// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_modbus_modbus_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_modbus_modbus_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


#include "zeek/analyzer/protocol/modbus/events.bif.h"

namespace binpac {

namespace ModbusTCP {
class ContextModbusTCP;
class ModbusTCP_Conn;
// NOLINTNEXTLINE(performance-enum-size)
enum function_codes {
    READ_COILS = 1,
    READ_DISCRETE_INPUTS = 2,
    READ_HOLDING_REGISTERS = 3,
    READ_INPUT_REGISTERS = 4,
    WRITE_SINGLE_COIL = 5,
    WRITE_SINGLE_REGISTER = 6,
    DIAGNOSTICS = 8,
    WRITE_MULTIPLE_COILS = 15,
    WRITE_MULTIPLE_REGISTERS = 16,
    READ_FILE_RECORD = 20,
    WRITE_FILE_RECORD = 21,
    MASK_WRITE_REGISTER = 22,
    READ_WRITE_MULTIPLE_REGISTERS = 23,
    READ_FIFO_QUEUE = 24,
    ENCAP_INTERFACE_TRANSPORT = 43,
    OBJECT_MESSAGING = 91,
    PROGRAM_484 = 9,
    POLL_484 = 10,
    PROGRAM_584_984 = 13,
    POLL_584_984 = 14,
    PROGRAM_884_U84 = 18,
    RESET_COMM_LINK_884_U84 = 19,
    PROGRAM_CONCEPT = 40,
    MULTIPLE_FUNCTION_CODES = 41,
    PROGRAM_UNITY = 90,
    FIRMWARE_REPLACEMENT = 125,
    PROGRAM_584_984_2 = 126,
    REPORT_LOCAL_ADDRESS = 127,
};
// NOLINTNEXTLINE(performance-enum-size)
enum diagnostic_subfunctions {
    DIAGNOSTICS_RETURN_QUERY_DATA = 0,
    DIAGNOSTICS_RESTART_COMMUNICATIONS_OPTION = 1,
    DIAGNOSTICS_RETURN_DIAGNOSTIC_REGISTER = 2,
    DIAGNOSTICS_CHANGE_ASCII_INPUT_DELIMITER = 3,
    DIAGNOSTICS_FORCE_LISTEN_ONLY_MODE = 4,
    DIAGNOSTICS_CLEAR_COUNTERS_AND_DIAGNOSTIC_REGISTER = 10,
    DIAGNOSTICS_RETURN_BUS_MESSAGE_COUNT = 11,
    DIAGNOSTICS_RETURN_BUS_COMMUNICATION_ERROR_COUNT = 12,
    DIAGNOSTICS_RETURN_BUS_EXCEPTION_ERROR_COUNT = 13,
    DIAGNOSTICS_RETURN_SERVER_MESSAGE_COUNT = 14,
    DIAGNOSTICS_RETURN_SERVER_NO_RESPONSE_COUNT = 15,
    DIAGNOSTICS_RETURN_SERVER_NAK_COUNT = 16,
    DIAGNOSTICS_RETURN_SERVER_BUSY_COUNT = 17,
    DIAGNOSTICS_RETURN_BUS_CHARACTER_OVERRUN_COUNT = 18,
    DIAGNOSTICS_CLEAR_OVERRUN_COUNTER_AND_FLAG = 20,
};
class ModbusTCP_PDU;
class ModbusTCP_TransportHeader;
class ModbusTCP_Request;
class ModbusTCP_Response;
class ModbusTCP_NormalResponse;
class ModbusTCP_ExceptResponse;
class ReadCoilsRequest;
class ReadCoilsResponse;
class ReadDiscreteInputsRequest;
class ReadDiscreteInputsResponse;
class ReadHoldingRegistersRequest;
class ReadHoldingRegistersResponse;
class ReadInputRegistersRequest;
class ReadInputRegistersResponse;
class WriteSingleCoilRequest;
class WriteSingleCoilResponse;
class WriteSingleRegisterRequest;
class WriteSingleRegisterResponse;
class DiagnosticsRequest;
class DiagnosticsResponse;
class WriteMultipleCoilsRequest;
class WriteMultipleCoilsResponse;
class WriteMultipleRegistersRequest;
class WriteMultipleRegistersResponse;
class FileRecordRequest;
class ReadFileRecordRequest;
class FileRecordResponse;
class ReadFileRecordResponse;
class ReferenceWithData;
class WriteFileRecordRequest;
class WriteFileRecordResponse;
class MaskWriteRegisterRequest;
class MaskWriteRegisterResponse;
class ReadWriteMultipleRegistersRequest;
class ReadWriteMultipleRegistersResponse;
class ReadFIFOQueueRequest;
class ReadFIFOQueueResponse;
class EncapInterfaceTransportRequest;
class EncapInterfaceTransportResponse;
class ModbusTCP_Flow;
} // namespace ModbusTCP

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace ModbusTCP {

class ContextModbusTCP final {
public:
    ContextModbusTCP(ModbusTCP_Conn* connection, ModbusTCP_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextModbusTCP();

    // Member access functions
    ModbusTCP_Conn* connection() const { return connection_; }
    ModbusTCP_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    ModbusTCP_Conn* connection_;
    ModbusTCP_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class ModbusTCP_Conn final : public binpac::ConnectionAnalyzer {
public:
    ModbusTCP_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~ModbusTCP_Conn() override;

    // Member access functions
    ModbusTCP_Flow* upflow() const { return upflow_; }
    ModbusTCP_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    bool SetPDU(bool is_orig);
    bool SetConfirmed();
    bool IsConfirmed();

protected:

    // Additional members

		// Fields used to determine if the protocol has been confirmed or not.
		bool confirmed;
		bool orig_pdu;
		bool resp_pdu;
		
    ModbusTCP_Flow* upflow_;
    ModbusTCP_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class ModbusTCP_PDU final {
public:
    ModbusTCP_PDU(bool is_orig);
    ~ModbusTCP_PDU();
    int initial_buffer_length() const { return 8; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextModbusTCP* t_context);

    // Member access functions
    ModbusTCP_TransportHeader* header() const { return header_; }
    int body_case_index() const	{ return body_case_index_; }
    ModbusTCP_Request* request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( body_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:69:request", (int64)body_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return request_;
    }
    ModbusTCP_Response* response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( body_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:70:response", (int64)body_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return response_;
    }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    ModbusTCP_TransportHeader* header_;
    int body_case_index_;
    ModbusTCP_Request* request_;
    ModbusTCP_Response* response_;
    bool is_orig_;
    int byteorder_;
    bool deliver_;
    int buffering_state_;
};


class ModbusTCP_TransportHeader final {
public:
    ModbusTCP_TransportHeader();
    ~ModbusTCP_TransportHeader();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 tid() const { return tid_; }
    uint16 pid() const { return pid_; }
    uint16 len() const { return len_; }
    uint8 uid() const { return uid_; }
    uint8 fc() const { return fc_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 tid_;
    uint16 pid_;
    uint16 len_;
    uint8 uid_;
    uint8 fc_;
    int byteorder_;
    bool deliver_;
};


class ModbusTCP_Request final {
public:
    ModbusTCP_Request(ModbusTCP_TransportHeader* header);
    ~ModbusTCP_Request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    ReadCoilsRequest* readCoils() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:87:readCoils", (int64)val_case_index(), "READ_COILS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readCoils_;
    }
    ReadDiscreteInputsRequest* readDiscreteInputs() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:88:readDiscreteInputs", (int64)val_case_index(), "READ_DISCRETE_INPUTS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readDiscreteInputs_;
    }
    ReadHoldingRegistersRequest* readHoldingRegisters() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:89:readHoldingRegisters", (int64)val_case_index(), "READ_HOLDING_REGISTERS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readHoldingRegisters_;
    }
    ReadInputRegistersRequest* readInputRegisters() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:90:readInputRegisters", (int64)val_case_index(), "READ_INPUT_REGISTERS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readInputRegisters_;
    }
    WriteSingleCoilRequest* writeSingleCoil() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:91:writeSingleCoil", (int64)val_case_index(), "WRITE_SINGLE_COIL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return writeSingleCoil_;
    }
    WriteSingleRegisterRequest* writeSingleRegister() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:92:writeSingleRegister", (int64)val_case_index(), "WRITE_SINGLE_REGISTER");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return writeSingleRegister_;
    }
    DiagnosticsRequest* diagnostics() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:94:diagnostics", (int64)val_case_index(), "DIAGNOSTICS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return diagnostics_;
    }
    WriteMultipleCoilsRequest* writeMultipleCoils() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:97:writeMultipleCoils", (int64)val_case_index(), "WRITE_MULTIPLE_COILS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return writeMultipleCoils_;
    }
    WriteMultipleRegistersRequest* writeMultRegisters() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:98:writeMultRegisters", (int64)val_case_index(), "WRITE_MULTIPLE_REGISTERS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return writeMultRegisters_;
    }
    ReadFileRecordRequest* readFileRecord() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)20):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:100:readFileRecord", (int64)val_case_index(), "READ_FILE_RECORD");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readFileRecord_;
    }
    WriteFileRecordRequest* writeFileRecord() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)21):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:101:writeFileRecord", (int64)val_case_index(), "WRITE_FILE_RECORD");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return writeFileRecord_;
    }
    MaskWriteRegisterRequest* maskWriteRegister() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)22):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:102:maskWriteRegister", (int64)val_case_index(), "MASK_WRITE_REGISTER");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return maskWriteRegister_;
    }
    ReadWriteMultipleRegistersRequest* readWriteMultipleRegisters() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)23):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:103:readWriteMultipleRegisters", (int64)val_case_index(), "READ_WRITE_MULTIPLE_REGISTERS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readWriteMultipleRegisters_;
    }
    ReadFIFOQueueRequest* readFIFOQueue() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)24):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:104:readFIFOQueue", (int64)val_case_index(), "READ_FIFO_QUEUE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readFIFOQueue_;
    }
    EncapInterfaceTransportRequest* encapInterfaceException() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)43):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:105:encapInterfaceException", (int64)val_case_index(), "ENCAP_INTERFACE_TRANSPORT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return encapInterfaceException_;
    }
    bytestring const& unknown() const {
        return unknown_;
    }
    ModbusTCP_TransportHeader* header() const { return header_; }

protected:
    uint8 val_case_index_;
    ReadCoilsRequest* readCoils_;
    ReadDiscreteInputsRequest* readDiscreteInputs_;
    ReadHoldingRegistersRequest* readHoldingRegisters_;
    ReadInputRegistersRequest* readInputRegisters_;
    WriteSingleCoilRequest* writeSingleCoil_;
    WriteSingleRegisterRequest* writeSingleRegister_;
    DiagnosticsRequest* diagnostics_;
    WriteMultipleCoilsRequest* writeMultipleCoils_;
    WriteMultipleRegistersRequest* writeMultRegisters_;
    ReadFileRecordRequest* readFileRecord_;
    WriteFileRecordRequest* writeFileRecord_;
    MaskWriteRegisterRequest* maskWriteRegister_;
    ReadWriteMultipleRegistersRequest* readWriteMultipleRegisters_;
    ReadFIFOQueueRequest* readFIFOQueue_;
    EncapInterfaceTransportRequest* encapInterfaceException_;
    bytestring unknown_;
    ModbusTCP_TransportHeader* header_;
};


class ModbusTCP_Response final {
public:
    ModbusTCP_Response(ModbusTCP_TransportHeader* header);
    ~ModbusTCP_Response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    ModbusTCP_NormalResponse* normal_response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:114:normal_response", (int64)val_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return normal_response_;
    }
    ModbusTCP_ExceptResponse* exception_response() const {
        return exception_response_;
    }
    ModbusTCP_TransportHeader* header() const { return header_; }

protected:
    int val_case_index_;
    ModbusTCP_NormalResponse* normal_response_;
    ModbusTCP_ExceptResponse* exception_response_;
    ModbusTCP_TransportHeader* header_;
};


class ModbusTCP_NormalResponse final {
public:
    ModbusTCP_NormalResponse(ModbusTCP_TransportHeader* header);
    ~ModbusTCP_NormalResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    ReadCoilsResponse* readCoils() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:119:readCoils", (int64)val_case_index(), "READ_COILS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readCoils_;
    }
    ReadDiscreteInputsResponse* readDiscreteInputs() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:120:readDiscreteInputs", (int64)val_case_index(), "READ_DISCRETE_INPUTS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readDiscreteInputs_;
    }
    ReadHoldingRegistersResponse* readHoldingRegisters() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:121:readHoldingRegisters", (int64)val_case_index(), "READ_HOLDING_REGISTERS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readHoldingRegisters_;
    }
    ReadInputRegistersResponse* readInputRegisters() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:122:readInputRegisters", (int64)val_case_index(), "READ_INPUT_REGISTERS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readInputRegisters_;
    }
    WriteSingleCoilResponse* writeSingleCoil() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:123:writeSingleCoil", (int64)val_case_index(), "WRITE_SINGLE_COIL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return writeSingleCoil_;
    }
    WriteSingleRegisterResponse* writeSingleRegister() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:124:writeSingleRegister", (int64)val_case_index(), "WRITE_SINGLE_REGISTER");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return writeSingleRegister_;
    }
    DiagnosticsResponse* diagnostics() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:126:diagnostics", (int64)val_case_index(), "DIAGNOSTICS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return diagnostics_;
    }
    WriteMultipleCoilsResponse* writeMultipleCoils() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:129:writeMultipleCoils", (int64)val_case_index(), "WRITE_MULTIPLE_COILS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return writeMultipleCoils_;
    }
    WriteMultipleRegistersResponse* writeMultRegisters() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:130:writeMultRegisters", (int64)val_case_index(), "WRITE_MULTIPLE_REGISTERS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return writeMultRegisters_;
    }
    ReadFileRecordResponse* readFileRecord() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)20):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:132:readFileRecord", (int64)val_case_index(), "READ_FILE_RECORD");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readFileRecord_;
    }
    WriteFileRecordResponse* writeFileRecord() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)21):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:133:writeFileRecord", (int64)val_case_index(), "WRITE_FILE_RECORD");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return writeFileRecord_;
    }
    MaskWriteRegisterResponse* maskWriteRegister() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)22):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:134:maskWriteRegister", (int64)val_case_index(), "MASK_WRITE_REGISTER");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return maskWriteRegister_;
    }
    ReadWriteMultipleRegistersResponse* readWriteMultipleRegisters() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)23):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:135:readWriteMultipleRegisters", (int64)val_case_index(), "READ_WRITE_MULTIPLE_REGISTERS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readWriteMultipleRegisters_;
    }
    ReadFIFOQueueResponse* readFIFOQueue() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)24):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:136:readFIFOQueue", (int64)val_case_index(), "READ_FIFO_QUEUE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return readFIFOQueue_;
    }
    EncapInterfaceTransportResponse* encapInterfaceTransport() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)43):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/modbus/modbus-protocol.pac:137:encapInterfaceTransport", (int64)val_case_index(), "ENCAP_INTERFACE_TRANSPORT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return encapInterfaceTransport_;
    }
    bytestring const& unknown() const {
        return unknown_;
    }
    ModbusTCP_TransportHeader* header() const { return header_; }

protected:
    uint8 val_case_index_;
    ReadCoilsResponse* readCoils_;
    ReadDiscreteInputsResponse* readDiscreteInputs_;
    ReadHoldingRegistersResponse* readHoldingRegisters_;
    ReadInputRegistersResponse* readInputRegisters_;
    WriteSingleCoilResponse* writeSingleCoil_;
    WriteSingleRegisterResponse* writeSingleRegister_;
    DiagnosticsResponse* diagnostics_;
    WriteMultipleCoilsResponse* writeMultipleCoils_;
    WriteMultipleRegistersResponse* writeMultRegisters_;
    ReadFileRecordResponse* readFileRecord_;
    WriteFileRecordResponse* writeFileRecord_;
    MaskWriteRegisterResponse* maskWriteRegister_;
    ReadWriteMultipleRegistersResponse* readWriteMultipleRegisters_;
    ReadFIFOQueueResponse* readFIFOQueue_;
    EncapInterfaceTransportResponse* encapInterfaceTransport_;
    bytestring unknown_;
    ModbusTCP_TransportHeader* header_;
};


class ModbusTCP_ExceptResponse final {
public:
    ModbusTCP_ExceptResponse(ModbusTCP_TransportHeader* header);
    ~ModbusTCP_ExceptResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 code() const { return code_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 code_;
    ModbusTCP_TransportHeader* header_;
    bool deliver_;
};


class ReadCoilsRequest final {
public:
    ReadCoilsRequest(ModbusTCP_TransportHeader* header);
    ~ReadCoilsRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 start_address() const { return start_address_; }
    uint16 quantity() const { return quantity_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 start_address_;
    uint16 quantity_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReadCoilsResponse final {
public:
    ReadCoilsResponse(ModbusTCP_TransportHeader* header);
    ~ReadCoilsResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 byte_count() const { return byte_count_; }
    bytestring const& bits() const { return bits_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 byte_count_;
    bytestring bits_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReadDiscreteInputsRequest final {
public:
    ReadDiscreteInputsRequest(ModbusTCP_TransportHeader* header);
    ~ReadDiscreteInputsRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 start_address() const { return start_address_; }
    uint16 quantity() const { return quantity_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 start_address_;
    uint16 quantity_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReadDiscreteInputsResponse final {
public:
    ReadDiscreteInputsResponse(ModbusTCP_TransportHeader* header);
    ~ReadDiscreteInputsResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 byte_count() const { return byte_count_; }
    bytestring const& bits() const { return bits_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 byte_count_;
    bytestring bits_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReadHoldingRegistersRequest final {
public:
    ReadHoldingRegistersRequest(ModbusTCP_TransportHeader* header);
    ~ReadHoldingRegistersRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 start_address() const { return start_address_; }
    uint16 quantity() const { return quantity_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 start_address_;
    uint16 quantity_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReadHoldingRegistersResponse final {
public:
    ReadHoldingRegistersResponse(ModbusTCP_TransportHeader* header);
    ~ReadHoldingRegistersResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 byte_count() const { return byte_count_; }
    vector<uint16>* registers() const { return registers_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 byte_count_;
    vector<uint16>* registers_;
    uint16 registers__elem_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReadInputRegistersRequest final {
public:
    ReadInputRegistersRequest(ModbusTCP_TransportHeader* header);
    ~ReadInputRegistersRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 start_address() const { return start_address_; }
    uint16 quantity() const { return quantity_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 start_address_;
    uint16 quantity_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReadInputRegistersResponse final {
public:
    ReadInputRegistersResponse(ModbusTCP_TransportHeader* header);
    ~ReadInputRegistersResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 byte_count() const { return byte_count_; }
    vector<uint16>* registers() const { return registers_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 byte_count_;
    vector<uint16>* registers_;
    uint16 registers__elem_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class WriteSingleCoilRequest final {
public:
    WriteSingleCoilRequest(ModbusTCP_TransportHeader* header);
    ~WriteSingleCoilRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 address() const { return address_; }
    uint16 value() const { return value_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 address_;
    uint16 value_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class WriteSingleCoilResponse final {
public:
    WriteSingleCoilResponse(ModbusTCP_TransportHeader* header);
    ~WriteSingleCoilResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 address() const { return address_; }
    uint16 value() const { return value_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 address_;
    uint16 value_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class WriteSingleRegisterRequest final {
public:
    WriteSingleRegisterRequest(ModbusTCP_TransportHeader* header);
    ~WriteSingleRegisterRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 address() const { return address_; }
    uint16 value() const { return value_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 address_;
    uint16 value_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class WriteSingleRegisterResponse final {
public:
    WriteSingleRegisterResponse(ModbusTCP_TransportHeader* header);
    ~WriteSingleRegisterResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 address() const { return address_; }
    uint16 value() const { return value_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 address_;
    uint16 value_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class DiagnosticsRequest final {
public:
    DiagnosticsRequest(ModbusTCP_TransportHeader* header);
    ~DiagnosticsRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 subfunction() const { return subfunction_; }
    bytestring const& data() const { return data_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 subfunction_;
    bytestring data_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class DiagnosticsResponse final {
public:
    DiagnosticsResponse(ModbusTCP_TransportHeader* header);
    ~DiagnosticsResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 subfunction() const { return subfunction_; }
    bytestring const& data() const { return data_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 subfunction_;
    bytestring data_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class WriteMultipleCoilsRequest final {
public:
    WriteMultipleCoilsRequest(ModbusTCP_TransportHeader* header);
    ~WriteMultipleCoilsRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 start_address() const { return start_address_; }
    uint16 quantity() const { return quantity_; }
    uint8 byte_count() const { return byte_count_; }
    bytestring const& coils() const { return coils_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 start_address_;
    uint16 quantity_;
    uint8 byte_count_;
    bytestring coils_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class WriteMultipleCoilsResponse final {
public:
    WriteMultipleCoilsResponse(ModbusTCP_TransportHeader* header);
    ~WriteMultipleCoilsResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 start_address() const { return start_address_; }
    uint16 quantity() const { return quantity_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 start_address_;
    uint16 quantity_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class WriteMultipleRegistersRequest final {
public:
    WriteMultipleRegistersRequest(ModbusTCP_TransportHeader* header);
    ~WriteMultipleRegistersRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 start_address() const { return start_address_; }
    uint16 quantity() const { return quantity_; }
    uint8 byte_count() const { return byte_count_; }
    vector<uint16>* registers() const { return registers_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 start_address_;
    uint16 quantity_;
    uint8 byte_count_;
    vector<uint16>* registers_;
    uint16 registers__elem_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class WriteMultipleRegistersResponse final {
public:
    WriteMultipleRegistersResponse(ModbusTCP_TransportHeader* header);
    ~WriteMultipleRegistersResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 start_address() const { return start_address_; }
    uint16 quantity() const { return quantity_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 start_address_;
    uint16 quantity_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class FileRecordRequest final {
public:
    FileRecordRequest();
    ~FileRecordRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 ref_type() const { return ref_type_; }
    uint16 file_num() const { return file_num_; }
    uint16 record_num() const { return record_num_; }
    uint16 record_len() const { return record_len_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 ref_type_;
    uint16 file_num_;
    uint16 record_num_;
    uint16 record_len_;
    int byteorder_;
};


class ReadFileRecordRequest final {
public:
    ReadFileRecordRequest(ModbusTCP_TransportHeader* header);
    ~ReadFileRecordRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 byte_count() const { return byte_count_; }
    vector<FileRecordRequest*>* references() const { return references_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 byte_count_;
    vector<FileRecordRequest*>* references_;
    FileRecordRequest* references__elem_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class FileRecordResponse final {
public:
    FileRecordResponse();
    ~FileRecordResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 file_len() const { return file_len_; }
    uint8 ref_type() const { return ref_type_; }
    bytestring const& record_data() const { return record_data_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 file_len_;
    uint8 ref_type_;
    bytestring record_data_;
    int byteorder_;
};


class ReadFileRecordResponse final {
public:
    ReadFileRecordResponse(ModbusTCP_TransportHeader* header);
    ~ReadFileRecordResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 byte_count() const { return byte_count_; }
    vector<FileRecordResponse*>* references() const { return references_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 byte_count_;
    vector<FileRecordResponse*>* references_;
    FileRecordResponse* references__elem_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReferenceWithData final {
public:
    ReferenceWithData();
    ~ReferenceWithData();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 ref_type() const { return ref_type_; }
    uint16 file_num() const { return file_num_; }
    uint16 record_num() const { return record_num_; }
    uint16 record_length() const { return record_length_; }
    bytestring const& record_data() const { return record_data_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 ref_type_;
    uint16 file_num_;
    uint16 record_num_;
    uint16 record_length_;
    bytestring record_data_;
    int byteorder_;
};


class WriteFileRecordRequest final {
public:
    WriteFileRecordRequest(ModbusTCP_TransportHeader* header);
    ~WriteFileRecordRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 byte_count() const { return byte_count_; }
    vector<ReferenceWithData*>* references() const { return references_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 byte_count_;
    vector<ReferenceWithData*>* references_;
    ReferenceWithData* references__elem_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class WriteFileRecordResponse final {
public:
    WriteFileRecordResponse(ModbusTCP_TransportHeader* header);
    ~WriteFileRecordResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 byte_count() const { return byte_count_; }
    vector<ReferenceWithData*>* references() const { return references_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 byte_count_;
    vector<ReferenceWithData*>* references_;
    ReferenceWithData* references__elem_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class MaskWriteRegisterRequest final {
public:
    MaskWriteRegisterRequest(ModbusTCP_TransportHeader* header);
    ~MaskWriteRegisterRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 address() const { return address_; }
    uint16 and_mask() const { return and_mask_; }
    uint16 or_mask() const { return or_mask_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 address_;
    uint16 and_mask_;
    uint16 or_mask_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class MaskWriteRegisterResponse final {
public:
    MaskWriteRegisterResponse(ModbusTCP_TransportHeader* header);
    ~MaskWriteRegisterResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 address() const { return address_; }
    uint16 and_mask() const { return and_mask_; }
    uint16 or_mask() const { return or_mask_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 address_;
    uint16 and_mask_;
    uint16 or_mask_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReadWriteMultipleRegistersRequest final {
public:
    ReadWriteMultipleRegistersRequest(ModbusTCP_TransportHeader* header);
    ~ReadWriteMultipleRegistersRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 read_start_address() const { return read_start_address_; }
    uint16 read_quantity() const { return read_quantity_; }
    uint16 write_start_address() const { return write_start_address_; }
    uint16 write_quantity() const { return write_quantity_; }
    uint8 write_byte_count() const { return write_byte_count_; }
    vector<uint16>* write_register_values() const { return write_register_values_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 read_start_address_;
    uint16 read_quantity_;
    uint16 write_start_address_;
    uint16 write_quantity_;
    uint8 write_byte_count_;
    vector<uint16>* write_register_values_;
    uint16 write_register_values__elem_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReadWriteMultipleRegistersResponse final {
public:
    ReadWriteMultipleRegistersResponse(ModbusTCP_TransportHeader* header);
    ~ReadWriteMultipleRegistersResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 byte_count() const { return byte_count_; }
    vector<uint16>* registers() const { return registers_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 byte_count_;
    vector<uint16>* registers_;
    uint16 registers__elem_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReadFIFOQueueRequest final {
public:
    ReadFIFOQueueRequest(ModbusTCP_TransportHeader* header);
    ~ReadFIFOQueueRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 start_address() const { return start_address_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 start_address_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ReadFIFOQueueResponse final {
public:
    ReadFIFOQueueResponse(ModbusTCP_TransportHeader* header);
    ~ReadFIFOQueueResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint16 byte_count() const { return byte_count_; }
    uint16 fifo_count() const { return fifo_count_; }
    vector<uint16>* register_data() const { return register_data_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 byte_count_;
    uint16 fifo_count_;
    vector<uint16>* register_data_;
    uint16 register_data__elem_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class EncapInterfaceTransportRequest final {
public:
    EncapInterfaceTransportRequest(ModbusTCP_TransportHeader* header);
    ~EncapInterfaceTransportRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 mei_type() const { return mei_type_; }
    bytestring const& data() const { return data_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 mei_type_;
    bytestring data_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class EncapInterfaceTransportResponse final {
public:
    EncapInterfaceTransportResponse(ModbusTCP_TransportHeader* header);
    ~EncapInterfaceTransportResponse();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextModbusTCP* t_context);

    // Member access functions
    uint8 mei_type() const { return mei_type_; }
    bytestring const& data() const { return data_; }
    ModbusTCP_TransportHeader* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 mei_type_;
    bytestring data_;
    ModbusTCP_TransportHeader* header_;
    int byteorder_;
    bool deliver_;
};


class ModbusTCP_Flow final : public binpac::FlowAnalyzer {
public:
    ModbusTCP_Flow(ModbusTCP_Conn* connection, bool is_orig);
    ~ModbusTCP_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    ModbusTCP_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    bool deliver_message(ModbusTCP_TransportHeader* header);
    bool deliver_ModbusTCP_PDU(ModbusTCP_PDU* message);
    bool deliver_Exception(ModbusTCP_TransportHeader* header, ModbusTCP_ExceptResponse* message);
    bool deliver_ReadCoilsRequest(ModbusTCP_TransportHeader* header, ReadCoilsRequest* message);
    bool deliver_ReadCoilsResponse(ModbusTCP_TransportHeader* header, ReadCoilsResponse* message);
    bool deliver_ReadDiscreteInputsRequest(ModbusTCP_TransportHeader* header, ReadDiscreteInputsRequest* message);
    bool deliver_ReadDiscreteInputsResponse(ModbusTCP_TransportHeader* header, ReadDiscreteInputsResponse* message);
    bool deliver_ReadHoldingRegistersRequest(ModbusTCP_TransportHeader* header, ReadHoldingRegistersRequest* message);
    bool deliver_ReadHoldingRegistersResponse(ModbusTCP_TransportHeader* header, ReadHoldingRegistersResponse* message);
    bool deliver_ReadInputRegistersRequest(ModbusTCP_TransportHeader* header, ReadInputRegistersRequest* message);
    bool deliver_ReadInputRegistersResponse(ModbusTCP_TransportHeader* header, ReadInputRegistersResponse* message);
    bool deliver_WriteSingleCoilRequest(ModbusTCP_TransportHeader* header, WriteSingleCoilRequest* message);
    bool deliver_WriteSingleCoilResponse(ModbusTCP_TransportHeader* header, WriteSingleCoilResponse* message);
    bool deliver_WriteSingleRegisterRequest(ModbusTCP_TransportHeader* header, WriteSingleRegisterRequest* message);
    bool deliver_WriteSingleRegisterResponse(ModbusTCP_TransportHeader* header, WriteSingleRegisterResponse* message);
    bool deliver_DiagnosticsRequest(ModbusTCP_TransportHeader* header, DiagnosticsRequest* message);
    bool deliver_DiagnosticsResponse(ModbusTCP_TransportHeader* header, DiagnosticsResponse* message);
    bool deliver_WriteMultipleCoilsRequest(ModbusTCP_TransportHeader* header, WriteMultipleCoilsRequest* message);
    bool deliver_WriteMultipleCoilsResponse(ModbusTCP_TransportHeader* header, WriteMultipleCoilsResponse* message);
    bool deliver_WriteMultipleRegistersRequest(ModbusTCP_TransportHeader* header, WriteMultipleRegistersRequest* message);
    bool deliver_WriteMultipleRegistersResponse(ModbusTCP_TransportHeader* header, WriteMultipleRegistersResponse* message);
    bool deliver_ReadFileRecordRequest(ModbusTCP_TransportHeader* header, ReadFileRecordRequest* message);
    bool deliver_ReadFileRecordResponse(ModbusTCP_TransportHeader* header, ReadFileRecordResponse* message);
    bool deliver_WriteFileRecordRequest(ModbusTCP_TransportHeader* header, WriteFileRecordRequest* message);
    bool deliver_WriteFileRecordResponse(ModbusTCP_TransportHeader* header, WriteFileRecordResponse* message);
    bool deliver_MaskWriteRegisterRequest(ModbusTCP_TransportHeader* header, MaskWriteRegisterRequest* message);
    bool deliver_MaskWriteRegisterResponse(ModbusTCP_TransportHeader* header, MaskWriteRegisterResponse* message);
    bool deliver_ReadWriteMultipleRegistersRequest(ModbusTCP_TransportHeader* header, ReadWriteMultipleRegistersRequest* message);
    bool deliver_ReadWriteMultipleRegistersResponse(ModbusTCP_TransportHeader* header, ReadWriteMultipleRegistersResponse* message);
    bool deliver_ReadFIFOQueueRequest(ModbusTCP_TransportHeader* header, ReadFIFOQueueRequest* message);
    bool deliver_ReadFIFOQueueResponse(ModbusTCP_TransportHeader* header, ReadFIFOQueueResponse* message);
    bool deliver_EncapInterfaceTransportRequest(ModbusTCP_TransportHeader* header, EncapInterfaceTransportRequest* message);
    bool deliver_EncapInterfaceTransportResponse(ModbusTCP_TransportHeader* header, EncapInterfaceTransportResponse* message);

protected:
    ModbusTCP_PDU* dataunit_;
    ContextModbusTCP* context_;
    FlowBuffer* flow_buffer_;
    ModbusTCP_Conn* connection_;
    bool is_orig_;
};


	zeek::VectorValPtr bytestring_to_coils(const bytestring& coils, uint quantity);
	zeek::RecordValPtr HeaderToVal(ModbusTCP_TransportHeader* header);
	zeek::VectorValPtr create_vector_of_count();
	
} // namespace ModbusTCP
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_modbus_modbus_pac_h */
