// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_rdp_rdp_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_rdp_rdp_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


	#include "zeek/analyzer/protocol/rdp/events.bif.h"


#include <cstdlib>
#include <cinttypes>


#include "zeek/Desc.h"
#include "zeek/file_analysis/Manager.h"

#include "zeek/analyzer/protocol/rdp/types.bif.h"

namespace binpac {

namespace RDP {
class ContextRDP;
class RDP_Conn;
// NOLINTNEXTLINE(performance-enum-size)
enum ASN1TypeTag {
    ASN1_INTEGER_TAG = 2,
    ASN1_OCTET_STRING_TAG = 4,
    ASN1_NULL_TAG = 5,
    ASN1_OBJECT_IDENTIFIER_TAG = 6,
    ASN1_SEQUENCE_TAG = 48,
    ASN1_APP_TAG_OFFSET = 96,
    ASN1_INDEX_TAG_OFFSET = 160,
};
// NOLINTNEXTLINE(performance-enum-size)
enum ASN1TagClass {
    ASN1_TAG_UNIVERSAL = 0,
    ASN1_TAG_APPLICATION = 1,
    ASN1_TAG_CONTEXT = 2,
    ASN1_TAG_PRIVATE = 3,
};
class ASN1Encoding;
class ASN1EncodingMeta;
class ASN1OptionalEncodingMeta;
class ASN1SequenceMeta;
class ASN1Integer;
class ASN1OctetString;
class ASN1ObjectIdentifier;
class ASN1Boolean;
class ASN1Enumerated;
class SequenceElement;
class Array;
class TPKT;
class COTP;
class DT_Data;
class Data_Header;
class Data_Block;
extern RegExMatcher RDP_Connect_Request_cookie_re_001;

extern RegExMatcher RDP_Connect_Request_cookie_re_002;

class RDP_Connect_Request_cookie;
extern RegExMatcher Connect_Request_re_003;

class Connect_Request;
class RDP_Negotiation_Request;
class Connect_Confirm;
class Connect_Confirm_Record;
class RDP_Negotiation_Response;
class RDP_Negotiation_Failure;
class Client_Header;
class GCC_Client_Connection_Data;
extern RegExMatcher GCC_Client_Create_Request_re_004;

class GCC_Client_Create_Request;
class Client_Core_Data;
class Client_Security_Data;
class Client_Network_Data;
class Client_Cluster_Data;
class Client_Channel_Def;
class Server_Header;
class GCC_Server_Connection_Data;
extern RegExMatcher GCC_Server_Create_Response_re_005;

class GCC_Server_Create_Response;
class Server_Core_Data;
class Server_Network_Data;
class Server_Security_Data;
class Server_Certificate;
class Server_Proprietary_Cert;
class Public_Key_Blob;
class X509;
class X509_Cert_Data;
class RDP_Flow;
} // namespace RDP

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace RDP {

class ContextRDP final {
public:
    ContextRDP(RDP_Conn* connection, RDP_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextRDP();

    // Member access functions
    RDP_Conn* connection() const { return connection_; }
    RDP_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    RDP_Conn* connection_;
    RDP_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class RDP_Conn final : public binpac::ConnectionAnalyzer {
public:
    RDP_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~RDP_Conn() override;

    // Member access functions
    RDP_Flow* upflow() const { return upflow_; }
    RDP_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    bool go_encrypted(uint32 method);
    bool is_encrypted();
    uint32 encryption_method();

protected:

    // Additional members

		bool is_encrypted_;
		uint32 encryption_method_;
	
    RDP_Flow* upflow_;
    RDP_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


	zeek::ValPtr asn1_integer_to_val(const ASN1Encoding* i, zeek::TypeTag t);
	zeek::ValPtr asn1_integer_to_val(const ASN1Integer* i, zeek::TypeTag t);
	zeek::StringValPtr asn1_oid_to_val(const ASN1Encoding* oid);
	zeek::StringValPtr asn1_oid_to_val(const ASN1ObjectIdentifier* oid);
	zeek::StringValPtr asn1_octet_string_to_val(const ASN1Encoding* s);
	zeek::StringValPtr asn1_octet_string_to_val(const ASN1OctetString* s);


class ASN1Encoding final {
public:
    ASN1Encoding();
    ~ASN1Encoding();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* meta() const { return meta_; }
    bytestring const& content() const { return content_; }

protected:
    ASN1EncodingMeta* meta_;
    bytestring content_;
};


class ASN1EncodingMeta final {
public:
    ASN1EncodingMeta();
    ~ASN1EncodingMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 tag() const { return tag_; }
    uint8 len() const { return len_; }
    bytestring const& more_len() const { return more_len_; }
    bool long_len() const { return long_len_; }
    uint64 length() const { return length_; }
    uint8 index() const { return index_; }
    uint8 tag_class() const { return tag_class_; }
    bool simple_type() const { return simple_type_; }
    uint8 tag_num() const { return tag_num_; }

protected:
    uint8 tag_;
    uint8 len_;
    bytestring more_len_;
    bool long_len_;
    uint64 length_;
    uint8 index_;
    uint8 tag_class_;
    bool simple_type_;
    uint8 tag_num_;
};


class ASN1OptionalEncodingMeta final {
public:
    ASN1OptionalEncodingMeta(bool is_present, ASN1EncodingMeta* previous_metadata);
    ~ASN1OptionalEncodingMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    ASN1EncodingMeta* data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/../asn1/asn1.pac:53:data", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_;
    }
    bool is_present() const { return is_present_; }
    ASN1EncodingMeta* previous_metadata() const { return previous_metadata_; }
    uint64 length() const { return length_; }

protected:
    int val_case_index_;
    ASN1EncodingMeta* data_;
    bool is_present_;
    ASN1EncodingMeta* previous_metadata_;
    uint64 length_;
};


class ASN1SequenceMeta final {
public:
    ASN1SequenceMeta();
    ~ASN1SequenceMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* encoding() const { return encoding_; }

protected:
    ASN1EncodingMeta* encoding_;
};


class ASN1Integer final {
public:
    ASN1Integer();
    ~ASN1Integer();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1OctetString final {
public:
    ASN1OctetString();
    ~ASN1OctetString();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1ObjectIdentifier final {
public:
    ASN1ObjectIdentifier();
    ~ASN1ObjectIdentifier();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1Boolean final {
public:
    ASN1Boolean();
    ~ASN1Boolean();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1Enumerated final {
public:
    ASN1Enumerated();
    ~ASN1Enumerated();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class SequenceElement final {
public:
    SequenceElement(bool grab_content);
    ~SequenceElement();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* index_meta() const { return index_meta_; }
    int have_content_case_index() const	{ return have_content_case_index_; }
    ASN1Encoding* data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_content_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/../asn1/asn1.pac:86:data", (int64)have_content_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_;
    }
    ASN1EncodingMeta* meta() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_content_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/../asn1/asn1.pac:87:meta", (int64)have_content_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return meta_;
    }
    bool grab_content() const { return grab_content_; }
    uint8 index() const { return index_; }
    uint64 length() const { return length_; }

protected:
    ASN1EncodingMeta* index_meta_;
    int have_content_case_index_;
    ASN1Encoding* data_;
    ASN1EncodingMeta* meta_;
    bool grab_content_;
    uint8 index_;
    uint64 length_;
};


class Array final {
public:
    Array();
    ~Array();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* array_meta() const { return array_meta_; }
    vector<ASN1Encoding*>* data() const { return data_; }

protected:
    ASN1EncodingMeta* array_meta_;
    vector<ASN1Encoding*>* data_;
    ASN1Encoding* data__elem_;
};

int64 binary_to_int64(bytestring const& bs);

class TPKT final {
public:
    TPKT(bool is_orig);
    ~TPKT();
    int initial_buffer_length() const { return 4; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRDP* t_context);

    // Member access functions
    uint8 version() const { return version_; }
    uint8 reserved() const { return reserved_; }
    uint16 tpkt_len() const { return tpkt_len_; }
    COTP* cotp() const { return cotp_; }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 version_;
    uint8 reserved_;
    uint16 tpkt_len_;
    COTP* cotp_;
    bool is_orig_;
    int byteorder_;
    int buffering_state_;
};


class COTP final {
public:
    COTP(TPKT* tpkt);
    ~COTP();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint8 cotp_len() const { return cotp_len_; }
    uint8 pdu() const { return pdu_; }
    uint8 switch_case_index() const	{ return switch_case_index_; }
    Connect_Confirm* connect_confirm() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( switch_case_index() ) {
            case ((uint8)208):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:19:connect_confirm", (int64)switch_case_index(), "((int) 0xd0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return connect_confirm_;
    }
    Connect_Request* client_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( switch_case_index() ) {
            case ((uint8)224):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:20:client_request", (int64)switch_case_index(), "((int) 0xe0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_request_;
    }
    DT_Data* data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( switch_case_index() ) {
            case ((uint8)240):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:21:data", (int64)switch_case_index(), "((int) 0xf0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_;
    }
    TPKT* tpkt() const { return tpkt_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 cotp_len_;
    uint8 pdu_;
    uint8 switch_case_index_;
    Connect_Confirm* connect_confirm_;
    Connect_Request* client_request_;
    DT_Data* data_;
    const_bytestring not_done_;
    TPKT* tpkt_;
    int byteorder_;
};


class DT_Data final {
public:
    DT_Data();
    ~DT_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint8 tpdu_number() const { return tpdu_number_; }
    uint8 application_defined_type() const { return application_defined_type_; }
    uint8 application_type() const { return application_type_; }
    uint8 data_case_index() const	{ return data_case_index_; }
    Client_Header* client() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)101):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:36:client", (int64)data_case_index(), "((int) 0x65)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_;
    }
    Server_Header* server() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)102):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:37:server", (int64)data_case_index(), "((int) 0x66)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_;
    }
    int byteorder() const { return byteorder_; }

protected:
    uint8 tpdu_number_;
    uint8 application_defined_type_;
    uint8 application_type_;
    uint8 data_case_index_;
    Client_Header* client_;
    Server_Header* server_;
    int byteorder_;
};


class Data_Header final {
public:
    Data_Header();
    ~Data_Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint16 type() const { return type_; }
    uint16 length() const { return length_; }
    int byteorder() const { return byteorder_; }

protected:
    uint16 type_;
    uint16 length_;
    int byteorder_;
};


class Data_Block final {
public:
    Data_Block();
    ~Data_Block();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    Data_Header* header() const { return header_; }
    uint16 block_case_index() const	{ return block_case_index_; }
    Client_Core_Data* client_core() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( block_case_index() ) {
            case ((uint16)49153):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:54:client_core", (int64)block_case_index(), "((int) 0xc001)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_core_;
    }
    Client_Security_Data* client_security() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( block_case_index() ) {
            case ((uint16)49154):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:55:client_security", (int64)block_case_index(), "((int) 0xc002)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_security_;
    }
    Client_Network_Data* client_network() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( block_case_index() ) {
            case ((uint16)49155):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:56:client_network", (int64)block_case_index(), "((int) 0xc003)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_network_;
    }
    Client_Cluster_Data* client_cluster() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( block_case_index() ) {
            case ((uint16)49156):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:57:client_cluster", (int64)block_case_index(), "((int) 0xc004)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_cluster_;
    }
    Server_Core_Data* server_core() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( block_case_index() ) {
            case ((uint16)3073):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:63:server_core", (int64)block_case_index(), "((int) 0x0c01)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_core_;
    }
    Server_Security_Data* server_security() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( block_case_index() ) {
            case ((uint16)3074):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:64:server_security", (int64)block_case_index(), "((int) 0x0c02)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_security_;
    }
    Server_Network_Data* server_network() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( block_case_index() ) {
            case ((uint16)3075):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:65:server_network", (int64)block_case_index(), "((int) 0x0c03)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_network_;
    }
    int byteorder() const { return byteorder_; }

protected:
    Data_Header* header_;
    uint16 block_case_index_;
    Client_Core_Data* client_core_;
    Client_Security_Data* client_security_;
    Client_Network_Data* client_network_;
    Client_Cluster_Data* client_cluster_;
    Server_Core_Data* server_core_;
    Server_Security_Data* server_security_;
    Server_Network_Data* server_network_;
    const_bytestring unhandled_;
    int byteorder_;
};


class RDP_Connect_Request_cookie final {
public:
    RDP_Connect_Request_cookie();
    ~RDP_Connect_Request_cookie();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& cookie_value() const { return cookie_value_; }
    bytestring const& cookie_terminator() const { return cookie_terminator_; }
    int byteorder() const { return byteorder_; }

protected:
    bytestring cookie_value_;
    bytestring cookie_terminator_;
    int byteorder_;
};


class Connect_Request final {
public:
    Connect_Request(COTP* cotp);
    ~Connect_Request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint16 destination_reference() const { return destination_reference_; }
    uint16 source_reference() const { return source_reference_; }
    uint8 flow_control() const { return flow_control_; }
    bytestring const& cookie_mstshash() const { return cookie_mstshash_; }
    int switch1_case_index() const	{ return switch1_case_index_; }
    RDP_Connect_Request_cookie* cookie() const {
        return cookie_;
    }
    int switch2_case_index() const	{ return switch2_case_index_; }
    RDP_Negotiation_Request* rdp_neg_req() const {
        return rdp_neg_req_;
    }
    COTP* cotp() const { return cotp_; }
    int byteorder() const { return byteorder_; }
    bool proc() const { return proc_; }

protected:
    uint16 destination_reference_;
    uint16 source_reference_;
    uint8 flow_control_;
    bytestring cookie_mstshash_;
    int switch1_case_index_;
    RDP_Connect_Request_cookie* cookie_;
    int switch2_case_index_;
    RDP_Negotiation_Request* rdp_neg_req_;
    COTP* cotp_;
    int byteorder_;
    bool proc_;
};


class RDP_Negotiation_Request final {
public:
    RDP_Negotiation_Request();
    ~RDP_Negotiation_Request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 type() const { return type_; }
    uint8 flags() const { return flags_; }
    uint16 length() const { return length_; }
    uint32 requested_protocols() const { return requested_protocols_; }
    int byteorder() const { return byteorder_; }
    bool PROTOCOL_RDP() const { return PROTOCOL_RDP_; }
    bool PROTOCOL_SSL() const { return PROTOCOL_SSL_; }
    bool PROTOCOL_HYBRID() const { return PROTOCOL_HYBRID_; }
    bool PROTOCOL_HYBRID_EX() const { return PROTOCOL_HYBRID_EX_; }

protected:
    uint8 type_;
    uint8 flags_;
    uint16 length_;
    uint32 requested_protocols_;
    int byteorder_;
    bool PROTOCOL_RDP_;
    bool PROTOCOL_SSL_;
    bool PROTOCOL_HYBRID_;
    bool PROTOCOL_HYBRID_EX_;
};


class Connect_Confirm final {
public:
    Connect_Confirm(COTP* cotp);
    ~Connect_Confirm();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context, int t_byteorder);

    // Member access functions
    uint16 destination_reference() const { return destination_reference_; }
    uint16 source_reference() const { return source_reference_; }
    uint8 flags() const { return flags_; }
    int switch1_case_index() const	{ return switch1_case_index_; }
    Connect_Confirm_Record* response() const {
        return response_;
    }
    COTP* cotp() const { return cotp_; }

protected:
    uint16 destination_reference_;
    uint16 source_reference_;
    uint8 flags_;
    int switch1_case_index_;
    Connect_Confirm_Record* response_;
    COTP* cotp_;
};


class Connect_Confirm_Record final {
public:
    Connect_Confirm_Record();
    ~Connect_Confirm_Record();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint8 response_type() const { return response_type_; }
    uint8 switch1_case_index() const	{ return switch1_case_index_; }
    RDP_Negotiation_Response* neg_resp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( switch1_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:132:neg_resp", (int64)switch1_case_index(), "((int) 0x02)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return neg_resp_;
    }
    RDP_Negotiation_Failure* neg_fail() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( switch1_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:133:neg_fail", (int64)switch1_case_index(), "((int) 0x03)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return neg_fail_;
    }

protected:
    uint8 response_type_;
    uint8 switch1_case_index_;
    RDP_Negotiation_Response* neg_resp_;
    RDP_Negotiation_Failure* neg_fail_;
};


class RDP_Negotiation_Response final {
public:
    RDP_Negotiation_Response();
    ~RDP_Negotiation_Response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint8 flags() const { return flags_; }
    uint16 length() const { return length_; }
    uint32 selected_protocol() const { return selected_protocol_; }
    int byteorder() const { return byteorder_; }
    bool enc_ssl() const { BINPAC_ASSERT(has_enc_ssl()); return enc_ssl_; }
    bool has_enc_ssl() const { return has_enc_ssl_; }
    bool proc() const { return proc_; }

protected:
    uint8 flags_;
    uint16 length_;
    uint32 selected_protocol_;
    int byteorder_;
    bool enc_ssl_;
    bool has_enc_ssl_;
    bool proc_;
};


class RDP_Negotiation_Failure final {
public:
    RDP_Negotiation_Failure();
    ~RDP_Negotiation_Failure();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint8 flags() const { return flags_; }
    uint16 length() const { return length_; }
    uint32 failure_code() const { return failure_code_; }
    int byteorder() const { return byteorder_; }
    bool proc() const { return proc_; }

protected:
    uint8 flags_;
    uint16 length_;
    uint32 failure_code_;
    int byteorder_;
    bool proc_;
};


class Client_Header final {
public:
    Client_Header();
    ~Client_Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context, int t_byteorder);

    // Member access functions
    ASN1Integer* type_length() const { return type_length_; }
    ASN1OctetString* calling_domain_selector() const { return calling_domain_selector_; }
    ASN1OctetString* called_domain_selector() const { return called_domain_selector_; }
    ASN1Boolean* upward_flag() const { return upward_flag_; }
    ASN1SequenceMeta* target_parameters() const { return target_parameters_; }
    ASN1SequenceMeta* minimum_parameters() const { return minimum_parameters_; }
    ASN1SequenceMeta* maximum_parameters() const { return maximum_parameters_; }
    uint32 user_data_length() const { return user_data_length_; }
    GCC_Client_Connection_Data* gcc_connection_data() const { return gcc_connection_data_; }
    GCC_Client_Create_Request* gcc_client_create_request() const { return gcc_client_create_request_; }
    vector<Data_Block*>* data_blocks() const { return data_blocks_; }

protected:
    ASN1Integer* type_length_;
    ASN1OctetString* calling_domain_selector_;
    ASN1OctetString* called_domain_selector_;
    ASN1Boolean* upward_flag_;
    ASN1SequenceMeta* target_parameters_;
    const_bytestring targ_parameters_pad_;
    ASN1SequenceMeta* minimum_parameters_;
    const_bytestring min_parameters_pad_;
    ASN1SequenceMeta* maximum_parameters_;
    const_bytestring max_parameters_pad_;
    uint32 user_data_length_;
    GCC_Client_Connection_Data* gcc_connection_data_;
    GCC_Client_Create_Request* gcc_client_create_request_;
    vector<Data_Block*>* data_blocks_;
    Data_Block* data_blocks__elem_;
};


class GCC_Client_Connection_Data final {
public:
    GCC_Client_Connection_Data();
    ~GCC_Client_Connection_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint16 key_object_length() const { return key_object_length_; }
    vector<uint8>* key_object() const { return key_object_; }
    uint16 connect_data_connect_pdu() const { return connect_data_connect_pdu_; }
    int byteorder() const { return byteorder_; }

protected:
    uint16 key_object_length_;
    vector<uint8>* key_object_;
    uint8 key_object__elem_;
    uint16 connect_data_connect_pdu_;
    int byteorder_;
};


class GCC_Client_Create_Request final {
public:
    GCC_Client_Create_Request();
    ~GCC_Client_Create_Request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 extension_bit() const { return extension_bit_; }
    uint8 privileges() const { return privileges_; }
    uint8 numeric_length() const { return numeric_length_; }
    uint8 numeric() const { return numeric_; }
    uint8 termination_method() const { return termination_method_; }
    uint8 number_user_data_sets() const { return number_user_data_sets_; }
    uint8 user_data_value_present() const { return user_data_value_present_; }
    uint8 h221_nonstandard_length() const { return h221_nonstandard_length_; }
    bytestring const& h221_nonstandard_key() const { return h221_nonstandard_key_; }
    uint16 user_data_value_length() const { return user_data_value_length_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 extension_bit_;
    uint8 privileges_;
    uint8 numeric_length_;
    uint8 numeric_;
    uint8 termination_method_;
    uint8 number_user_data_sets_;
    uint8 user_data_value_present_;
    uint8 h221_nonstandard_length_;
    bytestring h221_nonstandard_key_;
    uint16 user_data_value_length_;
    int byteorder_;
};


class Client_Core_Data final {
public:
    Client_Core_Data();
    ~Client_Core_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint16 version_major() const { return version_major_; }
    uint16 version_minor() const { return version_minor_; }
    uint16 desktop_width() const { return desktop_width_; }
    uint16 desktop_height() const { return desktop_height_; }
    uint16 color_depth() const { return color_depth_; }
    uint16 sas_sequence() const { return sas_sequence_; }
    uint32 keyboard_layout() const { return keyboard_layout_; }
    uint32 client_build() const { return client_build_; }
    bytestring const& client_name() const { return client_name_; }
    uint32 keyboard_type() const { return keyboard_type_; }
    uint32 keyboard_sub() const { return keyboard_sub_; }
    uint32 keyboard_function_key() const { return keyboard_function_key_; }
    bytestring const& ime_file_name() const { return ime_file_name_; }
    uint16 post_beta2_color_depth() const { return post_beta2_color_depth_; }
    uint16 client_product_id() const { return client_product_id_; }
    uint32 serial_number() const { return serial_number_; }
    uint16 high_color_depth() const { return high_color_depth_; }
    uint16 supported_color_depths() const { return supported_color_depths_; }
    uint16 early_capability_flags() const { return early_capability_flags_; }
    bytestring const& dig_product_id() const { return dig_product_id_; }
    int byteorder() const { return byteorder_; }
    bool SUPPORT_ERRINFO_PDU() const { return SUPPORT_ERRINFO_PDU_; }
    bool WANT_32BPP_SESSION() const { return WANT_32BPP_SESSION_; }
    bool SUPPORT_STATUSINFO_PDU() const { return SUPPORT_STATUSINFO_PDU_; }
    bool STRONG_ASYMMETRIC_KEYS() const { return STRONG_ASYMMETRIC_KEYS_; }
    bool SUPPORT_MONITOR_LAYOUT_PDU() const { return SUPPORT_MONITOR_LAYOUT_PDU_; }
    bool SUPPORT_NETCHAR_AUTODETECT() const { return SUPPORT_NETCHAR_AUTODETECT_; }
    bool SUPPORT_DYNVC_GFX_PROTOCOL() const { return SUPPORT_DYNVC_GFX_PROTOCOL_; }
    bool SUPPORT_DYNAMIC_TIME_ZONE() const { return SUPPORT_DYNAMIC_TIME_ZONE_; }
    bool SUPPORT_HEARTBEAT_PDU() const { return SUPPORT_HEARTBEAT_PDU_; }
    bool proc() const { return proc_; }

protected:
    uint16 version_major_;
    uint16 version_minor_;
    uint16 desktop_width_;
    uint16 desktop_height_;
    uint16 color_depth_;
    uint16 sas_sequence_;
    uint32 keyboard_layout_;
    uint32 client_build_;
    bytestring client_name_;
    uint32 keyboard_type_;
    uint32 keyboard_sub_;
    uint32 keyboard_function_key_;
    bytestring ime_file_name_;
    uint16 post_beta2_color_depth_;
    uint16 client_product_id_;
    uint32 serial_number_;
    uint16 high_color_depth_;
    uint16 supported_color_depths_;
    uint16 early_capability_flags_;
    bytestring dig_product_id_;
    int byteorder_;
    bool SUPPORT_ERRINFO_PDU_;
    bool WANT_32BPP_SESSION_;
    bool SUPPORT_STATUSINFO_PDU_;
    bool STRONG_ASYMMETRIC_KEYS_;
    bool SUPPORT_MONITOR_LAYOUT_PDU_;
    bool SUPPORT_NETCHAR_AUTODETECT_;
    bool SUPPORT_DYNVC_GFX_PROTOCOL_;
    bool SUPPORT_DYNAMIC_TIME_ZONE_;
    bool SUPPORT_HEARTBEAT_PDU_;
    bool proc_;
};


class Client_Security_Data final {
public:
    Client_Security_Data();
    ~Client_Security_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint32 encryption_methods() const { return encryption_methods_; }
    uint32 ext_encryption_methods() const { return ext_encryption_methods_; }
    int byteorder() const { return byteorder_; }
    bool proc() const { return proc_; }

protected:
    uint32 encryption_methods_;
    uint32 ext_encryption_methods_;
    int byteorder_;
    bool proc_;
};


class Client_Network_Data final {
public:
    Client_Network_Data();
    ~Client_Network_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint32 channel_count() const { return channel_count_; }
    vector<Client_Channel_Def*>* channel_def_array() const { return channel_def_array_; }
    int byteorder() const { return byteorder_; }
    bool proc() const { return proc_; }

protected:
    uint32 channel_count_;
    vector<Client_Channel_Def*>* channel_def_array_;
    Client_Channel_Def* channel_def_array__elem_;
    int byteorder_;
    bool proc_;
};


class Client_Cluster_Data final {
public:
    Client_Cluster_Data();
    ~Client_Cluster_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint32 flags() const { return flags_; }
    uint32 redir_session_id() const { return redir_session_id_; }
    int byteorder() const { return byteorder_; }
    bool REDIRECTION_SUPPORTED() const { return REDIRECTION_SUPPORTED_; }
    uint8 SERVER_SESSION_REDIRECTION_VERSION_MASK() const { return SERVER_SESSION_REDIRECTION_VERSION_MASK_; }
    bool REDIRECTED_SESSIONID_FIELD_VALID() const { return REDIRECTED_SESSIONID_FIELD_VALID_; }
    bool REDIRECTED_SMARTCARD() const { return REDIRECTED_SMARTCARD_; }
    bool proc() const { return proc_; }

protected:
    uint32 flags_;
    uint32 redir_session_id_;
    int byteorder_;
    bool REDIRECTION_SUPPORTED_;
    uint8 SERVER_SESSION_REDIRECTION_VERSION_MASK_;
    bool REDIRECTED_SESSIONID_FIELD_VALID_;
    bool REDIRECTED_SMARTCARD_;
    bool proc_;
};


class Client_Channel_Def final {
public:
    Client_Channel_Def();
    ~Client_Channel_Def();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& name() const { return name_; }
    uint32 options() const { return options_; }
    int byteorder() const { return byteorder_; }
    bool REMOTE_CONTROL_PERSISTENT() const { return REMOTE_CONTROL_PERSISTENT_; }
    bool CHANNEL_OPTION_SHOW_PROTOCOL() const { return CHANNEL_OPTION_SHOW_PROTOCOL_; }
    bool CHANNEL_OPTION_COMPRESS() const { return CHANNEL_OPTION_COMPRESS_; }
    bool CHANNEL_OPTION_COMPRESS_RDP() const { return CHANNEL_OPTION_COMPRESS_RDP_; }
    bool CHANNEL_OPTION_PRI_LOW() const { return CHANNEL_OPTION_PRI_LOW_; }
    bool CHANNEL_OPTION_PRI_MED() const { return CHANNEL_OPTION_PRI_MED_; }
    bool CHANNEL_OPTION_PRI_HIGH() const { return CHANNEL_OPTION_PRI_HIGH_; }
    bool CHANNEL_OPTION_ENCRYPT_CS() const { return CHANNEL_OPTION_ENCRYPT_CS_; }
    bool CHANNEL_OPTION_ENCRYPT_SC() const { return CHANNEL_OPTION_ENCRYPT_SC_; }
    bool CHANNEL_OPTION_ENCRYPT_RDP() const { return CHANNEL_OPTION_ENCRYPT_RDP_; }
    bool CHANNEL_OPTION_INITIALIZED() const { return CHANNEL_OPTION_INITIALIZED_; }

protected:
    bytestring name_;
    uint32 options_;
    int byteorder_;
    bool REMOTE_CONTROL_PERSISTENT_;
    bool CHANNEL_OPTION_SHOW_PROTOCOL_;
    bool CHANNEL_OPTION_COMPRESS_;
    bool CHANNEL_OPTION_COMPRESS_RDP_;
    bool CHANNEL_OPTION_PRI_LOW_;
    bool CHANNEL_OPTION_PRI_MED_;
    bool CHANNEL_OPTION_PRI_HIGH_;
    bool CHANNEL_OPTION_ENCRYPT_CS_;
    bool CHANNEL_OPTION_ENCRYPT_SC_;
    bool CHANNEL_OPTION_ENCRYPT_RDP_;
    bool CHANNEL_OPTION_INITIALIZED_;
};


class Server_Header final {
public:
    Server_Header();
    ~Server_Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    vector<uint8>* type_length() const { return type_length_; }
    ASN1Enumerated* connect_response_result() const { return connect_response_result_; }
    ASN1Integer* connect_response_called_id() const { return connect_response_called_id_; }
    ASN1SequenceMeta* connect_response_domain_parameters() const { return connect_response_domain_parameters_; }
    uint32 user_data_length() const { return user_data_length_; }
    GCC_Server_Connection_Data* gcc_connection_data() const { return gcc_connection_data_; }
    GCC_Server_Create_Response* gcc_create_response() const { return gcc_create_response_; }
    vector<Data_Block*>* data_blocks() const { return data_blocks_; }
    int byteorder() const { return byteorder_; }

protected:
    vector<uint8>* type_length_;
    uint8 type_length__elem_;
    ASN1Enumerated* connect_response_result_;
    ASN1Integer* connect_response_called_id_;
    ASN1SequenceMeta* connect_response_domain_parameters_;
    const_bytestring domain_parameters_;
    uint32 user_data_length_;
    GCC_Server_Connection_Data* gcc_connection_data_;
    GCC_Server_Create_Response* gcc_create_response_;
    vector<Data_Block*>* data_blocks_;
    Data_Block* data_blocks__elem_;
    int byteorder_;
};


class GCC_Server_Connection_Data final {
public:
    GCC_Server_Connection_Data();
    ~GCC_Server_Connection_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint16 key_object_length() const { return key_object_length_; }
    vector<uint8>* key_object() const { return key_object_; }
    uint8 connect_data_connect_pdu() const { return connect_data_connect_pdu_; }
    int byteorder() const { return byteorder_; }

protected:
    uint16 key_object_length_;
    vector<uint8>* key_object_;
    uint8 key_object__elem_;
    uint8 connect_data_connect_pdu_;
    int byteorder_;
};


class GCC_Server_Create_Response final {
public:
    GCC_Server_Create_Response();
    ~GCC_Server_Create_Response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint8 extension_bit() const { return extension_bit_; }
    uint16 node_id() const { return node_id_; }
    uint8 tag_length() const { return tag_length_; }
    uint8 tag() const { return tag_; }
    uint8 result() const { return result_; }
    uint8 number_user_data_sets() const { return number_user_data_sets_; }
    uint8 user_data_value_present() const { return user_data_value_present_; }
    uint8 h221_nonstandard_length() const { return h221_nonstandard_length_; }
    bytestring const& h221_nonstandard_key() const { return h221_nonstandard_key_; }
    uint16 user_data_value_length() const { return user_data_value_length_; }
    int byteorder() const { return byteorder_; }
    bool proc() const { return proc_; }

protected:
    uint8 extension_bit_;
    uint16 node_id_;
    uint8 tag_length_;
    uint8 tag_;
    uint8 result_;
    uint8 number_user_data_sets_;
    uint8 user_data_value_present_;
    uint8 h221_nonstandard_length_;
    bytestring h221_nonstandard_key_;
    uint16 user_data_value_length_;
    int byteorder_;
    bool proc_;
};


class Server_Core_Data final {
public:
    Server_Core_Data(Data_Header* h);
    ~Server_Core_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint16 version_major() const { return version_major_; }
    uint16 version_minor() const { return version_minor_; }
    uint16 switch1_case_index() const	{ return switch1_case_index_; }
    uint32 client_requested_protocols() const {
        return client_requested_protocols_;
    }
    Data_Header* h() const { return h_; }
    int byteorder() const { return byteorder_; }

protected:
    uint16 version_major_;
    uint16 version_minor_;
    uint16 switch1_case_index_;
    uint32 client_requested_protocols_;
    Data_Header* h_;
    int byteorder_;
};


class Server_Network_Data final {
public:
    Server_Network_Data();
    ~Server_Network_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint16 mcs_channel_id() const { return mcs_channel_id_; }
    uint16 channel_count() const { return channel_count_; }
    int byteorder() const { return byteorder_; }

protected:
    uint16 mcs_channel_id_;
    uint16 channel_count_;
    int byteorder_;
};


class Server_Security_Data final {
public:
    Server_Security_Data();
    ~Server_Security_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint32 encryption_method() const { return encryption_method_; }
    uint32 encryption_level() const { return encryption_level_; }
    uint32 server_random_length() const { return server_random_length_; }
    uint32 server_cert_length() const { return server_cert_length_; }
    bytestring const& server_random() const { return server_random_; }
    Server_Certificate* server_certificate() const { return server_certificate_; }
    int byteorder() const { return byteorder_; }
    bool enc() const { BINPAC_ASSERT(has_enc()); return enc_; }
    bool has_enc() const { return has_enc_; }
    bool proc() const { return proc_; }

protected:
    uint32 encryption_method_;
    uint32 encryption_level_;
    uint32 server_random_length_;
    uint32 server_cert_length_;
    bytestring server_random_;
    Server_Certificate* server_certificate_;
    int byteorder_;
    bool enc_;
    bool has_enc_;
    bool proc_;
};


class Server_Certificate final {
public:
    Server_Certificate();
    ~Server_Certificate();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint32 version() const { return version_; }
    uint32 switch_case_index() const	{ return switch_case_index_; }
    Server_Proprietary_Cert* proprietary() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( switch_case_index() ) {
            case ((uint32)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:341:proprietary", (int64)switch_case_index(), "((int) 0x01)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return proprietary_;
    }
    X509* x509() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( switch_case_index() ) {
            case ((uint32)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:342:x509", (int64)switch_case_index(), "((int) 0x02)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return x509_;
    }
    int byteorder() const { return byteorder_; }
    uint32 cert_type() const { return cert_type_; }
    bool permanently_issued() const { return permanently_issued_; }
    bool proc() const { return proc_; }

protected:
    uint32 version_;
    uint32 switch_case_index_;
    Server_Proprietary_Cert* proprietary_;
    X509* x509_;
    int byteorder_;
    uint32 cert_type_;
    bool permanently_issued_;
    bool proc_;
};


class Server_Proprietary_Cert final {
public:
    Server_Proprietary_Cert(Server_Certificate* cert);
    ~Server_Proprietary_Cert();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint32 signature_algorithm() const { return signature_algorithm_; }
    uint32 key_algorithm() const { return key_algorithm_; }
    uint16 public_key_blob_type() const { return public_key_blob_type_; }
    uint16 public_key_blob_length() const { return public_key_blob_length_; }
    Public_Key_Blob* public_key_blob() const { return public_key_blob_; }
    uint16 signature_blob_type() const { return signature_blob_type_; }
    uint16 signature_blob_length() const { return signature_blob_length_; }
    bytestring const& signature_blob() const { return signature_blob_; }
    Server_Certificate* cert() const { return cert_; }
    int byteorder() const { return byteorder_; }

protected:
    uint32 signature_algorithm_;
    uint32 key_algorithm_;
    uint16 public_key_blob_type_;
    uint16 public_key_blob_length_;
    Public_Key_Blob* public_key_blob_;
    uint16 signature_blob_type_;
    uint16 signature_blob_length_;
    bytestring signature_blob_;
    Server_Certificate* cert_;
    int byteorder_;
};


class Public_Key_Blob final {
public:
    Public_Key_Blob();
    ~Public_Key_Blob();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& magic() const { return magic_; }
    uint32 key_length() const { return key_length_; }
    uint32 bit_length() const { return bit_length_; }
    uint32 public_exponent() const { return public_exponent_; }
    bytestring const& modulus() const { return modulus_; }
    int byteorder() const { return byteorder_; }

protected:
    bytestring magic_;
    uint32 key_length_;
    uint32 bit_length_;
    uint32 public_exponent_;
    bytestring modulus_;
    int byteorder_;
};


class X509 final {
public:
    X509();
    ~X509();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint32 num_of_certs() const { return num_of_certs_; }
    vector<X509_Cert_Data*>* certs() const { return certs_; }
    int byteorder() const { return byteorder_; }

protected:
    uint32 num_of_certs_;
    vector<X509_Cert_Data*>* certs_;
    X509_Cert_Data* certs__elem_;
    int byteorder_;
};


class X509_Cert_Data final {
public:
    X509_Cert_Data();
    ~X509_Cert_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context);

    // Member access functions
    uint32 cert_len() const { return cert_len_; }
    bytestring const& cert() const { return cert_; }
    int byteorder() const { return byteorder_; }
    bool proc() const { return proc_; }

protected:
    uint32 cert_len_;
    bytestring cert_;
    int byteorder_;
    bool proc_;
};


class RDP_Flow final : public binpac::FlowAnalyzer {
public:
    RDP_Flow(RDP_Conn* connection, bool is_orig);
    ~RDP_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    RDP_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    bool proc_rdp_connect_request(Connect_Request* cr);
    bool proc_rdp_negotiation_response(RDP_Negotiation_Response* nr);
    bool proc_rdp_negotiation_failure(RDP_Negotiation_Failure* nf);
    bool proc_rdp_gcc_server_create_response(GCC_Server_Create_Response* gcc_response);
    bool proc_rdp_client_core_data(Client_Core_Data* ccore);
    bool proc_rdp_client_security_data(Client_Security_Data* csec);
    bool proc_rdp_client_network_data(Client_Network_Data* cnetwork);
    bool proc_rdp_client_cluster_data(Client_Cluster_Data* ccluster);
    bool proc_rdp_server_security(Server_Security_Data* ssd);
    bool proc_rdp_server_certificate(Server_Certificate* cert);
    bool proc_x509_cert_data(X509_Cert_Data* x509);

protected:
    TPKT* dataunit_;
    ContextRDP* context_;
    FlowBuffer* flow_buffer_;
    RDP_Conn* connection_;
    bool is_orig_;
};

} // namespace RDP
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_rdp_rdp_pac_h */
