// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_rfb_rfb_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_rfb_rfb_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


	#include "zeek/analyzer/protocol/rfb/events.bif.h"

namespace binpac {

namespace RFB {
class ContextRFB;
class RFB_Conn;
// NOLINTNEXTLINE(performance-enum-size)
enum ServerState {
    SERVER_VERSION = 0,
    SERVER_AUTH_TYPE = 1,
    SERVER_AUTH_TYPE37 = 2,
    SERVER_AUTH_FAILURE = 3,
    SERVER_AUTH_VNC_CHALLENGE = 4,
    SERVER_AUTH_ARD_CHALLENGE = 5,
    SERVER_AUTH_RESULT = 6,
    SERVER_INIT = 7,
    SERVER_MESSAGE_TYPE = 8,
    SERVER_MESSAGE = 9,
    SERVER_WAIT = 99,
    SERVER_INVALID = 100,
};
// NOLINTNEXTLINE(performance-enum-size)
enum ClientState {
    CLIENT_VERSION = 0,
    CLIENT_AUTH_SELECTION = 1,
    CLIENT_AUTH_VNC_RESPONSE = 2,
    CLIENT_AUTH_ARD_RESPONSE = 3,
    CLIENT_INIT = 4,
    CLIENT_MESSAGE_TYPE = 5,
    CLIENT_MESSAGE = 6,
    CLIENT_WAIT = 99,
    CLIENT_INVALID = 100,
};
class RFBProtocolVersion;
class RFBFailReasonString;
class RFBSecurityType;
class RFBSecurityTypes37;
class RFBAuthTypeSelected;
class RFBSecurityResult;
class RFBVNCAuthenticationRequest;
class RFBVNCAuthenticationResponse;
class RFBSecurityARDChallenge;
class RFBSecurityARDResponse;
class RFBClientInit;
class RFBServerInit;
class InvalidData;
class WaitData;
class ClientMessageType;
class ClientMessage;
class ClientSetPixelFormat;
class ClientSetEncodings;
class ClientFramebufferUpdateRequest;
class ClientKeyEvent;
class ClientPointerEvent;
class ClientCutText;
class ServerMessageType;
class ServerMessage;
class PixelData;
class PD_Raw;
class PD_CopyRec;
class RRE_Subrect;
class PD_RRE;
class PD_Hextile;
class PD_TRLE;
class PD_ZRLE;
class PD_PseudoCursor;
class PD_PseudoDesktopSize;
class Rectangle;
class ServerFramebufferUpdate;
class RGB_Value;
class ServerSetColorMapEntries;
class ServerBell;
class ServerCutText;
class RFB_PDU_request;
class RFB_PDU_response;
class RFB_PDU;
class RFB_Flow;
} // namespace RFB

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace RFB {

class ContextRFB final {
public:
    ContextRFB(RFB_Conn* connection, RFB_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextRFB();

    // Member access functions
    RFB_Conn* connection() const { return connection_; }
    RFB_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    RFB_Conn* connection_;
    RFB_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class RFB_Conn final : public binpac::ConnectionAnalyzer {
public:
    RFB_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~RFB_Conn() override;

    // Member access functions
    RFB_Flow* upflow() const { return upflow_; }
    RFB_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    bool saw_handshake();
    uint16 get_ard_key_length();
    int get_state(bool client);
    uint8 get_next_msg_type(bool client);
    uint8 get_bytes_per_pixel();
    bool handle_banners(bool client, RFBProtocolVersion* msg);
    bool handle_security_type(RFBSecurityType* msg);
    bool handle_fail_reason_string(RFBFailReasonString* msg);
    bool handle_security_types37(RFBSecurityTypes37* msg);
    bool handle_auth_type_selected(RFBAuthTypeSelected* msg);
    bool handle_ard_challenge(RFBSecurityARDChallenge* msg);
    bool handle_ard_response();
    bool handle_auth_request();
    bool handle_auth_response();
    bool handle_security_result(RFBSecurityResult* msg);
    bool handle_client_init(RFBClientInit* msg);
    bool handle_server_init(RFBServerInit* msg);
    bool handle_wait_data(bool client);
    bool handle_invalid_data(bool client);
    bool handle_client_message_type(uint8 type);
    bool handle_client_message(uint8 type);
    bool handle_server_message_type(uint8 type);
    bool handle_server_message(uint8 type);
    bool handle_client_set_pixel_format(ClientSetPixelFormat* msg);
    bool handle_client_set_encodings(ClientSetEncodings* msg);
    bool handle_client_framebuffer_update_request(ClientFramebufferUpdateRequest* msg);
    bool handle_client_key_event(ClientKeyEvent* msg);
    bool handle_client_pointer_event(ClientPointerEvent* msg);
    bool handle_client_cut_text(ClientCutText* msg);

protected:

    // Additional members

		enum ServerState : uint8_t {
			SERVER_VERSION            =  0,
			SERVER_AUTH_TYPE          =  1,
			SERVER_AUTH_TYPE37        =  2,
			SERVER_AUTH_FAILURE       =  3,
			SERVER_AUTH_VNC_CHALLENGE =  4,
			SERVER_AUTH_ARD_CHALLENGE =  5,
			SERVER_AUTH_RESULT        =  6,
			SERVER_INIT               =  7,
			SERVER_MESSAGE_TYPE       =  8,
			SERVER_MESSAGE            =  9,
			SERVER_WAIT               = 99,
			SERVER_INVALID            =100,
		};

		enum ClientState : uint8_t {
			CLIENT_VERSION           =  0,
			CLIENT_AUTH_SELECTION    =  1,
			CLIENT_AUTH_VNC_RESPONSE =  2,
			CLIENT_AUTH_ARD_RESPONSE =  3,
			CLIENT_INIT              =  4,
			CLIENT_MESSAGE_TYPE      =  5,
			CLIENT_MESSAGE           =  6,
			CLIENT_WAIT              = 99,
			CLIENT_INVALID           =100,
		};

		int version = 0;
		uint8 client_state = CLIENT_VERSION;
		uint8 server_state = SERVER_VERSION;
		uint16 ard_key_length = 0;
		uint8 next_client_msg = 0;
		uint8 next_server_msg = 0;
		uint8 bytes_per_pixel = 0;
		bool saw_full_handshake = false;
	
    RFB_Flow* upflow_;
    RFB_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};

extern uint32 const MAX_DATA_LENGTH;

class RFBProtocolVersion final {
public:
    RFBProtocolVersion(bool client);
    ~RFBProtocolVersion();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    bytestring const& header() const { return header_; }
    bytestring const& major_ver() const { return major_ver_; }
    bytestring const& dot() const { return dot_; }
    bytestring const& minor_ver() const { return minor_ver_; }
    uint8 pad() const { return pad_; }
    bool client() const { return client_; }
    bool proc() const { return proc_; }
    bool proc2() const { return proc2_; }

protected:
    bytestring header_;
    bytestring major_ver_;
    bytestring dot_;
    bytestring minor_ver_;
    uint8 pad_;
    bool client_;
    bool proc_;
    bool proc2_;
    int buffering_state_;
};


class RFBFailReasonString final {
public:
    RFBFailReasonString();
    ~RFBFailReasonString();
    int initial_buffer_length() const { return 4; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint32 len() const { return len_; }
    bytestring const& str() const { return str_; }
    bool proc() const { return proc_; }

protected:
    uint32 len_;
    bytestring str_;
    bool proc_;
    int buffering_state_;
};


class RFBSecurityType final {
public:
    RFBSecurityType();
    ~RFBSecurityType();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint32 sectype() const { return sectype_; }
    bool proc() const { return proc_; }
    bool proc2() const { return proc2_; }

protected:
    uint32 sectype_;
    bool proc_;
    bool proc2_;
    int buffering_state_;
};


class RFBSecurityTypes37 final {
public:
    RFBSecurityTypes37();
    ~RFBSecurityTypes37();
    int initial_buffer_length() const { return 1; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    uint8 count() const { return count_; }
    vector<uint8>* types() const { return types_; }
    bool proc() const { return proc_; }

protected:
    uint8 count_;
    vector<uint8>* types_;
    uint8 types__elem_;
    bool proc_;
    int buffering_state_;
};


class RFBAuthTypeSelected final {
public:
    RFBAuthTypeSelected();
    ~RFBAuthTypeSelected();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    uint8 type() const { return type_; }
    bool proc() const { return proc_; }
    bool proc2() const { return proc2_; }

protected:
    uint8 type_;
    bool proc_;
    bool proc2_;
    int buffering_state_;
};


class RFBSecurityResult final {
public:
    RFBSecurityResult();
    ~RFBSecurityResult();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint32 result() const { return result_; }
    bool proc() const { return proc_; }
    bool proc2() const { return proc2_; }

protected:
    uint32 result_;
    bool proc_;
    bool proc2_;
    int buffering_state_;
};


class RFBVNCAuthenticationRequest final {
public:
    RFBVNCAuthenticationRequest();
    ~RFBVNCAuthenticationRequest();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    bytestring const& challenge() const { return challenge_; }
    bool proc() const { return proc_; }

protected:
    bytestring challenge_;
    bool proc_;
    int buffering_state_;
};


class RFBVNCAuthenticationResponse final {
public:
    RFBVNCAuthenticationResponse();
    ~RFBVNCAuthenticationResponse();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    bytestring const& response() const { return response_; }
    bool proc() const { return proc_; }

protected:
    bytestring response_;
    bool proc_;
    int buffering_state_;
};


class RFBSecurityARDChallenge final {
public:
    RFBSecurityARDChallenge();
    ~RFBSecurityARDChallenge();
    int initial_buffer_length() const { return 4; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint16 generator() const { return generator_; }
    uint16 key_length() const { return key_length_; }
    bytestring const& prime_mod() const { return prime_mod_; }
    bytestring const& publickey() const { return publickey_; }
    bool proc() const { return proc_; }

protected:
    uint16 generator_;
    uint16 key_length_;
    bytestring prime_mod_;
    bytestring publickey_;
    bool proc_;
    int buffering_state_;
};


class RFBSecurityARDResponse final {
public:
    RFBSecurityARDResponse();
    ~RFBSecurityARDResponse();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    bytestring const& publickey() const { return publickey_; }
    bytestring const& creds() const { return creds_; }
    bool proc() const { return proc_; }

protected:
    bytestring publickey_;
    bytestring creds_;
    bool proc_;
    int buffering_state_;
};


class RFBClientInit final {
public:
    RFBClientInit();
    ~RFBClientInit();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    uint8 shared_flag() const { return shared_flag_; }
    bool proc() const { return proc_; }
    bool proc2() const { return proc2_; }

protected:
    uint8 shared_flag_;
    bool proc_;
    bool proc2_;
    int buffering_state_;
};


class RFBServerInit final {
public:
    RFBServerInit();
    ~RFBServerInit();
    int initial_buffer_length() const { return 24; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint16 width() const { return width_; }
    uint16 height() const { return height_; }
    vector<uint8>* pixel_format() const { return pixel_format_; }
    uint32 len() const { return len_; }
    vector<uint8>* name() const { return name_; }
    bool proc() const { return proc_; }
    bool proc2() const { return proc2_; }

protected:
    uint16 width_;
    uint16 height_;
    vector<uint8>* pixel_format_;
    uint8 pixel_format__elem_;
    uint32 len_;
    vector<uint8>* name_;
    uint8 name__elem_;
    bool proc_;
    bool proc2_;
    int buffering_state_;
};


class InvalidData final {
public:
    InvalidData(bool orig);
    ~InvalidData();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    uint8 invalid() const { return invalid_; }
    bool orig() const { return orig_; }
    bool proc() const { return proc_; }

protected:
    uint8 invalid_;
    bool orig_;
    bool proc_;
    int buffering_state_;
};


class WaitData final {
public:
    WaitData(bool orig);
    ~WaitData();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    bytestring const& nothing() const { return nothing_; }
    bool orig() const { return orig_; }
    bool proc() const { return proc_; }

protected:
    bytestring nothing_;
    bool orig_;
    bool proc_;
    int buffering_state_;
};


class ClientMessageType final {
public:
    ClientMessageType();
    ~ClientMessageType();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    uint8 type() const { return type_; }
    bool proc() const { return proc_; }

protected:
    uint8 type_;
    bool proc_;
    int buffering_state_;
};


class ClientMessage final {
public:
    ClientMessage(uint8 type);
    ~ClientMessage();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    ClientSetPixelFormat* set_pixel_format() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:145:set_pixel_format", (int64)val_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return set_pixel_format_;
    }
    ClientSetEncodings* set_encodings() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:146:set_encodings", (int64)val_case_index(), "((int) 2)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return set_encodings_;
    }
    ClientFramebufferUpdateRequest* framebuffer_update_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:147:framebuffer_update_request", (int64)val_case_index(), "((int) 3)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return framebuffer_update_request_;
    }
    ClientKeyEvent* key_event() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:148:key_event", (int64)val_case_index(), "((int) 4)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return key_event_;
    }
    ClientPointerEvent* pointer_event() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:149:pointer_event", (int64)val_case_index(), "((int) 5)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pointer_event_;
    }
    ClientCutText* cut_text() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:150:cut_text", (int64)val_case_index(), "((int) 6)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return cut_text_;
    }
    uint8 type() const { return type_; }
    bool proc() const { return proc_; }

protected:
    uint8 val_case_index_;
    ClientSetPixelFormat* set_pixel_format_;
    ClientSetEncodings* set_encodings_;
    ClientFramebufferUpdateRequest* framebuffer_update_request_;
    ClientKeyEvent* key_event_;
    ClientPointerEvent* pointer_event_;
    ClientCutText* cut_text_;
    uint8 type_;
    bool proc_;
};


class ClientSetPixelFormat final {
public:
    ClientSetPixelFormat();
    ~ClientSetPixelFormat();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    vector<uint8>* pad() const { return pad_; }
    vector<uint8>* pixel_format() const { return pixel_format_; }
    bool proc() const { return proc_; }

protected:
    vector<uint8>* pad_;
    uint8 pad__elem_;
    vector<uint8>* pixel_format_;
    uint8 pixel_format__elem_;
    bool proc_;
    int buffering_state_;
};


class ClientSetEncodings final {
public:
    ClientSetEncodings();
    ~ClientSetEncodings();
    int initial_buffer_length() const { return 3; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint8 pad() const { return pad_; }
    uint16 num_encodings() const { return num_encodings_; }
    vector<uint32>* encodings() const { return encodings_; }
    bool proc() const { return proc_; }

protected:
    uint8 pad_;
    uint16 num_encodings_;
    vector<uint32>* encodings_;
    uint32 encodings__elem_;
    bool proc_;
    int buffering_state_;
};


class ClientFramebufferUpdateRequest final {
public:
    ClientFramebufferUpdateRequest();
    ~ClientFramebufferUpdateRequest();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint8 incremental() const { return incremental_; }
    uint16 xpos() const { return xpos_; }
    uint16 ypos() const { return ypos_; }
    uint16 width() const { return width_; }
    uint16 height() const { return height_; }
    bool proc() const { return proc_; }

protected:
    uint8 incremental_;
    uint16 xpos_;
    uint16 ypos_;
    uint16 width_;
    uint16 height_;
    bool proc_;
    int buffering_state_;
};


class ClientKeyEvent final {
public:
    ClientKeyEvent();
    ~ClientKeyEvent();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint8 down_flag() const { return down_flag_; }
    uint16 pad() const { return pad_; }
    uint32 key() const { return key_; }
    bool proc() const { return proc_; }

protected:
    uint8 down_flag_;
    uint16 pad_;
    uint32 key_;
    bool proc_;
    int buffering_state_;
};


class ClientPointerEvent final {
public:
    ClientPointerEvent();
    ~ClientPointerEvent();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint8 button_mask() const { return button_mask_; }
    uint16 xpos() const { return xpos_; }
    uint16 ypos() const { return ypos_; }
    bool proc() const { return proc_; }

protected:
    uint8 button_mask_;
    uint16 xpos_;
    uint16 ypos_;
    bool proc_;
    int buffering_state_;
};


class ClientCutText final {
public:
    ClientCutText();
    ~ClientCutText();
    int initial_buffer_length() const { return 7; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    vector<uint8>* pad() const { return pad_; }
    uint32 len() const { return len_; }
    bytestring const& text() const { return text_; }
    bool proc() const { return proc_; }

protected:
    vector<uint8>* pad_;
    uint8 pad__elem_;
    uint32 len_;
    bytestring text_;
    bool proc_;
    int buffering_state_;
};


class ServerMessageType final {
public:
    ServerMessageType();
    ~ServerMessageType();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    uint8 type() const { return type_; }
    bool proc() const { return proc_; }

protected:
    uint8 type_;
    bool proc_;
    int buffering_state_;
};


class ServerMessage final {
public:
    ServerMessage(uint8 type);
    ~ServerMessage();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    ServerFramebufferUpdate* framebuffer_update() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:211:framebuffer_update", (int64)val_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return framebuffer_update_;
    }
    ServerSetColorMapEntries* set_color_map_entries() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:212:set_color_map_entries", (int64)val_case_index(), "((int) 1)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return set_color_map_entries_;
    }
    ServerBell* bell() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:213:bell", (int64)val_case_index(), "((int) 2)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return bell_;
    }
    ServerCutText* cut_text() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:214:cut_text", (int64)val_case_index(), "((int) 3)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return cut_text_;
    }
    uint8 type() const { return type_; }
    bool proc() const { return proc_; }

protected:
    uint8 val_case_index_;
    ServerFramebufferUpdate* framebuffer_update_;
    ServerSetColorMapEntries* set_color_map_entries_;
    ServerBell* bell_;
    ServerCutText* cut_text_;
    uint8 type_;
    bool proc_;
};


class PixelData final {
public:
    PixelData(int32 encoding, uint16 x, uint16 y, uint16 w, uint16 h);
    ~PixelData();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    int32 val_case_index() const	{ return val_case_index_; }
    PD_Raw* raw() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int32)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:220:raw", (int64)val_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return raw_;
    }
    PD_CopyRec* copy_rec() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int32)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:221:copy_rec", (int64)val_case_index(), "((int) 1)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return copy_rec_;
    }
    PD_RRE* rre() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int32)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:222:rre", (int64)val_case_index(), "((int) 2)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return rre_;
    }
    PD_Hextile* hextile() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int32)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:223:hextile", (int64)val_case_index(), "((int) 5)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return hextile_;
    }
    PD_TRLE* trle() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int32)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:224:trle", (int64)val_case_index(), "((int) 15)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return trle_;
    }
    PD_ZRLE* zrle() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int32)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:225:zrle", (int64)val_case_index(), "((int) 16)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return zrle_;
    }
    int32 encoding() const { return encoding_; }
    uint16 x() const { return x_; }
    uint16 y() const { return y_; }
    uint16 w() const { return w_; }
    uint16 h() const { return h_; }

protected:
    int32 val_case_index_;
    PD_Raw* raw_;
    PD_CopyRec* copy_rec_;
    PD_RRE* rre_;
    PD_Hextile* hextile_;
    PD_TRLE* trle_;
    PD_ZRLE* zrle_;
    int32 encoding_;
    uint16 x_;
    uint16 y_;
    uint16 w_;
    uint16 h_;
};


class PD_Raw final {
public:
    PD_Raw(uint16 w, uint16 h);
    ~PD_Raw();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context);

    // Member access functions
    uint16 w() const { return w_; }
    uint16 h() const { return h_; }

protected:
    const_bytestring pixels_;
    uint16 w_;
    uint16 h_;
};


class PD_CopyRec final {
public:
    PD_CopyRec();
    ~PD_CopyRec();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 xpos() const { return xpos_; }
    uint16 ypos() const { return ypos_; }

protected:
    uint16 xpos_;
    uint16 ypos_;
};


class RRE_Subrect final {
public:
    RRE_Subrect();
    ~RRE_Subrect();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    bytestring const& pixel() const { return pixel_; }
    uint16 xpos() const { return xpos_; }
    uint16 ypos() const { return ypos_; }
    uint16 width() const { return width_; }
    uint16 height() const { return height_; }

protected:
    bytestring pixel_;
    uint16 xpos_;
    uint16 ypos_;
    uint16 width_;
    uint16 height_;
};


class PD_RRE final {
public:
    PD_RRE();
    ~PD_RRE();
    int initial_buffer_length() const { return 4; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint32 num_subrects() const { return num_subrects_; }
    bytestring const& bg_pixel() const { return bg_pixel_; }

protected:
    uint32 num_subrects_;
    bytestring bg_pixel_;
    vector<RRE_Subrect*>* subrects_;
    RRE_Subrect* subrects__elem_;
};


class PD_Hextile final {
public:
    PD_Hextile();
    ~PD_Hextile();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions

protected:
};


class PD_TRLE final {
public:
    PD_TRLE();
    ~PD_TRLE();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions

protected:
};


class PD_ZRLE final {
public:
    PD_ZRLE();
    ~PD_ZRLE();
    int initial_buffer_length() const { return 4; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 len() const { return len_; }

protected:
    uint32 len_;
    const_bytestring zlib_data_;
};


class PD_PseudoCursor final {
public:
    PD_PseudoCursor(uint16 w, uint16 h);
    ~PD_PseudoCursor();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context);

    // Member access functions
    uint16 w() const { return w_; }
    uint16 h() const { return h_; }

protected:
    const_bytestring pixels_;
    const_bytestring bitmask_;
    uint16 w_;
    uint16 h_;
};


class PD_PseudoDesktopSize final {
public:
    PD_PseudoDesktopSize();
    ~PD_PseudoDesktopSize();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions

protected:
};


class Rectangle final {
public:
    Rectangle();
    ~Rectangle();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint16 xpos() const { return xpos_; }
    uint16 ypos() const { return ypos_; }
    uint16 width() const { return width_; }
    uint16 height() const { return height_; }
    int32 encoding() const { return encoding_; }
    PixelData* pixel_data() const { return pixel_data_; }

protected:
    uint16 xpos_;
    uint16 ypos_;
    uint16 width_;
    uint16 height_;
    int32 encoding_;
    PixelData* pixel_data_;
};


class ServerFramebufferUpdate final {
public:
    ServerFramebufferUpdate();
    ~ServerFramebufferUpdate();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint8 pad() const { return pad_; }
    uint16 num_rects() const { return num_rects_; }
    vector<Rectangle*>* rects() const { return rects_; }

protected:
    uint8 pad_;
    uint16 num_rects_;
    vector<Rectangle*>* rects_;
    Rectangle* rects__elem_;
    int buffering_state_;
};


class RGB_Value final {
public:
    RGB_Value();
    ~RGB_Value();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 red() const { return red_; }
    uint16 green() const { return green_; }
    uint16 blue() const { return blue_; }

protected:
    uint16 red_;
    uint16 green_;
    uint16 blue_;
};


class ServerSetColorMapEntries final {
public:
    ServerSetColorMapEntries();
    ~ServerSetColorMapEntries();
    int initial_buffer_length() const { return 5; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, int t_byteorder);

    // Member access functions
    uint8 pad() const { return pad_; }
    uint16 first_color() const { return first_color_; }
    uint16 num_colors() const { return num_colors_; }
    vector<RGB_Value*>* colors() const { return colors_; }

protected:
    uint8 pad_;
    uint16 first_color_;
    uint16 num_colors_;
    vector<RGB_Value*>* colors_;
    RGB_Value* colors__elem_;
    int buffering_state_;
};


class ServerBell final {
public:
    ServerBell();
    ~ServerBell();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions

protected:
};


class ServerCutText final {
public:
    ServerCutText();
    ~ServerCutText();
    int initial_buffer_length() const { return 7; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, int t_byteorder);

    // Member access functions
    vector<uint8>* pad() const { return pad_; }
    uint32 len() const { return len_; }
    bytestring const& text() const { return text_; }

protected:
    vector<uint8>* pad_;
    uint8 pad__elem_;
    uint32 len_;
    bytestring text_;
    int buffering_state_;
};


class RFB_PDU_request final {
public:
    RFB_PDU_request(uint8 state);
    ~RFB_PDU_request();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    WaitData* wait() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)99):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:320:wait", (int64)val_case_index(), "CLIENT_WAIT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return wait_;
    }
    InvalidData* invalid() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)100):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:321:invalid", (int64)val_case_index(), "CLIENT_INVALID");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return invalid_;
    }
    RFBProtocolVersion* version() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:323:version", (int64)val_case_index(), "CLIENT_VERSION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return version_;
    }
    RFBAuthTypeSelected* authtype() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:324:authtype", (int64)val_case_index(), "CLIENT_AUTH_SELECTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return authtype_;
    }
    RFBVNCAuthenticationResponse* response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:325:response", (int64)val_case_index(), "CLIENT_AUTH_VNC_RESPONSE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return response_;
    }
    RFBSecurityARDResponse* ard_response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:326:ard_response", (int64)val_case_index(), "CLIENT_AUTH_ARD_RESPONSE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ard_response_;
    }
    RFBClientInit* shareflag() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:327:shareflag", (int64)val_case_index(), "CLIENT_INIT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return shareflag_;
    }
    ClientMessageType* msg_type() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:329:msg_type", (int64)val_case_index(), "CLIENT_MESSAGE_TYPE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return msg_type_;
    }
    ClientMessage* msg() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:330:msg", (int64)val_case_index(), "CLIENT_MESSAGE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return msg_;
    }
    uint8 state() const { return state_; }

protected:
    uint8 val_case_index_;
    WaitData* wait_;
    InvalidData* invalid_;
    RFBProtocolVersion* version_;
    RFBAuthTypeSelected* authtype_;
    RFBVNCAuthenticationResponse* response_;
    RFBSecurityARDResponse* ard_response_;
    RFBClientInit* shareflag_;
    ClientMessageType* msg_type_;
    ClientMessage* msg_;
    uint8 state_;
};


class RFB_PDU_response final {
public:
    RFB_PDU_response(uint8 state);
    ~RFB_PDU_response();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    WaitData* wait() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)99):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:334:wait", (int64)val_case_index(), "SERVER_WAIT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return wait_;
    }
    InvalidData* invalid() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)100):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:335:invalid", (int64)val_case_index(), "SERVER_INVALID");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return invalid_;
    }
    RFBProtocolVersion* version() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:337:version", (int64)val_case_index(), "SERVER_VERSION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return version_;
    }
    RFBSecurityType* auth_type() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:338:auth_type", (int64)val_case_index(), "SERVER_AUTH_TYPE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return auth_type_;
    }
    RFBSecurityTypes37* auth_types37() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:339:auth_types37", (int64)val_case_index(), "SERVER_AUTH_TYPE37");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return auth_types37_;
    }
    RFBFailReasonString* fail_reason() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:340:fail_reason", (int64)val_case_index(), "SERVER_AUTH_FAILURE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return fail_reason_;
    }
    RFBVNCAuthenticationRequest* challenge() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:341:challenge", (int64)val_case_index(), "SERVER_AUTH_VNC_CHALLENGE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return challenge_;
    }
    RFBSecurityARDChallenge* ard_challenge() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:342:ard_challenge", (int64)val_case_index(), "SERVER_AUTH_ARD_CHALLENGE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ard_challenge_;
    }
    RFBSecurityResult* authresult() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:343:authresult", (int64)val_case_index(), "SERVER_AUTH_RESULT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return authresult_;
    }
    RFBServerInit* serverinit() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:344:serverinit", (int64)val_case_index(), "SERVER_INIT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return serverinit_;
    }
    ServerMessageType* msg_type() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:346:msg_type", (int64)val_case_index(), "SERVER_MESSAGE_TYPE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return msg_type_;
    }
    ServerMessage* msg() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:349:msg", (int64)val_case_index(), "SERVER_MESSAGE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return msg_;
    }
    uint8 state() const { return state_; }

protected:
    uint8 val_case_index_;
    WaitData* wait_;
    InvalidData* invalid_;
    RFBProtocolVersion* version_;
    RFBSecurityType* auth_type_;
    RFBSecurityTypes37* auth_types37_;
    RFBFailReasonString* fail_reason_;
    RFBVNCAuthenticationRequest* challenge_;
    RFBSecurityARDChallenge* ard_challenge_;
    RFBSecurityResult* authresult_;
    RFBServerInit* serverinit_;
    ServerMessageType* msg_type_;
    ServerMessage* msg_;
    uint8 state_;
};


class RFB_PDU final {
public:
    RFB_PDU(bool is_orig);
    ~RFB_PDU();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    RFB_PDU_request* request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:353:request", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return request_;
    }
    RFB_PDU_response* response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:354:response", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return response_;
    }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    int val_case_index_;
    RFB_PDU_request* request_;
    RFB_PDU_response* response_;
    bool is_orig_;
    int byteorder_;
};


class RFB_Flow final : public binpac::FlowAnalyzer {
public:
    RFB_Flow(RFB_Conn* connection, bool is_orig);
    ~RFB_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    RFB_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    bool proc_rfb_version(bool client, bytestring const& major, bytestring const& minor);
    bool proc_rfb_share_flag(bool shared);
    bool proc_security_types(RFBSecurityType* msg);
    bool proc_security_types37(RFBAuthTypeSelected* msg);
    bool proc_handle_server_params(RFBServerInit* msg);
    bool proc_handle_security_result(uint32 result);

protected:
    RFB_PDU* dataunit_;
    ContextRFB* context_;
    FlowBuffer* flow_buffer_;
    RFB_Conn* connection_;
    bool is_orig_;
};

} // namespace RFB
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_rfb_rfb_pac_h */
