// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/sip/sip.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/sip/sip_pac.h"

namespace binpac {






namespace SIP {
// NOLINTNEXTLINE(modernize-use-equals-default)
ContextSIP::ContextSIP(SIP_Conn* connection, SIP_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextSIP::~ContextSIP() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Conn::SIP_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new SIP_Flow(this, true);
    downflow_ = new SIP_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Conn::~SIP_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void SIP_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void SIP_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void SIP_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

RegExMatcher SIP_TOKEN_re_001("[a-zA-Z0-9_.!%*+`'~-]+");

RegExMatcher NOT_SIP_TOKEN_re_002("[^a-zA-Z0-9_.!%*+`'~-]*");

RegExMatcher SIP_WS_re_003("[ \\t]*");

RegExMatcher SIP_URI_re_004("[[:alnum:]@[:punct:]]+");

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_PDU::SIP_PDU(bool is_orig) {
    val_case_index_ = -1;
    request_ = nullptr;
    reply_ = nullptr;
    is_orig_ = is_orig;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_PDU::~SIP_PDU() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "request"
            {
                delete request_;
                request_ = nullptr;
            }
            break;
        case false:
            // Clean up "reply"
            {
                delete reply_;
                reply_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool SIP_PDU::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    val_case_index_ = is_orig();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "request"
            {
                if ( ! request_ ) {
                    request_ = new SIP_Request();
                }
                bool t_request_parsing_complete;
                t_request_parsing_complete = false;
                t_request_parsing_complete = request_->ParseBuffer(t_flow_buffer, t_context);
                if ( t_request_parsing_complete ) {
                }
                t_val_parsing_complete = t_request_parsing_complete;
            }
            break;
        case false:
            // Parse "reply"
            {
                if ( ! reply_ ) {
                    reply_ = new SIP_Reply();
                }
                bool t_reply_parsing_complete;
                t_reply_parsing_complete = false;
                t_reply_parsing_complete = reply_->ParseBuffer(t_flow_buffer, t_context);
                if ( t_reply_parsing_complete ) {
                }
                t_val_parsing_complete = t_reply_parsing_complete;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SIP_PDU", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->flow()->proc_sip_message_done(this);
    }
    return t_val_parsing_complete;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Request::SIP_Request() {
    request_ = nullptr;
    buffering_state_ = 0;
    buffering_state_ = 0;
    msg_ = nullptr;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Request::~SIP_Request() {
    delete request_;
    request_ = nullptr;
    delete msg_;
    msg_ = nullptr;
}

bool SIP_Request::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "request"
        if ( ! request_ ) {
            request_ = new SIP_RequestLine();
        }
        if ( buffering_state_ == 0 ) {
            t_flow_buffer->UnsetLineBreaker();
            t_flow_buffer->NewLine();
            buffering_state_ = 1;
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_request_parsing_complete;
        t_request_parsing_complete = false;
        while ( ! t_request_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            t_request_parsing_complete = request_->Parse(t_begin_of_data, t_end_of_data, t_context);
            if ( t_request_parsing_complete ) {
                // Evaluate 'let' and 'withinput' fields
            }
            buffering_state_ = 0;
        }
        if ( ! (t_request_parsing_complete) )
            goto need_more_data;
        }

        // Parse "msg"
        if ( ! msg_ ) {
            msg_ = new SIP_Message();
        }
        parsing_state_ = 2;
        /* fall through */
    case 2:
    {
        bool t_msg_parsing_complete;
        t_msg_parsing_complete = false;
        t_msg_parsing_complete = msg_->ParseBuffer(t_flow_buffer, t_context);
        if ( t_msg_parsing_complete ) {
        }
        if ( ! (t_msg_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Reply::SIP_Reply() {
    reply_ = nullptr;
    buffering_state_ = 0;
    buffering_state_ = 0;
    msg_ = nullptr;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Reply::~SIP_Reply() {
    delete reply_;
    reply_ = nullptr;
    delete msg_;
    msg_ = nullptr;
}

bool SIP_Reply::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "reply"
        if ( ! reply_ ) {
            reply_ = new SIP_ReplyLine();
        }
        if ( buffering_state_ == 0 ) {
            t_flow_buffer->UnsetLineBreaker();
            t_flow_buffer->NewLine();
            buffering_state_ = 1;
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_reply_parsing_complete;
        t_reply_parsing_complete = false;
        while ( ! t_reply_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            t_reply_parsing_complete = reply_->Parse(t_begin_of_data, t_end_of_data, t_context);
            if ( t_reply_parsing_complete ) {
                // Evaluate 'let' and 'withinput' fields
            }
            buffering_state_ = 0;
        }
        if ( ! (t_reply_parsing_complete) )
            goto need_more_data;
        }

        // Parse "msg"
        if ( ! msg_ ) {
            msg_ = new SIP_Message();
        }
        parsing_state_ = 2;
        /* fall through */
    case 2:
    {
        bool t_msg_parsing_complete;
        t_msg_parsing_complete = false;
        t_msg_parsing_complete = msg_->ParseBuffer(t_flow_buffer, t_context);
        if ( t_msg_parsing_complete ) {
        }
        if ( ! (t_msg_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_RequestLine::SIP_RequestLine() {
    version_ = nullptr;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_RequestLine::~SIP_RequestLine() {
    junk_.free();
    method_.free();
    uri_.free();
    delete version_;
    version_ = nullptr;
}

int SIP_RequestLine::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSIP* t_context) {
    // Parse "junk"
    int t_junk_string_length;
    t_junk_string_length = 
        NOT_SIP_TOKEN_re_002.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_junk_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:22", "[^a-zA-Z0-9_.!%*+`'~-]*", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_junk__size;
    t_junk__size = t_junk_string_length;
    // check for negative sizes
    if ( t_junk_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:22", t_junk_string_length);
    junk_.init(t_begin_of_data, t_junk_string_length);

    const_byteptr const t_dataptr_after_junk = t_begin_of_data + (t_junk__size);
    BINPAC_ASSERT(t_dataptr_after_junk <= t_end_of_data);
    // Parse "method"
    int t_method_string_length;
    t_method_string_length = 
        SIP_TOKEN_re_001.MatchPrefix(
            t_dataptr_after_junk,
            t_end_of_data - t_dataptr_after_junk);
    if ( t_method_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:23", "[a-zA-Z0-9_.!%*+`'~-]+", string(reinterpret_cast<const char*>(t_dataptr_after_junk), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_method__size;
    t_method__size = t_method_string_length;
    // check for negative sizes
    if ( t_method_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:23", t_method_string_length);
    method_.init(t_dataptr_after_junk, t_method_string_length);

    const_byteptr const t_dataptr_after_method = t_dataptr_after_junk + (t_method__size);
    BINPAC_ASSERT(t_dataptr_after_method <= t_end_of_data);
    // Parse "anonymous_field_005"
    bytestring anonymous_field_005_;
    int t_anonymous_field_005_string_length;
    t_anonymous_field_005_string_length = 
        SIP_WS_re_003.MatchPrefix(
            t_dataptr_after_method,
            t_end_of_data - t_dataptr_after_method);
    if ( t_anonymous_field_005_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:24", "[ \\t]*", string(reinterpret_cast<const char*>(t_dataptr_after_method), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_anonymous_field_005__size;
    t_anonymous_field_005__size = t_anonymous_field_005_string_length;
    anonymous_field_005_.free();

    const_byteptr const t_dataptr_after_anonymous_field_005 = t_dataptr_after_method + (t_anonymous_field_005__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_005 <= t_end_of_data);
    // Parse "uri"
    int t_uri_string_length;
    t_uri_string_length = 
        SIP_URI_re_004.MatchPrefix(
            t_dataptr_after_anonymous_field_005,
            t_end_of_data - t_dataptr_after_anonymous_field_005);
    if ( t_uri_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:25", "[[:alnum:]@[:punct:]]+", string(reinterpret_cast<const char*>(t_dataptr_after_anonymous_field_005), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_uri__size;
    t_uri__size = t_uri_string_length;
    // check for negative sizes
    if ( t_uri_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:25", t_uri_string_length);
    uri_.init(t_dataptr_after_anonymous_field_005, t_uri_string_length);

    const_byteptr const t_dataptr_after_uri = t_dataptr_after_anonymous_field_005 + (t_uri__size);
    BINPAC_ASSERT(t_dataptr_after_uri <= t_end_of_data);
    // Parse "anonymous_field_006"
    bytestring anonymous_field_006_;
    int t_anonymous_field_006_string_length;
    t_anonymous_field_006_string_length = 
        SIP_WS_re_003.MatchPrefix(
            t_dataptr_after_uri,
            t_end_of_data - t_dataptr_after_uri);
    if ( t_anonymous_field_006_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:26", "[ \\t]*", string(reinterpret_cast<const char*>(t_dataptr_after_uri), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_anonymous_field_006__size;
    t_anonymous_field_006__size = t_anonymous_field_006_string_length;
    anonymous_field_006_.free();

    const_byteptr const t_dataptr_after_anonymous_field_006 = t_dataptr_after_uri + (t_anonymous_field_006__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_006 <= t_end_of_data);
    // Parse "version"
    version_ = new SIP_Version();
    int t_version__size;
    t_version__size = version_->Parse(t_dataptr_after_anonymous_field_006, t_end_of_data);

    int t_SIP_RequestLine__size;
    const_byteptr const t_dataptr_after_version = t_dataptr_after_anonymous_field_006 + (t_version__size);
    BINPAC_ASSERT(t_dataptr_after_version <= t_end_of_data);
    t_SIP_RequestLine__size = t_dataptr_after_version - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_sip_request(junk(), method(), uri(), version());
    BINPAC_ASSERT(t_begin_of_data + (t_SIP_RequestLine__size) <= t_end_of_data);
    return t_SIP_RequestLine__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_ReplyLine::SIP_ReplyLine() {
    version_ = nullptr;
    status_ = nullptr;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_ReplyLine::~SIP_ReplyLine() {
    delete version_;
    version_ = nullptr;
    delete status_;
    status_ = nullptr;
    reason_.free();
}

int SIP_ReplyLine::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSIP* t_context) {
    // Parse "version"
    version_ = new SIP_Version();
    int t_version__size;
    t_version__size = version_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_version = t_begin_of_data + (t_version__size);
    BINPAC_ASSERT(t_dataptr_after_version <= t_end_of_data);
    // Parse "anonymous_field_007"
    bytestring anonymous_field_007_;
    int t_anonymous_field_007_string_length;
    t_anonymous_field_007_string_length = 
        SIP_WS_re_003.MatchPrefix(
            t_dataptr_after_version,
            t_end_of_data - t_dataptr_after_version);
    if ( t_anonymous_field_007_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:32", "[ \\t]*", string(reinterpret_cast<const char*>(t_dataptr_after_version), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_anonymous_field_007__size;
    t_anonymous_field_007__size = t_anonymous_field_007_string_length;
    anonymous_field_007_.free();

    const_byteptr const t_dataptr_after_anonymous_field_007 = t_dataptr_after_version + (t_anonymous_field_007__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_007 <= t_end_of_data);
    // Parse "status"
    status_ = new SIP_Status();
    int t_status__size;
    t_status__size = status_->Parse(t_dataptr_after_anonymous_field_007, t_end_of_data);

    const_byteptr const t_dataptr_after_status = t_dataptr_after_anonymous_field_007 + (t_status__size);
    BINPAC_ASSERT(t_dataptr_after_status <= t_end_of_data);
    // Parse "anonymous_field_008"
    bytestring anonymous_field_008_;
    int t_anonymous_field_008_string_length;
    t_anonymous_field_008_string_length = 
        SIP_WS_re_003.MatchPrefix(
            t_dataptr_after_status,
            t_end_of_data - t_dataptr_after_status);
    if ( t_anonymous_field_008_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:34", "[ \\t]*", string(reinterpret_cast<const char*>(t_dataptr_after_status), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_anonymous_field_008__size;
    t_anonymous_field_008__size = t_anonymous_field_008_string_length;
    anonymous_field_008_.free();

    const_byteptr const t_dataptr_after_anonymous_field_008 = t_dataptr_after_status + (t_anonymous_field_008__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_008 <= t_end_of_data);
    // Parse "reason"
    int t_reason_string_length;
    t_reason_string_length = (t_end_of_data) - (t_dataptr_after_anonymous_field_008);
    int t_reason__size;
    t_reason__size = t_reason_string_length;
    // check for negative sizes
    if ( t_reason_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:35", t_reason_string_length);
    reason_.init(t_dataptr_after_anonymous_field_008, t_reason_string_length);

    int t_SIP_ReplyLine__size;
    const_byteptr const t_dataptr_after_reason = t_dataptr_after_anonymous_field_008 + (t_reason__size);
    BINPAC_ASSERT(t_dataptr_after_reason <= t_end_of_data);
    t_SIP_ReplyLine__size = t_dataptr_after_reason - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_sip_reply(version(), status()->stat_num(), reason());
    BINPAC_ASSERT(t_begin_of_data + (t_SIP_ReplyLine__size) <= t_end_of_data);
    return t_SIP_ReplyLine__size;
}

RegExMatcher SIP_Status_re_009("[0-9]{3}");

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Status::SIP_Status() {
    stat_num_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Status::~SIP_Status() {
    stat_str_.free();
}

int SIP_Status::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "stat_str"
    int t_stat_str_string_length;
    t_stat_str_string_length = 
        SIP_Status_re_009.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_stat_str_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:39", "[0-9]{3}", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_stat_str__size;
    t_stat_str__size = t_stat_str_string_length;
    // check for negative sizes
    if ( t_stat_str_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:39", t_stat_str_string_length);
    stat_str_.init(t_begin_of_data, t_stat_str_string_length);

    int t_SIP_Status__size;
    const_byteptr const t_dataptr_after_stat_str = t_begin_of_data + (t_stat_str__size);
    BINPAC_ASSERT(t_dataptr_after_stat_str <= t_end_of_data);
    t_SIP_Status__size = t_dataptr_after_stat_str - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    stat_num_ = bytestring_to_int(stat_str(), 10);
    BINPAC_ASSERT(t_begin_of_data + (t_SIP_Status__size) <= t_end_of_data);
    return t_SIP_Status__size;
}

RegExMatcher SIP_Version_re_011("[0-9]+\\.[0-9]+");

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Version::SIP_Version() {
    vers_num_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Version::~SIP_Version() {
    vers_str_.free();
}

int SIP_Version::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "SIP_Version:anonymous_field_010"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SIP_Version:anonymous_field_010",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "anonymous_field_010"
    bytestring anonymous_field_010_;
    if ( memcmp(t_begin_of_data, "SIP/", 4) != 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:45", "SIP/", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    anonymous_field_010_.free();

    // Parse "vers_str"
    int t_vers_str_string_length;
    t_vers_str_string_length = 
        SIP_Version_re_011.MatchPrefix(
            (t_begin_of_data + 4),
            t_end_of_data - (t_begin_of_data + 4));
    if ( t_vers_str_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:46", "[0-9]+\\.[0-9]+", string(reinterpret_cast<const char*>((t_begin_of_data + 4)), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_vers_str__size;
    t_vers_str__size = t_vers_str_string_length;
    // check for negative sizes
    if ( t_vers_str_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:46", t_vers_str_string_length);
    vers_str_.init((t_begin_of_data + 4), t_vers_str_string_length);

    int t_SIP_Version__size;
    const_byteptr const t_dataptr_after_vers_str = (t_begin_of_data + 4) + (t_vers_str__size);
    BINPAC_ASSERT(t_dataptr_after_vers_str <= t_end_of_data);
    t_SIP_Version__size = t_dataptr_after_vers_str - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    vers_num_ = bytestring_to_double(vers_str());
    BINPAC_ASSERT(t_begin_of_data + (t_SIP_Version__size) <= t_end_of_data);
    return t_SIP_Version__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Headers::SIP_Headers() {
    val_ = nullptr;
    val__elem_ = nullptr;
    buffering_state_ = 0;
    buffering_state_ = 0;
    val__arraylength_ = 0;
    val__elem__it_ = 0;
    proc_ = false;
    val__elem__it_ = -1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Headers::~SIP_Headers() {
    delete val__elem_;
    val__elem_ = nullptr;
    if ( val() ) {
        for ( auto* val__elem_ : *val() ) {
            delete val__elem_;
            val__elem_ = nullptr;
        }
    }
    delete val_;
}

bool SIP_Headers::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    if ( val__elem__it_ < 0 ) {
        // Initialize only once
        val__elem__it_ = 0;
        val_ = new vector<SIP_Header*>;
    }
    for (; /* forever */; ++val__elem__it_) {
        if ( ! val__elem_ ) {
            val__elem_ = new SIP_Header();
        }
        if ( buffering_state_ == 0 ) {
            t_flow_buffer->UnsetLineBreaker();
            t_flow_buffer->NewLine();
            buffering_state_ = 1;
        }
        bool t_val__elem_parsing_complete;
        t_val__elem_parsing_complete = false;
        while ( ! t_val__elem_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            const_bytestring t_val__elem_input(t_begin_of_data, t_end_of_data);
            // Check &until( ( @$input->length@() == ((int) 0) ) )
            if (  ( t_val__elem_input.length() == 0 )  ) {
                t_val_parsing_complete = true;
                delete val__elem_;
                val__elem_ = nullptr;
                goto end_of_val;
            }
            t_val__elem_parsing_complete = val__elem_->ParseBuffer(t_flow_buffer, t_context);
            if ( t_val__elem_parsing_complete ) {
                // Evaluate 'let' and 'withinput' fields
            }
            buffering_state_ = 0;
        }
        if ( ! t_val__elem_parsing_complete )
            goto need_more_data;
        val_->push_back(val__elem_);
        val__elem_ = nullptr;
    }
end_of_val: ;
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->flow()->proc_sip_end_of_headers(this);
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Message::SIP_Message() {
    headers_ = nullptr;
    body_ = nullptr;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Message::~SIP_Message() {
    delete headers_;
    headers_ = nullptr;
    delete body_;
    body_ = nullptr;
}

bool SIP_Message::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "headers"
        if ( ! headers_ ) {
            headers_ = new SIP_Headers();
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_headers_parsing_complete;
        t_headers_parsing_complete = false;
        t_headers_parsing_complete = headers_->ParseBuffer(t_flow_buffer, t_context);
        if ( t_headers_parsing_complete ) {
        }
        if ( ! (t_headers_parsing_complete) )
            goto need_more_data;
        }

        // Parse "body"
        if ( ! body_ ) {
            body_ = new SIP_Body();
        }
        parsing_state_ = 2;
        /* fall through */
    case 2:
    {
        bool t_body_parsing_complete;
        t_body_parsing_complete = false;
        t_body_parsing_complete = body_->ParseBuffer(t_flow_buffer, t_context);
        if ( t_body_parsing_complete ) {
        }
        if ( ! (t_body_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

RegExMatcher SIP_HEADER_NAME_re_012("[^: \\t]+");

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Header::SIP_Header() {
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Header::~SIP_Header() {
    name_.free();
    value_.free();
}

bool SIP_Header::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // Parse "name"
    int t_name_string_length;
    t_name_string_length = 
        SIP_HEADER_NAME_re_012.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_name_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:60", "[^: \\t]+", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_name__size;
    t_name__size = t_name_string_length;
    // check for negative sizes
    if ( t_name_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:60", t_name_string_length);
    name_.init(t_begin_of_data, t_name_string_length);

    const_byteptr const t_dataptr_after_name = t_begin_of_data + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    // Parse "anonymous_field_013"
    bytestring anonymous_field_013_;
    int t_anonymous_field_013_string_length;
    t_anonymous_field_013_string_length = 
        SIP_WS_re_003.MatchPrefix(
            t_dataptr_after_name,
            t_end_of_data - t_dataptr_after_name);
    if ( t_anonymous_field_013_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:61", "[ \\t]*", string(reinterpret_cast<const char*>(t_dataptr_after_name), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_anonymous_field_013__size;
    t_anonymous_field_013__size = t_anonymous_field_013_string_length;
    anonymous_field_013_.free();

    const_byteptr const t_dataptr_after_anonymous_field_013 = t_dataptr_after_name + (t_anonymous_field_013__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_013 <= t_end_of_data);
    // Parse "anonymous_field_014"
    bytestring anonymous_field_014_;
    // Checking out-of-bound for "SIP_Header:anonymous_field_014"
    if ( t_dataptr_after_anonymous_field_013 + (1) > t_end_of_data || t_dataptr_after_anonymous_field_013 + (1) < t_dataptr_after_anonymous_field_013 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SIP_Header:anonymous_field_014",
        	((t_dataptr_after_anonymous_field_013 - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    if ( memcmp(t_dataptr_after_anonymous_field_013, ":", 1) != 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:62", ":", string(reinterpret_cast<const char*>(t_dataptr_after_anonymous_field_013), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    anonymous_field_014_.free();

    // Parse "anonymous_field_015"
    bytestring anonymous_field_015_;
    int t_anonymous_field_015_string_length;
    t_anonymous_field_015_string_length = 
        SIP_WS_re_003.MatchPrefix(
            (t_dataptr_after_anonymous_field_013 + 1),
            t_end_of_data - (t_dataptr_after_anonymous_field_013 + 1));
    if ( t_anonymous_field_015_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:63", "[ \\t]*", string(reinterpret_cast<const char*>((t_dataptr_after_anonymous_field_013 + 1)), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_anonymous_field_015__size;
    t_anonymous_field_015__size = t_anonymous_field_015_string_length;
    anonymous_field_015_.free();

    const_byteptr const t_dataptr_after_anonymous_field_015 = (t_dataptr_after_anonymous_field_013 + 1) + (t_anonymous_field_015__size);
    BINPAC_ASSERT(t_dataptr_after_anonymous_field_015 <= t_end_of_data);
    // Parse "value"
    int t_value_string_length;
    t_value_string_length = (t_end_of_data) - (t_dataptr_after_anonymous_field_015);
    int t_value__size;
    t_value__size = t_value_string_length;
    // check for negative sizes
    if ( t_value_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:64", t_value_string_length);
    value_.init(t_dataptr_after_anonymous_field_015, t_value_string_length);

    t_val_parsing_complete = true;
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->flow()->proc_sip_header(name(), value());
    }
    buffering_state_ = 0;
    return t_val_parsing_complete;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Body::SIP_Body() {
    buffering_state_ = 0;
    buffering_state_ = 0;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Body::~SIP_Body() {
    body_.free();
}

bool SIP_Body::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSIP* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "body"
        if ( buffering_state_ == 0 ) {
            t_flow_buffer->NewFrame(0, false);
            buffering_state_ = 1;
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_body_parsing_complete;
        t_body_parsing_complete = false;
        while ( ! t_body_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            // NOLINTBEGIN(bugprone-branch-clone)
            switch ( buffering_state_ ) {
                case 0:
                    if ( buffering_state_ == 0 ) {
                        t_flow_buffer->NewFrame(0, false);
                        buffering_state_ = 1;
                    }
                    buffering_state_ = 1;
                    break;
                case 1:
                {
                    buffering_state_ = 2;
                    t_flow_buffer->GrowFrame(t_context->flow()->get_content_length());
                }
                break;
                case 2:
                    BINPAC_ASSERT(t_flow_buffer->ready());
                    if ( t_flow_buffer->ready() ) {
                        int t_body_string_length;
                        t_body_string_length = t_context->flow()->get_content_length();
                        // check for negative sizes
                        if ( t_body_string_length < 0 )
                        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/sip/sip-protocol.pac:68", t_body_string_length);
                        body_.init(t_begin_of_data, t_body_string_length);
                        t_body_parsing_complete = true;
                        if ( t_body_parsing_complete ) {
                            // Evaluate 'let' and 'withinput' fields
                        }
                        BINPAC_ASSERT(t_body_parsing_complete);
                        buffering_state_ = 0;
                    }
                    break;
                default:
                    BINPAC_ASSERT(buffering_state_ <= 2);
                    break;
            }
            // NOLINTEND(bugprone-branch-clone)
        }
        if ( ! (t_body_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Flow::SIP_Flow(SIP_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;

		content_length = 0;
		build_headers = bool(sip_all_headers);
	
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SIP_Flow::~SIP_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void SIP_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new SIP_PDU(is_orig());
                context_ = new ContextSIP(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
            if ( t_dataunit_parsing_complete ) {
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e; // NOLINT(bugprone-exception-copy-constructor-throws)
    }
}

void SIP_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void SIP_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
int SIP_Flow::get_content_length() {

		return content_length;
		
}

bool SIP_Flow::proc_sip_request(bytestring const& junk, bytestring const& method, bytestring const& uri, SIP_Version* vers) {

		if ( junk.length() )
			{
			zeek::String zs{junk.begin(), junk.length(), false};
			auto addl = zs.Render();
			connection()->zeek_analyzer()->Weird("sip_junk_before_request", addl);
			delete [] addl;
			}

		if ( sip_request )
			{
			zeek::BifEvent::enqueue_sip_request(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(),
						       to_stringval(method), to_stringval(uri),
						       to_stringval(vers->vers_str()));
			}

		proc_sip_message_begin();

		return true;
		
}

bool SIP_Flow::proc_sip_reply(SIP_Version* vers, int code, bytestring const& reason) {

		connection()->zeek_analyzer()->AnalyzerConfirmation();
		if ( sip_reply )
			{
			zeek::BifEvent::enqueue_sip_reply(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(),
						     to_stringval(vers->vers_str()), code, to_stringval(reason));
			}

		proc_sip_message_begin();

		return true;
		
}

bool SIP_Flow::proc_sip_header(bytestring const& name, bytestring const& value) {

		if ( name == "Content-Length" || name == "L" )
			content_length = bytestring_to_int(value, 10);

		if ( sip_header )
			{
			auto nameval = to_stringval(name);
			nameval->ToUpper();
			zeek::BifEvent::enqueue_sip_header(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(),
						      is_orig(), std::move(nameval), to_stringval(value));
			}

		if ( build_headers )
			{
			headers.emplace_back(zeek::AdoptRef{}, build_sip_header_val(name, value));
			}

		return true;
		
}

ZeekVal SIP_Flow::build_sip_headers_val() {

		static auto mime_header_list = zeek::id::find_type<zeek::TableType>("mime_header_list");
		auto* t = new zeek::TableVal(mime_header_list);

		for ( unsigned int i = 0; i < headers.size(); ++i )
			{ // index starting from 1
			auto index = zeek::val_mgr->Count(i + 1);
			t->Assign(std::move(index), std::move(headers[i]));
			}

		return t;
		
}

void SIP_Flow::gen_sip_all_headers() {

		if ( sip_all_headers )
			{
			zeek::BifEvent::enqueue_sip_all_headers(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(),
							   is_orig(), {zeek::AdoptRef{}, build_sip_headers_val()});
			}

		headers.clear();
		
}

bool SIP_Flow::proc_sip_end_of_headers(SIP_Headers* headers) {

		if ( build_headers )
			{
			gen_sip_all_headers();
			}

		return true;
		
}

ZeekVal SIP_Flow::build_sip_header_val(const_bytestring const& name, const_bytestring const& value) {

		static auto mime_header_rec = zeek::id::find_type<zeek::RecordType>("mime_header_rec");
		auto* header_record = new zeek::RecordVal(mime_header_rec);
		zeek::StringValPtr name_val;

		if ( name.length() > 0 )
			{
			// Make it all uppercase.
			name_val = zeek::make_intrusive<zeek::StringVal>(name.length(), reinterpret_cast<const char*>(name.begin()));
			name_val->ToUpper();
			}
		else
			{
			name_val = zeek::val_mgr->EmptyString();
			}

		header_record->Assign(0, name_val);
		header_record->Assign(1, to_stringval(value));

		return header_record;
		
}

void SIP_Flow::proc_sip_message_begin() {

		if ( sip_begin_entity )
			{
			zeek::BifEvent::enqueue_sip_begin_entity(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(), is_orig());
			}
		
}

bool SIP_Flow::proc_sip_message_done(SIP_PDU* pdu) {

		if ( sip_end_entity )
			{
			zeek::BifEvent::enqueue_sip_end_entity(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(), is_orig());
			}

		return true;
		
}

} // namespace SIP
}  // namespace binpac
