// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/smb/smb.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_smb_smb_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_smb_smb_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


#include "zeek/analyzer/Manager.h"
#include "zeek/analyzer/Analyzer.h"

#include "zeek/analyzer/protocol/smb/smb1_events.bif.h"
#include "zeek/analyzer/protocol/smb/smb2_events.bif.h"

#include "zeek/analyzer/protocol/smb/types.bif.h"
#include "zeek/analyzer/protocol/smb/events.bif.h"
#include "zeek/analyzer/protocol/smb/consts.bif.h"

#include "zeek/analyzer/protocol/smb/smb1_com_check_directory.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_close.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_create_directory.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_echo.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_logoff_andx.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_negotiate.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_nt_cancel.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_nt_create_andx.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_query_information.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_read_andx.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_session_setup_andx.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_transaction.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_transaction_secondary.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_transaction2.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_transaction2_secondary.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_tree_connect_andx.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_tree_disconnect.bif.h"
#include "zeek/analyzer/protocol/smb/smb1_com_write_andx.bif.h"

#include "zeek/analyzer/protocol/smb/smb2_com_close.bif.h"
#include "zeek/analyzer/protocol/smb/smb2_com_create.bif.h"
#include "zeek/analyzer/protocol/smb/smb2_com_negotiate.bif.h"
#include "zeek/analyzer/protocol/smb/smb2_com_read.bif.h"
#include "zeek/analyzer/protocol/smb/smb2_com_session_setup.bif.h"
#include "zeek/analyzer/protocol/smb/smb2_com_set_info.bif.h"
#include "zeek/analyzer/protocol/smb/smb2_com_tree_connect.bif.h"
#include "zeek/analyzer/protocol/smb/smb2_com_tree_disconnect.bif.h"
#include "zeek/analyzer/protocol/smb/smb2_com_write.bif.h"
#include "zeek/analyzer/protocol/smb/smb2_com_transform_header.bif.h"


#include "zeek/binpac_zeek.h"


#include "zeek/analyzer/protocol/dce-rpc/DCE_RPC.h"


#include "zeek/Dict.h"


#include "zeek/Dict.h"


#include "zeek/file_analysis/Manager.h"

namespace binpac {

namespace SMB {
class ContextSMB;
class SMB_Conn;
class SMB_ascii_string;
class SMB_unicode_string;
class SMB_string;
class SMB2_string;
// NOLINTNEXTLINE(performance-enum-size)
enum SMBVersion {
    SMB1 = -11317950,
    SMB2 = -28095166,
    SMB3 = -44872382,
};
// NOLINTNEXTLINE(performance-enum-size)
enum TransactionType {
    SMB_MAILSLOT_BROWSE,
    SMB_MAILSLOT_LANMAN,
    SMB_PIPE,
    SMB_RAP,
    SMB_UNKNOWN,
};
// NOLINTNEXTLINE(performance-enum-size)
enum SMB_Command {
    SMB_COM_CREATE_DIRECTORY = 0,
    SMB_COM_DELETE_DIRECTORY = 1,
    SMB_COM_OPEN = 2,
    SMB_COM_CREATE = 3,
    SMB_COM_CLOSE = 4,
    SMB_COM_FLUSH = 5,
    SMB_COM_DELETE = 6,
    SMB_COM_RENAME = 7,
    SMB_COM_QUERY_INFORMATION = 8,
    SMB_COM_SET_INFORMATION = 9,
    SMB_COM_READ = 10,
    SMB_COM_WRITE = 11,
    SMB_COM_LOCK_BYTE_RANGE = 12,
    SMB_COM_UNLOCK_BYTE_RANGE = 13,
    SMB_COM_CREATE_TEMPORARY = 14,
    SMB_COM_CREATE_NEW = 15,
    SMB_COM_CHECK_DIRECTORY = 16,
    SMB_COM_PROCESS_EXIT = 17,
    SMB_COM_SEEK = 18,
    SMB_COM_LOCK_AND_READ = 19,
    SMB_COM_WRITE_AND_UNLOCK = 20,
    SMB_COM_READ_RAW = 26,
    SMB_COM_READ_MPX = 27,
    SMB_COM_READ_MPX_SECONDARY = 28,
    SMB_COM_WRITE_RAW = 29,
    SMB_COM_WRITE_MPX = 30,
    SMB_COM_WRITE_MPX_SECONDARY = 31,
    SMB_COM_WRITE_COMPLETE = 32,
    SMB_COM_QUERY_SERVER = 33,
    SMB_COM_SET_INFORMATION2 = 34,
    SMB_COM_QUERY_INFORMATION2 = 35,
    SMB_COM_LOCKING_ANDX = 36,
    SMB_COM_TRANSACTION = 37,
    SMB_COM_TRANSACTION_SECONDARY = 38,
    SMB_COM_IOCTL = 39,
    SMB_COM_IOCTL_SECONDARY = 40,
    SMB_COM_COPY = 41,
    SMB_COM_MOVE = 42,
    SMB_COM_ECHO = 43,
    SMB_COM_WRITE_AND_CLOSE = 44,
    SMB_COM_OPEN_ANDX = 45,
    SMB_COM_READ_ANDX = 46,
    SMB_COM_WRITE_ANDX = 47,
    SMB_COM_NEW_FILE_SIZE = 48,
    SMB_COM_CLOSE_AND_TREE_DISC = 49,
    SMB_COM_TRANSACTION2 = 50,
    SMB_COM_TRANSACTION2_SECONDARY = 51,
    SMB_COM_FIND_CLOSE2 = 52,
    SMB_COM_FIND_NOTIFY_CLOSE = 53,
    SMB_COM_TREE_CONNECT = 112,
    SMB_COM_TREE_DISCONNECT = 113,
    SMB_COM_NEGOTIATE = 114,
    SMB_COM_SESSION_SETUP_ANDX = 115,
    SMB_COM_LOGOFF_ANDX = 116,
    SMB_COM_TREE_CONNECT_ANDX = 117,
    SMB_COM_QUERY_INFORMATION_DISK = 128,
    SMB_COM_SEARCH = 129,
    SMB_COM_FIND = 130,
    SMB_COM_FIND_UNIQUE = 131,
    SMB_COM_FIND_CLOSE = 132,
    SMB_COM_NT_TRANSACT = 160,
    SMB_COM_NT_TRANSACT_SECONDARY = 161,
    SMB_COM_NT_CREATE_ANDX = 162,
    SMB_COM_NT_CANCEL = 164,
    SMB_COM_NT_RENAME = 165,
    SMB_COM_OPEN_PRINT_FILE = 192,
    SMB_COM_WRITE_PRINT_FILE = 193,
    SMB_COM_CLOSE_PRINT_FILE = 194,
    SMB_COM_GET_PRINT_QUEUE = 195,
    SMB_COM_READ_BULK = 216,
    SMB_COM_WRITE_BULK = 217,
    SMB_COM_WRITE_BULK_DATA = 218,
};
// NOLINTNEXTLINE(performance-enum-size)
enum SMB_Status {
    STATUS_SUCCESS = 0,
    STATUS_NOTIFY_ENUM_DIR = 268,
    STATUS_INVALID_SMB = 65538,
    STATUS_SMB_BAD_TID = 327682,
    STATUS_SMB_BAD_FID = 393217,
    STATUS_OS2_INVALID_ACCESS = 786433,
    STATUS_SMB_BAD_COMMAND = 1441794,
    STATUS_SMB_BAD_UID = 5963778,
    STATUS_OS2_NO_MORE_SIDS = 7405569,
    STATUS_OS2_INVALID_LEVEL = 8126465,
    STATUS_OS2_NEGATIVE_SEEK = 8585217,
    STATUS_OS2_CANCEL_VIOLATION = 11337729,
    STATUS_OS2_ATOMIC_LOCKS_NOT_SUPPORTED = 11403265,
    STATUS_SMB_USE_MPX = 16384002,
    STATUS_SMB_USE_STANDARD = 16449538,
    STATUS_SMB_CONTINUE_MPX = 16515074,
    STATUS_OS2_CANNOT_COPY = 17432577,
    STATUS_OS2_EAS_DIDNT_FIT = 18022401,
    STATUS_OS2_EA_ACCESS_DENIED = 65142785,
    STATUS_BUFFER_OVERFLOW = -2147483643,
    STATUS_NO_MORE_FILES = -2147483642,
    STATUS_DEVICE_PAPER_EMPTY = -2147483634,
    STATUS_STOPPED_ON_SYMLINK = -2147483603,
    STATUS_UNSUCCESSFUL = -1073741823,
    STATUS_NOT_IMPLEMENTED = -1073741822,
    STATUS_INVALID_INFO_CLASS = -1073741821,
    STATUS_INVALID_HANDLE = -1073741816,
    STATUS_INVALID_PARAMETER = -1073741811,
    STATUS_NO_SUCH_DEVICE = -1073741810,
    STATUS_NO_SUCH_FILE = -1073741809,
    STATUS_INVALID_DEVICE_REQUEST = -1073741808,
    STATUS_END_OF_FILE = -1073741807,
    STATUS_WRONG_VOLUME = -1073741806,
    STATUS_NONEXISTENT_SECTOR = -1073741803,
    STATUS_NO_MEDIA_IN_DEVICE = -1073741805,
    STATUS_MORE_PROCESSING_REQUIRED = -1073741802,
    STATUS_INVALID_LOCK_SEQUENCE = -1073741794,
    STATUS_INVALID_VIEW_SIZE = -1073741793,
    STATUS_ALREADY_COMMITTED = -1073741791,
    STATUS_ACCESS_DENIED = -1073741790,
    STATUS_BUFFER_TOO_SMALL = -1073741789,
    STATUS_OBJECT_TYPE_MISMATCH = -1073741788,
    STATUS_HANDLE_NOT_CLOSABLE = -1073741787,
    STATUS_DISK_CORRUPT_ERROR = -1073741774,
    STATUS_OBJECT_NAME_NOT_FOUND = -1073741772,
    STATUS_OBJECT_NAME_COLLISION = -1073741771,
    STATUS_PORT_DISCONNECTED = -1073741769,
    STATUS_OBJECT_PATH_INVALID = -1073741767,
    STATUS_OBJECT_PATH_NOT_FOUND = -1073741766,
    STATUS_OBJECT_PATH_SYNTAX_BAD = -1073741765,
    STATUS_DATA_ERROR = -1073741762,
    STATUS_CRC_ERROR = -1073741761,
    STATUS_SECTION_TOO_BIG = -1073741760,
    STATUS_PORT_CONNECTION_REFUSED = -1073741759,
    STATUS_INVALID_PORT_HANDLE = -1073741758,
    STATUS_SHARING_VIOLATION = -1073741757,
    STATUS_THREAD_IS_TERMINATING = -1073741749,
    STATUS_EAS_NOT_SUPPORTED = -1073741745,
    STATUS_EA_TOO_LARGE = -1073741744,
    STATUS_FILE_LOCK_CONFLICT = -1073741740,
    STATUS_LOCK_NOT_GRANTED = -1073741739,
    STATUS_DELETE_PENDING = -1073741738,
    STATUS_PRIVILEGE_NOT_HELD = -1073741727,
    STATUS_LOGON_FAILURE = -1073741715,
    STATUS_WRONG_PASSWORD = -1073741718,
    STATUS_INVALID_LOGON_HOURS = -1073741713,
    STATUS_INVALID_WORKSTATION = -1073741712,
    STATUS_PASSWORD_EXPIRED = -1073741711,
    STATUS_ACCOUNT_DISABLED = -1073741710,
    STATUS_RANGE_NOT_LOCKED = -1073741698,
    STATUS_DISK_FULL = -1073741697,
    STATUS_TOO_MANY_PAGING_FILES = -1073741673,
    STATUS_DFS_EXIT_PATH_FOUND = -1073741669,
    STATUS_DEVICE_DATA_ERROR = -1073741668,
    STATUS_MEDIA_WRITE_PROTECTED = -1073741662,
    STATUS_BAD_IMPERSONATION_LEVEL = -1073741659,
    STATUS_INSTANCE_NOT_AVAILABLE = -1073741653,
    STATUS_PIPE_NOT_AVAILABLE = -1073741652,
    STATUS_PIPE_STATE = -1073741651,
    STATUS_PIPE_BUSY = -1073741650,
    STATUS_ILLEGAL_FUNCTION = -1073741649,
    STATUS_PIPE_DISCONNECTED = -1073741648,
    STATUS_PIPE_CLOSING = -1073741647,
    STATUS_INVALID_READ_MODE = -1073741644,
    STATUS_IO_TIMEOUT = -1073741643,
    STATUS_FILE_IS_A_DIRECTORY = -1073741638,
    STATUS_NOT_SUPPORTED = -1073741637,
    STATUS_UNEXPECTED_NETWORK_ERROR = -1073741628,
    STATUS_PRINT_QUEUE_FULL = -1073741626,
    STATUS_NO_SPOOL_SPACE = -1073741625,
    STATUS_PRINT_CANCELLED = -1073741624,
    STATUS_NETWORK_NAME_DELETED = -1073741623,
    STATUS_NETWORK_ACCESS_DENIED = -1073741622,
    STATUS_BAD_DEVICE_TYPE = -1073741621,
    STATUS_BAD_NETWORK_NAME = -1073741620,
    STATUS_TOO_MANY_SESSIONS = -1073741618,
    STATUS_REQUEST_NOT_ACCEPTED = -1073741616,
    STATUS_NOT_SAME_DEVICE = -1073741612,
    STATUS_FILE_RENAMED = -1073741611,
    STATUS_PIPE_EMPTY = -1073741607,
    STATUS_REDIRECTOR_NOT_STARTED = -1073741573,
    STATUS_DIRECTORY_NOT_EMPTY = -1073741567,
    STATUS_PROCESS_IS_TERMINATING = -1073741558,
    STATUS_TOO_MANY_OPENED_FILES = -1073741537,
    STATUS_CANNOT_DELETE = -1073741535,
    STATUS_FILE_DELETED = -1073741533,
    STATUS_FILE_CLOSED = -1073741528,
    STATUS_INVALID_DEVICE_STATE = -1073741436,
    STATUS_ACCOUNT_EXPIRED = -1073741421,
    STATUS_USER_SESSION_DELETED = -1073741309,
    STATUS_INSUFF_SERVER_RESOURCES = -1073741307,
    STATUS_PASSWORD_MUST_CHANGE = -1073741276,
    STATUS_ACCOUNT_LOCKED_OUT = -1073741260,
    STATUS_PATH_NOT_COVERED = -1073741225,
    STATUS_NETWORK_SESSION_EXPIRED = -1073740964,
    STATUS_SMB_TOO_MANY_UIDS = -1073733542,
    STATUS_SMB_NO_SUPPORT = -65534,
};
class SMB_timestamp32;
class SMB_timestamp;
// NOLINTNEXTLINE(performance-enum-size)
enum SMB_MailSlot_opcode {
    HOST_ANNOUNCEMENT = 1,
    ANNOUNCEMENT_REQUEST = 2,
    REQUEST_ELECTION = 8,
    GET_BACKUP_LIST_REQUEST = 9,
    GET_BACKUP_LIST_RESPONSE = 10,
    BECOME_BACKUP_REQUEST = 11,
    DOMAIN_ANNOUNCEMENT = 12,
    MASTER_ANNOUNCEMENT = 13,
    RESET_BROWSER_STATE = 14,
    LOCAL_MASTER_ANNOUNCEMENT = 15,
};
class SMB_MailSlot_message;
class SMB_MailSlot_command;
class SMB_MailSlot_host_announcement;
class SMB_MailSlot_announcement_request;
class SMB_MailSlot_request_election;
class SMB_MailSlot_get_backup_list_request;
class SMB_MailSlot_get_backup_list_response;
class SMB_MailSlot_domain_announcement;
class SMB_MailSlot_local_master_announcement;
class SMB1_check_directory_request;
class SMB1_check_directory_response;
class SMB1_close_request;
class SMB1_create_directory_request;
class SMB1_create_directory_response;
class SMB1_echo_request;
class SMB1_echo_response;
class LOCKING_ANDX_RANGE32;
class LOCKING_ANDX_RANGE64;
class SMB1_locking_andx_request;
class SMB1_locking_andx_response;
class SMB1_logoff_andx;
class SMB_dialect;
class SMB1_negotiate_request;
class SMB1_negotiate_response;
class SMB1_negotiate_core_response;
class SMB1_negotiate_lanman_response;
class SMB1_negotiate_ntlm_response;
class SMB1_nt_cancel_request;
class SMB1_nt_create_andx_request;
class SMB1_nt_create_andx_response;
class SMB1_nt_transact_request;
class SMB1_nt_transact_response;
class SMB1_query_information_request;
class SMB1_query_information_response;
class SMB1_read_andx_request;
class SMB1_read_andx_response;
class SMB1_session_setup_andx_request;
class SMB1_session_setup_andx_response;
class SMB1_session_setup_andx_request_lanman;
class SMB1_session_setup_andx_response_lanman;
class SMB1_session_setup_andx_request_ntlm_capabilities;
class SMB1_session_setup_andx_request_ntlm_nonextended_security;
class SMB1_session_setup_andx_request_ntlm_extended_security;
class SMB1_session_setup_andx_response_ntlm;
class SMB1_transaction_secondary_request;
// NOLINTNEXTLINE(performance-enum-size)
enum Trans_subcommands {
    NT_TRANSACT_QUERY_QUOTA = 7,
    NT_TRANSACT_SET_QUOTA = 8,
    NT_TRANSACT_CREATE2 = 9,
};
class SMB1_transaction_data;
class SMB1_transaction_request;
class SMB1_transaction_response;
// NOLINTNEXTLINE(performance-enum-size)
enum Trans2_subcommands {
    TRANS2_OPEN2 = 0,
    TRANS2_FIND_FIRST2 = 1,
    TRANS2_FIND_NEXT2 = 2,
    TRANS2_QUERY_FS_INFORMATION = 3,
    TRANS2_SET_FS_INFORMATION = 4,
    TRANS2_QUERY_PATH_INFORMATION = 5,
    TRANS2_SET_PATH_INFORMATION = 6,
    TRANS2_QUERY_FILE_INFORMATION = 7,
    TRANS2_SET_FILE_INFORMATION = 8,
    TRANS2_FSCTL = 9,
    TRANS2_IOCTL2 = 10,
    TRANS2_FIND_NOTIFY_FIRST = 11,
    TRANS2_FIND_NOTIFY_NEXT = 12,
    TRANS2_CREATE_DIRECTORY = 13,
    TRANS2_SESSION_SETUP = 14,
    TRANS2_GET_DFS_REFERRAL = 16,
    TRANS2_REPORT_DFS_INCONSISTENCY = 17,
};
class SMB1_transaction2_request;
class SMB1_transaction2_response;
class trans2_find_first2_request;
class trans2_find_first2_response;
class trans2_query_fs_info_request;
class trans2_query_fs_info_response;
class trans2_query_path_info_request;
class trans2_query_path_info_response;
class trans2_query_file_info_request;
class trans2_query_file_info_response;
class trans2_set_file_info_request;
class trans2_set_file_info_response;
class trans2_get_dfs_referral_request;
class trans2_get_dfs_referral_response;
class SMB1_transaction2_secondary_request;
class SMB1_tree_connect_andx_request;
class SMB1_tree_connect_andx_response;
class SMB1_tree_disconnect;
class SMB1_write_andx_request;
class SMB1_write_andx_response;
class SMB2_close_request;
class SMB2_close_response;
class SMB2_create_context;
class SMB2_create_request;
class SMB2_create_response;
class SMB2_ioctl_request;
class SMB2_ioctl_response;
class SMB2_lock;
class SMB2_lock_request;
class SMB2_lock_response;
// NOLINTNEXTLINE(performance-enum-size)
enum smb3_capabilities {
    SMB2_GLOBAL_CAP_DFS = 0,
    SMB2_GLOBAL_CAP_LEASING = 2,
    SMB2_GLOBAL_CAP_LARGE_MTU = 4,
    SMB2_GLOBAL_CAP_MULTI_CHANNEL = 8,
    SMB2_GLOBAL_CAP_PERSISTENT_HANDLES = 16,
    SMB2_GLOBAL_CAP_DIRECTORY_LEASING = 32,
    SMB2_GLOBAL_CAP_ENCRYPTION = 64,
};
// NOLINTNEXTLINE(performance-enum-size)
enum smb3_context_type {
    SMB2_PREAUTH_INTEGRITY_CAPABILITIES = 1,
    SMB2_ENCRYPTION_CAPABILITIES = 2,
    SMB2_COMPRESSION_CAPABILITIES = 3,
    SMB2_NETNAME_NEGOTIATE_CONTEXT_ID = 5,
};
class SMB3_preauth_integrity_capabilities;
class SMB3_encryption_capabilities;
class SMB3_compression_capabilities;
class SMB3_netname_negotiate_context_id;
class SMB3_negotiate_context_value;
class Padded_SMB3_negotiate_context_value;
class SMB2_negotiate_request;
class NegotiateContextList;
class OptNegotiateContextList;
class SMB2_negotiate_response;
class SMB2_read_request;
class SMB2_read_response;
class SMB2_session_setup_request;
class SMB2_session_setup_response;
// NOLINTNEXTLINE(performance-enum-size)
enum smb2_set_info_type {
    SMB2_0_INFO_FILE = 1,
    SMB2_0_INFO_FILESYSTEM = 2,
    SMB2_0_INFO_SECURITY = 3,
    SMB2_0_INFO_QUOTA = 4,
};
// NOLINTNEXTLINE(performance-enum-size)
enum smb_file_info_type {
    SMB2_FILE_BASIC_INFO = 4,
    SMB2_FILE_RENAME_INFO = 10,
    SMB2_FILE_DISPOSITION_INFO = 13,
    SMB2_FILE_ALLOCATION_INFO = 19,
    SMB2_FILE_ENDOFFILE_INFO = 20,
    SMB2_FILE_FULLEA_INFO = 15,
    SMB2_FILE_LINK_INFO = 11,
    SMB2_FILE_MODE_INFO = 16,
    SMB2_FILE_PIPE_INFO = 24,
    SMB2_FILE_POSITION_INFO = 14,
    SMB2_FILE_SHORTNAME_INFO = 40,
    SMB2_FILE_VALIDDATALENGTH_INFO = 39,
    SMB2_FILE_FSCONTROL_INFO = 6,
    SMB2_FILE_FSOBJECTID_INFO = 8,
};
class SMB2_file_basic_info;
class SMB2_file_rename_info;
class SMB2_file_disposition_info;
class SMB2_file_allocation_info;
class SMB2_file_endoffile_info;
class SMB2_file_fullea_info_element;
class SMB2_file_fullea_info;
class SMB2_file_link_info;
class SMB2_file_mode_info;
class SMB2_file_pipe_info;
class SMB2_file_position_info;
class SMB2_file_shortname_info;
class SMB2_file_validdatalength_info;
class SMB2_file_fscontrol_info;
class SMB2_file_fsobjectid_info;
class SMB2_set_info_file_class;
class SMB2_set_info_filesystem_class;
class SMB2_set_info_request;
class SMB2_set_info_response;
class SMB2_tree_connect_request;
class SMB2_tree_connect_response;
class SMB2_tree_disconnect_request;
class SMB2_tree_disconnect_response;
class SMB2_write_request;
class SMB2_write_response;
class SMB2_transform_header;
class uint24;
class SMB_TCP;
class SMB_Protocol_Identifier;
class SMB_dos_error;
class SMB_error;
class SMB_andx;
class SMB_PDU;
class SMB_No_Message;
class SMB_empty_response;
class SMB_Message;
class SMB_andx_command;
class SMB_Message_Request;
class SMB_Message_Response;
class SMB_Header;
// NOLINTNEXTLINE(performance-enum-size)
enum smb2_commands {
    SMB2_NEGOTIATE_PROTOCOL = 0,
    SMB2_SESSION_SETUP = 1,
    SMB2_LOGOFF = 2,
    SMB2_TREE_CONNECT = 3,
    SMB2_TREE_DISCONNECT = 4,
    SMB2_CREATE = 5,
    SMB2_CLOSE = 6,
    SMB2_FLUSH = 7,
    SMB2_READ = 8,
    SMB2_WRITE = 9,
    SMB2_LOCK = 10,
    SMB2_IOCTL = 11,
    SMB2_CANCEL = 12,
    SMB2_ECHO = 13,
    SMB2_QUERY_DIRECTORY = 14,
    SMB2_CHANGE_NOTIFY = 15,
    SMB2_QUERY_INFO = 16,
    SMB2_SET_INFO = 17,
    SMB2_OPLOCK_BREAK = 18,
};
// NOLINTNEXTLINE(performance-enum-size)
enum smb2_share_types {
    SMB2_SHARE_TYPE_DISK = 1,
    SMB2_SHARE_TYPE_PIPE = 2,
    SMB2_SHARE_TYPE_PRINT = 3,
};
class SMB2_PDU;
class SMB2_Message;
class SMB2_Message_Request;
class SMB2_Message_Response;
class SMB2_file_attributes;
class SMB2_Header;
class SMB2_guid;
class SMB2_File_Notify_Information;
class SMB2_symlink_error;
class SMB2_error_data;
class SMB2_error_response;
class SMB2_logoff_request;
class SMB2_logoff_response;
class SMB2_flush_request;
class SMB2_flush_response;
class SMB2_cancel_request;
class SMB2_echo_request;
class SMB2_echo_response;
class SMB2_query_directory_request;
class SMB2_query_directory_response;
class SMB2_change_notify_request;
class SMB2_change_notify_response;
class SMB2_query_info_request;
class SMB2_query_info_response;
class SMB2_oplock_break;
class SMB_Flow;
} // namespace SMB

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace SMB {

class ContextSMB final {
public:
    ContextSMB(SMB_Conn* connection, SMB_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextSMB();

    // Member access functions
    SMB_Conn* connection() const { return connection_; }
    SMB_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    SMB_Conn* connection_;
    SMB_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class SMB_Conn final : public binpac::ConnectionAnalyzer {
public:
    SMB_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~SMB_Conn() override;

    // Member access functions
    SMB_Flow* upflow() const { return upflow_; }
    SMB_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    bool store_this_unicode_string(SMB_unicode_string* s);
    uint8 get_prev_elem();
    bool get_tree_is_pipe(uint32 tree_id);
    bool unset_tree_is_pipe(uint32 tree_id);
    bool set_tree_is_pipe(uint32 tree_id);
    bool forward_dce_rpc(bytestring const& pipe_data, uint64 fid, bool is_orig);
    bool forward_dce_rpc_close(uint64 fid);
    bool forward_gssapi(bytestring const& data, bool is_orig);
    bool proc_smb1_check_directory_request(SMB_Header* header, SMB1_check_directory_request* val);
    bool proc_smb1_check_directory_response(SMB_Header* header, SMB1_check_directory_response* val);
    bool proc_smb1_close_request(SMB_Header* h, SMB1_close_request* val);
    bool proc_smb1_create_directory_request(SMB_Header* header, SMB1_create_directory_request* val);
    bool proc_smb1_create_directory_response(SMB_Header* header, SMB1_create_directory_response* val);
    bool proc_smb1_echo_request(SMB_Header* header, SMB1_echo_request* val);
    bool proc_smb1_echo_response(SMB_Header* header, SMB1_echo_response* val);
    bool proc_smb1_locking_andx_request(SMB_Header* header, SMB1_locking_andx_request* val);
    bool proc_smb1_locking_andx_response(SMB_Header* header, SMB1_locking_andx_response* val);
    bool proc_smb1_logoff_andx(SMB_Header* header, SMB1_logoff_andx* val);
    bool proc_smb1_negotiate_request(SMB_Header* header, SMB1_negotiate_request* val);
    bool proc_smb1_negotiate_response(SMB_Header* header, SMB1_negotiate_response* val);
    bool proc_smb1_nt_cancel_request(SMB_Header* header, SMB1_nt_cancel_request* val);
    bool proc_smb1_nt_create_andx_request(SMB_Header* header, SMB1_nt_create_andx_request* val);
    bool proc_smb1_nt_create_andx_response(SMB_Header* header, SMB1_nt_create_andx_response* val);
    bool proc_smb1_nt_transact_request(SMB_Header* header, SMB1_nt_transact_request* val);
    bool proc_smb1_nt_transact_response(SMB_Header* header, SMB1_nt_transact_response* val);
    bool proc_smb1_query_information_request(SMB_Header* header, SMB1_query_information_request* val);
    bool proc_smb1_query_information_response(SMB_Header* header, SMB1_query_information_response* val);
    bool proc_smb1_read_andx_request(SMB_Header* h, SMB1_read_andx_request* val);
    bool proc_smb1_read_andx_response(SMB_Header* h, SMB1_read_andx_response* val);
    bool proc_smb1_session_setup_andx_request(SMB_Header* header, SMB1_session_setup_andx_request* val);
    bool proc_smb1_session_setup_andx_response(SMB_Header* header, SMB1_session_setup_andx_response* val);
    bool proc_smb1_transaction_secondary_request(SMB_Header* header, SMB1_transaction_secondary_request* val);
    bool get_is_file_a_pipe(uint16 id);
    bool set_is_file_a_pipe(uint16 id, bool is_it);
    bool proc_smb1_transaction_request(SMB_Header* header, SMB1_transaction_request* val);
    bool proc_smb1_transaction_response(SMB_Header* header, SMB1_transaction_response* val);
    bool proc_smb1_transaction2_request(SMB_Header* header, SMB1_transaction2_request* val);
    bool proc_smb1_transaction2_response(SMB_Header* header, SMB1_transaction2_response* val);
    bool proc_trans2_find_first2_request(SMB_Header* header, trans2_find_first2_request* val);
    bool proc_trans2_find_first2_response(SMB_Header* header, trans2_find_first2_response* val);
    bool proc_trans2_query_fs_info_request(SMB_Header* header, trans2_query_fs_info_request* val);
    bool proc_trans2_query_fs_info_response(SMB_Header* header, trans2_query_fs_info_response* val);
    bool proc_trans2_query_path_info_request(SMB_Header* header, trans2_query_path_info_request* val);
    bool proc_trans2_query_path_info_response(SMB_Header* header, trans2_query_path_info_response* val);
    bool proc_trans2_query_file_info_request(SMB_Header* header, trans2_query_file_info_request* val);
    bool proc_trans2_query_file_info_response(SMB_Header* header, trans2_query_file_info_response* val);
    bool proc_trans2_set_file_info_request(SMB_Header* header, trans2_set_file_info_request* val);
    bool proc_trans2_set_file_info_response(SMB_Header* header, trans2_set_file_info_response* val);
    bool proc_trans2_get_dfs_referral_request(SMB_Header* header, trans2_get_dfs_referral_request* val);
    bool proc_trans2_get_dfs_referral_response(SMB_Header* header, trans2_get_dfs_referral_response* val);
    bool proc_smb1_transaction2_secondary_request(SMB_Header* header, SMB1_transaction2_secondary_request* val);
    bool proc_smb1_tree_connect_andx_request(SMB_Header* header, SMB1_tree_connect_andx_request* val);
    bool proc_smb1_tree_connect_andx_response(SMB_Header* header, SMB1_tree_connect_andx_response* val);
    bool proc_smb1_tree_disconnect(SMB_Header* header, SMB1_tree_disconnect* val);
    bool proc_smb1_write_andx_request(SMB_Header* h, SMB1_write_andx_request* val);
    bool proc_smb1_write_andx_response(SMB_Header* h, SMB1_write_andx_response* val);
    bool proc_smb2_close_request(SMB2_Header* h, SMB2_close_request* val);
    bool proc_smb2_close_response(SMB2_Header* h, SMB2_close_response* val);
    bool proc_smb2_create_request(SMB2_Header* h, SMB2_create_request* val);
    bool proc_smb2_create_response(SMB2_Header* h, SMB2_create_response* val);
    uint64 get_ioctl_fid(uint64 message_id);
    bool proc_smb2_ioctl_request(SMB2_ioctl_request* val);
    bool proc_smb2_negotiate_request(SMB2_Header* h, SMB2_negotiate_request* val);
    bool proc_smb2_negotiate_response(SMB2_Header* h, SMB2_negotiate_response* val);
    uint64 get_file_id(uint64 message_id, bool forget);
    bool proc_smb2_read_request(SMB2_Header* h, SMB2_read_request* val);
    bool proc_smb2_read_response(SMB2_Header* h, SMB2_read_response* val);
    bool proc_smb2_session_setup_request(SMB2_Header* h, SMB2_session_setup_request* val);
    bool proc_smb2_session_setup_response(SMB2_Header* h, SMB2_session_setup_response* val);
    bool proc_smb2_set_info_request_file(SMB2_file_basic_info* val);
    bool proc_smb2_set_info_request_file_rename(SMB2_file_rename_info* val);
    bool proc_smb2_set_info_request_file_delete(SMB2_file_disposition_info* val);
    bool proc_smb2_set_info_request_file_allocation(SMB2_file_allocation_info* val);
    bool proc_smb2_set_info_request_file_endoffile(SMB2_file_endoffile_info* val);
    bool proc_smb2_set_info_request_file_fullea(SMB2_file_fullea_info* val);
    bool proc_smb2_set_info_request_file_link(SMB2_file_link_info* val);
    bool proc_smb2_set_info_request_file_mode(SMB2_file_mode_info* val);
    bool proc_smb2_set_info_request_file_pipe(SMB2_file_pipe_info* val);
    bool proc_smb2_set_info_request_file_position(SMB2_file_position_info* val);
    bool proc_smb2_set_info_request_file_shortname(SMB2_file_shortname_info* val);
    bool proc_smb2_set_info_request_file_validdatalength(SMB2_file_validdatalength_info* val);
    bool proc_smb2_set_info_request_file_fscontrol(SMB2_file_fscontrol_info* val);
    bool proc_smb2_set_info_request_file_fsobjectid(SMB2_file_fsobjectid_info* val);
    bool proc_smb2_tree_connect_request(SMB2_Header* header, SMB2_tree_connect_request* val);
    bool proc_smb2_tree_connect_response(SMB2_Header* header, SMB2_tree_connect_response* val);
    bool proc_smb2_tree_disconnect_request(SMB2_Header* header);
    bool proc_smb2_tree_disconnect_response(SMB2_Header* header);
    bool proc_smb2_write_request(SMB2_Header* h, SMB2_write_request* val);
    bool proc_smb2_write_response(SMB2_Header* h, SMB2_write_response* val);
    bool proc_smb2_transform_header(SMB2_transform_header* hdr);
    uint32 join_pid_bits(uint16 hi, uint16 lo);
    bool proc_smb_message(SMB_Header* h, bool is_orig);
    bool proc_smb_empty_response(SMB_Header* header);
    bool proc_smb_no_msg(SMB_Header* h, bool is_orig);
    int get_offset_len();
    bool proc_smb2_message(SMB2_Header* h, bool is_orig);
    uint64 get_request_tree_id(uint64 message_id);
    bool is_error_response(SMB2_Header* header, bool is_orig);

protected:

    // Additional members

		zeek::StringValPtr uint8s_to_stringval(std::vector<uint8_t>* data);
		zeek::StringValPtr extract_string(SMB_string* s);
		zeek::StringValPtr smb_string2stringval(SMB_string* s);
		zeek::StringValPtr smb2_string2stringval(SMB2_string* s);

		SMB_unicode_string* me;
	

		map<uint32,bool> tree_is_pipe_map;
		map<uint64,zeek::analyzer::dce_rpc::DCE_RPC_Analyzer*> fid_to_analyzer_map;
	

		zeek::analyzer::Analyzer *gssapi;
		zeek::analyzer::Analyzer *ntlm;
	

		// Track read offsets to provide correct
		// offsets for file manager.
		std::map<uint16,uint64> read_offsets;
	

		map<uint16, bool> is_file_a_pipe;

		static zeek::StringValPtr transaction_data_to_val(SMB1_transaction_data* payload);
	

		std::map<uint64,uint64> smb2_ioctl_fids;
	

		// Track read offsets to provide correct
		// offsets for file manager.
		std::map<uint64,uint64> smb2_read_offsets;
		std::map<uint64,uint64> smb2_read_fids;
	

		int offset_len;
	

		// Track tree_ids given in requests.  Sometimes the server doesn't
		// reply with the tree_id.  Index is message_id, yield is tree_id
		std::map<uint64,uint64> smb2_request_tree_id;
	
    SMB_Flow* upflow_;
    SMB_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class SMB_ascii_string final {
public:
    SMB_ascii_string();
    ~SMB_ascii_string();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    vector<uint8>* val() const { return val_; }
    int size() const	{ return val() ? val()->size() : 0; }
    uint8 operator[](int index) const { BINPAC_ASSERT(val()); return (*val())[index]; }

protected:
    vector<uint8>* val_;
    uint8 val__elem_;
};


class SMB_unicode_string final {
public:
    SMB_unicode_string(int offset);
    ~SMB_unicode_string();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    vector<uint8>* pad() const { return pad_; }
    bool prev() const { return prev_; }
    vector<uint8>* s() const { return s_; }
    int offset() const { return offset_; }
    int byteorder() const { return byteorder_; }

protected:
    vector<uint8>* pad_;
    uint8 pad__elem_;
    bool prev_;
    vector<uint8>* s_;
    uint8 s__elem_;
    int offset_;
    int byteorder_;
};


class SMB_string final {
public:
    SMB_string(bool unicode, int offset);
    ~SMB_string();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    SMB_unicode_string* u() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb-strings.pac:95:u", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return u_;
    }
    SMB_ascii_string* a() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb-strings.pac:96:a", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return a_;
    }
    bool unicode() const { return unicode_; }
    int offset() const { return offset_; }

protected:
    int val_case_index_;
    SMB_unicode_string* u_;
    SMB_ascii_string* a_;
    bool unicode_;
    int offset_;
};


class SMB2_string final {
public:
    SMB2_string(int len);
    ~SMB2_string();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    vector<uint8>* s() const { return s_; }
    int len() const { return len_; }

protected:
    vector<uint8>* s_;
    uint8 s__elem_;
    int len_;
};

TransactionType determine_transaction_type(SMB_Header* header, SMB_string* name);

double filetime2zeektime(uint64_t ts);
double time_from_lanman(uint32_t smb_time, uint32_t smb_date, uint16_t tz);

zeek::RecordValPtr SMB_BuildMACTimes(uint64_t modify, uint64_t access,
                                     uint64_t create, uint64_t change);


class SMB_timestamp32 final {
public:
    SMB_timestamp32();
    ~SMB_timestamp32();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 val() const { return val_; }

protected:
    uint32 val_;
};


class SMB_timestamp final {
public:
    SMB_timestamp();
    ~SMB_timestamp();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint64 val() const { return val_; }

protected:
    uint64 val_;
};


class SMB_MailSlot_message final {
public:
    SMB_MailSlot_message(bool unicode, uint16 byte_count);
    ~SMB_MailSlot_message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 opcode() const { return opcode_; }
    SMB_MailSlot_command* data() const { return data_; }
    bool unicode() const { return unicode_; }
    uint16 byte_count() const { return byte_count_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 opcode_;
    SMB_MailSlot_command* data_;
    bool unicode_;
    uint16 byte_count_;
    int byteorder_;
};


class SMB_MailSlot_command final {
public:
    SMB_MailSlot_command(bool unicode, uint8 code, uint16 byte_count);
    ~SMB_MailSlot_command();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SMB_MailSlot_host_announcement* announce() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb-mailslot.pac:22:announce", (int64)val_case_index(), "HOST_ANNOUNCEMENT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return announce_;
    }
    SMB_MailSlot_announcement_request* announce_req() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb-mailslot.pac:23:announce_req", (int64)val_case_index(), "ANNOUNCEMENT_REQUEST");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return announce_req_;
    }
    SMB_MailSlot_request_election* election_req() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb-mailslot.pac:24:election_req", (int64)val_case_index(), "REQUEST_ELECTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return election_req_;
    }
    SMB_MailSlot_get_backup_list_request* get_backup_req() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb-mailslot.pac:25:get_backup_req", (int64)val_case_index(), "GET_BACKUP_LIST_REQUEST");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return get_backup_req_;
    }
    SMB_MailSlot_get_backup_list_response* get_backup_resp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb-mailslot.pac:26:get_backup_resp", (int64)val_case_index(), "GET_BACKUP_LIST_RESPONSE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return get_backup_resp_;
    }
    SMB_MailSlot_domain_announcement* domain_announce() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)12):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb-mailslot.pac:27:domain_announce", (int64)val_case_index(), "DOMAIN_ANNOUNCEMENT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return domain_announce_;
    }
    SMB_MailSlot_local_master_announcement* lm_announce() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb-mailslot.pac:28:lm_announce", (int64)val_case_index(), "LOCAL_MASTER_ANNOUNCEMENT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return lm_announce_;
    }
    bytestring const& data() const {
        return data_;
    }
    bool unicode() const { return unicode_; }
    uint8 code() const { return code_; }
    uint16 byte_count() const { return byte_count_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 val_case_index_;
    SMB_MailSlot_host_announcement* announce_;
    SMB_MailSlot_announcement_request* announce_req_;
    SMB_MailSlot_request_election* election_req_;
    SMB_MailSlot_get_backup_list_request* get_backup_req_;
    SMB_MailSlot_get_backup_list_response* get_backup_resp_;
    SMB_MailSlot_domain_announcement* domain_announce_;
    SMB_MailSlot_local_master_announcement* lm_announce_;
    bytestring data_;
    bool unicode_;
    uint8 code_;
    uint16 byte_count_;
    int byteorder_;
};


class SMB_MailSlot_host_announcement final {
public:
    SMB_MailSlot_host_announcement(bool unicode);
    ~SMB_MailSlot_host_announcement();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 update_count() const { return update_count_; }
    uint32 periodicity() const { return periodicity_; }
    SMB_string* server_name() const { return server_name_; }
    uint8 os_major_ver() const { return os_major_ver_; }
    uint8 os_minor_ver() const { return os_minor_ver_; }
    uint32 server_type() const { return server_type_; }
    uint8 bro_major_ver() const { return bro_major_ver_; }
    uint8 bro_minor_ver() const { return bro_minor_ver_; }
    uint16 signature() const { return signature_; }
    SMB_string* comment() const { return comment_; }
    bool unicode() const { return unicode_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 update_count_;
    uint32 periodicity_;
    SMB_string* server_name_;
    uint8 os_major_ver_;
    uint8 os_minor_ver_;
    uint32 server_type_;
    uint8 bro_major_ver_;
    uint8 bro_minor_ver_;
    uint16 signature_;
    SMB_string* comment_;
    bool unicode_;
    int byteorder_;
};


class SMB_MailSlot_announcement_request final {
public:
    SMB_MailSlot_announcement_request(bool unicode);
    ~SMB_MailSlot_announcement_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 unused() const { return unused_; }
    SMB_string* response_name() const { return response_name_; }
    bool unicode() const { return unicode_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 unused_;
    SMB_string* response_name_;
    bool unicode_;
    int byteorder_;
};


class SMB_MailSlot_request_election final {
public:
    SMB_MailSlot_request_election(bool unicode);
    ~SMB_MailSlot_request_election();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 version() const { return version_; }
    uint32 criteria() const { return criteria_; }
    uint32 uptime() const { return uptime_; }
    uint32 reserved() const { return reserved_; }
    SMB_string* server_name() const { return server_name_; }
    bool unicode() const { return unicode_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 version_;
    uint32 criteria_;
    uint32 uptime_;
    uint32 reserved_;
    SMB_string* server_name_;
    bool unicode_;
    int byteorder_;
};


class SMB_MailSlot_get_backup_list_request final {
public:
    SMB_MailSlot_get_backup_list_request(bool unicode);
    ~SMB_MailSlot_get_backup_list_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 req_count() const { return req_count_; }
    uint32 token() const { return token_; }
    bool unicode() const { return unicode_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 req_count_;
    uint32 token_;
    bool unicode_;
    int byteorder_;
};


class SMB_MailSlot_get_backup_list_response final {
public:
    SMB_MailSlot_get_backup_list_response(bool unicode);
    ~SMB_MailSlot_get_backup_list_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 backup_count() const { return backup_count_; }
    uint32 token() const { return token_; }
    SMB_string* backup_list() const { return backup_list_; }
    bool unicode() const { return unicode_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 backup_count_;
    uint32 token_;
    SMB_string* backup_list_;
    bool unicode_;
    int byteorder_;
};


class SMB_MailSlot_domain_announcement final {
public:
    SMB_MailSlot_domain_announcement(bool unicode);
    ~SMB_MailSlot_domain_announcement();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 update_count() const { return update_count_; }
    uint32 periodicity() const { return periodicity_; }
    SMB_string* server_name() const { return server_name_; }
    uint8 os_major_ver() const { return os_major_ver_; }
    uint8 os_minor_ver() const { return os_minor_ver_; }
    uint32 server_type() const { return server_type_; }
    uint8 bro_major_ver() const { return bro_major_ver_; }
    uint8 bro_minor_ver() const { return bro_minor_ver_; }
    uint16 signature() const { return signature_; }
    SMB_string* comment() const { return comment_; }
    bool unicode() const { return unicode_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 update_count_;
    uint32 periodicity_;
    SMB_string* server_name_;
    uint8 os_major_ver_;
    uint8 os_minor_ver_;
    uint32 server_type_;
    uint8 bro_major_ver_;
    uint8 bro_minor_ver_;
    uint16 signature_;
    SMB_string* comment_;
    bool unicode_;
    int byteorder_;
};


class SMB_MailSlot_local_master_announcement final {
public:
    SMB_MailSlot_local_master_announcement(bool unicode);
    ~SMB_MailSlot_local_master_announcement();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 update_count() const { return update_count_; }
    uint32 periodicity() const { return periodicity_; }
    SMB_string* server_name() const { return server_name_; }
    uint8 os_major_ver() const { return os_major_ver_; }
    uint8 os_minor_ver() const { return os_minor_ver_; }
    uint32 server_type() const { return server_type_; }
    uint8 bro_major_ver() const { return bro_major_ver_; }
    uint8 bro_minor_ver() const { return bro_minor_ver_; }
    uint16 signature() const { return signature_; }
    SMB_string* comment() const { return comment_; }
    bool unicode() const { return unicode_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 update_count_;
    uint32 periodicity_;
    SMB_string* server_name_;
    uint8 os_major_ver_;
    uint8 os_minor_ver_;
    uint32 server_type_;
    uint8 bro_major_ver_;
    uint8 bro_minor_ver_;
    uint16 signature_;
    SMB_string* comment_;
    bool unicode_;
    int byteorder_;
};


class SMB1_check_directory_request final {
public:
    SMB1_check_directory_request(SMB_Header* header);
    ~SMB1_check_directory_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 byte_count() const { return byte_count_; }
    uint8 buffer_format() const { return buffer_format_; }
    SMB_string* directory_name() const { return directory_name_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 byte_count_;
    uint8 buffer_format_;
    SMB_string* directory_name_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_check_directory_response final {
public:
    SMB1_check_directory_response(SMB_Header* header);
    ~SMB1_check_directory_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 byte_count_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_close_request final {
public:
    SMB1_close_request(SMB_Header* header);
    ~SMB1_close_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 file_id() const { return file_id_; }
    uint32 last_modified_time() const { return last_modified_time_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 file_id_;
    uint32 last_modified_time_;
    uint16 byte_count_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_create_directory_request final {
public:
    SMB1_create_directory_request(SMB_Header* header);
    ~SMB1_create_directory_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 byte_count() const { return byte_count_; }
    uint8 buffer_format() const { return buffer_format_; }
    SMB_string* directory_name() const { return directory_name_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 byte_count_;
    uint8 buffer_format_;
    SMB_string* directory_name_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_create_directory_response final {
public:
    SMB1_create_directory_response(SMB_Header* header);
    ~SMB1_create_directory_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 byte_count_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_echo_request final {
public:
    SMB1_echo_request(SMB_Header* header);
    ~SMB1_echo_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 echo_count() const { return echo_count_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& data() const { return data_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 echo_count_;
    uint16 byte_count_;
    bytestring data_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_echo_response final {
public:
    SMB1_echo_response(SMB_Header* header);
    ~SMB1_echo_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 seq_num() const { return seq_num_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& data() const { return data_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 seq_num_;
    uint16 byte_count_;
    bytestring data_;
    SMB_Header* header_;
    bool proc_;
};


class LOCKING_ANDX_RANGE32 final {
public:
    LOCKING_ANDX_RANGE32();
    ~LOCKING_ANDX_RANGE32();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 pid() const { return pid_; }
    uint32 byte_offset() const { return byte_offset_; }
    uint32 byte_len() const { return byte_len_; }

protected:
    uint16 pid_;
    uint32 byte_offset_;
    uint32 byte_len_;
};


class LOCKING_ANDX_RANGE64 final {
public:
    LOCKING_ANDX_RANGE64();
    ~LOCKING_ANDX_RANGE64();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 pid() const { return pid_; }
    uint16 pad() const { return pad_; }
    uint64 byte_offset() const { return byte_offset_; }
    uint64 byte_len() const { return byte_len_; }

protected:
    uint16 pid_;
    uint16 pad_;
    uint64 byte_offset_;
    uint64 byte_len_;
};


class SMB1_locking_andx_request final {
public:
    SMB1_locking_andx_request(SMB_Header* header, uint16 offset);
    ~SMB1_locking_andx_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_andx* andx() const { return andx_; }
    uint16 file_id() const { return file_id_; }
    uint8 type_of_lock() const { return type_of_lock_; }
    uint8 new_op_lock_level() const { return new_op_lock_level_; }
    uint32 timeout() const { return timeout_; }
    uint16 num_requested_unlocks() const { return num_requested_unlocks_; }
    uint16 num_requested_locks() const { return num_requested_locks_; }
    uint16 bytecount() const { return bytecount_; }
    int unlocks_case_index() const	{ return unlocks_case_index_; }
    vector<LOCKING_ANDX_RANGE32*>* unlocks32() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( unlocks_case_index() ) {
            case ((int)32):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-locking-andx.pac:43:unlocks32", (int64)unlocks_case_index(), "((int) 32)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return unlocks32_;
    }
    vector<LOCKING_ANDX_RANGE64*>* unlocks64() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( unlocks_case_index() ) {
            case ((int)64):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-locking-andx.pac:44:unlocks64", (int64)unlocks_case_index(), "((int) 64)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return unlocks64_;
    }
    int locks_case_index() const	{ return locks_case_index_; }
    vector<LOCKING_ANDX_RANGE32*>* locks32() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( locks_case_index() ) {
            case ((int)32):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-locking-andx.pac:47:locks32", (int64)locks_case_index(), "((int) 32)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return locks32_;
    }
    vector<LOCKING_ANDX_RANGE64*>* locks64() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( locks_case_index() ) {
            case ((int)64):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-locking-andx.pac:48:locks64", (int64)locks_case_index(), "((int) 64)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return locks64_;
    }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_andx* andx_;
    uint16 file_id_;
    uint8 type_of_lock_;
    uint8 new_op_lock_level_;
    uint32 timeout_;
    uint16 num_requested_unlocks_;
    uint16 num_requested_locks_;
    uint16 bytecount_;
    int unlocks_case_index_;
    vector<LOCKING_ANDX_RANGE32*>* unlocks32_;
    LOCKING_ANDX_RANGE32* unlocks32__elem_;
    vector<LOCKING_ANDX_RANGE64*>* unlocks64_;
    LOCKING_ANDX_RANGE64* unlocks64__elem_;
    int locks_case_index_;
    vector<LOCKING_ANDX_RANGE32*>* locks32_;
    LOCKING_ANDX_RANGE32* locks32__elem_;
    vector<LOCKING_ANDX_RANGE64*>* locks64_;
    LOCKING_ANDX_RANGE64* locks64__elem_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    bool proc_;
};


class SMB1_locking_andx_response final {
public:
    SMB1_locking_andx_response(SMB_Header* header);
    ~SMB1_locking_andx_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    SMB_Header* header_;
    bool proc_;
};


class SMB1_logoff_andx final {
public:
    SMB1_logoff_andx(SMB_Header* header, uint16 offset, bool is_orig);
    ~SMB1_logoff_andx();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_andx* andx() const { return andx_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_andx* andx_;
    uint16 byte_count_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    bool is_orig_;
    bool proc_;
};


class SMB_dialect final {
public:
    SMB_dialect();
    ~SMB_dialect();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 buffer_format() const { return buffer_format_; }
    SMB_string* name() const { return name_; }

protected:
    uint8 buffer_format_;
    SMB_string* name_;
};


class SMB1_negotiate_request final {
public:
    SMB1_negotiate_request(SMB_Header* header);
    ~SMB1_negotiate_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 byte_count() const { return byte_count_; }
    vector<SMB_dialect*>* dialects() const { return dialects_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 byte_count_;
    vector<SMB_dialect*>* dialects_;
    SMB_dialect* dialects__elem_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_negotiate_response final {
public:
    SMB1_negotiate_response(SMB_Header* header);
    ~SMB1_negotiate_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 dialect_index() const { return dialect_index_; }
    uint8 response_case_index() const	{ return response_case_index_; }
    SMB1_negotiate_core_response* core() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( response_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-negotiate.pac:165:core", (int64)response_case_index(), "((int) 0x01)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return core_;
    }
    SMB1_negotiate_lanman_response* lanman() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( response_case_index() ) {
            case ((uint8)13):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-negotiate.pac:166:lanman", (int64)response_case_index(), "((int) 0x0d)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return lanman_;
    }
    SMB1_negotiate_ntlm_response* ntlm() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( response_case_index() ) {
            case ((uint8)17):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-negotiate.pac:167:ntlm", (int64)response_case_index(), "((int) 0x11)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ntlm_;
    }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 dialect_index_;
    uint8 response_case_index_;
    SMB1_negotiate_core_response* core_;
    SMB1_negotiate_lanman_response* lanman_;
    SMB1_negotiate_ntlm_response* ntlm_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_negotiate_core_response final {
public:
    SMB1_negotiate_core_response();
    ~SMB1_negotiate_core_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 byte_count() const { return byte_count_; }

protected:
    uint16 byte_count_;
};


class SMB1_negotiate_lanman_response final {
public:
    SMB1_negotiate_lanman_response(SMB_Header* header);
    ~SMB1_negotiate_lanman_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 security_flags() const { return security_flags_; }
    uint16 max_buffer_size() const { return max_buffer_size_; }
    uint16 max_mpx_count() const { return max_mpx_count_; }
    uint16 max_number_vcs() const { return max_number_vcs_; }
    uint16 raw_mode() const { return raw_mode_; }
    uint32 session_key() const { return session_key_; }
    uint16 server_time() const { return server_time_; }
    uint16 server_date() const { return server_date_; }
    uint16 server_tz() const { return server_tz_; }
    uint16 encryption_key_length() const { return encryption_key_length_; }
    uint16 reserved() const { return reserved_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& encryption_key() const { return encryption_key_; }
    SMB_string* primary_domain() const { return primary_domain_; }
    SMB_Header* header() const { return header_; }
    bool security_user_level() const { return security_user_level_; }
    bool security_challenge_response() const { return security_challenge_response_; }
    bool raw_read_supported() const { return raw_read_supported_; }
    bool raw_write_supported() const { return raw_write_supported_; }

protected:
    uint16 security_flags_;
    uint16 max_buffer_size_;
    uint16 max_mpx_count_;
    uint16 max_number_vcs_;
    uint16 raw_mode_;
    uint32 session_key_;
    uint16 server_time_;
    uint16 server_date_;
    uint16 server_tz_;
    uint16 encryption_key_length_;
    uint16 reserved_;
    uint16 byte_count_;
    bytestring encryption_key_;
    SMB_string* primary_domain_;
    SMB_Header* header_;
    bool security_user_level_;
    bool security_challenge_response_;
    bool raw_read_supported_;
    bool raw_write_supported_;
};


class SMB1_negotiate_ntlm_response final {
public:
    SMB1_negotiate_ntlm_response(SMB_Header* header);
    ~SMB1_negotiate_ntlm_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 security_flags() const { return security_flags_; }
    uint16 max_mpx_count() const { return max_mpx_count_; }
    uint16 max_number_vcs() const { return max_number_vcs_; }
    uint32 max_buffer_size() const { return max_buffer_size_; }
    uint32 max_raw_size() const { return max_raw_size_; }
    uint32 session_key() const { return session_key_; }
    uint32 capabilities() const { return capabilities_; }
    uint64 server_time() const { return server_time_; }
    uint16 server_tz() const { return server_tz_; }
    uint8 encryption_key_length() const { return encryption_key_length_; }
    uint16 byte_count() const { return byte_count_; }
    int encryption_key_present_case_index() const	{ return encryption_key_present_case_index_; }
    bytestring const& encryption_key() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( encryption_key_present_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-negotiate.pac:212:encryption_key", (int64)encryption_key_present_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return encryption_key_;
    }
    int domain_name_present_case_index() const	{ return domain_name_present_case_index_; }
    SMB_string* domain_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( domain_name_present_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-negotiate.pac:216:domain_name", (int64)domain_name_present_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return domain_name_;
    }
    int server_guid_present_case_index() const	{ return server_guid_present_case_index_; }
    bytestring const& server_guid() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( server_guid_present_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-negotiate.pac:220:server_guid", (int64)server_guid_present_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_guid_;
    }
    int security_blob_present_case_index() const	{ return security_blob_present_case_index_; }
    bytestring const& security_blob() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( security_blob_present_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-negotiate.pac:224:security_blob", (int64)security_blob_present_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return security_blob_;
    }
    SMB_Header* header() const { return header_; }
    bool security_user_level() const { return security_user_level_; }
    bool security_challenge_response() const { return security_challenge_response_; }
    bool security_signatures_enabled() const { return security_signatures_enabled_; }
    bool security_signatures_required() const { return security_signatures_required_; }
    bool capabilities_raw_mode() const { return capabilities_raw_mode_; }
    bool capabilities_mpx_mode() const { return capabilities_mpx_mode_; }
    bool capabilities_unicode() const { return capabilities_unicode_; }
    bool capabilities_large_files() const { return capabilities_large_files_; }
    bool capabilities_nt_smbs() const { return capabilities_nt_smbs_; }
    bool capabilities_rpc_remote_apis() const { return capabilities_rpc_remote_apis_; }
    bool capabilities_status32() const { return capabilities_status32_; }
    bool capabilities_level_2_oplocks() const { return capabilities_level_2_oplocks_; }
    bool capabilities_lock_and_read() const { return capabilities_lock_and_read_; }
    bool capabilities_nt_find() const { return capabilities_nt_find_; }
    bool capabilities_dfs() const { return capabilities_dfs_; }
    bool capabilities_infolevel_passthru() const { return capabilities_infolevel_passthru_; }
    bool capabilities_large_readx() const { return capabilities_large_readx_; }
    bool capabilities_large_writex() const { return capabilities_large_writex_; }
    bool capabilities_unix() const { return capabilities_unix_; }
    bool capabilities_reserved() const { return capabilities_reserved_; }
    bool capabilities_bulk_transfer() const { return capabilities_bulk_transfer_; }
    bool capabilities_compressed_data() const { return capabilities_compressed_data_; }
    bool capabilities_extended_security() const { return capabilities_extended_security_; }
    bool gssapi_proc() const { BINPAC_ASSERT(has_gssapi_proc()); return gssapi_proc_; }
    bool has_gssapi_proc() const { return has_gssapi_proc_; }

protected:
    uint8 security_flags_;
    uint16 max_mpx_count_;
    uint16 max_number_vcs_;
    uint32 max_buffer_size_;
    uint32 max_raw_size_;
    uint32 session_key_;
    uint32 capabilities_;
    uint64 server_time_;
    uint16 server_tz_;
    uint8 encryption_key_length_;
    uint16 byte_count_;
    int encryption_key_present_case_index_;
    bytestring encryption_key_;
    int domain_name_present_case_index_;
    SMB_string* domain_name_;
    int server_guid_present_case_index_;
    bytestring server_guid_;
    int security_blob_present_case_index_;
    bytestring security_blob_;
    SMB_Header* header_;
    bool security_user_level_;
    bool security_challenge_response_;
    bool security_signatures_enabled_;
    bool security_signatures_required_;
    bool capabilities_raw_mode_;
    bool capabilities_mpx_mode_;
    bool capabilities_unicode_;
    bool capabilities_large_files_;
    bool capabilities_nt_smbs_;
    bool capabilities_rpc_remote_apis_;
    bool capabilities_status32_;
    bool capabilities_level_2_oplocks_;
    bool capabilities_lock_and_read_;
    bool capabilities_nt_find_;
    bool capabilities_dfs_;
    bool capabilities_infolevel_passthru_;
    bool capabilities_large_readx_;
    bool capabilities_large_writex_;
    bool capabilities_unix_;
    bool capabilities_reserved_;
    bool capabilities_bulk_transfer_;
    bool capabilities_compressed_data_;
    bool capabilities_extended_security_;
    bool gssapi_proc_;
    bool has_gssapi_proc_;
};


class SMB1_nt_cancel_request final {
public:
    SMB1_nt_cancel_request(SMB_Header* header);
    ~SMB1_nt_cancel_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 byte_count_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_nt_create_andx_request final {
public:
    SMB1_nt_create_andx_request(SMB_Header* header, uint16 offset);
    ~SMB1_nt_create_andx_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_andx* andx() const { return andx_; }
    uint8 reserved() const { return reserved_; }
    uint16 name_length() const { return name_length_; }
    uint32 flags() const { return flags_; }
    uint32 root_dir_file_id() const { return root_dir_file_id_; }
    uint32 desired_access() const { return desired_access_; }
    uint64 alloc_size() const { return alloc_size_; }
    uint32 ext_file_attrs() const { return ext_file_attrs_; }
    uint32 share_access() const { return share_access_; }
    uint32 create_disposition() const { return create_disposition_; }
    uint32 create_options() const { return create_options_; }
    uint32 impersonation_level() const { return impersonation_level_; }
    uint8 security_flags() const { return security_flags_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_string* filename() const { return filename_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_andx* andx_;
    uint8 reserved_;
    uint16 name_length_;
    uint32 flags_;
    uint32 root_dir_file_id_;
    uint32 desired_access_;
    uint64 alloc_size_;
    uint32 ext_file_attrs_;
    uint32 share_access_;
    uint32 create_disposition_;
    uint32 create_options_;
    uint32 impersonation_level_;
    uint8 security_flags_;
    uint16 byte_count_;
    SMB_string* filename_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    bool proc_;
};


class SMB1_nt_create_andx_response final {
public:
    SMB1_nt_create_andx_response(SMB_Header* header, uint16 offset);
    ~SMB1_nt_create_andx_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_andx* andx() const { return andx_; }
    uint8 oplock_level() const { return oplock_level_; }
    uint16 file_id() const { return file_id_; }
    uint32 create_disposition() const { return create_disposition_; }
    uint64 create_time() const { return create_time_; }
    uint64 last_access_time() const { return last_access_time_; }
    uint64 last_write_time() const { return last_write_time_; }
    uint64 last_change_time() const { return last_change_time_; }
    uint32 ext_file_attrs() const { return ext_file_attrs_; }
    uint64 allocation_size() const { return allocation_size_; }
    uint64 end_of_file() const { return end_of_file_; }
    uint16 resource_type() const { return resource_type_; }
    uint16 nm_pipe_status() const { return nm_pipe_status_; }
    uint8 directory() const { return directory_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_andx* andx_;
    uint8 oplock_level_;
    uint16 file_id_;
    uint32 create_disposition_;
    uint64 create_time_;
    uint64 last_access_time_;
    uint64 last_write_time_;
    uint64 last_change_time_;
    uint32 ext_file_attrs_;
    uint64 allocation_size_;
    uint64 end_of_file_;
    uint16 resource_type_;
    uint16 nm_pipe_status_;
    uint8 directory_;
    uint16 byte_count_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    bool proc_;
};


class SMB1_nt_transact_request final {
public:
    SMB1_nt_transact_request(SMB_Header* header);
    ~SMB1_nt_transact_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_nt_transact_response final {
public:
    SMB1_nt_transact_response(SMB_Header* header);
    ~SMB1_nt_transact_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_query_information_request final {
public:
    SMB1_query_information_request(SMB_Header* header);
    ~SMB1_query_information_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 byte_count() const { return byte_count_; }
    uint8 buffer_format() const { return buffer_format_; }
    SMB_string* filename() const { return filename_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 byte_count_;
    uint8 buffer_format_;
    SMB_string* filename_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_query_information_response final {
public:
    SMB1_query_information_response(SMB_Header* header);
    ~SMB1_query_information_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 file_attribs() const { return file_attribs_; }
    uint32 last_write_time() const { return last_write_time_; }
    uint32 file_size() const { return file_size_; }
    vector<uint16>* reserved() const { return reserved_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 file_attribs_;
    uint32 last_write_time_;
    uint32 file_size_;
    vector<uint16>* reserved_;
    uint16 reserved__elem_;
    uint16 byte_count_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_read_andx_request final {
public:
    SMB1_read_andx_request(SMB_Header* header, uint16 offset);
    ~SMB1_read_andx_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_andx* andx() const { return andx_; }
    uint16 file_id() const { return file_id_; }
    uint32 offset_low() const { return offset_low_; }
    uint16 max_count_low() const { return max_count_low_; }
    uint16 min_count() const { return min_count_; }
    uint32 max_count_high() const { return max_count_high_; }
    uint16 remaining() const { return remaining_; }
    uint8 offset_high_u_case_index() const	{ return offset_high_u_case_index_; }
    uint32 offset_high_tmp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( offset_high_u_case_index() ) {
            case ((uint8)12):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-read-andx.pac:59:offset_high_tmp", (int64)offset_high_u_case_index(), "((int) 0x0C)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return offset_high_tmp_;
    }
    uint16 byte_count() const { return byte_count_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    int byteorder() const { return byteorder_; }
    uint64 offset_high_64() const { return offset_high_64_; }
    uint32 offset_high() const { return offset_high_; }
    uint64 read_offset() const { return read_offset_; }
    uint64 max_count_high_64() const { return max_count_high_64_; }
    uint64 max_count() const { return max_count_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_andx* andx_;
    uint16 file_id_;
    uint32 offset_low_;
    uint16 max_count_low_;
    uint16 min_count_;
    uint32 max_count_high_;
    uint16 remaining_;
    uint8 offset_high_u_case_index_;
    uint32 offset_high_tmp_;
    uint16 byte_count_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    int byteorder_;
    uint64 offset_high_64_;
    uint32 offset_high_;
    uint64 read_offset_;
    uint64 max_count_high_64_;
    uint64 max_count_;
    bool proc_;
};


class SMB1_read_andx_response final {
public:
    SMB1_read_andx_response(SMB_Header* header, uint16 offset);
    ~SMB1_read_andx_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_andx* andx() const { return andx_; }
    uint16 available() const { return available_; }
    uint16 data_compact_mode() const { return data_compact_mode_; }
    uint16 reserved1() const { return reserved1_; }
    uint16 data_len_low() const { return data_len_low_; }
    uint16 data_offset() const { return data_offset_; }
    uint16 data_len_high() const { return data_len_high_; }
    uint64 reserved2() const { return reserved2_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& data() const { return data_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    int byteorder() const { return byteorder_; }
    bool pipe_proc() const { BINPAC_ASSERT(has_pipe_proc()); return pipe_proc_; }
    bool has_pipe_proc() const { return has_pipe_proc_; }
    uint8 padding_len() const { return padding_len_; }
    uint32 data_len() const { return data_len_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_andx* andx_;
    uint16 available_;
    uint16 data_compact_mode_;
    uint16 reserved1_;
    uint16 data_len_low_;
    uint16 data_offset_;
    uint16 data_len_high_;
    uint64 reserved2_;
    uint16 byte_count_;
    bytestring data_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    int byteorder_;
    bool pipe_proc_;
    bool has_pipe_proc_;
    uint8 padding_len_;
    uint32 data_len_;
    bool proc_;
};


class SMB1_session_setup_andx_request final {
public:
    SMB1_session_setup_andx_request(SMB_Header* header, uint16 offset);
    ~SMB1_session_setup_andx_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint8 lanman_or_ntlm_case_index() const	{ return lanman_or_ntlm_case_index_; }
    SMB1_session_setup_andx_request_lanman* lanman() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( lanman_or_ntlm_case_index() ) {
            case ((uint8)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:129:lanman", (int64)lanman_or_ntlm_case_index(), "((int) 0x0a)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return lanman_;
    }
    SMB1_session_setup_andx_request_ntlm_extended_security* ntlm_extended_security() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( lanman_or_ntlm_case_index() ) {
            case ((uint8)12):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:130:ntlm_extended_security", (int64)lanman_or_ntlm_case_index(), "((int) 0x0c)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ntlm_extended_security_;
    }
    SMB1_session_setup_andx_request_ntlm_nonextended_security* ntlm_nonextended_security() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( lanman_or_ntlm_case_index() ) {
            case ((uint8)13):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:131:ntlm_nonextended_security", (int64)lanman_or_ntlm_case_index(), "((int) 0x0d)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ntlm_nonextended_security_;
    }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint8 lanman_or_ntlm_case_index_;
    SMB1_session_setup_andx_request_lanman* lanman_;
    SMB1_session_setup_andx_request_ntlm_extended_security* ntlm_extended_security_;
    SMB1_session_setup_andx_request_ntlm_nonextended_security* ntlm_nonextended_security_;
    SMB_Header* header_;
    uint16 offset_;
    bool proc_;
};


class SMB1_session_setup_andx_response final {
public:
    SMB1_session_setup_andx_response(SMB_Header* header, uint16 offset);
    ~SMB1_session_setup_andx_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint8 lanman_or_ntlm_case_index() const	{ return lanman_or_ntlm_case_index_; }
    SMB1_session_setup_andx_response_lanman* lanman() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( lanman_or_ntlm_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:140:lanman", (int64)lanman_or_ntlm_case_index(), "((int) 0x03)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return lanman_;
    }
    SMB1_session_setup_andx_response_ntlm* ntlm() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( lanman_or_ntlm_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:141:ntlm", (int64)lanman_or_ntlm_case_index(), "((int) 0x04)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ntlm_;
    }
    uint16 error() const {
        return error_;
    }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint8 lanman_or_ntlm_case_index_;
    SMB1_session_setup_andx_response_lanman* lanman_;
    SMB1_session_setup_andx_response_ntlm* ntlm_;
    uint16 error_;
    SMB_Header* header_;
    uint16 offset_;
    bool proc_;
};


class SMB1_session_setup_andx_request_lanman final {
public:
    SMB1_session_setup_andx_request_lanman(SMB_Header* header, uint16 offset);
    ~SMB1_session_setup_andx_request_lanman();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    SMB_andx* andx() const { return andx_; }
    uint16 max_buffer_size() const { return max_buffer_size_; }
    uint16 max_mpx_count() const { return max_mpx_count_; }
    uint16 vc_number() const { return vc_number_; }
    uint32 session_key() const { return session_key_; }
    uint16 password_length() const { return password_length_; }
    uint32 reserved() const { return reserved_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& account_password() const { return account_password_; }
    SMB_string* account_name() const { return account_name_; }
    SMB_string* primary_domain() const { return primary_domain_; }
    SMB_string* native_os() const { return native_os_; }
    SMB_string* native_lanman() const { return native_lanman_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }

protected:
    SMB_andx* andx_;
    uint16 max_buffer_size_;
    uint16 max_mpx_count_;
    uint16 vc_number_;
    uint32 session_key_;
    uint16 password_length_;
    uint32 reserved_;
    uint16 byte_count_;
    bytestring account_password_;
    SMB_string* account_name_;
    SMB_string* primary_domain_;
    SMB_string* native_os_;
    SMB_string* native_lanman_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
};


class SMB1_session_setup_andx_response_lanman final {
public:
    SMB1_session_setup_andx_response_lanman(SMB_Header* header, uint16 offset);
    ~SMB1_session_setup_andx_response_lanman();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    SMB_andx* andx() const { return andx_; }
    uint16 action() const { return action_; }
    uint16 byte_count() const { return byte_count_; }
    vector<SMB_string*>* native_os() const { return native_os_; }
    vector<SMB_string*>* native_lanman() const { return native_lanman_; }
    vector<SMB_string*>* primary_domain() const { return primary_domain_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool is_guest() const { return is_guest_; }

protected:
    SMB_andx* andx_;
    uint16 action_;
    uint16 byte_count_;
    vector<SMB_string*>* native_os_;
    SMB_string* native_os__elem_;
    vector<SMB_string*>* native_lanman_;
    SMB_string* native_lanman__elem_;
    vector<SMB_string*>* primary_domain_;
    SMB_string* primary_domain__elem_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    bool is_guest_;
};


class SMB1_session_setup_andx_request_ntlm_capabilities final {
public:
    SMB1_session_setup_andx_request_ntlm_capabilities();
    ~SMB1_session_setup_andx_request_ntlm_capabilities();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 capabilities() const { return capabilities_; }
    bool unicode() const { return unicode_; }
    bool large_files() const { return large_files_; }
    bool nt_smbs() const { return nt_smbs_; }
    bool status32() const { return status32_; }
    bool level_2_oplocks() const { return level_2_oplocks_; }
    bool nt_find() const { return nt_find_; }

protected:
    uint32 capabilities_;
    bool unicode_;
    bool large_files_;
    bool nt_smbs_;
    bool status32_;
    bool level_2_oplocks_;
    bool nt_find_;
};


class SMB1_session_setup_andx_request_ntlm_nonextended_security final {
public:
    SMB1_session_setup_andx_request_ntlm_nonextended_security(SMB_Header* header, uint16 offset);
    ~SMB1_session_setup_andx_request_ntlm_nonextended_security();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    SMB_andx* andx() const { return andx_; }
    uint16 max_buffer_size() const { return max_buffer_size_; }
    uint16 max_mpx_count() const { return max_mpx_count_; }
    uint16 vc_number() const { return vc_number_; }
    uint32 session_key() const { return session_key_; }
    uint16 case_insensitive_password_length() const { return case_insensitive_password_length_; }
    uint16 case_sensitive_password_length() const { return case_sensitive_password_length_; }
    uint32 reserved() const { return reserved_; }
    SMB1_session_setup_andx_request_ntlm_capabilities* capabilities() const { return capabilities_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& case_insensitive_password() const { return case_insensitive_password_; }
    bytestring const& case_sensitive_password() const { return case_sensitive_password_; }
    SMB_string* account_name() const { return account_name_; }
    SMB_string* primary_domain() const { return primary_domain_; }
    SMB_string* native_os() const { return native_os_; }
    SMB_string* native_lanman() const { return native_lanman_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }

protected:
    SMB_andx* andx_;
    uint16 max_buffer_size_;
    uint16 max_mpx_count_;
    uint16 vc_number_;
    uint32 session_key_;
    uint16 case_insensitive_password_length_;
    uint16 case_sensitive_password_length_;
    uint32 reserved_;
    SMB1_session_setup_andx_request_ntlm_capabilities* capabilities_;
    uint16 byte_count_;
    bytestring case_insensitive_password_;
    bytestring case_sensitive_password_;
    SMB_string* account_name_;
    SMB_string* primary_domain_;
    SMB_string* native_os_;
    SMB_string* native_lanman_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
};


class SMB1_session_setup_andx_request_ntlm_extended_security final {
public:
    SMB1_session_setup_andx_request_ntlm_extended_security(SMB_Header* header, uint16 offset);
    ~SMB1_session_setup_andx_request_ntlm_extended_security();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    SMB_andx* andx() const { return andx_; }
    uint16 max_buffer_size() const { return max_buffer_size_; }
    uint16 max_mpx_count() const { return max_mpx_count_; }
    uint16 vc_number() const { return vc_number_; }
    uint32 session_key() const { return session_key_; }
    uint16 security_blob_length() const { return security_blob_length_; }
    uint32 reserved() const { return reserved_; }
    SMB1_session_setup_andx_request_ntlm_capabilities* capabilities() const { return capabilities_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& security_blob() const { return security_blob_; }
    SMB_string* native_os() const { return native_os_; }
    SMB_string* native_lanman() const { return native_lanman_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool pipe_proc() const { return pipe_proc_; }

protected:
    SMB_andx* andx_;
    uint16 max_buffer_size_;
    uint16 max_mpx_count_;
    uint16 vc_number_;
    uint32 session_key_;
    uint16 security_blob_length_;
    uint32 reserved_;
    SMB1_session_setup_andx_request_ntlm_capabilities* capabilities_;
    uint16 byte_count_;
    bytestring security_blob_;
    SMB_string* native_os_;
    SMB_string* native_lanman_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    bool pipe_proc_;
};


class SMB1_session_setup_andx_response_ntlm final {
public:
    SMB1_session_setup_andx_response_ntlm(SMB_Header* header, uint16 offset);
    ~SMB1_session_setup_andx_response_ntlm();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    SMB_andx* andx() const { return andx_; }
    uint16 action() const { return action_; }
    uint16 security_blob_length() const { return security_blob_length_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& security_blob() const { return security_blob_; }
    SMB_string* native_os() const { return native_os_; }
    SMB_string* native_lanman() const { return native_lanman_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool is_guest() const { return is_guest_; }
    bool gssapi_proc() const { return gssapi_proc_; }

protected:
    SMB_andx* andx_;
    uint16 action_;
    uint16 security_blob_length_;
    uint16 byte_count_;
    bytestring security_blob_;
    SMB_string* native_os_;
    SMB_string* native_lanman_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    bool is_guest_;
    bool gssapi_proc_;
};


class SMB1_transaction_secondary_request final {
public:
    SMB1_transaction_secondary_request(SMB_Header* header);
    ~SMB1_transaction_secondary_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 total_param_count() const { return total_param_count_; }
    uint16 total_data_count() const { return total_data_count_; }
    uint16 param_count() const { return param_count_; }
    uint16 param_offset() const { return param_offset_; }
    uint16 param_displacement() const { return param_displacement_; }
    uint16 data_count() const { return data_count_; }
    uint16 data_offset() const { return data_offset_; }
    uint16 data_displacement() const { return data_displacement_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& parameters() const { return parameters_; }
    SMB1_transaction_data* data() const { return data_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 total_param_count_;
    uint16 total_data_count_;
    uint16 param_count_;
    uint16 param_offset_;
    uint16 param_displacement_;
    uint16 data_count_;
    uint16 data_offset_;
    uint16 data_displacement_;
    uint16 byte_count_;
    bytestring parameters_;
    SMB1_transaction_data* data_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_transaction_data final {
public:
    SMB1_transaction_data(SMB_Header* header, bool is_orig, uint16 count, uint16 sub_cmd, int trans_type, bool is_pipe);
    ~SMB1_transaction_data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    bytestring const& pipe_data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction.pac:105:pipe_data", (int64)val_case_index(), "SMB_PIPE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pipe_data_;
    }
    bytestring const& unknown() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction.pac:106:unknown", (int64)val_case_index(), "SMB_UNKNOWN");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return unknown_;
    }
    bytestring const& data() const {
        return data_;
    }
    SMB_Header* header() const { return header_; }
    bool is_orig() const { return is_orig_; }
    uint16 count() const { return count_; }
    uint16 sub_cmd() const { return sub_cmd_; }
    int trans_type() const { return trans_type_; }
    bool is_pipe() const { return is_pipe_; }
    bool pipe_proc() const { BINPAC_ASSERT(has_pipe_proc()); return pipe_proc_; }
    bool has_pipe_proc() const { return has_pipe_proc_; }

protected:
    int val_case_index_;
    bytestring pipe_data_;
    bytestring unknown_;
    bytestring data_;
    SMB_Header* header_;
    bool is_orig_;
    uint16 count_;
    uint16 sub_cmd_;
    int trans_type_;
    bool is_pipe_;
    bool pipe_proc_;
    bool has_pipe_proc_;
};


class SMB1_transaction_request final {
public:
    SMB1_transaction_request(SMB_Header* header);
    ~SMB1_transaction_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 total_param_count() const { return total_param_count_; }
    uint16 total_data_count() const { return total_data_count_; }
    uint16 max_param_count() const { return max_param_count_; }
    uint16 max_data_count() const { return max_data_count_; }
    uint8 max_setup_count() const { return max_setup_count_; }
    uint8 reserved1() const { return reserved1_; }
    uint16 flags() const { return flags_; }
    uint32 timeout() const { return timeout_; }
    uint16 reserved2() const { return reserved2_; }
    uint16 param_count() const { return param_count_; }
    uint16 param_offset() const { return param_offset_; }
    uint16 data_count() const { return data_count_; }
    uint16 data_offset() const { return data_offset_; }
    uint8 setup_count() const { return setup_count_; }
    uint8 reserved3() const { return reserved3_; }
    vector<uint16>* setup() const { return setup_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_string* name() const { return name_; }
    bytestring const& parameters() const { return parameters_; }
    SMB1_transaction_data* data() const { return data_; }
    SMB_Header* header() const { return header_; }
    uint16 sub_cmd() const { return sub_cmd_; }
    int transtype() const { return transtype_; }
    bool is_pipe() const { return is_pipe_; }
    bool proc_set_pipe() const { return proc_set_pipe_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 total_param_count_;
    uint16 total_data_count_;
    uint16 max_param_count_;
    uint16 max_data_count_;
    uint8 max_setup_count_;
    uint8 reserved1_;
    uint16 flags_;
    uint32 timeout_;
    uint16 reserved2_;
    uint16 param_count_;
    uint16 param_offset_;
    uint16 data_count_;
    uint16 data_offset_;
    uint8 setup_count_;
    uint8 reserved3_;
    vector<uint16>* setup_;
    uint16 setup__elem_;
    uint16 byte_count_;
    SMB_string* name_;
    bytestring parameters_;
    SMB1_transaction_data* data_;
    SMB_Header* header_;
    uint16 sub_cmd_;
    int transtype_;
    bool is_pipe_;
    bool proc_set_pipe_;
    bool proc_;
};


class SMB1_transaction_response final {
public:
    SMB1_transaction_response(SMB_Header* header);
    ~SMB1_transaction_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 total_param_count() const { return total_param_count_; }
    uint16 total_data_count() const { return total_data_count_; }
    uint16 reserved() const { return reserved_; }
    uint16 param_count() const { return param_count_; }
    uint16 param_offset() const { return param_offset_; }
    uint16 param_displacement() const { return param_displacement_; }
    uint16 data_count() const { return data_count_; }
    uint16 data_offset() const { return data_offset_; }
    uint16 data_displacement() const { return data_displacement_; }
    uint8 setup_count() const { return setup_count_; }
    uint8 reserved2() const { return reserved2_; }
    vector<uint16>* setup() const { return setup_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& parameters() const { return parameters_; }
    vector<SMB1_transaction_data*>* data() const { return data_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }
    bool is_pipe() const { return is_pipe_; }

protected:
    uint8 word_count_;
    uint16 total_param_count_;
    uint16 total_data_count_;
    uint16 reserved_;
    uint16 param_count_;
    uint16 param_offset_;
    uint16 param_displacement_;
    uint16 data_count_;
    uint16 data_offset_;
    uint16 data_displacement_;
    uint8 setup_count_;
    uint8 reserved2_;
    vector<uint16>* setup_;
    uint16 setup__elem_;
    uint16 byte_count_;
    bytestring parameters_;
    vector<SMB1_transaction_data*>* data_;
    SMB1_transaction_data* data__elem_;
    SMB_Header* header_;
    bool proc_;
    bool is_pipe_;
};


class SMB1_transaction2_request final {
public:
    SMB1_transaction2_request(SMB_Header* header);
    ~SMB1_transaction2_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 total_param_count() const { return total_param_count_; }
    uint16 total_data_count() const { return total_data_count_; }
    uint16 max_param_count() const { return max_param_count_; }
    uint16 max_data_count() const { return max_data_count_; }
    uint8 max_setup_count() const { return max_setup_count_; }
    uint8 reserved1() const { return reserved1_; }
    uint16 flags() const { return flags_; }
    uint32 timeout() const { return timeout_; }
    uint16 reserved2() const { return reserved2_; }
    uint16 param_count() const { return param_count_; }
    uint16 param_offset() const { return param_offset_; }
    uint16 data_count() const { return data_count_; }
    uint16 data_offset() const { return data_offset_; }
    uint8 setup_count() const { return setup_count_; }
    uint8 reserved3() const { return reserved3_; }
    uint16 sub_cmd() const { return sub_cmd_; }
    uint16 byte_count() const { return byte_count_; }
    uint16 parameters_case_index() const	{ return parameters_case_index_; }
    trans2_find_first2_request* find_first2() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( parameters_case_index() ) {
            case ((uint16)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2.pac:86:find_first2", (int64)parameters_case_index(), "TRANS2_FIND_FIRST2");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return find_first2_;
    }
    trans2_query_fs_info_request* query_fs_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( parameters_case_index() ) {
            case ((uint16)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2.pac:87:query_fs_info", (int64)parameters_case_index(), "TRANS2_QUERY_FS_INFORMATION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return query_fs_info_;
    }
    trans2_query_path_info_request* query_path_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( parameters_case_index() ) {
            case ((uint16)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2.pac:88:query_path_info", (int64)parameters_case_index(), "TRANS2_QUERY_PATH_INFORMATION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return query_path_info_;
    }
    trans2_query_file_info_request* query_file_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( parameters_case_index() ) {
            case ((uint16)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2.pac:89:query_file_info", (int64)parameters_case_index(), "TRANS2_QUERY_FILE_INFORMATION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return query_file_info_;
    }
    trans2_set_file_info_request* set_file_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( parameters_case_index() ) {
            case ((uint16)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2.pac:90:set_file_info", (int64)parameters_case_index(), "TRANS2_SET_FILE_INFORMATION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return set_file_info_;
    }
    trans2_get_dfs_referral_request* get_dfs_referral() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( parameters_case_index() ) {
            case ((uint16)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2.pac:91:get_dfs_referral", (int64)parameters_case_index(), "TRANS2_GET_DFS_REFERRAL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return get_dfs_referral_;
    }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 total_param_count_;
    uint16 total_data_count_;
    uint16 max_param_count_;
    uint16 max_data_count_;
    uint8 max_setup_count_;
    uint8 reserved1_;
    uint16 flags_;
    uint32 timeout_;
    uint16 reserved2_;
    uint16 param_count_;
    uint16 param_offset_;
    uint16 data_count_;
    uint16 data_offset_;
    uint8 setup_count_;
    uint8 reserved3_;
    uint16 sub_cmd_;
    uint16 byte_count_;
    uint16 parameters_case_index_;
    trans2_find_first2_request* find_first2_;
    trans2_query_fs_info_request* query_fs_info_;
    trans2_query_path_info_request* query_path_info_;
    trans2_query_file_info_request* query_file_info_;
    trans2_set_file_info_request* set_file_info_;
    trans2_get_dfs_referral_request* get_dfs_referral_;
    const_bytestring blah_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_transaction2_response final {
public:
    SMB1_transaction2_response(SMB_Header* header);
    ~SMB1_transaction2_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 total_param_count() const { return total_param_count_; }
    uint16 total_data_count() const { return total_data_count_; }
    uint16 reserved1() const { return reserved1_; }
    uint16 param_count() const { return param_count_; }
    uint16 param_offset() const { return param_offset_; }
    uint16 param_displacement() const { return param_displacement_; }
    uint16 data_count() const { return data_count_; }
    uint16 data_offset() const { return data_offset_; }
    uint16 data_displacement() const { return data_displacement_; }
    uint8 setup_count() const { return setup_count_; }
    uint8 reserved2() const { return reserved2_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& stuff() const { return stuff_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 total_param_count_;
    uint16 total_data_count_;
    uint16 reserved1_;
    uint16 param_count_;
    uint16 param_offset_;
    uint16 param_displacement_;
    uint16 data_count_;
    uint16 data_offset_;
    uint16 data_displacement_;
    uint8 setup_count_;
    uint8 reserved2_;
    uint16 byte_count_;
    bytestring stuff_;
    SMB_Header* header_;
    bool proc_;
};


class trans2_find_first2_request final {
public:
    trans2_find_first2_request(SMB_Header* header);
    ~trans2_find_first2_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 search_attrs() const { return search_attrs_; }
    uint16 search_count() const { return search_count_; }
    uint16 flags() const { return flags_; }
    uint16 info_level() const { return info_level_; }
    uint32 search_storage_type() const { return search_storage_type_; }
    SMB_string* file_name() const { return file_name_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 search_attrs_;
    uint16 search_count_;
    uint16 flags_;
    uint16 info_level_;
    uint32 search_storage_type_;
    SMB_string* file_name_;
    SMB_Header* header_;
    bool proc_;
};


class trans2_find_first2_response final {
public:
    trans2_find_first2_response(SMB_Header* header);
    ~trans2_find_first2_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 sid() const { return sid_; }
    uint16 search_count() const { return search_count_; }
    uint16 end_of_search() const { return end_of_search_; }
    uint16 ea_error_offset() const { return ea_error_offset_; }
    uint16 last_name_offset() const { return last_name_offset_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 sid_;
    uint16 search_count_;
    uint16 end_of_search_;
    uint16 ea_error_offset_;
    uint16 last_name_offset_;
    SMB_Header* header_;
    bool proc_;
};


class trans2_query_fs_info_request final {
public:
    trans2_query_fs_info_request(SMB_Header* header);
    ~trans2_query_fs_info_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    SMB_Header* header_;
    bool proc_;
};


class trans2_query_fs_info_response final {
public:
    trans2_query_fs_info_response(SMB_Header* header);
    ~trans2_query_fs_info_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    SMB_Header* header_;
    bool proc_;
};


class trans2_query_path_info_request final {
public:
    trans2_query_path_info_request(SMB_Header* header);
    ~trans2_query_path_info_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 information_level() const { return information_level_; }
    uint32 reserved() const { return reserved_; }
    SMB_string* file_name() const { return file_name_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 information_level_;
    uint32 reserved_;
    SMB_string* file_name_;
    SMB_Header* header_;
    bool proc_;
};


class trans2_query_path_info_response final {
public:
    trans2_query_path_info_response(SMB_Header* header);
    ~trans2_query_path_info_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    SMB_Header* header_;
    bool proc_;
};


class trans2_query_file_info_request final {
public:
    trans2_query_file_info_request(SMB_Header* header);
    ~trans2_query_file_info_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 file_id() const { return file_id_; }
    uint16 information_level() const { return information_level_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 file_id_;
    uint16 information_level_;
    SMB_Header* header_;
    bool proc_;
};


class trans2_query_file_info_response final {
public:
    trans2_query_file_info_response(SMB_Header* header);
    ~trans2_query_file_info_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    SMB_Header* header_;
    bool proc_;
};


class trans2_set_file_info_request final {
public:
    trans2_set_file_info_request(SMB_Header* header);
    ~trans2_set_file_info_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    SMB_Header* header_;
    bool proc_;
};


class trans2_set_file_info_response final {
public:
    trans2_set_file_info_response(SMB_Header* header);
    ~trans2_set_file_info_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    SMB_Header* header_;
    bool proc_;
};


class trans2_get_dfs_referral_request final {
public:
    trans2_get_dfs_referral_request(SMB_Header* header);
    ~trans2_get_dfs_referral_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 max_referral_level() const { return max_referral_level_; }
    SMB_string* file_name() const { return file_name_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 max_referral_level_;
    SMB_string* file_name_;
    SMB_Header* header_;
    bool proc_;
};


class trans2_get_dfs_referral_response final {
public:
    trans2_get_dfs_referral_response(SMB_Header* header);
    ~trans2_get_dfs_referral_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    SMB_Header* header_;
    bool proc_;
};


class SMB1_transaction2_secondary_request final {
public:
    SMB1_transaction2_secondary_request(SMB_Header* header);
    ~SMB1_transaction2_secondary_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 total_param_count() const { return total_param_count_; }
    uint16 total_data_count() const { return total_data_count_; }
    uint16 param_count() const { return param_count_; }
    uint16 param_offset() const { return param_offset_; }
    uint16 param_displacement() const { return param_displacement_; }
    uint16 data_count() const { return data_count_; }
    uint16 data_offset() const { return data_offset_; }
    uint16 data_displacement() const { return data_displacement_; }
    uint16 FID() const { return FID_; }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& parameters() const { return parameters_; }
    bytestring const& data() const { return data_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 total_param_count_;
    uint16 total_data_count_;
    uint16 param_count_;
    uint16 param_offset_;
    uint16 param_displacement_;
    uint16 data_count_;
    uint16 data_offset_;
    uint16 data_displacement_;
    uint16 FID_;
    uint16 byte_count_;
    bytestring parameters_;
    bytestring data_;
    SMB_Header* header_;
    bool proc_;
};


class SMB1_tree_connect_andx_request final {
public:
    SMB1_tree_connect_andx_request(SMB_Header* header, uint16 offset);
    ~SMB1_tree_connect_andx_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_andx* andx() const { return andx_; }
    uint16 flags() const { return flags_; }
    uint16 password_length() const { return password_length_; }
    uint16 byte_count() const { return byte_count_; }
    vector<uint8>* password() const { return password_; }
    SMB_string* path() const { return path_; }
    SMB_string* service() const { return service_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_andx* andx_;
    uint16 flags_;
    uint16 password_length_;
    uint16 byte_count_;
    vector<uint8>* password_;
    uint8 password__elem_;
    SMB_string* path_;
    SMB_string* service_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    bool proc_;
};


class SMB1_tree_connect_andx_response final {
public:
    SMB1_tree_connect_andx_response(SMB_Header* header, uint16 offset);
    ~SMB1_tree_connect_andx_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_andx* andx() const { return andx_; }
    vector<uint16>* optional_support() const { return optional_support_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_string* service() const { return service_; }
    vector<SMB_string*>* native_file_system() const { return native_file_system_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_andx* andx_;
    vector<uint16>* optional_support_;
    uint16 optional_support__elem_;
    uint16 byte_count_;
    SMB_string* service_;
    vector<SMB_string*>* native_file_system_;
    SMB_string* native_file_system__elem_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    bool proc_;
};


class SMB1_tree_disconnect final {
public:
    SMB1_tree_disconnect(SMB_Header* header, bool is_orig);
    ~SMB1_tree_disconnect();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_Header* header() const { return header_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 byte_count_;
    SMB_Header* header_;
    bool is_orig_;
    bool proc_;
};


class SMB1_write_andx_request final {
public:
    SMB1_write_andx_request(SMB_Header* header, uint16 offset);
    ~SMB1_write_andx_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_andx* andx() const { return andx_; }
    uint16 file_id() const { return file_id_; }
    uint32 offset_low() const { return offset_low_; }
    uint32 timeout() const { return timeout_; }
    uint16 write_mode() const { return write_mode_; }
    uint16 remaining() const { return remaining_; }
    uint16 data_len_high() const { return data_len_high_; }
    uint16 data_len_low() const { return data_len_low_; }
    uint16 data_offset() const { return data_offset_; }
    uint8 offset_high_u_case_index() const	{ return offset_high_u_case_index_; }
    uint32 offset_high_tmp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( offset_high_u_case_index() ) {
            case ((uint8)14):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-write-andx.pac:49:offset_high_tmp", (int64)offset_high_u_case_index(), "((int) 0x0E)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return offset_high_tmp_;
    }
    uint16 byte_count() const { return byte_count_; }
    bytestring const& data() const { return data_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    bool pipe_proc() const { BINPAC_ASSERT(has_pipe_proc()); return pipe_proc_; }
    bool has_pipe_proc() const { return has_pipe_proc_; }
    uint32 data_len() const { return data_len_; }
    uint32 offset_high() const { return offset_high_; }
    uint64 write_offset() const { return write_offset_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_andx* andx_;
    uint16 file_id_;
    uint32 offset_low_;
    uint32 timeout_;
    uint16 write_mode_;
    uint16 remaining_;
    uint16 data_len_high_;
    uint16 data_len_low_;
    uint16 data_offset_;
    uint8 offset_high_u_case_index_;
    uint32 offset_high_tmp_;
    uint16 byte_count_;
    bytestring data_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    bool pipe_proc_;
    bool has_pipe_proc_;
    uint32 data_len_;
    uint32 offset_high_;
    uint64 write_offset_;
    bool proc_;
};


class SMB1_write_andx_response final {
public:
    SMB1_write_andx_response(SMB_Header* header, uint16 offset);
    ~SMB1_write_andx_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    SMB_andx* andx() const { return andx_; }
    uint16 written_low() const { return written_low_; }
    uint16 remaining() const { return remaining_; }
    uint16 written_high() const { return written_high_; }
    uint16 reserved() const { return reserved_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_andx_command* andx_command() const { return andx_command_; }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    uint32 written_bytes() const { return written_bytes_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    SMB_andx* andx_;
    uint16 written_low_;
    uint16 remaining_;
    uint16 written_high_;
    uint16 reserved_;
    uint16 byte_count_;
    const_bytestring extra_byte_parameters_;
    SMB_andx_command* andx_command_;
    SMB_Header* header_;
    uint16 offset_;
    uint32 written_bytes_;
    bool proc_;
};


class SMB2_close_request final {
public:
    SMB2_close_request(SMB2_Header* header);
    ~SMB2_close_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 flags() const { return flags_; }
    uint32 reserved() const { return reserved_; }
    SMB2_guid* file_id() const { return file_id_; }
    SMB2_Header* header() const { return header_; }
    uint64 fid() const { return fid_; }
    bool proc() const { return proc_; }
    bool maybe_pipe_close() const { return maybe_pipe_close_; }

protected:
    uint16 structure_size_;
    uint16 flags_;
    uint32 reserved_;
    SMB2_guid* file_id_;
    SMB2_Header* header_;
    uint64 fid_;
    bool proc_;
    bool maybe_pipe_close_;
};


class SMB2_close_response final {
public:
    SMB2_close_response(SMB2_Header* header);
    ~SMB2_close_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 flags() const { return flags_; }
    uint32 reserved() const { return reserved_; }
    uint64 creation_time() const { return creation_time_; }
    uint64 last_access_time() const { return last_access_time_; }
    uint64 last_write_time() const { return last_write_time_; }
    uint64 change_time() const { return change_time_; }
    uint64 alloc_size() const { return alloc_size_; }
    uint64 eof() const { return eof_; }
    SMB2_file_attributes* file_attrs() const { return file_attrs_; }
    SMB2_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint16 flags_;
    uint32 reserved_;
    uint64 creation_time_;
    uint64 last_access_time_;
    uint64 last_write_time_;
    uint64 change_time_;
    uint64 alloc_size_;
    uint64 eof_;
    SMB2_file_attributes* file_attrs_;
    SMB2_Header* header_;
    bool proc_;
};


class SMB2_create_context final {
public:
    SMB2_create_context();
    ~SMB2_create_context();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 next_offset() const { return next_offset_; }
    uint16 name_offset() const { return name_offset_; }
    uint16 name_len() const { return name_len_; }
    uint16 reserved() const { return reserved_; }
    uint16 data_offset() const { return data_offset_; }
    uint32 data_len() const { return data_len_; }
    SMB2_string* name() const { return name_; }
    SMB2_string* data() const { return data_; }

protected:
    uint32 next_offset_;
    uint16 name_offset_;
    uint16 name_len_;
    uint16 reserved_;
    uint16 data_offset_;
    uint32 data_len_;
    SMB2_string* name_;
    SMB2_string* data_;
};


class SMB2_create_request final {
public:
    SMB2_create_request(SMB2_Header* header);
    ~SMB2_create_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint8 sec_flags_reserved() const { return sec_flags_reserved_; }
    uint8 oplock() const { return oplock_; }
    uint32 impersonation_level() const { return impersonation_level_; }
    bytestring const& flags() const { return flags_; }
    bytestring const& reserved() const { return reserved_; }
    uint32 access_mask() const { return access_mask_; }
    SMB2_file_attributes* file_attrs() const { return file_attrs_; }
    uint32 share_access() const { return share_access_; }
    uint32 disposition() const { return disposition_; }
    uint32 create_options() const { return create_options_; }
    uint16 filename_offset() const { return filename_offset_; }
    uint16 filename_len() const { return filename_len_; }
    uint32 context_offset() const { return context_offset_; }
    uint32 context_len() const { return context_len_; }
    SMB2_string* filename() const { return filename_; }
    SMB2_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint8 sec_flags_reserved_;
    uint8 oplock_;
    uint32 impersonation_level_;
    bytestring flags_;
    bytestring reserved_;
    uint32 access_mask_;
    SMB2_file_attributes* file_attrs_;
    uint32 share_access_;
    uint32 disposition_;
    uint32 create_options_;
    uint16 filename_offset_;
    uint16 filename_len_;
    uint32 context_offset_;
    uint32 context_len_;
    SMB2_string* filename_;
    const_bytestring contexts_;
    SMB2_Header* header_;
    bool proc_;
};


class SMB2_create_response final {
public:
    SMB2_create_response(SMB2_Header* header);
    ~SMB2_create_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint8 oplock() const { return oplock_; }
    uint8 reserved() const { return reserved_; }
    uint32 create_action() const { return create_action_; }
    uint64 creation_time() const { return creation_time_; }
    uint64 last_access_time() const { return last_access_time_; }
    uint64 last_write_time() const { return last_write_time_; }
    uint64 change_time() const { return change_time_; }
    uint64 alloc_size() const { return alloc_size_; }
    uint64 eof() const { return eof_; }
    SMB2_file_attributes* file_attrs() const { return file_attrs_; }
    uint32 reserved2() const { return reserved2_; }
    SMB2_guid* file_id() const { return file_id_; }
    uint32 context_offset() const { return context_offset_; }
    uint32 context_len() const { return context_len_; }
    SMB2_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint8 oplock_;
    uint8 reserved_;
    uint32 create_action_;
    uint64 creation_time_;
    uint64 last_access_time_;
    uint64 last_write_time_;
    uint64 change_time_;
    uint64 alloc_size_;
    uint64 eof_;
    SMB2_file_attributes* file_attrs_;
    uint32 reserved2_;
    SMB2_guid* file_id_;
    uint32 context_offset_;
    uint32 context_len_;
    const_bytestring contexts_;
    SMB2_Header* header_;
    bool proc_;
};


class SMB2_ioctl_request final {
public:
    SMB2_ioctl_request(SMB2_Header* header);
    ~SMB2_ioctl_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved() const { return reserved_; }
    uint32 ctl_code() const { return ctl_code_; }
    SMB2_guid* file_id() const { return file_id_; }
    uint32 input_offset() const { return input_offset_; }
    uint32 input_count() const { return input_count_; }
    uint32 max_input_resp() const { return max_input_resp_; }
    uint32 output_offset() const { return output_offset_; }
    uint32 output_count() const { return output_count_; }
    uint32 max_output_resp() const { return max_output_resp_; }
    uint32 flags() const { return flags_; }
    uint32 reserved2() const { return reserved2_; }
    bytestring const& input_buffer() const { return input_buffer_; }
    bytestring const& output_buffer() const { return output_buffer_; }
    SMB2_Header* header() const { return header_; }
    bool is_pipe() const { return is_pipe_; }
    uint64 fid() const { return fid_; }
    bool pipe_proc() const { BINPAC_ASSERT(has_pipe_proc()); return pipe_proc_; }
    bool has_pipe_proc() const { return has_pipe_proc_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint16 reserved_;
    uint32 ctl_code_;
    SMB2_guid* file_id_;
    uint32 input_offset_;
    uint32 input_count_;
    uint32 max_input_resp_;
    uint32 output_offset_;
    uint32 output_count_;
    uint32 max_output_resp_;
    uint32 flags_;
    uint32 reserved2_;
    const_bytestring pad1_;
    bytestring input_buffer_;
    const_bytestring pad2_;
    bytestring output_buffer_;
    SMB2_Header* header_;
    bool is_pipe_;
    uint64 fid_;
    bool pipe_proc_;
    bool has_pipe_proc_;
    bool proc_;
};


class SMB2_ioctl_response final {
public:
    SMB2_ioctl_response(SMB2_Header* header);
    ~SMB2_ioctl_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved() const { return reserved_; }
    uint32 ctl_code() const { return ctl_code_; }
    SMB2_guid* file_id() const { return file_id_; }
    uint32 input_offset() const { return input_offset_; }
    uint32 input_count() const { return input_count_; }
    uint32 output_offset() const { return output_offset_; }
    uint32 output_count() const { return output_count_; }
    uint32 flags() const { return flags_; }
    uint32 reserved2() const { return reserved2_; }
    bytestring const& input_buffer() const { return input_buffer_; }
    bytestring const& output_buffer() const { return output_buffer_; }
    SMB2_Header* header() const { return header_; }
    bool is_pipe() const { return is_pipe_; }
    uint64 fid() const { return fid_; }
    bool pipe_proc() const { BINPAC_ASSERT(has_pipe_proc()); return pipe_proc_; }
    bool has_pipe_proc() const { return has_pipe_proc_; }

protected:
    uint16 structure_size_;
    uint16 reserved_;
    uint32 ctl_code_;
    SMB2_guid* file_id_;
    uint32 input_offset_;
    uint32 input_count_;
    uint32 output_offset_;
    uint32 output_count_;
    uint32 flags_;
    uint32 reserved2_;
    const_bytestring pad1_;
    bytestring input_buffer_;
    const_bytestring pad2_;
    bytestring output_buffer_;
    SMB2_Header* header_;
    bool is_pipe_;
    uint64 fid_;
    bool pipe_proc_;
    bool has_pipe_proc_;
};


class SMB2_lock final {
public:
    SMB2_lock();
    ~SMB2_lock();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint64 offset() const { return offset_; }
    uint64 len() const { return len_; }
    uint32 flags() const { return flags_; }

protected:
    uint64 offset_;
    uint64 len_;
    uint32 flags_;
};


class SMB2_lock_request final {
public:
    SMB2_lock_request(SMB2_Header* header);
    ~SMB2_lock_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 lock_count() const { return lock_count_; }
    uint32 lock_seq() const { return lock_seq_; }
    SMB2_guid* file_id() const { return file_id_; }
    vector<SMB2_lock*>* locks() const { return locks_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 lock_count_;
    uint32 lock_seq_;
    SMB2_guid* file_id_;
    vector<SMB2_lock*>* locks_;
    SMB2_lock* locks__elem_;
    SMB2_Header* header_;
};


class SMB2_lock_response final {
public:
    SMB2_lock_response(SMB2_Header* header);
    ~SMB2_lock_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved() const { return reserved_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 reserved_;
    SMB2_Header* header_;
};


class SMB3_preauth_integrity_capabilities final {
public:
    SMB3_preauth_integrity_capabilities();
    ~SMB3_preauth_integrity_capabilities();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 hash_alg_count() const { return hash_alg_count_; }
    uint16 salt_length() const { return salt_length_; }
    vector<uint16>* hash_alg() const { return hash_alg_; }
    bytestring const& salt() const { return salt_; }

protected:
    uint16 hash_alg_count_;
    uint16 salt_length_;
    vector<uint16>* hash_alg_;
    uint16 hash_alg__elem_;
    bytestring salt_;
};


class SMB3_encryption_capabilities final {
public:
    SMB3_encryption_capabilities();
    ~SMB3_encryption_capabilities();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 cipher_count() const { return cipher_count_; }
    vector<uint16>* ciphers() const { return ciphers_; }

protected:
    uint16 cipher_count_;
    vector<uint16>* ciphers_;
    uint16 ciphers__elem_;
};


class SMB3_compression_capabilities final {
public:
    SMB3_compression_capabilities();
    ~SMB3_compression_capabilities();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 alg_count() const { return alg_count_; }
    uint16 pad() const { return pad_; }
    uint32 reserved() const { return reserved_; }
    vector<uint16>* algs() const { return algs_; }

protected:
    uint16 alg_count_;
    uint16 pad_;
    uint32 reserved_;
    vector<uint16>* algs_;
    uint16 algs__elem_;
};


class SMB3_netname_negotiate_context_id final {
public:
    SMB3_netname_negotiate_context_id(uint16 len);
    ~SMB3_netname_negotiate_context_id();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& net_name() const { return net_name_; }
    uint16 len() const { return len_; }

protected:
    bytestring net_name_;
    uint16 len_;
};


class SMB3_negotiate_context_value final {
public:
    SMB3_negotiate_context_value();
    ~SMB3_negotiate_context_value();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 context_type() const { return context_type_; }
    uint16 data_length() const { return data_length_; }
    uint32 reserved() const { return reserved_; }
    uint16 data_case_index() const	{ return data_case_index_; }
    SMB3_preauth_integrity_capabilities* preauth_integrity_capabilities() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint16)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-negotiate.pac:100:preauth_integrity_capabilities", (int64)data_case_index(), "SMB2_PREAUTH_INTEGRITY_CAPABILITIES");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return preauth_integrity_capabilities_;
    }
    SMB3_encryption_capabilities* encryption_capabilities() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint16)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-negotiate.pac:101:encryption_capabilities", (int64)data_case_index(), "SMB2_ENCRYPTION_CAPABILITIES");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return encryption_capabilities_;
    }
    SMB3_compression_capabilities* compression_capabilities() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint16)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-negotiate.pac:102:compression_capabilities", (int64)data_case_index(), "SMB2_COMPRESSION_CAPABILITIES");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return compression_capabilities_;
    }
    SMB3_netname_negotiate_context_id* netname_negotiate_context_id() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint16)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-negotiate.pac:103:netname_negotiate_context_id", (int64)data_case_index(), "SMB2_NETNAME_NEGOTIATE_CONTEXT_ID");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return netname_negotiate_context_id_;
    }
    bytestring const& unknown_context_data() const {
        return unknown_context_data_;
    }

protected:
    uint16 context_type_;
    uint16 data_length_;
    uint32 reserved_;
    uint16 data_case_index_;
    SMB3_preauth_integrity_capabilities* preauth_integrity_capabilities_;
    SMB3_encryption_capabilities* encryption_capabilities_;
    SMB3_compression_capabilities* compression_capabilities_;
    SMB3_netname_negotiate_context_id* netname_negotiate_context_id_;
    bytestring unknown_context_data_;
};


class Padded_SMB3_negotiate_context_value final {
public:
    Padded_SMB3_negotiate_context_value();
    ~Padded_SMB3_negotiate_context_value();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    SMB3_negotiate_context_value* ncv() const { return ncv_; }

protected:
    SMB3_negotiate_context_value* ncv_;
};


class SMB2_negotiate_request final {
public:
    SMB2_negotiate_request(SMB2_Header* header);
    ~SMB2_negotiate_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 dialect_count() const { return dialect_count_; }
    uint16 security_mode() const { return security_mode_; }
    uint32 capabilities() const { return capabilities_; }
    SMB2_guid* client_guid() const { return client_guid_; }
    uint64 client_start_time() const { return client_start_time_; }
    vector<uint16>* dialects() const { return dialects_; }
    SMB2_Header* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint16 dialect_count_;
    uint16 security_mode_;
    uint32 capabilities_;
    SMB2_guid* client_guid_;
    uint64 client_start_time_;
    vector<uint16>* dialects_;
    uint16 dialects__elem_;
    SMB2_Header* header_;
    int byteorder_;
    bool proc_;
};


class NegotiateContextList final {
public:
    NegotiateContextList(uint16 len);
    ~NegotiateContextList();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    vector<Padded_SMB3_negotiate_context_value*>* vals() const { return vals_; }
    SMB3_negotiate_context_value* last_val() const { return last_val_; }
    uint16 len() const { return len_; }

protected:
    vector<Padded_SMB3_negotiate_context_value*>* vals_;
    Padded_SMB3_negotiate_context_value* vals__elem_;
    SMB3_negotiate_context_value* last_val_;
    uint16 len_;
};


class OptNegotiateContextList final {
public:
    OptNegotiateContextList(uint16 len);
    ~OptNegotiateContextList();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 opt_case_index() const	{ return opt_case_index_; }
    NegotiateContextList* list() const {
        return list_;
    }
    uint16 len() const { return len_; }

protected:
    uint16 opt_case_index_;
    NegotiateContextList* list_;
    uint16 len_;
};


class SMB2_negotiate_response final {
public:
    SMB2_negotiate_response(SMB2_Header* header);
    ~SMB2_negotiate_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 security_mode() const { return security_mode_; }
    uint16 dialect_revision() const { return dialect_revision_; }
    uint16 negotiate_context_count() const { return negotiate_context_count_; }
    SMB2_guid* server_guid() const { return server_guid_; }
    uint32 capabilities() const { return capabilities_; }
    uint32 max_transact_size() const { return max_transact_size_; }
    uint32 max_read_size() const { return max_read_size_; }
    uint32 max_write_size() const { return max_write_size_; }
    uint64 system_time() const { return system_time_; }
    uint64 server_start_time() const { return server_start_time_; }
    uint16 security_offset() const { return security_offset_; }
    uint16 security_length() const { return security_length_; }
    uint32 negotiate_context_offset() const { return negotiate_context_offset_; }
    bytestring const& security_blob() const { return security_blob_; }
    uint16 negotiate_context_list_case_index() const	{ return negotiate_context_list_case_index_; }
    OptNegotiateContextList* smb3_ncl() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( negotiate_context_list_case_index() ) {
            case ((uint16)785):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-negotiate.pac:156:smb3_ncl", (int64)negotiate_context_list_case_index(), "((int) 0x0311)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return smb3_ncl_;
    }
    SMB2_Header* header() const { return header_; }
    int byteorder() const { return byteorder_; }
    bool proc() const { return proc_; }
    bool gssapi_proc() const { return gssapi_proc_; }

protected:
    uint16 structure_size_;
    uint16 security_mode_;
    uint16 dialect_revision_;
    uint16 negotiate_context_count_;
    SMB2_guid* server_guid_;
    uint32 capabilities_;
    uint32 max_transact_size_;
    uint32 max_read_size_;
    uint32 max_write_size_;
    uint64 system_time_;
    uint64 server_start_time_;
    uint16 security_offset_;
    uint16 security_length_;
    uint32 negotiate_context_offset_;
    bytestring security_blob_;
    uint16 negotiate_context_list_case_index_;
    OptNegotiateContextList* smb3_ncl_;
    SMB2_Header* header_;
    int byteorder_;
    bool proc_;
    bool gssapi_proc_;
};


class SMB2_read_request final {
public:
    SMB2_read_request(SMB2_Header* header);
    ~SMB2_read_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint8 pad() const { return pad_; }
    uint8 reserved() const { return reserved_; }
    uint32 read_len() const { return read_len_; }
    uint64 offset() const { return offset_; }
    SMB2_guid* file_id() const { return file_id_; }
    uint32 minimum_count() const { return minimum_count_; }
    uint32 channel() const { return channel_; }
    uint32 remaining_bytes() const { return remaining_bytes_; }
    uint16 channel_info_offset() const { return channel_info_offset_; }
    uint16 channel_info_len() const { return channel_info_len_; }
    bytestring const& buffer() const { return buffer_; }
    SMB2_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint8 pad_;
    uint8 reserved_;
    uint32 read_len_;
    uint64 offset_;
    SMB2_guid* file_id_;
    uint32 minimum_count_;
    uint32 channel_;
    uint32 remaining_bytes_;
    uint16 channel_info_offset_;
    uint16 channel_info_len_;
    bytestring buffer_;
    SMB2_Header* header_;
    bool proc_;
};


class SMB2_read_response final {
public:
    SMB2_read_response(SMB2_Header* header);
    ~SMB2_read_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint8 data_offset() const { return data_offset_; }
    uint8 reserved1() const { return reserved1_; }
    uint32 data_len() const { return data_len_; }
    uint32 data_remaining() const { return data_remaining_; }
    uint32 reserved2() const { return reserved2_; }
    bytestring const& data() const { return data_; }
    SMB2_Header* header() const { return header_; }
    uint64 fid() const { return fid_; }
    bool pipe_proc() const { BINPAC_ASSERT(has_pipe_proc()); return pipe_proc_; }
    bool has_pipe_proc() const { return has_pipe_proc_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint8 data_offset_;
    uint8 reserved1_;
    uint32 data_len_;
    uint32 data_remaining_;
    uint32 reserved2_;
    bytestring data_;
    SMB2_Header* header_;
    uint64 fid_;
    bool pipe_proc_;
    bool has_pipe_proc_;
    bool proc_;
};


class SMB2_session_setup_request final {
public:
    SMB2_session_setup_request(SMB2_Header* header);
    ~SMB2_session_setup_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint8 vc_number() const { return vc_number_; }
    uint8 security_mode() const { return security_mode_; }
    uint32 capabilities() const { return capabilities_; }
    uint32 channel() const { return channel_; }
    uint16 security_offset() const { return security_offset_; }
    uint16 security_length() const { return security_length_; }
    bytestring const& security_blob() const { return security_blob_; }
    SMB2_Header* header() const { return header_; }
    bool proc() const { return proc_; }
    bool gssapi_proc() const { return gssapi_proc_; }

protected:
    uint16 structure_size_;
    uint8 vc_number_;
    uint8 security_mode_;
    uint32 capabilities_;
    uint32 channel_;
    uint16 security_offset_;
    uint16 security_length_;
    bytestring security_blob_;
    SMB2_Header* header_;
    bool proc_;
    bool gssapi_proc_;
};


class SMB2_session_setup_response final {
public:
    SMB2_session_setup_response(SMB2_Header* header);
    ~SMB2_session_setup_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 session_flags() const { return session_flags_; }
    uint16 security_offset() const { return security_offset_; }
    uint16 security_length() const { return security_length_; }
    bytestring const& security_blob() const { return security_blob_; }
    SMB2_Header* header() const { return header_; }
    int flag_guest() const { return flag_guest_; }
    int flag_anonymous() const { return flag_anonymous_; }
    int flag_encrypt() const { return flag_encrypt_; }
    bool proc() const { return proc_; }
    bool gssapi_proc() const { return gssapi_proc_; }

protected:
    uint16 structure_size_;
    uint16 session_flags_;
    uint16 security_offset_;
    uint16 security_length_;
    bytestring security_blob_;
    SMB2_Header* header_;
    int flag_guest_;
    int flag_anonymous_;
    int flag_encrypt_;
    bool proc_;
    bool gssapi_proc_;
};


class SMB2_file_basic_info final {
public:
    SMB2_file_basic_info(SMB2_set_info_request* sir);
    ~SMB2_file_basic_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint64 creation_time() const { return creation_time_; }
    uint64 last_access_time() const { return last_access_time_; }
    uint64 last_write_time() const { return last_write_time_; }
    uint64 change_time() const { return change_time_; }
    SMB2_file_attributes* file_attrs() const { return file_attrs_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    uint64 creation_time_;
    uint64 last_access_time_;
    uint64 last_write_time_;
    uint64 change_time_;
    SMB2_file_attributes* file_attrs_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_rename_info final {
public:
    SMB2_file_rename_info(SMB2_set_info_request* sir);
    ~SMB2_file_rename_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 replace_if_exists() const { return replace_if_exists_; }
    vector<uint8>* reserved() const { return reserved_; }
    uint64 root_directory() const { return root_directory_; }
    uint32 filename_len() const { return filename_len_; }
    SMB2_string* filename() const { return filename_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    uint8 replace_if_exists_;
    vector<uint8>* reserved_;
    uint8 reserved__elem_;
    uint64 root_directory_;
    uint32 filename_len_;
    SMB2_string* filename_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_disposition_info final {
public:
    SMB2_file_disposition_info(SMB2_set_info_request* sir);
    ~SMB2_file_disposition_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 delete_pending() const { return delete_pending_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    uint8 delete_pending_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_allocation_info final {
public:
    SMB2_file_allocation_info(SMB2_set_info_request* sir);
    ~SMB2_file_allocation_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    int64 allocation_size() const { return allocation_size_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    int64 allocation_size_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_endoffile_info final {
public:
    SMB2_file_endoffile_info(SMB2_set_info_request* sir);
    ~SMB2_file_endoffile_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    int64 endoffile() const { return endoffile_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    int64 endoffile_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_fullea_info_element final {
public:
    SMB2_file_fullea_info_element();
    ~SMB2_file_fullea_info_element();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 next_entry_offset() const { return next_entry_offset_; }
    uint8 flags() const { return flags_; }
    uint8 ea_name_length() const { return ea_name_length_; }
    uint16 ea_value_length() const { return ea_value_length_; }
    SMB2_string* ea_name() const { return ea_name_; }
    SMB2_string* ea_value() const { return ea_value_; }
    int next_offset() const { return next_offset_; }

protected:
    uint32 next_entry_offset_;
    uint8 flags_;
    uint8 ea_name_length_;
    uint16 ea_value_length_;
    SMB2_string* ea_name_;
    SMB2_string* ea_value_;
    int next_offset_;
};


class SMB2_file_fullea_info final {
public:
    SMB2_file_fullea_info(SMB2_set_info_request* sir);
    ~SMB2_file_fullea_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    vector<SMB2_file_fullea_info_element*>* ea_vector() const { return ea_vector_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    vector<SMB2_file_fullea_info_element*>* ea_vector_;
    SMB2_file_fullea_info_element* ea_vector__elem_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_link_info final {
public:
    SMB2_file_link_info(SMB2_set_info_request* sir);
    ~SMB2_file_link_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 replace_if_exists() const { return replace_if_exists_; }
    vector<uint8>* reserved() const { return reserved_; }
    uint64 root_directory() const { return root_directory_; }
    uint32 file_name_length() const { return file_name_length_; }
    SMB2_string* file_name() const { return file_name_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    uint8 replace_if_exists_;
    vector<uint8>* reserved_;
    uint8 reserved__elem_;
    uint64 root_directory_;
    uint32 file_name_length_;
    SMB2_string* file_name_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_mode_info final {
public:
    SMB2_file_mode_info(SMB2_set_info_request* sir);
    ~SMB2_file_mode_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint32 mode() const { return mode_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    uint32 mode_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_pipe_info final {
public:
    SMB2_file_pipe_info(SMB2_set_info_request* sir);
    ~SMB2_file_pipe_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint32 read_mode() const { return read_mode_; }
    uint32 completion_mode() const { return completion_mode_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    uint32 read_mode_;
    uint32 completion_mode_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_position_info final {
public:
    SMB2_file_position_info(SMB2_set_info_request* sir);
    ~SMB2_file_position_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    int64 current_byte_offset() const { return current_byte_offset_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    int64 current_byte_offset_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_shortname_info final {
public:
    SMB2_file_shortname_info(SMB2_set_info_request* sir);
    ~SMB2_file_shortname_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint32 filename_length() const { return filename_length_; }
    SMB2_string* filename() const { return filename_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    uint32 filename_length_;
    SMB2_string* filename_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_validdatalength_info final {
public:
    SMB2_file_validdatalength_info(SMB2_set_info_request* sir);
    ~SMB2_file_validdatalength_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    int64 validdatalength() const { return validdatalength_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    int64 validdatalength_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_fscontrol_info final {
public:
    SMB2_file_fscontrol_info(SMB2_set_info_request* sir);
    ~SMB2_file_fscontrol_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    int64 free_space_start_filtering() const { return free_space_start_filtering_; }
    int64 free_space_start_threshold() const { return free_space_start_threshold_; }
    int64 free_space_stop_filtering() const { return free_space_stop_filtering_; }
    uint64 default_quota_threshold() const { return default_quota_threshold_; }
    uint64 default_quota_limit() const { return default_quota_limit_; }
    uint32 file_system_control_flags() const { return file_system_control_flags_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    int64 free_space_start_filtering_;
    int64 free_space_start_threshold_;
    int64 free_space_stop_filtering_;
    uint64 default_quota_threshold_;
    uint64 default_quota_limit_;
    uint32 file_system_control_flags_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_file_fsobjectid_info final {
public:
    SMB2_file_fsobjectid_info(SMB2_set_info_request* sir);
    ~SMB2_file_fsobjectid_info();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    SMB2_guid* object_id() const { return object_id_; }
    SMB2_string* extended_info() const { return extended_info_; }
    SMB2_set_info_request* sir() const { return sir_; }
    bool proc() const { return proc_; }

protected:
    SMB2_guid* object_id_;
    SMB2_string* extended_info_;
    SMB2_set_info_request* sir_;
    bool proc_;
};


class SMB2_set_info_file_class final {
public:
    SMB2_set_info_file_class(SMB2_set_info_request* sir);
    ~SMB2_set_info_file_class();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SMB2_file_basic_info* file_basic() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:346:file_basic", (int64)val_case_index(), "SMB2_FILE_BASIC_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_basic_;
    }
    SMB2_file_rename_info* file_rename() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:347:file_rename", (int64)val_case_index(), "SMB2_FILE_RENAME_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_rename_;
    }
    SMB2_file_disposition_info* file_disposition() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)13):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:348:file_disposition", (int64)val_case_index(), "SMB2_FILE_DISPOSITION_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_disposition_;
    }
    SMB2_file_allocation_info* file_allocation() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)19):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:349:file_allocation", (int64)val_case_index(), "SMB2_FILE_ALLOCATION_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_allocation_;
    }
    SMB2_file_endoffile_info* file_endoffile() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)20):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:350:file_endoffile", (int64)val_case_index(), "SMB2_FILE_ENDOFFILE_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_endoffile_;
    }
    SMB2_file_fullea_info* file_fullea() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:351:file_fullea", (int64)val_case_index(), "SMB2_FILE_FULLEA_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_fullea_;
    }
    SMB2_file_link_info* file_link() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:352:file_link", (int64)val_case_index(), "SMB2_FILE_LINK_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_link_;
    }
    SMB2_file_mode_info* file_mode() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:353:file_mode", (int64)val_case_index(), "SMB2_FILE_MODE_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_mode_;
    }
    SMB2_file_pipe_info* file_pipe() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)24):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:354:file_pipe", (int64)val_case_index(), "SMB2_FILE_PIPE_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_pipe_;
    }
    SMB2_file_position_info* file_position() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)14):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:355:file_position", (int64)val_case_index(), "SMB2_FILE_POSITION_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_position_;
    }
    SMB2_file_shortname_info* file_shortname() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)40):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:356:file_shortname", (int64)val_case_index(), "SMB2_FILE_SHORTNAME_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_shortname_;
    }
    SMB2_file_validdatalength_info* file_validdatalength() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)39):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:357:file_validdatalength", (int64)val_case_index(), "SMB2_FILE_VALIDDATALENGTH_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_validdatalength_;
    }
    SMB2_set_info_request* sir() const { return sir_; }

protected:
    uint8 val_case_index_;
    SMB2_file_basic_info* file_basic_;
    SMB2_file_rename_info* file_rename_;
    SMB2_file_disposition_info* file_disposition_;
    SMB2_file_allocation_info* file_allocation_;
    SMB2_file_endoffile_info* file_endoffile_;
    SMB2_file_fullea_info* file_fullea_;
    SMB2_file_link_info* file_link_;
    SMB2_file_mode_info* file_mode_;
    SMB2_file_pipe_info* file_pipe_;
    SMB2_file_position_info* file_position_;
    SMB2_file_shortname_info* file_shortname_;
    SMB2_file_validdatalength_info* file_validdatalength_;
    SMB2_set_info_request* sir_;
};


class SMB2_set_info_filesystem_class final {
public:
    SMB2_set_info_filesystem_class(SMB2_set_info_request* sir);
    ~SMB2_set_info_filesystem_class();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SMB2_file_fscontrol_info* file_fscontrol() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:362:file_fscontrol", (int64)val_case_index(), "SMB2_FILE_FSCONTROL_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_fscontrol_;
    }
    SMB2_file_fsobjectid_info* file_fsobjectid() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:363:file_fsobjectid", (int64)val_case_index(), "SMB2_FILE_FSOBJECTID_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_fsobjectid_;
    }
    SMB2_set_info_request* sir() const { return sir_; }

protected:
    uint8 val_case_index_;
    SMB2_file_fscontrol_info* file_fscontrol_;
    SMB2_file_fsobjectid_info* file_fsobjectid_;
    SMB2_set_info_request* sir_;
};


class SMB2_set_info_request final {
public:
    SMB2_set_info_request(SMB2_Header* header);
    ~SMB2_set_info_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint8 info_class() const { return info_class_; }
    uint8 info_level() const { return info_level_; }
    uint32 buffer_len() const { return buffer_len_; }
    uint16 buffer_offset() const { return buffer_offset_; }
    uint16 reserved() const { return reserved_; }
    uint32 additional_info() const { return additional_info_; }
    SMB2_guid* file_id() const { return file_id_; }
    uint8 data_case_index() const	{ return data_case_index_; }
    SMB2_set_info_file_class* file_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:380:file_info", (int64)data_case_index(), "SMB2_0_INFO_FILE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return file_info_;
    }
    SMB2_set_info_filesystem_class* filesystem_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:381:filesystem_info", (int64)data_case_index(), "SMB2_0_INFO_FILESYSTEM");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return filesystem_info_;
    }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint8 info_class_;
    uint8 info_level_;
    uint32 buffer_len_;
    uint16 buffer_offset_;
    uint16 reserved_;
    uint32 additional_info_;
    SMB2_guid* file_id_;
    uint8 data_case_index_;
    SMB2_set_info_file_class* file_info_;
    SMB2_set_info_filesystem_class* filesystem_info_;
    SMB2_Header* header_;
};


class SMB2_set_info_response final {
public:
    SMB2_set_info_response(SMB2_Header* header);
    ~SMB2_set_info_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    SMB2_Header* header_;
};


class SMB2_tree_connect_request final {
public:
    SMB2_tree_connect_request(SMB2_Header* header);
    ~SMB2_tree_connect_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 path_offset() const { return path_offset_; }
    uint16 path_length() const { return path_length_; }
    SMB2_string* path() const { return path_; }
    SMB2_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint16 path_offset_;
    uint16 path_length_;
    SMB2_string* path_;
    SMB2_Header* header_;
    bool proc_;
};


class SMB2_tree_connect_response final {
public:
    SMB2_tree_connect_response(SMB2_Header* header);
    ~SMB2_tree_connect_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint8 share_type() const { return share_type_; }
    uint32 share_flags() const { return share_flags_; }
    uint32 capabilities() const { return capabilities_; }
    uint32 maximal_access() const { return maximal_access_; }
    SMB2_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint8 share_type_;
    uint32 share_flags_;
    uint32 capabilities_;
    uint32 maximal_access_;
    SMB2_Header* header_;
    bool proc_;
};


class SMB2_tree_disconnect_request final {
public:
    SMB2_tree_disconnect_request(SMB2_Header* header);
    ~SMB2_tree_disconnect_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved() const { return reserved_; }
    SMB2_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint16 reserved_;
    SMB2_Header* header_;
    bool proc_;
};


class SMB2_tree_disconnect_response final {
public:
    SMB2_tree_disconnect_response(SMB2_Header* header);
    ~SMB2_tree_disconnect_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved() const { return reserved_; }
    SMB2_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint16 reserved_;
    SMB2_Header* header_;
    bool proc_;
};


class SMB2_write_request final {
public:
    SMB2_write_request(SMB2_Header* header);
    ~SMB2_write_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 data_offset() const { return data_offset_; }
    uint32 data_len() const { return data_len_; }
    uint64 offset() const { return offset_; }
    SMB2_guid* file_id() const { return file_id_; }
    uint32 channel() const { return channel_; }
    uint32 data_remaining() const { return data_remaining_; }
    uint16 channel_info_offset() const { return channel_info_offset_; }
    uint16 channel_info_len() const { return channel_info_len_; }
    uint32 flags() const { return flags_; }
    bytestring const& data() const { return data_; }
    SMB2_Header* header() const { return header_; }
    bool pipe_proc() const { BINPAC_ASSERT(has_pipe_proc()); return pipe_proc_; }
    bool has_pipe_proc() const { return has_pipe_proc_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint16 data_offset_;
    uint32 data_len_;
    uint64 offset_;
    SMB2_guid* file_id_;
    uint32 channel_;
    uint32 data_remaining_;
    uint16 channel_info_offset_;
    uint16 channel_info_len_;
    uint32 flags_;
    bytestring data_;
    SMB2_Header* header_;
    bool pipe_proc_;
    bool has_pipe_proc_;
    bool proc_;
};


class SMB2_write_response final {
public:
    SMB2_write_response(SMB2_Header* header);
    ~SMB2_write_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved() const { return reserved_; }
    uint32 write_count() const { return write_count_; }
    uint32 remaining() const { return remaining_; }
    uint16 channel_info_offset() const { return channel_info_offset_; }
    uint16 channel_info_len() const { return channel_info_len_; }
    SMB2_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint16 structure_size_;
    uint16 reserved_;
    uint32 write_count_;
    uint32 remaining_;
    uint16 channel_info_offset_;
    uint16 channel_info_len_;
    SMB2_Header* header_;
    bool proc_;
};


class SMB2_transform_header final {
public:
    SMB2_transform_header();
    ~SMB2_transform_header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    bytestring const& signature() const { return signature_; }
    bytestring const& nonce() const { return nonce_; }
    uint32 orig_msg_size() const { return orig_msg_size_; }
    uint16 reserved() const { return reserved_; }
    uint16 flags() const { return flags_; }
    uint64 session_id() const { return session_id_; }
    int byteorder() const { return byteorder_; }
    bool proc() const { return proc_; }

protected:
    bytestring signature_;
    bytestring nonce_;
    uint32 orig_msg_size_;
    uint16 reserved_;
    uint16 flags_;
    uint64 session_id_;
    int byteorder_;
    bool proc_;
};


class uint24 final {
public:
    uint24();
    ~uint24();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 byte1() const { return byte1_; }
    uint8 byte2() const { return byte2_; }
    uint8 byte3() const { return byte3_; }

protected:
    uint8 byte1_;
    uint8 byte2_;
    uint8 byte3_;
};

uint32 to_int(uint24* num);

class SMB_TCP final {
public:
    SMB_TCP(bool is_orig);
    ~SMB_TCP();
    int initial_buffer_length() const { return 4; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSMB* t_context);

    // Member access functions
    uint8 message_type() const { return message_type_; }
    uint24* len24() const { return len24_; }
    uint8 body_case_index() const	{ return body_case_index_; }
    vector<SMB_Protocol_Identifier*>* nbss() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( body_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb.pac:118:nbss", (int64)body_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nbss_;
    }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }
    uint32 len() const { return len_; }

protected:
    uint8 message_type_;
    uint24* len24_;
    uint8 body_case_index_;
    vector<SMB_Protocol_Identifier*>* nbss_;
    SMB_Protocol_Identifier* nbss__elem_;
    const_bytestring skip_;
    bool is_orig_;
    int byteorder_;
    uint32 len_;
    int buffering_state_;
};


class SMB_Protocol_Identifier final {
public:
    SMB_Protocol_Identifier(bool is_orig, uint32 msg_len);
    ~SMB_Protocol_Identifier();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    int32 protocol() const { return protocol_; }
    int32 smb_1_or_2_case_index() const	{ return smb_1_or_2_case_index_; }
    SMB_PDU* smb1() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( smb_1_or_2_case_index() ) {
            case ((int32)-11317950):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb.pac:131:smb1", (int64)smb_1_or_2_case_index(), "SMB1");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return smb1_;
    }
    SMB2_PDU* smb2() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( smb_1_or_2_case_index() ) {
            case ((int32)-28095166):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb.pac:132:smb2", (int64)smb_1_or_2_case_index(), "SMB2");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return smb2_;
    }
    SMB2_transform_header* smb3() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( smb_1_or_2_case_index() ) {
            case ((int32)-44872382):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb.pac:134:smb3", (int64)smb_1_or_2_case_index(), "SMB3");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return smb3_;
    }
    bool is_orig() const { return is_orig_; }
    uint32 msg_len() const { return msg_len_; }
    bool end_of_chain() const { return end_of_chain_; }

protected:
    int32 protocol_;
    int32 smb_1_or_2_case_index_;
    SMB_PDU* smb1_;
    SMB2_PDU* smb2_;
    SMB2_transform_header* smb3_;
    bool is_orig_;
    uint32 msg_len_;
    bool end_of_chain_;
};


	zeek::RecordValPtr SMBHeaderVal(SMB_Header* hdr);


class SMB_dos_error final {
public:
    SMB_dos_error();
    ~SMB_dos_error();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 error_class() const { return error_class_; }
    uint8 reserved() const { return reserved_; }
    uint16 error() const { return error_; }

protected:
    uint8 error_class_;
    uint8 reserved_;
    uint16 error_;
};


class SMB_error final {
public:
    SMB_error(int err_status_type);
    ~SMB_error();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    SMB_dos_error* dos_error() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:99:dos_error", (int64)val_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return dos_error_;
    }
    uint32 error() const {
        return error_;
    }
    int err_status_type() const { return err_status_type_; }

protected:
    int val_case_index_;
    SMB_dos_error* dos_error_;
    uint32 error_;
    int err_status_type_;
};


class SMB_andx final {
public:
    SMB_andx();
    ~SMB_andx();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 command() const { return command_; }
    uint8 reserved() const { return reserved_; }
    uint16 offset() const { return offset_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 command_;
    uint8 reserved_;
    uint16 offset_;
    int byteorder_;
};


class SMB_PDU final {
public:
    SMB_PDU(bool is_orig, uint32 msg_len);
    ~SMB_PDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    SMB_Header* header() const { return header_; }
    uint32 message_case_index() const	{ return message_case_index_; }
    SMB_No_Message* no_msg() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( message_case_index() ) {
            case ((uint32)35):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:114:no_msg", (int64)message_case_index(), "((int) 35)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return no_msg_;
    }
    SMB_Message* msg() const {
        return msg_;
    }
    bool is_orig() const { return is_orig_; }
    uint32 msg_len() const { return msg_len_; }

protected:
    SMB_Header* header_;
    uint32 message_case_index_;
    SMB_No_Message* no_msg_;
    SMB_Message* msg_;
    bool is_orig_;
    uint32 msg_len_;
};


class SMB_No_Message final {
public:
    SMB_No_Message(SMB_Header* header, bool is_orig);
    ~SMB_No_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    SMB_Header* header() const { return header_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    const_bytestring x_;
    SMB_Header* header_;
    bool is_orig_;
    bool proc_;
};


class SMB_empty_response final {
public:
    SMB_empty_response(SMB_Header* header);
    ~SMB_empty_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint8 word_count() const { return word_count_; }
    uint16 byte_count() const { return byte_count_; }
    SMB_Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    uint8 word_count_;
    uint16 byte_count_;
    SMB_Header* header_;
    bool proc_;
};


class SMB_Message final {
public:
    SMB_Message(SMB_Header* header, uint16 offset, uint8 command, bool is_orig);
    ~SMB_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    SMB_Message_Request* request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:133:request", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return request_;
    }
    SMB_Message_Response* response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:134:response", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return response_;
    }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    uint8 command() const { return command_; }
    bool is_orig() const { return is_orig_; }

protected:
    int val_case_index_;
    SMB_Message_Request* request_;
    SMB_Message_Response* response_;
    SMB_Header* header_;
    uint16 offset_;
    uint8 command_;
    bool is_orig_;
};


class SMB_andx_command final {
public:
    SMB_andx_command(SMB_Header* header, bool is_orig, uint16 offset, uint8 command);
    ~SMB_andx_command();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SMB_Message* message() const {
        return message_;
    }
    SMB_Header* header() const { return header_; }
    bool is_orig() const { return is_orig_; }
    uint16 offset() const { return offset_; }
    uint8 command() const { return command_; }

protected:
    uint8 val_case_index_;
    SMB_Message* message_;
    SMB_Header* header_;
    bool is_orig_;
    uint16 offset_;
    uint8 command_;
};


class SMB_Message_Request final {
public:
    SMB_Message_Request(SMB_Header* header, uint16 offset, uint8 command, bool is_orig);
    ~SMB_Message_Request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SMB1_read_andx_request* read_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)46):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:145:read_andx", (int64)val_case_index(), "SMB_COM_READ_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return read_andx_;
    }
    SMB1_write_andx_request* write_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)47):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:146:write_andx", (int64)val_case_index(), "SMB_COM_WRITE_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return write_andx_;
    }
    SMB1_transaction2_request* transaction2() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)50):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:147:transaction2", (int64)val_case_index(), "SMB_COM_TRANSACTION2");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return transaction2_;
    }
    SMB1_negotiate_request* negotiate() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)114):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:148:negotiate", (int64)val_case_index(), "SMB_COM_NEGOTIATE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return negotiate_;
    }
    SMB1_session_setup_andx_request* session_setup_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)115):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:149:session_setup_andx", (int64)val_case_index(), "SMB_COM_SESSION_SETUP_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return session_setup_andx_;
    }
    SMB1_tree_connect_andx_request* tree_connect_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)117):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:150:tree_connect_andx", (int64)val_case_index(), "SMB_COM_TREE_CONNECT_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tree_connect_andx_;
    }
    SMB1_nt_transact_request* nt_transact() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)160):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:151:nt_transact", (int64)val_case_index(), "SMB_COM_NT_TRANSACT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nt_transact_;
    }
    SMB1_nt_create_andx_request* nt_create_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)162):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:152:nt_create_andx", (int64)val_case_index(), "SMB_COM_NT_CREATE_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nt_create_andx_;
    }
    SMB1_close_request* close() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:158:close", (int64)val_case_index(), "SMB_COM_CLOSE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return close_;
    }
    SMB1_query_information_request* query_information() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:162:query_information", (int64)val_case_index(), "SMB_COM_QUERY_INFORMATION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return query_information_;
    }
    SMB1_check_directory_request* check_directory() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:170:check_directory", (int64)val_case_index(), "SMB_COM_CHECK_DIRECTORY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return check_directory_;
    }
    SMB1_locking_andx_request* locking_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)36):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:185:locking_andx", (int64)val_case_index(), "SMB_COM_LOCKING_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return locking_andx_;
    }
    SMB1_transaction_request* transaction() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)37):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:186:transaction", (int64)val_case_index(), "SMB_COM_TRANSACTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return transaction_;
    }
    SMB1_transaction_secondary_request* transaction_secondary() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)38):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:187:transaction_secondary", (int64)val_case_index(), "SMB_COM_TRANSACTION_SECONDARY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return transaction_secondary_;
    }
    SMB1_echo_request* echo() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)43):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:192:echo", (int64)val_case_index(), "SMB_COM_ECHO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return echo_;
    }
    SMB1_transaction2_secondary_request* transaction2_secondary() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)51):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:196:transaction2_secondary", (int64)val_case_index(), "SMB_COM_TRANSACTION2_SECONDARY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return transaction2_secondary_;
    }
    SMB1_tree_disconnect* tree_disconnect() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)113):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:200:tree_disconnect", (int64)val_case_index(), "SMB_COM_TREE_DISCONNECT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tree_disconnect_;
    }
    SMB1_logoff_andx* logoff_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)116):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:201:logoff_andx", (int64)val_case_index(), "SMB_COM_LOGOFF_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return logoff_andx_;
    }
    SMB1_nt_cancel_request* nt_cancel() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)164):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:208:nt_cancel", (int64)val_case_index(), "SMB_COM_NT_CANCEL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nt_cancel_;
    }
    bytestring const& unknown_msg() const {
        return unknown_msg_;
    }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    uint8 command() const { return command_; }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 val_case_index_;
    SMB1_read_andx_request* read_andx_;
    SMB1_write_andx_request* write_andx_;
    SMB1_transaction2_request* transaction2_;
    SMB1_negotiate_request* negotiate_;
    SMB1_session_setup_andx_request* session_setup_andx_;
    SMB1_tree_connect_andx_request* tree_connect_andx_;
    SMB1_nt_transact_request* nt_transact_;
    SMB1_nt_create_andx_request* nt_create_andx_;
    SMB1_close_request* close_;
    SMB1_query_information_request* query_information_;
    SMB1_check_directory_request* check_directory_;
    SMB1_locking_andx_request* locking_andx_;
    SMB1_transaction_request* transaction_;
    SMB1_transaction_secondary_request* transaction_secondary_;
    SMB1_echo_request* echo_;
    SMB1_transaction2_secondary_request* transaction2_secondary_;
    SMB1_tree_disconnect* tree_disconnect_;
    SMB1_logoff_andx* logoff_andx_;
    SMB1_nt_cancel_request* nt_cancel_;
    bytestring unknown_msg_;
    SMB_Header* header_;
    uint16 offset_;
    uint8 command_;
    bool is_orig_;
    int byteorder_;
};


class SMB_Message_Response final {
public:
    SMB_Message_Response(SMB_Header* header, uint16 offset, uint8 command, bool is_orig);
    ~SMB_Message_Response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SMB1_read_andx_response* read_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)46):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:223:read_andx", (int64)val_case_index(), "SMB_COM_READ_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return read_andx_;
    }
    SMB1_write_andx_response* write_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)47):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:224:write_andx", (int64)val_case_index(), "SMB_COM_WRITE_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return write_andx_;
    }
    SMB1_transaction2_response* transaction2() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)50):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:225:transaction2", (int64)val_case_index(), "SMB_COM_TRANSACTION2");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return transaction2_;
    }
    SMB1_negotiate_response* negotiate() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)114):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:226:negotiate", (int64)val_case_index(), "SMB_COM_NEGOTIATE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return negotiate_;
    }
    SMB1_session_setup_andx_response* session_setup_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)115):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:227:session_setup_andx", (int64)val_case_index(), "SMB_COM_SESSION_SETUP_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return session_setup_andx_;
    }
    SMB1_tree_connect_andx_response* tree_connect_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)117):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:228:tree_connect_andx", (int64)val_case_index(), "SMB_COM_TREE_CONNECT_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tree_connect_andx_;
    }
    SMB1_nt_transact_response* nt_transact() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)160):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:229:nt_transact", (int64)val_case_index(), "SMB_COM_NT_TRANSACT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nt_transact_;
    }
    SMB1_nt_create_andx_response* nt_create_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)162):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:230:nt_create_andx", (int64)val_case_index(), "SMB_COM_NT_CREATE_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nt_create_andx_;
    }
    SMB_empty_response* close() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:236:close", (int64)val_case_index(), "SMB_COM_CLOSE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return close_;
    }
    SMB1_query_information_response* query_information() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:240:query_information", (int64)val_case_index(), "SMB_COM_QUERY_INFORMATION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return query_information_;
    }
    SMB1_check_directory_response* check_directory() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:248:check_directory", (int64)val_case_index(), "SMB_COM_CHECK_DIRECTORY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return check_directory_;
    }
    SMB1_locking_andx_response* locking_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)36):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:263:locking_andx", (int64)val_case_index(), "SMB_COM_LOCKING_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return locking_andx_;
    }
    SMB1_transaction_response* transaction() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)37):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:264:transaction", (int64)val_case_index(), "SMB_COM_TRANSACTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return transaction_;
    }
    SMB1_echo_response* echo() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)43):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:269:echo", (int64)val_case_index(), "SMB_COM_ECHO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return echo_;
    }
    SMB1_tree_disconnect* tree_disconnect() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)113):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:277:tree_disconnect", (int64)val_case_index(), "SMB_COM_TREE_DISCONNECT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tree_disconnect_;
    }
    SMB1_logoff_andx* logoff_andx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)116):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:278:logoff_andx", (int64)val_case_index(), "SMB_COM_LOGOFF_ANDX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return logoff_andx_;
    }
    bytestring const& unknown_msg() const {
        return unknown_msg_;
    }
    SMB_Header* header() const { return header_; }
    uint16 offset() const { return offset_; }
    uint8 command() const { return command_; }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 val_case_index_;
    SMB1_read_andx_response* read_andx_;
    SMB1_write_andx_response* write_andx_;
    SMB1_transaction2_response* transaction2_;
    SMB1_negotiate_response* negotiate_;
    SMB1_session_setup_andx_response* session_setup_andx_;
    SMB1_tree_connect_andx_response* tree_connect_andx_;
    SMB1_nt_transact_response* nt_transact_;
    SMB1_nt_create_andx_response* nt_create_andx_;
    SMB_empty_response* close_;
    SMB1_query_information_response* query_information_;
    SMB1_check_directory_response* check_directory_;
    SMB1_locking_andx_response* locking_andx_;
    SMB1_transaction_response* transaction_;
    SMB1_echo_response* echo_;
    SMB1_tree_disconnect* tree_disconnect_;
    SMB1_logoff_andx* logoff_andx_;
    bytestring unknown_msg_;
    SMB_Header* header_;
    uint16 offset_;
    uint8 command_;
    bool is_orig_;
    int byteorder_;
};


class SMB_Header final {
public:
    SMB_Header(bool is_orig);
    ~SMB_Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint8 command() const { return command_; }
    uint32 status() const { return status_; }
    uint8 flags() const { return flags_; }
    uint16 flags2() const { return flags2_; }
    uint16 pid_high() const { return pid_high_; }
    vector<uint8>* security_features() const { return security_features_; }
    uint16 reserved() const { return reserved_; }
    uint16 tid() const { return tid_; }
    uint16 pid_low() const { return pid_low_; }
    uint16 uid() const { return uid_; }
    uint16 mid() const { return mid_; }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }
    int err_status_type() const { return err_status_type_; }
    int unicode() const { return unicode_; }
    uint32 pid() const { return pid_; }
    bool is_pipe() const { return is_pipe_; }
    bool proc() const { return proc_; }

protected:
    uint8 command_;
    uint32 status_;
    uint8 flags_;
    uint16 flags2_;
    uint16 pid_high_;
    vector<uint8>* security_features_;
    uint8 security_features__elem_;
    uint16 reserved_;
    uint16 tid_;
    uint16 pid_low_;
    uint16 uid_;
    uint16 mid_;
    bool is_orig_;
    int byteorder_;
    int err_status_type_;
    int unicode_;
    uint32 pid_;
    bool is_pipe_;
    bool proc_;
};

extern int const SMB_Header_length;

zeek::RecordValPtr BuildSMB2HeaderVal(SMB2_Header* hdr);
zeek::RecordValPtr BuildSMB2GUID(SMB2_guid* file_id);
zeek::RecordValPtr smb2_file_attrs_to_zeek(SMB2_file_attributes* val);
zeek::RecordValPtr BuildSMB2ContextVal(SMB3_negotiate_context_value* ncv);


class SMB2_PDU final {
public:
    SMB2_PDU(bool is_orig);
    ~SMB2_PDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    SMB2_Header* header() const { return header_; }
    int message_case_index() const	{ return message_case_index_; }
    SMB2_error_response* err() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( message_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:166:err", (int64)message_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return err_;
    }
    SMB2_Message* msg() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( message_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:167:msg", (int64)message_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return msg_;
    }
    uint32 pad_case_index() const	{ return pad_case_index_; }
    bytestring const& chain_pad() const {
        return chain_pad_;
    }
    bool is_orig() const { return is_orig_; }
    bool end_of_chain() const { return end_of_chain_; }

protected:
    SMB2_Header* header_;
    int message_case_index_;
    SMB2_error_response* err_;
    SMB2_Message* msg_;
    uint32 pad_case_index_;
    bytestring chain_pad_;
    bool is_orig_;
    bool end_of_chain_;
};


class SMB2_Message final {
public:
    SMB2_Message(SMB2_Header* header, bool is_orig);
    ~SMB2_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    SMB2_Message_Request* request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:178:request", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return request_;
    }
    SMB2_Message_Response* response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:179:response", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return response_;
    }
    SMB2_Header* header() const { return header_; }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    int val_case_index_;
    SMB2_Message_Request* request_;
    SMB2_Message_Response* response_;
    SMB2_Header* header_;
    bool is_orig_;
    int byteorder_;
};


class SMB2_Message_Request final {
public:
    SMB2_Message_Request(SMB2_Header* header);
    ~SMB2_Message_Request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint16 val_case_index() const	{ return val_case_index_; }
    SMB2_negotiate_request* negotiate_protocol() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:183:negotiate_protocol", (int64)val_case_index(), "SMB2_NEGOTIATE_PROTOCOL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return negotiate_protocol_;
    }
    SMB2_session_setup_request* session_setup() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:184:session_setup", (int64)val_case_index(), "SMB2_SESSION_SETUP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return session_setup_;
    }
    SMB2_tree_connect_request* tree_connect() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:185:tree_connect", (int64)val_case_index(), "SMB2_TREE_CONNECT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tree_connect_;
    }
    SMB2_tree_disconnect_request* tree_disconnect() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:186:tree_disconnect", (int64)val_case_index(), "SMB2_TREE_DISCONNECT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tree_disconnect_;
    }
    SMB2_create_request* create() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:187:create", (int64)val_case_index(), "SMB2_CREATE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return create_;
    }
    SMB2_close_request* close() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:188:close", (int64)val_case_index(), "SMB2_CLOSE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return close_;
    }
    SMB2_flush_request* flush() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:189:flush", (int64)val_case_index(), "SMB2_FLUSH");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return flush_;
    }
    SMB2_read_request* read() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:190:read", (int64)val_case_index(), "SMB2_READ");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return read_;
    }
    SMB2_write_request* write() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:191:write", (int64)val_case_index(), "SMB2_WRITE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return write_;
    }
    SMB2_lock_request* lock() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:192:lock", (int64)val_case_index(), "SMB2_LOCK");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return lock_;
    }
    SMB2_ioctl_request* ioctl() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:193:ioctl", (int64)val_case_index(), "SMB2_IOCTL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ioctl_;
    }
    SMB2_cancel_request* cancel() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)12):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:194:cancel", (int64)val_case_index(), "SMB2_CANCEL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return cancel_;
    }
    SMB2_echo_request* echo() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)13):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:195:echo", (int64)val_case_index(), "SMB2_ECHO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return echo_;
    }
    SMB2_query_directory_request* query_directory() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)14):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:196:query_directory", (int64)val_case_index(), "SMB2_QUERY_DIRECTORY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return query_directory_;
    }
    SMB2_change_notify_request* change_notify() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:197:change_notify", (int64)val_case_index(), "SMB2_CHANGE_NOTIFY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return change_notify_;
    }
    SMB2_query_info_request* query_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:198:query_info", (int64)val_case_index(), "SMB2_QUERY_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return query_info_;
    }
    SMB2_set_info_request* set_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)17):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:199:set_info", (int64)val_case_index(), "SMB2_SET_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return set_info_;
    }
    SMB2_oplock_break* oplock_break() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)18):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:200:oplock_break", (int64)val_case_index(), "SMB2_OPLOCK_BREAK");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return oplock_break_;
    }
    SMB2_Header* header() const { return header_; }
    int byteorder() const { return byteorder_; }

protected:
    uint16 val_case_index_;
    SMB2_negotiate_request* negotiate_protocol_;
    SMB2_session_setup_request* session_setup_;
    SMB2_tree_connect_request* tree_connect_;
    SMB2_tree_disconnect_request* tree_disconnect_;
    SMB2_create_request* create_;
    SMB2_close_request* close_;
    SMB2_flush_request* flush_;
    SMB2_read_request* read_;
    SMB2_write_request* write_;
    SMB2_lock_request* lock_;
    SMB2_ioctl_request* ioctl_;
    SMB2_cancel_request* cancel_;
    SMB2_echo_request* echo_;
    SMB2_query_directory_request* query_directory_;
    SMB2_change_notify_request* change_notify_;
    SMB2_query_info_request* query_info_;
    SMB2_set_info_request* set_info_;
    SMB2_oplock_break* oplock_break_;
    SMB2_Header* header_;
    int byteorder_;
};


class SMB2_Message_Response final {
public:
    SMB2_Message_Response(SMB2_Header* header);
    ~SMB2_Message_Response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint16 val_case_index() const	{ return val_case_index_; }
    SMB2_negotiate_response* negotiate_protocol() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:206:negotiate_protocol", (int64)val_case_index(), "SMB2_NEGOTIATE_PROTOCOL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return negotiate_protocol_;
    }
    SMB2_session_setup_response* session_setup() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:207:session_setup", (int64)val_case_index(), "SMB2_SESSION_SETUP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return session_setup_;
    }
    SMB2_tree_connect_response* tree_connect() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:208:tree_connect", (int64)val_case_index(), "SMB2_TREE_CONNECT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tree_connect_;
    }
    SMB2_tree_disconnect_response* tree_disconnect() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:209:tree_disconnect", (int64)val_case_index(), "SMB2_TREE_DISCONNECT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tree_disconnect_;
    }
    SMB2_create_response* create() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:210:create", (int64)val_case_index(), "SMB2_CREATE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return create_;
    }
    SMB2_close_response* close() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:211:close", (int64)val_case_index(), "SMB2_CLOSE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return close_;
    }
    SMB2_flush_response* flush() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:212:flush", (int64)val_case_index(), "SMB2_FLUSH");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return flush_;
    }
    SMB2_read_response* read() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:213:read", (int64)val_case_index(), "SMB2_READ");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return read_;
    }
    SMB2_write_response* write() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:214:write", (int64)val_case_index(), "SMB2_WRITE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return write_;
    }
    SMB2_lock_response* lock() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:215:lock", (int64)val_case_index(), "SMB2_LOCK");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return lock_;
    }
    SMB2_ioctl_response* ioctl() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:216:ioctl", (int64)val_case_index(), "SMB2_IOCTL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ioctl_;
    }
    SMB2_echo_response* echo() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)13):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:217:echo", (int64)val_case_index(), "SMB2_ECHO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return echo_;
    }
    SMB2_query_directory_response* query_directory() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)14):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:218:query_directory", (int64)val_case_index(), "SMB2_QUERY_DIRECTORY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return query_directory_;
    }
    SMB2_change_notify_response* change_notify() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:219:change_notify", (int64)val_case_index(), "SMB2_CHANGE_NOTIFY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return change_notify_;
    }
    SMB2_query_info_response* query_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:220:query_info", (int64)val_case_index(), "SMB2_QUERY_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return query_info_;
    }
    SMB2_set_info_response* set_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)17):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:221:set_info", (int64)val_case_index(), "SMB2_SET_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return set_info_;
    }
    SMB2_oplock_break* oplock_break() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)18):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:222:oplock_break", (int64)val_case_index(), "SMB2_OPLOCK_BREAK");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return oplock_break_;
    }
    SMB2_Header* header() const { return header_; }
    int byteorder() const { return byteorder_; }

protected:
    uint16 val_case_index_;
    SMB2_negotiate_response* negotiate_protocol_;
    SMB2_session_setup_response* session_setup_;
    SMB2_tree_connect_response* tree_connect_;
    SMB2_tree_disconnect_response* tree_disconnect_;
    SMB2_create_response* create_;
    SMB2_close_response* close_;
    SMB2_flush_response* flush_;
    SMB2_read_response* read_;
    SMB2_write_response* write_;
    SMB2_lock_response* lock_;
    SMB2_ioctl_response* ioctl_;
    SMB2_echo_response* echo_;
    SMB2_query_directory_response* query_directory_;
    SMB2_change_notify_response* change_notify_;
    SMB2_query_info_response* query_info_;
    SMB2_set_info_response* set_info_;
    SMB2_oplock_break* oplock_break_;
    SMB2_Header* header_;
    int byteorder_;
};


class SMB2_file_attributes final {
public:
    SMB2_file_attributes();
    ~SMB2_file_attributes();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 flags() const { return flags_; }
    bool read_only() const { return read_only_; }
    bool hidden() const { return hidden_; }
    bool system() const { return system_; }
    bool directory() const { return directory_; }
    bool archive() const { return archive_; }
    bool normal() const { return normal_; }
    bool temporary() const { return temporary_; }
    bool sparse_file() const { return sparse_file_; }
    bool reparse_point() const { return reparse_point_; }
    bool compressed() const { return compressed_; }
    bool offline() const { return offline_; }
    bool not_content_indexed() const { return not_content_indexed_; }
    bool encrypted() const { return encrypted_; }
    bool integrity_stream() const { return integrity_stream_; }
    bool no_scrub_data() const { return no_scrub_data_; }

protected:
    uint32 flags_;
    bool read_only_;
    bool hidden_;
    bool system_;
    bool directory_;
    bool archive_;
    bool normal_;
    bool temporary_;
    bool sparse_file_;
    bool reparse_point_;
    bool compressed_;
    bool offline_;
    bool not_content_indexed_;
    bool encrypted_;
    bool integrity_stream_;
    bool no_scrub_data_;
};


class SMB2_Header final {
public:
    SMB2_Header(bool is_orig);
    ~SMB2_Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint16 head_length() const { return head_length_; }
    uint16 credit_charge() const { return credit_charge_; }
    uint32 status() const { return status_; }
    uint16 command() const { return command_; }
    uint16 credits() const { return credits_; }
    uint32 flags() const { return flags_; }
    uint32 next_command() const { return next_command_; }
    uint64 message_id() const { return message_id_; }
    uint32 process_id() const { return process_id_; }
    uint32 tree_id() const { return tree_id_; }
    uint64 session_id() const { return session_id_; }
    bytestring const& signature() const { return signature_; }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }
    int response() const { return response_; }
    int async() const { return async_; }
    int related() const { return related_; }
    int msigned() const { return msigned_; }
    int dfs() const { return dfs_; }
    int request_tree_id() const { return request_tree_id_; }
    bool is_pipe() const { return is_pipe_; }
    bool proc() const { return proc_; }

protected:
    uint16 head_length_;
    uint16 credit_charge_;
    uint32 status_;
    uint16 command_;
    uint16 credits_;
    uint32 flags_;
    uint32 next_command_;
    uint64 message_id_;
    uint32 process_id_;
    uint32 tree_id_;
    uint64 session_id_;
    bytestring signature_;
    bool is_orig_;
    int byteorder_;
    int response_;
    int async_;
    int related_;
    int msigned_;
    int dfs_;
    int request_tree_id_;
    bool is_pipe_;
    bool proc_;
};


class SMB2_guid final {
public:
    SMB2_guid();
    ~SMB2_guid();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint64 persistent() const { return persistent_; }
    uint64 _volatile() const { return _volatile_; }

protected:
    uint64 persistent_;
    uint64 _volatile_;
};


class SMB2_File_Notify_Information final {
public:
    SMB2_File_Notify_Information();
    ~SMB2_File_Notify_Information();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 next_entry_offset() const { return next_entry_offset_; }
    uint32 action() const { return action_; }
    uint32 filename_len() const { return filename_len_; }
    SMB2_string* filename() const { return filename_; }

protected:
    uint32 next_entry_offset_;
    uint32 action_;
    uint32 filename_len_;
    SMB2_string* filename_;
};


class SMB2_symlink_error final {
public:
    SMB2_symlink_error(uint32 byte_count);
    ~SMB2_symlink_error();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint32 sym_link_length() const { return sym_link_length_; }
    uint32 sym_link_err_tag() const { return sym_link_err_tag_; }
    uint32 reparse_tag() const { return reparse_tag_; }
    uint16 reparse_data_len() const { return reparse_data_len_; }
    uint16 unparsed_path_len() const { return unparsed_path_len_; }
    uint16 sub_name_offset() const { return sub_name_offset_; }
    uint16 sub_name_length() const { return sub_name_length_; }
    uint16 print_name_offset() const { return print_name_offset_; }
    uint16 print_name_length() const { return print_name_length_; }
    uint32 flags() const { return flags_; }
    bytestring const& path_buffer() const { return path_buffer_; }
    uint32 byte_count() const { return byte_count_; }
    int byteorder() const { return byteorder_; }
    int absolute_target_path() const { return absolute_target_path_; }
    int symlink_flag_relative() const { return symlink_flag_relative_; }

protected:
    uint32 sym_link_length_;
    uint32 sym_link_err_tag_;
    uint32 reparse_tag_;
    uint16 reparse_data_len_;
    uint16 unparsed_path_len_;
    uint16 sub_name_offset_;
    uint16 sub_name_length_;
    uint16 print_name_offset_;
    uint16 print_name_length_;
    uint32 flags_;
    bytestring path_buffer_;
    uint32 byte_count_;
    int byteorder_;
    int absolute_target_path_;
    int symlink_flag_relative_;
};


class SMB2_error_data final {
public:
    SMB2_error_data(SMB2_Header* header, uint32 byte_count);
    ~SMB2_error_data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint32 val_case_index() const	{ return val_case_index_; }
    SMB2_symlink_error* error() const {
        return error_;
    }
    SMB2_Header* header() const { return header_; }
    uint32 byte_count() const { return byte_count_; }
    int byteorder() const { return byteorder_; }

protected:
    uint32 val_case_index_;
    SMB2_symlink_error* error_;
    SMB2_Header* header_;
    uint32 byte_count_;
    int byteorder_;
};


class SMB2_error_response final {
public:
    SMB2_error_response(SMB2_Header* header);
    ~SMB2_error_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint32 byte_count() const { return byte_count_; }
    SMB2_Header* header() const { return header_; }
    int byteorder() const { return byteorder_; }

protected:
    uint16 structure_size_;
    uint32 byte_count_;
    const_bytestring stuff_;
    SMB2_Header* header_;
    int byteorder_;
};


class SMB2_logoff_request final {
public:
    SMB2_logoff_request(SMB2_Header* header);
    ~SMB2_logoff_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved() const { return reserved_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 reserved_;
    SMB2_Header* header_;
};


class SMB2_logoff_response final {
public:
    SMB2_logoff_response(SMB2_Header* header);
    ~SMB2_logoff_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved() const { return reserved_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 reserved_;
    SMB2_Header* header_;
};


class SMB2_flush_request final {
public:
    SMB2_flush_request(SMB2_Header* header);
    ~SMB2_flush_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved1() const { return reserved1_; }
    uint32 reserved2() const { return reserved2_; }
    SMB2_guid* file_id() const { return file_id_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 reserved1_;
    uint32 reserved2_;
    SMB2_guid* file_id_;
    SMB2_Header* header_;
};


class SMB2_flush_response final {
public:
    SMB2_flush_response(SMB2_Header* header);
    ~SMB2_flush_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved1() const { return reserved1_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 reserved1_;
    SMB2_Header* header_;
};


class SMB2_cancel_request final {
public:
    SMB2_cancel_request(SMB2_Header* header);
    ~SMB2_cancel_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved() const { return reserved_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 reserved_;
    SMB2_Header* header_;
};


class SMB2_echo_request final {
public:
    SMB2_echo_request(SMB2_Header* header);
    ~SMB2_echo_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved() const { return reserved_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 reserved_;
    SMB2_Header* header_;
};


class SMB2_echo_response final {
public:
    SMB2_echo_response(SMB2_Header* header);
    ~SMB2_echo_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 reserved() const { return reserved_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 reserved_;
    SMB2_Header* header_;
};


class SMB2_query_directory_request final {
public:
    SMB2_query_directory_request(SMB2_Header* header);
    ~SMB2_query_directory_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint8 _class() const { return _class_; }
    uint8 flags() const { return flags_; }
    uint32 file_index() const { return file_index_; }
    SMB2_guid* file_id() const { return file_id_; }
    uint16 file_name_offset() const { return file_name_offset_; }
    uint16 file_name_len() const { return file_name_len_; }
    uint32 output_buffer_len() const { return output_buffer_len_; }
    bytestring const& file_name() const { return file_name_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint8 _class_;
    uint8 flags_;
    uint32 file_index_;
    SMB2_guid* file_id_;
    uint16 file_name_offset_;
    uint16 file_name_len_;
    uint32 output_buffer_len_;
    bytestring file_name_;
    SMB2_Header* header_;
};


class SMB2_query_directory_response final {
public:
    SMB2_query_directory_response(SMB2_Header* header);
    ~SMB2_query_directory_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 buffer_offset() const { return buffer_offset_; }
    uint32 buffer_len() const { return buffer_len_; }
    bytestring const& buffer() const { return buffer_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 buffer_offset_;
    uint32 buffer_len_;
    bytestring buffer_;
    SMB2_Header* header_;
};


class SMB2_change_notify_request final {
public:
    SMB2_change_notify_request(SMB2_Header* header);
    ~SMB2_change_notify_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 flags() const { return flags_; }
    uint32 output_buffer_len() const { return output_buffer_len_; }
    SMB2_guid* file_id() const { return file_id_; }
    uint32 completion_filter() const { return completion_filter_; }
    uint32 reserved() const { return reserved_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 flags_;
    uint32 output_buffer_len_;
    SMB2_guid* file_id_;
    uint32 completion_filter_;
    uint32 reserved_;
    SMB2_Header* header_;
};


class SMB2_change_notify_response final {
public:
    SMB2_change_notify_response(SMB2_Header* header);
    ~SMB2_change_notify_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 output_buffer_offset() const { return output_buffer_offset_; }
    uint32 output_buffer_len() const { return output_buffer_len_; }
    vector<SMB2_File_Notify_Information*>* buffer() const { return buffer_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 output_buffer_offset_;
    uint32 output_buffer_len_;
    vector<SMB2_File_Notify_Information*>* buffer_;
    SMB2_File_Notify_Information* buffer__elem_;
    SMB2_Header* header_;
};


class SMB2_query_info_request final {
public:
    SMB2_query_info_request(SMB2_Header* header);
    ~SMB2_query_info_request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint8 info_type() const { return info_type_; }
    uint8 file_info_class() const { return file_info_class_; }
    uint32 output_buffer_len() const { return output_buffer_len_; }
    uint16 input_buffer_offset() const { return input_buffer_offset_; }
    uint16 reserved() const { return reserved_; }
    uint32 input_buffer_len() const { return input_buffer_len_; }
    uint32 additional_info() const { return additional_info_; }
    uint32 flags() const { return flags_; }
    SMB2_guid* file_id() const { return file_id_; }
    bytestring const& buffer() const { return buffer_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint8 info_type_;
    uint8 file_info_class_;
    uint32 output_buffer_len_;
    uint16 input_buffer_offset_;
    uint16 reserved_;
    uint32 input_buffer_len_;
    uint32 additional_info_;
    uint32 flags_;
    SMB2_guid* file_id_;
    bytestring buffer_;
    SMB2_Header* header_;
};


class SMB2_query_info_response final {
public:
    SMB2_query_info_response(SMB2_Header* header);
    ~SMB2_query_info_response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint16 buffer_offset() const { return buffer_offset_; }
    uint32 buffer_len() const { return buffer_len_; }
    bytestring const& buffer() const { return buffer_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint16 buffer_offset_;
    uint32 buffer_len_;
    bytestring buffer_;
    SMB2_Header* header_;
};


class SMB2_oplock_break final {
public:
    SMB2_oplock_break(SMB2_Header* header);
    ~SMB2_oplock_break();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder);

    // Member access functions
    uint16 structure_size() const { return structure_size_; }
    uint8 oplock_level() const { return oplock_level_; }
    uint8 reserved() const { return reserved_; }
    uint32 reserved2() const { return reserved2_; }
    SMB2_guid* file_id() const { return file_id_; }
    SMB2_Header* header() const { return header_; }

protected:
    uint16 structure_size_;
    uint8 oplock_level_;
    uint8 reserved_;
    uint32 reserved2_;
    SMB2_guid* file_id_;
    SMB2_Header* header_;
};


class SMB_Flow final : public binpac::FlowAnalyzer {
public:
    SMB_Flow(SMB_Conn* connection, bool is_orig);
    ~SMB_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    SMB_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

protected:
    SMB_TCP* dataunit_;
    ContextSMB* context_;
    FlowBuffer* flow_buffer_;
    SMB_Conn* connection_;
    bool is_orig_;
};

} // namespace SMB
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_smb_smb_pac_h */
