// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/snmp/snmp_pac.h"

namespace binpac {






namespace SNMP {
// NOLINTNEXTLINE(modernize-use-equals-default)
ContextSNMP::ContextSNMP(SNMP_Conn* connection, SNMP_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextSNMP::~ContextSNMP() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SNMP_Conn::SNMP_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new SNMP_Flow(this, true);
    downflow_ = new SNMP_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SNMP_Conn::~SNMP_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void SNMP_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void SNMP_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void SNMP_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool SNMP_Conn::proc_get_request(GetRequestPDU* pdu) {

		if ( ! snmp_get_request )
			return false;

		zeek::BifEvent::enqueue_snmp_get_request(zeek_analyzer(),
		                                   zeek_analyzer()->Conn(),
		                                   pdu->header()->is_orig(),
		                                   build_hdr(pdu->header()),
		                                   build_pdu(pdu->pdu()));
		return true;
		
}

bool SNMP_Conn::proc_get_next_request(GetNextRequestPDU* pdu) {

		if ( ! snmp_get_next_request )
			return false;

		zeek::BifEvent::enqueue_snmp_get_next_request(zeek_analyzer(),
		                                        zeek_analyzer()->Conn(),
		                                        pdu->header()->is_orig(),
		                                        build_hdr(pdu->header()),
		                                        build_pdu(pdu->pdu()));
		return true;
		
}

bool SNMP_Conn::proc_response(ResponsePDU* pdu) {

		if ( ! snmp_response )
			return false;

		zeek::BifEvent::enqueue_snmp_response(zeek_analyzer(),
		                                zeek_analyzer()->Conn(),
		                                pdu->header()->is_orig(),
		                                build_hdr(pdu->header()),
		                                build_pdu(pdu->pdu()));
		return true;
		
}

bool SNMP_Conn::proc_set_request(SetRequestPDU* pdu) {

		if ( ! snmp_set_request )
			return false;

		zeek::BifEvent::enqueue_snmp_set_request(zeek_analyzer(),
		                                   zeek_analyzer()->Conn(),
		                                   pdu->header()->is_orig(),
		                                   build_hdr(pdu->header()),
		                                   build_pdu(pdu->pdu()));
		return true;
		
}

bool SNMP_Conn::proc_trap(TrapPDU* pdu) {

		if ( ! snmp_trap )
			return false;

		zeek::BifEvent::enqueue_snmp_trap(zeek_analyzer(),
		                            zeek_analyzer()->Conn(),
		                            pdu->header()->is_orig(),
		                            build_hdr(pdu->header()),
		                            build_trap_pdu(pdu));
		return true;
		
}

bool SNMP_Conn::proc_get_bulk_request(GetBulkRequestPDU* pdu) {

		if ( ! snmp_get_bulk_request )
			return false;

		zeek::BifEvent::enqueue_snmp_get_bulk_request(zeek_analyzer(),
		                                        zeek_analyzer()->Conn(),
		                                        pdu->header()->is_orig(),
		                                        build_hdr(pdu->header()),
		                                        build_bulk_pdu(pdu));
		return true;
		
}

bool SNMP_Conn::proc_inform_request(InformRequestPDU* pdu) {

		if ( ! snmp_inform_request )
			return false;

		zeek::BifEvent::enqueue_snmp_inform_request(zeek_analyzer(),
		                                      zeek_analyzer()->Conn(),
		                                      pdu->header()->is_orig(),
		                                      build_hdr(pdu->header()),
		                                      build_pdu(pdu->pdu()));
		return true;
		
}

bool SNMP_Conn::proc_v2_trap(v2TrapPDU* pdu) {

		if ( ! snmp_trapV2 )
			return false;

		zeek::BifEvent::enqueue_snmp_trapV2(zeek_analyzer(),
		                              zeek_analyzer()->Conn(),
		                              pdu->header()->is_orig(),
		                              build_hdr(pdu->header()),
		                              build_pdu(pdu->pdu()));
		return true;
		
}

bool SNMP_Conn::proc_report(ReportPDU* pdu) {

		if ( ! snmp_report )
			return false;

		zeek::BifEvent::enqueue_snmp_report(zeek_analyzer(),
		                              zeek_analyzer()->Conn(),
		                              pdu->header()->is_orig(),
		                              build_hdr(pdu->header()),
		                              build_pdu(pdu->pdu()));
		return true;
		
}

bool SNMP_Conn::proc_unknown_version_header(UnknownVersionHeader* rec) {

		if ( ! snmp_unknown_header_version )
			return false;

		zeek::BifEvent::enqueue_snmp_unknown_header_version(zeek_analyzer(),
		                                              zeek_analyzer()->Conn(),
		                                              rec->header()->is_orig(),
		                                              rec->header()->version());
		return true;
		
}

bool SNMP_Conn::proc_unknown_pdu(UnknownPDU* rec) {

		if ( ! snmp_unknown_pdu )
			return false;

		zeek::BifEvent::enqueue_snmp_unknown_pdu(zeek_analyzer(),
		                                   zeek_analyzer()->Conn(),
		                                   rec->header()->is_orig(),
		                                   build_hdr(rec->header()),
		                                   rec->tag());
		return true;
		
}

bool SNMP_Conn::proc_unknown_scoped_pdu(UnknownScopedPDU* rec) {

		if ( ! snmp_unknown_scoped_pdu )
			return false;

		zeek::BifEvent::enqueue_snmp_unknown_scoped_pdu(zeek_analyzer(),
		                                          zeek_analyzer()->Conn(),
		                                          rec->header()->is_orig(),
		                                          build_hdr(rec->header()),
		                                          rec->tag());
		return true;
		
}

bool SNMP_Conn::proc_encrypted_pdu(EncryptedPDU* rec) {

		if ( ! snmp_encrypted_pdu )
			return false;

		zeek::BifEvent::enqueue_snmp_encrypted_pdu(zeek_analyzer(),
		                                     zeek_analyzer()->Conn(),
		                                     rec->header()->is_orig(),
		                                     build_hdr(rec->header()));
		return true;
		
}

bool SNMP_Conn::proc_header(Header* rec) {

		if ( ! rec->is_orig() )
			zeek_analyzer()->AnalyzerConfirmation();

		if ( rec->unknown() )
			return false;

		return true;
		
}

bool SNMP_Conn::proc_v3_header_data(v3HeaderData* rec) {

		if ( rec->flags()->encoding()->content().length() == 1 )
			return true;

		zeek_analyzer()->AnalyzerViolation("Invalid v3 HeaderData msgFlags");
		return false;
		
}

bool SNMP_Conn::check_tag(ASN1EncodingMeta* rec, uint8 expect) {

		if ( rec->tag() == expect )
			return true;

		// Unwind now to stop parsing because it's definitely the
		// wrong protocol and parsing further could be expensive.
		// Upper layer of analyzer will catch and call AnalyzerViolation().
		throw binpac::Exception(zeek::util::fmt("Got ASN.1 tag %d, expect %d",
		                        rec->tag(), expect));
		return false;
		
}

bool SNMP_Conn::check_int_width(ASN1Integer* rec) {

		int len = rec->encoding()->content().length();

		if ( len <= 9 )
			// All integers use two's complement form, so an unsigned 64-bit
			// integer value can require 9 octets to encode if the highest
			// order bit is set.
			return true;

		throw binpac::Exception(zeek::util::fmt("ASN.1 integer width overflow: %d", len));
		return false;
		
}

bool SNMP_Conn::check_int(ASN1Integer* rec) {

		return check_tag(rec->encoding()->meta(), ASN1_INTEGER_TAG) &&
		       check_int_width(rec);
		
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Encoding::ASN1Encoding() {
    meta_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Encoding::~ASN1Encoding() {
    delete meta_;
    meta_ = nullptr;
    content_.free();
}

int ASN1Encoding::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "meta"
    meta_ = new ASN1EncodingMeta();
    int t_meta__size;
    t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_meta = t_begin_of_data + (t_meta__size);
    BINPAC_ASSERT(t_dataptr_after_meta <= t_end_of_data);
    // Parse "content"
    int t_content__size;
    t_content__size = meta()->length();
    // Checking out-of-bound for "ASN1Encoding:content"
    if ( t_dataptr_after_meta + (t_content__size) > t_end_of_data || t_dataptr_after_meta + (t_content__size) < t_dataptr_after_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1Encoding:content",
        	((t_dataptr_after_meta - t_begin_of_data)) + (t_content__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_meta + t_content__size;
        int t_content_string_length;
        t_content_string_length = meta()->length();
        // check for negative sizes
        if ( t_content_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/snmp/../asn1/asn1.pac:36", t_content_string_length);
        content_.init(t_dataptr_after_meta, t_content_string_length);
    }

    int t_ASN1Encoding__size;
    const_byteptr const t_dataptr_after_content = t_dataptr_after_meta + (t_content__size);
    BINPAC_ASSERT(t_dataptr_after_content <= t_end_of_data);
    t_ASN1Encoding__size = t_dataptr_after_content - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Encoding__size) <= t_end_of_data);
    return t_ASN1Encoding__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1EncodingMeta::ASN1EncodingMeta() {
    tag_ = 0;
    len_ = 0;
    long_len_ = false;
    length_ = 0;
    index_ = 0;
    tag_class_ = 0;
    simple_type_ = false;
    tag_num_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1EncodingMeta::~ASN1EncodingMeta() {
    more_len_.free();
}

int ASN1EncodingMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "ASN1EncodingMeta:len"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1EncodingMeta:len",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "tag"
    tag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "len"
    len_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "more_len"
    int t_more_len__size;
    long_len_ =  ( len() & 0x80 )  > 0;
    t_more_len__size = long_len() ? len() & 0x7f : 0;
    // Checking out-of-bound for "ASN1EncodingMeta:more_len"
    if ( (t_begin_of_data + 2) + (t_more_len__size) > t_end_of_data || (t_begin_of_data + 2) + (t_more_len__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1EncodingMeta:more_len",
        	(2) + (t_more_len__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_more_len__size;
        int t_more_len_string_length;
        t_more_len_string_length = long_len() ? len() & 0x7f : 0;
        // check for negative sizes
        if ( t_more_len_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/snmp/../asn1/asn1.pac:42", t_more_len_string_length);
        more_len_.init((t_begin_of_data + 2), t_more_len_string_length);
    }

    int t_ASN1EncodingMeta__size;
    const_byteptr const t_dataptr_after_more_len = (t_begin_of_data + 2) + (t_more_len__size);
    BINPAC_ASSERT(t_dataptr_after_more_len <= t_end_of_data);
    t_ASN1EncodingMeta__size = t_dataptr_after_more_len - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    length_ = long_len() ? binary_to_int64(more_len()) : len();
    index_ = tag() - ASN1_INDEX_TAG_OFFSET;
    tag_class_ =  ( tag() & 0xC0 )  >> 6;
    simple_type_ =  ( tag() & 20 )  >> 5;
    tag_num_ = tag() & 0x1F;
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1EncodingMeta__size) <= t_end_of_data);
    return t_ASN1EncodingMeta__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1OptionalEncodingMeta::ASN1OptionalEncodingMeta(bool is_present, ASN1EncodingMeta* previous_metadata) {
    val_case_index_ = -1;
    data_ = nullptr;
    is_present_ = is_present;
    previous_metadata_ = previous_metadata;
    length_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1OptionalEncodingMeta::~ASN1OptionalEncodingMeta() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "data"
            {
                delete data_;
                data_ = nullptr;
            }
            break;
        case false:
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ASN1OptionalEncodingMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    int t_val__size;
    val_case_index_ = is_present();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "data"
            {
                data_ = new ASN1EncodingMeta();
                int t_data__size;
                t_data__size = data_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_data__size;
            }
            break;
        case false:
            // Parse "none"
            {
                t_val__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("ASN1OptionalEncodingMeta", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    length_ = is_present() ? data()->length() : previous_metadata()->length();
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1SequenceMeta::ASN1SequenceMeta() {
    encoding_ = nullptr;
    valid_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1SequenceMeta::~ASN1SequenceMeta() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1SequenceMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "encoding"
    encoding_ = new ASN1EncodingMeta();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1SequenceMeta__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1SequenceMeta__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    valid_ = t_context->connection()->check_tag(encoding(), ASN1_SEQUENCE_TAG);
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1SequenceMeta__size) <= t_end_of_data);
    return t_ASN1SequenceMeta__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Integer::ASN1Integer() {
    encoding_ = nullptr;
    valid_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Integer::~ASN1Integer() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Integer::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Integer__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Integer__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    valid_ = t_context->connection()->check_int(this);
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Integer__size) <= t_end_of_data);
    return t_ASN1Integer__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1OctetString::ASN1OctetString() {
    encoding_ = nullptr;
    valid_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1OctetString::~ASN1OctetString() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1OctetString::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1OctetString__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1OctetString__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    valid_ = t_context->connection()->check_tag(encoding()->meta(), ASN1_OCTET_STRING_TAG);
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1OctetString__size) <= t_end_of_data);
    return t_ASN1OctetString__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1ObjectIdentifier::ASN1ObjectIdentifier() {
    encoding_ = nullptr;
    valid_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1ObjectIdentifier::~ASN1ObjectIdentifier() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1ObjectIdentifier::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1ObjectIdentifier__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1ObjectIdentifier__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    valid_ = t_context->connection()->check_tag(encoding()->meta(), ASN1_OBJECT_IDENTIFIER_TAG);
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1ObjectIdentifier__size) <= t_end_of_data);
    return t_ASN1ObjectIdentifier__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Boolean::ASN1Boolean() {
    encoding_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Boolean::~ASN1Boolean() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Boolean::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Boolean__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Boolean__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Boolean__size) <= t_end_of_data);
    return t_ASN1Boolean__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Enumerated::ASN1Enumerated() {
    encoding_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Enumerated::~ASN1Enumerated() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Enumerated::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Enumerated__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Enumerated__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Enumerated__size) <= t_end_of_data);
    return t_ASN1Enumerated__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SequenceElement::SequenceElement(bool grab_content) {
    index_meta_ = nullptr;
    have_content_case_index_ = -1;
    data_ = nullptr;
    meta_ = nullptr;
    grab_content_ = grab_content;
    index_ = 0;
    length_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SequenceElement::~SequenceElement() {
    delete index_meta_;
    index_meta_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_content_case_index() ) {
        case true:
            // Clean up "data"
            {
                delete data_;
                data_ = nullptr;
            }
            break;
        case false:
            // Clean up "meta"
            {
                delete meta_;
                meta_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SequenceElement::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "index_meta"
    index_meta_ = new ASN1EncodingMeta();
    int t_index_meta__size;
    t_index_meta__size = index_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_index_meta = t_begin_of_data + (t_index_meta__size);
    BINPAC_ASSERT(t_dataptr_after_index_meta <= t_end_of_data);
    // Parse "have_content"
    int t_have_content__size;
    have_content_case_index_ = grab_content();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_content_case_index() ) {
        case true:
            // Parse "data"
            {
                data_ = new ASN1Encoding();
                int t_data__size;
                t_data__size = data_->Parse(t_dataptr_after_index_meta, t_end_of_data);
                t_have_content__size = t_data__size;
            }
            break;
        case false:
            // Parse "meta"
            {
                meta_ = new ASN1EncodingMeta();
                int t_meta__size;
                t_meta__size = meta_->Parse(t_dataptr_after_index_meta, t_end_of_data);
                t_have_content__size = t_meta__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SequenceElement", (int64)have_content_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SequenceElement__size;
    const_byteptr const t_dataptr_after_have_content = t_dataptr_after_index_meta + (t_have_content__size);
    BINPAC_ASSERT(t_dataptr_after_have_content <= t_end_of_data);
    t_SequenceElement__size = t_dataptr_after_have_content - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    index_ = index_meta()->index();
    length_ = index_meta()->length();
    BINPAC_ASSERT(t_begin_of_data + (t_SequenceElement__size) <= t_end_of_data);
    return t_SequenceElement__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Array::Array() {
    array_meta_ = nullptr;
    data_ = nullptr;
    data__elem_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Array::~Array() {
    delete array_meta_;
    array_meta_ = nullptr;
    delete data__elem_;
    data__elem_ = nullptr;
    if ( data() ) {
        for ( auto* data__elem_ : *data() ) {
            delete data__elem_;
            data__elem_ = nullptr;
        }
    }
    delete data_;
}

int Array::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "array_meta"
    array_meta_ = new ASN1EncodingMeta();
    int t_array_meta__size;
    t_array_meta__size = array_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_array_meta = t_begin_of_data + (t_array_meta__size);
    BINPAC_ASSERT(t_dataptr_after_array_meta <= t_end_of_data);
    // Parse "data"
    int t_data__arraylength;
    t_data__arraylength = 0;
    data__elem_ = nullptr;
    int t_data__elem__it;
    t_data__elem__it = 0;
    int t_data__size;
    data_ = new vector<ASN1Encoding*>;
    const_byteptr t_data__elem__dataptr = t_dataptr_after_array_meta;
    for (; /* forever */; ++t_data__elem__it) {
        // Check &until(data__elem__dataptr >= end_of_data)
        if ( t_data__elem__dataptr >= t_end_of_data ) {
            data__elem_ = nullptr;
            goto end_of_data;
        }
        data__elem_ = new ASN1Encoding();
        int t_data__elem__size;
        t_data__elem__size = data__elem_->Parse(t_data__elem__dataptr, t_end_of_data);
        data_->push_back(data__elem_);
        t_data__elem__dataptr += t_data__elem__size;
        BINPAC_ASSERT(t_data__elem__dataptr <= t_end_of_data);
        data__elem_ = nullptr;
    }
end_of_data: ;
    t_data__size = t_data__elem__dataptr - (t_dataptr_after_array_meta);
    // Evaluate 'let' and 'withinput' fields

    int t_Array__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_array_meta + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Array__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Array__size) <= t_end_of_data);
    return t_Array__size;
}

int64 binary_to_int64(bytestring const& bs) {

	int64 rval = 0;

	if ( bs.length() > 8 )
		{
		zeek::reporter->Weird("asn_binary_to_int64_shift_too_large", zeek::util::fmt("%d", bs.length()));
		return 0;
		}

	for ( int i = 0; i < bs.length(); ++i )
		{
		uint64 byte = bs[i];
		rval |= byte << (8 * (bs.length() - (i + 1)));
		}

	return rval;
	
}



zeek::ValPtr asn1_integer_to_val(const ASN1Integer* i, zeek::TypeTag t)
	{
	return asn1_integer_to_val(i->encoding(), t);
	}

zeek::ValPtr asn1_integer_to_val(const ASN1Encoding* i, zeek::TypeTag t)
	{
	auto v = binary_to_int64(i->content());

	switch ( t ) {
	case zeek::TYPE_BOOL:
		return zeek::val_mgr->Bool(v);
	case zeek::TYPE_INT:
		return zeek::val_mgr->Int(v);
	case zeek::TYPE_COUNT:
		return zeek::val_mgr->Count(v);
	default:
		zeek::reporter->Error("bad asn1_integer_to_val tag: %s", zeek::type_name(t));
		return zeek::val_mgr->Count(v);
	}
	}

zeek::StringValPtr asn1_oid_to_val(const ASN1ObjectIdentifier* oid)
	{
	return asn1_oid_to_val(oid->encoding());
	}

zeek::StringValPtr asn1_oid_to_val(const ASN1Encoding* oid)
	{
	vector<uint64> oid_components;
	vector<vector<uint8> > subidentifiers;
	vector<uint64> subidentifier_values;
	vector<uint8> subidentifier;
	bytestring const& bs = oid->content();

	for ( int i = 0; i < bs.length(); ++i )
		{
		if ( bs[i] & 0x80 )
			subidentifier.push_back(bs[i] & 0x7f);
		else
			{
			subidentifier.push_back(bs[i]);
			subidentifiers.push_back(subidentifier);
			subidentifier.clear();
			}
		}

	if ( ! subidentifier.empty() || subidentifiers.empty() )
		// Underflow.
		return zeek::val_mgr->EmptyString();

	for ( const auto& subidentifier : subidentifiers )
		{
		uint64 value = 0;

		for ( size_t j = 0; j < subidentifier.size(); ++j )
			{
			uint64 byte = subidentifier[j];
			value |= byte << (7 * (subidentifier.size() - (j + 1)));
			}

		subidentifier_values.push_back(value);
		}

	string rval;

	for ( size_t i = 0; i < subidentifier_values.size(); ++i )
		{
		char tmp[32];

		if ( i > 0 )
			{
			snprintf(tmp, sizeof(tmp), ".%" PRIu64, subidentifier_values[i]);
			rval += tmp;
			}
		else
			{
			std::div_t result = std::div(subidentifier_values[i], 40);
			snprintf(tmp, sizeof(tmp), "%d.%d", result.quot, result.rem);
			rval += tmp;
			}
		}

	return zeek::make_intrusive<zeek::StringVal>(rval);
	}

zeek::StringValPtr asn1_octet_string_to_val(const ASN1OctetString* s)
	{
	return asn1_octet_string_to_val(s->encoding());
	}

zeek::StringValPtr asn1_octet_string_to_val(const ASN1Encoding* s)
	{
	bytestring const& bs = s->content();
	return zeek::make_intrusive<zeek::StringVal>(bs.length(), reinterpret_cast<const char*>(bs.data()));
	}

// NOLINTNEXTLINE(modernize-use-equals-default)
TopLevelMessage::TopLevelMessage(bool is_orig) {
    asn1_sequence_meta_ = nullptr;
    version_ = nullptr;
    header_ = nullptr;
    pdu_or_not_case_index_ = -1;
    pdu_ = nullptr;
    is_orig_ = is_orig;
    version_value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TopLevelMessage::~TopLevelMessage() {
    delete asn1_sequence_meta_;
    asn1_sequence_meta_ = nullptr;
    delete version_;
    version_ = nullptr;
    delete header_;
    header_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( pdu_or_not_case_index() ) {
        case false:
            // Clean up "none"
            {
            }
            break;
        case true:
            // Clean up "pdu"
            {
                delete pdu_;
                pdu_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int TopLevelMessage::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "asn1_sequence_meta"
    asn1_sequence_meta_ = new ASN1SequenceMeta();
    int t_asn1_sequence_meta__size;
    t_asn1_sequence_meta__size = asn1_sequence_meta_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_asn1_sequence_meta = t_begin_of_data + (t_asn1_sequence_meta__size);
    BINPAC_ASSERT(t_dataptr_after_asn1_sequence_meta <= t_end_of_data);
    // Parse "version"
    version_ = new ASN1Integer();
    int t_version__size;
    t_version__size = version_->Parse(t_dataptr_after_asn1_sequence_meta, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_version = t_dataptr_after_asn1_sequence_meta + (t_version__size);
    BINPAC_ASSERT(t_dataptr_after_version <= t_end_of_data);
    // Parse "header"
    version_value_ = binary_to_int64(version()->encoding()->content());
    header_ = new Header(version_value(), is_orig());
    int t_header__size;
    t_header__size = header_->Parse(t_dataptr_after_version, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_header = t_dataptr_after_version + (t_header__size);
    BINPAC_ASSERT(t_dataptr_after_header <= t_end_of_data);
    // Parse "pdu_or_not"
    int t_pdu_or_not__size;
    pdu_or_not_case_index_ = have_plaintext_pdu(header());
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( pdu_or_not_case_index() ) {
        case false:
            // Parse "none"
            {
                t_pdu_or_not__size = 0;
            }
            break;
        case true:
            // Parse "pdu"
            {
                pdu_ = new PDU_Choice(header());
                int t_pdu__size;
                t_pdu__size = pdu_->Parse(t_dataptr_after_header, t_end_of_data, t_context);
                t_pdu_or_not__size = t_pdu__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("TopLevelMessage", (int64)pdu_or_not_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_TopLevelMessage__size;
    const_byteptr const t_dataptr_after_pdu_or_not = t_dataptr_after_header + (t_pdu_or_not__size);
    BINPAC_ASSERT(t_dataptr_after_pdu_or_not <= t_end_of_data);
    t_TopLevelMessage__size = t_dataptr_after_pdu_or_not - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_TopLevelMessage__size) <= t_end_of_data);
    return t_TopLevelMessage__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Header::Header(int64 version, bool is_orig) {
    val_case_index_ = -1;
    v1_ = nullptr;
    v2_ = nullptr;
    v3_ = nullptr;
    unknown_ = nullptr;
    version_ = version;
    is_orig_ = is_orig;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Header::~Header() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int64)0):
            // Clean up "v1"
            {
                delete v1_;
                v1_ = nullptr;
            }
            break;
        case ((int64)1):
            // Clean up "v2"
            {
                delete v2_;
                v2_ = nullptr;
            }
            break;
        case ((int64)3):
            // Clean up "v3"
            {
                delete v3_;
                v3_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                delete unknown_;
                unknown_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    int t_val__size;
    val_case_index_ = version();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int64)0):
            // Parse "v1"
            {
                v1_ = new v1Header(this);
                int t_v1__size;
                t_v1__size = v1_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_v1__size;
            }
            break;
        case ((int64)1):
            // Parse "v2"
            {
                v2_ = new v2Header(this);
                int t_v2__size;
                t_v2__size = v2_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_v2__size;
            }
            break;
        case ((int64)3):
            // Parse "v3"
            {
                v3_ = new v3Header(this);
                int t_v3__size;
                t_v3__size = v3_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_v3__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                unknown_ = new UnknownVersionHeader(this);
                int t_unknown__size;
                t_unknown__size = unknown_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_header(this);
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

bool have_plaintext_pdu(Header* header) {
    int t_t_var_001;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( header->version() ) {
        case ((int64)0):
            t_t_var_001 = true;
            break;
        case ((int64)1):
            t_t_var_001 = true;
            break;
        case ((int64)3):
            t_t_var_001 = header->v3()->next()->tag() == ASN1_SEQUENCE_TAG;
            break;
        default:
            t_t_var_001 = false;
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return static_cast<bool>(t_t_var_001);
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PDU_Choice::PDU_Choice(Header* header) {
    choice_ = nullptr;
    pdu_ = nullptr;
    header_ = header;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PDU_Choice::~PDU_Choice() {
    delete choice_;
    choice_ = nullptr;
    delete pdu_;
    pdu_ = nullptr;
}

int PDU_Choice::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "choice"
    choice_ = new ASN1EncodingMeta();
    int t_choice__size;
    t_choice__size = choice_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_choice = t_begin_of_data + (t_choice__size);
    BINPAC_ASSERT(t_dataptr_after_choice <= t_end_of_data);
    // Parse "pdu"
    pdu_ = new PDU(choice()->tag(), header());
    int t_pdu__size;
    t_pdu__size = pdu_->Parse(t_dataptr_after_choice, t_end_of_data, t_context);

    int t_PDU_Choice__size;
    const_byteptr const t_dataptr_after_pdu = t_dataptr_after_choice + (t_pdu__size);
    BINPAC_ASSERT(t_dataptr_after_pdu <= t_end_of_data);
    t_PDU_Choice__size = t_dataptr_after_pdu - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_PDU_Choice__size) <= t_end_of_data);
    return t_PDU_Choice__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PDU::PDU(uint8 choice, Header* header) {
    val_case_index_ = -1;
    unknown_ = nullptr;
    get_request_ = nullptr;
    get_next_request_ = nullptr;
    response_ = nullptr;
    set_request_ = nullptr;
    trap_ = nullptr;
    get_bulk_request_ = nullptr;
    inform_request_ = nullptr;
    v2_trap_ = nullptr;
    report_ = nullptr;
    choice_ = choice;
    header_ = header;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PDU::~PDU() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)160):
            // Clean up "get_request"
            {
                delete get_request_;
                get_request_ = nullptr;
            }
            break;
        case ((uint8)161):
            // Clean up "get_next_request"
            {
                delete get_next_request_;
                get_next_request_ = nullptr;
            }
            break;
        case ((uint8)162):
            // Clean up "response"
            {
                delete response_;
                response_ = nullptr;
            }
            break;
        case ((uint8)163):
            // Clean up "set_request"
            {
                delete set_request_;
                set_request_ = nullptr;
            }
            break;
        case ((uint8)164):
            // Clean up "trap"
            {
                delete trap_;
                trap_ = nullptr;
            }
            break;
        case ((uint8)165):
            // Clean up "get_bulk_request"
            {
                delete get_bulk_request_;
                get_bulk_request_ = nullptr;
            }
            break;
        case ((uint8)166):
            // Clean up "inform_request"
            {
                delete inform_request_;
                inform_request_ = nullptr;
            }
            break;
        case ((uint8)167):
            // Clean up "v2_trap"
            {
                delete v2_trap_;
                v2_trap_ = nullptr;
            }
            break;
        case ((uint8)168):
            // Clean up "report"
            {
                delete report_;
                report_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                delete unknown_;
                unknown_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int PDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    int t_val__size;
    val_case_index_ = choice();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)160):
            // Parse "get_request"
            {
                get_request_ = new GetRequestPDU(header());
                int t_get_request__size;
                t_get_request__size = get_request_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_get_request__size;
            }
            break;
        case ((uint8)161):
            // Parse "get_next_request"
            {
                get_next_request_ = new GetNextRequestPDU(header());
                int t_get_next_request__size;
                t_get_next_request__size = get_next_request_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_get_next_request__size;
            }
            break;
        case ((uint8)162):
            // Parse "response"
            {
                response_ = new ResponsePDU(header());
                int t_response__size;
                t_response__size = response_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_response__size;
            }
            break;
        case ((uint8)163):
            // Parse "set_request"
            {
                set_request_ = new SetRequestPDU(header());
                int t_set_request__size;
                t_set_request__size = set_request_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_set_request__size;
            }
            break;
        case ((uint8)164):
            // Parse "trap"
            {
                trap_ = new TrapPDU(header());
                int t_trap__size;
                t_trap__size = trap_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_trap__size;
            }
            break;
        case ((uint8)165):
            // Parse "get_bulk_request"
            {
                get_bulk_request_ = new GetBulkRequestPDU(header());
                int t_get_bulk_request__size;
                t_get_bulk_request__size = get_bulk_request_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_get_bulk_request__size;
            }
            break;
        case ((uint8)166):
            // Parse "inform_request"
            {
                inform_request_ = new InformRequestPDU(header());
                int t_inform_request__size;
                t_inform_request__size = inform_request_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_inform_request__size;
            }
            break;
        case ((uint8)167):
            // Parse "v2_trap"
            {
                v2_trap_ = new v2TrapPDU(header());
                int t_v2_trap__size;
                t_v2_trap__size = v2_trap_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_v2_trap__size;
            }
            break;
        case ((uint8)168):
            // Parse "report"
            {
                report_ = new ReportPDU(header());
                int t_report__size;
                t_report__size = report_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_report__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                unknown_ = new UnknownPDU(choice(), header());
                int t_unknown__size;
                t_unknown__size = unknown_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v1Header::v1Header(Header* header) {
    community_ = nullptr;
    header_ = header;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v1Header::~v1Header() {
    delete community_;
    community_ = nullptr;
}

int v1Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "community"
    community_ = new ASN1OctetString();
    int t_community__size;
    t_community__size = community_->Parse(t_begin_of_data, t_end_of_data, t_context);

    int t_v1Header__size;
    const_byteptr const t_dataptr_after_community = t_begin_of_data + (t_community__size);
    BINPAC_ASSERT(t_dataptr_after_community <= t_end_of_data);
    t_v1Header__size = t_dataptr_after_community - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_v1Header__size) <= t_end_of_data);
    return t_v1Header__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v2Header::v2Header(Header* header) {
    community_ = nullptr;
    header_ = header;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v2Header::~v2Header() {
    delete community_;
    community_ = nullptr;
}

int v2Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "community"
    community_ = new ASN1OctetString();
    int t_community__size;
    t_community__size = community_->Parse(t_begin_of_data, t_end_of_data, t_context);

    int t_v2Header__size;
    const_byteptr const t_dataptr_after_community = t_begin_of_data + (t_community__size);
    BINPAC_ASSERT(t_dataptr_after_community <= t_end_of_data);
    t_v2Header__size = t_dataptr_after_community - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_v2Header__size) <= t_end_of_data);
    return t_v2Header__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v3Header::v3Header(Header* header) {
    global_data_ = nullptr;
    security_parameters_ = nullptr;
    next_ = nullptr;
    scoped_pdu_data_case_index_ = -1;
    plaintext_pdu_ = nullptr;
    encrypted_pdu_ = nullptr;
    unknown_pdu_ = nullptr;
    header_ = header;
    usm_security_parameters_ = nullptr;
    has_usm_security_parameters_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v3Header::~v3Header() {
    delete global_data_;
    global_data_ = nullptr;
    delete security_parameters_;
    security_parameters_ = nullptr;
    delete next_;
    next_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( scoped_pdu_data_case_index() ) {
        case ((uint8)48):
            // Clean up "plaintext_pdu"
            {
                delete plaintext_pdu_;
                plaintext_pdu_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "encrypted_pdu"
            {
                delete encrypted_pdu_;
                encrypted_pdu_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown_pdu"
            {
                delete unknown_pdu_;
                unknown_pdu_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    delete usm_security_parameters_;
    usm_security_parameters_ = nullptr;
}

int v3Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "global_data"
    global_data_ = new v3HeaderData();
    int t_global_data__size;
    t_global_data__size = global_data_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_global_data = t_begin_of_data + (t_global_data__size);
    BINPAC_ASSERT(t_dataptr_after_global_data <= t_end_of_data);
    // Parse "security_parameters"
    security_parameters_ = new ASN1OctetString();
    int t_security_parameters__size;
    t_security_parameters__size = security_parameters_->Parse(t_dataptr_after_global_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_security_parameters = t_dataptr_after_global_data + (t_security_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_security_parameters <= t_end_of_data);
    // Parse "next"
    next_ = new ASN1EncodingMeta();
    int t_next__size;
    t_next__size = next_->Parse(t_dataptr_after_security_parameters, t_end_of_data);

    const_byteptr const t_dataptr_after_next = t_dataptr_after_security_parameters + (t_next__size);
    BINPAC_ASSERT(t_dataptr_after_next <= t_end_of_data);
    // Parse "scoped_pdu_data"
    int t_scoped_pdu_data__size;
    scoped_pdu_data_case_index_ = next()->tag();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( scoped_pdu_data_case_index() ) {
        case ((uint8)48):
            // Parse "plaintext_pdu"
            {
                plaintext_pdu_ = new v3ScopedPDU();
                int t_plaintext_pdu__size;
                t_plaintext_pdu__size = plaintext_pdu_->Parse(t_dataptr_after_next, t_end_of_data, t_context);
                t_scoped_pdu_data__size = t_plaintext_pdu__size;
            }
            break;
        case ((uint8)4):
            // Parse "encrypted_pdu"
            {
                encrypted_pdu_ = new EncryptedPDU(header());
                int t_encrypted_pdu__size;
                t_encrypted_pdu__size = encrypted_pdu_->Parse(t_dataptr_after_next, t_end_of_data, t_context);
                t_scoped_pdu_data__size = t_encrypted_pdu__size;
            }
            break;
        default:
            // Parse "unknown_pdu"
            {
                unknown_pdu_ = new UnknownScopedPDU(next()->tag(), header());
                int t_unknown_pdu__size;
                t_unknown_pdu__size = unknown_pdu_->Parse(t_dataptr_after_next, t_end_of_data, t_context);
                t_scoped_pdu_data__size = t_unknown_pdu__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_v3Header__size;
    const_byteptr const t_dataptr_after_scoped_pdu_data = t_dataptr_after_next + (t_scoped_pdu_data__size);
    BINPAC_ASSERT(t_dataptr_after_scoped_pdu_data <= t_end_of_data);
    t_v3Header__size = t_dataptr_after_scoped_pdu_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    // Parse "usm_security_parameters"
    has_usm_security_parameters_ =  ( binary_to_int64(global_data()->security_model()->encoding()->content()) == 3 ) ;
    if ( has_usm_security_parameters() ) {
        usm_security_parameters_ = new v3UsmSecurityParameters();
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(security_parameters()->encoding()->content(), &t_begin_of_data, &t_end_of_data);
        int t_usm_security_parameters__size;
        t_usm_security_parameters__size = usm_security_parameters_->Parse(t_begin_of_data, t_end_of_data, t_context);
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_v3Header__size) <= t_end_of_data);
    return t_v3Header__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v3UsmSecurityParameters::v3UsmSecurityParameters() {
    asn1_sequence_meta_ = nullptr;
    msgAuthoritativeEngineID_ = nullptr;
    msgAuthoritativeEngineBoots_ = nullptr;
    msgAuthoritativeEngineTime_ = nullptr;
    msgUserName_ = nullptr;
    msgAuthenticationParameters_ = nullptr;
    msgPrivacyParameters_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v3UsmSecurityParameters::~v3UsmSecurityParameters() {
    delete asn1_sequence_meta_;
    asn1_sequence_meta_ = nullptr;
    delete msgAuthoritativeEngineID_;
    msgAuthoritativeEngineID_ = nullptr;
    delete msgAuthoritativeEngineBoots_;
    msgAuthoritativeEngineBoots_ = nullptr;
    delete msgAuthoritativeEngineTime_;
    msgAuthoritativeEngineTime_ = nullptr;
    delete msgUserName_;
    msgUserName_ = nullptr;
    delete msgAuthenticationParameters_;
    msgAuthenticationParameters_ = nullptr;
    delete msgPrivacyParameters_;
    msgPrivacyParameters_ = nullptr;
}

int v3UsmSecurityParameters::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "asn1_sequence_meta"
    asn1_sequence_meta_ = new ASN1SequenceMeta();
    int t_asn1_sequence_meta__size;
    t_asn1_sequence_meta__size = asn1_sequence_meta_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_asn1_sequence_meta = t_begin_of_data + (t_asn1_sequence_meta__size);
    BINPAC_ASSERT(t_dataptr_after_asn1_sequence_meta <= t_end_of_data);
    // Parse "msgAuthoritativeEngineID"
    msgAuthoritativeEngineID_ = new ASN1OctetString();
    int t_msgAuthoritativeEngineID__size;
    t_msgAuthoritativeEngineID__size = msgAuthoritativeEngineID_->Parse(t_dataptr_after_asn1_sequence_meta, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_msgAuthoritativeEngineID = t_dataptr_after_asn1_sequence_meta + (t_msgAuthoritativeEngineID__size);
    BINPAC_ASSERT(t_dataptr_after_msgAuthoritativeEngineID <= t_end_of_data);
    // Parse "msgAuthoritativeEngineBoots"
    msgAuthoritativeEngineBoots_ = new ASN1Integer();
    int t_msgAuthoritativeEngineBoots__size;
    t_msgAuthoritativeEngineBoots__size = msgAuthoritativeEngineBoots_->Parse(t_dataptr_after_msgAuthoritativeEngineID, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_msgAuthoritativeEngineBoots = t_dataptr_after_msgAuthoritativeEngineID + (t_msgAuthoritativeEngineBoots__size);
    BINPAC_ASSERT(t_dataptr_after_msgAuthoritativeEngineBoots <= t_end_of_data);
    // Parse "msgAuthoritativeEngineTime"
    msgAuthoritativeEngineTime_ = new ASN1Integer();
    int t_msgAuthoritativeEngineTime__size;
    t_msgAuthoritativeEngineTime__size = msgAuthoritativeEngineTime_->Parse(t_dataptr_after_msgAuthoritativeEngineBoots, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_msgAuthoritativeEngineTime = t_dataptr_after_msgAuthoritativeEngineBoots + (t_msgAuthoritativeEngineTime__size);
    BINPAC_ASSERT(t_dataptr_after_msgAuthoritativeEngineTime <= t_end_of_data);
    // Parse "msgUserName"
    msgUserName_ = new ASN1OctetString();
    int t_msgUserName__size;
    t_msgUserName__size = msgUserName_->Parse(t_dataptr_after_msgAuthoritativeEngineTime, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_msgUserName = t_dataptr_after_msgAuthoritativeEngineTime + (t_msgUserName__size);
    BINPAC_ASSERT(t_dataptr_after_msgUserName <= t_end_of_data);
    // Parse "msgAuthenticationParameters"
    msgAuthenticationParameters_ = new ASN1OctetString();
    int t_msgAuthenticationParameters__size;
    t_msgAuthenticationParameters__size = msgAuthenticationParameters_->Parse(t_dataptr_after_msgUserName, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_msgAuthenticationParameters = t_dataptr_after_msgUserName + (t_msgAuthenticationParameters__size);
    BINPAC_ASSERT(t_dataptr_after_msgAuthenticationParameters <= t_end_of_data);
    // Parse "msgPrivacyParameters"
    msgPrivacyParameters_ = new ASN1OctetString();
    int t_msgPrivacyParameters__size;
    t_msgPrivacyParameters__size = msgPrivacyParameters_->Parse(t_dataptr_after_msgAuthenticationParameters, t_end_of_data, t_context);

    int t_v3UsmSecurityParameters__size;
    const_byteptr const t_dataptr_after_msgPrivacyParameters = t_dataptr_after_msgAuthenticationParameters + (t_msgPrivacyParameters__size);
    BINPAC_ASSERT(t_dataptr_after_msgPrivacyParameters <= t_end_of_data);
    t_v3UsmSecurityParameters__size = t_dataptr_after_msgPrivacyParameters - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_v3UsmSecurityParameters__size) <= t_end_of_data);
    return t_v3UsmSecurityParameters__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v3HeaderData::v3HeaderData() {
    asn1_sequence_meta_ = nullptr;
    id_ = nullptr;
    max_size_ = nullptr;
    flags_ = nullptr;
    security_model_ = nullptr;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v3HeaderData::~v3HeaderData() {
    delete asn1_sequence_meta_;
    asn1_sequence_meta_ = nullptr;
    delete id_;
    id_ = nullptr;
    delete max_size_;
    max_size_ = nullptr;
    delete flags_;
    flags_ = nullptr;
    delete security_model_;
    security_model_ = nullptr;
}

int v3HeaderData::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "asn1_sequence_meta"
    asn1_sequence_meta_ = new ASN1SequenceMeta();
    int t_asn1_sequence_meta__size;
    t_asn1_sequence_meta__size = asn1_sequence_meta_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_asn1_sequence_meta = t_begin_of_data + (t_asn1_sequence_meta__size);
    BINPAC_ASSERT(t_dataptr_after_asn1_sequence_meta <= t_end_of_data);
    // Parse "id"
    id_ = new ASN1Integer();
    int t_id__size;
    t_id__size = id_->Parse(t_dataptr_after_asn1_sequence_meta, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_id = t_dataptr_after_asn1_sequence_meta + (t_id__size);
    BINPAC_ASSERT(t_dataptr_after_id <= t_end_of_data);
    // Parse "max_size"
    max_size_ = new ASN1Integer();
    int t_max_size__size;
    t_max_size__size = max_size_->Parse(t_dataptr_after_id, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_max_size = t_dataptr_after_id + (t_max_size__size);
    BINPAC_ASSERT(t_dataptr_after_max_size <= t_end_of_data);
    // Parse "flags"
    flags_ = new ASN1OctetString();
    int t_flags__size;
    t_flags__size = flags_->Parse(t_dataptr_after_max_size, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_flags = t_dataptr_after_max_size + (t_flags__size);
    BINPAC_ASSERT(t_dataptr_after_flags <= t_end_of_data);
    // Parse "security_model"
    security_model_ = new ASN1Integer();
    int t_security_model__size;
    t_security_model__size = security_model_->Parse(t_dataptr_after_flags, t_end_of_data, t_context);

    int t_v3HeaderData__size;
    const_byteptr const t_dataptr_after_security_model = t_dataptr_after_flags + (t_security_model__size);
    BINPAC_ASSERT(t_dataptr_after_security_model <= t_end_of_data);
    t_v3HeaderData__size = t_dataptr_after_security_model - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_v3_header_data(this);
    BINPAC_ASSERT(t_begin_of_data + (t_v3HeaderData__size) <= t_end_of_data);
    return t_v3HeaderData__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v3ScopedPDU::v3ScopedPDU() {
    context_engine_id_ = nullptr;
    context_name_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v3ScopedPDU::~v3ScopedPDU() {
    delete context_engine_id_;
    context_engine_id_ = nullptr;
    delete context_name_;
    context_name_ = nullptr;
}

int v3ScopedPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "context_engine_id"
    context_engine_id_ = new ASN1OctetString();
    int t_context_engine_id__size;
    t_context_engine_id__size = context_engine_id_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_context_engine_id = t_begin_of_data + (t_context_engine_id__size);
    BINPAC_ASSERT(t_dataptr_after_context_engine_id <= t_end_of_data);
    // Parse "context_name"
    context_name_ = new ASN1OctetString();
    int t_context_name__size;
    t_context_name__size = context_name_->Parse(t_dataptr_after_context_engine_id, t_end_of_data, t_context);

    int t_v3ScopedPDU__size;
    const_byteptr const t_dataptr_after_context_name = t_dataptr_after_context_engine_id + (t_context_name__size);
    BINPAC_ASSERT(t_dataptr_after_context_name <= t_end_of_data);
    t_v3ScopedPDU__size = t_dataptr_after_context_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_v3ScopedPDU__size) <= t_end_of_data);
    return t_v3ScopedPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
EncryptedPDU::EncryptedPDU(Header* header) {
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
EncryptedPDU::~EncryptedPDU() {
}

int EncryptedPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:121", t_data_string_length);
    data_.init(t_begin_of_data, t_data_string_length);

    int t_EncryptedPDU__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_EncryptedPDU__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_encrypted_pdu(this);
    BINPAC_ASSERT(t_begin_of_data + (t_EncryptedPDU__size) <= t_end_of_data);
    return t_EncryptedPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UnknownScopedPDU::UnknownScopedPDU(uint8 tag, Header* header) {
    tag_ = tag;
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UnknownScopedPDU::~UnknownScopedPDU() {
}

int UnknownScopedPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:125", t_data_string_length);
    data_.init(t_begin_of_data, t_data_string_length);

    int t_UnknownScopedPDU__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_UnknownScopedPDU__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_unknown_scoped_pdu(this);
    BINPAC_ASSERT(t_begin_of_data + (t_UnknownScopedPDU__size) <= t_end_of_data);
    return t_UnknownScopedPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UnknownVersionHeader::UnknownVersionHeader(Header* header) {
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UnknownVersionHeader::~UnknownVersionHeader() {
}

int UnknownVersionHeader::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:129", t_data_string_length);
    data_.init(t_begin_of_data, t_data_string_length);

    int t_UnknownVersionHeader__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_UnknownVersionHeader__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_unknown_version_header(this);
    BINPAC_ASSERT(t_begin_of_data + (t_UnknownVersionHeader__size) <= t_end_of_data);
    return t_UnknownVersionHeader__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CommonPDU::CommonPDU(Header* header) {
    request_id_ = nullptr;
    error_status_ = nullptr;
    error_index_ = nullptr;
    var_bindings_ = nullptr;
    header_ = header;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CommonPDU::~CommonPDU() {
    delete request_id_;
    request_id_ = nullptr;
    delete error_status_;
    error_status_ = nullptr;
    delete error_index_;
    error_index_ = nullptr;
    delete var_bindings_;
    var_bindings_ = nullptr;
}

int CommonPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "request_id"
    request_id_ = new ASN1Integer();
    int t_request_id__size;
    t_request_id__size = request_id_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_request_id = t_begin_of_data + (t_request_id__size);
    BINPAC_ASSERT(t_dataptr_after_request_id <= t_end_of_data);
    // Parse "error_status"
    error_status_ = new ASN1Integer();
    int t_error_status__size;
    t_error_status__size = error_status_->Parse(t_dataptr_after_request_id, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_error_status = t_dataptr_after_request_id + (t_error_status__size);
    BINPAC_ASSERT(t_dataptr_after_error_status <= t_end_of_data);
    // Parse "error_index"
    error_index_ = new ASN1Integer();
    int t_error_index__size;
    t_error_index__size = error_index_->Parse(t_dataptr_after_error_status, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_error_index = t_dataptr_after_error_status + (t_error_index__size);
    BINPAC_ASSERT(t_dataptr_after_error_index <= t_end_of_data);
    // Parse "var_bindings"
    var_bindings_ = new VarBindList();
    int t_var_bindings__size;
    t_var_bindings__size = var_bindings_->Parse(t_dataptr_after_error_index, t_end_of_data, t_context);

    int t_CommonPDU__size;
    const_byteptr const t_dataptr_after_var_bindings = t_dataptr_after_error_index + (t_var_bindings__size);
    BINPAC_ASSERT(t_dataptr_after_var_bindings <= t_end_of_data);
    t_CommonPDU__size = t_dataptr_after_var_bindings - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_CommonPDU__size) <= t_end_of_data);
    return t_CommonPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GetRequestPDU::GetRequestPDU(Header* header) {
    pdu_ = nullptr;
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GetRequestPDU::~GetRequestPDU() {
    delete pdu_;
    pdu_ = nullptr;
}

int GetRequestPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "pdu"
    pdu_ = new CommonPDU(header());
    int t_pdu__size;
    t_pdu__size = pdu_->Parse(t_begin_of_data, t_end_of_data, t_context);

    int t_GetRequestPDU__size;
    const_byteptr const t_dataptr_after_pdu = t_begin_of_data + (t_pdu__size);
    BINPAC_ASSERT(t_dataptr_after_pdu <= t_end_of_data);
    t_GetRequestPDU__size = t_dataptr_after_pdu - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_get_request(this);
    BINPAC_ASSERT(t_begin_of_data + (t_GetRequestPDU__size) <= t_end_of_data);
    return t_GetRequestPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GetNextRequestPDU::GetNextRequestPDU(Header* header) {
    pdu_ = nullptr;
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GetNextRequestPDU::~GetNextRequestPDU() {
    delete pdu_;
    pdu_ = nullptr;
}

int GetNextRequestPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "pdu"
    pdu_ = new CommonPDU(header());
    int t_pdu__size;
    t_pdu__size = pdu_->Parse(t_begin_of_data, t_end_of_data, t_context);

    int t_GetNextRequestPDU__size;
    const_byteptr const t_dataptr_after_pdu = t_begin_of_data + (t_pdu__size);
    BINPAC_ASSERT(t_dataptr_after_pdu <= t_end_of_data);
    t_GetNextRequestPDU__size = t_dataptr_after_pdu - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_get_next_request(this);
    BINPAC_ASSERT(t_begin_of_data + (t_GetNextRequestPDU__size) <= t_end_of_data);
    return t_GetNextRequestPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ResponsePDU::ResponsePDU(Header* header) {
    pdu_ = nullptr;
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ResponsePDU::~ResponsePDU() {
    delete pdu_;
    pdu_ = nullptr;
}

int ResponsePDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "pdu"
    pdu_ = new CommonPDU(header());
    int t_pdu__size;
    t_pdu__size = pdu_->Parse(t_begin_of_data, t_end_of_data, t_context);

    int t_ResponsePDU__size;
    const_byteptr const t_dataptr_after_pdu = t_begin_of_data + (t_pdu__size);
    BINPAC_ASSERT(t_dataptr_after_pdu <= t_end_of_data);
    t_ResponsePDU__size = t_dataptr_after_pdu - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_response(this);
    BINPAC_ASSERT(t_begin_of_data + (t_ResponsePDU__size) <= t_end_of_data);
    return t_ResponsePDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SetRequestPDU::SetRequestPDU(Header* header) {
    pdu_ = nullptr;
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SetRequestPDU::~SetRequestPDU() {
    delete pdu_;
    pdu_ = nullptr;
}

int SetRequestPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "pdu"
    pdu_ = new CommonPDU(header());
    int t_pdu__size;
    t_pdu__size = pdu_->Parse(t_begin_of_data, t_end_of_data, t_context);

    int t_SetRequestPDU__size;
    const_byteptr const t_dataptr_after_pdu = t_begin_of_data + (t_pdu__size);
    BINPAC_ASSERT(t_dataptr_after_pdu <= t_end_of_data);
    t_SetRequestPDU__size = t_dataptr_after_pdu - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_set_request(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SetRequestPDU__size) <= t_end_of_data);
    return t_SetRequestPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TrapPDU::TrapPDU(Header* header) {
    enterprise_ = nullptr;
    agent_addr_ = nullptr;
    generic_trap_ = nullptr;
    specific_trap_ = nullptr;
    time_stamp_ = nullptr;
    var_bindings_ = nullptr;
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TrapPDU::~TrapPDU() {
    delete enterprise_;
    enterprise_ = nullptr;
    delete agent_addr_;
    agent_addr_ = nullptr;
    delete generic_trap_;
    generic_trap_ = nullptr;
    delete specific_trap_;
    specific_trap_ = nullptr;
    delete time_stamp_;
    time_stamp_ = nullptr;
    delete var_bindings_;
    var_bindings_ = nullptr;
}

int TrapPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "enterprise"
    enterprise_ = new ASN1ObjectIdentifier();
    int t_enterprise__size;
    t_enterprise__size = enterprise_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_enterprise = t_begin_of_data + (t_enterprise__size);
    BINPAC_ASSERT(t_dataptr_after_enterprise <= t_end_of_data);
    // Parse "agent_addr"
    agent_addr_ = new NetworkAddress();
    int t_agent_addr__size;
    t_agent_addr__size = agent_addr_->Parse(t_dataptr_after_enterprise, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_agent_addr = t_dataptr_after_enterprise + (t_agent_addr__size);
    BINPAC_ASSERT(t_dataptr_after_agent_addr <= t_end_of_data);
    // Parse "generic_trap"
    generic_trap_ = new ASN1Integer();
    int t_generic_trap__size;
    t_generic_trap__size = generic_trap_->Parse(t_dataptr_after_agent_addr, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_generic_trap = t_dataptr_after_agent_addr + (t_generic_trap__size);
    BINPAC_ASSERT(t_dataptr_after_generic_trap <= t_end_of_data);
    // Parse "specific_trap"
    specific_trap_ = new ASN1Integer();
    int t_specific_trap__size;
    t_specific_trap__size = specific_trap_->Parse(t_dataptr_after_generic_trap, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_specific_trap = t_dataptr_after_generic_trap + (t_specific_trap__size);
    BINPAC_ASSERT(t_dataptr_after_specific_trap <= t_end_of_data);
    // Parse "time_stamp"
    time_stamp_ = new TimeTicks();
    int t_time_stamp__size;
    t_time_stamp__size = time_stamp_->Parse(t_dataptr_after_specific_trap, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_time_stamp = t_dataptr_after_specific_trap + (t_time_stamp__size);
    BINPAC_ASSERT(t_dataptr_after_time_stamp <= t_end_of_data);
    // Parse "var_bindings"
    var_bindings_ = new VarBindList();
    int t_var_bindings__size;
    t_var_bindings__size = var_bindings_->Parse(t_dataptr_after_time_stamp, t_end_of_data, t_context);

    int t_TrapPDU__size;
    const_byteptr const t_dataptr_after_var_bindings = t_dataptr_after_time_stamp + (t_var_bindings__size);
    BINPAC_ASSERT(t_dataptr_after_var_bindings <= t_end_of_data);
    t_TrapPDU__size = t_dataptr_after_var_bindings - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trap(this);
    BINPAC_ASSERT(t_begin_of_data + (t_TrapPDU__size) <= t_end_of_data);
    return t_TrapPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GetBulkRequestPDU::GetBulkRequestPDU(Header* header) {
    request_id_ = nullptr;
    non_repeaters_ = nullptr;
    max_repetitions_ = nullptr;
    var_bindings_ = nullptr;
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GetBulkRequestPDU::~GetBulkRequestPDU() {
    delete request_id_;
    request_id_ = nullptr;
    delete non_repeaters_;
    non_repeaters_ = nullptr;
    delete max_repetitions_;
    max_repetitions_ = nullptr;
    delete var_bindings_;
    var_bindings_ = nullptr;
}

int GetBulkRequestPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "request_id"
    request_id_ = new ASN1Integer();
    int t_request_id__size;
    t_request_id__size = request_id_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_request_id = t_begin_of_data + (t_request_id__size);
    BINPAC_ASSERT(t_dataptr_after_request_id <= t_end_of_data);
    // Parse "non_repeaters"
    non_repeaters_ = new ASN1Integer();
    int t_non_repeaters__size;
    t_non_repeaters__size = non_repeaters_->Parse(t_dataptr_after_request_id, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_non_repeaters = t_dataptr_after_request_id + (t_non_repeaters__size);
    BINPAC_ASSERT(t_dataptr_after_non_repeaters <= t_end_of_data);
    // Parse "max_repetitions"
    max_repetitions_ = new ASN1Integer();
    int t_max_repetitions__size;
    t_max_repetitions__size = max_repetitions_->Parse(t_dataptr_after_non_repeaters, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_max_repetitions = t_dataptr_after_non_repeaters + (t_max_repetitions__size);
    BINPAC_ASSERT(t_dataptr_after_max_repetitions <= t_end_of_data);
    // Parse "var_bindings"
    var_bindings_ = new VarBindList();
    int t_var_bindings__size;
    t_var_bindings__size = var_bindings_->Parse(t_dataptr_after_max_repetitions, t_end_of_data, t_context);

    int t_GetBulkRequestPDU__size;
    const_byteptr const t_dataptr_after_var_bindings = t_dataptr_after_max_repetitions + (t_var_bindings__size);
    BINPAC_ASSERT(t_dataptr_after_var_bindings <= t_end_of_data);
    t_GetBulkRequestPDU__size = t_dataptr_after_var_bindings - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_get_bulk_request(this);
    BINPAC_ASSERT(t_begin_of_data + (t_GetBulkRequestPDU__size) <= t_end_of_data);
    return t_GetBulkRequestPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
InformRequestPDU::InformRequestPDU(Header* header) {
    pdu_ = nullptr;
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
InformRequestPDU::~InformRequestPDU() {
    delete pdu_;
    pdu_ = nullptr;
}

int InformRequestPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "pdu"
    pdu_ = new CommonPDU(header());
    int t_pdu__size;
    t_pdu__size = pdu_->Parse(t_begin_of_data, t_end_of_data, t_context);

    int t_InformRequestPDU__size;
    const_byteptr const t_dataptr_after_pdu = t_begin_of_data + (t_pdu__size);
    BINPAC_ASSERT(t_dataptr_after_pdu <= t_end_of_data);
    t_InformRequestPDU__size = t_dataptr_after_pdu - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_inform_request(this);
    BINPAC_ASSERT(t_begin_of_data + (t_InformRequestPDU__size) <= t_end_of_data);
    return t_InformRequestPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v2TrapPDU::v2TrapPDU(Header* header) {
    pdu_ = nullptr;
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
v2TrapPDU::~v2TrapPDU() {
    delete pdu_;
    pdu_ = nullptr;
}

int v2TrapPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "pdu"
    pdu_ = new CommonPDU(header());
    int t_pdu__size;
    t_pdu__size = pdu_->Parse(t_begin_of_data, t_end_of_data, t_context);

    int t_v2TrapPDU__size;
    const_byteptr const t_dataptr_after_pdu = t_begin_of_data + (t_pdu__size);
    BINPAC_ASSERT(t_dataptr_after_pdu <= t_end_of_data);
    t_v2TrapPDU__size = t_dataptr_after_pdu - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_v2_trap(this);
    BINPAC_ASSERT(t_begin_of_data + (t_v2TrapPDU__size) <= t_end_of_data);
    return t_v2TrapPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ReportPDU::ReportPDU(Header* header) {
    pdu_ = nullptr;
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ReportPDU::~ReportPDU() {
    delete pdu_;
    pdu_ = nullptr;
}

int ReportPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "pdu"
    pdu_ = new CommonPDU(header());
    int t_pdu__size;
    t_pdu__size = pdu_->Parse(t_begin_of_data, t_end_of_data, t_context);

    int t_ReportPDU__size;
    const_byteptr const t_dataptr_after_pdu = t_begin_of_data + (t_pdu__size);
    BINPAC_ASSERT(t_dataptr_after_pdu <= t_end_of_data);
    t_ReportPDU__size = t_dataptr_after_pdu - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_report(this);
    BINPAC_ASSERT(t_begin_of_data + (t_ReportPDU__size) <= t_end_of_data);
    return t_ReportPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UnknownPDU::UnknownPDU(uint8 tag, Header* header) {
    tag_ = tag;
    header_ = header;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UnknownPDU::~UnknownPDU() {
}

int UnknownPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:186", t_data_string_length);
    data_.init(t_begin_of_data, t_data_string_length);

    int t_UnknownPDU__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_UnknownPDU__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_unknown_pdu(this);
    BINPAC_ASSERT(t_begin_of_data + (t_UnknownPDU__size) <= t_end_of_data);
    return t_UnknownPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
VarBindList::VarBindList() {
    asn1_sequence_meta_ = nullptr;
    bindings_ = nullptr;
    bindings__elem_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
VarBindList::~VarBindList() {
    delete asn1_sequence_meta_;
    asn1_sequence_meta_ = nullptr;
    delete bindings__elem_;
    bindings__elem_ = nullptr;
    if ( bindings() ) {
        for ( auto* bindings__elem_ : *bindings() ) {
            delete bindings__elem_;
            bindings__elem_ = nullptr;
        }
    }
    delete bindings_;
}

int VarBindList::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "asn1_sequence_meta"
    asn1_sequence_meta_ = new ASN1SequenceMeta();
    int t_asn1_sequence_meta__size;
    t_asn1_sequence_meta__size = asn1_sequence_meta_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_asn1_sequence_meta = t_begin_of_data + (t_asn1_sequence_meta__size);
    BINPAC_ASSERT(t_dataptr_after_asn1_sequence_meta <= t_end_of_data);
    // Parse "bindings"
    int t_bindings__arraylength;
    t_bindings__arraylength = 0;
    bindings__elem_ = nullptr;
    int t_bindings__elem__it;
    t_bindings__elem__it = 0;
    int t_bindings__size;
    bindings_ = new vector<VarBind*>;
    const_byteptr t_bindings__elem__dataptr = t_dataptr_after_asn1_sequence_meta;
    for (; /* forever */; ++t_bindings__elem__it) {
        // Check &until(bindings__elem__dataptr >= end_of_data)
        if ( t_bindings__elem__dataptr >= t_end_of_data ) {
            bindings__elem_ = nullptr;
            goto end_of_bindings;
        }
        bindings__elem_ = new VarBind();
        int t_bindings__elem__size;
        t_bindings__elem__size = bindings__elem_->Parse(t_bindings__elem__dataptr, t_end_of_data, t_context);
        bindings_->push_back(bindings__elem_);
        t_bindings__elem__dataptr += t_bindings__elem__size;
        BINPAC_ASSERT(t_bindings__elem__dataptr <= t_end_of_data);
        bindings__elem_ = nullptr;
    }
end_of_bindings: ;
    t_bindings__size = t_bindings__elem__dataptr - (t_dataptr_after_asn1_sequence_meta);
    // Evaluate 'let' and 'withinput' fields

    int t_VarBindList__size;
    const_byteptr const t_dataptr_after_bindings = t_dataptr_after_asn1_sequence_meta + (t_bindings__size);
    BINPAC_ASSERT(t_dataptr_after_bindings <= t_end_of_data);
    t_VarBindList__size = t_dataptr_after_bindings - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_VarBindList__size) <= t_end_of_data);
    return t_VarBindList__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
VarBind::VarBind() {
    asn1_sequence_meta_ = nullptr;
    name_ = nullptr;
    value_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
VarBind::~VarBind() {
    delete asn1_sequence_meta_;
    asn1_sequence_meta_ = nullptr;
    delete name_;
    name_ = nullptr;
    delete value_;
    value_ = nullptr;
}

int VarBind::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "asn1_sequence_meta"
    asn1_sequence_meta_ = new ASN1SequenceMeta();
    int t_asn1_sequence_meta__size;
    t_asn1_sequence_meta__size = asn1_sequence_meta_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_asn1_sequence_meta = t_begin_of_data + (t_asn1_sequence_meta__size);
    BINPAC_ASSERT(t_dataptr_after_asn1_sequence_meta <= t_end_of_data);
    // Parse "name"
    name_ = new ObjectName();
    int t_name__size;
    t_name__size = name_->Parse(t_dataptr_after_asn1_sequence_meta, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_name = t_dataptr_after_asn1_sequence_meta + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    // Parse "value"
    value_ = new ObjectSyntax();
    int t_value__size;
    t_value__size = value_->Parse(t_dataptr_after_name, t_end_of_data);

    int t_VarBind__size;
    const_byteptr const t_dataptr_after_value = t_dataptr_after_name + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_VarBind__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_VarBind__size) <= t_end_of_data);
    return t_VarBind__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ObjectName::ObjectName() {
    oid_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ObjectName::~ObjectName() {
    delete oid_;
    oid_ = nullptr;
}

int ObjectName::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "oid"
    oid_ = new ASN1ObjectIdentifier();
    int t_oid__size;
    t_oid__size = oid_->Parse(t_begin_of_data, t_end_of_data, t_context);

    int t_ObjectName__size;
    const_byteptr const t_dataptr_after_oid = t_begin_of_data + (t_oid__size);
    BINPAC_ASSERT(t_dataptr_after_oid <= t_end_of_data);
    t_ObjectName__size = t_dataptr_after_oid - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ObjectName__size) <= t_end_of_data);
    return t_ObjectName__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ObjectSyntax::ObjectSyntax() {
    encoding_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ObjectSyntax::~ObjectSyntax() {
    delete encoding_;
    encoding_ = nullptr;
}

int ObjectSyntax::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ObjectSyntax__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ObjectSyntax__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ObjectSyntax__size) <= t_end_of_data);
    return t_ObjectSyntax__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NetworkAddress::NetworkAddress() {
    encoding_ = nullptr;
    valid_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NetworkAddress::~NetworkAddress() {
    delete encoding_;
    encoding_ = nullptr;
}

int NetworkAddress::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_NetworkAddress__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_NetworkAddress__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    valid_ = t_context->connection()->check_tag(encoding()->meta(), APP_IPADDRESS_TAG);
    BINPAC_ASSERT(t_begin_of_data + (t_NetworkAddress__size) <= t_end_of_data);
    return t_NetworkAddress__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TimeTicks::TimeTicks() {
    asn1_integer_ = nullptr;
    valid_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TimeTicks::~TimeTicks() {
    delete asn1_integer_;
    asn1_integer_ = nullptr;
}

int TimeTicks::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context) {
    // Parse "asn1_integer"
    asn1_integer_ = new ASN1Encoding();
    int t_asn1_integer__size;
    t_asn1_integer__size = asn1_integer_->Parse(t_begin_of_data, t_end_of_data);

    int t_TimeTicks__size;
    const_byteptr const t_dataptr_after_asn1_integer = t_begin_of_data + (t_asn1_integer__size);
    BINPAC_ASSERT(t_dataptr_after_asn1_integer <= t_end_of_data);
    t_TimeTicks__size = t_dataptr_after_asn1_integer - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    valid_ = t_context->connection()->check_tag(asn1_integer()->meta(), APP_TIMETICKS_TAG);
    BINPAC_ASSERT(t_begin_of_data + (t_TimeTicks__size) <= t_end_of_data);
    return t_TimeTicks__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SNMP_Flow::SNMP_Flow(SNMP_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SNMP_Flow::~SNMP_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void SNMP_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new TopLevelMessage(is_orig());
        context_ = new ContextSNMP(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e; // NOLINT(bugprone-exception-copy-constructor-throws)
    }
}

void SNMP_Flow::NewGap(int gap_length) {
}
void SNMP_Flow::FlowEOF() {
}


zeek::AddrValPtr network_address_to_val(const NetworkAddress* na)
	{
	return network_address_to_val(na->encoding());
	}

zeek::AddrValPtr network_address_to_val(const ASN1Encoding* na)
	{
	bytestring const& bs = na->content();

	// IPv6 can probably be presumed to be a octet string of length 16,
	// but standards don't seem to currently make any provisions for IPv6,
	// so ignore anything that can't be IPv4.
	if ( bs.length() != 4 )
		return zeek::make_intrusive<zeek::AddrVal>(zeek::IPAddr());

	const u_char* data = reinterpret_cast<const u_char*>(bs.data());
	uint32 network_order = zeek::extract_uint32(data);
	return zeek::make_intrusive<zeek::AddrVal>(ntohl(network_order));
	}

zeek::RecordValPtr asn1_obj_to_val(const ASN1Encoding* obj)
	{
	zeek::RecordValPtr rval = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SNMP::ObjectValue);
	uint8 tag = obj->meta()->tag();

	rval->Assign(0, tag);

	switch ( tag ) {
	case VARBIND_UNSPECIFIED_TAG:
	case VARBIND_NOSUCHOBJECT_TAG:
	case VARBIND_NOSUCHINSTANCE_TAG:
	case VARBIND_ENDOFMIBVIEW_TAG:
		break;

	case ASN1_OBJECT_IDENTIFIER_TAG:
		rval->Assign(1, asn1_oid_to_val(obj));
		break;

	case ASN1_INTEGER_TAG:
		rval->Assign(2, asn1_integer_to_val(obj, zeek::TYPE_INT));
		break;

	case APP_COUNTER32_TAG:
	case APP_UNSIGNED32_TAG:
	case APP_TIMETICKS_TAG:
	case APP_COUNTER64_TAG:
		rval->Assign(3, asn1_integer_to_val(obj, zeek::TYPE_COUNT));
		break;

	case APP_IPADDRESS_TAG:
		rval->Assign(4, network_address_to_val(obj));
		break;

	case ASN1_OCTET_STRING_TAG:
	case APP_OPAQUE_TAG:
	default:
		rval->Assign(5, asn1_octet_string_to_val(obj));
		break;
	}

	return rval;
	}

zeek::ValPtr time_ticks_to_val(const TimeTicks* tt)
	{
	return asn1_integer_to_val(tt->asn1_integer(), zeek::TYPE_COUNT);
	}

zeek::RecordValPtr build_hdr(const Header* header)
	{
	auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SNMP::Header);
	rv->Assign(0, static_cast<uint64_t>(header->version()));

	switch ( header->version() ) {
	case SNMPV1_TAG:
		{
		auto v1 = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SNMP::HeaderV1);
		v1->Assign(0, asn1_octet_string_to_val(header->v1()->community()));
		rv->Assign(1, std::move(v1));
		}
		break;

	case SNMPV2_TAG:
		{
		auto v2 = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SNMP::HeaderV2);
		v2->Assign(0, asn1_octet_string_to_val(header->v2()->community()));
		rv->Assign(2, std::move(v2));
		}
		break;

	case SNMPV3_TAG:
		{
		rv->Assign(3, build_hdrV3(header));
		}
		break;
	}

	return rv;
	}

zeek::RecordValPtr build_hdrV3(const Header* header)
	{
	auto v3 = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SNMP::HeaderV3);
	const v3Header* v3hdr = header->v3();
	const v3HeaderData* global_data = v3hdr->global_data();
	bytestring const& flags = global_data->flags()->encoding()->content();
	uint8 flags_byte = flags.length() > 0 ? flags[0] : 0;
	auto security_model = binary_to_int64(global_data->security_model()->encoding()->content());

	v3->Assign(0, asn1_integer_to_val(global_data->id(), zeek::TYPE_COUNT));
	v3->Assign(1, asn1_integer_to_val(global_data->max_size(), zeek::TYPE_COUNT));
	v3->Assign(2, flags_byte);
	v3->Assign(3, static_cast<bool>(flags_byte & 0x01));
	v3->Assign(4, static_cast<bool>(flags_byte & 0x02));
	v3->Assign(5, static_cast<bool>(flags_byte & 0x04));
	v3->Assign(6, asn1_integer_to_val(global_data->security_model(), zeek::TYPE_COUNT));
	v3->Assign(7, asn1_octet_string_to_val(v3hdr->security_parameters()));

	if ( v3hdr->next()->tag() == ASN1_SEQUENCE_TAG )
		{
		const v3ScopedPDU* spdu = v3hdr->plaintext_pdu();
		auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SNMP::ScopedPDU_Context);
		rv->Assign(0, asn1_octet_string_to_val(spdu->context_engine_id()));
		rv->Assign(1, asn1_octet_string_to_val(spdu->context_name()));
		v3->Assign(8, std::move(rv));
		}

	if ( security_model == 3 && v3hdr->has_usm_security_parameters() ) // user security model
		{
		auto usm = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SNMP::UserSecurityParameters);
		const v3UsmSecurityParameters* usp = v3hdr->usm_security_parameters();
		usm->Assign(0, asn1_octet_string_to_val(usp->msgAuthoritativeEngineID()));
		usm->Assign(1, asn1_integer_to_val(usp->msgAuthoritativeEngineBoots(), zeek::TYPE_INT));
		usm->Assign(2, asn1_integer_to_val(usp->msgAuthoritativeEngineTime(), zeek::TYPE_INT));
		usm->Assign(3, asn1_octet_string_to_val(usp->msgUserName()));
		usm->Assign(4, asn1_octet_string_to_val(usp->msgAuthenticationParameters()));
		usm->Assign(5, asn1_octet_string_to_val(usp->msgPrivacyParameters()));
		v3->Assign(9, std::move(usm));
		}

	return v3;
	}

zeek::VectorValPtr build_bindings(const VarBindList* vbl)
	{
	auto vv = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::SNMP::Bindings);

	for ( size_t i = 0; i < vbl->bindings()->size(); ++i )
		{
		VarBind* vb = (*vbl->bindings())[i];
		auto binding = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SNMP::Binding);
		binding->Assign(0, asn1_oid_to_val(vb->name()->oid()));
		binding->Assign(1, asn1_obj_to_val(vb->value()->encoding()));
		vv->Assign(i, std::move(binding));
		}

	return vv;
	}

zeek::RecordValPtr build_pdu(const CommonPDU* pdu)
	{
	auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SNMP::PDU);
	rv->Assign(0, asn1_integer_to_val(pdu->request_id(), zeek::TYPE_INT));
	rv->Assign(1, asn1_integer_to_val(pdu->error_status(), zeek::TYPE_INT));
	rv->Assign(2, asn1_integer_to_val(pdu->error_index(), zeek::TYPE_INT));
	rv->Assign(3, build_bindings(pdu->var_bindings()));
	return rv;
	}

zeek::RecordValPtr build_trap_pdu(const TrapPDU* pdu)
	{
	auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SNMP::TrapPDU);
	rv->Assign(0, asn1_oid_to_val(pdu->enterprise()));
	rv->Assign(1, network_address_to_val(pdu->agent_addr()));
	rv->Assign(2, asn1_integer_to_val(pdu->generic_trap(), zeek::TYPE_INT));
	rv->Assign(3, asn1_integer_to_val(pdu->specific_trap(), zeek::TYPE_INT));
	rv->Assign(4, time_ticks_to_val(pdu->time_stamp()));
	rv->Assign(5, build_bindings(pdu->var_bindings()));
	return rv;
	}

zeek::RecordValPtr build_bulk_pdu(const GetBulkRequestPDU* pdu)
	{
	auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SNMP::BulkPDU);
	rv->Assign(0, asn1_integer_to_val(pdu->request_id(), zeek::TYPE_INT));
	rv->Assign(1, asn1_integer_to_val(pdu->non_repeaters(), zeek::TYPE_COUNT));
	rv->Assign(2, asn1_integer_to_val(pdu->max_repetitions(), zeek::TYPE_COUNT));
	rv->Assign(3, build_bindings(pdu->var_bindings()));
	return rv;
	}

} // namespace SNMP
}  // namespace binpac
