// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_ssh_ssh_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_ssh_ssh_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


	#include "zeek/analyzer/protocol/ssh/types.bif.h"
	#include "zeek/analyzer/protocol/ssh/events.bif.h"


#include "zeek/ZeekString.h"


#include <cstdlib>
#include <vector>
#include <string>
#include "zeek/digest.h"

namespace binpac {

namespace SSH {
class ContextSSH;
class SSH_Conn;
// NOLINTNEXTLINE(performance-enum-size)
enum version {
    SSH1 = 1,
    SSH2 = 2,
    UNK = 3,
    SSH199 = 4,
};
// NOLINTNEXTLINE(performance-enum-size)
enum state {
    VERSION_EXCHANGE = 0,
    KEX_INIT = 1,
    KEX_DH_GEX = 2,
    KEX_DH = 3,
    KEX_ECC = 4,
    KEX_GSS = 5,
    KEX_RSA = 6,
    ENCRYPTED = 7,
};
// NOLINTNEXTLINE(performance-enum-size)
enum KEX_DH_message_id {
    SSH_MSG_KEXDH_INIT = 30,
    SSH_MSG_KEXDH_REPLY = 31,
};
// NOLINTNEXTLINE(performance-enum-size)
enum KEX_DH_GEX_message_id {
    SSH_MSG_KEX_DH_GEX_REQUEST_OLD = 30,
    SSH_MSG_KEX_DH_GEX_GROUP = 31,
    SSH_MSG_KEX_DH_GEX_INIT = 32,
    SSH_MSG_KEX_DH_GEX_REPLY = 33,
    SSH_MSG_KEX_DH_GEX_REQUEST = 34,
};
// NOLINTNEXTLINE(performance-enum-size)
enum KEX_RSA_message_id {
    SSH_MSG_KEXRSA_PUBKEY = 30,
    SSH_MSG_KEXRSA_SECRET = 31,
    SSH_MSG_KEXRSA_DONE = 32,
};
// NOLINTNEXTLINE(performance-enum-size)
enum KEX_GSS_message_id {
    SSH_MSG_KEXGSS_INIT = 30,
    SSH_MSG_KEXGSS_CONTINUE = 31,
    SSH_MSG_KEXGSS_COMPLETE = 32,
    SSH_MSG_KEXGSS_HOSTKEY = 33,
    SSH_MSG_KEXGSS_ERROR = 34,
    SSH_MSG_KEXGSS_GROUPREQ = 40,
    SSH_MSG_KEXGSS_GROUP = 41,
};
// NOLINTNEXTLINE(performance-enum-size)
enum KEX_ECDH_message_id {
    SSH_MSG_KEX_ECDH_INIT = 30,
    SSH_MSG_KEX_ECDH_REPLY = 31,
};
// NOLINTNEXTLINE(performance-enum-size)
enum KEX_ECMQV_message_id {
    SSH_MSG_ECMQV_INIT = 30,
    SSH_MSG_ECMQV_REPLY = 31,
};
// NOLINTNEXTLINE(performance-enum-size)
enum ssh1_message_id {
    SSH_MSG_NONE = 0,
    SSH_MSG_DISCONNECT = 1,
    SSH_SMSG_PUBLIC_KEY = 2,
    SSH_CMSG_SESSION_KEY = 3,
    SSH_CMSG_USER = 4,
    SSH_CMSG_AUTH_RHOSTS = 5,
    SSH_CMSG_AUTH_RSA = 6,
    SSH_SMSG_AUTH_RSA_CHALLENGE = 7,
    SSH_CMSG_AUTH_RSA_RESPONSE = 8,
    SSH_CMSG_AUTH_PASSWORD = 9,
    SSH_CMSG_REQUEST_PTY = 10,
    SSH_CMSG_WINDOW_SIZE = 11,
    SSH_CMSG_EXEC_SHELL = 12,
    SSH_CMSG_EXEC_CMD = 13,
    SSH_SMSG_SUCCESS = 14,
    SSH_SMSG_FAILURE = 15,
    SSH_CMSG_STDIN_DATA = 16,
    SSH_SMSG_STDOUT_DATA = 17,
    SSH_SMSG_STDERR_DATA = 18,
    SSH_CMSG_EOF = 19,
    SSH_SMSG_EXITSTATUS = 20,
    SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 21,
    SSH_MSG_CHANNEL_OPEN_FAILURE = 22,
    SSH_MSG_CHANNEL_DATA = 23,
    SSH_MSG_CHANNEL_CLOSE = 24,
    SSH_MSG_CHANNEL_CLOSE_CONFIRMATION = 25,
    SSH_CMSG_X11_REQUEST_FORWARDING_OLD = 26,
    SSH_SMSG_X11_OPEN = 27,
    SSH_CMSG_PORT_FORWARD_REQUEST = 28,
    SSH_MSG_PORT_OPEN = 29,
    SSH_CMSG_AGENT_REQUEST_FORWARDING = 30,
    SSH_SMSG_AGENT_OPEN = 31,
    SSH_MSG_IGNORE = 32,
    SSH_CMSG_EXIT_CONFIRMATION = 33,
    SSH_CMSG_X11_REQUEST_FORWARDING = 34,
    SSH_CMSG_AUTH_RHOSTS_RSA = 35,
    SSH_MSG_DEBUG = 36,
    SSH_CMSG_REQUEST_COMPRESSION = 37,
    SSH_CMSG_MAX_PACKET_SIZE = 38,
    SSH_CMSG_AUTH_TIS = 39,
    SSH_SMSG_AUTH_TIS_CHALLENGE = 40,
    SSH_CMSG_AUTH_TIS_RESPONSE = 41,
    SSH_CMSG_AUTH_KERBEROS = 42,
    SSH_SMSG_AUTH_KERBEROS_RESPONSE = 43,
    SSH_CMSG_HAVE_KERBEROS_TGT = 44,
};
// NOLINTNEXTLINE(performance-enum-size)
enum ssh2_message_id {
    MSG_DISCONNECT = 1,
    MSG_IGNORE = 2,
    MSG_UNIMPLEMENTED = 3,
    MSG_DEBUG = 4,
    MSG_SERVICE_REQUEST = 5,
    MSG_SERVICE_ACCEPT = 6,
    MSG_KEXINIT = 20,
    MSG_NEWKEYS = 21,
};
class EncryptedByte;
class SSH_PDU;
class SSH_Version_Switch;
extern RegExMatcher SSH_Version_Server_re_001;

extern RegExMatcher SSH_Version_Server_re_002;

class SSH_Version_Server;
extern RegExMatcher SSH_Version_Client_re_003;

class SSH_Version_Client;
class SSH_Key_Exchange;
class SSH1_Key_Exchange;
class SSH1_Message;
class SSH1_PUBLIC_KEY;
class SSH1_SESSION_KEY;
class ssh1_mp_int;
class SSH2_Header;
class SSH2_Key_Exchange;
class SSH2_Message;
class SSH2_KEXINIT;
class SSH2_Key_Exchange_DH_Message;
class SSH2_Key_Exchange_DH_GEX_Message;
class SSH2_DH_GEX_REQUEST;
class SSH2_DH_GEX_REQUEST_OLD;
class SSH2_DH_GEX_GROUP;
class SSH2_DH_GEX_INIT;
class SSH2_DH_GEX_REPLY;
class SSH2_Key_Exchange_RSA_Message;
class SSH2_RSA_PUBKEY;
class SSH2_RSA_SECRET;
class SSH2_RSA_DONE;
class SSH2_Key_Exchange_GSS_Message;
class SSH2_GSS_INIT;
class SSH2_GSS_CONTINUE;
class SSH2_GSS_COMPLETE;
class SSH2_GSS_HOSTKEY;
class SSH2_GSS_ERROR;
class SSH2_Key_Exchange_ECC_Message;
class SSH2_ECC_INIT;
class SSH2_ECC_REPLY;
class ssh_string;
class ssh_host_key;
class SSH_Flow;
} // namespace SSH

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace SSH {

class ContextSSH final {
public:
    ContextSSH(SSH_Conn* connection, SSH_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextSSH();

    // Member access functions
    SSH_Conn* connection() const { return connection_; }
    SSH_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    SSH_Conn* connection_;
    SSH_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class SSH_Conn final : public binpac::ConnectionAnalyzer {
public:
    SSH_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~SSH_Conn() override;

    // Member access functions
    SSH_Flow* upflow() const { return upflow_; }
    SSH_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    bool clear_encrypted_byte_count_in_current_segment();
    bool inc_encrypted_byte_count_in_current_segment();
    int get_encrypted_bytes_in_current_segment();
    int get_state(bool is_orig);
    bool update_state(state s, bool is_orig);
    int get_version();
    bool update_version(bytestring const& v, bool is_orig);
    bool update_kex_state_if_equal(string const& s, state to_state);
    bool update_kex_state_if_startswith(string const& s, state to_state);
    bool update_kex(bytestring const& algs, bool orig);

protected:

    // Additional members

		int state_up_;
		int state_down_;
		int version_;
		int version_client_;
		int version_server_;
		int encrypted_bytes_in_current_segment_;

		bool kex_orig_;
		bool kex_seen_;
		bytestring kex_algs_cache_;
		bytestring kex_algorithm_;
	
    SSH_Flow* upflow_;
    SSH_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class EncryptedByte final {
public:
    EncryptedByte(bool is_orig);
    ~EncryptedByte();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context);

    // Member access functions
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    const_bytestring encrypted_;
    int buffering_state_;
    bool is_orig_;
    bool proc_;
    int parsing_state_;
};


class SSH_PDU final {
public:
    SSH_PDU(bool is_orig);
    ~SSH_PDU();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    SSH_Version_Switch* version() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:23:version", (int64)val_case_index(), "VERSION_EXCHANGE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return version_;
    }
    EncryptedByte* encrypted() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:24:encrypted", (int64)val_case_index(), "ENCRYPTED");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return encrypted_;
    }
    SSH_Key_Exchange* kex() const {
        return kex_;
    }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    int val_case_index_;
    SSH_Version_Switch* version_;
    EncryptedByte* encrypted_;
    SSH_Key_Exchange* kex_;
    bool is_orig_;
    int byteorder_;
};


class SSH_Version_Switch final {
public:
    SSH_Version_Switch(bool is_orig);
    ~SSH_Version_Switch();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    SSH_Version_Client* client_version() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:29:client_version", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_version_;
    }
    SSH_Version_Server* server_version() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:30:server_version", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_version_;
    }
    bool is_orig() const { return is_orig_; }

protected:
    int val_case_index_;
    SSH_Version_Client* client_version_;
    SSH_Version_Server* server_version_;
    int buffering_state_;
    bool is_orig_;
};


class SSH_Version_Server final {
public:
    SSH_Version_Server();
    ~SSH_Version_Server();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context);

    // Member access functions
    bytestring const& version() const { return version_; }
    bytestring const& nonversiondata() const { return nonversiondata_; }
    bool update_state() const { BINPAC_ASSERT(has_update_state()); return update_state_; }
    bool has_update_state() const { return has_update_state_; }
    bool update_version() const { BINPAC_ASSERT(has_update_version()); return update_version_; }
    bool has_update_version() const { return has_update_version_; }
    bool proc() const { return proc_; }

protected:
    bytestring version_;
    bytestring nonversiondata_;
    bool update_state_;
    bool has_update_state_;
    bool update_version_;
    bool has_update_version_;
    bool proc_;
    int buffering_state_;
};


class SSH_Version_Client final {
public:
    SSH_Version_Client();
    ~SSH_Version_Client();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context);

    // Member access functions
    bytestring const& version() const { return version_; }
    bool update_state() const { return update_state_; }
    bool update_version() const { return update_version_; }
    bool proc() const { return proc_; }

protected:
    bytestring version_;
    int buffering_state_;
    bool update_state_;
    bool update_version_;
    bool proc_;
    int parsing_state_;
};


class SSH_Key_Exchange final {
public:
    SSH_Key_Exchange(bool is_orig);
    ~SSH_Key_Exchange();
    int initial_buffer_length() const { return 4; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    uint32 packet_length() const { return packet_length_; }
    int key_ex_case_index() const	{ return key_ex_case_index_; }
    SSH1_Key_Exchange* ssh1_msg() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( key_ex_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:54:ssh1_msg", (int64)key_ex_case_index(), "SSH1");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ssh1_msg_;
    }
    SSH2_Key_Exchange* ssh2_msg() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( key_ex_case_index() ) {
            case ((int)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:55:ssh2_msg", (int64)key_ex_case_index(), "SSH2");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ssh2_msg_;
    }
    bool is_orig() const { return is_orig_; }

protected:
    uint32 packet_length_;
    int key_ex_case_index_;
    SSH1_Key_Exchange* ssh1_msg_;
    SSH2_Key_Exchange* ssh2_msg_;
    bool is_orig_;
    int buffering_state_;
};


class SSH1_Key_Exchange final {
public:
    SSH1_Key_Exchange(bool is_orig, uint32 packet_length);
    ~SSH1_Key_Exchange();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    bytestring const& pad_fill() const { return pad_fill_; }
    uint8 msg_type() const { return msg_type_; }
    SSH1_Message* message() const { return message_; }
    uint32 crc() const { return crc_; }
    bool is_orig() const { return is_orig_; }
    uint32 packet_length() const { return packet_length_; }

protected:
    bytestring pad_fill_;
    uint8 msg_type_;
    SSH1_Message* message_;
    uint32 crc_;
    bool is_orig_;
    uint32 packet_length_;
};


class SSH1_Message final {
public:
    SSH1_Message(bool is_orig, uint8 msg_type, uint32 length);
    ~SSH1_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SSH1_PUBLIC_KEY* public_key() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:70:public_key", (int64)val_case_index(), "SSH_SMSG_PUBLIC_KEY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return public_key_;
    }
    SSH1_SESSION_KEY* session_key() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:71:session_key", (int64)val_case_index(), "SSH_CMSG_SESSION_KEY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return session_key_;
    }
    bool is_orig() const { return is_orig_; }
    uint8 msg_type() const { return msg_type_; }
    uint32 length() const { return length_; }
    bool detach() const { return detach_; }
    bool proc_newkeys() const { BINPAC_ASSERT(has_proc_newkeys()); return proc_newkeys_; }
    bool has_proc_newkeys() const { return has_proc_newkeys_; }

protected:
    uint8 val_case_index_;
    SSH1_PUBLIC_KEY* public_key_;
    SSH1_SESSION_KEY* session_key_;
    bool is_orig_;
    uint8 msg_type_;
    uint32 length_;
    bool detach_;
    bool proc_newkeys_;
    bool has_proc_newkeys_;
};


class SSH1_PUBLIC_KEY final {
public:
    SSH1_PUBLIC_KEY(uint32 length);
    ~SSH1_PUBLIC_KEY();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    bytestring const& cookie() const { return cookie_; }
    uint32 server_key() const { return server_key_; }
    ssh1_mp_int* server_key_exp() const { return server_key_exp_; }
    ssh1_mp_int* server_key_mod() const { return server_key_mod_; }
    uint32 host_key() const { return host_key_; }
    ssh1_mp_int* host_key_exp() const { return host_key_exp_; }
    ssh1_mp_int* host_key_mod() const { return host_key_mod_; }
    uint32 flags() const { return flags_; }
    uint32 supported_ciphers() const { return supported_ciphers_; }
    uint32 supported_auths() const { return supported_auths_; }
    uint32 length() const { return length_; }
    bool proc() const { return proc_; }

protected:
    bytestring cookie_;
    uint32 server_key_;
    ssh1_mp_int* server_key_exp_;
    ssh1_mp_int* server_key_mod_;
    uint32 host_key_;
    ssh1_mp_int* host_key_exp_;
    ssh1_mp_int* host_key_mod_;
    uint32 flags_;
    uint32 supported_ciphers_;
    uint32 supported_auths_;
    uint32 length_;
    bool proc_;
};


class SSH1_SESSION_KEY final {
public:
    SSH1_SESSION_KEY(uint32 length);
    ~SSH1_SESSION_KEY();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 cipher() const { return cipher_; }
    bytestring const& cookie() const { return cookie_; }
    ssh1_mp_int* session_key() const { return session_key_; }
    uint32 flags() const { return flags_; }
    uint32 length() const { return length_; }

protected:
    uint8 cipher_;
    bytestring cookie_;
    ssh1_mp_int* session_key_;
    uint32 flags_;
    uint32 length_;
};


class ssh1_mp_int final {
public:
    ssh1_mp_int();
    ~ssh1_mp_int();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 len() const { return len_; }
    bytestring const& val() const { return val_; }

protected:
    uint16 len_;
    bytestring val_;
};


class SSH2_Header final {
public:
    SSH2_Header(bool is_orig, uint32 packet_length);
    ~SSH2_Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context);

    // Member access functions
    uint8 padding_length() const { return padding_length_; }
    uint8 msg_type() const { return msg_type_; }
    bool is_orig() const { return is_orig_; }
    uint32 packet_length() const { return packet_length_; }
    uint32 payload_length() const { return payload_length_; }
    bool detach() const { BINPAC_ASSERT(has_detach()); return detach_; }
    bool has_detach() const { return has_detach_; }

protected:
    uint8 padding_length_;
    uint8 msg_type_;
    bool is_orig_;
    uint32 packet_length_;
    uint32 payload_length_;
    bool detach_;
    bool has_detach_;
};


class SSH2_Key_Exchange final {
public:
    SSH2_Key_Exchange(bool is_orig, uint32 packet_length);
    ~SSH2_Key_Exchange();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    SSH2_Header* header() const { return header_; }
    SSH2_Message* payload() const { return payload_; }
    bytestring const& pad() const { return pad_; }
    bool is_orig() const { return is_orig_; }
    uint32 packet_length() const { return packet_length_; }

protected:
    SSH2_Header* header_;
    SSH2_Message* payload_;
    bytestring pad_;
    bool is_orig_;
    uint32 packet_length_;
};


class SSH2_Message final {
public:
    SSH2_Message(bool is_orig, uint8 msg_type, uint32 length);
    ~SSH2_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    SSH2_KEXINIT* kex() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:119:kex", (int64)val_case_index(), "KEX_INIT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return kex_;
    }
    SSH2_Key_Exchange_DH_GEX_Message* kex_dh_gex() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:120:kex_dh_gex", (int64)val_case_index(), "KEX_DH_GEX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return kex_dh_gex_;
    }
    SSH2_Key_Exchange_DH_Message* kex_dh() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:121:kex_dh", (int64)val_case_index(), "KEX_DH");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return kex_dh_;
    }
    SSH2_Key_Exchange_ECC_Message* kex_ecc() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:122:kex_ecc", (int64)val_case_index(), "KEX_ECC");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return kex_ecc_;
    }
    SSH2_Key_Exchange_GSS_Message* kex_gss() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:123:kex_gss", (int64)val_case_index(), "KEX_GSS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return kex_gss_;
    }
    SSH2_Key_Exchange_RSA_Message* kex_rsa() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:124:kex_rsa", (int64)val_case_index(), "KEX_RSA");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return kex_rsa_;
    }
    bytestring const& unknown() const {
        return unknown_;
    }
    bool is_orig() const { return is_orig_; }
    uint8 msg_type() const { return msg_type_; }
    uint32 length() const { return length_; }
    bool proc_newkeys() const { BINPAC_ASSERT(has_proc_newkeys()); return proc_newkeys_; }
    bool has_proc_newkeys() const { return has_proc_newkeys_; }

protected:
    int val_case_index_;
    SSH2_KEXINIT* kex_;
    SSH2_Key_Exchange_DH_GEX_Message* kex_dh_gex_;
    SSH2_Key_Exchange_DH_Message* kex_dh_;
    SSH2_Key_Exchange_ECC_Message* kex_ecc_;
    SSH2_Key_Exchange_GSS_Message* kex_gss_;
    SSH2_Key_Exchange_RSA_Message* kex_rsa_;
    bytestring unknown_;
    bool is_orig_;
    uint8 msg_type_;
    uint32 length_;
    bool proc_newkeys_;
    bool has_proc_newkeys_;
};


class SSH2_KEXINIT final {
public:
    SSH2_KEXINIT(uint32 length, bool is_orig);
    ~SSH2_KEXINIT();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    bytestring const& cookie() const { return cookie_; }
    ssh_string* kex_algorithms() const { return kex_algorithms_; }
    ssh_string* server_host_key_algorithms() const { return server_host_key_algorithms_; }
    ssh_string* encryption_algorithms_client_to_server() const { return encryption_algorithms_client_to_server_; }
    ssh_string* encryption_algorithms_server_to_client() const { return encryption_algorithms_server_to_client_; }
    ssh_string* mac_algorithms_client_to_server() const { return mac_algorithms_client_to_server_; }
    ssh_string* mac_algorithms_server_to_client() const { return mac_algorithms_server_to_client_; }
    ssh_string* compression_algorithms_client_to_server() const { return compression_algorithms_client_to_server_; }
    ssh_string* compression_algorithms_server_to_client() const { return compression_algorithms_server_to_client_; }
    ssh_string* languages_client_to_server() const { return languages_client_to_server_; }
    ssh_string* languages_server_to_client() const { return languages_server_to_client_; }
    uint8 first_kex_packet_follows() const { return first_kex_packet_follows_; }
    uint32 reserved() const { return reserved_; }
    uint32 length() const { return length_; }
    bool is_orig() const { return is_orig_; }
    bool proc_kex() const { return proc_kex_; }
    bool proc() const { return proc_; }

protected:
    bytestring cookie_;
    ssh_string* kex_algorithms_;
    ssh_string* server_host_key_algorithms_;
    ssh_string* encryption_algorithms_client_to_server_;
    ssh_string* encryption_algorithms_server_to_client_;
    ssh_string* mac_algorithms_client_to_server_;
    ssh_string* mac_algorithms_server_to_client_;
    ssh_string* compression_algorithms_client_to_server_;
    ssh_string* compression_algorithms_server_to_client_;
    ssh_string* languages_client_to_server_;
    ssh_string* languages_server_to_client_;
    uint8 first_kex_packet_follows_;
    uint32 reserved_;
    uint32 length_;
    bool is_orig_;
    bool proc_kex_;
    bool proc_;
};


class SSH2_Key_Exchange_DH_Message final {
public:
    SSH2_Key_Exchange_DH_Message(bool is_orig, uint8 msg_type, uint32 length);
    ~SSH2_Key_Exchange_DH_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SSH2_DH_GEX_INIT* init() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)30):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:149:init", (int64)val_case_index(), "SSH_MSG_KEXDH_INIT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return init_;
    }
    SSH2_DH_GEX_REPLY* reply() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)31):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:150:reply", (int64)val_case_index(), "SSH_MSG_KEXDH_REPLY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return reply_;
    }
    bool is_orig() const { return is_orig_; }
    uint8 msg_type() const { return msg_type_; }
    uint32 length() const { return length_; }

protected:
    uint8 val_case_index_;
    SSH2_DH_GEX_INIT* init_;
    SSH2_DH_GEX_REPLY* reply_;
    const_bytestring unknown_;
    bool is_orig_;
    uint8 msg_type_;
    uint32 length_;
};


class SSH2_Key_Exchange_DH_GEX_Message final {
public:
    SSH2_Key_Exchange_DH_GEX_Message(bool is_orig, uint8 msg_type, uint32 length);
    ~SSH2_Key_Exchange_DH_GEX_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SSH2_DH_GEX_REQUEST_OLD* request_old() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)30):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:157:request_old", (int64)val_case_index(), "SSH_MSG_KEX_DH_GEX_REQUEST_OLD");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return request_old_;
    }
    SSH2_DH_GEX_REQUEST* request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)34):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:158:request", (int64)val_case_index(), "SSH_MSG_KEX_DH_GEX_REQUEST");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return request_;
    }
    SSH2_DH_GEX_GROUP* group() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)31):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:159:group", (int64)val_case_index(), "SSH_MSG_KEX_DH_GEX_GROUP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return group_;
    }
    SSH2_DH_GEX_INIT* init() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)32):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:160:init", (int64)val_case_index(), "SSH_MSG_KEX_DH_GEX_INIT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return init_;
    }
    SSH2_DH_GEX_REPLY* reply() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)33):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:161:reply", (int64)val_case_index(), "SSH_MSG_KEX_DH_GEX_REPLY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return reply_;
    }
    bool is_orig() const { return is_orig_; }
    uint8 msg_type() const { return msg_type_; }
    uint32 length() const { return length_; }

protected:
    uint8 val_case_index_;
    SSH2_DH_GEX_REQUEST_OLD* request_old_;
    SSH2_DH_GEX_REQUEST* request_;
    SSH2_DH_GEX_GROUP* group_;
    SSH2_DH_GEX_INIT* init_;
    SSH2_DH_GEX_REPLY* reply_;
    const_bytestring unknown_;
    bool is_orig_;
    uint8 msg_type_;
    uint32 length_;
};


class SSH2_DH_GEX_REQUEST final {
public:
    SSH2_DH_GEX_REQUEST();
    ~SSH2_DH_GEX_REQUEST();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 min() const { return min_; }
    uint32 n() const { return n_; }
    uint32 max() const { return max_; }

protected:
    uint32 min_;
    uint32 n_;
    uint32 max_;
};


class SSH2_DH_GEX_REQUEST_OLD final {
public:
    SSH2_DH_GEX_REQUEST_OLD();
    ~SSH2_DH_GEX_REQUEST_OLD();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 n() const { return n_; }

protected:
    uint32 n_;
};


class SSH2_DH_GEX_GROUP final {
public:
    SSH2_DH_GEX_GROUP(uint32 length);
    ~SSH2_DH_GEX_GROUP();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    ssh_string* p() const { return p_; }
    ssh_string* g() const { return g_; }
    uint32 length() const { return length_; }
    bool proc() const { return proc_; }

protected:
    ssh_string* p_;
    ssh_string* g_;
    uint32 length_;
    bool proc_;
};


class SSH2_DH_GEX_INIT final {
public:
    SSH2_DH_GEX_INIT(uint32 length, bool is_orig);
    ~SSH2_DH_GEX_INIT();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    ssh_string* e() const { return e_; }
    uint32 length() const { return length_; }
    bool is_orig() const { return is_orig_; }
    bool proc_init() const { return proc_init_; }

protected:
    ssh_string* e_;
    uint32 length_;
    bool is_orig_;
    bool proc_init_;
};


class SSH2_DH_GEX_REPLY final {
public:
    SSH2_DH_GEX_REPLY(uint32 length);
    ~SSH2_DH_GEX_REPLY();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    ssh_string* k_s() const { return k_s_; }
    ssh_string* f() const { return f_; }
    ssh_string* signature() const { return signature_; }
    uint32 length() const { return length_; }
    bool proc() const { return proc_; }

protected:
    ssh_string* k_s_;
    ssh_string* f_;
    ssh_string* signature_;
    uint32 length_;
    bool proc_;
};


class SSH2_Key_Exchange_RSA_Message final {
public:
    SSH2_Key_Exchange_RSA_Message(bool is_orig, uint8 msg_type, uint32 length);
    ~SSH2_Key_Exchange_RSA_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SSH2_RSA_PUBKEY* pubkey() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)30):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:193:pubkey", (int64)val_case_index(), "SSH_MSG_KEXRSA_PUBKEY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pubkey_;
    }
    SSH2_RSA_SECRET* secret() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)31):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:194:secret", (int64)val_case_index(), "SSH_MSG_KEXRSA_SECRET");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return secret_;
    }
    SSH2_RSA_DONE* done() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)32):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:195:done", (int64)val_case_index(), "SSH_MSG_KEXRSA_DONE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return done_;
    }
    bool is_orig() const { return is_orig_; }
    uint8 msg_type() const { return msg_type_; }
    uint32 length() const { return length_; }

protected:
    uint8 val_case_index_;
    SSH2_RSA_PUBKEY* pubkey_;
    SSH2_RSA_SECRET* secret_;
    SSH2_RSA_DONE* done_;
    bool is_orig_;
    uint8 msg_type_;
    uint32 length_;
};


class SSH2_RSA_PUBKEY final {
public:
    SSH2_RSA_PUBKEY(uint32 length);
    ~SSH2_RSA_PUBKEY();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    ssh_string* k_s() const { return k_s_; }
    ssh_string* k_t() const { return k_t_; }
    uint32 length() const { return length_; }

protected:
    ssh_string* k_s_;
    ssh_string* k_t_;
    uint32 length_;
};


class SSH2_RSA_SECRET final {
public:
    SSH2_RSA_SECRET(uint32 length, bool is_orig);
    ~SSH2_RSA_SECRET();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    ssh_string* encrypted_payload() const { return encrypted_payload_; }
    uint32 length() const { return length_; }
    bool is_orig() const { return is_orig_; }
    bool proc_init() const { return proc_init_; }

protected:
    ssh_string* encrypted_payload_;
    uint32 length_;
    bool is_orig_;
    bool proc_init_;
};


class SSH2_RSA_DONE final {
public:
    SSH2_RSA_DONE(uint32 length);
    ~SSH2_RSA_DONE();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    ssh_string* signature() const { return signature_; }
    uint32 length() const { return length_; }

protected:
    ssh_string* signature_;
    uint32 length_;
};


class SSH2_Key_Exchange_GSS_Message final {
public:
    SSH2_Key_Exchange_GSS_Message(bool is_orig, uint8 msg_type, uint32 length);
    ~SSH2_Key_Exchange_GSS_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SSH2_GSS_INIT* init() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)30):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:214:init", (int64)val_case_index(), "SSH_MSG_KEXGSS_INIT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return init_;
    }
    SSH2_GSS_CONTINUE* cont() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)31):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:215:cont", (int64)val_case_index(), "SSH_MSG_KEXGSS_CONTINUE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return cont_;
    }
    SSH2_GSS_COMPLETE* complete() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)32):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:216:complete", (int64)val_case_index(), "SSH_MSG_KEXGSS_COMPLETE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return complete_;
    }
    SSH2_GSS_HOSTKEY* hostkey() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)33):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:217:hostkey", (int64)val_case_index(), "SSH_MSG_KEXGSS_HOSTKEY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return hostkey_;
    }
    SSH2_GSS_ERROR* error() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)34):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:218:error", (int64)val_case_index(), "SSH_MSG_KEXGSS_ERROR");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return error_;
    }
    SSH2_DH_GEX_REQUEST* groupreq() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)40):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:219:groupreq", (int64)val_case_index(), "SSH_MSG_KEXGSS_GROUPREQ");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return groupreq_;
    }
    SSH2_DH_GEX_GROUP* group() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)41):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:220:group", (int64)val_case_index(), "SSH_MSG_KEXGSS_GROUP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return group_;
    }
    bool is_orig() const { return is_orig_; }
    uint8 msg_type() const { return msg_type_; }
    uint32 length() const { return length_; }

protected:
    uint8 val_case_index_;
    SSH2_GSS_INIT* init_;
    SSH2_GSS_CONTINUE* cont_;
    SSH2_GSS_COMPLETE* complete_;
    SSH2_GSS_HOSTKEY* hostkey_;
    SSH2_GSS_ERROR* error_;
    SSH2_DH_GEX_REQUEST* groupreq_;
    SSH2_DH_GEX_GROUP* group_;
    bool is_orig_;
    uint8 msg_type_;
    uint32 length_;
};


class SSH2_GSS_INIT final {
public:
    SSH2_GSS_INIT(uint32 length, bool is_orig);
    ~SSH2_GSS_INIT();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    ssh_string* output_token() const { return output_token_; }
    ssh_string* e() const { return e_; }
    uint32 length() const { return length_; }
    bool is_orig() const { return is_orig_; }
    bool proc_init() const { return proc_init_; }

protected:
    ssh_string* output_token_;
    ssh_string* e_;
    uint32 length_;
    bool is_orig_;
    bool proc_init_;
};


class SSH2_GSS_CONTINUE final {
public:
    SSH2_GSS_CONTINUE(uint32 length);
    ~SSH2_GSS_CONTINUE();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    ssh_string* output_token() const { return output_token_; }
    uint32 length() const { return length_; }

protected:
    ssh_string* output_token_;
    uint32 length_;
};


class SSH2_GSS_COMPLETE final {
public:
    SSH2_GSS_COMPLETE(uint32 length);
    ~SSH2_GSS_COMPLETE();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    ssh_string* f() const { return f_; }
    ssh_string* per_msg_token() const { return per_msg_token_; }
    uint8 have_token() const { return have_token_; }
    uint8 parse_token_case_index() const	{ return parse_token_case_index_; }
    ssh_string* token() const {
        return token_;
    }
    uint32 length() const { return length_; }

protected:
    ssh_string* f_;
    ssh_string* per_msg_token_;
    uint8 have_token_;
    uint8 parse_token_case_index_;
    ssh_string* token_;
    uint32 length_;
};


class SSH2_GSS_HOSTKEY final {
public:
    SSH2_GSS_HOSTKEY(uint32 length);
    ~SSH2_GSS_HOSTKEY();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    ssh_string* k_s() const { return k_s_; }
    uint32 length() const { return length_; }
    bool proc() const { return proc_; }

protected:
    ssh_string* k_s_;
    uint32 length_;
    bool proc_;
};


class SSH2_GSS_ERROR final {
public:
    SSH2_GSS_ERROR(uint32 length);
    ~SSH2_GSS_ERROR();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    uint32 major_status() const { return major_status_; }
    uint32 minor_status() const { return minor_status_; }
    ssh_string* message() const { return message_; }
    ssh_string* language() const { return language_; }
    uint32 length() const { return length_; }
    bool proc() const { return proc_; }

protected:
    uint32 major_status_;
    uint32 minor_status_;
    ssh_string* message_;
    ssh_string* language_;
    uint32 length_;
    bool proc_;
};


class SSH2_Key_Exchange_ECC_Message final {
public:
    SSH2_Key_Exchange_ECC_Message(bool is_orig, uint8 msg_type, uint32 length);
    ~SSH2_Key_Exchange_ECC_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    SSH2_ECC_INIT* init() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)30):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:256:init", (int64)val_case_index(), "SSH_MSG_KEX_ECDH_INIT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return init_;
    }
    SSH2_ECC_REPLY* reply() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)31):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:257:reply", (int64)val_case_index(), "SSH_MSG_KEX_ECDH_REPLY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return reply_;
    }
    bool is_orig() const { return is_orig_; }
    uint8 msg_type() const { return msg_type_; }
    uint32 length() const { return length_; }

protected:
    uint8 val_case_index_;
    SSH2_ECC_INIT* init_;
    SSH2_ECC_REPLY* reply_;
    bool is_orig_;
    uint8 msg_type_;
    uint32 length_;
};


class SSH2_ECC_INIT final {
public:
    SSH2_ECC_INIT(uint32 length, bool is_orig);
    ~SSH2_ECC_INIT();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    ssh_string* q_c() const { return q_c_; }
    uint32 length() const { return length_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }
    bool proc_init() const { return proc_init_; }

protected:
    ssh_string* q_c_;
    uint32 length_;
    bool is_orig_;
    bool proc_;
    bool proc_init_;
};


class SSH2_ECC_REPLY final {
public:
    SSH2_ECC_REPLY(uint32 length, bool is_orig);
    ~SSH2_ECC_REPLY();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder);

    // Member access functions
    ssh_string* k_s() const { return k_s_; }
    ssh_string* q_s() const { return q_s_; }
    ssh_string* signature() const { return signature_; }
    uint32 length() const { return length_; }
    bool is_orig() const { return is_orig_; }
    bool proc_k() const { return proc_k_; }
    bool proc_q() const { return proc_q_; }

protected:
    ssh_string* k_s_;
    ssh_string* q_s_;
    ssh_string* signature_;
    uint32 length_;
    bool is_orig_;
    bool proc_k_;
    bool proc_q_;
};


class ssh_string final {
public:
    ssh_string();
    ~ssh_string();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 len() const { return len_; }
    bytestring const& val() const { return val_; }

protected:
    uint32 len_;
    bytestring val_;
};


class ssh_host_key final {
public:
    ssh_host_key();
    ~ssh_host_key();
    int initial_buffer_length() const { return 4; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 len() const { return len_; }
    ssh_string* key_type() const { return key_type_; }
    ssh_string* key() const { return key_; }

protected:
    uint32 len_;
    ssh_string* key_type_;
    ssh_string* key_;
};


class SSH_Flow final : public binpac::FlowAnalyzer {
public:
    SSH_Flow(SSH_Conn* connection, bool is_orig);
    ~SSH_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    SSH_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    bool proc_ssh_version_client(SSH_Version_Client* msg);
    bool proc_ssh_version_server(SSH_Version_Server* msg);
    bool proc_ssh2_kexinit(SSH2_KEXINIT* msg);
    bool proc_ssh2_ecc_init(bool is_orig);
    bool proc_ssh2_dh_gex_init(bool is_orig);
    bool proc_ssh2_gss_init(bool is_orig);
    bool proc_ssh2_rsa_secret(bool is_orig);
    bool proc_ssh2_dh_gex_group(SSH2_DH_GEX_GROUP* msg);
    bool proc_ssh2_ecc_key(bytestring const& q, bool is_orig);
    bool proc_ssh2_gss_error(SSH2_GSS_ERROR* msg);
    bool proc_ssh2_server_host_key(bytestring const& key);
    bool proc_ssh1_server_host_key(bytestring const& exp, bytestring const& mod);
    bool proc_newkeys();
    int get_kex_length(int v, uint32 packet_length);

protected:
    SSH_PDU* dataunit_;
    ContextSSH* context_;
    FlowBuffer* flow_buffer_;
    SSH_Conn* connection_;
    bool is_orig_;
};


zeek::VectorValPtr name_list_to_vector(const bytestring& nl);
const char* fingerprint_md5(const unsigned char* d);

} // namespace SSH
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_ssh_ssh_pac_h */
