// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/ssl/dtls.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/ssl/dtls_pac.h"

namespace binpac {






namespace DTLS {
// NOLINTNEXTLINE(modernize-use-equals-default)
ContextDTLS::ContextDTLS(SSL_Conn* connection, DTLS_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextDTLS::~ContextDTLS() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SSL_Conn::SSL_Conn(DTLSAnalyzer const& zeek_analyzer) {
    upflow_ = new DTLS_Flow(this, true);
    downflow_ = new DTLS_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		server_state_ = STATE_CLEAR;
		client_state_ = STATE_CLEAR;
		record_layer_version_ = UNKNOWN_VERSION;
	

		invalid_version_count_ = 0;
		reported_errors_ = 0;
	

		established_ = false;
		decryption_failed_ = false;
	

		memset(&server, 0, sizeof(server));
		memset(&client, 0, sizeof(client));
	
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SSL_Conn::~SSL_Conn() {

	

		delete [] server.buffer;
		delete [] client.buffer;
	
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void SSL_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void SSL_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void SSL_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

int SSL_Conn::client_state() {
 return client_state_; 
}

int SSL_Conn::server_state() {
 return client_state_; 
}

int SSL_Conn::state(bool is_orig) {

		if ( is_orig )
			return client_state_;
		else
			return server_state_;
		
}

bool SSL_Conn::startEncryption(bool is_orig) {

		if ( is_orig )
			client_state_ = STATE_ENCRYPTED;
		else
			server_state_ = STATE_ENCRYPTED;
		return true;
		
}

int SSL_Conn::determine_tls13() {

		// let's be conservative and only return yes if it has a valid TLS 1.3 version number here.
		uint16_t negotiated_version = zeek_analyzer()->GetNegotiatedVersion();
		if ( negotiated_version == TLSv13 || negotiated_version/0xFF == 0x7F )
			return 1;

		return 0;
		
}

int SSL_Conn::cap_alert_messages_length(int record_length) {

		int alert_length = record_length;
		int max_length = zeek::BifConst::SSL::max_alerts_per_record * 2;

		// With TLS 1.3, enforce a single alert.
		//
		// From https://datatracker.ietf.org/doc/html/rfc8446//section-5.1
		//
		//    Alert messages (Section 6) MUST NOT be fragmented across records, and
		//    multiple alert messages MUST NOT be coalesced into a single
		//    record.  In other words, a record with an Alert type MUST contain
		//    exactly one message.
		if ( determine_tls13() )
			max_length = 2;

		if ( alert_length > max_length )
			{
			zeek_analyzer()->Weird("SSL_excessive_alerts_in_record", zeek::util::fmt("%d", alert_length / 2));
			alert_length = max_length;
			}

		return alert_length;
		
}

uint16 SSL_Conn::dtls_version_ok(uint16 version) {

		switch ( version ) {
		case DTLSv10:
		case DTLSv12:
			// Reset only to 0 once we have seen a client hello.
			// This means the connection gets a limited amount of valid/invalid
			// packets before a client hello has to be seen - which seems reasonable.
			if ( zeek_analyzer()->AnalyzerConfirmed() )
				invalid_version_count_ = 0;
			return true;

		default:
			invalid_version_count_++;

			if ( zeek_analyzer()->AnalyzerConfirmed() )
				{
				reported_errors_++;
				if ( reported_errors_ <= zeek::BifConst::SSL::dtls_max_reported_version_errors )
					zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("Invalid version in DTLS connection. Packet reported version: %d", version));
				}

			if ( invalid_version_count_ > zeek::BifConst::SSL::dtls_max_version_errors )
				zeek_analyzer()->SetSkip(true);
			return false;
		}
		
}

bool SSL_Conn::is_unified_record(uint8 firstbyte) {

			uint16_t negotiated_version = zeek_analyzer()->GetNegotiatedVersion();
			return negotiated_version == DTLSv13 && ( (firstbyte & 0xE0) == 0x20 );
			
}

bool SSL_Conn::setEstablished() {

		established_ = true;
		return true;
		
}

bool SSL_Conn::proc_alert(SSLRecord* rec, int level, int desc) {

		if ( ssl_alert )
			zeek::BifEvent::enqueue_ssl_alert(zeek_analyzer(), zeek_analyzer()->Conn(),
							rec->is_orig() ^ zeek_analyzer()->GetFlipped(), level, desc);
		return true;
		
}

bool SSL_Conn::proc_unknown_record(SSLRecord* rec) {

		zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("unknown SSL record type (%d) from %s",
				rec->content_type(),
				orig_label(rec->is_orig()).c_str()));
		return true;
		
}

bool SSL_Conn::proc_ciphertext_record(SSLRecord* rec, const_bytestring const& cont) {

		if ( established_ == false && determine_tls13() == 1 )
			{
			if ( ssl_probable_encrypted_handshake_message )
				zeek::BifEvent::enqueue_ssl_probable_encrypted_handshake_message(zeek_analyzer(),
					zeek_analyzer()->Conn(), rec->is_orig(), rec->length());
			}

		if ( client_state_ == STATE_ENCRYPTED &&
		     server_state_ == STATE_ENCRYPTED &&
		     established_ == false )
			{
			established_ = true;
			if ( ssl_established )
				zeek::BifEvent::enqueue_ssl_established(zeek_analyzer(), zeek_analyzer()->Conn());
			}

		if ( ssl_encrypted_data )
			{
			zeek::BifEvent::enqueue_ssl_encrypted_data(zeek_analyzer(),
				zeek_analyzer()->Conn(), rec->is_orig() ^ zeek_analyzer()->GetFlipped(), rec->raw_tls_version(), rec->content_type(), rec->length());
			}

		if ( rec->content_type() == APPLICATION_DATA && decryption_failed_ == false )
			{
			// If decryption of one packet fails, do not try to decrypt future packets.
			if ( ! zeek_analyzer()->TryDecryptApplicationData(cont.length(), cont.begin(), rec->is_orig() ^ zeek_analyzer()->GetFlipped(), rec->content_type(), rec->raw_tls_version()) )
				decryption_failed_ = true;
			}

		return true;
		
}

bool SSL_Conn::proc_plaintext_record(SSLRecord* rec) {

		if ( ssl_plaintext_data )
			zeek::BifEvent::enqueue_ssl_plaintext_data(zeek_analyzer(),
				zeek_analyzer()->Conn(), rec->is_orig() ^ zeek_analyzer()->GetFlipped(), rec->raw_tls_version(), rec->content_type(), rec->length());

		return true;
		
}

bool SSL_Conn::proc_heartbeat(SSLRecord* rec, uint8 type, uint16 payload_length, bytestring const& data) {

		if ( ssl_heartbeat )
			zeek::BifEvent::enqueue_ssl_heartbeat(zeek_analyzer(),
				zeek_analyzer()->Conn(), rec->is_orig() ^ zeek_analyzer()->GetFlipped(), rec->length(), type, payload_length,
				zeek::make_intrusive<zeek::StringVal>(data.length(), reinterpret_cast<const char*>(data.data())));
		return true;
		
}

bool SSL_Conn::proc_check_v2_server_hello_version(uint16 version) {

		if ( version != SSLv20 )
			{
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("Invalid version in SSL server hello. Version: %d", version));
			zeek_analyzer()->SetSkip(true);
			return false;
			}

		return true;
		
}

bool SSL_Conn::proc_ccs(SSLRecord* rec) {

		if ( ssl_change_cipher_spec )
			zeek::BifEvent::enqueue_ssl_change_cipher_spec(zeek_analyzer(),
				zeek_analyzer()->Conn(), rec->is_orig() ^ zeek_analyzer()->GetFlipped());

		return true;
		
}

bool SSL_Conn::proc_dtls(SSLRecord* pdu, uint64 sequence) {

		//fprintf(stderr, "Type: %d, sequence number: %d, epoch: %d\n", ${pdu.content_type}, sequence, ${pdu.epoch});

		return true;
		
}

bool SSL_Conn::proc_handshake(SSLRecord* pdu, Handshake* rec) {

		uint32 foffset = to_int()(rec->fragment_offset());
		int64  flength = to_int()(rec->fragment_length());
		int64  length = to_int()(rec->length());
		uint64 sequence_number = to_int()(pdu->sequence_number());
		//fprintf(stderr, "Handshake type: %d, length: %u, seq: %u, foffset: %u, flength: %u\n", ${rec.msg_type}, to_int()(${rec.length}), ${rec.message_seq}, to_int()(${rec.fragment_offset}), to_int()(${rec.fragment_length}));

		if ( foffset == 0 && length == flength )
			{
			//fprintf(stderr, "Complete fragment, forwarding...\n");
			zeek_analyzer()->SendHandshake(pdu->raw_tls_version(), rec->msg_type(), length, rec->data().begin(), rec->data().end(), pdu->is_orig());
			return true;
			}

		// if we fall through here, the message has to be reassembled. Let's first get the right info record...
		message_info* i;
		if ( pdu->is_orig() )
			i = &client;
		else
			i = &server;

		if ( length > MAX_DTLS_HANDSHAKE_RECORD )
			{
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("DTLS record length %" PRId64 " larger than allowed maximum.", length));
			return true;
			}

		if ( i->message_handshake_sequence != rec->message_seq() || i->message_length != length || i->buffer == nullptr )
			{
			// cannot resume reassembling. Let's abandon the current data and try anew...
			delete [] i->buffer;
			memset(i, 0, sizeof(message_info));
			i->message_handshake_sequence = rec->message_seq();
			i->message_length = length;
			i->buffer = new u_char[length];
			// does not have to be the first sequence number - we cannot figure that out at this point. If it is not,
			// we will fix that later...
			i->message_first_sequence = sequence_number;
			}

		// if we arrive here, we are actually ready to resume.
		if ( i->message_first_sequence > sequence_number )
			{
			if ( i->first_sequence_seen )
				{
				zeek_analyzer()->AnalyzerViolation("Saw second and different first message fragment for handshake.");
				return true;
				}
			// first sequence number was incorrect, let's fix that.
			uint64 diff = i->message_first_sequence - sequence_number;
			i->message_sequence_seen = i->message_sequence_seen << diff;
			i->message_first_sequence = sequence_number;
			}

		// if we have offset 0, we know the smallest number...
		if ( foffset == 0 )
			i->first_sequence_seen = true;

		// check if we already saw the message
		if ( ( i->message_sequence_seen & ( 1 << (sequence_number - i->message_first_sequence) ) ) != 0 )
			return true; // do not handle same message fragment twice

		// copy data from fragment to buffer
		if ( rec->data().length() != flength )
			{
			zeek_analyzer()->AnalyzerViolation("DTLS handshake record length does not match packet length");
			return true;
			}

		if ( foffset + flength > length )
			{
			zeek_analyzer()->AnalyzerViolation("DTLS handshake fragment trying to write past end of buffer");
			return true;
			}

		// store that we handled fragment
		i->message_sequence_seen |= 1 << (sequence_number - i->message_first_sequence);
		memcpy(i->buffer + foffset, rec->data().data(), rec->data().length());

		//fprintf(stderr, "Copied to buffer offset %u length %u\n", foffset, ${rec.data}.length());

		// store last fragment information if this is the last fragment...

		// check if we saw all fragments so far. If yes, forward...
		if ( foffset + flength == length )
			i->message_last_sequence = sequence_number;

		if ( i->message_last_sequence != 0 && i->first_sequence_seen )
			{
			uint64 total_length = i->message_last_sequence - i->message_first_sequence;
			if ( total_length > 30 )
				{
				zeek_analyzer()->AnalyzerViolation("DTLS Message fragmented over more than 30 pieces. Cannot reassemble.");
				return true;
				}

			if ( ( ~(i->message_sequence_seen) & ( ( 1<<(total_length+1) ) -1 ) ) == 0 )
				{
				//fprintf(stderr, "ALl fragments here. Total length %u\n", length);
				zeek_analyzer()->SendHandshake(pdu->raw_tls_version(), rec->msg_type(), length, i->buffer, i->buffer + length, pdu->is_orig());
				}
			}


		return true;
		
}

bool SSL_Conn::proc_unified_record(bool is_orig, UnifiedRecord* ur) {

			// we don't have a CCS packet anymore - so let's just assume the connection is established once we have seen a packet from each direction.
			if ( is_orig )
				client_state_ = STATE_ENCRYPTED;
			else
				server_state_ = STATE_ENCRYPTED;

			if ( client_state_ == STATE_ENCRYPTED && server_state_ == STATE_ENCRYPTED && established_ == false )
				{
				established_ = true;
				if ( ssl_established )
					zeek::BifEvent::enqueue_ssl_established(zeek_analyzer(), zeek_analyzer()->Conn());
				}

			if ( ssl_encrypted_data )
				{
				// In case a CID is given, swallow is not quite the correct length, because we are not parsing the entire header. This is not entirely
				// trivial to work around, and the workaround won't work in all cases - and it might also not matter.
				// We also have more potentially interesting information (the sequence number) - which we don't currently give to scriptland.
				zeek::BifEvent::enqueue_ssl_encrypted_data(zeek_analyzer(),
					zeek_analyzer()->Conn(), is_orig ^ zeek_analyzer()->GetFlipped(), DTLSv13, APPLICATION_DATA, ur->swallow().length());
				}

			return true;
			
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PlaintextRecord::PlaintextRecord(SSLRecord* rec) {
    val_case_index_ = -1;
    ch_cipher_ = nullptr;
    alerts_ = nullptr;
    heartbeat_ = nullptr;
    app_data_ = nullptr;
    unknown_record_ = nullptr;
    handshake_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PlaintextRecord::~PlaintextRecord() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)20):
            // Clean up "ch_cipher"
            {
                delete ch_cipher_;
                ch_cipher_ = nullptr;
            }
            break;
        case ((uint8)21):
            // Clean up "alerts"
            {
                delete alerts_;
                alerts_ = nullptr;
            }
            break;
        case ((uint8)24):
            // Clean up "heartbeat"
            {
                delete heartbeat_;
                heartbeat_ = nullptr;
            }
            break;
        case ((uint8)23):
            // Clean up "app_data"
            {
                delete app_data_;
                app_data_ = nullptr;
            }
            break;
        case ((uint8)22):
            // Clean up "handshake"
            {
                delete handshake_;
                handshake_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown_record"
            {
                delete unknown_record_;
                unknown_record_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int PlaintextRecord::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = rec()->content_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)20):
            // Parse "ch_cipher"
            {
                ch_cipher_ = new ChangeCipherSpec(rec());
                ch_cipher_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 1;
            }
            break;
        case ((uint8)21):
            // Parse "alerts"
            {
                alerts_ = new Alerts(rec());
                int t_alerts__size;
                t_alerts__size = alerts_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_alerts__size;
            }
            break;
        case ((uint8)24):
            // Parse "heartbeat"
            {
                heartbeat_ = new Heartbeat(rec());
                int t_heartbeat__size;
                t_heartbeat__size = heartbeat_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_heartbeat__size;
            }
            break;
        case ((uint8)23):
            // Parse "app_data"
            {
                app_data_ = new ApplicationData(rec());
                int t_app_data__size;
                t_app_data__size = app_data_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_app_data__size;
            }
            break;
        case ((uint8)22):
            // Parse "handshake"
            {
                handshake_ = new Handshake(rec());
                int t_handshake__size;
                t_handshake__size = handshake_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_handshake__size;
            }
            break;
        default:
            // Parse "unknown_record"
            {
                unknown_record_ = new UnknownRecord(rec());
                int t_unknown_record__size;
                t_unknown_record__size = unknown_record_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_unknown_record__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_plaintext_record(rec());
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ChangeCipherSpec::ChangeCipherSpec(SSLRecord* rec) {
    type_ = 0;
    rec_ = rec;
    state_changed_ = false;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ChangeCipherSpec::~ChangeCipherSpec() {
}

int ChangeCipherSpec::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context) {
    // Checking out-of-bound for "ChangeCipherSpec"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ChangeCipherSpec",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 1;
        // Checking out-of-bound for "ChangeCipherSpec:type"
        if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("ChangeCipherSpec:type",
            	(0) + (1), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "type"
        type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

        // Evaluate 'let' and 'withinput' fields
        int t_t_var_001;
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( t_context->connection()->determine_tls13() ) {
            case ((int)1):
                t_t_var_001 = false;
                break;
            case ((int)0):
                t_t_var_001 = t_context->connection()->startEncryption(rec()->is_orig());
                break;
            default:
                throw binpac::ExceptionInvalidCaseIndex("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:39", (int64)t_context->connection()->determine_tls13());
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        state_changed_ = t_t_var_001;
        proc_ = t_context->connection()->proc_ccs(rec());
    }
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Alerts::Alerts(SSLRecord* rec) {
    alerts_ = nullptr;
    alerts__elem_ = nullptr;
    rec_ = rec;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Alerts::~Alerts() {
    delete alerts__elem_;
    alerts__elem_ = nullptr;
    if ( alerts() ) {
        for ( auto* alerts__elem_ : *alerts() ) {
            delete alerts__elem_;
            alerts__elem_ = nullptr;
        }
    }
    delete alerts_;
}

int Alerts::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context) {
    int t_Alerts__size;
    t_Alerts__size = rec()->length();
    // Checking out-of-bound for "Alerts"
    if ( t_begin_of_data + (t_Alerts__size) > t_end_of_data || t_begin_of_data + (t_Alerts__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Alerts",
        	(0) + (t_Alerts__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_Alerts__size;
        // Parse "alerts"
        int t_alerts__size;
        t_alerts__size = t_context->connection()->cap_alert_messages_length(rec()->length());
        // Checking out-of-bound for "Alerts:alerts"
        if ( t_begin_of_data + (t_alerts__size) > t_end_of_data || t_begin_of_data + (t_alerts__size) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("Alerts:alerts",
            	(0) + (t_alerts__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_begin_of_data + t_alerts__size;
            int t_alerts__arraylength;
            t_alerts__arraylength = 0;
            alerts__elem_ = nullptr;
            int t_alerts__elem__it;
            t_alerts__elem__it = 0;
            alerts_ = new vector<Alert*>;
            const_byteptr t_alerts__elem__dataptr = t_begin_of_data;
            for (; /* forever */; ++t_alerts__elem__it) {
                // Check &until(alerts__elem__dataptr >= end_of_data)
                if ( t_alerts__elem__dataptr >= t_end_of_data ) {
                    alerts__elem_ = nullptr;
                    goto end_of_alerts;
                }
                alerts__elem_ = new Alert(rec());
                alerts__elem_->Parse(t_alerts__elem__dataptr, t_end_of_data, t_context);
                alerts_->push_back(alerts__elem_);
                t_alerts__elem__dataptr += 2;
                BINPAC_ASSERT(t_alerts__elem__dataptr <= t_end_of_data);
                alerts__elem_ = nullptr;
            }
        end_of_alerts: ;
            // Evaluate 'let' and 'withinput' fields
        }

        const_byteptr const t_dataptr_after_alerts = t_begin_of_data + (t_alerts__size);
        BINPAC_ASSERT(t_dataptr_after_alerts <= t_end_of_data);
        // Parse "rest"
        int t_rest_string_length;
        t_rest_string_length = (t_end_of_data) - (t_dataptr_after_alerts);
        int t_rest__size;
        t_rest__size = t_rest_string_length;
        // check for negative sizes
        if ( t_rest_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:49", t_rest_string_length);
        rest_.init(t_dataptr_after_alerts, t_rest_string_length);

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_Alerts__size) <= t_end_of_data);
    return t_Alerts__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Alert::Alert(SSLRecord* rec) {
    level_ = 0;
    description_ = 0;
    rec_ = rec;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Alert::~Alert() {
}

int Alert::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context) {
    // Checking out-of-bound for "Alert"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Alert",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "level"
    level_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "description"
    description_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_alert(rec(), level(), description());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ApplicationData::ApplicationData(SSLRecord* rec) {
    rec_ = rec;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ApplicationData::~ApplicationData() {
}

int ApplicationData::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context) {
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:65", t_data_string_length);
    data_.init(t_begin_of_data, t_data_string_length);

    int t_ApplicationData__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_ApplicationData__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ApplicationData__size) <= t_end_of_data);
    return t_ApplicationData__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Heartbeat::Heartbeat(SSLRecord* rec) {
    type_ = 0;
    payload_length_ = 0;
    rec_ = rec;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Heartbeat::~Heartbeat() {
    data_.free();
}

int Heartbeat::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context, int t_byteorder) {
    // Checking out-of-bound for "Heartbeat:payload_length"
    if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Heartbeat:payload_length",
        	(1) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "type"
    type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "payload_length"
    payload_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 3));
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:75", t_data_string_length);
    data_.init((t_begin_of_data + 3), t_data_string_length);

    int t_Heartbeat__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 3) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Heartbeat__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_heartbeat(rec(), type(), payload_length(), data());
    BINPAC_ASSERT(t_begin_of_data + (t_Heartbeat__size) <= t_end_of_data);
    return t_Heartbeat__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UnknownRecord::UnknownRecord(SSLRecord* rec) {
    rec_ = rec;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UnknownRecord::~UnknownRecord() {
}

int UnknownRecord::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context) {
    // Parse "cont"
    int t_cont_string_length;
    t_cont_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_cont__size;
    t_cont__size = t_cont_string_length;
    // check for negative sizes
    if ( t_cont_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:84", t_cont_string_length);
    cont_.init(t_begin_of_data, t_cont_string_length);

    int t_UnknownRecord__size;
    const_byteptr const t_dataptr_after_cont = t_begin_of_data + (t_cont__size);
    BINPAC_ASSERT(t_dataptr_after_cont <= t_end_of_data);
    t_UnknownRecord__size = t_dataptr_after_cont - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_unknown_record(rec());
    BINPAC_ASSERT(t_begin_of_data + (t_UnknownRecord__size) <= t_end_of_data);
    return t_UnknownRecord__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CiphertextRecord::CiphertextRecord(SSLRecord* rec) {
    rec_ = rec;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CiphertextRecord::~CiphertextRecord() {
}

int CiphertextRecord::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context) {
    // Parse "cont"
    int t_cont_string_length;
    t_cont_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_cont__size;
    t_cont__size = t_cont_string_length;
    // check for negative sizes
    if ( t_cont_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:88", t_cont_string_length);
    cont_.init(t_begin_of_data, t_cont_string_length);

    int t_CiphertextRecord__size;
    const_byteptr const t_dataptr_after_cont = t_begin_of_data + (t_cont__size);
    BINPAC_ASSERT(t_dataptr_after_cont <= t_end_of_data);
    t_CiphertextRecord__size = t_dataptr_after_cont - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_ciphertext_record(rec(), cont_);
    BINPAC_ASSERT(t_begin_of_data + (t_CiphertextRecord__size) <= t_end_of_data);
    return t_CiphertextRecord__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DTLSPDU::DTLSPDU(bool is_orig) {
    records_ = nullptr;
    records__elem_ = nullptr;
    is_orig_ = is_orig;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DTLSPDU::~DTLSPDU() {
    delete records__elem_;
    records__elem_ = nullptr;
    if ( records_ ) {
        for ( auto* records__elem_ : *records_ ) {
            delete records__elem_;
            records__elem_ = nullptr;
        }
    }
    delete records_;
}

int DTLSPDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context) {
    // Parse "records"
    int t_records__arraylength;
    t_records__arraylength = 0;
    records__elem_ = nullptr;
    int t_records__elem__it;
    t_records__elem__it = 0;
    int t_records__size;
    records_ = new vector<SSLRecordSwitch*>;
    const_byteptr t_records__elem__dataptr = t_begin_of_data;
    for (; /* forever */; ++t_records__elem__it) {
        // Check &until(records__elem__dataptr >= end_of_data)
        if ( t_records__elem__dataptr >= t_end_of_data ) {
            records__elem_ = nullptr;
            goto end_of_records;
        }
        records__elem_ = new SSLRecordSwitch(is_orig());
        int t_records__elem__size;
        t_records__elem__size = records__elem_->Parse(t_records__elem__dataptr, t_end_of_data, t_context);
        delete records__elem_;
        t_records__elem__dataptr += t_records__elem__size;
        BINPAC_ASSERT(t_records__elem__dataptr <= t_end_of_data);
        records__elem_ = nullptr;
    }
end_of_records: ;
    t_records__size = t_records__elem__dataptr - (t_begin_of_data);
    // Evaluate 'let' and 'withinput' fields

    int t_DTLSPDU__size;
    const_byteptr const t_dataptr_after_records = t_begin_of_data + (t_records__size);
    BINPAC_ASSERT(t_dataptr_after_records <= t_end_of_data);
    t_DTLSPDU__size = t_dataptr_after_records - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_DTLSPDU__size) <= t_end_of_data);
    return t_DTLSPDU__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SSLRecordSwitch::SSLRecordSwitch(bool is_orig) {
    firstbyte_ = 0;
    cont_case_index_ = -1;
    rec_ = nullptr;
    unified_ = nullptr;
    is_orig_ = is_orig;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SSLRecordSwitch::~SSLRecordSwitch() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( cont_case_index() ) {
        case false:
            // Clean up "rec"
            {
                delete rec_;
                rec_ = nullptr;
            }
            break;
        case true:
            // Clean up "unified"
            {
                delete unified_;
                unified_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SSLRecordSwitch::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context) {
    // Checking out-of-bound for "SSLRecordSwitch:firstbyte"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSLRecordSwitch:firstbyte",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "firstbyte"
    firstbyte_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "cont"
    int t_cont__size;
    cont_case_index_ = t_context->connection()->is_unified_record(firstbyte());
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( cont_case_index() ) {
        case false:
            // Parse "rec"
            {
                rec_ = new SSLRecord(firstbyte(), is_orig());
                int t_rec__size;
                t_rec__size = rec_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
                t_cont__size = t_rec__size;
            }
            break;
        case true:
            // Parse "unified"
            {
                unified_ = new UnifiedRecord(firstbyte(), is_orig());
                int t_unified__size;
                t_unified__size = unified_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
                t_cont__size = t_unified__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SSLRecordSwitch", (int64)cont_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SSLRecordSwitch__size;
    const_byteptr const t_dataptr_after_cont = (t_begin_of_data + 1) + (t_cont__size);
    BINPAC_ASSERT(t_dataptr_after_cont <= t_end_of_data);
    t_SSLRecordSwitch__size = t_dataptr_after_cont - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SSLRecordSwitch__size) <= t_end_of_data);
    return t_SSLRecordSwitch__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UnifiedRecord::UnifiedRecord(uint8 firstbyte, bool is_orig) {
    seqnum_case_index_ = -1;
    lengthfield_case_index_ = -1;
    length_ = 0;
    firstbyte_ = firstbyte;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
    with_cid_ = false;
    sequence_number_length_ = false;
    length_present_ = false;
    epoch_low_bits_ = 0;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UnifiedRecord::~UnifiedRecord() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( seqnum_case_index() ) {
        case false:
            // Clean up "sequence_number"
            {
                sequence_number_.free();
            }
            break;
        case true:
            // Clean up "nothing1"
            {
                nothing1_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( lengthfield_case_index() ) {
        case ((int)1):
            // Clean up "length"
            {
            }
            break;
        case ((int)0):
            // Clean up "nothing2"
            {
                nothing2_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    swallow_.free();
}

int UnifiedRecord::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context) {
    // Parse "seqnum"
    sequence_number_length_ =  (  ( firstbyte() & 0x08 )  == 0x08 ) ;
    with_cid_ =  (  ( firstbyte() & 0x10 )  == 0x10 ) ;
    int t_seqnum__size;
    seqnum_case_index_ = with_cid();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( seqnum_case_index() ) {
        case false:
            // Parse "sequence_number"
            {
                int t_sequence_number__size;
                t_sequence_number__size =  ( sequence_number_length() ? 2 : 1 ) ;
                // Checking out-of-bound for "UnifiedRecord:sequence_number"
                if ( t_begin_of_data + (t_sequence_number__size) > t_end_of_data || t_begin_of_data + (t_sequence_number__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("UnifiedRecord:sequence_number",
                    	(0) + (t_sequence_number__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_sequence_number__size;
                    int t_sequence_number_string_length;
                    t_sequence_number_string_length =  ( sequence_number_length() ? 2 : 1 ) ;
                    // check for negative sizes
                    if ( t_sequence_number_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/dtls-protocol.pac:30", t_sequence_number_string_length);
                    sequence_number_.init(t_begin_of_data, t_sequence_number_string_length);
                }
                t_seqnum__size = t_sequence_number__size;
            }
            break;
        case true:
            // Parse "nothing1"
            {
                // Checking out-of-bound for "UnifiedRecord:nothing1"
                if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("UnifiedRecord:nothing1",
                    	(0) + (0), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + 0;
                    int t_nothing1_string_length;
                    t_nothing1_string_length = 0;
                    int t_nothing1__size;
                    t_nothing1__size = t_nothing1_string_length;
                    nothing1_.init(t_begin_of_data, t_nothing1_string_length);
                }
                t_seqnum__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("UnifiedRecord", (int64)seqnum_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_seqnum = t_begin_of_data + (t_seqnum__size);
    BINPAC_ASSERT(t_dataptr_after_seqnum <= t_end_of_data);
    // Parse "lengthfield"
    length_present_ =  (  ( firstbyte() & 0x04 )  == 0x04 ) ;
    int t_lengthfield__size;
    lengthfield_case_index_ =  ( with_cid() == false && length_present() == true ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( lengthfield_case_index() ) {
        case ((int)1):
            // Parse "length"
            {
                // Checking out-of-bound for "UnifiedRecord:length"
                if ( t_dataptr_after_seqnum + (2) > t_end_of_data || t_dataptr_after_seqnum + (2) < t_dataptr_after_seqnum ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("UnifiedRecord:length",
                    	((t_dataptr_after_seqnum - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_seqnum)));
                t_lengthfield__size = 2;
            }
            break;
        case ((int)0):
            // Parse "nothing2"
            {
                // Checking out-of-bound for "UnifiedRecord:nothing2"
                if ( t_dataptr_after_seqnum + (0) > t_end_of_data || t_dataptr_after_seqnum + (0) < t_dataptr_after_seqnum ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("UnifiedRecord:nothing2",
                    	((t_dataptr_after_seqnum - t_begin_of_data)) + (0), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_seqnum + 0;
                    int t_nothing2_string_length;
                    t_nothing2_string_length = 0;
                    int t_nothing2__size;
                    t_nothing2__size = t_nothing2_string_length;
                    nothing2_.init(t_dataptr_after_seqnum, t_nothing2_string_length);
                }
                t_lengthfield__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("UnifiedRecord", (int64)lengthfield_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_lengthfield = t_dataptr_after_seqnum + (t_lengthfield__size);
    BINPAC_ASSERT(t_dataptr_after_lengthfield <= t_end_of_data);
    // Parse "swallow"
    int t_swallow_string_length;
    t_swallow_string_length = (t_end_of_data) - (t_dataptr_after_lengthfield);
    int t_swallow__size;
    t_swallow__size = t_swallow_string_length;
    // check for negative sizes
    if ( t_swallow_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/dtls-protocol.pac:37", t_swallow_string_length);
    swallow_.init(t_dataptr_after_lengthfield, t_swallow_string_length);

    int t_UnifiedRecord__size;
    const_byteptr const t_dataptr_after_swallow = t_dataptr_after_lengthfield + (t_swallow__size);
    BINPAC_ASSERT(t_dataptr_after_swallow <= t_end_of_data);
    t_UnifiedRecord__size = t_dataptr_after_swallow - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    epoch_low_bits_ =  ( firstbyte() & 0x03 ) ;
    proc_ = t_context->connection()->proc_unified_record(is_orig(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_UnifiedRecord__size) <= t_end_of_data);
    return t_UnifiedRecord__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SSLRecord::SSLRecord(uint8 content_type, bool is_orig) {
    version_ = 0;
    epoch_ = 0;
    sequence_number_ = nullptr;
    length_ = 0;
    cont_case_index_ = -1;
    rec_ = nullptr;
    rec__elem_ = nullptr;
    content_type_ = content_type;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
    valid_ = false;
    raw_tls_version_ = 0;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SSLRecord::~SSLRecord() {
    delete sequence_number_;
    sequence_number_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( cont_case_index() ) {
        case true:
            // Clean up "rec"
            {
                delete rec__elem_;
                rec__elem_ = nullptr;
                if ( rec() ) {
                    for ( auto* rec__elem_ : *rec() ) {
                        delete rec__elem_;
                        rec__elem_ = nullptr;
                    }
                }
                delete rec_;
            }
            break;
        case false:
            // Clean up "swallow"
            {
                swallow_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SSLRecord::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context) {
    // Checking out-of-bound for "SSLRecord:length"
    if ( (t_begin_of_data + 10) + (2) > t_end_of_data || (t_begin_of_data + 10) + (2) < (t_begin_of_data + 10) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSLRecord:length",
        	(10) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "version"
    version_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "epoch"
    epoch_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "sequence_number"
    sequence_number_ = new uint48();
    sequence_number_->Parse((t_begin_of_data + 4), t_end_of_data);

    // Parse "length"
    length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 10))));

    // Parse "cont"
    valid_ = t_context->connection()->dtls_version_ok(version());
    raw_tls_version_ = version();
    int t_cont__size;
    cont_case_index_ = valid();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( cont_case_index() ) {
        case true:
            // Parse "rec"
            {
                int t_rec__size;
                t_rec__size = length();
                // Checking out-of-bound for "SSLRecord:rec"
                if ( (t_begin_of_data + 12) + (t_rec__size) > t_end_of_data || (t_begin_of_data + 12) + (t_rec__size) < (t_begin_of_data + 12) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SSLRecord:rec",
                    	(12) + (t_rec__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 12) + t_rec__size;
                    int t_rec__arraylength;
                    t_rec__arraylength = 0;
                    rec__elem_ = nullptr;
                    int t_rec__elem__it;
                    t_rec__elem__it = 0;
                    rec_ = new vector<RecordText*>;
                    const_byteptr t_rec__elem__dataptr = (t_begin_of_data + 12);
                    for (; /* forever */; ++t_rec__elem__it) {
                        // Check &until(rec__elem__dataptr >= end_of_data)
                        if ( t_rec__elem__dataptr >= t_end_of_data ) {
                            rec__elem_ = nullptr;
                            goto end_of_rec;
                        }
                        rec__elem_ = new RecordText(this);
                        int t_rec__elem__size;
                        t_rec__elem__size = rec__elem_->Parse(t_rec__elem__dataptr, t_end_of_data, t_context, byteorder());
                        rec_->push_back(rec__elem_);
                        t_rec__elem__dataptr += t_rec__elem__size;
                        BINPAC_ASSERT(t_rec__elem__dataptr <= t_end_of_data);
                        rec__elem_ = nullptr;
                    }
                end_of_rec: ;
                    // Evaluate 'let' and 'withinput' fields
                }
                t_cont__size = t_rec__size;
            }
            break;
        case false:
            // Parse "swallow"
            {
                int t_swallow_string_length;
                t_swallow_string_length = (t_end_of_data) - ((t_begin_of_data + 12));
                int t_swallow__size;
                t_swallow__size = t_swallow_string_length;
                // check for negative sizes
                if ( t_swallow_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/dtls-protocol.pac:54", t_swallow_string_length);
                swallow_.init((t_begin_of_data + 12), t_swallow_string_length);
                t_cont__size = t_swallow__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SSLRecord", (int64)cont_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SSLRecord__size;
    const_byteptr const t_dataptr_after_cont = (t_begin_of_data + 12) + (t_cont__size);
    BINPAC_ASSERT(t_dataptr_after_cont <= t_end_of_data);
    t_SSLRecord__size = t_dataptr_after_cont - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_dtls(this, to_int()(sequence_number()));
    BINPAC_ASSERT(t_begin_of_data + (t_SSLRecord__size) <= t_end_of_data);
    return t_SSLRecord__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RecordText::RecordText(SSLRecord* rec) {
    val_case_index_ = -1;
    plaintext_ = nullptr;
    ciphertext_ = nullptr;
    rec_ = rec;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RecordText::~RecordText() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint16)0):
            // Clean up "plaintext"
            {
                delete plaintext_;
                plaintext_ = nullptr;
            }
            break;
        default:
            // Clean up "ciphertext"
            {
                delete ciphertext_;
                ciphertext_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int RecordText::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = rec()->epoch();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint16)0):
            // Parse "plaintext"
            {
                plaintext_ = new PlaintextRecord(rec());
                int t_plaintext__size;
                t_plaintext__size = plaintext_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_plaintext__size;
            }
            break;
        default:
            // Parse "ciphertext"
            {
                ciphertext_ = new CiphertextRecord(rec());
                int t_ciphertext__size;
                t_ciphertext__size = ciphertext_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_ciphertext__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Handshake::Handshake(SSLRecord* rec) {
    msg_type_ = 0;
    length_ = nullptr;
    message_seq_ = 0;
    fragment_offset_ = nullptr;
    fragment_length_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Handshake::~Handshake() {
    delete length_;
    length_ = nullptr;
    delete fragment_offset_;
    fragment_offset_ = nullptr;
    delete fragment_length_;
    fragment_length_ = nullptr;
    data_.free();
}

int Handshake::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDTLS* t_context, int t_byteorder) {
    // Checking out-of-bound for "Handshake:fragment_length"
    if ( (t_begin_of_data + 9) + (3) > t_end_of_data || (t_begin_of_data + 9) + (3) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Handshake:fragment_length",
        	(9) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "msg_type"
    msg_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "length"
    length_ = new uint24();
    length_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "message_seq"
    message_seq_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "fragment_offset"
    fragment_offset_ = new uint24();
    fragment_offset_->Parse((t_begin_of_data + 6), t_end_of_data);

    // Parse "fragment_length"
    fragment_length_ = new uint24();
    fragment_length_->Parse((t_begin_of_data + 9), t_end_of_data);

    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 12));
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/dtls-protocol.pac:77", t_data_string_length);
    data_.init((t_begin_of_data + 12), t_data_string_length);

    int t_Handshake__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 12) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Handshake__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_handshake(rec(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_Handshake__size) <= t_end_of_data);
    return t_Handshake__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DTLS_Flow::DTLS_Flow(SSL_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DTLS_Flow::~DTLS_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void DTLS_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new DTLSPDU(is_orig());
        context_ = new ContextDTLS(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e; // NOLINT(bugprone-exception-copy-constructor-throws)
    }
}

void DTLS_Flow::NewGap(int gap_length) {
}
void DTLS_Flow::FlowEOF() {
}
// NOLINTNEXTLINE(modernize-use-equals-default)
uint24::uint24() {
    byte1_ = 0;
    byte2_ = 0;
    byte3_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
uint24::~uint24() {
}

int uint24::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "uint24"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("uint24",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte1"
    byte1_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte2"
    byte2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "byte3"
    byte3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
uint48::uint48() {
    byte1_ = 0;
    byte2_ = 0;
    byte3_ = 0;
    byte4_ = 0;
    byte5_ = 0;
    byte6_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
uint48::~uint48() {
}

int uint48::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "uint48"
    if ( t_begin_of_data + (6) > t_end_of_data || t_begin_of_data + (6) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("uint48",
        	(0) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte1"
    byte1_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte2"
    byte2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "byte3"
    byte3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "byte4"
    byte4_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "byte5"
    byte5_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Parse "byte6"
    byte6_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 5)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (6) <= t_end_of_data);
    return 6;
}


string orig_label(bool is_orig)
		{
		return is_orig ? "originator" :"responder";
		}

zeek::StringVal* to_string_val(vector<uint8>* data) {

	char tmp[32];
	memset(tmp, 0, sizeof(tmp));

	// Just return an empty string if the string is longer than 32 bytes
	if ( data && data->size() <= 32 )
		{
		for ( unsigned int i = data->size(); i > 0; --i )
			tmp[i-1] = (*data)[i-1];
		}

	return new zeek::StringVal(32, tmp);
	
}

bool version_ok(uint16 vers) {

	if ( vers >> 8 == 0x7F ) // 1.3 draft
		return true;

	switch ( vers ) {
	case SSLv20:
	case SSLv30:
	case TLSv10:
	case TLSv11:
	case TLSv12:
	case TLSv13:
	case DTLSv10:
	case DTLSv12:
	case DTLSv13:
		return true;

	default:
		return false;
	}
	
}

uint32 const MAX_DTLS_HANDSHAKE_RECORD = 100000;
} // namespace DTLS
}  // namespace binpac
