// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_ssl_tls_handshake_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_ssl_tls_handshake_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


#include "zeek/Desc.h"

#include "zeek/analyzer/protocol/ssl/types.bif.h"
#include "zeek/analyzer/protocol/ssl/events.bif.h"


#include <string>
#include "zeek/analyzer/protocol/ssl/events.bif.h"

using std::string;


#include <vector>
#include <algorithm>
#include <iostream>
#include <iterator>

#include "zeek/util.h"
#include "zeek/file_analysis/Manager.h"

namespace binpac {

namespace TLSHandshake {
class ContextTLSHandshake;
class Handshake_Conn;
class uint24;
class uint48;
// NOLINTNEXTLINE(performance-enum-size)
enum ContentType {
    CHANGE_CIPHER_SPEC = 20,
    ALERT = 21,
    HANDSHAKE = 22,
    APPLICATION_DATA = 23,
    HEARTBEAT = 24,
    V2_ERROR = 300,
    V2_CLIENT_HELLO = 301,
    V2_CLIENT_MASTER_KEY = 302,
    V2_SERVER_HELLO = 304,
    UNKNOWN_OR_V2_ENCRYPTED = 400,
};
// NOLINTNEXTLINE(performance-enum-size)
enum SSLVersions {
    UNKNOWN_VERSION = 0,
    SSLv20 = 2,
    SSLv30 = 768,
    TLSv10 = 769,
    TLSv11 = 770,
    TLSv12 = 771,
    TLSv13 = 772,
    TLSv13_draft = 32512,
    DTLSv10 = 65279,
    DTLSv12 = 65277,
    DTLSv13 = 65276,
};
// NOLINTNEXTLINE(performance-enum-size)
enum SSLExtensions {
    EXT_SERVER_NAME = 0,
    EXT_MAX_FRAGMENT_LENGTH = 1,
    EXT_CLIENT_CERTIFICATE_URL = 2,
    EXT_TRUSTED_CA_KEYS = 3,
    EXT_TRUNCATED_HMAC = 4,
    EXT_STATUS_REQUEST = 5,
    EXT_USER_MAPPING = 6,
    EXT_CLIENT_AUTHZ = 7,
    EXT_SERVER_AUTHZ = 8,
    EXT_CERT_TYPE = 9,
    EXT_ELLIPTIC_CURVES = 10,
    EXT_EC_POINT_FORMATS = 11,
    EXT_SRP = 12,
    EXT_SIGNATURE_ALGORITHMS = 13,
    EXT_USE_SRTP = 14,
    EXT_HEARTBEAT = 15,
    EXT_APPLICATION_LAYER_PROTOCOL_NEGOTIATION = 16,
    EXT_STATUS_REQUEST_V2 = 17,
    EXT_SIGNED_CERTIFICATE_TIMESTAMP = 18,
    EXT_SESSIONTICKET_TLS = 35,
    EXT_KEY_SHARE_OLD = 40,
    EXT_PRE_SHARED_KEY = 41,
    EXT_EARLY_DATA = 42,
    EXT_SUPPORTED_VERSIONS = 43,
    EXT_COOKIE = 44,
    EXT_PSK_KEY_EXCHANGE_MODES = 45,
    EXT_TICKET_EARLY_DATA_INFO = 46,
    EXT_CERTIFICATE_AUTHORITIES = 47,
    EXT_OID_FILTERS = 48,
    EXT_KEY_SHARE = 51,
    EXT_CONNECTION_ID = 54,
    EXT_NEXT_PROTOCOL_NEGOTIATION = 13172,
    EXT_ORIGIN_BOUND_CERTIFICATES = 13175,
    EXT_ENCRYPTED_CLIENT_CERTIFICATES = 13180,
    EXT_CHANNEL_ID = 30031,
    EXT_CHANNEL_ID_NEW = 30032,
    EXT_PADDING = 35655,
    EXT_RENEGOTIATION_INFO = 65281,
};
// NOLINTNEXTLINE(performance-enum-size)
enum ECCurveType {
    EXPLICIT_PRIME = 1,
    EXPLICIT_CHAR = 2,
    NAMED_CURVE = 3,
};
// NOLINTNEXTLINE(performance-enum-size)
enum TLSCiphers {
    NO_CHOSEN_CIPHER = 16777215,
    TLS_NULL_WITH_NULL_NULL = 0,
    TLS_RSA_WITH_NULL_MD5 = 1,
    TLS_RSA_WITH_NULL_SHA = 2,
    TLS_RSA_EXPORT_WITH_RC4_40_MD5 = 3,
    TLS_RSA_WITH_RC4_128_MD5 = 4,
    TLS_RSA_WITH_RC4_128_SHA = 5,
    TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 6,
    TLS_RSA_WITH_IDEA_CBC_SHA = 7,
    TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = 8,
    TLS_RSA_WITH_DES_CBC_SHA = 9,
    TLS_RSA_WITH_3DES_EDE_CBC_SHA = 10,
    TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = 11,
    TLS_DH_DSS_WITH_DES_CBC_SHA = 12,
    TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = 13,
    TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = 14,
    TLS_DH_RSA_WITH_DES_CBC_SHA = 15,
    TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = 16,
    TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 17,
    TLS_DHE_DSS_WITH_DES_CBC_SHA = 18,
    TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19,
    TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 20,
    TLS_DHE_RSA_WITH_DES_CBC_SHA = 21,
    TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22,
    TLS_DH_ANON_EXPORT_WITH_RC4_40_MD5 = 23,
    TLS_DH_ANON_WITH_RC4_128_MD5 = 24,
    TLS_DH_ANON_EXPORT_WITH_DES40_CBC_SHA = 25,
    TLS_DH_ANON_WITH_DES_CBC_SHA = 26,
    TLS_DH_ANON_WITH_3DES_EDE_CBC_SHA = 27,
    SSL_FORTEZZA_KEA_WITH_NULL_SHA = 28,
    SSL_FORTEZZA_KEA_WITH_FORTEZZA_CBC_SHA = 29,
    TLS_KRB5_WITH_DES_CBC_SHA = 30,
    TLS_KRB5_WITH_3DES_EDE_CBC_SHA = 31,
    TLS_KRB5_WITH_RC4_128_SHA = 32,
    TLS_KRB5_WITH_IDEA_CBC_SHA = 33,
    TLS_KRB5_WITH_DES_CBC_MD5 = 34,
    TLS_KRB5_WITH_3DES_EDE_CBC_MD5 = 35,
    TLS_KRB5_WITH_RC4_128_MD5 = 36,
    TLS_KRB5_WITH_IDEA_CBC_MD5 = 37,
    TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA = 38,
    TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA = 39,
    TLS_KRB5_EXPORT_WITH_RC4_40_SHA = 40,
    TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5 = 41,
    TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5 = 42,
    TLS_KRB5_EXPORT_WITH_RC4_40_MD5 = 43,
    TLS_RSA_WITH_AES_128_CBC_SHA = 47,
    TLS_DH_DSS_WITH_AES_128_CBC_SHA = 48,
    TLS_DH_RSA_WITH_AES_128_CBC_SHA = 49,
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 50,
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51,
    TLS_DH_ANON_WITH_AES_128_CBC_SHA = 52,
    TLS_RSA_WITH_AES_256_CBC_SHA = 53,
    TLS_DH_DSS_WITH_AES_256_CBC_SHA = 54,
    TLS_DH_RSA_WITH_AES_256_CBC_SHA = 55,
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 56,
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57,
    TLS_DH_ANON_WITH_AES_256_CBC_SHA = 58,
    TLS_RSA_WITH_NULL_SHA256 = 59,
    TLS_RSA_WITH_AES_128_CBC_SHA256 = 60,
    TLS_RSA_WITH_AES_256_CBC_SHA256 = 61,
    TLS_DH_DSS_WITH_AES_128_CBC_SHA256 = 62,
    TLS_DH_RSA_WITH_AES_128_CBC_SHA256 = 63,
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA256 = 64,
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA = 65,
    TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = 66,
    TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = 67,
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 68,
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 69,
    TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA = 70,
    TLS_RSA_EXPORT1024_WITH_RC4_56_MD5 = 96,
    TLS_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5 = 97,
    TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA = 98,
    TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA = 99,
    TLS_RSA_EXPORT1024_WITH_RC4_56_SHA = 100,
    TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA = 101,
    TLS_DHE_DSS_WITH_RC4_128_SHA = 102,
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 = 103,
    TLS_DH_DSS_WITH_AES_256_CBC_SHA256 = 104,
    TLS_DH_RSA_WITH_AES_256_CBC_SHA256 = 105,
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA256 = 106,
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 = 107,
    TLS_DH_ANON_WITH_AES_128_CBC_SHA256 = 108,
    TLS_DH_ANON_WITH_AES_256_CBC_SHA256 = 109,
    TLS_DHE_DSS_WITH_3DES_EDE_CBC_RMD = 114,
    TLS_DHE_DSS_WITH_AES_128_CBC_RMD = 115,
    TLS_DHE_DSS_WITH_AES_256_CBC_RMD = 116,
    TLS_DHE_RSA_WITH_3DES_EDE_CBC_RMD = 119,
    TLS_DHE_RSA_WITH_AES_128_CBC_RMD = 120,
    TLS_DHE_RSA_WITH_AES_256_CBC_RMD = 121,
    TLS_RSA_WITH_3DES_EDE_CBC_RMD = 124,
    TLS_RSA_WITH_AES_128_CBC_RMD = 125,
    TLS_RSA_WITH_AES_256_CBC_RMD = 126,
    TLS_GOSTR341094_WITH_28147_CNT_IMIT = 128,
    TLS_GOSTR341001_WITH_28147_CNT_IMIT = 129,
    TLS_GOSTR341094_WITH_NULL_GOSTR3411 = 130,
    TLS_GOSTR341001_WITH_NULL_GOSTR3411 = 131,
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA = 132,
    TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = 133,
    TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = 134,
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 135,
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 136,
    TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA = 137,
    TLS_PSK_WITH_RC4_128_SHA = 138,
    TLS_PSK_WITH_3DES_EDE_CBC_SHA = 139,
    TLS_PSK_WITH_AES_128_CBC_SHA = 140,
    TLS_PSK_WITH_AES_256_CBC_SHA = 141,
    TLS_DHE_PSK_WITH_RC4_128_SHA = 142,
    TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA = 143,
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA = 144,
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA = 145,
    TLS_RSA_PSK_WITH_RC4_128_SHA = 146,
    TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA = 147,
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA = 148,
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA = 149,
    TLS_RSA_WITH_SEED_CBC_SHA = 150,
    TLS_DH_DSS_WITH_SEED_CBC_SHA = 151,
    TLS_DH_RSA_WITH_SEED_CBC_SHA = 152,
    TLS_DHE_DSS_WITH_SEED_CBC_SHA = 153,
    TLS_DHE_RSA_WITH_SEED_CBC_SHA = 154,
    TLS_DH_ANON_WITH_SEED_CBC_SHA = 155,
    TLS_RSA_WITH_AES_128_GCM_SHA256 = 156,
    TLS_RSA_WITH_AES_256_GCM_SHA384 = 157,
    TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 = 158,
    TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 = 159,
    TLS_DH_RSA_WITH_AES_128_GCM_SHA256 = 160,
    TLS_DH_RSA_WITH_AES_256_GCM_SHA384 = 161,
    TLS_DHE_DSS_WITH_AES_128_GCM_SHA256 = 162,
    TLS_DHE_DSS_WITH_AES_256_GCM_SHA384 = 163,
    TLS_DH_DSS_WITH_AES_128_GCM_SHA256 = 164,
    TLS_DH_DSS_WITH_AES_256_GCM_SHA384 = 165,
    TLS_DH_ANON_WITH_AES_128_GCM_SHA256 = 166,
    TLS_DH_ANON_WITH_AES_256_GCM_SHA384 = 167,
    TLS_PSK_WITH_AES_128_GCM_SHA256 = 168,
    TLS_PSK_WITH_AES_256_GCM_SHA384 = 169,
    TLS_DHE_PSK_WITH_AES_128_GCM_SHA256 = 170,
    TLS_DHE_PSK_WITH_AES_256_GCM_SHA384 = 171,
    TLS_RSA_PSK_WITH_AES_128_GCM_SHA256 = 172,
    TLS_RSA_PSK_WITH_AES_256_GCM_SHA384 = 173,
    TLS_PSK_WITH_AES_128_CBC_SHA256 = 174,
    TLS_PSK_WITH_AES_256_CBC_SHA384 = 175,
    TLS_PSK_WITH_NULL_SHA256 = 176,
    TLS_PSK_WITH_NULL_SHA384 = 177,
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA256 = 178,
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA384 = 179,
    TLS_DHE_PSK_WITH_NULL_SHA256 = 180,
    TLS_DHE_PSK_WITH_NULL_SHA384 = 181,
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA256 = 182,
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA384 = 183,
    TLS_RSA_PSK_WITH_NULL_SHA256 = 184,
    TLS_RSA_PSK_WITH_NULL_SHA384 = 185,
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 186,
    TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 187,
    TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 188,
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 189,
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 190,
    TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA256 = 191,
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 192,
    TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 193,
    TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 194,
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 195,
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 196,
    TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA256 = 197,
    TLS_SM4_GCM_SM3 = 198,
    TLS_SM4_CCM_SM3 = 199,
    TLS_AES_128_GCM_SHA256 = 4865,
    TLS_AES_256_GCM_SHA384 = 4866,
    TLS_CHACHA20_POLY1305_SHA256 = 4867,
    TLS_AES_128_CCM_SHA256 = 4868,
    TLS_AES_128_CCM_8_SHA256 = 4869,
    TLS_AEGIS_256_SHA384 = 4870,
    TLS_AEGIS_128L_SHA256 = 4871,
    TLS_CECPQ1_RSA_WITH_CHACHA20_POLY1305_SHA256 = 5815,
    TLS_CECPQ1_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = 5816,
    TLS_CECPQ1_RSA_WITH_AES_256_GCM_SHA384 = 5817,
    TLS_CECPQ1_ECDSA_WITH_AES_256_GCM_SHA384 = 5818,
    TLS_FALLBACK_SCSV = 22016,
    TLS_ECDH_ECDSA_WITH_NULL_SHA = 49153,
    TLS_ECDH_ECDSA_WITH_RC4_128_SHA = 49154,
    TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA = 49155,
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = 49156,
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = 49157,
    TLS_ECDHE_ECDSA_WITH_NULL_SHA = 49158,
    TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = 49159,
    TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = 49160,
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 49161,
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 49162,
    TLS_ECDH_RSA_WITH_NULL_SHA = 49163,
    TLS_ECDH_RSA_WITH_RC4_128_SHA = 49164,
    TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA = 49165,
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = 49166,
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = 49167,
    TLS_ECDHE_RSA_WITH_NULL_SHA = 49168,
    TLS_ECDHE_RSA_WITH_RC4_128_SHA = 49169,
    TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = 49170,
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = 49171,
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = 49172,
    TLS_ECDH_ANON_WITH_NULL_SHA = 49173,
    TLS_ECDH_ANON_WITH_RC4_128_SHA = 49174,
    TLS_ECDH_ANON_WITH_3DES_EDE_CBC_SHA = 49175,
    TLS_ECDH_ANON_WITH_AES_128_CBC_SHA = 49176,
    TLS_ECDH_ANON_WITH_AES_256_CBC_SHA = 49177,
    TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA = 49178,
    TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = 49179,
    TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = 49180,
    TLS_SRP_SHA_WITH_AES_128_CBC_SHA = 49181,
    TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = 49182,
    TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = 49183,
    TLS_SRP_SHA_WITH_AES_256_CBC_SHA = 49184,
    TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = 49185,
    TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = 49186,
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = 49187,
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = 49188,
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256 = 49189,
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384 = 49190,
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = 49191,
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = 49192,
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256 = 49193,
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384 = 49194,
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 49195,
    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 49196,
    TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = 49197,
    TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = 49198,
    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 49199,
    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 49200,
    TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256 = 49201,
    TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384 = 49202,
    TLS_ECDHE_PSK_WITH_RC4_128_SHA = 49203,
    TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = 49204,
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA = 49205,
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA = 49206,
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = 49207,
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = 49208,
    TLS_ECDHE_PSK_WITH_NULL_SHA = 49209,
    TLS_ECDHE_PSK_WITH_NULL_SHA256 = 49210,
    TLS_ECDHE_PSK_WITH_NULL_SHA384 = 49211,
    TLS_RSA_WITH_ARIA_128_CBC_SHA256 = 49212,
    TLS_RSA_WITH_ARIA_256_CBC_SHA384 = 49213,
    TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256 = 49214,
    TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384 = 49215,
    TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256 = 49216,
    TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384 = 49217,
    TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256 = 49218,
    TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384 = 49219,
    TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256 = 49220,
    TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384 = 49221,
    TLS_DH_ANON_WITH_ARIA_128_CBC_SHA256 = 49222,
    TLS_DH_ANON_WITH_ARIA_256_CBC_SHA384 = 49223,
    TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256 = 49224,
    TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384 = 49225,
    TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256 = 49226,
    TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384 = 49227,
    TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256 = 49228,
    TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384 = 49229,
    TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256 = 49230,
    TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384 = 49231,
    TLS_RSA_WITH_ARIA_128_GCM_SHA256 = 49232,
    TLS_RSA_WITH_ARIA_256_GCM_SHA384 = 49233,
    TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = 49234,
    TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = 49235,
    TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256 = 49236,
    TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384 = 49237,
    TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = 49238,
    TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = 49239,
    TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256 = 49240,
    TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384 = 49241,
    TLS_DH_ANON_WITH_ARIA_128_GCM_SHA256 = 49242,
    TLS_DH_ANON_WITH_ARIA_256_GCM_SHA384 = 49243,
    TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = 49244,
    TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = 49245,
    TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = 49246,
    TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = 49247,
    TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = 49248,
    TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = 49249,
    TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = 49250,
    TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = 49251,
    TLS_PSK_WITH_ARIA_128_CBC_SHA256 = 49252,
    TLS_PSK_WITH_ARIA_256_CBC_SHA384 = 49253,
    TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256 = 49254,
    TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384 = 49255,
    TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256 = 49256,
    TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384 = 49257,
    TLS_PSK_WITH_ARIA_128_GCM_SHA256 = 49258,
    TLS_PSK_WITH_ARIA_256_GCM_SHA384 = 49259,
    TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = 49260,
    TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = 49261,
    TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = 49262,
    TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = 49263,
    TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256 = 49264,
    TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384 = 49265,
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 49266,
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 49267,
    TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 49268,
    TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 49269,
    TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 49270,
    TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 49271,
    TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 49272,
    TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 49273,
    TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49274,
    TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49275,
    TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49276,
    TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49277,
    TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49278,
    TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49279,
    TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256 = 49280,
    TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384 = 49281,
    TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256 = 49282,
    TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384 = 49283,
    TLS_DH_ANON_WITH_CAMELLIA_128_GCM_SHA256 = 49284,
    TLS_DH_ANON_WITH_CAMELLIA_256_GCM_SHA384 = 49285,
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256 = 49286,
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384 = 49287,
    TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256 = 49288,
    TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384 = 49289,
    TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49290,
    TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49291,
    TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49292,
    TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49293,
    TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 49294,
    TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 49295,
    TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 49296,
    TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 49297,
    TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 49298,
    TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 49299,
    TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49300,
    TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49301,
    TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49302,
    TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49303,
    TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49304,
    TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49305,
    TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49306,
    TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49307,
    TLS_RSA_WITH_AES_128_CCM = 49308,
    TLS_RSA_WITH_AES_256_CCM = 49309,
    TLS_DHE_RSA_WITH_AES_128_CCM = 49310,
    TLS_DHE_RSA_WITH_AES_256_CCM = 49311,
    TLS_RSA_WITH_AES_128_CCM_8 = 49312,
    TLS_RSA_WITH_AES_256_CCM_8 = 49313,
    TLS_DHE_RSA_WITH_AES_128_CCM_8 = 49314,
    TLS_DHE_RSA_WITH_AES_256_CCM_8 = 49315,
    TLS_PSK_WITH_AES_128_CCM = 49316,
    TLS_PSK_WITH_AES_256_CCM = 49317,
    TLS_DHE_PSK_WITH_AES_128_CCM = 49318,
    TLS_DHE_PSK_WITH_AES_256_CCM = 49319,
    TLS_PSK_WITH_AES_128_CCM_8 = 49320,
    TLS_PSK_WITH_AES_256_CCM_8 = 49321,
    TLS_PSK_DHE_WITH_AES_128_CCM_8 = 49322,
    TLS_PSK_DHE_WITH_AES_256_CCM_8 = 49323,
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM = 49324,
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM = 49325,
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8 = 49326,
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8 = 49327,
    TLS_ECCPWD_WITH_AES_128_GCM_SHA256 = 49328,
    TLS_ECCPWD_WITH_AES_256_GCM_SHA384 = 49329,
    TLS_ECCPWD_WITH_AES_128_CCM_SHA256 = 49330,
    TLS_ECCPWD_WITH_AES_256_CCM_SHA384 = 49331,
    TLS_SHA256_SHA256 = 49332,
    TLS_SHA384_SHA384 = 49333,
    TLS_GOSTR341112_256_WITH_KUZNYECHIK_CTR_OMAC = 49408,
    TLS_GOSTR341112_256_WITH_MAGMA_CTR_OMAC = 49409,
    TLS_GOSTR341112_256_WITH_28147_CNT_IMIT = 49410,
    TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_L = 49411,
    TLS_GOSTR341112_256_WITH_MAGMA_MGM_L = 49412,
    TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_S = 49413,
    TLS_GOSTR341112_256_WITH_MAGMA_MGM_S = 49414,
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256_OLD = 52243,
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256_OLD = 52244,
    TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256_OLD = 52245,
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 52392,
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = 52393,
    TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 52394,
    TLS_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52395,
    TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52396,
    TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52397,
    TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52398,
    TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256_OLD = 53252,
    TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256 = 53249,
    TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384 = 53250,
    TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256 = 53251,
    TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256 = 53253,
    SSL_RSA_FIPS_WITH_DES_CBC_SHA = 65278,
    SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA = 65279,
    SSL_RSA_FIPS_WITH_DES_CBC_SHA_2 = 65505,
    SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA_2 = 65504,
    SSL_RSA_WITH_RC2_CBC_MD5 = 65408,
    SSL_RSA_WITH_IDEA_CBC_MD5 = 65409,
    SSL_RSA_WITH_DES_CBC_MD5 = 65410,
    SSL_RSA_WITH_3DES_EDE_CBC_MD5 = 65411,
    TLS_EMPTY_RENEGOTIATION_INFO_SCSV = 255,
};
// NOLINTNEXTLINE(performance-enum-size)
enum HandshakeType {
    HELLO_REQUEST = 0,
    CLIENT_HELLO = 1,
    SERVER_HELLO = 2,
    HELLO_VERIFY_REQUEST = 3,
    SESSION_TICKET = 4,
    CERTIFICATE = 11,
    SERVER_KEY_EXCHANGE = 12,
    CERTIFICATE_REQUEST = 13,
    SERVER_HELLO_DONE = 14,
    CERTIFICATE_VERIFY = 15,
    CLIENT_KEY_EXCHANGE = 16,
    FINISHED = 20,
    CERTIFICATE_URL = 21,
    CERTIFICATE_STATUS = 22,
};
class HandshakeRecord;
class Handshake;
class HandshakePDU;
class UnknownHandshake;
class HelloRequest;
class ClientHello;
class ClientHelloCookie;
class ServerHelloChoice;
class ServerHello;
class ServerHello13;
class DirectionCheck;
class HelloVerifyRequest;
class X509Certificate;
class Certificate;
class CertificateStatus;
class ServerKeyExchange;
class EcdheServerKeyExchange;
class ServerKeyExchangeSignature;
class EcdhAnonServerKeyExchange;
class ServerECDHParamsAndSignature;
class DheServerKeyExchange;
class DhAnonServerKeyExchange;
class CertificateAuthorities;
class CertificateAuthoritiesContainer;
class CertificateRequest;
class ServerHelloDone;
class ClientKeyExchange;
class RsaClientKeyExchange;
class DhClientKeyExchange;
class EcdhClientKeyExchange;
class CertificateVerify;
class Finished;
class SessionTicketHandshake;
class SSLExtension;
class SignatureAndHashAlgorithm;
class SignedCertificateTimestampList;
class SignedCertificateTimestamp;
class ConnectionId;
class SupportedVersionsSelector;
class SupportedVersions;
class OneSupportedVersion;
class PSKKeyExchangeModes;
class ServerNameHostName;
class ServerName;
class ServerNameExt;
class EcPointFormats;
class KeyShareEntry;
class ServerHelloKeyShare;
class HelloRetryRequestKeyShare;
class ServerHelloKeyShareChoice;
class ClientHelloKeyShare;
class KeyShare;
class SelectedPreSharedKeyIdentity;
class PSKIdentity;
class PSKIdentitiesList;
class PSKBinder;
class PSKBindersList;
class OfferedPsks;
class PreSharedKey;
class SignatureAlgorithm;
class EllipticCurves;
class ProtocolName;
class ApplicationLayerProtocolNegotiationExtension;
class Handshake_Flow;
} // namespace TLSHandshake

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace TLSHandshake {

class ContextTLSHandshake final {
public:
    ContextTLSHandshake(Handshake_Conn* connection, Handshake_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextTLSHandshake();

    // Member access functions
    Handshake_Conn* connection() const { return connection_; }
    Handshake_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    Handshake_Conn* connection_;
    Handshake_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class Handshake_Conn final : public binpac::ConnectionAnalyzer {
public:
    Handshake_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~Handshake_Conn() override;

    // Member access functions
    Handshake_Flow* upflow() const { return upflow_; }
    Handshake_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    int chosen_cipher();
    bool set_cipher(uint32 cipher);
    uint16 chosen_version();
    bool set_version(uint16 version);
    bool check_flipped(bool desired, bool is_orig);
    bool flipped();
    uint16 record_version();
    bool set_record_version(uint16 version);
    bytestring client_random();
    bool set_client_random(bytestring const& client_random);
    bytestring server_random();
    bool set_server_random(bytestring const& server_random);
    uint32 gmt_unix_time();
    bool set_gmt_unix_time(uint32 ts);
    bool proc_certificate(bool is_orig, bool is_flipped, vector<bytestring>* certificates);
    bool proc_client_hello(uint16 version, double ts, bytestring const& client_random, vector<uint8>* session_id, vector<uint16>* cipher_suites16, vector<uint24*>* cipher_suites24, vector<uint8>* compression_methods);
    bool proc_server_hello(uint16 version, bool v2, bytestring const& server_random, vector<uint8>* session_id, vector<uint16>* cipher_suites16, vector<uint24*>* cipher_suites24, uint8 comp_method);
    bool proc_session_ticket_handshake(SessionTicketHandshake* rec, bool is_orig);
    bool proc_ssl_extension(HandshakeRecord* rec, int type, const_bytestring const& sourcedata);
    bool proc_ec_point_formats(HandshakeRecord* rec, vector<uint8>* point_format_list);
    bool proc_elliptic_curves(HandshakeRecord* rec, vector<uint16>* list);
    bool proc_client_key_share(HandshakeRecord* rec, vector<KeyShareEntry*>* keyshare);
    bool proc_server_key_share(HandshakeRecord* rec, KeyShareEntry* keyshare);
    bool proc_hello_retry_request_key_share(HandshakeRecord* rec, uint16 namedgroup);
    bool proc_signature_algorithm(HandshakeRecord* rec, vector<SignatureAndHashAlgorithm*>* supported_signature_algorithms);
    bool proc_apnl(HandshakeRecord* rec, vector<ProtocolName*>* protocols);
    bool proc_server_name(HandshakeRecord* rec, vector<ServerName*>* list);
    bool proc_supported_versions(HandshakeRecord* rec, vector<uint16>* versions_list);
    bool proc_one_supported_version(HandshakeRecord* rec, uint16 version);
    bool proc_psk_key_exchange_modes(HandshakeRecord* rec, vector<uint8>* mode_list);
    bool proc_v3_certificate(bool is_orig, vector<X509Certificate*>* cl);
    bool proc_unknown_handshake(HandshakeRecord* hs, bool is_orig);
    bool proc_certificate_status(HandshakeRecord* rec, uint8 status_type, bytestring const& response);
    bool proc_ecdhe_server_key_exchange(EcdheServerKeyExchange* kex);
    bool proc_ecdh_anon_server_key_exchange(EcdhAnonServerKeyExchange* kex);
    bool proc_rsa_client_key_exchange(HandshakeRecord* rec, bytestring const& rsa_pms);
    bool proc_dh_client_key_exchange(HandshakeRecord* rec, bytestring const& Yc);
    bool proc_ecdh_client_key_exchange(HandshakeRecord* rec, bytestring const& point);
    bool proc_signedcertificatetimestamp(HandshakeRecord* rec, uint8 version, const_bytestring const& logid, uint64 timestamp, SignatureAndHashAlgorithm* digitally_signed_algorithms, const_bytestring const& digitally_signed_signature);
    bool proc_dhe_server_key_exchange(HandshakeRecord* rec, bytestring const& p, bytestring const& g, bytestring const& Ys, ServerKeyExchangeSignature* signed_params);
    bool proc_dh_anon_server_key_exchange(HandshakeRecord* rec, bytestring const& p, bytestring const& g, bytestring const& Ys);
    bool proc_handshake(bool is_orig, uint8 msg_type, uint24* length);
    bool proc_pre_shared_key_server_hello(HandshakeRecord* rec, PSKIdentitiesList* identities, PSKBindersList* binders);
    bool proc_pre_shared_key_client_hello(HandshakeRecord* rec, uint16 selected_identity);
    bool proc_certificate_request(HandshakeRecord* rec, CertificateRequest* req);
    bool proc_connection_id(HandshakeRecord* rec, bytestring const& cid);

protected:

    // Additional members

		uint32 chosen_cipher_;
		uint16 chosen_version_;
		uint16 record_version_;
		bytestring client_random_;
		bytestring server_random_;
		uint32 gmt_unix_time_;
		bool flipped_;
		bool already_alerted_;
	
    Handshake_Flow* upflow_;
    Handshake_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class uint24 final {
public:
    uint24();
    ~uint24();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 byte1() const { return byte1_; }
    uint8 byte2() const { return byte2_; }
    uint8 byte3() const { return byte3_; }

protected:
    uint8 byte1_;
    uint8 byte2_;
    uint8 byte3_;
};


class uint48 final {
public:
    uint48();
    ~uint48();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 byte1() const { return byte1_; }
    uint8 byte2() const { return byte2_; }
    uint8 byte3() const { return byte3_; }
    uint8 byte4() const { return byte4_; }
    uint8 byte5() const { return byte5_; }
    uint8 byte6() const { return byte6_; }

protected:
    uint8 byte1_;
    uint8 byte2_;
    uint8 byte3_;
    uint8 byte4_;
    uint8 byte5_;
    uint8 byte6_;
};


	string orig_label(bool is_orig);
	

	class to_int {
	public:
		int operator()(uint24 * num) const
		{
		return (num->byte1() << 16) | (num->byte2() << 8) | num->byte3();
		}

		uint64 operator()(uint48 * num) const
		{
		return ((uint64)num->byte1() << 40) | ((uint64)num->byte2() << 32) | ((uint64)num->byte3() << 24) |
		  ((uint64)num->byte4() << 16) | ((uint64)num->byte5() << 8) | (uint64)num->byte6();
		}
	};

zeek::StringVal* to_string_val(vector<uint8>* data);
bool version_ok(uint16 vers);
extern uint32 const MAX_DTLS_HANDSHAKE_RECORD;

class HandshakeRecord final {
public:
    HandshakeRecord(bool is_orig);
    ~HandshakeRecord();
    int initial_buffer_length() const { return 4; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint8 msg_type() const { return msg_type_; }
    uint24* msg_length() const { return msg_length_; }
    Handshake* rec() const { return rec_; }
    bool is_orig() const { return is_orig_; }

protected:
    uint8 msg_type_;
    uint24* msg_length_;
    Handshake* rec_;
    bool is_orig_;
    int buffering_state_;
};


class Handshake final {
public:
    Handshake(HandshakeRecord* rec);
    ~Handshake();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    HelloRequest* hello_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:34:hello_request", (int64)val_case_index(), "HELLO_REQUEST");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return hello_request_;
    }
    ClientHello* client_hello() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:35:client_hello", (int64)val_case_index(), "CLIENT_HELLO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_hello_;
    }
    ServerHelloChoice* server_hello() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:36:server_hello", (int64)val_case_index(), "SERVER_HELLO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_hello_;
    }
    HelloVerifyRequest* hello_verify_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:37:hello_verify_request", (int64)val_case_index(), "HELLO_VERIFY_REQUEST");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return hello_verify_request_;
    }
    SessionTicketHandshake* session_ticket() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:38:session_ticket", (int64)val_case_index(), "SESSION_TICKET");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return session_ticket_;
    }
    Certificate* certificate() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:39:certificate", (int64)val_case_index(), "CERTIFICATE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return certificate_;
    }
    ServerKeyExchange* server_key_exchange() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)12):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:40:server_key_exchange", (int64)val_case_index(), "SERVER_KEY_EXCHANGE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_key_exchange_;
    }
    CertificateRequest* certificate_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)13):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:41:certificate_request", (int64)val_case_index(), "CERTIFICATE_REQUEST");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return certificate_request_;
    }
    ServerHelloDone* server_hello_done() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)14):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:42:server_hello_done", (int64)val_case_index(), "SERVER_HELLO_DONE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_hello_done_;
    }
    CertificateVerify* certificate_verify() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:43:certificate_verify", (int64)val_case_index(), "CERTIFICATE_VERIFY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return certificate_verify_;
    }
    ClientKeyExchange* client_key_exchange() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:44:client_key_exchange", (int64)val_case_index(), "CLIENT_KEY_EXCHANGE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_key_exchange_;
    }
    Finished* finished() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)20):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:45:finished", (int64)val_case_index(), "FINISHED");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return finished_;
    }
    CertificateStatus* certificate_status() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)22):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:47:certificate_status", (int64)val_case_index(), "CERTIFICATE_STATUS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return certificate_status_;
    }
    UnknownHandshake* unknown_handshake() const {
        return unknown_handshake_;
    }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint8 val_case_index_;
    HelloRequest* hello_request_;
    ClientHello* client_hello_;
    ServerHelloChoice* server_hello_;
    HelloVerifyRequest* hello_verify_request_;
    SessionTicketHandshake* session_ticket_;
    Certificate* certificate_;
    ServerKeyExchange* server_key_exchange_;
    CertificateRequest* certificate_request_;
    ServerHelloDone* server_hello_done_;
    CertificateVerify* certificate_verify_;
    ClientKeyExchange* client_key_exchange_;
    Finished* finished_;
    const_bytestring certificate_url_;
    CertificateStatus* certificate_status_;
    UnknownHandshake* unknown_handshake_;
    HandshakeRecord* rec_;
    bool proc_;
};


class HandshakePDU final {
public:
    HandshakePDU(bool is_orig);
    ~HandshakePDU();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextTLSHandshake* t_context);

    // Member access functions
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    vector<HandshakeRecord*>* records_;
    HandshakeRecord* records__elem_;
    int records__arraylength_;
    int records__elem__it_;
    bool is_orig_;
    int byteorder_;
    int parsing_state_;
};


class UnknownHandshake final {
public:
    UnknownHandshake(HandshakeRecord* hs, bool is_orig);
    ~UnknownHandshake();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    HandshakeRecord* hs() const { return hs_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    const_bytestring data_;
    HandshakeRecord* hs_;
    bool is_orig_;
    bool proc_;
};


class HelloRequest final {
public:
    HelloRequest(HandshakeRecord* rec);
    ~HelloRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    DirectionCheck* direction_check() const { return direction_check_; }
    HandshakeRecord* rec() const { return rec_; }

protected:
    DirectionCheck* direction_check_;
    HandshakeRecord* rec_;
};


class ClientHello final {
public:
    ClientHello(HandshakeRecord* rec);
    ~ClientHello();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    DirectionCheck* direction_check() const { return direction_check_; }
    uint16 client_version() const { return client_version_; }
    uint32 gmt_unix_time() const { return gmt_unix_time_; }
    bytestring const& random_bytes() const { return random_bytes_; }
    uint8 session_len() const { return session_len_; }
    vector<uint8>* session_id() const { return session_id_; }
    uint16 dtls_cookie_case_index() const	{ return dtls_cookie_case_index_; }
    ClientHelloCookie* cookie() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( dtls_cookie_case_index() ) {
            case ((uint16)65279):
            case ((uint16)65277):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:81:cookie", (int64)dtls_cookie_case_index(), "DTLSv10, DTLSv12");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return cookie_;
    }
    bytestring const& nothing() const {
        return nothing_;
    }
    uint16 csuit_len() const { return csuit_len_; }
    vector<uint16>* csuits() const { return csuits_; }
    uint8 cmeth_len() const { return cmeth_len_; }
    vector<uint8>* cmeths() const { return cmeths_; }
    vector<uint16>* ext_len() const { return ext_len_; }
    vector<SSLExtension*>* extensions() const { return extensions_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    DirectionCheck* direction_check_;
    uint16 client_version_;
    uint32 gmt_unix_time_;
    bytestring random_bytes_;
    uint8 session_len_;
    vector<uint8>* session_id_;
    uint8 session_id__elem_;
    uint16 dtls_cookie_case_index_;
    ClientHelloCookie* cookie_;
    bytestring nothing_;
    uint16 csuit_len_;
    vector<uint16>* csuits_;
    uint16 csuits__elem_;
    uint8 cmeth_len_;
    vector<uint8>* cmeths_;
    uint8 cmeths__elem_;
    vector<uint16>* ext_len_;
    uint16 ext_len__elem_;
    vector<SSLExtension*>* extensions_;
    SSLExtension* extensions__elem_;
    HandshakeRecord* rec_;
    bool proc_;
};


class ClientHelloCookie final {
public:
    ClientHelloCookie(HandshakeRecord* rec);
    ~ClientHelloCookie();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    uint8 cookie_len() const { return cookie_len_; }
    bytestring const& cookie() const { return cookie_; }
    HandshakeRecord* rec() const { return rec_; }

protected:
    uint8 cookie_len_;
    bytestring cookie_;
    HandshakeRecord* rec_;
};


class ServerHelloChoice final {
public:
    ServerHelloChoice(HandshakeRecord* rec);
    ~ServerHelloChoice();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    DirectionCheck* direction_check() const { return direction_check_; }
    uint8 server_version0() const { return server_version0_; }
    uint8 server_version1() const { return server_version1_; }
    uint16 hello_case_index() const	{ return hello_case_index_; }
    ServerHello13* hello13() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( hello_case_index() ) {
            case ((uint16)772):
            case ((uint16)32512):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:110:hello13", (int64)hello_case_index(), "TLSv13, TLSv13_draft");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return hello13_;
    }
    ServerHello* helloclassic() const {
        return helloclassic_;
    }
    HandshakeRecord* rec() const { return rec_; }
    uint16 server_version() const { return server_version_; }
    uint16 parsed_version() const { return parsed_version_; }
    bool version_set() const { return version_set_; }

protected:
    DirectionCheck* direction_check_;
    uint8 server_version0_;
    uint8 server_version1_;
    uint16 hello_case_index_;
    ServerHello13* hello13_;
    ServerHello* helloclassic_;
    HandshakeRecord* rec_;
    uint16 server_version_;
    uint16 parsed_version_;
    bool version_set_;
};


class ServerHello final {
public:
    ServerHello(HandshakeRecord* rec, uint16 server_version);
    ~ServerHello();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    bytestring const& random_bytes() const { return random_bytes_; }
    uint8 session_len() const { return session_len_; }
    vector<uint8>* session_id() const { return session_id_; }
    vector<uint16>* cipher_suite() const { return cipher_suite_; }
    uint8 compression_method() const { return compression_method_; }
    vector<uint16>* ext_len() const { return ext_len_; }
    vector<SSLExtension*>* extensions() const { return extensions_; }
    HandshakeRecord* rec() const { return rec_; }
    uint16 server_version() const { return server_version_; }
    bool cipher_set() const { return cipher_set_; }
    bool proc() const { return proc_; }

protected:
    bytestring random_bytes_;
    uint8 session_len_;
    vector<uint8>* session_id_;
    uint8 session_id__elem_;
    vector<uint16>* cipher_suite_;
    uint16 cipher_suite__elem_;
    uint8 compression_method_;
    vector<uint16>* ext_len_;
    uint16 ext_len__elem_;
    vector<SSLExtension*>* extensions_;
    SSLExtension* extensions__elem_;
    HandshakeRecord* rec_;
    uint16 server_version_;
    bool cipher_set_;
    bool proc_;
};


class ServerHello13 final {
public:
    ServerHello13(HandshakeRecord* rec, uint16 server_version);
    ~ServerHello13();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    bytestring const& random() const { return random_; }
    vector<uint16>* cipher_suite() const { return cipher_suite_; }
    vector<uint16>* ext_len() const { return ext_len_; }
    vector<SSLExtension*>* extensions() const { return extensions_; }
    HandshakeRecord* rec() const { return rec_; }
    uint16 server_version() const { return server_version_; }
    bool cipher_set() const { return cipher_set_; }
    bool proc() const { return proc_; }

protected:
    bytestring random_;
    vector<uint16>* cipher_suite_;
    uint16 cipher_suite__elem_;
    vector<uint16>* ext_len_;
    uint16 ext_len__elem_;
    vector<SSLExtension*>* extensions_;
    SSLExtension* extensions__elem_;
    HandshakeRecord* rec_;
    uint16 server_version_;
    bool cipher_set_;
    bool proc_;
};


class DirectionCheck final {
public:
    DirectionCheck(bool desired, HandshakeRecord* rec);
    ~DirectionCheck();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    bool desired() const { return desired_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    bool desired_;
    HandshakeRecord* rec_;
    bool proc_;
};


class HelloVerifyRequest final {
public:
    HelloVerifyRequest(HandshakeRecord* rec);
    ~HelloVerifyRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 version() const { return version_; }
    uint8 cookie_length() const { return cookie_length_; }
    bytestring const& cookie() const { return cookie_; }
    HandshakeRecord* rec() const { return rec_; }

protected:
    uint16 version_;
    uint8 cookie_length_;
    bytestring cookie_;
    HandshakeRecord* rec_;
};


class X509Certificate final {
public:
    X509Certificate();
    ~X509Certificate();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint24* length() const { return length_; }
    bytestring const& certificate() const { return certificate_; }

protected:
    uint24* length_;
    bytestring certificate_;
};


class Certificate final {
public:
    Certificate(HandshakeRecord* rec);
    ~Certificate();
    int initial_buffer_length() const { return 3; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    uint24* length() const { return length_; }
    vector<X509Certificate*>* certificates() const { return certificates_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint24* length_;
    vector<X509Certificate*>* certificates_;
    X509Certificate* certificates__elem_;
    HandshakeRecord* rec_;
    bool proc_;
};


class CertificateStatus final {
public:
    CertificateStatus(HandshakeRecord* rec);
    ~CertificateStatus();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    uint8 status_type() const { return status_type_; }
    uint24* length() const { return length_; }
    bytestring const& response() const { return response_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint8 status_type_;
    uint24* length_;
    bytestring response_;
    HandshakeRecord* rec_;
    bool proc_;
};


class ServerKeyExchange final {
public:
    ServerKeyExchange(HandshakeRecord* rec);
    ~ServerKeyExchange();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    EcdheServerKeyExchange* ecdhe_server_key_exchange() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)49158):
            case ((int)49159):
            case ((int)49160):
            case ((int)49161):
            case ((int)49162):
            case ((int)49168):
            case ((int)49169):
            case ((int)49170):
            case ((int)49171):
            case ((int)49172):
            case ((int)49187):
            case ((int)49188):
            case ((int)49191):
            case ((int)49192):
            case ((int)49195):
            case ((int)49196):
            case ((int)49199):
            case ((int)49200):
            case ((int)49203):
            case ((int)49204):
            case ((int)49205):
            case ((int)49206):
            case ((int)49207):
            case ((int)49208):
            case ((int)49209):
            case ((int)49210):
            case ((int)49211):
            case ((int)49224):
            case ((int)49225):
            case ((int)49228):
            case ((int)49229):
            case ((int)49244):
            case ((int)49245):
            case ((int)49248):
            case ((int)49249):
            case ((int)49264):
            case ((int)49265):
            case ((int)49266):
            case ((int)49267):
            case ((int)49270):
            case ((int)49271):
            case ((int)49286):
            case ((int)49287):
            case ((int)49290):
            case ((int)49291):
            case ((int)49306):
            case ((int)49307):
            case ((int)49324):
            case ((int)49325):
            case ((int)49326):
            case ((int)49327):
            case ((int)52243):
            case ((int)52244):
            case ((int)52392):
            case ((int)52393):
            case ((int)53249):
            case ((int)53250):
            case ((int)53251):
            case ((int)53253):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:255:ecdhe_server_key_exchange", (int64)val_case_index(), "TLS_ECDHE_ECDSA_WITH_NULL_SHA, TLS_ECDHE_ECDSA_WITH_RC4_128_SHA, TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_NULL_SHA, TLS_ECDHE_RSA_WITH_RC4_128_SHA, TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, TLS_ECDHE_PSK_WITH_RC4_128_SHA, TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA, TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, TLS_ECDHE_PSK_WITH_NULL_SHA, TLS_ECDHE_PSK_WITH_NULL_SHA256, TLS_ECDHE_PSK_WITH_NULL_SHA384, TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256, TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256, TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384, TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256, TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384, TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, TLS_ECDHE_ECDSA_WITH_AES_128_CCM, TLS_ECDHE_ECDSA_WITH_AES_256_CCM, TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256_OLD, TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256_OLD, TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256, TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384, TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256, TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ecdhe_server_key_exchange_;
    }
    EcdhAnonServerKeyExchange* ecdh_anon_server_key_exchange() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)49173):
            case ((int)49174):
            case ((int)49175):
            case ((int)49176):
            case ((int)49177):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:264:ecdh_anon_server_key_exchange", (int64)val_case_index(), "TLS_ECDH_ANON_WITH_NULL_SHA, TLS_ECDH_ANON_WITH_RC4_128_SHA, TLS_ECDH_ANON_WITH_3DES_EDE_CBC_SHA, TLS_ECDH_ANON_WITH_AES_128_CBC_SHA, TLS_ECDH_ANON_WITH_AES_256_CBC_SHA");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ecdh_anon_server_key_exchange_;
    }
    DheServerKeyExchange* dhe_server_key_exchange() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)17):
            case ((int)18):
            case ((int)19):
            case ((int)20):
            case ((int)21):
            case ((int)22):
            case ((int)50):
            case ((int)51):
            case ((int)56):
            case ((int)57):
            case ((int)64):
            case ((int)68):
            case ((int)69):
            case ((int)99):
            case ((int)101):
            case ((int)102):
            case ((int)103):
            case ((int)106):
            case ((int)107):
            case ((int)114):
            case ((int)115):
            case ((int)116):
            case ((int)119):
            case ((int)120):
            case ((int)121):
            case ((int)135):
            case ((int)136):
            case ((int)142):
            case ((int)143):
            case ((int)144):
            case ((int)145):
            case ((int)153):
            case ((int)154):
            case ((int)158):
            case ((int)159):
            case ((int)162):
            case ((int)163):
            case ((int)170):
            case ((int)171):
            case ((int)178):
            case ((int)179):
            case ((int)180):
            case ((int)181):
            case ((int)189):
            case ((int)190):
            case ((int)195):
            case ((int)196):
            case ((int)49218):
            case ((int)49219):
            case ((int)49220):
            case ((int)49221):
            case ((int)49234):
            case ((int)49235):
            case ((int)49238):
            case ((int)49239):
            case ((int)49254):
            case ((int)49255):
            case ((int)49260):
            case ((int)49261):
            case ((int)49276):
            case ((int)49277):
            case ((int)49280):
            case ((int)49281):
            case ((int)49296):
            case ((int)49297):
            case ((int)49302):
            case ((int)49303):
            case ((int)49310):
            case ((int)49311):
            case ((int)49314):
            case ((int)49315):
            case ((int)49318):
            case ((int)49319):
            case ((int)49322):
            case ((int)49323):
            case ((int)52245):
            case ((int)52394):
            case ((int)52397):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:345:dhe_server_key_exchange", (int64)val_case_index(), "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_DSS_WITH_DES_CBC_SHA, TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA, TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_RSA_WITH_DES_CBC_SHA, TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DHE_DSS_WITH_AES_128_CBC_SHA, TLS_DHE_RSA_WITH_AES_128_CBC_SHA, TLS_DHE_DSS_WITH_AES_256_CBC_SHA, TLS_DHE_RSA_WITH_AES_256_CBC_SHA, TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA, TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA, TLS_DHE_DSS_WITH_RC4_128_SHA, TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, TLS_DHE_DSS_WITH_3DES_EDE_CBC_RMD, TLS_DHE_DSS_WITH_AES_128_CBC_RMD, TLS_DHE_DSS_WITH_AES_256_CBC_RMD, TLS_DHE_RSA_WITH_3DES_EDE_CBC_RMD, TLS_DHE_RSA_WITH_AES_128_CBC_RMD, TLS_DHE_RSA_WITH_AES_256_CBC_RMD, TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, TLS_DHE_PSK_WITH_RC4_128_SHA, TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA, TLS_DHE_PSK_WITH_AES_128_CBC_SHA, TLS_DHE_PSK_WITH_AES_256_CBC_SHA, TLS_DHE_DSS_WITH_SEED_CBC_SHA, TLS_DHE_RSA_WITH_SEED_CBC_SHA, TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, TLS_DHE_PSK_WITH_NULL_SHA256, TLS_DHE_PSK_WITH_NULL_SHA384, TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256, TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384, TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256, TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384, TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256, TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384, TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256, TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384, TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256, TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384, TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, TLS_DHE_RSA_WITH_AES_128_CCM, TLS_DHE_RSA_WITH_AES_256_CCM, TLS_DHE_RSA_WITH_AES_128_CCM_8, TLS_DHE_RSA_WITH_AES_256_CCM_8, TLS_DHE_PSK_WITH_AES_128_CCM, TLS_DHE_PSK_WITH_AES_256_CCM, TLS_PSK_DHE_WITH_AES_128_CCM_8, TLS_PSK_DHE_WITH_AES_256_CCM_8, TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256_OLD, TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return dhe_server_key_exchange_;
    }
    DhAnonServerKeyExchange* dh_anon_server_key_exchange() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)23):
            case ((int)24):
            case ((int)25):
            case ((int)26):
            case ((int)27):
            case ((int)52):
            case ((int)58):
            case ((int)70):
            case ((int)108):
            case ((int)109):
            case ((int)137):
            case ((int)155):
            case ((int)166):
            case ((int)167):
            case ((int)191):
            case ((int)197):
            case ((int)49222):
            case ((int)49223):
            case ((int)49242):
            case ((int)49243):
            case ((int)49284):
            case ((int)49285):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:371:dh_anon_server_key_exchange", (int64)val_case_index(), "TLS_DH_ANON_EXPORT_WITH_RC4_40_MD5, TLS_DH_ANON_WITH_RC4_128_MD5, TLS_DH_ANON_EXPORT_WITH_DES40_CBC_SHA, TLS_DH_ANON_WITH_DES_CBC_SHA, TLS_DH_ANON_WITH_3DES_EDE_CBC_SHA, TLS_DH_ANON_WITH_AES_128_CBC_SHA, TLS_DH_ANON_WITH_AES_256_CBC_SHA, TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA, TLS_DH_ANON_WITH_AES_128_CBC_SHA256, TLS_DH_ANON_WITH_AES_256_CBC_SHA256, TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA, TLS_DH_ANON_WITH_SEED_CBC_SHA, TLS_DH_ANON_WITH_AES_128_GCM_SHA256, TLS_DH_ANON_WITH_AES_256_GCM_SHA384, TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA256, TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA256, TLS_DH_ANON_WITH_ARIA_128_CBC_SHA256, TLS_DH_ANON_WITH_ARIA_256_CBC_SHA384, TLS_DH_ANON_WITH_ARIA_128_GCM_SHA256, TLS_DH_ANON_WITH_ARIA_256_GCM_SHA384, TLS_DH_ANON_WITH_CAMELLIA_128_GCM_SHA256, TLS_DH_ANON_WITH_CAMELLIA_256_GCM_SHA384");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return dh_anon_server_key_exchange_;
    }
    HandshakeRecord* rec() const { return rec_; }

protected:
    int val_case_index_;
    EcdheServerKeyExchange* ecdhe_server_key_exchange_;
    EcdhAnonServerKeyExchange* ecdh_anon_server_key_exchange_;
    DheServerKeyExchange* dhe_server_key_exchange_;
    DhAnonServerKeyExchange* dh_anon_server_key_exchange_;
    const_bytestring key_;
    HandshakeRecord* rec_;
};


class EcdheServerKeyExchange final {
public:
    EcdheServerKeyExchange(HandshakeRecord* rec);
    ~EcdheServerKeyExchange();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint8 curve_type() const { return curve_type_; }
    uint8 named_curve_case_index() const	{ return named_curve_case_index_; }
    ServerECDHParamsAndSignature* params() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( named_curve_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:383:params", (int64)named_curve_case_index(), "NAMED_CURVE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return params_;
    }
    uint8 signature_case_index() const	{ return signature_case_index_; }
    ServerKeyExchangeSignature* signed_params() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( signature_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:387:signed_params", (int64)signature_case_index(), "NAMED_CURVE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return signed_params_;
    }
    bytestring const& nothing() const {
        return nothing_;
    }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint8 curve_type_;
    uint8 named_curve_case_index_;
    ServerECDHParamsAndSignature* params_;
    const_bytestring data_;
    uint8 signature_case_index_;
    ServerKeyExchangeSignature* signed_params_;
    bytestring nothing_;
    HandshakeRecord* rec_;
    bool proc_;
};


class ServerKeyExchangeSignature final {
public:
    ServerKeyExchangeSignature();
    ~ServerKeyExchangeSignature();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    int alg_case_index() const	{ return alg_case_index_; }
    SignatureAndHashAlgorithm* algorithm() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( alg_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:394:algorithm", (int64)alg_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return algorithm_;
    }
    bytestring const& nothing() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( alg_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:395:nothing", (int64)alg_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nothing_;
    }
    uint16 signature_length() const { return signature_length_; }
    bytestring const& signature() const { return signature_; }
    bool uses_signature_and_hashalgorithm() const { return uses_signature_and_hashalgorithm_; }

protected:
    int alg_case_index_;
    SignatureAndHashAlgorithm* algorithm_;
    bytestring nothing_;
    uint16 signature_length_;
    bytestring signature_;
    bool uses_signature_and_hashalgorithm_;
};


class EcdhAnonServerKeyExchange final {
public:
    EcdhAnonServerKeyExchange(HandshakeRecord* rec);
    ~EcdhAnonServerKeyExchange();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint8 curve_type() const { return curve_type_; }
    uint8 named_curve_case_index() const	{ return named_curve_case_index_; }
    ServerECDHParamsAndSignature* params() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( named_curve_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:411:params", (int64)named_curve_case_index(), "NAMED_CURVE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return params_;
    }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint8 curve_type_;
    uint8 named_curve_case_index_;
    ServerECDHParamsAndSignature* params_;
    const_bytestring data_;
    HandshakeRecord* rec_;
    bool proc_;
};


class ServerECDHParamsAndSignature final {
public:
    ServerECDHParamsAndSignature();
    ~ServerECDHParamsAndSignature();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 curve() const { return curve_; }
    uint8 point_length() const { return point_length_; }
    bytestring const& point() const { return point_; }

protected:
    uint16 curve_;
    uint8 point_length_;
    bytestring point_;
};


class DheServerKeyExchange final {
public:
    DheServerKeyExchange(HandshakeRecord* rec);
    ~DheServerKeyExchange();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 dh_p_length() const { return dh_p_length_; }
    bytestring const& dh_p() const { return dh_p_; }
    uint16 dh_g_length() const { return dh_g_length_; }
    bytestring const& dh_g() const { return dh_g_; }
    uint16 dh_Ys_length() const { return dh_Ys_length_; }
    bytestring const& dh_Ys() const { return dh_Ys_; }
    ServerKeyExchangeSignature* signed_params() const { return signed_params_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint16 dh_p_length_;
    bytestring dh_p_;
    uint16 dh_g_length_;
    bytestring dh_g_;
    uint16 dh_Ys_length_;
    bytestring dh_Ys_;
    ServerKeyExchangeSignature* signed_params_;
    HandshakeRecord* rec_;
    bool proc_;
};


class DhAnonServerKeyExchange final {
public:
    DhAnonServerKeyExchange(HandshakeRecord* rec);
    ~DhAnonServerKeyExchange();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 dh_p_length() const { return dh_p_length_; }
    bytestring const& dh_p() const { return dh_p_; }
    uint16 dh_g_length() const { return dh_g_length_; }
    bytestring const& dh_g() const { return dh_g_; }
    uint16 dh_Ys_length() const { return dh_Ys_length_; }
    bytestring const& dh_Ys() const { return dh_Ys_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint16 dh_p_length_;
    bytestring dh_p_;
    uint16 dh_g_length_;
    bytestring dh_g_;
    uint16 dh_Ys_length_;
    bytestring dh_Ys_;
    const_bytestring data_;
    HandshakeRecord* rec_;
    bool proc_;
};


class CertificateAuthorities final {
public:
    CertificateAuthorities();
    ~CertificateAuthorities();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 certificate_authority_len() const { return certificate_authority_len_; }
    bytestring const& certificate_authority() const { return certificate_authority_; }

protected:
    uint16 certificate_authority_len_;
    bytestring certificate_authority_;
};


class CertificateAuthoritiesContainer final {
public:
    CertificateAuthoritiesContainer();
    ~CertificateAuthoritiesContainer();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    vector<CertificateAuthorities*>* certificate_authorities() const { return certificate_authorities_; }

protected:
    vector<CertificateAuthorities*>* certificate_authorities_;
    CertificateAuthorities* certificate_authorities__elem_;
};


class CertificateRequest final {
public:
    CertificateRequest(HandshakeRecord* rec);
    ~CertificateRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint8 certificate_types_len() const { return certificate_types_len_; }
    vector<uint8>* certificate_types() const { return certificate_types_; }
    int alg_case_index() const	{ return alg_case_index_; }
    SignatureAlgorithm* supported_signature_algorithms() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( alg_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:464:supported_signature_algorithms", (int64)alg_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return supported_signature_algorithms_;
    }
    bytestring const& nothing() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( alg_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:465:nothing", (int64)alg_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nothing_;
    }
    uint16 certificate_authorities_len() const { return certificate_authorities_len_; }
    CertificateAuthoritiesContainer* certificate_authorities() const { return certificate_authorities_; }
    HandshakeRecord* rec() const { return rec_; }
    bool uses_signature_and_hashalgorithm() const { return uses_signature_and_hashalgorithm_; }
    bool proc() const { return proc_; }

protected:
    uint8 certificate_types_len_;
    vector<uint8>* certificate_types_;
    uint8 certificate_types__elem_;
    int alg_case_index_;
    SignatureAlgorithm* supported_signature_algorithms_;
    bytestring nothing_;
    uint16 certificate_authorities_len_;
    CertificateAuthoritiesContainer* certificate_authorities_;
    const_bytestring cont_;
    HandshakeRecord* rec_;
    bool uses_signature_and_hashalgorithm_;
    bool proc_;
};


class ServerHelloDone final {
public:
    ServerHelloDone(HandshakeRecord* rec);
    ~ServerHelloDone();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    HandshakeRecord* rec() const { return rec_; }

protected:
    HandshakeRecord* rec_;
};


class ClientKeyExchange final {
public:
    ClientKeyExchange(HandshakeRecord* rec);
    ~ClientKeyExchange();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    RsaClientKeyExchange* rsa_client_key_exchange() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)1):
            case ((int)2):
            case ((int)3):
            case ((int)4):
            case ((int)5):
            case ((int)6):
            case ((int)7):
            case ((int)8):
            case ((int)9):
            case ((int)10):
            case ((int)47):
            case ((int)53):
            case ((int)59):
            case ((int)60):
            case ((int)61):
            case ((int)65):
            case ((int)96):
            case ((int)97):
            case ((int)98):
            case ((int)100):
            case ((int)124):
            case ((int)125):
            case ((int)126):
            case ((int)132):
            case ((int)146):
            case ((int)147):
            case ((int)148):
            case ((int)149):
            case ((int)150):
            case ((int)156):
            case ((int)157):
            case ((int)182):
            case ((int)183):
            case ((int)184):
            case ((int)185):
            case ((int)186):
            case ((int)192):
            case ((int)49212):
            case ((int)49213):
            case ((int)49232):
            case ((int)49233):
            case ((int)49256):
            case ((int)49257):
            case ((int)49262):
            case ((int)49263):
            case ((int)49274):
            case ((int)49275):
            case ((int)49298):
            case ((int)49299):
            case ((int)49304):
            case ((int)49305):
            case ((int)49308):
            case ((int)49309):
            case ((int)49312):
            case ((int)49313):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:559:rsa_client_key_exchange", (int64)val_case_index(), "TLS_RSA_WITH_NULL_MD5, TLS_RSA_WITH_NULL_SHA, TLS_RSA_EXPORT_WITH_RC4_40_MD5, TLS_RSA_WITH_RC4_128_MD5, TLS_RSA_WITH_RC4_128_SHA, TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5, TLS_RSA_WITH_IDEA_CBC_SHA, TLS_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_RSA_WITH_DES_CBC_SHA, TLS_RSA_WITH_3DES_EDE_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_NULL_SHA256, TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256, TLS_RSA_WITH_CAMELLIA_128_CBC_SHA, TLS_RSA_EXPORT1024_WITH_RC4_56_MD5, TLS_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5, TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA, TLS_RSA_EXPORT1024_WITH_RC4_56_SHA, TLS_RSA_WITH_3DES_EDE_CBC_RMD, TLS_RSA_WITH_AES_128_CBC_RMD, TLS_RSA_WITH_AES_256_CBC_RMD, TLS_RSA_WITH_CAMELLIA_256_CBC_SHA, TLS_RSA_PSK_WITH_RC4_128_SHA, TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA, TLS_RSA_PSK_WITH_AES_128_CBC_SHA, TLS_RSA_PSK_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_SEED_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_GCM_SHA384, TLS_RSA_PSK_WITH_AES_128_CBC_SHA256, TLS_RSA_PSK_WITH_AES_256_CBC_SHA384, TLS_RSA_PSK_WITH_NULL_SHA256, TLS_RSA_PSK_WITH_NULL_SHA384, TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256, TLS_RSA_WITH_ARIA_128_CBC_SHA256, TLS_RSA_WITH_ARIA_256_CBC_SHA384, TLS_RSA_WITH_ARIA_128_GCM_SHA256, TLS_RSA_WITH_ARIA_256_GCM_SHA384, TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256, TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384, TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256, TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384, TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256, TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384, TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256, TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384, TLS_RSA_WITH_AES_128_CCM, TLS_RSA_WITH_AES_256_CCM, TLS_RSA_WITH_AES_128_CCM_8, TLS_RSA_WITH_AES_256_CCM_8");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return rsa_client_key_exchange_;
    }
    EcdhClientKeyExchange* ecdh_client_key_exchange() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)49153):
            case ((int)49154):
            case ((int)49155):
            case ((int)49156):
            case ((int)49157):
            case ((int)49158):
            case ((int)49159):
            case ((int)49160):
            case ((int)49161):
            case ((int)49162):
            case ((int)49163):
            case ((int)49164):
            case ((int)49165):
            case ((int)49166):
            case ((int)49167):
            case ((int)49168):
            case ((int)49169):
            case ((int)49170):
            case ((int)49171):
            case ((int)49172):
            case ((int)49173):
            case ((int)49174):
            case ((int)49175):
            case ((int)49176):
            case ((int)49177):
            case ((int)49187):
            case ((int)49188):
            case ((int)49189):
            case ((int)49190):
            case ((int)49191):
            case ((int)49192):
            case ((int)49193):
            case ((int)49194):
            case ((int)49195):
            case ((int)49196):
            case ((int)49197):
            case ((int)49198):
            case ((int)49199):
            case ((int)49200):
            case ((int)49201):
            case ((int)49202):
            case ((int)49203):
            case ((int)49204):
            case ((int)49205):
            case ((int)49206):
            case ((int)49207):
            case ((int)49208):
            case ((int)49209):
            case ((int)49210):
            case ((int)49211):
            case ((int)49224):
            case ((int)49225):
            case ((int)49226):
            case ((int)49227):
            case ((int)49228):
            case ((int)49229):
            case ((int)49230):
            case ((int)49231):
            case ((int)49244):
            case ((int)49245):
            case ((int)49246):
            case ((int)49247):
            case ((int)49248):
            case ((int)49249):
            case ((int)49250):
            case ((int)49251):
            case ((int)49264):
            case ((int)49265):
            case ((int)49266):
            case ((int)49267):
            case ((int)49268):
            case ((int)49269):
            case ((int)49270):
            case ((int)49271):
            case ((int)49272):
            case ((int)49273):
            case ((int)49286):
            case ((int)49287):
            case ((int)49288):
            case ((int)49289):
            case ((int)49290):
            case ((int)49291):
            case ((int)49292):
            case ((int)49293):
            case ((int)49306):
            case ((int)49307):
            case ((int)49324):
            case ((int)49325):
            case ((int)49326):
            case ((int)49327):
            case ((int)52392):
            case ((int)52393):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:654:ecdh_client_key_exchange", (int64)val_case_index(), "TLS_ECDH_ECDSA_WITH_NULL_SHA, TLS_ECDH_ECDSA_WITH_RC4_128_SHA, TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA, TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_NULL_SHA, TLS_ECDHE_ECDSA_WITH_RC4_128_SHA, TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDH_RSA_WITH_NULL_SHA, TLS_ECDH_RSA_WITH_RC4_128_SHA, TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA, TLS_ECDH_RSA_WITH_AES_128_CBC_SHA, TLS_ECDH_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_NULL_SHA, TLS_ECDHE_RSA_WITH_RC4_128_SHA, TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDH_ANON_WITH_NULL_SHA, TLS_ECDH_ANON_WITH_RC4_128_SHA, TLS_ECDH_ANON_WITH_3DES_EDE_CBC_SHA, TLS_ECDH_ANON_WITH_AES_128_CBC_SHA, TLS_ECDH_ANON_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256, TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256, TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384, TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256, TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384, TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256, TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384, TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256, TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384, TLS_ECDHE_PSK_WITH_RC4_128_SHA, TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA, TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA, TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA, TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256, TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384, TLS_ECDHE_PSK_WITH_NULL_SHA, TLS_ECDHE_PSK_WITH_NULL_SHA256, TLS_ECDHE_PSK_WITH_NULL_SHA384, TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256, TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384, TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256, TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256, TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384, TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256, TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384, TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256, TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384, TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256, TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384, TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256, TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384, TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256, TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384, TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256, TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384, TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384, TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384, TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, TLS_ECDHE_ECDSA_WITH_AES_128_CCM, TLS_ECDHE_ECDSA_WITH_AES_256_CCM, TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8, TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8, TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ecdh_client_key_exchange_;
    }
    DhClientKeyExchange* dh_server_key_exchange() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)17):
            case ((int)18):
            case ((int)19):
            case ((int)20):
            case ((int)21):
            case ((int)22):
            case ((int)50):
            case ((int)51):
            case ((int)56):
            case ((int)57):
            case ((int)64):
            case ((int)68):
            case ((int)69):
            case ((int)99):
            case ((int)101):
            case ((int)102):
            case ((int)103):
            case ((int)106):
            case ((int)107):
            case ((int)114):
            case ((int)115):
            case ((int)116):
            case ((int)119):
            case ((int)120):
            case ((int)121):
            case ((int)135):
            case ((int)136):
            case ((int)142):
            case ((int)143):
            case ((int)144):
            case ((int)145):
            case ((int)153):
            case ((int)154):
            case ((int)158):
            case ((int)159):
            case ((int)162):
            case ((int)163):
            case ((int)170):
            case ((int)171):
            case ((int)178):
            case ((int)179):
            case ((int)180):
            case ((int)181):
            case ((int)189):
            case ((int)190):
            case ((int)195):
            case ((int)196):
            case ((int)49218):
            case ((int)49219):
            case ((int)49220):
            case ((int)49221):
            case ((int)49234):
            case ((int)49235):
            case ((int)49238):
            case ((int)49239):
            case ((int)49254):
            case ((int)49255):
            case ((int)49260):
            case ((int)49261):
            case ((int)49276):
            case ((int)49277):
            case ((int)49280):
            case ((int)49281):
            case ((int)49296):
            case ((int)49297):
            case ((int)49302):
            case ((int)49303):
            case ((int)49310):
            case ((int)49311):
            case ((int)49314):
            case ((int)49315):
            case ((int)49318):
            case ((int)49319):
            case ((int)49322):
            case ((int)49323):
            case ((int)52394):
            case ((int)23):
            case ((int)24):
            case ((int)25):
            case ((int)26):
            case ((int)27):
            case ((int)52):
            case ((int)58):
            case ((int)70):
            case ((int)108):
            case ((int)109):
            case ((int)137):
            case ((int)155):
            case ((int)166):
            case ((int)167):
            case ((int)191):
            case ((int)197):
            case ((int)49222):
            case ((int)49223):
            case ((int)49242):
            case ((int)49243):
            case ((int)49284):
            case ((int)49285):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:756:dh_server_key_exchange", (int64)val_case_index(), "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_DSS_WITH_DES_CBC_SHA, TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA, TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_RSA_WITH_DES_CBC_SHA, TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DHE_DSS_WITH_AES_128_CBC_SHA, TLS_DHE_RSA_WITH_AES_128_CBC_SHA, TLS_DHE_DSS_WITH_AES_256_CBC_SHA, TLS_DHE_RSA_WITH_AES_256_CBC_SHA, TLS_DHE_DSS_WITH_AES_128_CBC_SHA256, TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA, TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA, TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA, TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA, TLS_DHE_DSS_WITH_RC4_128_SHA, TLS_DHE_RSA_WITH_AES_128_CBC_SHA256, TLS_DHE_DSS_WITH_AES_256_CBC_SHA256, TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, TLS_DHE_DSS_WITH_3DES_EDE_CBC_RMD, TLS_DHE_DSS_WITH_AES_128_CBC_RMD, TLS_DHE_DSS_WITH_AES_256_CBC_RMD, TLS_DHE_RSA_WITH_3DES_EDE_CBC_RMD, TLS_DHE_RSA_WITH_AES_128_CBC_RMD, TLS_DHE_RSA_WITH_AES_256_CBC_RMD, TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA, TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA, TLS_DHE_PSK_WITH_RC4_128_SHA, TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA, TLS_DHE_PSK_WITH_AES_128_CBC_SHA, TLS_DHE_PSK_WITH_AES_256_CBC_SHA, TLS_DHE_DSS_WITH_SEED_CBC_SHA, TLS_DHE_RSA_WITH_SEED_CBC_SHA, TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, TLS_DHE_DSS_WITH_AES_256_GCM_SHA384, TLS_DHE_PSK_WITH_AES_128_GCM_SHA256, TLS_DHE_PSK_WITH_AES_256_GCM_SHA384, TLS_DHE_PSK_WITH_AES_128_CBC_SHA256, TLS_DHE_PSK_WITH_AES_256_CBC_SHA384, TLS_DHE_PSK_WITH_NULL_SHA256, TLS_DHE_PSK_WITH_NULL_SHA384, TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256, TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256, TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256, TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256, TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256, TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384, TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256, TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384, TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256, TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384, TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256, TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384, TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256, TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384, TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256, TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384, TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256, TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384, TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256, TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384, TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256, TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384, TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256, TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384, TLS_DHE_RSA_WITH_AES_128_CCM, TLS_DHE_RSA_WITH_AES_256_CCM, TLS_DHE_RSA_WITH_AES_128_CCM_8, TLS_DHE_RSA_WITH_AES_256_CCM_8, TLS_DHE_PSK_WITH_AES_128_CCM, TLS_DHE_PSK_WITH_AES_256_CCM, TLS_PSK_DHE_WITH_AES_128_CCM_8, TLS_PSK_DHE_WITH_AES_256_CCM_8, TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256, TLS_DH_ANON_EXPORT_WITH_RC4_40_MD5, TLS_DH_ANON_WITH_RC4_128_MD5, TLS_DH_ANON_EXPORT_WITH_DES40_CBC_SHA, TLS_DH_ANON_WITH_DES_CBC_SHA, TLS_DH_ANON_WITH_3DES_EDE_CBC_SHA, TLS_DH_ANON_WITH_AES_128_CBC_SHA, TLS_DH_ANON_WITH_AES_256_CBC_SHA, TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA, TLS_DH_ANON_WITH_AES_128_CBC_SHA256, TLS_DH_ANON_WITH_AES_256_CBC_SHA256, TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA, TLS_DH_ANON_WITH_SEED_CBC_SHA, TLS_DH_ANON_WITH_AES_128_GCM_SHA256, TLS_DH_ANON_WITH_AES_256_GCM_SHA384, TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA256, TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA256, TLS_DH_ANON_WITH_ARIA_128_CBC_SHA256, TLS_DH_ANON_WITH_ARIA_256_CBC_SHA384, TLS_DH_ANON_WITH_ARIA_128_GCM_SHA256, TLS_DH_ANON_WITH_ARIA_256_GCM_SHA384, TLS_DH_ANON_WITH_CAMELLIA_128_GCM_SHA256, TLS_DH_ANON_WITH_CAMELLIA_256_GCM_SHA384");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return dh_server_key_exchange_;
    }
    HandshakeRecord* rec() const { return rec_; }

protected:
    int val_case_index_;
    RsaClientKeyExchange* rsa_client_key_exchange_;
    EcdhClientKeyExchange* ecdh_client_key_exchange_;
    DhClientKeyExchange* dh_server_key_exchange_;
    const_bytestring key_;
    HandshakeRecord* rec_;
};


class RsaClientKeyExchange final {
public:
    RsaClientKeyExchange(HandshakeRecord* rec);
    ~RsaClientKeyExchange();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    bytestring const& rsa_pms() const { return rsa_pms_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    bytestring rsa_pms_;
    HandshakeRecord* rec_;
    bool proc_;
};


class DhClientKeyExchange final {
public:
    DhClientKeyExchange(HandshakeRecord* rec);
    ~DhClientKeyExchange();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    bytestring const& dh_Yc() const { return dh_Yc_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    bytestring dh_Yc_;
    HandshakeRecord* rec_;
    bool proc_;
};


class EcdhClientKeyExchange final {
public:
    EcdhClientKeyExchange(HandshakeRecord* rec);
    ~EcdhClientKeyExchange();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    bytestring const& point() const { return point_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    bytestring point_;
    HandshakeRecord* rec_;
    bool proc_;
};


class CertificateVerify final {
public:
    CertificateVerify(HandshakeRecord* rec);
    ~CertificateVerify();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    HandshakeRecord* rec() const { return rec_; }

protected:
    const_bytestring cont_;
    HandshakeRecord* rec_;
};


class Finished final {
public:
    Finished(HandshakeRecord* rec);
    ~Finished();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    HandshakeRecord* rec() const { return rec_; }

protected:
    const_bytestring cont_;
    HandshakeRecord* rec_;
};


class SessionTicketHandshake final {
public:
    SessionTicketHandshake(HandshakeRecord* rec);
    ~SessionTicketHandshake();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint32 ticket_lifetime_hint() const { return ticket_lifetime_hint_; }
    uint16 length() const { return length_; }
    bytestring const& data() const { return data_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint32 ticket_lifetime_hint_;
    uint16 length_;
    bytestring data_;
    HandshakeRecord* rec_;
    bool proc_;
};


class SSLExtension final {
public:
    SSLExtension(HandshakeRecord* rec);
    ~SSLExtension();
    int initial_buffer_length() const { return 4; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 type() const { return type_; }
    uint16 data_len() const { return data_len_; }
    uint16 ext_case_index() const	{ return ext_case_index_; }
    vector<ApplicationLayerProtocolNegotiationExtension*>* apnl() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:811:apnl", (int64)ext_case_index(), "EXT_APPLICATION_LAYER_PROTOCOL_NEGOTIATION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return apnl_;
    }
    vector<EllipticCurves*>* elliptic_curves() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:812:elliptic_curves", (int64)ext_case_index(), "EXT_ELLIPTIC_CURVES");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return elliptic_curves_;
    }
    vector<EcPointFormats*>* ec_point_formats() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:813:ec_point_formats", (int64)ext_case_index(), "EXT_EC_POINT_FORMATS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ec_point_formats_;
    }
    vector<ServerNameExt*>* server_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:815:server_name", (int64)ext_case_index(), "EXT_SERVER_NAME");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_name_;
    }
    vector<SignatureAlgorithm*>* signature_algorithm() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)13):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:816:signature_algorithm", (int64)ext_case_index(), "EXT_SIGNATURE_ALGORITHMS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return signature_algorithm_;
    }
    vector<SignedCertificateTimestampList*>* certificate_timestamp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)18):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:817:certificate_timestamp", (int64)ext_case_index(), "EXT_SIGNED_CERTIFICATE_TIMESTAMP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return certificate_timestamp_;
    }
    vector<KeyShare*>* key_share() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)51):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:818:key_share", (int64)ext_case_index(), "EXT_KEY_SHARE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return key_share_;
    }
    vector<KeyShare*>* key_share_old() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)40):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:819:key_share_old", (int64)ext_case_index(), "EXT_KEY_SHARE_OLD");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return key_share_old_;
    }
    vector<SupportedVersionsSelector*>* supported_versions_selector() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)43):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:820:supported_versions_selector", (int64)ext_case_index(), "EXT_SUPPORTED_VERSIONS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return supported_versions_selector_;
    }
    vector<PSKKeyExchangeModes*>* psk_key_exchange_modes() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)45):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:821:psk_key_exchange_modes", (int64)ext_case_index(), "EXT_PSK_KEY_EXCHANGE_MODES");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return psk_key_exchange_modes_;
    }
    vector<PreSharedKey*>* pre_shared_key() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)41):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:822:pre_shared_key", (int64)ext_case_index(), "EXT_PRE_SHARED_KEY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pre_shared_key_;
    }
    vector<ConnectionId*>* connection_id() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)54):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:823:connection_id", (int64)ext_case_index(), "EXT_CONNECTION_ID");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return connection_id_;
    }
    bytestring const& data() const {
        return data_;
    }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }
    const_bytestring const& sourcedata() const { return sourcedata_; }

protected:
    uint16 type_;
    uint16 data_len_;
    uint16 ext_case_index_;
    vector<ApplicationLayerProtocolNegotiationExtension*>* apnl_;
    ApplicationLayerProtocolNegotiationExtension* apnl__elem_;
    vector<EllipticCurves*>* elliptic_curves_;
    EllipticCurves* elliptic_curves__elem_;
    vector<EcPointFormats*>* ec_point_formats_;
    EcPointFormats* ec_point_formats__elem_;
    vector<ServerNameExt*>* server_name_;
    ServerNameExt* server_name__elem_;
    vector<SignatureAlgorithm*>* signature_algorithm_;
    SignatureAlgorithm* signature_algorithm__elem_;
    vector<SignedCertificateTimestampList*>* certificate_timestamp_;
    SignedCertificateTimestampList* certificate_timestamp__elem_;
    vector<KeyShare*>* key_share_;
    KeyShare* key_share__elem_;
    vector<KeyShare*>* key_share_old_;
    KeyShare* key_share_old__elem_;
    vector<SupportedVersionsSelector*>* supported_versions_selector_;
    SupportedVersionsSelector* supported_versions_selector__elem_;
    vector<PSKKeyExchangeModes*>* psk_key_exchange_modes_;
    PSKKeyExchangeModes* psk_key_exchange_modes__elem_;
    vector<PreSharedKey*>* pre_shared_key_;
    PreSharedKey* pre_shared_key__elem_;
    vector<ConnectionId*>* connection_id_;
    ConnectionId* connection_id__elem_;
    bytestring data_;
    HandshakeRecord* rec_;
    bool proc_;
    const_bytestring sourcedata_;
};


class SignatureAndHashAlgorithm final {
public:
    SignatureAndHashAlgorithm();
    ~SignatureAndHashAlgorithm();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 HashAlgorithm() const { return HashAlgorithm_; }
    uint8 SignatureAlgorithm() const { return SignatureAlgorithm_; }

protected:
    uint8 HashAlgorithm_;
    uint8 SignatureAlgorithm_;
};


class SignedCertificateTimestampList final {
public:
    SignedCertificateTimestampList(HandshakeRecord* rec);
    ~SignedCertificateTimestampList();
    int initial_buffer_length() const { return 2; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    vector<SignedCertificateTimestamp*>* SCTs() const { return SCTs_; }
    HandshakeRecord* rec() const { return rec_; }

protected:
    uint16 length_;
    vector<SignedCertificateTimestamp*>* SCTs_;
    SignedCertificateTimestamp* SCTs__elem_;
    HandshakeRecord* rec_;
};


class SignedCertificateTimestamp final {
public:
    SignedCertificateTimestamp(HandshakeRecord* rec);
    ~SignedCertificateTimestamp();
    int initial_buffer_length() const { return 2; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    uint8 version() const { return version_; }
    bytestring const& logid() const { return logid_; }
    uint64 timestamp() const { return timestamp_; }
    uint16 extensions_length() const { return extensions_length_; }
    bytestring const& extensions() const { return extensions_; }
    SignatureAndHashAlgorithm* digitally_signed_algorithms() const { return digitally_signed_algorithms_; }
    uint16 digitally_signed_signature_length() const { return digitally_signed_signature_length_; }
    bytestring const& digitally_signed_signature() const { return digitally_signed_signature_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint16 length_;
    uint8 version_;
    bytestring logid_;
    uint64 timestamp_;
    uint16 extensions_length_;
    bytestring extensions_;
    SignatureAndHashAlgorithm* digitally_signed_algorithms_;
    uint16 digitally_signed_signature_length_;
    bytestring digitally_signed_signature_;
    HandshakeRecord* rec_;
    bool proc_;
};


class ConnectionId final {
public:
    ConnectionId(HandshakeRecord* rec);
    ~ConnectionId();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    uint8 length() const { return length_; }
    bytestring const& cid() const { return cid_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint8 length_;
    bytestring cid_;
    HandshakeRecord* rec_;
    bool proc_;
};


class SupportedVersionsSelector final {
public:
    SupportedVersionsSelector(HandshakeRecord* rec, uint16 data_len);
    ~SupportedVersionsSelector();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    SupportedVersions* a() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:836:a", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return a_;
    }
    OneSupportedVersion* b() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:837:b", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return b_;
    }
    HandshakeRecord* rec() const { return rec_; }
    uint16 data_len() const { return data_len_; }

protected:
    int val_case_index_;
    SupportedVersions* a_;
    OneSupportedVersion* b_;
    HandshakeRecord* rec_;
    uint16 data_len_;
};


class SupportedVersions final {
public:
    SupportedVersions(HandshakeRecord* rec);
    ~SupportedVersions();
    int initial_buffer_length() const { return 1; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint8 length() const { return length_; }
    vector<uint16>* versions() const { return versions_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint8 length_;
    vector<uint16>* versions_;
    uint16 versions__elem_;
    HandshakeRecord* rec_;
    bool proc_;
};


class OneSupportedVersion final {
public:
    OneSupportedVersion(HandshakeRecord* rec);
    ~OneSupportedVersion();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 version() const { return version_; }
    HandshakeRecord* rec() const { return rec_; }
    bool version_set() const { return version_set_; }
    bool proc() const { return proc_; }

protected:
    uint16 version_;
    HandshakeRecord* rec_;
    bool version_set_;
    bool proc_;
};


class PSKKeyExchangeModes final {
public:
    PSKKeyExchangeModes(HandshakeRecord* rec);
    ~PSKKeyExchangeModes();
    int initial_buffer_length() const { return 1; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    uint8 length() const { return length_; }
    vector<uint8>* modes() const { return modes_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint8 length_;
    vector<uint8>* modes_;
    uint8 modes__elem_;
    HandshakeRecord* rec_;
    bool proc_;
};


class ServerNameHostName final {
public:
    ServerNameHostName();
    ~ServerNameHostName();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    bytestring const& host_name() const { return host_name_; }

protected:
    uint16 length_;
    bytestring host_name_;
};


class ServerName final {
public:
    ServerName();
    ~ServerName();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 name_type() const { return name_type_; }
    uint8 name_case_index() const	{ return name_case_index_; }
    ServerNameHostName* host_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( name_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:866:host_name", (int64)name_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return host_name_;
    }

protected:
    uint8 name_type_;
    uint8 name_case_index_;
    ServerNameHostName* host_name_;
    const_bytestring data_;
};


class ServerNameExt final {
public:
    ServerNameExt(HandshakeRecord* rec);
    ~ServerNameExt();
    int initial_buffer_length() const { return 2; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    vector<ServerName*>* server_names() const { return server_names_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint16 length_;
    vector<ServerName*>* server_names_;
    ServerName* server_names__elem_;
    HandshakeRecord* rec_;
    bool proc_;
};


class EcPointFormats final {
public:
    EcPointFormats(HandshakeRecord* rec);
    ~EcPointFormats();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context);

    // Member access functions
    uint8 length() const { return length_; }
    vector<uint8>* point_format_list() const { return point_format_list_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint8 length_;
    vector<uint8>* point_format_list_;
    uint8 point_format_list__elem_;
    HandshakeRecord* rec_;
    bool proc_;
};


class KeyShareEntry final {
public:
    KeyShareEntry();
    ~KeyShareEntry();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 namedgroup() const { return namedgroup_; }
    uint16 key_exchange_length() const { return key_exchange_length_; }

protected:
    uint16 namedgroup_;
    uint16 key_exchange_length_;
    const_bytestring key_exchange_;
};


class ServerHelloKeyShare final {
public:
    ServerHelloKeyShare(HandshakeRecord* rec);
    ~ServerHelloKeyShare();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    KeyShareEntry* keyshare() const { return keyshare_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    KeyShareEntry* keyshare_;
    HandshakeRecord* rec_;
    bool proc_;
};


class HelloRetryRequestKeyShare final {
public:
    HelloRetryRequestKeyShare(HandshakeRecord* rec);
    ~HelloRetryRequestKeyShare();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 namedgroup() const { return namedgroup_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint16 namedgroup_;
    HandshakeRecord* rec_;
    bool proc_;
};


class ServerHelloKeyShareChoice final {
public:
    ServerHelloKeyShareChoice(HandshakeRecord* rec, SSLExtension* ext);
    ~ServerHelloKeyShareChoice();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 val_case_index() const	{ return val_case_index_; }
    HelloRetryRequestKeyShare* hrr() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint16)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:912:hrr", (int64)val_case_index(), "((int) 2)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return hrr_;
    }
    ServerHelloKeyShare* server() const {
        return server_;
    }
    HandshakeRecord* rec() const { return rec_; }
    SSLExtension* ext() const { return ext_; }

protected:
    uint16 val_case_index_;
    HelloRetryRequestKeyShare* hrr_;
    ServerHelloKeyShare* server_;
    HandshakeRecord* rec_;
    SSLExtension* ext_;
};


class ClientHelloKeyShare final {
public:
    ClientHelloKeyShare(HandshakeRecord* rec);
    ~ClientHelloKeyShare();
    int initial_buffer_length() const { return 2; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    vector<KeyShareEntry*>* keyshares() const { return keyshares_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint16 length_;
    vector<KeyShareEntry*>* keyshares_;
    KeyShareEntry* keyshares__elem_;
    HandshakeRecord* rec_;
    bool proc_;
};


class KeyShare final {
public:
    KeyShare(HandshakeRecord* rec, SSLExtension* ext);
    ~KeyShare();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    ClientHelloKeyShare* client_hello_keyshare() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:922:client_hello_keyshare", (int64)val_case_index(), "CLIENT_HELLO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_hello_keyshare_;
    }
    ServerHelloKeyShareChoice* server_hello_keyshare() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:923:server_hello_keyshare", (int64)val_case_index(), "SERVER_HELLO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_hello_keyshare_;
    }
    HandshakeRecord* rec() const { return rec_; }
    SSLExtension* ext() const { return ext_; }

protected:
    uint8 val_case_index_;
    ClientHelloKeyShare* client_hello_keyshare_;
    ServerHelloKeyShareChoice* server_hello_keyshare_;
    const_bytestring other_;
    HandshakeRecord* rec_;
    SSLExtension* ext_;
};


class SelectedPreSharedKeyIdentity final {
public:
    SelectedPreSharedKeyIdentity(HandshakeRecord* rec);
    ~SelectedPreSharedKeyIdentity();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 selected_identity() const { return selected_identity_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint16 selected_identity_;
    HandshakeRecord* rec_;
    bool proc_;
};


class PSKIdentity final {
public:
    PSKIdentity();
    ~PSKIdentity();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    bytestring const& identity() const { return identity_; }
    uint32 obfuscated_ticket_age() const { return obfuscated_ticket_age_; }

protected:
    uint16 length_;
    bytestring identity_;
    uint32 obfuscated_ticket_age_;
};


class PSKIdentitiesList final {
public:
    PSKIdentitiesList();
    ~PSKIdentitiesList();
    int initial_buffer_length() const { return 2; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    vector<PSKIdentity*>* identities() const { return identities_; }

protected:
    uint16 length_;
    vector<PSKIdentity*>* identities_;
    PSKIdentity* identities__elem_;
};


class PSKBinder final {
public:
    PSKBinder();
    ~PSKBinder();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 length() const { return length_; }
    bytestring const& binder() const { return binder_; }

protected:
    uint8 length_;
    bytestring binder_;
};


class PSKBindersList final {
public:
    PSKBindersList();
    ~PSKBindersList();
    int initial_buffer_length() const { return 2; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    vector<PSKBinder*>* binders() const { return binders_; }

protected:
    uint16 length_;
    vector<PSKBinder*>* binders_;
    PSKBinder* binders__elem_;
};


class OfferedPsks final {
public:
    OfferedPsks(HandshakeRecord* rec);
    ~OfferedPsks();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    PSKIdentitiesList* identities() const { return identities_; }
    PSKBindersList* binders() const { return binders_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    PSKIdentitiesList* identities_;
    PSKBindersList* binders_;
    HandshakeRecord* rec_;
    bool proc_;
};


class PreSharedKey final {
public:
    PreSharedKey(HandshakeRecord* rec);
    ~PreSharedKey();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    OfferedPsks* offered_psks() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:961:offered_psks", (int64)val_case_index(), "CLIENT_HELLO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return offered_psks_;
    }
    SelectedPreSharedKeyIdentity* selected_identity() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:962:selected_identity", (int64)val_case_index(), "SERVER_HELLO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return selected_identity_;
    }
    HandshakeRecord* rec() const { return rec_; }

protected:
    uint8 val_case_index_;
    OfferedPsks* offered_psks_;
    SelectedPreSharedKeyIdentity* selected_identity_;
    const_bytestring other_;
    HandshakeRecord* rec_;
};


class SignatureAlgorithm final {
public:
    SignatureAlgorithm(HandshakeRecord* rec);
    ~SignatureAlgorithm();
    int initial_buffer_length() const { return 2; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    vector<SignatureAndHashAlgorithm*>* supported_signature_algorithms() const { return supported_signature_algorithms_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint16 length_;
    vector<SignatureAndHashAlgorithm*>* supported_signature_algorithms_;
    SignatureAndHashAlgorithm* supported_signature_algorithms__elem_;
    HandshakeRecord* rec_;
    bool proc_;
};


class EllipticCurves final {
public:
    EllipticCurves(HandshakeRecord* rec);
    ~EllipticCurves();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    vector<uint16>* elliptic_curve_list() const { return elliptic_curve_list_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint16 length_;
    vector<uint16>* elliptic_curve_list_;
    uint16 elliptic_curve_list__elem_;
    HandshakeRecord* rec_;
    bool proc_;
};


class ProtocolName final {
public:
    ProtocolName();
    ~ProtocolName();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 length() const { return length_; }
    bytestring const& name() const { return name_; }

protected:
    uint8 length_;
    bytestring name_;
};


class ApplicationLayerProtocolNegotiationExtension final {
public:
    ApplicationLayerProtocolNegotiationExtension(HandshakeRecord* rec);
    ~ApplicationLayerProtocolNegotiationExtension();
    int initial_buffer_length() const { return 2; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    vector<ProtocolName*>* protocol_name_list() const { return protocol_name_list_; }
    HandshakeRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint16 length_;
    vector<ProtocolName*>* protocol_name_list_;
    ProtocolName* protocol_name_list__elem_;
    HandshakeRecord* rec_;
    bool proc_;
};


class Handshake_Flow final : public binpac::FlowAnalyzer {
public:
    Handshake_Flow(Handshake_Conn* connection, bool is_orig);
    ~Handshake_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    Handshake_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

protected:
    HandshakePDU* dataunit_;
    ContextTLSHandshake* context_;
    FlowBuffer* flow_buffer_;
    Handshake_Conn* connection_;
    bool is_orig_;
};


	class extract_certs {
	public:
		bytestring const& operator() (X509Certificate* cert) const
			{
			return cert->certificate();
			}
	};

	string orig_label(bool is_orig);
	string handshake_type_label(int type);
	
} // namespace TLSHandshake
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_ssl_tls_handshake_pac_h */
