// This file was automatically generated by bifcl from /build/zeek/src/zeek/src/iosource/pcap/pcap.bif (alternative mode).


#include "pcap.bif.h"
#include "zeek/Func.h"

namespace zeek::BifConst::Pcap { zeek_uint_t snaplen; }
namespace BifConst::Pcap { zeek_uint_t snaplen; } 
namespace zeek::BifConst::Pcap { zeek_uint_t bufsize; }
namespace BifConst::Pcap { zeek_uint_t bufsize; } 
namespace zeek::BifConst::Pcap { zeek_uint_t bufsize_offline_bytes; }
namespace BifConst::Pcap { zeek_uint_t bufsize_offline_bytes; } 
namespace zeek::BifConst::Pcap { double non_fd_timeout; }
namespace BifConst::Pcap { double non_fd_timeout; } 

#line 9 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

#include <pcap.h>

#include "zeek/iosource/BPF_Program.h"
#include "zeek/iosource/Manager.h"
#include "zeek/iosource/PktSrc.h"

#line 35 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
zeek::ValPtr zeek::BifFunc::Pcap::precompile_pcap_filter_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 36 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
{
	// NOLINTNEXTLINE(readability-container-size-empty)
	if ( BiF_ARGS->size() != 2 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("Pcap::precompile_pcap_filter() takes exactly 2 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::Val* id = (zeek::Val*) ((*BiF_ARGS)[0].get()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)
	zeek::StringVal* s = (zeek::StringVal*) ((*BiF_ARGS)[1].get()->AsStringVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 36 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

	if ( id->AsEnum() >= 100 )
		{
		// We use a vector as underlying data structure for fast
		// lookups and limit the ID space so that it doesn't grow too
		// large.
		zeek::emit_builtin_error(
			zeek::util::fmt("PCAP filter ids must remain below 100 (is %" PRId64 ")", id->AsInt()));
		return zeek::val_mgr->False();
		}

	bool success = true;

	zeek::iosource::PktSrc* ps = zeek::iosource_mgr->GetPktSrc();
	if ( ps )
		{
		bool compiled = ps->PrecompileFilter(id->AsInt(), s->CheckString());
		auto filter = ps->GetBPFFilter(id->AsInt());
		if ( ! compiled || ( filter && filter->GetState() != zeek::iosource::FilterState::OK ) )
			success = false;
		}

	return zeek::val_mgr->Bool(success);
	} // end of BifFunc::Pcap::precompile_pcap_filter

#line 59 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

#line 79 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
zeek::ValPtr zeek::BifFunc::Pcap::install_pcap_filter_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 80 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
{
	// NOLINTNEXTLINE(readability-container-size-empty)
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("Pcap::install_pcap_filter() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::Val* id = (zeek::Val*) ((*BiF_ARGS)[0].get()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 80 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

	bool success = true;

	zeek::iosource::PktSrc* ps = zeek::iosource_mgr->GetPktSrc();
	if ( ps && ! ps->SetFilter(id->AsInt()) )
		success = false;

	return zeek::val_mgr->Bool(success);
	} // end of BifFunc::Pcap::install_pcap_filter

#line 88 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

#line 104 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
zeek::ValPtr zeek::BifFunc::Pcap::error_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 105 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
{
	// NOLINTNEXTLINE(readability-container-size-empty)
	if ( BiF_ARGS->size() != 0 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("Pcap::error() takes exactly 0 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}

#line 105 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

	zeek::iosource::PktSrc* ps = zeek::iosource_mgr->GetPktSrc();
	if ( ps )
		{
		const char* err = ps->ErrorMsg();
		if ( err && *err )
			return zeek::make_intrusive<zeek::StringVal>(err);
		}

	return zeek::make_intrusive<zeek::StringVal>("no error");
	} // end of BifFunc::Pcap::error

#line 115 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

#line 127 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
zeek::ValPtr zeek::BifFunc::Pcap::get_filter_state_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 128 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
{
	// NOLINTNEXTLINE(readability-container-size-empty)
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("Pcap::get_filter_state() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::Val* id = (zeek::Val*) ((*BiF_ARGS)[0].get()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 128 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

	EnumTypePtr filter_state = zeek::id::find_type<EnumType>("Pcap::filter_state");
	zeek::iosource::PktSrc* ps = zeek::iosource_mgr->GetPktSrc();
	if ( ps )
		{
		if ( auto filter = ps->GetBPFFilter(id->AsInt()) )
			return filter_state->GetEnumVal(static_cast<zeek_int_t>(filter->GetState()));
		}

	return filter_state->GetEnumVal(static_cast<zeek_int_t>(iosource::FilterState::OK));
	} // end of BifFunc::Pcap::get_filter_state

#line 138 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

#line 151 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
zeek::ValPtr zeek::BifFunc::Pcap::get_filter_state_string_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 152 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
{
	// NOLINTNEXTLINE(readability-container-size-empty)
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("Pcap::get_filter_state_string() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::Val* id = (zeek::Val*) ((*BiF_ARGS)[0].get()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 152 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

	zeek::iosource::PktSrc* ps = zeek::iosource_mgr->GetPktSrc();
	if ( ps )
		{
		if ( auto filter = ps->GetBPFFilter(id->AsInt()) )
			return zeek::make_intrusive<zeek::StringVal>(filter->GetStateMessage());
		}

	return zeek::make_intrusive<zeek::StringVal>("<unknown>");
	} // end of BifFunc::Pcap::get_filter_state_string

#line 161 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

#line 163 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
zeek::ValPtr zeek::BifFunc::Pcap::findalldevs_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 164 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
{
	// NOLINTNEXTLINE(readability-container-size-empty)
	if ( BiF_ARGS->size() != 0 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("Pcap::findalldevs() takes exactly 0 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}

#line 164 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"

	pcap_if_t* alldevs;
	char errbuf[PCAP_ERRBUF_SIZE];

	static auto ifaces_type = id::find_type<TableType>("Pcap::Interfaces");
	auto pcap_interfaces = make_intrusive<TableVal>(ifaces_type);

	int ret = pcap_findalldevs(&alldevs, errbuf);
	if ( ret == PCAP_ERROR )
		{
		emit_builtin_error(util::fmt("Error calling pcap_findalldevs: %s", errbuf));
		// Return an empty set in case of failure.
		return pcap_interfaces;
		}

	static auto iface_type = id::find_type<RecordType>("Pcap::Interface");
	for ( auto d = alldevs; d; d = d->next )
		{
		auto r = make_intrusive<RecordVal>(iface_type);

		r->Assign(0, d->name);
		if ( d->description )
			r->Assign(1, d->description);

		auto addrs = make_intrusive<ListVal>(TYPE_ADDR);
		for ( auto addr = d->addresses; addr != nullptr; addr = addr->next )
			{
			if ( addr->addr->sa_family == AF_INET )
				{
				IPAddr a(reinterpret_cast<struct sockaddr_in *>(addr->addr)->sin_addr);
				addrs->Append(make_intrusive<AddrVal>(a));
				}
			else if ( addr->addr->sa_family == AF_INET6 )
				{
				IPAddr a(reinterpret_cast<struct sockaddr_in6 *>(addr->addr)->sin6_addr);
				addrs->Append(make_intrusive<AddrVal>(a));
				}
			}
		r->Assign(2, addrs->ToSetVal());
		r->Assign(3, static_cast<bool>(d->flags & PCAP_IF_LOOPBACK));
#ifdef PCAP_IF_UP
		// These didn't become available until libpcap 1.6.1
		r->Assign(4, static_cast<bool>(d->flags & PCAP_IF_UP));
		r->Assign(5, static_cast<bool>(d->flags & PCAP_IF_RUNNING));
#endif

		pcap_interfaces->Assign(std::move(r), nullptr);
		}

	pcap_freealldevs(alldevs);
	return pcap_interfaces;
	} // end of BifFunc::Pcap::findalldevs

#line 215 "/build/zeek/src/zeek/src/iosource/pcap/pcap.bif"
