// This file is automatically generated from /build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/packet_analysis/protocol/gtpv1/gtpv1_pac.h"

namespace binpac {






namespace GTPv1 {
// NOLINTNEXTLINE(modernize-use-equals-default)
ContextGTPv1::ContextGTPv1(GTPv1_Conn* connection, GTPv1_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextGTPv1::~ContextGTPv1() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GTPv1_Header::GTPv1_Header() {
    flags_ = 0;
    msg_type_ = 0;
    length_ = 0;
    teid_ = 0;
    opt_case_index_ = -1;
    opt_hdr_ = nullptr;
    ext_case_index_ = -1;
    ext_hdrs_ = nullptr;
    ext_hdrs__elem_ = nullptr;
    msg_case_index_ = -1;
    create_pdp_ctx_request_ = nullptr;
    create_pdp_ctx_request__elem_ = nullptr;
    create_pdp_ctx_response_ = nullptr;
    create_pdp_ctx_response__elem_ = nullptr;
    update_pdp_ctx_request_ = nullptr;
    update_pdp_ctx_request__elem_ = nullptr;
    update_pdp_ctx_response_ = nullptr;
    update_pdp_ctx_response__elem_ = nullptr;
    delete_pdp_ctx_request_ = nullptr;
    delete_pdp_ctx_request__elem_ = nullptr;
    delete_pdp_ctx_response_ = nullptr;
    delete_pdp_ctx_response__elem_ = nullptr;
    byteorder_ = bigendian;
    version_ = 0;
    pt_flag_ = false;
    rsv_ = false;
    e_flag_ = false;
    s_flag_ = false;
    pn_flag_ = false;
    has_opt_ = false;
    proc_gtpv1_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GTPv1_Header::~GTPv1_Header() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( opt_case_index() ) {
        case true:
            // Clean up "opt_hdr"
            {
                delete opt_hdr_;
                opt_hdr_ = nullptr;
            }
            break;
        case false:
            // Clean up "no_opt"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( ext_case_index() ) {
        case true:
            // Clean up "ext_hdrs"
            {
                delete ext_hdrs__elem_;
                ext_hdrs__elem_ = nullptr;
                if ( ext_hdrs() ) {
                    for ( auto* ext_hdrs__elem_ : *ext_hdrs() ) {
                        delete ext_hdrs__elem_;
                        ext_hdrs__elem_ = nullptr;
                    }
                }
                delete ext_hdrs_;
            }
            break;
        case false:
            // Clean up "no_ext"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_case_index() ) {
        case ((uint8)16):
            // Clean up "create_pdp_ctx_request"
            {
                delete create_pdp_ctx_request__elem_;
                create_pdp_ctx_request__elem_ = nullptr;
                if ( create_pdp_ctx_request() ) {
                    for ( auto* create_pdp_ctx_request__elem_ : *create_pdp_ctx_request() ) {
                        delete create_pdp_ctx_request__elem_;
                        create_pdp_ctx_request__elem_ = nullptr;
                    }
                }
                delete create_pdp_ctx_request_;
            }
            break;
        case ((uint8)17):
            // Clean up "create_pdp_ctx_response"
            {
                delete create_pdp_ctx_response__elem_;
                create_pdp_ctx_response__elem_ = nullptr;
                if ( create_pdp_ctx_response() ) {
                    for ( auto* create_pdp_ctx_response__elem_ : *create_pdp_ctx_response() ) {
                        delete create_pdp_ctx_response__elem_;
                        create_pdp_ctx_response__elem_ = nullptr;
                    }
                }
                delete create_pdp_ctx_response_;
            }
            break;
        case ((uint8)18):
            // Clean up "update_pdp_ctx_request"
            {
                delete update_pdp_ctx_request__elem_;
                update_pdp_ctx_request__elem_ = nullptr;
                if ( update_pdp_ctx_request() ) {
                    for ( auto* update_pdp_ctx_request__elem_ : *update_pdp_ctx_request() ) {
                        delete update_pdp_ctx_request__elem_;
                        update_pdp_ctx_request__elem_ = nullptr;
                    }
                }
                delete update_pdp_ctx_request_;
            }
            break;
        case ((uint8)19):
            // Clean up "update_pdp_ctx_response"
            {
                delete update_pdp_ctx_response__elem_;
                update_pdp_ctx_response__elem_ = nullptr;
                if ( update_pdp_ctx_response() ) {
                    for ( auto* update_pdp_ctx_response__elem_ : *update_pdp_ctx_response() ) {
                        delete update_pdp_ctx_response__elem_;
                        update_pdp_ctx_response__elem_ = nullptr;
                    }
                }
                delete update_pdp_ctx_response_;
            }
            break;
        case ((uint8)20):
            // Clean up "delete_pdp_ctx_request"
            {
                delete delete_pdp_ctx_request__elem_;
                delete_pdp_ctx_request__elem_ = nullptr;
                if ( delete_pdp_ctx_request() ) {
                    for ( auto* delete_pdp_ctx_request__elem_ : *delete_pdp_ctx_request() ) {
                        delete delete_pdp_ctx_request__elem_;
                        delete_pdp_ctx_request__elem_ = nullptr;
                    }
                }
                delete delete_pdp_ctx_request_;
            }
            break;
        case ((uint8)21):
            // Clean up "delete_pdp_ctx_response"
            {
                delete delete_pdp_ctx_response__elem_;
                delete_pdp_ctx_response__elem_ = nullptr;
                if ( delete_pdp_ctx_response() ) {
                    for ( auto* delete_pdp_ctx_response__elem_ : *delete_pdp_ctx_response() ) {
                        delete delete_pdp_ctx_response__elem_;
                        delete_pdp_ctx_response__elem_ = nullptr;
                    }
                }
                delete delete_pdp_ctx_response_;
            }
            break;
        case ((uint8)255):
            // Clean up "packet"
            {
                packet_.free();
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int GTPv1_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGTPv1* t_context) {
    sourcedata_ = const_bytestring(t_begin_of_data, t_end_of_data);
    // Checking out-of-bound for "GTPv1_Header:teid"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GTPv1_Header:teid",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flags"
    flags_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "msg_type"
    msg_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "length"
    length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "teid"
    teid_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "opt"
    int t_opt__size;
    has_opt_ = flags() & 0x07;
    opt_case_index_ = has_opt();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( opt_case_index() ) {
        case true:
            // Parse "opt_hdr"
            {
                opt_hdr_ = new GTPv1_Opt_Header();
                opt_hdr_->Parse((t_begin_of_data + 8), t_end_of_data, byteorder());
                t_opt__size = 4;
            }
            break;
        case false:
            // Parse "no_opt"
            {
                t_opt__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("GTPv1_Header", (int64)opt_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_opt = (t_begin_of_data + 8) + (t_opt__size);
    BINPAC_ASSERT(t_dataptr_after_opt <= t_end_of_data);
    // Parse "ext"
    int t_ext__size;
    e_flag_ = flags() & 0x04;
    ext_case_index_ = e_flag();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( ext_case_index() ) {
        case true:
            // Parse "ext_hdrs"
            {
                int t_ext_hdrs__arraylength;
                t_ext_hdrs__arraylength = 0;
                ext_hdrs__elem_ = nullptr;
                int t_ext_hdrs__elem__it;
                t_ext_hdrs__elem__it = 0;
                int t_ext_hdrs__size;
                ext_hdrs_ = new vector<GTPv1_Ext_Header*>;
                const_byteptr t_ext_hdrs__elem__dataptr = t_dataptr_after_opt;
                for (; /* forever */; ++t_ext_hdrs__elem__it) {
                    // Check &until(ext_hdrs__elem__dataptr >= end_of_data)
                    if ( t_ext_hdrs__elem__dataptr >= t_end_of_data ) {
                        ext_hdrs__elem_ = nullptr;
                        goto end_of_ext_hdrs;
                    }
                    ext_hdrs__elem_ = new GTPv1_Ext_Header();
                    int t_ext_hdrs__elem__size;
                    t_ext_hdrs__elem__size = ext_hdrs__elem_->Parse(t_ext_hdrs__elem__dataptr, t_end_of_data);
                    ext_hdrs_->push_back(ext_hdrs__elem_);
                    t_ext_hdrs__elem__dataptr += t_ext_hdrs__elem__size;
                    BINPAC_ASSERT(t_ext_hdrs__elem__dataptr <= t_end_of_data);
                    // Check &until( ( @$element->next_type@ == ((int) 0) ) )
                    if (  ( ext_hdrs__elem_->next_type() == 0 )  ) {
                        ext_hdrs__elem_ = nullptr;
                        goto end_of_ext_hdrs;
                    }
                    ext_hdrs__elem_ = nullptr;
                }
            end_of_ext_hdrs: ;
                t_ext_hdrs__size = t_ext_hdrs__elem__dataptr - (t_dataptr_after_opt);
                // Evaluate 'let' and 'withinput' fields
                t_ext__size = t_ext_hdrs__size;
            }
            break;
        case false:
            // Parse "no_ext"
            {
                t_ext__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("GTPv1_Header", (int64)ext_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_ext = t_dataptr_after_opt + (t_ext__size);
    BINPAC_ASSERT(t_dataptr_after_ext <= t_end_of_data);
    // Parse "msg"
    int t_msg__size;
    msg_case_index_ = msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_case_index() ) {
        case ((uint8)16):
            // Parse "create_pdp_ctx_request"
            {
                int t_create_pdp_ctx_request__arraylength;
                t_create_pdp_ctx_request__arraylength = 0;
                create_pdp_ctx_request__elem_ = nullptr;
                int t_create_pdp_ctx_request__elem__it;
                t_create_pdp_ctx_request__elem__it = 0;
                int t_create_pdp_ctx_request__size;
                create_pdp_ctx_request_ = new vector<InformationElement*>;
                const_byteptr t_create_pdp_ctx_request__elem__dataptr = t_dataptr_after_ext;
                for (; /* forever */; ++t_create_pdp_ctx_request__elem__it) {
                    // Check &until(create_pdp_ctx_request__elem__dataptr >= end_of_data)
                    if ( t_create_pdp_ctx_request__elem__dataptr >= t_end_of_data ) {
                        create_pdp_ctx_request__elem_ = nullptr;
                        goto end_of_create_pdp_ctx_request;
                    }
                    create_pdp_ctx_request__elem_ = new InformationElement();
                    int t_create_pdp_ctx_request__elem__size;
                    t_create_pdp_ctx_request__elem__size = create_pdp_ctx_request__elem_->Parse(t_create_pdp_ctx_request__elem__dataptr, t_end_of_data, byteorder());
                    create_pdp_ctx_request_->push_back(create_pdp_ctx_request__elem_);
                    t_create_pdp_ctx_request__elem__dataptr += t_create_pdp_ctx_request__elem__size;
                    BINPAC_ASSERT(t_create_pdp_ctx_request__elem__dataptr <= t_end_of_data);
                    create_pdp_ctx_request__elem_ = nullptr;
                }
            end_of_create_pdp_ctx_request: ;
                t_create_pdp_ctx_request__size = t_create_pdp_ctx_request__elem__dataptr - (t_dataptr_after_ext);
                // Evaluate 'let' and 'withinput' fields
                t_msg__size = t_create_pdp_ctx_request__size;
            }
            break;
        case ((uint8)17):
            // Parse "create_pdp_ctx_response"
            {
                int t_create_pdp_ctx_response__arraylength;
                t_create_pdp_ctx_response__arraylength = 0;
                create_pdp_ctx_response__elem_ = nullptr;
                int t_create_pdp_ctx_response__elem__it;
                t_create_pdp_ctx_response__elem__it = 0;
                int t_create_pdp_ctx_response__size;
                create_pdp_ctx_response_ = new vector<InformationElement*>;
                const_byteptr t_create_pdp_ctx_response__elem__dataptr = t_dataptr_after_ext;
                for (; /* forever */; ++t_create_pdp_ctx_response__elem__it) {
                    // Check &until(create_pdp_ctx_response__elem__dataptr >= end_of_data)
                    if ( t_create_pdp_ctx_response__elem__dataptr >= t_end_of_data ) {
                        create_pdp_ctx_response__elem_ = nullptr;
                        goto end_of_create_pdp_ctx_response;
                    }
                    create_pdp_ctx_response__elem_ = new InformationElement();
                    int t_create_pdp_ctx_response__elem__size;
                    t_create_pdp_ctx_response__elem__size = create_pdp_ctx_response__elem_->Parse(t_create_pdp_ctx_response__elem__dataptr, t_end_of_data, byteorder());
                    create_pdp_ctx_response_->push_back(create_pdp_ctx_response__elem_);
                    t_create_pdp_ctx_response__elem__dataptr += t_create_pdp_ctx_response__elem__size;
                    BINPAC_ASSERT(t_create_pdp_ctx_response__elem__dataptr <= t_end_of_data);
                    create_pdp_ctx_response__elem_ = nullptr;
                }
            end_of_create_pdp_ctx_response: ;
                t_create_pdp_ctx_response__size = t_create_pdp_ctx_response__elem__dataptr - (t_dataptr_after_ext);
                // Evaluate 'let' and 'withinput' fields
                t_msg__size = t_create_pdp_ctx_response__size;
            }
            break;
        case ((uint8)18):
            // Parse "update_pdp_ctx_request"
            {
                int t_update_pdp_ctx_request__arraylength;
                t_update_pdp_ctx_request__arraylength = 0;
                update_pdp_ctx_request__elem_ = nullptr;
                int t_update_pdp_ctx_request__elem__it;
                t_update_pdp_ctx_request__elem__it = 0;
                int t_update_pdp_ctx_request__size;
                update_pdp_ctx_request_ = new vector<InformationElement*>;
                const_byteptr t_update_pdp_ctx_request__elem__dataptr = t_dataptr_after_ext;
                for (; /* forever */; ++t_update_pdp_ctx_request__elem__it) {
                    // Check &until(update_pdp_ctx_request__elem__dataptr >= end_of_data)
                    if ( t_update_pdp_ctx_request__elem__dataptr >= t_end_of_data ) {
                        update_pdp_ctx_request__elem_ = nullptr;
                        goto end_of_update_pdp_ctx_request;
                    }
                    update_pdp_ctx_request__elem_ = new InformationElement();
                    int t_update_pdp_ctx_request__elem__size;
                    t_update_pdp_ctx_request__elem__size = update_pdp_ctx_request__elem_->Parse(t_update_pdp_ctx_request__elem__dataptr, t_end_of_data, byteorder());
                    update_pdp_ctx_request_->push_back(update_pdp_ctx_request__elem_);
                    t_update_pdp_ctx_request__elem__dataptr += t_update_pdp_ctx_request__elem__size;
                    BINPAC_ASSERT(t_update_pdp_ctx_request__elem__dataptr <= t_end_of_data);
                    update_pdp_ctx_request__elem_ = nullptr;
                }
            end_of_update_pdp_ctx_request: ;
                t_update_pdp_ctx_request__size = t_update_pdp_ctx_request__elem__dataptr - (t_dataptr_after_ext);
                // Evaluate 'let' and 'withinput' fields
                t_msg__size = t_update_pdp_ctx_request__size;
            }
            break;
        case ((uint8)19):
            // Parse "update_pdp_ctx_response"
            {
                int t_update_pdp_ctx_response__arraylength;
                t_update_pdp_ctx_response__arraylength = 0;
                update_pdp_ctx_response__elem_ = nullptr;
                int t_update_pdp_ctx_response__elem__it;
                t_update_pdp_ctx_response__elem__it = 0;
                int t_update_pdp_ctx_response__size;
                update_pdp_ctx_response_ = new vector<InformationElement*>;
                const_byteptr t_update_pdp_ctx_response__elem__dataptr = t_dataptr_after_ext;
                for (; /* forever */; ++t_update_pdp_ctx_response__elem__it) {
                    // Check &until(update_pdp_ctx_response__elem__dataptr >= end_of_data)
                    if ( t_update_pdp_ctx_response__elem__dataptr >= t_end_of_data ) {
                        update_pdp_ctx_response__elem_ = nullptr;
                        goto end_of_update_pdp_ctx_response;
                    }
                    update_pdp_ctx_response__elem_ = new InformationElement();
                    int t_update_pdp_ctx_response__elem__size;
                    t_update_pdp_ctx_response__elem__size = update_pdp_ctx_response__elem_->Parse(t_update_pdp_ctx_response__elem__dataptr, t_end_of_data, byteorder());
                    update_pdp_ctx_response_->push_back(update_pdp_ctx_response__elem_);
                    t_update_pdp_ctx_response__elem__dataptr += t_update_pdp_ctx_response__elem__size;
                    BINPAC_ASSERT(t_update_pdp_ctx_response__elem__dataptr <= t_end_of_data);
                    update_pdp_ctx_response__elem_ = nullptr;
                }
            end_of_update_pdp_ctx_response: ;
                t_update_pdp_ctx_response__size = t_update_pdp_ctx_response__elem__dataptr - (t_dataptr_after_ext);
                // Evaluate 'let' and 'withinput' fields
                t_msg__size = t_update_pdp_ctx_response__size;
            }
            break;
        case ((uint8)20):
            // Parse "delete_pdp_ctx_request"
            {
                int t_delete_pdp_ctx_request__arraylength;
                t_delete_pdp_ctx_request__arraylength = 0;
                delete_pdp_ctx_request__elem_ = nullptr;
                int t_delete_pdp_ctx_request__elem__it;
                t_delete_pdp_ctx_request__elem__it = 0;
                int t_delete_pdp_ctx_request__size;
                delete_pdp_ctx_request_ = new vector<InformationElement*>;
                const_byteptr t_delete_pdp_ctx_request__elem__dataptr = t_dataptr_after_ext;
                for (; /* forever */; ++t_delete_pdp_ctx_request__elem__it) {
                    // Check &until(delete_pdp_ctx_request__elem__dataptr >= end_of_data)
                    if ( t_delete_pdp_ctx_request__elem__dataptr >= t_end_of_data ) {
                        delete_pdp_ctx_request__elem_ = nullptr;
                        goto end_of_delete_pdp_ctx_request;
                    }
                    delete_pdp_ctx_request__elem_ = new InformationElement();
                    int t_delete_pdp_ctx_request__elem__size;
                    t_delete_pdp_ctx_request__elem__size = delete_pdp_ctx_request__elem_->Parse(t_delete_pdp_ctx_request__elem__dataptr, t_end_of_data, byteorder());
                    delete_pdp_ctx_request_->push_back(delete_pdp_ctx_request__elem_);
                    t_delete_pdp_ctx_request__elem__dataptr += t_delete_pdp_ctx_request__elem__size;
                    BINPAC_ASSERT(t_delete_pdp_ctx_request__elem__dataptr <= t_end_of_data);
                    delete_pdp_ctx_request__elem_ = nullptr;
                }
            end_of_delete_pdp_ctx_request: ;
                t_delete_pdp_ctx_request__size = t_delete_pdp_ctx_request__elem__dataptr - (t_dataptr_after_ext);
                // Evaluate 'let' and 'withinput' fields
                t_msg__size = t_delete_pdp_ctx_request__size;
            }
            break;
        case ((uint8)21):
            // Parse "delete_pdp_ctx_response"
            {
                int t_delete_pdp_ctx_response__arraylength;
                t_delete_pdp_ctx_response__arraylength = 0;
                delete_pdp_ctx_response__elem_ = nullptr;
                int t_delete_pdp_ctx_response__elem__it;
                t_delete_pdp_ctx_response__elem__it = 0;
                int t_delete_pdp_ctx_response__size;
                delete_pdp_ctx_response_ = new vector<InformationElement*>;
                const_byteptr t_delete_pdp_ctx_response__elem__dataptr = t_dataptr_after_ext;
                for (; /* forever */; ++t_delete_pdp_ctx_response__elem__it) {
                    // Check &until(delete_pdp_ctx_response__elem__dataptr >= end_of_data)
                    if ( t_delete_pdp_ctx_response__elem__dataptr >= t_end_of_data ) {
                        delete_pdp_ctx_response__elem_ = nullptr;
                        goto end_of_delete_pdp_ctx_response;
                    }
                    delete_pdp_ctx_response__elem_ = new InformationElement();
                    int t_delete_pdp_ctx_response__elem__size;
                    t_delete_pdp_ctx_response__elem__size = delete_pdp_ctx_response__elem_->Parse(t_delete_pdp_ctx_response__elem__dataptr, t_end_of_data, byteorder());
                    delete_pdp_ctx_response_->push_back(delete_pdp_ctx_response__elem_);
                    t_delete_pdp_ctx_response__elem__dataptr += t_delete_pdp_ctx_response__elem__size;
                    BINPAC_ASSERT(t_delete_pdp_ctx_response__elem__dataptr <= t_end_of_data);
                    delete_pdp_ctx_response__elem_ = nullptr;
                }
            end_of_delete_pdp_ctx_response: ;
                t_delete_pdp_ctx_response__size = t_delete_pdp_ctx_response__elem__dataptr - (t_dataptr_after_ext);
                // Evaluate 'let' and 'withinput' fields
                t_msg__size = t_delete_pdp_ctx_response__size;
            }
            break;
        case ((uint8)255):
            // Parse "packet"
            {
                int t_packet_string_length;
                t_packet_string_length = (t_end_of_data) - (t_dataptr_after_ext);
                int t_packet__size;
                t_packet__size = t_packet_string_length;
                // check for negative sizes
                if ( t_packet_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:25", t_packet_string_length);
                packet_.init(t_dataptr_after_ext, t_packet_string_length);
                t_msg__size = t_packet__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown_string_length;
                t_unknown_string_length = (t_end_of_data) - (t_dataptr_after_ext);
                int t_unknown__size;
                t_unknown__size = t_unknown_string_length;
                // check for negative sizes
                if ( t_unknown_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:26", t_unknown_string_length);
                unknown_.init(t_dataptr_after_ext, t_unknown_string_length);
                t_msg__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_GTPv1_Header__size;
    const_byteptr const t_dataptr_after_msg = t_dataptr_after_ext + (t_msg__size);
    BINPAC_ASSERT(t_dataptr_after_msg <= t_end_of_data);
    t_GTPv1_Header__size = t_dataptr_after_msg - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    version_ =  ( flags() & 0xE0 )  >> 5;
    pt_flag_ = flags() & 0x10;
    rsv_ = flags() & 0x08;
    s_flag_ = flags() & 0x02;
    pn_flag_ = flags() & 0x01;
    proc_gtpv1_ = t_context->flow()->process_gtpv1(this);
    sourcedata_.set_end(t_begin_of_data + t_GTPv1_Header__size);
    BINPAC_ASSERT(t_begin_of_data + (t_GTPv1_Header__size) <= t_end_of_data);
    return t_GTPv1_Header__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GTPv1_Opt_Header::GTPv1_Opt_Header() {
    seq_ = 0;
    n_pdu_ = 0;
    next_type_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GTPv1_Opt_Header::~GTPv1_Opt_Header() {
}

int GTPv1_Opt_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "GTPv1_Opt_Header"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GTPv1_Opt_Header",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "seq"
    seq_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "n_pdu"
    n_pdu_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "next_type"
    next_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GTPv1_Ext_Header::GTPv1_Ext_Header() {
    length_ = 0;
    next_type_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GTPv1_Ext_Header::~GTPv1_Ext_Header() {
    contents_.free();
}

int GTPv1_Ext_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "GTPv1_Ext_Header:length"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GTPv1_Ext_Header:length",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "contents"
    int t_contents__size;
    t_contents__size =  ( length() * 4 - 2 ) ;
    // Checking out-of-bound for "GTPv1_Ext_Header:contents"
    if ( (t_begin_of_data + 1) + (t_contents__size) > t_end_of_data || (t_begin_of_data + 1) + (t_contents__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GTPv1_Ext_Header:contents",
        	(1) + (t_contents__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_contents__size;
        int t_contents_string_length;
        t_contents_string_length =  ( length() * 4 - 2 ) ;
        // check for negative sizes
        if ( t_contents_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:47", t_contents_string_length);
        contents_.init((t_begin_of_data + 1), t_contents_string_length);
    }

    const_byteptr const t_dataptr_after_contents = (t_begin_of_data + 1) + (t_contents__size);
    BINPAC_ASSERT(t_dataptr_after_contents <= t_end_of_data);
    // Checking out-of-bound for "GTPv1_Ext_Header:next_type"
    if ( t_dataptr_after_contents + (1) > t_end_of_data || t_dataptr_after_contents + (1) < t_dataptr_after_contents ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GTPv1_Ext_Header:next_type",
        	((t_dataptr_after_contents - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "next_type"
    next_type_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_contents));

    int t_GTPv1_Ext_Header__size;
    t_GTPv1_Ext_Header__size = (t_dataptr_after_contents + 1) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_GTPv1_Ext_Header__size) <= t_end_of_data);
    return t_GTPv1_Ext_Header__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
InformationElement::InformationElement() {
    type_ = 0;
    len_case_index_ = -1;
    tlv_len_ = 0;
    value_case_index_ = -1;
    cause_ = nullptr;
    imsi_ = nullptr;
    rai_ = nullptr;
    tlli_ = nullptr;
    p_tmsi_ = nullptr;
    reorder_req_ = nullptr;
    authn_triplet_ = nullptr;
    map_cause_ = nullptr;
    p_tmsi_sig_ = nullptr;
    ms_valid_ = nullptr;
    recovery_ = nullptr;
    selection_mode_ = nullptr;
    teid1_ = nullptr;
    teidcp_ = nullptr;
    teid2_ = nullptr;
    teardown_ind_ = nullptr;
    nsapi_ = nullptr;
    ranap_cause_ = nullptr;
    rab_ctx_ = nullptr;
    radio_priority_sms_ = nullptr;
    radio_priority_ = nullptr;
    packet_flow_id_ = nullptr;
    charging_characteristics_ = nullptr;
    trace_reference_ = nullptr;
    trace_type_ = nullptr;
    ms_not_reachable_reason_ = nullptr;
    charging_id_ = nullptr;
    end_user_addr_ = nullptr;
    mm_ctx_ = nullptr;
    pdp_ctx_ = nullptr;
    ap_name_ = nullptr;
    proto_config_opts_ = nullptr;
    gsn_addr_ = nullptr;
    msisdn_ = nullptr;
    qos_profile_ = nullptr;
    authn_quintuplet_ = nullptr;
    traffic_flow_template_ = nullptr;
    target_id_ = nullptr;
    utran_transparent_container_ = nullptr;
    rab_setup_info_ = nullptr;
    ext_hdr_type_list_ = nullptr;
    trigger_id_ = nullptr;
    omc_id_ = nullptr;
    charging_gateway_addr_ = nullptr;
    private_ext_ = nullptr;
    is_tlv_ = false;
    length_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
InformationElement::~InformationElement() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( len_case_index() ) {
        case true:
            // Clean up "tlv_len"
            {
            }
            break;
        case false:
            // Clean up "no_len"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( value_case_index() ) {
        case ((uint8)1):
            // Clean up "cause"
            {
                delete cause_;
                cause_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "imsi"
            {
                delete imsi_;
                imsi_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "rai"
            {
                delete rai_;
                rai_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "tlli"
            {
                delete tlli_;
                tlli_ = nullptr;
            }
            break;
        case ((uint8)5):
            // Clean up "p_tmsi"
            {
                delete p_tmsi_;
                p_tmsi_ = nullptr;
            }
            break;
        case ((uint8)8):
            // Clean up "reorder_req"
            {
                delete reorder_req_;
                reorder_req_ = nullptr;
            }
            break;
        case ((uint8)9):
            // Clean up "authn_triplet"
            {
                delete authn_triplet_;
                authn_triplet_ = nullptr;
            }
            break;
        case ((uint8)11):
            // Clean up "map_cause"
            {
                delete map_cause_;
                map_cause_ = nullptr;
            }
            break;
        case ((uint8)12):
            // Clean up "p_tmsi_sig"
            {
                delete p_tmsi_sig_;
                p_tmsi_sig_ = nullptr;
            }
            break;
        case ((uint8)13):
            // Clean up "ms_valid"
            {
                delete ms_valid_;
                ms_valid_ = nullptr;
            }
            break;
        case ((uint8)14):
            // Clean up "recovery"
            {
                delete recovery_;
                recovery_ = nullptr;
            }
            break;
        case ((uint8)15):
            // Clean up "selection_mode"
            {
                delete selection_mode_;
                selection_mode_ = nullptr;
            }
            break;
        case ((uint8)16):
            // Clean up "teid1"
            {
                delete teid1_;
                teid1_ = nullptr;
            }
            break;
        case ((uint8)17):
            // Clean up "teidcp"
            {
                delete teidcp_;
                teidcp_ = nullptr;
            }
            break;
        case ((uint8)18):
            // Clean up "teid2"
            {
                delete teid2_;
                teid2_ = nullptr;
            }
            break;
        case ((uint8)19):
            // Clean up "teardown_ind"
            {
                delete teardown_ind_;
                teardown_ind_ = nullptr;
            }
            break;
        case ((uint8)20):
            // Clean up "nsapi"
            {
                delete nsapi_;
                nsapi_ = nullptr;
            }
            break;
        case ((uint8)21):
            // Clean up "ranap_cause"
            {
                delete ranap_cause_;
                ranap_cause_ = nullptr;
            }
            break;
        case ((uint8)22):
            // Clean up "rab_ctx"
            {
                delete rab_ctx_;
                rab_ctx_ = nullptr;
            }
            break;
        case ((uint8)23):
            // Clean up "radio_priority_sms"
            {
                delete radio_priority_sms_;
                radio_priority_sms_ = nullptr;
            }
            break;
        case ((uint8)24):
            // Clean up "radio_priority"
            {
                delete radio_priority_;
                radio_priority_ = nullptr;
            }
            break;
        case ((uint8)25):
            // Clean up "packet_flow_id"
            {
                delete packet_flow_id_;
                packet_flow_id_ = nullptr;
            }
            break;
        case ((uint8)26):
            // Clean up "charging_characteristics"
            {
                delete charging_characteristics_;
                charging_characteristics_ = nullptr;
            }
            break;
        case ((uint8)27):
            // Clean up "trace_reference"
            {
                delete trace_reference_;
                trace_reference_ = nullptr;
            }
            break;
        case ((uint8)28):
            // Clean up "trace_type"
            {
                delete trace_type_;
                trace_type_ = nullptr;
            }
            break;
        case ((uint8)29):
            // Clean up "ms_not_reachable_reason"
            {
                delete ms_not_reachable_reason_;
                ms_not_reachable_reason_ = nullptr;
            }
            break;
        case ((uint8)127):
            // Clean up "charging_id"
            {
                delete charging_id_;
                charging_id_ = nullptr;
            }
            break;
        case ((uint8)128):
            // Clean up "end_user_addr"
            {
                delete end_user_addr_;
                end_user_addr_ = nullptr;
            }
            break;
        case ((uint8)129):
            // Clean up "mm_ctx"
            {
                delete mm_ctx_;
                mm_ctx_ = nullptr;
            }
            break;
        case ((uint8)130):
            // Clean up "pdp_ctx"
            {
                delete pdp_ctx_;
                pdp_ctx_ = nullptr;
            }
            break;
        case ((uint8)131):
            // Clean up "ap_name"
            {
                delete ap_name_;
                ap_name_ = nullptr;
            }
            break;
        case ((uint8)132):
            // Clean up "proto_config_opts"
            {
                delete proto_config_opts_;
                proto_config_opts_ = nullptr;
            }
            break;
        case ((uint8)133):
            // Clean up "gsn_addr"
            {
                delete gsn_addr_;
                gsn_addr_ = nullptr;
            }
            break;
        case ((uint8)134):
            // Clean up "msisdn"
            {
                delete msisdn_;
                msisdn_ = nullptr;
            }
            break;
        case ((uint8)135):
            // Clean up "qos_profile"
            {
                delete qos_profile_;
                qos_profile_ = nullptr;
            }
            break;
        case ((uint8)136):
            // Clean up "authn_quintuplet"
            {
                delete authn_quintuplet_;
                authn_quintuplet_ = nullptr;
            }
            break;
        case ((uint8)137):
            // Clean up "traffic_flow_template"
            {
                delete traffic_flow_template_;
                traffic_flow_template_ = nullptr;
            }
            break;
        case ((uint8)138):
            // Clean up "target_id"
            {
                delete target_id_;
                target_id_ = nullptr;
            }
            break;
        case ((uint8)139):
            // Clean up "utran_transparent_container"
            {
                delete utran_transparent_container_;
                utran_transparent_container_ = nullptr;
            }
            break;
        case ((uint8)140):
            // Clean up "rab_setup_info"
            {
                delete rab_setup_info_;
                rab_setup_info_ = nullptr;
            }
            break;
        case ((uint8)141):
            // Clean up "ext_hdr_type_list"
            {
                delete ext_hdr_type_list_;
                ext_hdr_type_list_ = nullptr;
            }
            break;
        case ((uint8)142):
            // Clean up "trigger_id"
            {
                delete trigger_id_;
                trigger_id_ = nullptr;
            }
            break;
        case ((uint8)143):
            // Clean up "omc_id"
            {
                delete omc_id_;
                omc_id_ = nullptr;
            }
            break;
        case ((uint8)251):
            // Clean up "charging_gateway_addr"
            {
                delete charging_gateway_addr_;
                charging_gateway_addr_ = nullptr;
            }
            break;
        case ((uint8)255):
            // Clean up "private_ext"
            {
                delete private_ext_;
                private_ext_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int InformationElement::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "InformationElement:type"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("InformationElement:type",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "type"
    type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "len"
    int t_len__size;
    is_tlv_ =  ( type() & 0x80 ) ;
    len_case_index_ = is_tlv();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( len_case_index() ) {
        case true:
            // Parse "tlv_len"
            {
                // Checking out-of-bound for "InformationElement:tlv_len"
                if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("InformationElement:tlv_len",
                    	(1) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                tlv_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));
                t_len__size = 2;
            }
            break;
        case false:
            // Parse "no_len"
            {
                t_len__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("InformationElement", (int64)len_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_len = (t_begin_of_data + 1) + (t_len__size);
    BINPAC_ASSERT(t_dataptr_after_len <= t_end_of_data);
    // Parse "value"
    length_ = is_tlv() ? tlv_len() : Get_IE_Len(type());
    int t_value__size;
    value_case_index_ = type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( value_case_index() ) {
        case ((uint8)1):
            // Parse "cause"
            {
                cause_ = new Cause();
                cause_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)2):
            // Parse "imsi"
            {
                imsi_ = new IMSI();
                imsi_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 8;
            }
            break;
        case ((uint8)3):
            // Parse "rai"
            {
                rai_ = new RAI();
                rai_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = 6;
            }
            break;
        case ((uint8)4):
            // Parse "tlli"
            {
                tlli_ = new TLLI();
                tlli_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = 4;
            }
            break;
        case ((uint8)5):
            // Parse "p_tmsi"
            {
                p_tmsi_ = new P_TMSI();
                p_tmsi_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = 4;
            }
            break;
        case ((uint8)8):
            // Parse "reorder_req"
            {
                reorder_req_ = new ReorderReq();
                reorder_req_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)9):
            // Parse "authn_triplet"
            {
                authn_triplet_ = new AuthN_Triplet();
                int t_authn_triplet__size;
                t_authn_triplet__size = authn_triplet_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = t_authn_triplet__size;
            }
            break;
        case ((uint8)11):
            // Parse "map_cause"
            {
                map_cause_ = new MAP_Cause();
                map_cause_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)12):
            // Parse "p_tmsi_sig"
            {
                p_tmsi_sig_ = new P_TMSI_Sig();
                int t_p_tmsi_sig__size;
                t_p_tmsi_sig__size = p_tmsi_sig_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_p_tmsi_sig__size;
            }
            break;
        case ((uint8)13):
            // Parse "ms_valid"
            {
                ms_valid_ = new MS_Valid();
                ms_valid_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)14):
            // Parse "recovery"
            {
                recovery_ = new Recovery();
                recovery_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)15):
            // Parse "selection_mode"
            {
                selection_mode_ = new SelectionMode();
                selection_mode_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)16):
            // Parse "teid1"
            {
                teid1_ = new TEID1();
                teid1_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = 4;
            }
            break;
        case ((uint8)17):
            // Parse "teidcp"
            {
                teidcp_ = new TEID_ControlPlane();
                teidcp_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = 4;
            }
            break;
        case ((uint8)18):
            // Parse "teid2"
            {
                teid2_ = new TEID2();
                teid2_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = 5;
            }
            break;
        case ((uint8)19):
            // Parse "teardown_ind"
            {
                teardown_ind_ = new TeardownInd();
                teardown_ind_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)20):
            // Parse "nsapi"
            {
                nsapi_ = new NSAPI();
                nsapi_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)21):
            // Parse "ranap_cause"
            {
                ranap_cause_ = new RANAP_Cause();
                ranap_cause_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)22):
            // Parse "rab_ctx"
            {
                rab_ctx_ = new RAB_Ctx();
                rab_ctx_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = 9;
            }
            break;
        case ((uint8)23):
            // Parse "radio_priority_sms"
            {
                radio_priority_sms_ = new RadioPrioritySMS();
                radio_priority_sms_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)24):
            // Parse "radio_priority"
            {
                radio_priority_ = new RadioPriority();
                radio_priority_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)25):
            // Parse "packet_flow_id"
            {
                packet_flow_id_ = new PacketFlowID();
                packet_flow_id_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 2;
            }
            break;
        case ((uint8)26):
            // Parse "charging_characteristics"
            {
                charging_characteristics_ = new ChargingCharacteristics();
                charging_characteristics_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = 2;
            }
            break;
        case ((uint8)27):
            // Parse "trace_reference"
            {
                trace_reference_ = new TraceReference();
                trace_reference_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = 2;
            }
            break;
        case ((uint8)28):
            // Parse "trace_type"
            {
                trace_type_ = new TraceType();
                trace_type_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = 2;
            }
            break;
        case ((uint8)29):
            // Parse "ms_not_reachable_reason"
            {
                ms_not_reachable_reason_ = new MS_Not_Reachable_Reason();
                ms_not_reachable_reason_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = 1;
            }
            break;
        case ((uint8)127):
            // Parse "charging_id"
            {
                charging_id_ = new ChargingID();
                charging_id_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = 4;
            }
            break;
        case ((uint8)128):
            // Parse "end_user_addr"
            {
                end_user_addr_ = new EndUserAddr(length());
                int t_end_user_addr__size;
                t_end_user_addr__size = end_user_addr_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_end_user_addr__size;
            }
            break;
        case ((uint8)129):
            // Parse "mm_ctx"
            {
                mm_ctx_ = new MM_Ctx(length());
                int t_mm_ctx__size;
                t_mm_ctx__size = mm_ctx_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = t_mm_ctx__size;
            }
            break;
        case ((uint8)130):
            // Parse "pdp_ctx"
            {
                pdp_ctx_ = new PDP_Ctx(length());
                int t_pdp_ctx__size;
                t_pdp_ctx__size = pdp_ctx_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = t_pdp_ctx__size;
            }
            break;
        case ((uint8)131):
            // Parse "ap_name"
            {
                ap_name_ = new AP_Name(length());
                int t_ap_name__size;
                t_ap_name__size = ap_name_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_ap_name__size;
            }
            break;
        case ((uint8)132):
            // Parse "proto_config_opts"
            {
                proto_config_opts_ = new ProtoConfigOpts(length());
                int t_proto_config_opts__size;
                t_proto_config_opts__size = proto_config_opts_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_proto_config_opts__size;
            }
            break;
        case ((uint8)133):
            // Parse "gsn_addr"
            {
                gsn_addr_ = new GSN_Addr(length());
                int t_gsn_addr__size;
                t_gsn_addr__size = gsn_addr_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_gsn_addr__size;
            }
            break;
        case ((uint8)134):
            // Parse "msisdn"
            {
                msisdn_ = new MSISDN(length());
                int t_msisdn__size;
                t_msisdn__size = msisdn_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_msisdn__size;
            }
            break;
        case ((uint8)135):
            // Parse "qos_profile"
            {
                qos_profile_ = new QoS_Profile(length());
                int t_qos_profile__size;
                t_qos_profile__size = qos_profile_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_qos_profile__size;
            }
            break;
        case ((uint8)136):
            // Parse "authn_quintuplet"
            {
                authn_quintuplet_ = new AuthN_Quintuplet(length());
                int t_authn_quintuplet__size;
                t_authn_quintuplet__size = authn_quintuplet_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_authn_quintuplet__size;
            }
            break;
        case ((uint8)137):
            // Parse "traffic_flow_template"
            {
                traffic_flow_template_ = new TrafficFlowTemplate(length());
                int t_traffic_flow_template__size;
                t_traffic_flow_template__size = traffic_flow_template_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_traffic_flow_template__size;
            }
            break;
        case ((uint8)138):
            // Parse "target_id"
            {
                target_id_ = new TargetID(length());
                int t_target_id__size;
                t_target_id__size = target_id_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_target_id__size;
            }
            break;
        case ((uint8)139):
            // Parse "utran_transparent_container"
            {
                utran_transparent_container_ = new UTRAN_TransparentContainer(length());
                int t_utran_transparent_container__size;
                t_utran_transparent_container__size = utran_transparent_container_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_utran_transparent_container__size;
            }
            break;
        case ((uint8)140):
            // Parse "rab_setup_info"
            {
                rab_setup_info_ = new RAB_SetupInfo(length());
                int t_rab_setup_info__size;
                t_rab_setup_info__size = rab_setup_info_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = t_rab_setup_info__size;
            }
            break;
        case ((uint8)141):
            // Parse "ext_hdr_type_list"
            {
                ext_hdr_type_list_ = new ExtHdrTypeList(length());
                int t_ext_hdr_type_list__size;
                t_ext_hdr_type_list__size = ext_hdr_type_list_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_ext_hdr_type_list__size;
            }
            break;
        case ((uint8)142):
            // Parse "trigger_id"
            {
                trigger_id_ = new TriggerID(length());
                int t_trigger_id__size;
                t_trigger_id__size = trigger_id_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_trigger_id__size;
            }
            break;
        case ((uint8)143):
            // Parse "omc_id"
            {
                omc_id_ = new OMC_ID(length());
                int t_omc_id__size;
                t_omc_id__size = omc_id_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_omc_id__size;
            }
            break;
        case ((uint8)251):
            // Parse "charging_gateway_addr"
            {
                charging_gateway_addr_ = new ChargingGatewayAddr(length());
                int t_charging_gateway_addr__size;
                t_charging_gateway_addr__size = charging_gateway_addr_->Parse(t_dataptr_after_len, t_end_of_data);
                t_value__size = t_charging_gateway_addr__size;
            }
            break;
        case ((uint8)255):
            // Parse "private_ext"
            {
                private_ext_ = new PrivateExt(length());
                int t_private_ext__size;
                t_private_ext__size = private_ext_->Parse(t_dataptr_after_len, t_end_of_data, t_byteorder);
                t_value__size = t_private_ext__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown__size;
                t_unknown__size = length();
                // Checking out-of-bound for "InformationElement:unknown"
                if ( t_dataptr_after_len + (t_unknown__size) > t_end_of_data || t_dataptr_after_len + (t_unknown__size) < t_dataptr_after_len ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("InformationElement:unknown",
                    	((t_dataptr_after_len - t_begin_of_data)) + (t_unknown__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_len + t_unknown__size;
                    int t_unknown_string_length;
                    t_unknown_string_length = length();
                    // check for negative sizes
                    if ( t_unknown_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:153", t_unknown_string_length);
                    unknown_.init(t_dataptr_after_len, t_unknown_string_length);
                }
                t_value__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_InformationElement__size;
    const_byteptr const t_dataptr_after_value = t_dataptr_after_len + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_InformationElement__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_InformationElement__size) <= t_end_of_data);
    return t_InformationElement__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Cause::Cause() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Cause::~Cause() {
}

int Cause::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Cause"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Cause",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

uint64 decode_imsi(vector<uint8>* v) {

	uint64 rval = 0;
	uint8 digits[16];
	for ( size_t i = 0; i < v->size(); ++i )
		{
		digits[2 * i + 1] = ((*v)[i] & 0xf0) >> 4;
		digits[2 * i] = (*v)[i] & 0x0f;
		}
	int power = 0;
	for ( int i = 15; i >= 0; --i )
		{
		if ( digits[i] == 0x0f ) continue;
		rval += digits[i] * pow(10, power);
		++power;
		}
	return rval;
	
}

// NOLINTNEXTLINE(modernize-use-equals-default)
IMSI::IMSI() {
    tbcd_encoded_value_ = nullptr;
    tbcd_encoded_value__elem_ = 0;
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
IMSI::~IMSI() {
    delete tbcd_encoded_value_;
}

int IMSI::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "IMSI"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("IMSI",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "tbcd_encoded_value"
    int t_tbcd_encoded_value__arraylength;
    t_tbcd_encoded_value__arraylength = 8;
    if ( t_tbcd_encoded_value__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("IMSI:tbcd_encoded_value",
          t_tbcd_encoded_value__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: IMSI:tbcd_encoded_value
    if ( t_tbcd_encoded_value__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
        throw binpac::ExceptionOutOfBound("IMSI:tbcd_encoded_value",
          t_tbcd_encoded_value__arraylength, (t_end_of_data) - (t_begin_of_data));
    tbcd_encoded_value__elem_ = 0;
    int t_tbcd_encoded_value__elem__it;
    t_tbcd_encoded_value__elem__it = 0;
    tbcd_encoded_value_ = new vector<uint8>;
    tbcd_encoded_value_->reserve(t_tbcd_encoded_value__arraylength);
    const_byteptr t_tbcd_encoded_value__elem__dataptr = t_begin_of_data;
    for (; t_tbcd_encoded_value__elem__it < t_tbcd_encoded_value__arraylength; ++t_tbcd_encoded_value__elem__it) {
        tbcd_encoded_value__elem_ = *(reinterpret_cast<uint8 const*>(t_tbcd_encoded_value__elem__dataptr));
        tbcd_encoded_value_->push_back(tbcd_encoded_value__elem_);
        t_tbcd_encoded_value__elem__dataptr += 1;
        BINPAC_ASSERT(t_tbcd_encoded_value__elem__dataptr <= t_end_of_data);
    }
end_of_tbcd_encoded_value: ;
    // Evaluate 'let' and 'withinput' fields

    // Evaluate 'let' and 'withinput' fields
    value_ = decode_imsi(tbcd_encoded_value());
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RAI::RAI() {
    mcc2_mcc1_ = 0;
    mnc3_mcc3_ = 0;
    mnc2_mnc1_ = 0;
    lac_ = 0;
    rac_ = 0;
    mcc1_ = 0;
    mcc2_ = 0;
    mcc3_ = 0;
    mcc_ = 0;
    mnc1_ = 0;
    mnc2_ = 0;
    mnc3_ = 0;
    mnc_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RAI::~RAI() {
}

int RAI::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RAI"
    if ( t_begin_of_data + (6) > t_end_of_data || t_begin_of_data + (6) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RAI",
        	(0) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "mcc2_mcc1"
    mcc2_mcc1_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "mnc3_mcc3"
    mnc3_mcc3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "mnc2_mnc1"
    mnc2_mnc1_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "lac"
    lac_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "rac"
    rac_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 5)));

    // Evaluate 'let' and 'withinput' fields
    mcc1_ =  ( mcc2_mcc1() & 0x0f ) ;
    mcc2_ =  (  ( mcc2_mcc1() & 0xf0 )  >> 4 ) ;
    mcc3_ =  ( mnc3_mcc3() & 0x0f ) ;
    mcc_ = mcc1() * 100 + mcc2() * 10 + mcc3();
    mnc1_ =  ( mnc2_mnc1() & 0x0f ) ;
    mnc2_ =  (  ( mnc2_mnc1() & 0xf0 )  >> 4 ) ;
    mnc3_ =  ( mnc3_mcc3() & 0xf0 )  >> 4;
    mnc_ =  ( mnc3() & 0x0f )  ? mnc1() * 10 + mnc2() : mnc1() * 100 + mnc2() * 10 + mnc3();
    BINPAC_ASSERT(t_begin_of_data + (6) <= t_end_of_data);
    return 6;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TLLI::TLLI() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TLLI::~TLLI() {
}

int TLLI::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "TLLI"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("TLLI",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
P_TMSI::P_TMSI() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
P_TMSI::~P_TMSI() {
}

int P_TMSI::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "P_TMSI"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("P_TMSI",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ReorderReq::ReorderReq() {
    value_ = 0;
    req_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ReorderReq::~ReorderReq() {
}

int ReorderReq::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "ReorderReq"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ReorderReq",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    req_ = value() & 0x01;
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthN_Triplet::AuthN_Triplet() {
    sres_ = 0;
    kc_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthN_Triplet::~AuthN_Triplet() {
    rand_.free();
}

int AuthN_Triplet::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "rand"
    // Checking out-of-bound for "AuthN_Triplet:rand"
    if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthN_Triplet:rand",
        	(0) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 16;
        int t_rand_string_length;
        t_rand_string_length = 16;
        int t_rand__size;
        t_rand__size = t_rand_string_length;
        rand_.init(t_begin_of_data, t_rand_string_length);
    }

    const_byteptr const t_dataptr_after_rand = t_begin_of_data + (16);
    BINPAC_ASSERT(t_dataptr_after_rand <= t_end_of_data);
    // Checking out-of-bound for "AuthN_Triplet:kc"
    if ( (t_dataptr_after_rand + 4) + (8) > t_end_of_data || (t_dataptr_after_rand + 4) + (8) < (t_dataptr_after_rand + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthN_Triplet:kc",
        	(((t_dataptr_after_rand + 4) - t_begin_of_data)) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "sres"
    sres_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_rand)));

    // Parse "kc"
    kc_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_dataptr_after_rand + 4))));

    int t_AuthN_Triplet__size;
    t_AuthN_Triplet__size = (t_dataptr_after_rand + 12) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AuthN_Triplet__size) <= t_end_of_data);
    return t_AuthN_Triplet__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MAP_Cause::MAP_Cause() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MAP_Cause::~MAP_Cause() {
}

int MAP_Cause::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "MAP_Cause"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MAP_Cause",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
P_TMSI_Sig::P_TMSI_Sig() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
P_TMSI_Sig::~P_TMSI_Sig() {
    value_.free();
}

int P_TMSI_Sig::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    // Checking out-of-bound for "P_TMSI_Sig:value"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("P_TMSI_Sig:value",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 3;
        int t_value_string_length;
        t_value_string_length = 3;
        int t_value__size;
        t_value__size = t_value_string_length;
        value_.init(t_begin_of_data, t_value_string_length);
    }

    int t_P_TMSI_Sig__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (3);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_P_TMSI_Sig__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_P_TMSI_Sig__size) <= t_end_of_data);
    return t_P_TMSI_Sig__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MS_Valid::MS_Valid() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MS_Valid::~MS_Valid() {
}

int MS_Valid::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "MS_Valid"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MS_Valid",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Recovery::Recovery() {
    restart_counter_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Recovery::~Recovery() {
}

int Recovery::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Recovery"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Recovery",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "restart_counter"
    restart_counter_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SelectionMode::SelectionMode() {
    value_ = 0;
    mode_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SelectionMode::~SelectionMode() {
}

int SelectionMode::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "SelectionMode"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SelectionMode",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    mode_ = value() & 0x01;
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TEID1::TEID1() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TEID1::~TEID1() {
}

int TEID1::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "TEID1"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("TEID1",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TEID_ControlPlane::TEID_ControlPlane() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TEID_ControlPlane::~TEID_ControlPlane() {
}

int TEID_ControlPlane::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "TEID_ControlPlane"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("TEID_ControlPlane",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TEID2::TEID2() {
    spare_nsapi_ = 0;
    teid2_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TEID2::~TEID2() {
}

int TEID2::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "TEID2"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("TEID2",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "spare_nsapi"
    spare_nsapi_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "teid2"
    teid2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TeardownInd::TeardownInd() {
    value_ = 0;
    ind_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TeardownInd::~TeardownInd() {
}

int TeardownInd::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "TeardownInd"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("TeardownInd",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    ind_ = value() & 0x01;
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NSAPI::NSAPI() {
    xxxx_nsapi_ = 0;
    nsapi_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NSAPI::~NSAPI() {
}

int NSAPI::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "NSAPI"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NSAPI",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "xxxx_nsapi"
    xxxx_nsapi_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    nsapi_ = xxxx_nsapi() & 0x0f;
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RANAP_Cause::RANAP_Cause() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RANAP_Cause::~RANAP_Cause() {
}

int RANAP_Cause::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "RANAP_Cause"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RANAP_Cause",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RAB_Ctx::RAB_Ctx() {
    spare_nsapi_ = 0;
    dl_gtpu_seq_num_ = 0;
    ul_gtpu_seq_num_ = 0;
    dl_pdcp_seq_num_ = 0;
    ul_pdcp_seq_num_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RAB_Ctx::~RAB_Ctx() {
}

int RAB_Ctx::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RAB_Ctx"
    if ( t_begin_of_data + (9) > t_end_of_data || t_begin_of_data + (9) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RAB_Ctx",
        	(0) + (9), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "spare_nsapi"
    spare_nsapi_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "dl_gtpu_seq_num"
    dl_gtpu_seq_num_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "ul_gtpu_seq_num"
    ul_gtpu_seq_num_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "dl_pdcp_seq_num"
    dl_pdcp_seq_num_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "ul_pdcp_seq_num"
    ul_pdcp_seq_num_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (9) <= t_end_of_data);
    return 9;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RadioPrioritySMS::RadioPrioritySMS() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RadioPrioritySMS::~RadioPrioritySMS() {
}

int RadioPrioritySMS::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "RadioPrioritySMS"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RadioPrioritySMS",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RadioPriority::RadioPriority() {
    nsapi_radio_priority_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RadioPriority::~RadioPriority() {
}

int RadioPriority::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "RadioPriority"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RadioPriority",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "nsapi_radio_priority"
    nsapi_radio_priority_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PacketFlowID::PacketFlowID() {
    rsv_nsapi_ = 0;
    packet_flow_id_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PacketFlowID::~PacketFlowID() {
}

int PacketFlowID::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "PacketFlowID"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PacketFlowID",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "rsv_nsapi"
    rsv_nsapi_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "packet_flow_id"
    packet_flow_id_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ChargingCharacteristics::ChargingCharacteristics() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ChargingCharacteristics::~ChargingCharacteristics() {
}

int ChargingCharacteristics::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "ChargingCharacteristics"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ChargingCharacteristics",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TraceReference::TraceReference() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TraceReference::~TraceReference() {
}

int TraceReference::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "TraceReference"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("TraceReference",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TraceType::TraceType() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TraceType::~TraceType() {
}

int TraceType::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "TraceType"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("TraceType",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MS_Not_Reachable_Reason::MS_Not_Reachable_Reason() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MS_Not_Reachable_Reason::~MS_Not_Reachable_Reason() {
}

int MS_Not_Reachable_Reason::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "MS_Not_Reachable_Reason"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MS_Not_Reachable_Reason",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ChargingID::ChargingID() {
    value_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ChargingID::~ChargingID() {
}

int ChargingID::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "ChargingID"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ChargingID",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
EndUserAddr::EndUserAddr(uint16 n) {
    spare_pdp_type_org_ = 0;
    pdp_type_num_ = 0;
    n_ = n;
    pdp_type_org_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
EndUserAddr::~EndUserAddr() {
    pdp_addr_.free();
}

int EndUserAddr::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "EndUserAddr:pdp_type_num"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("EndUserAddr:pdp_type_num",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "spare_pdp_type_org"
    spare_pdp_type_org_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "pdp_type_num"
    pdp_type_num_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "pdp_addr"
    int t_pdp_addr__size;
    t_pdp_addr__size =  ( n() - 2 ) ;
    // Checking out-of-bound for "EndUserAddr:pdp_addr"
    if ( (t_begin_of_data + 2) + (t_pdp_addr__size) > t_end_of_data || (t_begin_of_data + 2) + (t_pdp_addr__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("EndUserAddr:pdp_addr",
        	(2) + (t_pdp_addr__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_pdp_addr__size;
        int t_pdp_addr_string_length;
        t_pdp_addr_string_length =  ( n() - 2 ) ;
        // check for negative sizes
        if ( t_pdp_addr_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:322", t_pdp_addr_string_length);
        pdp_addr_.init((t_begin_of_data + 2), t_pdp_addr_string_length);
    }

    int t_EndUserAddr__size;
    const_byteptr const t_dataptr_after_pdp_addr = (t_begin_of_data + 2) + (t_pdp_addr__size);
    BINPAC_ASSERT(t_dataptr_after_pdp_addr <= t_end_of_data);
    t_EndUserAddr__size = t_dataptr_after_pdp_addr - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    pdp_type_org_ = spare_pdp_type_org() & 0x0f;
    BINPAC_ASSERT(t_begin_of_data + (t_EndUserAddr__size) <= t_end_of_data);
    return t_EndUserAddr__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MM_Ctx::MM_Ctx(uint16 n) {
    spare_cksn_ksi_ = 0;
    security_params_ = 0;
    keys_case_index_ = -1;
    kc_ = 0;
    vector_len_case_index_ = -1;
    quint_len_ = 0;
    vectors_case_index_ = -1;
    triplets_ = nullptr;
    triplets__elem_ = nullptr;
    quintuplets_ = nullptr;
    quintuplets__elem_ = nullptr;
    drx_param_ = 0;
    ms_net_capability_len_ = 0;
    container_len_ = 0;
    n_ = n;
    security_mode_ = 0;
    gsm_keys_ = false;
    have_triplets_ = false;
    num_vectors_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MM_Ctx::~MM_Ctx() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( keys_case_index() ) {
        case true:
            // Clean up "kc"
            {
            }
            break;
        case false:
            // Clean up "ck_ik"
            {
                ck_ik_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( vector_len_case_index() ) {
        case true:
            // Clean up "no_quint_len"
            {
            }
            break;
        case false:
            // Clean up "quint_len"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( vectors_case_index() ) {
        case true:
            // Clean up "triplets"
            {
                delete triplets__elem_;
                triplets__elem_ = nullptr;
                if ( triplets() ) {
                    for ( auto* triplets__elem_ : *triplets() ) {
                        delete triplets__elem_;
                        triplets__elem_ = nullptr;
                    }
                }
                delete triplets_;
            }
            break;
        case false:
            // Clean up "quintuplets"
            {
                delete quintuplets__elem_;
                quintuplets__elem_ = nullptr;
                if ( quintuplets() ) {
                    for ( auto* quintuplets__elem_ : *quintuplets() ) {
                        delete quintuplets__elem_;
                        quintuplets__elem_ = nullptr;
                    }
                }
                delete quintuplets_;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    ms_net_capability_.free();
    container_.free();
}

int MM_Ctx::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "MM_Ctx:security_params"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MM_Ctx:security_params",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "spare_cksn_ksi"
    spare_cksn_ksi_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "security_params"
    security_params_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "keys"
    int t_keys__size;
    security_mode_ = security_params() >> 6;
    gsm_keys_ = security_mode() & 0x01;
    keys_case_index_ = gsm_keys();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( keys_case_index() ) {
        case true:
            // Parse "kc"
            {
                // Checking out-of-bound for "MM_Ctx:kc"
                if ( (t_begin_of_data + 2) + (8) > t_end_of_data || (t_begin_of_data + 2) + (8) < (t_begin_of_data + 2) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("MM_Ctx:kc",
                    	(2) + (8), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                kc_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 2))));
                t_keys__size = 8;
            }
            break;
        case false:
            // Parse "ck_ik"
            {
                // Checking out-of-bound for "MM_Ctx:ck_ik"
                if ( (t_begin_of_data + 2) + (32) > t_end_of_data || (t_begin_of_data + 2) + (32) < (t_begin_of_data + 2) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("MM_Ctx:ck_ik",
                    	(2) + (32), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 2) + 32;
                    int t_ck_ik_string_length;
                    t_ck_ik_string_length = 32;
                    int t_ck_ik__size;
                    t_ck_ik__size = t_ck_ik_string_length;
                    ck_ik_.init((t_begin_of_data + 2), t_ck_ik_string_length);
                }
                t_keys__size = 32;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("MM_Ctx", (int64)keys_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_keys = (t_begin_of_data + 2) + (t_keys__size);
    BINPAC_ASSERT(t_dataptr_after_keys <= t_end_of_data);
    // Parse "vector_len"
    int t_vector_len__size;
    have_triplets_ =  ( security_mode() == 1 ) ;
    vector_len_case_index_ = have_triplets();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( vector_len_case_index() ) {
        case true:
            // Parse "no_quint_len"
            {
                t_vector_len__size = 0;
            }
            break;
        case false:
            // Parse "quint_len"
            {
                // Checking out-of-bound for "MM_Ctx:quint_len"
                if ( t_dataptr_after_keys + (2) > t_end_of_data || t_dataptr_after_keys + (2) < t_dataptr_after_keys ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("MM_Ctx:quint_len",
                    	((t_dataptr_after_keys - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                quint_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_keys)));
                t_vector_len__size = 2;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("MM_Ctx", (int64)vector_len_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_vector_len = t_dataptr_after_keys + (t_vector_len__size);
    BINPAC_ASSERT(t_dataptr_after_vector_len <= t_end_of_data);
    // Parse "vectors"
    num_vectors_ =  ( security_params() & 0x38 )  >> 3;
    int t_vectors__size;
    vectors_case_index_ = have_triplets();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( vectors_case_index() ) {
        case true:
            // Parse "triplets"
            {
                int t_triplets__arraylength;
                t_triplets__arraylength = num_vectors();
                if ( t_triplets__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("MM_Ctx:triplets",
                      t_triplets__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: MM_Ctx:triplets
                if ( t_triplets__arraylength > ((t_end_of_data - t_dataptr_after_vector_len) / 1) )
                    throw binpac::ExceptionOutOfBound("MM_Ctx:triplets",
                      t_triplets__arraylength, (t_end_of_data) - (t_dataptr_after_vector_len));
                triplets__elem_ = nullptr;
                int t_triplets__elem__it;
                t_triplets__elem__it = 0;
                int t_triplets__size;
                triplets_ = new vector<AuthN_Triplet*>;
                triplets_->reserve(t_triplets__arraylength);
                const_byteptr t_triplets__elem__dataptr = t_dataptr_after_vector_len;
                for (; t_triplets__elem__it < t_triplets__arraylength; ++t_triplets__elem__it) {
                    triplets__elem_ = new AuthN_Triplet();
                    int t_triplets__elem__size;
                    t_triplets__elem__size = triplets__elem_->Parse(t_triplets__elem__dataptr, t_end_of_data, t_byteorder);
                    triplets_->push_back(triplets__elem_);
                    t_triplets__elem__dataptr += t_triplets__elem__size;
                    BINPAC_ASSERT(t_triplets__elem__dataptr <= t_end_of_data);
                    triplets__elem_ = nullptr;
                }
            end_of_triplets: ;
                t_triplets__size = t_triplets__elem__dataptr - (t_dataptr_after_vector_len);
                // Evaluate 'let' and 'withinput' fields
                t_vectors__size = t_triplets__size;
            }
            break;
        case false:
            // Parse "quintuplets"
            {
                int t_quintuplets__arraylength;
                t_quintuplets__arraylength = num_vectors();
                if ( t_quintuplets__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("MM_Ctx:quintuplets",
                      t_quintuplets__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: MM_Ctx:quintuplets
                if ( t_quintuplets__arraylength > ((t_end_of_data - t_dataptr_after_vector_len) / 1) )
                    throw binpac::ExceptionOutOfBound("MM_Ctx:quintuplets",
                      t_quintuplets__arraylength, (t_end_of_data) - (t_dataptr_after_vector_len));
                quintuplets__elem_ = nullptr;
                int t_quintuplets__elem__it;
                t_quintuplets__elem__it = 0;
                int t_quintuplets__size;
                quintuplets_ = new vector<AuthN_Quintuplet*>;
                quintuplets_->reserve(t_quintuplets__arraylength);
                const_byteptr t_quintuplets__elem__dataptr = t_dataptr_after_vector_len;
                for (; t_quintuplets__elem__it < t_quintuplets__arraylength; ++t_quintuplets__elem__it) {
                    quintuplets__elem_ = new AuthN_Quintuplet(quint_len());
                    int t_quintuplets__elem__size;
                    t_quintuplets__elem__size = quintuplets__elem_->Parse(t_quintuplets__elem__dataptr, t_end_of_data);
                    quintuplets_->push_back(quintuplets__elem_);
                    t_quintuplets__elem__dataptr += t_quintuplets__elem__size;
                    BINPAC_ASSERT(t_quintuplets__elem__dataptr <= t_end_of_data);
                    quintuplets__elem_ = nullptr;
                }
            end_of_quintuplets: ;
                t_quintuplets__size = t_quintuplets__elem__dataptr - (t_dataptr_after_vector_len);
                // Evaluate 'let' and 'withinput' fields
                t_vectors__size = t_quintuplets__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("MM_Ctx", (int64)vectors_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_vectors = t_dataptr_after_vector_len + (t_vectors__size);
    BINPAC_ASSERT(t_dataptr_after_vectors <= t_end_of_data);
    // Checking out-of-bound for "MM_Ctx:ms_net_capability_len"
    if ( (t_dataptr_after_vectors + 2) + (1) > t_end_of_data || (t_dataptr_after_vectors + 2) + (1) < (t_dataptr_after_vectors + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MM_Ctx:ms_net_capability_len",
        	(((t_dataptr_after_vectors + 2) - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "drx_param"
    drx_param_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_vectors)));

    // Parse "ms_net_capability_len"
    ms_net_capability_len_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_vectors + 2)));

    // Parse "ms_net_capability"
    int t_ms_net_capability__size;
    t_ms_net_capability__size = ms_net_capability_len();
    // Checking out-of-bound for "MM_Ctx:ms_net_capability"
    if ( (t_dataptr_after_vectors + 3) + (t_ms_net_capability__size) > t_end_of_data || (t_dataptr_after_vectors + 3) + (t_ms_net_capability__size) < (t_dataptr_after_vectors + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MM_Ctx:ms_net_capability",
        	(((t_dataptr_after_vectors + 3) - t_begin_of_data)) + (t_ms_net_capability__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_vectors + 3) + t_ms_net_capability__size;
        int t_ms_net_capability_string_length;
        t_ms_net_capability_string_length = ms_net_capability_len();
        // check for negative sizes
        if ( t_ms_net_capability_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:348", t_ms_net_capability_string_length);
        ms_net_capability_.init((t_dataptr_after_vectors + 3), t_ms_net_capability_string_length);
    }

    const_byteptr const t_dataptr_after_ms_net_capability = (t_dataptr_after_vectors + 3) + (t_ms_net_capability__size);
    BINPAC_ASSERT(t_dataptr_after_ms_net_capability <= t_end_of_data);
    // Checking out-of-bound for "MM_Ctx:container_len"
    if ( t_dataptr_after_ms_net_capability + (2) > t_end_of_data || t_dataptr_after_ms_net_capability + (2) < t_dataptr_after_ms_net_capability ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MM_Ctx:container_len",
        	((t_dataptr_after_ms_net_capability - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "container_len"
    container_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_ms_net_capability)));

    // Parse "container"
    int t_container__size;
    t_container__size = container_len();
    // Checking out-of-bound for "MM_Ctx:container"
    if ( (t_dataptr_after_ms_net_capability + 2) + (t_container__size) > t_end_of_data || (t_dataptr_after_ms_net_capability + 2) + (t_container__size) < (t_dataptr_after_ms_net_capability + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MM_Ctx:container",
        	(((t_dataptr_after_ms_net_capability + 2) - t_begin_of_data)) + (t_container__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_ms_net_capability + 2) + t_container__size;
        int t_container_string_length;
        t_container_string_length = container_len();
        // check for negative sizes
        if ( t_container_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:350", t_container_string_length);
        container_.init((t_dataptr_after_ms_net_capability + 2), t_container_string_length);
    }

    int t_MM_Ctx__size;
    const_byteptr const t_dataptr_after_container = (t_dataptr_after_ms_net_capability + 2) + (t_container__size);
    BINPAC_ASSERT(t_dataptr_after_container <= t_end_of_data);
    t_MM_Ctx__size = t_dataptr_after_container - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_MM_Ctx__size) <= t_end_of_data);
    return t_MM_Ctx__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PDP_Ctx::PDP_Ctx(uint16 n) {
    rsv_nsapi_ = 0;
    xxxx_sapi_ = 0;
    qos_sub_len_ = 0;
    qos_sub_ = nullptr;
    qos_req_len_ = 0;
    qos_req_ = nullptr;
    qos_neg_len_ = 0;
    qos_neg_ = nullptr;
    snd_ = 0;
    snu_ = 0;
    send_npdu_num_ = 0;
    recv_npdu_num_ = 0;
    ul_teid_cp_ = nullptr;
    ul_teid_data1_ = nullptr;
    pdp_ctx_id_ = 0;
    spare_pdp_type_org_ = 0;
    pdp_type_num_ = 0;
    pdp_addr_len_ = 0;
    ggsn_addr_control_plane_len_ = 0;
    ggsn_addr_user_traffic_len_ = 0;
    apn_len_ = 0;
    apn_ = nullptr;
    spare_transaction_id_ = 0;
    transaction_id_ = 0;
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PDP_Ctx::~PDP_Ctx() {
    delete qos_sub_;
    qos_sub_ = nullptr;
    delete qos_req_;
    qos_req_ = nullptr;
    delete qos_neg_;
    qos_neg_ = nullptr;
    delete ul_teid_cp_;
    ul_teid_cp_ = nullptr;
    delete ul_teid_data1_;
    ul_teid_data1_ = nullptr;
    pdp_addr_.free();
    ggsn_addr_control_plane_.free();
    ggsn_addr_user_traffic_.free();
    delete apn_;
    apn_ = nullptr;
}

int PDP_Ctx::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "PDP_Ctx:qos_sub_len"
    if ( (t_begin_of_data + 2) + (1) > t_end_of_data || (t_begin_of_data + 2) + (1) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PDP_Ctx:qos_sub_len",
        	(2) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "rsv_nsapi"
    rsv_nsapi_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "xxxx_sapi"
    xxxx_sapi_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "qos_sub_len"
    qos_sub_len_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "qos_sub"
    qos_sub_ = new QoS_Profile(qos_sub_len());
    int t_qos_sub__size;
    t_qos_sub__size = qos_sub_->Parse((t_begin_of_data + 3), t_end_of_data);

    const_byteptr const t_dataptr_after_qos_sub = (t_begin_of_data + 3) + (t_qos_sub__size);
    BINPAC_ASSERT(t_dataptr_after_qos_sub <= t_end_of_data);
    // Checking out-of-bound for "PDP_Ctx:qos_req_len"
    if ( t_dataptr_after_qos_sub + (1) > t_end_of_data || t_dataptr_after_qos_sub + (1) < t_dataptr_after_qos_sub ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PDP_Ctx:qos_req_len",
        	((t_dataptr_after_qos_sub - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "qos_req_len"
    qos_req_len_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_qos_sub));

    // Parse "qos_req"
    qos_req_ = new QoS_Profile(qos_req_len());
    int t_qos_req__size;
    t_qos_req__size = qos_req_->Parse((t_dataptr_after_qos_sub + 1), t_end_of_data);

    const_byteptr const t_dataptr_after_qos_req = (t_dataptr_after_qos_sub + 1) + (t_qos_req__size);
    BINPAC_ASSERT(t_dataptr_after_qos_req <= t_end_of_data);
    // Checking out-of-bound for "PDP_Ctx:qos_neg_len"
    if ( t_dataptr_after_qos_req + (1) > t_end_of_data || t_dataptr_after_qos_req + (1) < t_dataptr_after_qos_req ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PDP_Ctx:qos_neg_len",
        	((t_dataptr_after_qos_req - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "qos_neg_len"
    qos_neg_len_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_qos_req));

    // Parse "qos_neg"
    qos_neg_ = new QoS_Profile(qos_neg_len());
    int t_qos_neg__size;
    t_qos_neg__size = qos_neg_->Parse((t_dataptr_after_qos_req + 1), t_end_of_data);

    const_byteptr const t_dataptr_after_qos_neg = (t_dataptr_after_qos_req + 1) + (t_qos_neg__size);
    BINPAC_ASSERT(t_dataptr_after_qos_neg <= t_end_of_data);
    // Checking out-of-bound for "PDP_Ctx:pdp_addr_len"
    if ( (t_dataptr_after_qos_neg + 17) + (1) > t_end_of_data || (t_dataptr_after_qos_neg + 17) + (1) < (t_dataptr_after_qos_neg + 17) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PDP_Ctx:pdp_addr_len",
        	(((t_dataptr_after_qos_neg + 17) - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "snd"
    snd_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_qos_neg)));

    // Parse "snu"
    snu_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_qos_neg + 2))));

    // Parse "send_npdu_num"
    send_npdu_num_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_qos_neg + 4)));

    // Parse "recv_npdu_num"
    recv_npdu_num_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_qos_neg + 5)));

    // Parse "ul_teid_cp"
    ul_teid_cp_ = new TEID_ControlPlane();
    ul_teid_cp_->Parse((t_dataptr_after_qos_neg + 6), t_end_of_data, t_byteorder);

    // Parse "ul_teid_data1"
    ul_teid_data1_ = new TEID1();
    ul_teid_data1_->Parse((t_dataptr_after_qos_neg + 10), t_end_of_data, t_byteorder);

    // Parse "pdp_ctx_id"
    pdp_ctx_id_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_qos_neg + 14)));

    // Parse "spare_pdp_type_org"
    spare_pdp_type_org_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_qos_neg + 15)));

    // Parse "pdp_type_num"
    pdp_type_num_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_qos_neg + 16)));

    // Parse "pdp_addr_len"
    pdp_addr_len_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_qos_neg + 17)));

    // Parse "pdp_addr"
    int t_pdp_addr__size;
    t_pdp_addr__size = pdp_addr_len();
    // Checking out-of-bound for "PDP_Ctx:pdp_addr"
    if ( (t_dataptr_after_qos_neg + 18) + (t_pdp_addr__size) > t_end_of_data || (t_dataptr_after_qos_neg + 18) + (t_pdp_addr__size) < (t_dataptr_after_qos_neg + 18) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PDP_Ctx:pdp_addr",
        	(((t_dataptr_after_qos_neg + 18) - t_begin_of_data)) + (t_pdp_addr__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_qos_neg + 18) + t_pdp_addr__size;
        int t_pdp_addr_string_length;
        t_pdp_addr_string_length = pdp_addr_len();
        // check for negative sizes
        if ( t_pdp_addr_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:378", t_pdp_addr_string_length);
        pdp_addr_.init((t_dataptr_after_qos_neg + 18), t_pdp_addr_string_length);
    }

    const_byteptr const t_dataptr_after_pdp_addr = (t_dataptr_after_qos_neg + 18) + (t_pdp_addr__size);
    BINPAC_ASSERT(t_dataptr_after_pdp_addr <= t_end_of_data);
    // Checking out-of-bound for "PDP_Ctx:ggsn_addr_control_plane_len"
    if ( t_dataptr_after_pdp_addr + (1) > t_end_of_data || t_dataptr_after_pdp_addr + (1) < t_dataptr_after_pdp_addr ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PDP_Ctx:ggsn_addr_control_plane_len",
        	((t_dataptr_after_pdp_addr - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "ggsn_addr_control_plane_len"
    ggsn_addr_control_plane_len_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_pdp_addr));

    // Parse "ggsn_addr_control_plane"
    int t_ggsn_addr_control_plane__size;
    t_ggsn_addr_control_plane__size = ggsn_addr_control_plane_len();
    // Checking out-of-bound for "PDP_Ctx:ggsn_addr_control_plane"
    if ( (t_dataptr_after_pdp_addr + 1) + (t_ggsn_addr_control_plane__size) > t_end_of_data || (t_dataptr_after_pdp_addr + 1) + (t_ggsn_addr_control_plane__size) < (t_dataptr_after_pdp_addr + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PDP_Ctx:ggsn_addr_control_plane",
        	(((t_dataptr_after_pdp_addr + 1) - t_begin_of_data)) + (t_ggsn_addr_control_plane__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_pdp_addr + 1) + t_ggsn_addr_control_plane__size;
        int t_ggsn_addr_control_plane_string_length;
        t_ggsn_addr_control_plane_string_length = ggsn_addr_control_plane_len();
        // check for negative sizes
        if ( t_ggsn_addr_control_plane_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:380", t_ggsn_addr_control_plane_string_length);
        ggsn_addr_control_plane_.init((t_dataptr_after_pdp_addr + 1), t_ggsn_addr_control_plane_string_length);
    }

    const_byteptr const t_dataptr_after_ggsn_addr_control_plane = (t_dataptr_after_pdp_addr + 1) + (t_ggsn_addr_control_plane__size);
    BINPAC_ASSERT(t_dataptr_after_ggsn_addr_control_plane <= t_end_of_data);
    // Checking out-of-bound for "PDP_Ctx:ggsn_addr_user_traffic_len"
    if ( t_dataptr_after_ggsn_addr_control_plane + (1) > t_end_of_data || t_dataptr_after_ggsn_addr_control_plane + (1) < t_dataptr_after_ggsn_addr_control_plane ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PDP_Ctx:ggsn_addr_user_traffic_len",
        	((t_dataptr_after_ggsn_addr_control_plane - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "ggsn_addr_user_traffic_len"
    ggsn_addr_user_traffic_len_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_ggsn_addr_control_plane));

    // Parse "ggsn_addr_user_traffic"
    int t_ggsn_addr_user_traffic__size;
    t_ggsn_addr_user_traffic__size = ggsn_addr_user_traffic_len();
    // Checking out-of-bound for "PDP_Ctx:ggsn_addr_user_traffic"
    if ( (t_dataptr_after_ggsn_addr_control_plane + 1) + (t_ggsn_addr_user_traffic__size) > t_end_of_data || (t_dataptr_after_ggsn_addr_control_plane + 1) + (t_ggsn_addr_user_traffic__size) < (t_dataptr_after_ggsn_addr_control_plane + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PDP_Ctx:ggsn_addr_user_traffic",
        	(((t_dataptr_after_ggsn_addr_control_plane + 1) - t_begin_of_data)) + (t_ggsn_addr_user_traffic__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_ggsn_addr_control_plane + 1) + t_ggsn_addr_user_traffic__size;
        int t_ggsn_addr_user_traffic_string_length;
        t_ggsn_addr_user_traffic_string_length = ggsn_addr_user_traffic_len();
        // check for negative sizes
        if ( t_ggsn_addr_user_traffic_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:382", t_ggsn_addr_user_traffic_string_length);
        ggsn_addr_user_traffic_.init((t_dataptr_after_ggsn_addr_control_plane + 1), t_ggsn_addr_user_traffic_string_length);
    }

    const_byteptr const t_dataptr_after_ggsn_addr_user_traffic = (t_dataptr_after_ggsn_addr_control_plane + 1) + (t_ggsn_addr_user_traffic__size);
    BINPAC_ASSERT(t_dataptr_after_ggsn_addr_user_traffic <= t_end_of_data);
    // Checking out-of-bound for "PDP_Ctx:apn_len"
    if ( t_dataptr_after_ggsn_addr_user_traffic + (1) > t_end_of_data || t_dataptr_after_ggsn_addr_user_traffic + (1) < t_dataptr_after_ggsn_addr_user_traffic ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PDP_Ctx:apn_len",
        	((t_dataptr_after_ggsn_addr_user_traffic - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "apn_len"
    apn_len_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_ggsn_addr_user_traffic));

    // Parse "apn"
    apn_ = new AP_Name(apn_len());
    int t_apn__size;
    t_apn__size = apn_->Parse((t_dataptr_after_ggsn_addr_user_traffic + 1), t_end_of_data);

    const_byteptr const t_dataptr_after_apn = (t_dataptr_after_ggsn_addr_user_traffic + 1) + (t_apn__size);
    BINPAC_ASSERT(t_dataptr_after_apn <= t_end_of_data);
    // Checking out-of-bound for "PDP_Ctx:transaction_id"
    if ( (t_dataptr_after_apn + 1) + (1) > t_end_of_data || (t_dataptr_after_apn + 1) + (1) < (t_dataptr_after_apn + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PDP_Ctx:transaction_id",
        	(((t_dataptr_after_apn + 1) - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "spare_transaction_id"
    spare_transaction_id_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_apn));

    // Parse "transaction_id"
    transaction_id_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_apn + 1)));

    int t_PDP_Ctx__size;
    t_PDP_Ctx__size = (t_dataptr_after_apn + 2) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_PDP_Ctx__size) <= t_end_of_data);
    return t_PDP_Ctx__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AP_Name::AP_Name(uint16 n) {
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AP_Name::~AP_Name() {
    value_.free();
}

int AP_Name::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    int t_value__size;
    t_value__size = n();
    // Checking out-of-bound for "AP_Name:value"
    if ( t_begin_of_data + (t_value__size) > t_end_of_data || t_begin_of_data + (t_value__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AP_Name:value",
        	(0) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_value__size;
        int t_value_string_length;
        t_value_string_length = n();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:390", t_value_string_length);
        value_.init(t_begin_of_data, t_value_string_length);
    }

    int t_AP_Name__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_AP_Name__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AP_Name__size) <= t_end_of_data);
    return t_AP_Name__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ProtoConfigOpts::ProtoConfigOpts(uint16 n) {
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ProtoConfigOpts::~ProtoConfigOpts() {
    value_.free();
}

int ProtoConfigOpts::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    int t_value__size;
    t_value__size = n();
    // Checking out-of-bound for "ProtoConfigOpts:value"
    if ( t_begin_of_data + (t_value__size) > t_end_of_data || t_begin_of_data + (t_value__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ProtoConfigOpts:value",
        	(0) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_value__size;
        int t_value_string_length;
        t_value_string_length = n();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:394", t_value_string_length);
        value_.init(t_begin_of_data, t_value_string_length);
    }

    int t_ProtoConfigOpts__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_ProtoConfigOpts__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ProtoConfigOpts__size) <= t_end_of_data);
    return t_ProtoConfigOpts__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GSN_Addr::GSN_Addr(uint16 n) {
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GSN_Addr::~GSN_Addr() {
    value_.free();
}

int GSN_Addr::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    int t_value__size;
    t_value__size = n();
    // Checking out-of-bound for "GSN_Addr:value"
    if ( t_begin_of_data + (t_value__size) > t_end_of_data || t_begin_of_data + (t_value__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GSN_Addr:value",
        	(0) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_value__size;
        int t_value_string_length;
        t_value_string_length = n();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:398", t_value_string_length);
        value_.init(t_begin_of_data, t_value_string_length);
    }

    int t_GSN_Addr__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_GSN_Addr__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_GSN_Addr__size) <= t_end_of_data);
    return t_GSN_Addr__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MSISDN::MSISDN(uint16 n) {
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MSISDN::~MSISDN() {
    value_.free();
}

int MSISDN::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    int t_value__size;
    t_value__size = n();
    // Checking out-of-bound for "MSISDN:value"
    if ( t_begin_of_data + (t_value__size) > t_end_of_data || t_begin_of_data + (t_value__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MSISDN:value",
        	(0) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_value__size;
        int t_value_string_length;
        t_value_string_length = n();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:402", t_value_string_length);
        value_.init(t_begin_of_data, t_value_string_length);
    }

    int t_MSISDN__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_MSISDN__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_MSISDN__size) <= t_end_of_data);
    return t_MSISDN__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
QoS_Profile::QoS_Profile(uint16 n) {
    alloc_retention_priority_ = 0;
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
QoS_Profile::~QoS_Profile() {
    data_.free();
}

int QoS_Profile::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "QoS_Profile:alloc_retention_priority"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("QoS_Profile:alloc_retention_priority",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "alloc_retention_priority"
    alloc_retention_priority_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "data"
    int t_data__size;
    t_data__size = n() - 1;
    // Checking out-of-bound for "QoS_Profile:data"
    if ( (t_begin_of_data + 1) + (t_data__size) > t_end_of_data || (t_begin_of_data + 1) + (t_data__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("QoS_Profile:data",
        	(1) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_data__size;
        int t_data_string_length;
        t_data_string_length = n() - 1;
        // check for negative sizes
        if ( t_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:407", t_data_string_length);
        data_.init((t_begin_of_data + 1), t_data_string_length);
    }

    int t_QoS_Profile__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 1) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_QoS_Profile__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_QoS_Profile__size) <= t_end_of_data);
    return t_QoS_Profile__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthN_Quintuplet::AuthN_Quintuplet(uint16 n) {
    xres_len_ = 0;
    autn_len_ = 0;
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthN_Quintuplet::~AuthN_Quintuplet() {
    rand_.free();
    xres_.free();
    ck_.free();
    ik_.free();
    autn_.free();
}

int AuthN_Quintuplet::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "rand"
    // Checking out-of-bound for "AuthN_Quintuplet:rand"
    if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthN_Quintuplet:rand",
        	(0) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 16;
        int t_rand_string_length;
        t_rand_string_length = 16;
        int t_rand__size;
        t_rand__size = t_rand_string_length;
        rand_.init(t_begin_of_data, t_rand_string_length);
    }

    const_byteptr const t_dataptr_after_rand = t_begin_of_data + (16);
    BINPAC_ASSERT(t_dataptr_after_rand <= t_end_of_data);
    // Checking out-of-bound for "AuthN_Quintuplet:xres_len"
    if ( t_dataptr_after_rand + (1) > t_end_of_data || t_dataptr_after_rand + (1) < t_dataptr_after_rand ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthN_Quintuplet:xres_len",
        	((t_dataptr_after_rand - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "xres_len"
    xres_len_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_rand));

    // Parse "xres"
    int t_xres__size;
    t_xres__size = xres_len();
    // Checking out-of-bound for "AuthN_Quintuplet:xres"
    if ( (t_dataptr_after_rand + 1) + (t_xres__size) > t_end_of_data || (t_dataptr_after_rand + 1) + (t_xres__size) < (t_dataptr_after_rand + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthN_Quintuplet:xres",
        	(((t_dataptr_after_rand + 1) - t_begin_of_data)) + (t_xres__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_rand + 1) + t_xres__size;
        int t_xres_string_length;
        t_xres_string_length = xres_len();
        // check for negative sizes
        if ( t_xres_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:413", t_xres_string_length);
        xres_.init((t_dataptr_after_rand + 1), t_xres_string_length);
    }

    const_byteptr const t_dataptr_after_xres = (t_dataptr_after_rand + 1) + (t_xres__size);
    BINPAC_ASSERT(t_dataptr_after_xres <= t_end_of_data);
    // Parse "ck"
    // Checking out-of-bound for "AuthN_Quintuplet:ck"
    if ( t_dataptr_after_xres + (16) > t_end_of_data || t_dataptr_after_xres + (16) < t_dataptr_after_xres ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthN_Quintuplet:ck",
        	((t_dataptr_after_xres - t_begin_of_data)) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_xres + 16;
        int t_ck_string_length;
        t_ck_string_length = 16;
        int t_ck__size;
        t_ck__size = t_ck_string_length;
        ck_.init(t_dataptr_after_xres, t_ck_string_length);
    }

    const_byteptr const t_dataptr_after_ck = t_dataptr_after_xres + (16);
    BINPAC_ASSERT(t_dataptr_after_ck <= t_end_of_data);
    // Parse "ik"
    // Checking out-of-bound for "AuthN_Quintuplet:ik"
    if ( t_dataptr_after_ck + (16) > t_end_of_data || t_dataptr_after_ck + (16) < t_dataptr_after_ck ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthN_Quintuplet:ik",
        	((t_dataptr_after_ck - t_begin_of_data)) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_ck + 16;
        int t_ik_string_length;
        t_ik_string_length = 16;
        int t_ik__size;
        t_ik__size = t_ik_string_length;
        ik_.init(t_dataptr_after_ck, t_ik_string_length);
    }

    const_byteptr const t_dataptr_after_ik = t_dataptr_after_ck + (16);
    BINPAC_ASSERT(t_dataptr_after_ik <= t_end_of_data);
    // Checking out-of-bound for "AuthN_Quintuplet:autn_len"
    if ( t_dataptr_after_ik + (1) > t_end_of_data || t_dataptr_after_ik + (1) < t_dataptr_after_ik ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthN_Quintuplet:autn_len",
        	((t_dataptr_after_ik - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "autn_len"
    autn_len_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_ik));

    // Parse "autn"
    int t_autn__size;
    t_autn__size = autn_len();
    // Checking out-of-bound for "AuthN_Quintuplet:autn"
    if ( (t_dataptr_after_ik + 1) + (t_autn__size) > t_end_of_data || (t_dataptr_after_ik + 1) + (t_autn__size) < (t_dataptr_after_ik + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthN_Quintuplet:autn",
        	(((t_dataptr_after_ik + 1) - t_begin_of_data)) + (t_autn__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_ik + 1) + t_autn__size;
        int t_autn_string_length;
        t_autn_string_length = autn_len();
        // check for negative sizes
        if ( t_autn_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:417", t_autn_string_length);
        autn_.init((t_dataptr_after_ik + 1), t_autn_string_length);
    }

    int t_AuthN_Quintuplet__size;
    const_byteptr const t_dataptr_after_autn = (t_dataptr_after_ik + 1) + (t_autn__size);
    BINPAC_ASSERT(t_dataptr_after_autn <= t_end_of_data);
    t_AuthN_Quintuplet__size = t_dataptr_after_autn - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AuthN_Quintuplet__size) <= t_end_of_data);
    return t_AuthN_Quintuplet__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TrafficFlowTemplate::TrafficFlowTemplate(uint16 n) {
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TrafficFlowTemplate::~TrafficFlowTemplate() {
    value_.free();
}

int TrafficFlowTemplate::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    int t_value__size;
    t_value__size = n();
    // Checking out-of-bound for "TrafficFlowTemplate:value"
    if ( t_begin_of_data + (t_value__size) > t_end_of_data || t_begin_of_data + (t_value__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("TrafficFlowTemplate:value",
        	(0) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_value__size;
        int t_value_string_length;
        t_value_string_length = n();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:421", t_value_string_length);
        value_.init(t_begin_of_data, t_value_string_length);
    }

    int t_TrafficFlowTemplate__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_TrafficFlowTemplate__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_TrafficFlowTemplate__size) <= t_end_of_data);
    return t_TrafficFlowTemplate__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TargetID::TargetID(uint16 n) {
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TargetID::~TargetID() {
    value_.free();
}

int TargetID::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    int t_value__size;
    t_value__size = n();
    // Checking out-of-bound for "TargetID:value"
    if ( t_begin_of_data + (t_value__size) > t_end_of_data || t_begin_of_data + (t_value__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("TargetID:value",
        	(0) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_value__size;
        int t_value_string_length;
        t_value_string_length = n();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:425", t_value_string_length);
        value_.init(t_begin_of_data, t_value_string_length);
    }

    int t_TargetID__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_TargetID__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_TargetID__size) <= t_end_of_data);
    return t_TargetID__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UTRAN_TransparentContainer::UTRAN_TransparentContainer(uint16 n) {
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UTRAN_TransparentContainer::~UTRAN_TransparentContainer() {
    value_.free();
}

int UTRAN_TransparentContainer::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    int t_value__size;
    t_value__size = n();
    // Checking out-of-bound for "UTRAN_TransparentContainer:value"
    if ( t_begin_of_data + (t_value__size) > t_end_of_data || t_begin_of_data + (t_value__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UTRAN_TransparentContainer:value",
        	(0) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_value__size;
        int t_value_string_length;
        t_value_string_length = n();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:429", t_value_string_length);
        value_.init(t_begin_of_data, t_value_string_length);
    }

    int t_UTRAN_TransparentContainer__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_UTRAN_TransparentContainer__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_UTRAN_TransparentContainer__size) <= t_end_of_data);
    return t_UTRAN_TransparentContainer__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RAB_SetupInfo::RAB_SetupInfo(uint16 n) {
    xxxx_nsapi_ = 0;
    have_teid_case_index_ = -1;
    teid_ = nullptr;
    have_addr_case_index_ = -1;
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
RAB_SetupInfo::~RAB_SetupInfo() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_teid_case_index() ) {
        case ((uint16)1):
            // Clean up "no_teid"
            {
            }
            break;
        default:
            // Clean up "teid"
            {
                delete teid_;
                teid_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_addr_case_index() ) {
        case ((uint16)1):
            // Clean up "no_addr"
            {
            }
            break;
        default:
            // Clean up "rnc_addr"
            {
                rnc_addr_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int RAB_SetupInfo::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RAB_SetupInfo:xxxx_nsapi"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RAB_SetupInfo:xxxx_nsapi",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "xxxx_nsapi"
    xxxx_nsapi_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "have_teid"
    int t_have_teid__size;
    have_teid_case_index_ = n();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_teid_case_index() ) {
        case ((uint16)1):
            // Parse "no_teid"
            {
                t_have_teid__size = 0;
            }
            break;
        default:
            // Parse "teid"
            {
                teid_ = new TEID1();
                teid_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);
                t_have_teid__size = 4;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_teid = (t_begin_of_data + 1) + (t_have_teid__size);
    BINPAC_ASSERT(t_dataptr_after_have_teid <= t_end_of_data);
    // Parse "have_addr"
    int t_have_addr__size;
    have_addr_case_index_ = n();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_addr_case_index() ) {
        case ((uint16)1):
            // Parse "no_addr"
            {
                t_have_addr__size = 0;
            }
            break;
        default:
            // Parse "rnc_addr"
            {
                int t_rnc_addr__size;
                t_rnc_addr__size = n() - 5;
                // Checking out-of-bound for "RAB_SetupInfo:rnc_addr"
                if ( t_dataptr_after_have_teid + (t_rnc_addr__size) > t_end_of_data || t_dataptr_after_have_teid + (t_rnc_addr__size) < t_dataptr_after_have_teid ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RAB_SetupInfo:rnc_addr",
                    	((t_dataptr_after_have_teid - t_begin_of_data)) + (t_rnc_addr__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_have_teid + t_rnc_addr__size;
                    int t_rnc_addr_string_length;
                    t_rnc_addr_string_length = n() - 5;
                    // check for negative sizes
                    if ( t_rnc_addr_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:442", t_rnc_addr_string_length);
                    rnc_addr_.init(t_dataptr_after_have_teid, t_rnc_addr_string_length);
                }
                t_have_addr__size = t_rnc_addr__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_RAB_SetupInfo__size;
    const_byteptr const t_dataptr_after_have_addr = t_dataptr_after_have_teid + (t_have_addr__size);
    BINPAC_ASSERT(t_dataptr_after_have_addr <= t_end_of_data);
    t_RAB_SetupInfo__size = t_dataptr_after_have_addr - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_RAB_SetupInfo__size) <= t_end_of_data);
    return t_RAB_SetupInfo__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ExtHdrTypeList::ExtHdrTypeList(uint16 n) {
    value_ = nullptr;
    value__elem_ = 0;
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ExtHdrTypeList::~ExtHdrTypeList() {
    delete value_;
}

int ExtHdrTypeList::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    int t_value__arraylength;
    t_value__arraylength = n();
    if ( t_value__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("ExtHdrTypeList:value",
          t_value__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: ExtHdrTypeList:value
    if ( t_value__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
        throw binpac::ExceptionOutOfBound("ExtHdrTypeList:value",
          t_value__arraylength, (t_end_of_data) - (t_begin_of_data));
    value__elem_ = 0;
    int t_value__elem__it;
    t_value__elem__it = 0;
    int t_value__size;
    value_ = new vector<uint8>;
    value_->reserve(t_value__arraylength);
    const_byteptr t_value__elem__dataptr = t_begin_of_data;
    for (; t_value__elem__it < t_value__arraylength; ++t_value__elem__it) {
        value__elem_ = *(reinterpret_cast<uint8 const*>(t_value__elem__dataptr));
        value_->push_back(value__elem_);
        t_value__elem__dataptr += 1;
        BINPAC_ASSERT(t_value__elem__dataptr <= t_end_of_data);
    }
end_of_value: ;
    t_value__size = t_value__elem__dataptr - (t_begin_of_data);
    // Evaluate 'let' and 'withinput' fields

    int t_ExtHdrTypeList__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_ExtHdrTypeList__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ExtHdrTypeList__size) <= t_end_of_data);
    return t_ExtHdrTypeList__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TriggerID::TriggerID(uint16 n) {
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
TriggerID::~TriggerID() {
    value_.free();
}

int TriggerID::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    int t_value__size;
    t_value__size = n();
    // Checking out-of-bound for "TriggerID:value"
    if ( t_begin_of_data + (t_value__size) > t_end_of_data || t_begin_of_data + (t_value__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("TriggerID:value",
        	(0) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_value__size;
        int t_value_string_length;
        t_value_string_length = n();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:451", t_value_string_length);
        value_.init(t_begin_of_data, t_value_string_length);
    }

    int t_TriggerID__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_TriggerID__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_TriggerID__size) <= t_end_of_data);
    return t_TriggerID__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
OMC_ID::OMC_ID(uint16 n) {
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
OMC_ID::~OMC_ID() {
    value_.free();
}

int OMC_ID::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    int t_value__size;
    t_value__size = n();
    // Checking out-of-bound for "OMC_ID:value"
    if ( t_begin_of_data + (t_value__size) > t_end_of_data || t_begin_of_data + (t_value__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("OMC_ID:value",
        	(0) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_value__size;
        int t_value_string_length;
        t_value_string_length = n();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:455", t_value_string_length);
        value_.init(t_begin_of_data, t_value_string_length);
    }

    int t_OMC_ID__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_OMC_ID__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_OMC_ID__size) <= t_end_of_data);
    return t_OMC_ID__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ChargingGatewayAddr::ChargingGatewayAddr(uint16 n) {
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ChargingGatewayAddr::~ChargingGatewayAddr() {
    value_.free();
}

int ChargingGatewayAddr::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "value"
    int t_value__size;
    t_value__size = n();
    // Checking out-of-bound for "ChargingGatewayAddr:value"
    if ( t_begin_of_data + (t_value__size) > t_end_of_data || t_begin_of_data + (t_value__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ChargingGatewayAddr:value",
        	(0) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_value__size;
        int t_value_string_length;
        t_value_string_length = n();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:459", t_value_string_length);
        value_.init(t_begin_of_data, t_value_string_length);
    }

    int t_ChargingGatewayAddr__size;
    const_byteptr const t_dataptr_after_value = t_begin_of_data + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_ChargingGatewayAddr__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ChargingGatewayAddr__size) <= t_end_of_data);
    return t_ChargingGatewayAddr__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PrivateExt::PrivateExt(uint16 n) {
    id_ = 0;
    n_ = n;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PrivateExt::~PrivateExt() {
    value_.free();
}

int PrivateExt::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "PrivateExt:id"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PrivateExt:id",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "id"
    id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "value"
    int t_value__size;
    t_value__size = n() - 2;
    // Checking out-of-bound for "PrivateExt:value"
    if ( (t_begin_of_data + 2) + (t_value__size) > t_end_of_data || (t_begin_of_data + 2) + (t_value__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PrivateExt:value",
        	(2) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_value__size;
        int t_value_string_length;
        t_value_string_length = n() - 2;
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:464", t_value_string_length);
        value_.init((t_begin_of_data + 2), t_value_string_length);
    }

    int t_PrivateExt__size;
    const_byteptr const t_dataptr_after_value = (t_begin_of_data + 2) + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_PrivateExt__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_PrivateExt__size) <= t_end_of_data);
    return t_PrivateExt__size;
}

uint16 Get_IE_Len(uint8 t) {
    int t_t_var_001;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( t ) {
        case ((uint8)1):
            t_t_var_001 = 1;
            break;
        case ((uint8)2):
            t_t_var_001 = 8;
            break;
        case ((uint8)3):
            t_t_var_001 = 6;
            break;
        case ((uint8)4):
            t_t_var_001 = 4;
            break;
        case ((uint8)5):
            t_t_var_001 = 4;
            break;
        case ((uint8)8):
            t_t_var_001 = 1;
            break;
        case ((uint8)9):
            t_t_var_001 = 28;
            break;
        case ((uint8)11):
            t_t_var_001 = 1;
            break;
        case ((uint8)12):
            t_t_var_001 = 3;
            break;
        case ((uint8)13):
            t_t_var_001 = 1;
            break;
        case ((uint8)14):
            t_t_var_001 = 1;
            break;
        case ((uint8)15):
            t_t_var_001 = 1;
            break;
        case ((uint8)16):
            t_t_var_001 = 4;
            break;
        case ((uint8)17):
            t_t_var_001 = 4;
            break;
        case ((uint8)18):
            t_t_var_001 = 5;
            break;
        case ((uint8)19):
            t_t_var_001 = 1;
            break;
        case ((uint8)20):
            t_t_var_001 = 1;
            break;
        case ((uint8)21):
            t_t_var_001 = 1;
            break;
        case ((uint8)22):
            t_t_var_001 = 9;
            break;
        case ((uint8)23):
            t_t_var_001 = 1;
            break;
        case ((uint8)24):
            t_t_var_001 = 1;
            break;
        case ((uint8)25):
            t_t_var_001 = 2;
            break;
        case ((uint8)26):
            t_t_var_001 = 2;
            break;
        case ((uint8)27):
            t_t_var_001 = 2;
            break;
        case ((uint8)28):
            t_t_var_001 = 2;
            break;
        case ((uint8)29):
            t_t_var_001 = 1;
            break;
        case ((uint8)127):
            t_t_var_001 = 4;
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:496", (int64)t);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return static_cast<uint16>(t_t_var_001);
}


zeek::RecordValPtr BuildGTPv1Hdr(const GTPv1_Header* pdu)
	{
	auto rv = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::gtpv1_hdr);

	rv->Assign(0, pdu->version());
	rv->Assign(1, pdu->pt_flag());
	rv->Assign(2, pdu->rsv());
	rv->Assign(3, pdu->e_flag());
	rv->Assign(4, pdu->s_flag());
	rv->Assign(5, pdu->pn_flag());
	rv->Assign(6, pdu->msg_type());
	rv->Assign(7, pdu->length());
	rv->Assign(8, pdu->teid());

	if ( pdu->has_opt() )
		{
		rv->Assign(9, pdu->opt_hdr()->seq());
		rv->Assign(10, pdu->opt_hdr()->n_pdu());
		rv->Assign(11, pdu->opt_hdr()->next_type());
		}

	return rv;
	}

static zeek::ValPtr BuildIMSI(const InformationElement* ie)
	{
	return zeek::val_mgr->Count(ie->imsi()->value());
	}

static zeek::RecordValPtr BuildRAI(const InformationElement* ie)
	{
	auto ev = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::gtp_rai);
	ev->Assign(0, ie->rai()->mcc());
	ev->Assign(1, ie->rai()->mnc());
	ev->Assign(2, ie->rai()->lac());
	ev->Assign(3, ie->rai()->rac());
	return ev;
	}

static zeek::ValPtr BuildRecovery(const InformationElement* ie)
	{
	return zeek::val_mgr->Count(ie->recovery()->restart_counter());
	}

static zeek::ValPtr BuildSelectionMode(const InformationElement* ie)
	{
	return zeek::val_mgr->Count(ie->selection_mode()->mode());
	}

static zeek::ValPtr BuildTEID1(const InformationElement* ie)
	{
	return zeek::val_mgr->Count(ie->teid1()->value());
	}

static zeek::ValPtr BuildTEID_ControlPlane(const InformationElement* ie)
	{
	return zeek::val_mgr->Count(ie->teidcp()->value());
	}

static zeek::ValPtr BuildNSAPI(const InformationElement* ie)
	{
	return zeek::val_mgr->Count(ie->nsapi()->nsapi());
	}

static zeek::ValPtr BuildChargingCharacteristics(const InformationElement* ie)
	{
	return zeek::val_mgr->Count(ie->charging_characteristics()->value());
	}

static zeek::ValPtr BuildTraceReference(const InformationElement* ie)
	{
	return zeek::val_mgr->Count(ie->trace_reference()->value());
	}

static zeek::ValPtr BuildTraceType(const InformationElement* ie)
	{
	return zeek::val_mgr->Count(ie->trace_type()->value());
	}

zeek::RecordValPtr BuildEndUserAddr(const InformationElement* ie)
	{
	auto ev = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::gtp_end_user_addr);
	ev->Assign(0, ie->end_user_addr()->pdp_type_org());
	ev->Assign(1, ie->end_user_addr()->pdp_type_num());

	int len = ie->end_user_addr()->pdp_addr().length();

	if ( len > 0 )
		{
		const uint8* d = ie->end_user_addr()->pdp_addr().data();

		switch ( ie->end_user_addr()->pdp_type_num() ) {
		case 0x21:
			ev->Assign(2, zeek::make_intrusive<zeek::AddrVal>(
			  zeek::IPAddr(IPv4, reinterpret_cast<const uint32*>(d), zeek::IPAddr::Network)));
			break;
		case 0x57:
			ev->Assign(2, zeek::make_intrusive<zeek::AddrVal>(
			  zeek::IPAddr(IPv6, reinterpret_cast<const uint32*>(d), zeek::IPAddr::Network)));
			break;
		default:
			ev->Assign(3, new zeek::String((const u_char*) d, len, false));
			break;
		}
		}

	return ev;
	}

zeek::ValPtr BuildAccessPointName(const InformationElement* ie)
	{
	zeek::String* bs = new zeek::String((const u_char*) ie->ap_name()->value().data(),
	                                          ie->ap_name()->value().length(), false);
	return zeek::make_intrusive<zeek::StringVal>(bs);
	}

zeek::ValPtr BuildProtoConfigOptions(const InformationElement* ie)
	{
	const u_char* d = (const u_char*) ie->proto_config_opts()->value().data();
	int len = ie->proto_config_opts()->value().length();
	return zeek::make_intrusive<zeek::StringVal>(new zeek::String(d, len, false));
	}

zeek::RecordValPtr BuildGSN_Addr(const InformationElement* ie)
	{
	auto ev = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::gtp_gsn_addr);

	int len = ie->gsn_addr()->value().length();
	const uint8* d = ie->gsn_addr()->value().data();

	if ( len == 4 )
		ev->Assign(0, zeek::make_intrusive<zeek::AddrVal>(
		  zeek::IPAddr(IPv4, reinterpret_cast<const uint32*>(d), zeek::IPAddr::Network)));
	else if ( len == 16 )
		ev->Assign(0, zeek::make_intrusive<zeek::AddrVal>(
		  zeek::IPAddr(IPv6, reinterpret_cast<const uint32*>(d), zeek::IPAddr::Network)));
	else
		ev->Assign(1, new zeek::String((const u_char*) d, len, false));

	return ev;
	}

zeek::ValPtr BuildMSISDN(const InformationElement* ie)
	{
	const u_char* d = (const u_char*) ie->msisdn()->value().data();
	int len = ie->msisdn()->value().length();
	return zeek::make_intrusive<zeek::StringVal>(new zeek::String(d, len, false));
	}

zeek::RecordValPtr BuildQoS_Profile(const InformationElement* ie)
	{
	auto ev = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::gtp_qos_profile);

	const u_char* d = (const u_char*) ie->qos_profile()->data().data();
	int len = ie->qos_profile()->data().length();

	ev->Assign(0, ie->qos_profile()->alloc_retention_priority());
	ev->Assign(1, new zeek::String(d, len, false));

	return ev;
	}

zeek::ValPtr BuildTrafficFlowTemplate(const InformationElement* ie)
	{
	const uint8* d = ie->traffic_flow_template()->value().data();
	int len = ie->traffic_flow_template()->value().length();
	return zeek::make_intrusive<zeek::StringVal>(new zeek::String((const u_char*) d, len, false));
	}

zeek::ValPtr BuildTriggerID(const InformationElement* ie)
	{
	const uint8* d = ie->trigger_id()->value().data();
	int len = ie->trigger_id()->value().length();
	return zeek::make_intrusive<zeek::StringVal>(new zeek::String((const u_char*) d, len, false));
	}

zeek::ValPtr BuildOMC_ID(const InformationElement* ie)
	{
	const uint8* d = ie->omc_id()->value().data();
	int len = ie->omc_id()->value().length();
	return zeek::make_intrusive<zeek::StringVal>(new zeek::String((const u_char*) d, len, false));
	}

zeek::RecordValPtr BuildPrivateExt(const InformationElement* ie)
	{
	auto ev = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::gtp_private_extension);

	const uint8* d = ie->private_ext()->value().data();
	int len = ie->private_ext()->value().length();

	ev->Assign(0, ie->private_ext()->id());
	ev->Assign(1, new zeek::String((const u_char*) d, len, false));

	return ev;
	}

static zeek::ValPtr BuildCause(const InformationElement* ie)
	{
	return zeek::val_mgr->Count(ie->cause()->value());
	}

static zeek::ValPtr BuildReorderReq(const InformationElement* ie)
	{
	return zeek::val_mgr->Bool(ie->reorder_req()->req());
	}

static zeek::ValPtr BuildChargingID(const InformationElement* ie)
	{
	return zeek::val_mgr->Count(ie->charging_id()->value());;
	}

zeek::ValPtr BuildChargingGatewayAddr(const InformationElement* ie)
	{
	const uint8* d = ie->charging_gateway_addr()->value().data();
	int len = ie->charging_gateway_addr()->value().length();
	if ( len == 4 )
		return zeek::make_intrusive<zeek::AddrVal>(zeek::IPAddr(IPv4, reinterpret_cast<const uint32*>(d), zeek::IPAddr::Network));
	else if ( len == 16 )
		return zeek::make_intrusive<zeek::AddrVal>(zeek::IPAddr(IPv6, reinterpret_cast<const uint32*>(d), zeek::IPAddr::Network));
	else
		return nullptr;
	}

static zeek::ValPtr BuildTeardownInd(const InformationElement* ie)
	{
	return zeek::val_mgr->Bool(ie->teardown_ind()->ind());
	}

void CreatePDP_Request(const ZeekPacketAnalyzer& a, zeek::Connection* c, const GTPv1_Header* pdu)
	{
	if ( ! ::gtpv1_create_pdp_ctx_request ) return;

	auto rv = zeek::make_intrusive<zeek::RecordVal>(
	  zeek::BifType::Record::gtp_create_pdp_ctx_request_elements);

	const vector<InformationElement *> * v = pdu->create_pdp_ctx_request();

	bool second_nsapi = false;
	bool second_gsn_addr = false;

	for ( InformationElement* ie : *v )
		{
		switch ( ie->type() ) {
		case GTPv1::TYPE_IMSI:
			rv->Assign(0, BuildIMSI(ie));
			break;
		case GTPv1::TYPE_RAI:
			rv->Assign(1, BuildRAI(ie));
			break;
		case GTPv1::TYPE_RECOVERY:
			rv->Assign(2, BuildRecovery(ie));
			break;
		case GTPv1::TYPE_SELECTION_MODE:
			rv->Assign(3, BuildSelectionMode(ie));
			break;
		case GTPv1::TYPE_TEID1:
			rv->Assign(4, BuildTEID1(ie));
			break;
		case GTPv1::TYPE_TEID_CONTROL_PLANE:
			rv->Assign(5, BuildTEID_ControlPlane(ie));
			break;
		case GTPv1::TYPE_NSAPI:
			if ( second_nsapi )
				rv->Assign(7, BuildNSAPI(ie));
			else
				{
				second_nsapi = true;
				rv->Assign(6, BuildNSAPI(ie));
				}
			break;
		case GTPv1::TYPE_CHARGING_CHARACTERISTICS:
			rv->Assign(8, BuildChargingCharacteristics(ie));
			break;
		case GTPv1::TYPE_TRACE_REFERENCE:
			rv->Assign(9, BuildTraceReference(ie));
			break;
		case GTPv1::TYPE_TRACE_TYPE:
			rv->Assign(10, BuildTraceType(ie));
			break;
		case GTPv1::TYPE_END_USER_ADDR:
			rv->Assign(11, BuildEndUserAddr(ie));
			break;
		case GTPv1::TYPE_ACCESS_POINT_NAME:
			rv->Assign(12, BuildAccessPointName(ie));
			break;
		case GTPv1::TYPE_PROTO_CONFIG_OPTIONS:
			rv->Assign(13, BuildProtoConfigOptions(ie));
			break;
		case GTPv1::TYPE_GSN_ADDR:
			if ( second_gsn_addr )
				rv->Assign(15, BuildGSN_Addr(ie));
			else
				{
				second_gsn_addr = true;
				rv->Assign(14, BuildGSN_Addr(ie));
				}
			break;
		case GTPv1::TYPE_MSISDN:
			rv->Assign(16, BuildMSISDN(ie));
			break;
		case GTPv1::TYPE_QOS_PROFILE:
			rv->Assign(17, BuildQoS_Profile(ie));
			break;
		case GTPv1::TYPE_TRAFFIC_FLOW_TEMPLATE:
			rv->Assign(18, BuildTrafficFlowTemplate(ie));
			break;
		case GTPv1::TYPE_TRIGGER_ID:
			rv->Assign(19, BuildTriggerID(ie));
			break;
		case GTPv1::TYPE_OMC_ID:
			rv->Assign(20, BuildOMC_ID(ie));
			break;
		case GTPv1::TYPE_PRIVATE_EXT:
			rv->Assign(21, BuildPrivateExt(ie));
			break;
		default:
			a->Weird("gtp_invalid_info_element", nullptr, zeek::util::fmt("%d", ie->type()));
			break;
		}
		}

	zeek::BifEvent::enqueue_gtpv1_create_pdp_ctx_request(nullptr, c, BuildGTPv1Hdr(pdu), std::move(rv));
	}

void CreatePDP_Response(const ZeekPacketAnalyzer& a, zeek::Connection* c, const GTPv1_Header* pdu)
	{
	if ( ! ::gtpv1_create_pdp_ctx_response )
	    return;

	auto rv = zeek::make_intrusive<zeek::RecordVal>(
	  zeek::BifType::Record::gtp_create_pdp_ctx_response_elements);

	const vector<InformationElement *> * v = pdu->create_pdp_ctx_response();

	bool second_gsn_addr = false;

	for ( InformationElement* ie : *v )
		{
		switch ( ie->type() ) {
		case GTPv1::TYPE_CAUSE:
			rv->Assign(0, BuildCause(ie));
			break;
		case GTPv1::TYPE_REORDER_REQ:
			rv->Assign(1, BuildReorderReq(ie));
			break;
		case GTPv1::TYPE_RECOVERY:
			rv->Assign(2, BuildRecovery(ie));
			break;
		case GTPv1::TYPE_TEID1:
			rv->Assign(3, BuildTEID1(ie));
			break;
		case GTPv1::TYPE_TEID_CONTROL_PLANE:
			rv->Assign(4, BuildTEID_ControlPlane(ie));
			break;
		case GTPv1::TYPE_CHARGING_ID:
			rv->Assign(5, BuildChargingID(ie));
			break;
		case GTPv1::TYPE_END_USER_ADDR:
			rv->Assign(6, BuildEndUserAddr(ie));
			break;
		case GTPv1::TYPE_PROTO_CONFIG_OPTIONS:
			rv->Assign(7, BuildProtoConfigOptions(ie));
			break;
		case GTPv1::TYPE_GSN_ADDR:
			if ( second_gsn_addr )
				rv->Assign(9, BuildGSN_Addr(ie));
			else
				{
				second_gsn_addr = true;
				rv->Assign(8, BuildGSN_Addr(ie));
				}
			break;
		case GTPv1::TYPE_QOS_PROFILE:
			rv->Assign(10, BuildQoS_Profile(ie));
			break;
		case GTPv1::TYPE_CHARGING_GATEWAY_ADDR:
			rv->Assign(11, BuildChargingGatewayAddr(ie));
			break;
		case GTPv1::TYPE_PRIVATE_EXT:
			rv->Assign(12, BuildPrivateExt(ie));
			break;
		default:
			a->Weird("gtp_invalid_info_element", nullptr, zeek::util::fmt("%d", ie->type()));
			break;
		}
		}

	zeek::BifEvent::enqueue_gtpv1_create_pdp_ctx_response(nullptr, c, BuildGTPv1Hdr(pdu), std::move(rv));
	}

void UpdatePDP_Request(const ZeekPacketAnalyzer& a, zeek::Connection* c, const GTPv1_Header* pdu)
	{
	if ( ! ::gtpv1_update_pdp_ctx_request )
	    return;

	auto rv = zeek::make_intrusive<zeek::RecordVal>(
	  zeek::BifType::Record::gtp_update_pdp_ctx_request_elements);

	const vector<InformationElement *> * v = pdu->update_pdp_ctx_request();

	bool second_gsn_addr = false;

	for ( InformationElement* ie : *v )
		{
		switch ( ie->type() ) {
		case GTPv1::TYPE_IMSI:
			rv->Assign(0, BuildIMSI(ie));
			break;
		case GTPv1::TYPE_RAI:
			rv->Assign(1, BuildRAI(ie));
			break;
		case GTPv1::TYPE_RECOVERY:
			rv->Assign(2, BuildRecovery(ie));
			break;
		case GTPv1::TYPE_TEID1:
			rv->Assign(3, BuildTEID1(ie));
			break;
		case GTPv1::TYPE_TEID_CONTROL_PLANE:
			rv->Assign(4, BuildTEID_ControlPlane(ie));
			break;
		case GTPv1::TYPE_NSAPI:
			rv->Assign(5, BuildNSAPI(ie));
			break;
		case GTPv1::TYPE_TRACE_REFERENCE:
			rv->Assign(6, BuildTraceReference(ie));
			break;
		case GTPv1::TYPE_TRACE_TYPE:
			rv->Assign(7, BuildTraceType(ie));
			break;
		case GTPv1::TYPE_GSN_ADDR:
			if ( second_gsn_addr )
				rv->Assign(9, BuildGSN_Addr(ie));
			else
				{
				second_gsn_addr = true;
				rv->Assign(8, BuildGSN_Addr(ie));
				}
			break;
		case GTPv1::TYPE_QOS_PROFILE:
			rv->Assign(10, BuildQoS_Profile(ie));
			break;
		case GTPv1::TYPE_TRAFFIC_FLOW_TEMPLATE:
			rv->Assign(11, BuildTrafficFlowTemplate(ie));
			break;
		case GTPv1::TYPE_TRIGGER_ID:
			rv->Assign(12, BuildTriggerID(ie));
			break;
		case GTPv1::TYPE_OMC_ID:
			rv->Assign(13, BuildOMC_ID(ie));
			break;
		case GTPv1::TYPE_PRIVATE_EXT:
			rv->Assign(14, BuildPrivateExt(ie));
			break;
		case GTPv1::TYPE_END_USER_ADDR:
			rv->Assign(15, BuildEndUserAddr(ie));
			break;
		default:
			a->Weird("gtp_invalid_info_element", nullptr, zeek::util::fmt("%d", ie->type()));
			break;
		}
		}

	zeek::BifEvent::enqueue_gtpv1_update_pdp_ctx_request(nullptr, c, BuildGTPv1Hdr(pdu), std::move(rv));
	}

void UpdatePDP_Response(const ZeekPacketAnalyzer& a, zeek::Connection* c, const GTPv1_Header* pdu)
	{
	if ( ! ::gtpv1_update_pdp_ctx_response )
	    return;

	auto rv = zeek::make_intrusive<zeek::RecordVal>(
	  zeek::BifType::Record::gtp_update_pdp_ctx_response_elements);

	const vector<InformationElement *> * v = pdu->update_pdp_ctx_response();

	bool second_gsn_addr = false;

	for ( InformationElement* ie : *v )
		{
		switch ( ie->type() ) {
		case GTPv1::TYPE_CAUSE:
			rv->Assign(0, BuildCause(ie));
			break;
		case GTPv1::TYPE_RECOVERY:
			rv->Assign(1, BuildRecovery(ie));
			break;
		case GTPv1::TYPE_TEID1:
			rv->Assign(2, BuildTEID1(ie));
			break;
		case GTPv1::TYPE_TEID_CONTROL_PLANE:
			rv->Assign(3, BuildTEID_ControlPlane(ie));
			break;
		case GTPv1::TYPE_CHARGING_ID:
			rv->Assign(4, BuildChargingID(ie));
			break;
		case GTPv1::TYPE_GSN_ADDR:
			if ( second_gsn_addr )
				rv->Assign(6, BuildGSN_Addr(ie));
			else
				{
				second_gsn_addr = true;
				rv->Assign(5, BuildGSN_Addr(ie));
				}
			break;
		case GTPv1::TYPE_QOS_PROFILE:
			rv->Assign(7, BuildQoS_Profile(ie));
			break;
		case GTPv1::TYPE_CHARGING_GATEWAY_ADDR:
			rv->Assign(8, BuildChargingGatewayAddr(ie));
			break;
		case GTPv1::TYPE_PRIVATE_EXT:
			rv->Assign(9, BuildPrivateExt(ie));
			break;
		default:
			a->Weird("gtp_invalid_info_element", nullptr, zeek::util::fmt("%d", ie->type()));
			break;
		}
		}

	zeek::BifEvent::enqueue_gtpv1_update_pdp_ctx_response(nullptr, c, BuildGTPv1Hdr(pdu), std::move(rv));
	}

void DeletePDP_Request(const ZeekPacketAnalyzer& a, zeek::Connection* c, const GTPv1_Header* pdu)
	{
	if ( ! ::gtpv1_delete_pdp_ctx_request )
		return;

	auto rv = zeek::make_intrusive<zeek::RecordVal>(
	  zeek::BifType::Record::gtp_delete_pdp_ctx_request_elements);

	const vector<InformationElement *> * v = pdu->delete_pdp_ctx_request();

	for ( InformationElement* ie : *v )
		{
		switch ( ie->type() ) {
		case GTPv1::TYPE_TEARDOWN_IND:
			rv->Assign(0, BuildTeardownInd(ie));
			break;
		case GTPv1::TYPE_NSAPI:
			rv->Assign(1, BuildNSAPI(ie));
			break;
		case GTPv1::TYPE_PRIVATE_EXT:
			rv->Assign(2, BuildPrivateExt(ie));
			break;
		default:
			a->Weird("gtp_invalid_info_element", nullptr, zeek::util::fmt("%d", ie->type()));
			break;
		}
		}

	zeek::BifEvent::enqueue_gtpv1_delete_pdp_ctx_request(nullptr, c, BuildGTPv1Hdr(pdu), std::move(rv));
	}

void DeletePDP_Response(const ZeekPacketAnalyzer& a, zeek::Connection* c, const GTPv1_Header* pdu)
	{
	if ( ! ::gtpv1_delete_pdp_ctx_response )
		return;

	auto rv = zeek::make_intrusive<zeek::RecordVal>(
	  zeek::BifType::Record::gtp_delete_pdp_ctx_response_elements);

	const vector<InformationElement *> * v = pdu->delete_pdp_ctx_response();

	for ( InformationElement* ie : *v )
		{
		switch ( ie->type() ) {
		case GTPv1::TYPE_CAUSE:
			rv->Assign(0, BuildCause(ie));
			break;
		case GTPv1::TYPE_PRIVATE_EXT:
			rv->Assign(1, BuildPrivateExt(ie));
			break;
		default:
			a->Weird("gtp_invalid_info_element", nullptr, zeek::util::fmt("%d", ie->type()));
			break;
		}
		}

	zeek::BifEvent::enqueue_gtpv1_delete_pdp_ctx_response(nullptr, c, BuildGTPv1Hdr(pdu), std::move(rv));
	}

// NOLINTNEXTLINE(modernize-use-equals-default)
GTPv1_Conn::GTPv1_Conn(ZeekPacketAnalyzer const& zeek_analyzer) {
    upflow_ = new GTPv1_Flow(this, true);
    downflow_ = new GTPv1_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		valid_orig = false;
		valid_resp = false;
		packet = nullptr;
	
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GTPv1_Conn::~GTPv1_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void GTPv1_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void GTPv1_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void GTPv1_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool GTPv1_Conn::valid(bool orig) {

		return orig ? valid_orig : valid_resp;
		
}

void GTPv1_Conn::set_valid(bool orig, bool val) {

		if ( orig )
			valid_orig = val;
		else
			valid_resp = val;
		
}

void GTPv1_Conn::set_raw_packet(ZeekPacket* p) {

		packet = p;
		
}

ZeekPacket* GTPv1_Conn::get_raw_packet() {

		return packet;
		
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GTPv1_Flow::GTPv1_Flow(GTPv1_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
GTPv1_Flow::~GTPv1_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void GTPv1_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new GTPv1_Header();
        context_ = new ContextGTPv1(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e; // NOLINT(bugprone-exception-copy-constructor-throws)
    }
}

void GTPv1_Flow::NewGap(int gap_length) {
}
void GTPv1_Flow::FlowEOF() {
}
void GTPv1_Flow::violate(string const& r, GTPv1_Header* pdu) {

		ZeekPacketAnalyzer a = connection()->zeek_analyzer();
		ZeekPacket* p = connection()->get_raw_packet();
		a->AnalyzerViolation(r.c_str(), p->session);
		
}

bool GTPv1_Flow::process_gtpv1(GTPv1_Header* pdu) {

		ZeekPacketAnalyzer a = connection()->zeek_analyzer();
		ZeekPacket* p = connection()->get_raw_packet();
		zeek::Connection* c = static_cast<zeek::Connection*>(p->session);
		const std::shared_ptr<zeek::EncapsulationStack> e = p->encap;

		connection()->set_valid(is_orig(), false);

		if ( e && e->Depth() >= zeek::BifConst::Tunnel::max_depth )
			{
			a->Weird("tunnel_depth");
			return false;
			}

		if ( e && e->LastType() == BifEnum::Tunnel::GTPv1 )
			{
			// GTP is never tunneled in GTP so, this must be a regular packet
			violate("GTP-in-GTP", pdu);
			return false;
			}

		if ( pdu->version() != 1 )
			{
			// Only know of GTPv1 with Version == 1
			violate("GTPv1 bad Version", pdu);
			return false;
			}

		if ( ! pdu->pt_flag() )
			{
			// Not interested in GTP
			return false;
			}

		if ( ::gtpv1_message )
			zeek::BifEvent::enqueue_gtpv1_message(nullptr, c, BuildGTPv1Hdr(pdu));

		switch ( pdu->msg_type() ) {
		case 16:
			CreatePDP_Request(a, c, pdu);
			return true;
		case 17:
			CreatePDP_Response(a, c, pdu);
			return true;
		case 18:
			UpdatePDP_Request(a, c, pdu);
			return true;
		case 19:
			UpdatePDP_Response(a, c, pdu);
			return true;
		case 20:
			DeletePDP_Request(a, c, pdu);
			return true;
		case 21:
			DeletePDP_Response(a, c, pdu);
			return true;
		case 255:
			return process_g_pdu(pdu);
		default:
			return false;
		}

		return false;
		
}

bool GTPv1_Flow::process_g_pdu(GTPv1_Header* pdu) {

		ZeekPacketAnalyzer a = connection()->zeek_analyzer();
		ZeekPacket* p = connection()->get_raw_packet();
		zeek::Connection* c = static_cast<zeek::Connection*>(p->session);

		if ( pdu->packet().length() < (int)sizeof(struct ip) )
			{
			violate("Truncated GTPv1", pdu);
			return false;
			}

		const struct ip* ip = reinterpret_cast<const struct ip*>(pdu->packet().data());

		if ( ip->ip_v != 4 && ip->ip_v != 6 )
			{
			violate("non-IP packet in GTPv1", pdu);
			return false;
			}

		int hdr_len = 8;

		if ( pdu->has_opt() )
			hdr_len += 4;

		if ( pdu->e_flag() && pdu->ext_hdrs() )
			for ( const auto& eh : *pdu->ext_hdrs() )
				hdr_len += 2 + eh->contents().length();

		auto next_hdr = ip->ip_v == 6 ? IPPROTO_IPV6 : IPPROTO_IPV4;
		zeek::RecordValPtr hdr_val;

		if ( ::gtpv1_g_pdu_packet )
			hdr_val = BuildGTPv1Hdr(pdu);

		static_cast<zeek::packet_analysis::gtpv1::GTPv1_Analyzer*>(a)->SetInnerInfo(
			hdr_len, next_hdr, std::move(hdr_val));

		return true;
		
}

} // namespace GTPv1
}  // namespace binpac
