/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "/build/zeek/src/zeek/src/parse.y"

// See the file "COPYING" in the main distribution directory for copyright.
#line 85 "/build/zeek/src/zeek/src/parse.y"

#include <cassert>
#include <cinttypes>
#include <cstdlib>
#include <cstring>
#include <set>
#include <string>

#include "zeek/Desc.h"
#include "zeek/Expr.h"
#include "zeek/Func.h"
#include "zeek/IntrusivePtr.h"
#include "zeek/RE.h"
#include "zeek/Reporter.h"
#include "zeek/Scope.h"
#include "zeek/ScriptCoverageManager.h"
#include "zeek/ScriptValidation.h"
#include "zeek/Stmt.h"
#include "zeek/Val.h"
#include "zeek/Var.h"
#include "zeek/ZeekList.h"
#include "zeek/input.h"
#include "zeek/module_util.h"
#include "zeek/zeekygen/Manager.h"
#include "zeek/DebugLogger.h"

extern const char* filename;      // Absolute path of file currently being parsed.
extern const char* last_filename; // Absolute path of last file parsed.
extern const char* last_tok_filename;
extern const char* last_last_tok_filename;

extern int conditional_epoch; // let's us track embedded conditionals

// Whether the file we're currently parsing includes @if conditionals.
extern bool current_file_has_conditionals;

extern YYLTYPE GetCurrentLocation();
extern int yyerror(const char[]);
extern int zeeklex();

#define YYLLOC_DEFAULT(Current, Rhs, N) (Current) = (Rhs)[(N)];

using namespace zeek;
using namespace zeek::detail;

// Part of the module facility: while parsing, keep track of which
// module to put things in.
std::string zeek::detail::current_module = GLOBAL_MODULE_NAME;

bool is_export = false; // true if in an export {} block

// Used to temporarily turn off "is_export". A stack because the need
// to do so can nest.
std::vector<bool> hold_is_export;

// When parsing an expression for the debugger, where to put the result
// (obviously not reentrant).
extern Expr* g_curr_debug_expr;
extern bool in_debug;
extern const char* g_curr_debug_error;

extern int in_when_cond;

static int in_hook = 0;
int in_init = 0;
int in_record = 0;
static int in_record_redef = 0;
static int in_enum_redef = 0;
bool resolving_global_ID = false;
bool defining_global_ID = false;
std::vector<int> saved_in_init;
static int expr_list_has_opt_comma = 0;

std::vector<std::set<const ID*>> locals_at_this_scope;
static std::unordered_set<const ID*> out_of_scope_locals;

static Location func_hdr_location;
static int func_hdr_cond_epoch = 0;
EnumType* cur_enum_type = nullptr;
static ID* cur_decl_type_id = nullptr;

namespace zeek::detail {
extern bool g_policy_debug;
}

static void parse_new_enum(void) {
    // Starting a new enum definition.
    assert(cur_enum_type == nullptr);

    if ( cur_decl_type_id ) {
        auto name = make_full_var_name(current_module.c_str(), cur_decl_type_id->Name());
        cur_enum_type = new EnumType(name);
    }
    else
        reporter->FatalError("incorrect syntax for enum type declaration");
}

static void parse_redef_enum(ID* id) {
    // Redef an enum. id points to the enum to be redefined.
    // Let cur_enum_type point to it.
    assert(cur_enum_type == nullptr);

    // abort on errors; enums need to be accessible to continue parsing
    if ( ! id->GetType() )
        reporter->FatalError("unknown enum identifier \"%s\"", id->Name());
    else {
        if ( ! id->GetType() || id->GetType()->Tag() != TYPE_ENUM )
            reporter->FatalError("identifier \"%s\" is not an enum", id->Name());
        cur_enum_type = id->GetType()->AsEnumType();
    }
}

static void parse_redef_record_field(ID* id, const char* field, InitClass ic,
                                     std::unique_ptr<std::vector<AttrPtr>> attrs) {
    if ( ! id->GetType() ) {
        reporter->FatalError("unknown record identifier \"%s\"", id->Name());
        return;
    }

    auto t = id->GetType();
    if ( ! t || t->Tag() != TYPE_RECORD ) {
        reporter->FatalError("identifier \"%s\" has type \"%s\", expected \"record\"", id->Name(), type_name(t->Tag()));
        return;
    }

    auto rt = t->AsRecordType();
    auto idx = rt->FieldOffset(field);
    if ( idx < 0 ) {
        reporter->FatalError("field \"%s\" not in record \"%s\"", field, id->Name());
        return;
    }

    auto decl = rt->FieldDecl(idx);
    if ( ! decl->attrs )
        if ( ic == INIT_EXTRA )
            decl->attrs = make_intrusive<detail::Attributes>(decl->type, true /* in_record */, false /* is_global */);

    for ( const auto& attr : *attrs ) {
        // At this point, only support &log redef'ing.
        if ( attr->Tag() != ATTR_LOG ) {
            reporter->FatalError("Can only redef \"&log\" attributes of record fields");
            return;
        }

        if ( ic == INIT_EXTRA )
            decl->attrs->AddAttr(attr, true /* is_redef */);
        else
            // Removing attributes is a noop if they don't exist.
            if ( decl->attrs )
                decl->attrs->RemoveAttr(attr->Tag());
    }
}

static void extend_record(ID* id, std::unique_ptr<type_decl_list> fields, std::unique_ptr<std::vector<AttrPtr>> attrs) {
    const auto& types = Type::Aliases(id->Name());

    if ( types.empty() ) {
        id->Error("failed to redef record: no types found in alias map");
        return;
    }

    bool add_log_attr = false;

    if ( attrs )
        for ( const auto& at : *attrs )
            if ( at->Tag() == ATTR_LOG ) {
                add_log_attr = true;
                break;
            }

    for ( const auto& t : types ) {
        auto error = t->AsRecordType()->AddFields(*fields, add_log_attr);

        if ( error ) {
            id->Error(error);
            break;
        }
    }
}

static AttributesPtr make_attributes(std::vector<AttrPtr>* attrs, TypePtr t, bool in_record, bool is_param) {
    if ( ! attrs )
        return nullptr;

    auto rval = make_intrusive<Attributes>(std::move(*attrs), std::move(t), in_record, /*is_global=*/false, is_param);
    delete attrs;
    return rval;
}

static bool expr_is_table_type_name(const Expr* expr) {
    if ( expr->Tag() != EXPR_NAME )
        return false;

    const auto& type = expr->GetType();

    if ( type->IsTable() )
        return true;

    if ( type->Tag() == TYPE_TYPE )
        return type->AsTypeType()->GetType()->IsTable();

    return false;
}

static void check_loop_var(const IDPtr& var) {
    if ( var->IsGlobal() )
        var->Error("global variable used in 'for' loop");

    if ( var->IsConst() )
        var->Error("constant used in 'for' loop");
}

static void build_global(ID* id, Type* t, InitClass ic, Expr* e, std::vector<AttrPtr>* attrs, DeclType dt) {
    IDPtr id_ptr{AdoptRef{}, id};
    TypePtr t_ptr{AdoptRef{}, t};
    ExprPtr e_ptr{AdoptRef{}, e};

    auto attrs_ptr = attrs ? std::make_unique<std::vector<AttrPtr>>(*attrs) : nullptr;

    add_global(id_ptr, std::move(t_ptr), ic, e_ptr, std::move(attrs_ptr), dt);

    if ( dt == VAR_REDEF )
        zeekygen_mgr->Redef(id, ::filename, ic, std::move(e_ptr));
    else
        zeekygen_mgr->Identifier(std::move(id_ptr));
}

static StmtPtr build_local(ID* id, Type* t, InitClass ic, Expr* e, std::vector<AttrPtr>* attrs, DeclType dt,
                           bool do_coverage) {
    IDPtr id_ptr{AdoptRef{}, id};
    TypePtr t_ptr{AdoptRef{}, t};
    ExprPtr e_ptr{AdoptRef{}, e};

    auto attrs_ptr = attrs ? std::make_unique<std::vector<AttrPtr>>(*attrs) : nullptr;

    auto init = add_local(std::move(id_ptr), std::move(t_ptr), ic, e_ptr, std::move(attrs_ptr), dt);

    if ( do_coverage )
        script_coverage_mgr.AddStmt(init.get());

    return init;
}

static void refine_location(zeek::detail::ID* id) {
    if ( *id->GetLocationInfo() == zeek::detail::no_location )
        id->SetLocationInfo(&detail::start_location, &detail::end_location);
}


#line 324 "/build/zeek/src/zeek/build/src/p.cc"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "zeekparse.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TOK_ADD = 3,                    /* TOK_ADD  */
  YYSYMBOL_TOK_ADD_TO = 4,                 /* TOK_ADD_TO  */
  YYSYMBOL_TOK_ADDR = 5,                   /* TOK_ADDR  */
  YYSYMBOL_TOK_ANY = 6,                    /* TOK_ANY  */
  YYSYMBOL_TOK_ASSERT = 7,                 /* TOK_ASSERT  */
  YYSYMBOL_TOK_ATENDIF = 8,                /* TOK_ATENDIF  */
  YYSYMBOL_TOK_ATELSE = 9,                 /* TOK_ATELSE  */
  YYSYMBOL_TOK_ATIF = 10,                  /* TOK_ATIF  */
  YYSYMBOL_TOK_ATIFDEF = 11,               /* TOK_ATIFDEF  */
  YYSYMBOL_TOK_ATIFNDEF = 12,              /* TOK_ATIFNDEF  */
  YYSYMBOL_TOK_BOOL = 13,                  /* TOK_BOOL  */
  YYSYMBOL_TOK_BREAK = 14,                 /* TOK_BREAK  */
  YYSYMBOL_TOK_CASE = 15,                  /* TOK_CASE  */
  YYSYMBOL_TOK_OPTION = 16,                /* TOK_OPTION  */
  YYSYMBOL_TOK_CONST = 17,                 /* TOK_CONST  */
  YYSYMBOL_TOK_CONSTANT = 18,              /* TOK_CONSTANT  */
  YYSYMBOL_TOK_COPY = 19,                  /* TOK_COPY  */
  YYSYMBOL_TOK_COUNT = 20,                 /* TOK_COUNT  */
  YYSYMBOL_TOK_DEFAULT = 21,               /* TOK_DEFAULT  */
  YYSYMBOL_TOK_DELETE = 22,                /* TOK_DELETE  */
  YYSYMBOL_TOK_DOUBLE = 23,                /* TOK_DOUBLE  */
  YYSYMBOL_TOK_ELSE = 24,                  /* TOK_ELSE  */
  YYSYMBOL_TOK_ENUM = 25,                  /* TOK_ENUM  */
  YYSYMBOL_TOK_EVENT = 26,                 /* TOK_EVENT  */
  YYSYMBOL_TOK_EXPORT = 27,                /* TOK_EXPORT  */
  YYSYMBOL_TOK_FALLTHROUGH = 28,           /* TOK_FALLTHROUGH  */
  YYSYMBOL_TOK_FILE = 29,                  /* TOK_FILE  */
  YYSYMBOL_TOK_FOR = 30,                   /* TOK_FOR  */
  YYSYMBOL_TOK_FUNCTION = 31,              /* TOK_FUNCTION  */
  YYSYMBOL_TOK_GLOBAL = 32,                /* TOK_GLOBAL  */
  YYSYMBOL_TOK_HOOK = 33,                  /* TOK_HOOK  */
  YYSYMBOL_TOK_ID = 34,                    /* TOK_ID  */
  YYSYMBOL_TOK_IF = 35,                    /* TOK_IF  */
  YYSYMBOL_TOK_INT = 36,                   /* TOK_INT  */
  YYSYMBOL_TOK_INTERVAL = 37,              /* TOK_INTERVAL  */
  YYSYMBOL_TOK_MODULE = 38,                /* TOK_MODULE  */
  YYSYMBOL_TOK_LOCAL = 39,                 /* TOK_LOCAL  */
  YYSYMBOL_TOK_WHEN_LOCAL = 40,            /* TOK_WHEN_LOCAL  */
  YYSYMBOL_TOK_NEXT = 41,                  /* TOK_NEXT  */
  YYSYMBOL_TOK_OF = 42,                    /* TOK_OF  */
  YYSYMBOL_TOK_OPAQUE = 43,                /* TOK_OPAQUE  */
  YYSYMBOL_TOK_PATTERN = 44,               /* TOK_PATTERN  */
  YYSYMBOL_TOK_PATTERN_END = 45,           /* TOK_PATTERN_END  */
  YYSYMBOL_TOK_PATTERN_TEXT = 46,          /* TOK_PATTERN_TEXT  */
  YYSYMBOL_TOK_PORT = 47,                  /* TOK_PORT  */
  YYSYMBOL_TOK_PRINT = 48,                 /* TOK_PRINT  */
  YYSYMBOL_TOK_RECORD = 49,                /* TOK_RECORD  */
  YYSYMBOL_TOK_REDEF = 50,                 /* TOK_REDEF  */
  YYSYMBOL_TOK_REMOVE_FROM = 51,           /* TOK_REMOVE_FROM  */
  YYSYMBOL_TOK_RETURN = 52,                /* TOK_RETURN  */
  YYSYMBOL_TOK_SCHEDULE = 53,              /* TOK_SCHEDULE  */
  YYSYMBOL_TOK_SET = 54,                   /* TOK_SET  */
  YYSYMBOL_TOK_STRING = 55,                /* TOK_STRING  */
  YYSYMBOL_TOK_SUBNET = 56,                /* TOK_SUBNET  */
  YYSYMBOL_TOK_SWITCH = 57,                /* TOK_SWITCH  */
  YYSYMBOL_TOK_TABLE = 58,                 /* TOK_TABLE  */
  YYSYMBOL_TOK_TIME = 59,                  /* TOK_TIME  */
  YYSYMBOL_TOK_TIMEOUT = 60,               /* TOK_TIMEOUT  */
  YYSYMBOL_TOK_TYPE = 61,                  /* TOK_TYPE  */
  YYSYMBOL_TOK_VECTOR = 62,                /* TOK_VECTOR  */
  YYSYMBOL_TOK_WHEN = 63,                  /* TOK_WHEN  */
  YYSYMBOL_TOK_WHILE = 64,                 /* TOK_WHILE  */
  YYSYMBOL_TOK_AS = 65,                    /* TOK_AS  */
  YYSYMBOL_TOK_IS = 66,                    /* TOK_IS  */
  YYSYMBOL_TOK_GLOBAL_ID = 67,             /* TOK_GLOBAL_ID  */
  YYSYMBOL_TOK_ATTR_ADD_FUNC = 68,         /* TOK_ATTR_ADD_FUNC  */
  YYSYMBOL_TOK_ATTR_DEFAULT = 69,          /* TOK_ATTR_DEFAULT  */
  YYSYMBOL_TOK_ATTR_DEFAULT_INSERT = 70,   /* TOK_ATTR_DEFAULT_INSERT  */
  YYSYMBOL_TOK_ATTR_OPTIONAL = 71,         /* TOK_ATTR_OPTIONAL  */
  YYSYMBOL_TOK_ATTR_REDEF = 72,            /* TOK_ATTR_REDEF  */
  YYSYMBOL_TOK_ATTR_DEL_FUNC = 73,         /* TOK_ATTR_DEL_FUNC  */
  YYSYMBOL_TOK_ATTR_EXPIRE_FUNC = 74,      /* TOK_ATTR_EXPIRE_FUNC  */
  YYSYMBOL_TOK_ATTR_EXPIRE_CREATE = 75,    /* TOK_ATTR_EXPIRE_CREATE  */
  YYSYMBOL_TOK_ATTR_EXPIRE_READ = 76,      /* TOK_ATTR_EXPIRE_READ  */
  YYSYMBOL_TOK_ATTR_EXPIRE_WRITE = 77,     /* TOK_ATTR_EXPIRE_WRITE  */
  YYSYMBOL_TOK_ATTR_RAW_OUTPUT = 78,       /* TOK_ATTR_RAW_OUTPUT  */
  YYSYMBOL_TOK_ATTR_ON_CHANGE = 79,        /* TOK_ATTR_ON_CHANGE  */
  YYSYMBOL_TOK_ATTR_BROKER_STORE = 80,     /* TOK_ATTR_BROKER_STORE  */
  YYSYMBOL_TOK_ATTR_BROKER_STORE_ALLOW_COMPLEX = 81, /* TOK_ATTR_BROKER_STORE_ALLOW_COMPLEX  */
  YYSYMBOL_TOK_ATTR_BACKEND = 82,          /* TOK_ATTR_BACKEND  */
  YYSYMBOL_TOK_ATTR_PRIORITY = 83,         /* TOK_ATTR_PRIORITY  */
  YYSYMBOL_TOK_ATTR_LOG = 84,              /* TOK_ATTR_LOG  */
  YYSYMBOL_TOK_ATTR_ERROR_HANDLER = 85,    /* TOK_ATTR_ERROR_HANDLER  */
  YYSYMBOL_TOK_ATTR_GROUP = 86,            /* TOK_ATTR_GROUP  */
  YYSYMBOL_TOK_ATTR_TYPE_COLUMN = 87,      /* TOK_ATTR_TYPE_COLUMN  */
  YYSYMBOL_TOK_ATTR_DEPRECATED = 88,       /* TOK_ATTR_DEPRECATED  */
  YYSYMBOL_TOK_ATTR_IS_ASSIGNED = 89,      /* TOK_ATTR_IS_ASSIGNED  */
  YYSYMBOL_TOK_ATTR_IS_USED = 90,          /* TOK_ATTR_IS_USED  */
  YYSYMBOL_TOK_ATTR_ORDERED = 91,          /* TOK_ATTR_ORDERED  */
  YYSYMBOL_TOK_ATTR_NO_ZAM_OPT = 92,       /* TOK_ATTR_NO_ZAM_OPT  */
  YYSYMBOL_TOK_ATTR_NO_CPP_OPT = 93,       /* TOK_ATTR_NO_CPP_OPT  */
  YYSYMBOL_TOK_DEBUG = 94,                 /* TOK_DEBUG  */
  YYSYMBOL_TOK_NO_TEST = 95,               /* TOK_NO_TEST  */
  YYSYMBOL_96_ = 96,                       /* ','  */
  YYSYMBOL_97_ = 97,                       /* '='  */
  YYSYMBOL_98_ = 98,                       /* '?'  */
  YYSYMBOL_99_ = 99,                       /* ':'  */
  YYSYMBOL_TOK_OR_OR = 100,                /* TOK_OR_OR  */
  YYSYMBOL_TOK_AND_AND = 101,              /* TOK_AND_AND  */
  YYSYMBOL_102_ = 102,                     /* '<'  */
  YYSYMBOL_103_ = 103,                     /* '>'  */
  YYSYMBOL_TOK_LE = 104,                   /* TOK_LE  */
  YYSYMBOL_TOK_GE = 105,                   /* TOK_GE  */
  YYSYMBOL_TOK_EQ = 106,                   /* TOK_EQ  */
  YYSYMBOL_TOK_NE = 107,                   /* TOK_NE  */
  YYSYMBOL_TOK_IN = 108,                   /* TOK_IN  */
  YYSYMBOL_TOK_NOT_IN = 109,               /* TOK_NOT_IN  */
  YYSYMBOL_110_ = 110,                     /* '|'  */
  YYSYMBOL_111_ = 111,                     /* '^'  */
  YYSYMBOL_112_ = 112,                     /* '&'  */
  YYSYMBOL_TOK_LSHIFT = 113,               /* TOK_LSHIFT  */
  YYSYMBOL_TOK_RSHIFT = 114,               /* TOK_RSHIFT  */
  YYSYMBOL_115_ = 115,                     /* '+'  */
  YYSYMBOL_116_ = 116,                     /* '-'  */
  YYSYMBOL_117_ = 117,                     /* '*'  */
  YYSYMBOL_118_ = 118,                     /* '/'  */
  YYSYMBOL_119_ = 119,                     /* '%'  */
  YYSYMBOL_TOK_INCR = 120,                 /* TOK_INCR  */
  YYSYMBOL_TOK_DECR = 121,                 /* TOK_DECR  */
  YYSYMBOL_122_ = 122,                     /* '!'  */
  YYSYMBOL_123_ = 123,                     /* '~'  */
  YYSYMBOL_124_ = 124,                     /* '$'  */
  YYSYMBOL_125_ = 125,                     /* '['  */
  YYSYMBOL_126_ = 126,                     /* ']'  */
  YYSYMBOL_127_ = 127,                     /* '('  */
  YYSYMBOL_128_ = 128,                     /* ')'  */
  YYSYMBOL_TOK_HAS_FIELD = 129,            /* TOK_HAS_FIELD  */
  YYSYMBOL_130_ = 130,                     /* '{'  */
  YYSYMBOL_131_ = 131,                     /* '}'  */
  YYSYMBOL_132_ = 132,                     /* ';'  */
  YYSYMBOL_YYACCEPT = 133,                 /* $accept  */
  YYSYMBOL_zeek = 134,                     /* zeek  */
  YYSYMBOL_135_1 = 135,                    /* $@1  */
  YYSYMBOL_136_2 = 136,                    /* $@2  */
  YYSYMBOL_decl_list = 137,                /* decl_list  */
  YYSYMBOL_opt_expr = 138,                 /* opt_expr  */
  YYSYMBOL_when_clause = 139,              /* when_clause  */
  YYSYMBOL_when_head = 140,                /* when_head  */
  YYSYMBOL_when_start = 141,               /* when_start  */
  YYSYMBOL_when_flavor = 142,              /* when_flavor  */
  YYSYMBOL_when_captures = 143,            /* when_captures  */
  YYSYMBOL_when_condition = 144,           /* when_condition  */
  YYSYMBOL_145_3 = 145,                    /* $@3  */
  YYSYMBOL_146_4 = 146,                    /* $@4  */
  YYSYMBOL_expr = 147,                     /* expr  */
  YYSYMBOL_148_5 = 148,                    /* $@5  */
  YYSYMBOL_149_6 = 149,                    /* $@6  */
  YYSYMBOL_150_7 = 150,                    /* $@7  */
  YYSYMBOL_151_8 = 151,                    /* $@8  */
  YYSYMBOL_152_9 = 152,                    /* $@9  */
  YYSYMBOL_153_10 = 153,                   /* $@10  */
  YYSYMBOL_154_11 = 154,                   /* $@11  */
  YYSYMBOL_opt_exprs_or_field_assigns = 155, /* opt_exprs_or_field_assigns  */
  YYSYMBOL_field_assigns = 156,            /* field_assigns  */
  YYSYMBOL_field_assign = 157,             /* field_assign  */
  YYSYMBOL_158_12 = 158,                   /* $@12  */
  YYSYMBOL_rhs = 159,                      /* rhs  */
  YYSYMBOL_160_13 = 160,                   /* $@13  */
  YYSYMBOL_rhs_expr_list = 161,            /* rhs_expr_list  */
  YYSYMBOL_expr_list = 162,                /* expr_list  */
  YYSYMBOL_opt_expr_list = 163,            /* opt_expr_list  */
  YYSYMBOL_enum_body = 164,                /* enum_body  */
  YYSYMBOL_enum_body_list = 165,           /* enum_body_list  */
  YYSYMBOL_enum_body_elem = 166,           /* enum_body_elem  */
  YYSYMBOL_simple_type = 167,              /* simple_type  */
  YYSYMBOL_168_14 = 168,                   /* $@14  */
  YYSYMBOL_169_15 = 169,                   /* $@15  */
  YYSYMBOL_170_16 = 170,                   /* $@16  */
  YYSYMBOL_type = 171,                     /* type  */
  YYSYMBOL_type_list = 172,                /* type_list  */
  YYSYMBOL_type_decl_list = 173,           /* type_decl_list  */
  YYSYMBOL_type_decl = 174,                /* type_decl  */
  YYSYMBOL_formal_args = 175,              /* formal_args  */
  YYSYMBOL_formal_args_decl_list = 176,    /* formal_args_decl_list  */
  YYSYMBOL_formal_args_decl = 177,         /* formal_args_decl  */
  YYSYMBOL_decl = 178,                     /* decl  */
  YYSYMBOL_179_17 = 179,                   /* $@17  */
  YYSYMBOL_180_18 = 180,                   /* $@18  */
  YYSYMBOL_181_19 = 181,                   /* $@19  */
  YYSYMBOL_182_20 = 182,                   /* $@20  */
  YYSYMBOL_183_21 = 183,                   /* $@21  */
  YYSYMBOL_184_22 = 184,                   /* $@22  */
  YYSYMBOL_185_23 = 185,                   /* $@23  */
  YYSYMBOL_186_24 = 186,                   /* $@24  */
  YYSYMBOL_187_25 = 187,                   /* $@25  */
  YYSYMBOL_188_26 = 188,                   /* $@26  */
  YYSYMBOL_conditional_list = 189,         /* conditional_list  */
  YYSYMBOL_conditional = 190,              /* conditional  */
  YYSYMBOL_func_hdr = 191,                 /* func_hdr  */
  YYSYMBOL_func_body = 192,                /* func_body  */
  YYSYMBOL_193_27 = 193,                   /* $@27  */
  YYSYMBOL_194_28 = 194,                   /* $@28  */
  YYSYMBOL_lambda_body = 195,              /* lambda_body  */
  YYSYMBOL_196_29 = 196,                   /* $@29  */
  YYSYMBOL_197_30 = 197,                   /* $@30  */
  YYSYMBOL_anonymous_function = 198,       /* anonymous_function  */
  YYSYMBOL_199_31 = 199,                   /* $@31  */
  YYSYMBOL_begin_lambda = 200,             /* begin_lambda  */
  YYSYMBOL_opt_captures = 201,             /* opt_captures  */
  YYSYMBOL_capture_list = 202,             /* capture_list  */
  YYSYMBOL_capture = 203,                  /* capture  */
  YYSYMBOL_opt_deep = 204,                 /* opt_deep  */
  YYSYMBOL_func_params = 205,              /* func_params  */
  YYSYMBOL_opt_type = 206,                 /* opt_type  */
  YYSYMBOL_init_class = 207,               /* init_class  */
  YYSYMBOL_opt_init = 208,                 /* opt_init  */
  YYSYMBOL_209_32 = 209,                   /* $@32  */
  YYSYMBOL_210_33 = 210,                   /* $@33  */
  YYSYMBOL_index_slice = 211,              /* index_slice  */
  YYSYMBOL_opt_attr = 212,                 /* opt_attr  */
  YYSYMBOL_attr_list = 213,                /* attr_list  */
  YYSYMBOL_attr = 214,                     /* attr  */
  YYSYMBOL_stmt = 215,                     /* stmt  */
  YYSYMBOL_216_34 = 216,                   /* $@34  */
  YYSYMBOL_stmt_list = 217,                /* stmt_list  */
  YYSYMBOL_event = 218,                    /* event  */
  YYSYMBOL_case_list = 219,                /* case_list  */
  YYSYMBOL_case = 220,                     /* case  */
  YYSYMBOL_case_type_list = 221,           /* case_type_list  */
  YYSYMBOL_case_type = 222,                /* case_type  */
  YYSYMBOL_for_head = 223,                 /* for_head  */
  YYSYMBOL_local_id_list = 224,            /* local_id_list  */
  YYSYMBOL_local_id = 225,                 /* local_id  */
  YYSYMBOL_global_id = 226,                /* global_id  */
  YYSYMBOL_227_35 = 227,                   /* $@35  */
  YYSYMBOL_def_global_id = 228,            /* def_global_id  */
  YYSYMBOL_229_36 = 229,                   /* $@36  */
  YYSYMBOL_230_37 = 230,                   /* $@37  */
  YYSYMBOL_event_id = 231,                 /* event_id  */
  YYSYMBOL_232_38 = 232,                   /* $@38  */
  YYSYMBOL_global_or_event_id = 233,       /* global_or_event_id  */
  YYSYMBOL_resolve_id = 234,               /* resolve_id  */
  YYSYMBOL_lookup_identifier = 235,        /* lookup_identifier  */
  YYSYMBOL_opt_assert_msg = 236,           /* opt_assert_msg  */
  YYSYMBOL_opt_no_test = 237,              /* opt_no_test  */
  YYSYMBOL_opt_no_test_block = 238,        /* opt_no_test_block  */
  YYSYMBOL_opt_deprecated = 239,           /* opt_deprecated  */
  YYSYMBOL_expr_list_opt_comma = 240       /* expr_list_opt_comma  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  5
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   3802

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  133
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  108
/* YYNRULES -- Number of rules.  */
#define YYNRULES  304
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  791

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   363


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by zeeklex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by zeeklex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   122,     2,     2,   124,   119,   112,     2,
     127,   128,   117,   115,    96,   116,     2,   118,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    99,   132,
     102,    97,   103,    98,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   125,     2,   126,   111,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   130,   110,   131,   123,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,   100,   101,   104,   105,   106,   107,   108,   109,   113,
     114,   120,   121,   129
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   371,   371,   370,   400,   400,   407,   408,   412,   415,
     419,   427,   431,   439,   445,   453,   456,   461,   463,   467,
     467,   467,   472,   478,   484,   490,   496,   502,   508,   514,
     520,   551,   557,   563,   586,   592,   612,   618,   627,   633,
     639,   645,   651,   657,   663,   669,   675,   681,   687,   693,
     699,   705,   711,   718,   717,   738,   747,   756,   758,   764,
     770,   778,   802,   808,   808,   808,   816,   823,   830,   836,
     829,   878,   878,   891,   897,   899,   905,   960,   966,   973,
     973,   990,   997,  1003,  1011,  1012,  1013,  1017,  1022,  1030,
    1037,  1036,  1047,  1047,  1052,  1055,  1057,  1061,  1067,  1076,
    1078,  1082,  1088,  1096,  1098,  1107,  1120,  1128,  1138,  1144,
    1150,  1156,  1162,  1168,  1174,  1180,  1186,  1192,  1198,  1204,
    1210,  1216,  1223,  1225,  1222,  1232,  1232,  1239,  1245,  1251,
    1257,  1264,  1265,  1271,  1277,  1283,  1301,  1303,  1311,  1316,
    1322,  1335,  1337,  1340,  1344,  1346,  1348,  1353,  1362,  1369,
    1369,  1372,  1377,  1385,  1390,  1390,  1408,  1407,  1416,  1415,
    1423,  1422,  1430,  1432,  1434,  1429,  1447,  1446,  1458,  1457,
    1464,  1467,  1468,  1472,  1474,  1476,  1478,  1480,  1485,  1494,
    1501,  1510,  1521,  1530,  1520,  1549,  1555,  1548,  1582,  1581,
    1602,  1620,  1623,  1627,  1632,  1641,  1663,  1666,  1670,  1672,
    1677,  1680,  1684,  1685,  1686,  1687,  1691,  1691,  1691,  1694,
    1698,  1722,  1724,  1728,  1730,  1738,  1740,  1742,  1744,  1746,
    1748,  1750,  1752,  1754,  1756,  1758,  1760,  1762,  1764,  1766,
    1768,  1770,  1772,  1774,  1776,  1778,  1780,  1782,  1784,  1799,
    1801,  1803,  1809,  1808,  1825,  1830,  1838,  1846,  1857,  1869,
    1876,  1883,  1890,  1898,  1906,  1914,  1922,  1930,  1938,  1945,
    1952,  1962,  1970,  1977,  1982,  1989,  1998,  2021,  2024,  2028,
    2031,  2034,  2039,  2042,  2050,  2056,  2072,  2094,  2099,  2126,
    2144,  2146,  2154,  2176,  2176,  2181,  2181,  2181,  2186,  2186,
    2191,  2225,  2239,  2241,  2252,  2255,  2259,  2262,  2266,  2269,
    2273,  2276,  2289,  2292,  2293
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "TOK_ADD",
  "TOK_ADD_TO", "TOK_ADDR", "TOK_ANY", "TOK_ASSERT", "TOK_ATENDIF",
  "TOK_ATELSE", "TOK_ATIF", "TOK_ATIFDEF", "TOK_ATIFNDEF", "TOK_BOOL",
  "TOK_BREAK", "TOK_CASE", "TOK_OPTION", "TOK_CONST", "TOK_CONSTANT",
  "TOK_COPY", "TOK_COUNT", "TOK_DEFAULT", "TOK_DELETE", "TOK_DOUBLE",
  "TOK_ELSE", "TOK_ENUM", "TOK_EVENT", "TOK_EXPORT", "TOK_FALLTHROUGH",
  "TOK_FILE", "TOK_FOR", "TOK_FUNCTION", "TOK_GLOBAL", "TOK_HOOK",
  "TOK_ID", "TOK_IF", "TOK_INT", "TOK_INTERVAL", "TOK_MODULE", "TOK_LOCAL",
  "TOK_WHEN_LOCAL", "TOK_NEXT", "TOK_OF", "TOK_OPAQUE", "TOK_PATTERN",
  "TOK_PATTERN_END", "TOK_PATTERN_TEXT", "TOK_PORT", "TOK_PRINT",
  "TOK_RECORD", "TOK_REDEF", "TOK_REMOVE_FROM", "TOK_RETURN",
  "TOK_SCHEDULE", "TOK_SET", "TOK_STRING", "TOK_SUBNET", "TOK_SWITCH",
  "TOK_TABLE", "TOK_TIME", "TOK_TIMEOUT", "TOK_TYPE", "TOK_VECTOR",
  "TOK_WHEN", "TOK_WHILE", "TOK_AS", "TOK_IS", "TOK_GLOBAL_ID",
  "TOK_ATTR_ADD_FUNC", "TOK_ATTR_DEFAULT", "TOK_ATTR_DEFAULT_INSERT",
  "TOK_ATTR_OPTIONAL", "TOK_ATTR_REDEF", "TOK_ATTR_DEL_FUNC",
  "TOK_ATTR_EXPIRE_FUNC", "TOK_ATTR_EXPIRE_CREATE", "TOK_ATTR_EXPIRE_READ",
  "TOK_ATTR_EXPIRE_WRITE", "TOK_ATTR_RAW_OUTPUT", "TOK_ATTR_ON_CHANGE",
  "TOK_ATTR_BROKER_STORE", "TOK_ATTR_BROKER_STORE_ALLOW_COMPLEX",
  "TOK_ATTR_BACKEND", "TOK_ATTR_PRIORITY", "TOK_ATTR_LOG",
  "TOK_ATTR_ERROR_HANDLER", "TOK_ATTR_GROUP", "TOK_ATTR_TYPE_COLUMN",
  "TOK_ATTR_DEPRECATED", "TOK_ATTR_IS_ASSIGNED", "TOK_ATTR_IS_USED",
  "TOK_ATTR_ORDERED", "TOK_ATTR_NO_ZAM_OPT", "TOK_ATTR_NO_CPP_OPT",
  "TOK_DEBUG", "TOK_NO_TEST", "','", "'='", "'?'", "':'", "TOK_OR_OR",
  "TOK_AND_AND", "'<'", "'>'", "TOK_LE", "TOK_GE", "TOK_EQ", "TOK_NE",
  "TOK_IN", "TOK_NOT_IN", "'|'", "'^'", "'&'", "TOK_LSHIFT", "TOK_RSHIFT",
  "'+'", "'-'", "'*'", "'/'", "'%'", "TOK_INCR", "TOK_DECR", "'!'", "'~'",
  "'$'", "'['", "']'", "'('", "')'", "TOK_HAS_FIELD", "'{'", "'}'", "';'",
  "$accept", "zeek", "$@1", "$@2", "decl_list", "opt_expr", "when_clause",
  "when_head", "when_start", "when_flavor", "when_captures",
  "when_condition", "$@3", "$@4", "expr", "$@5", "$@6", "$@7", "$@8",
  "$@9", "$@10", "$@11", "opt_exprs_or_field_assigns", "field_assigns",
  "field_assign", "$@12", "rhs", "$@13", "rhs_expr_list", "expr_list",
  "opt_expr_list", "enum_body", "enum_body_list", "enum_body_elem",
  "simple_type", "$@14", "$@15", "$@16", "type", "type_list",
  "type_decl_list", "type_decl", "formal_args", "formal_args_decl_list",
  "formal_args_decl", "decl", "$@17", "$@18", "$@19", "$@20", "$@21",
  "$@22", "$@23", "$@24", "$@25", "$@26", "conditional_list",
  "conditional", "func_hdr", "func_body", "$@27", "$@28", "lambda_body",
  "$@29", "$@30", "anonymous_function", "$@31", "begin_lambda",
  "opt_captures", "capture_list", "capture", "opt_deep", "func_params",
  "opt_type", "init_class", "opt_init", "$@32", "$@33", "index_slice",
  "opt_attr", "attr_list", "attr", "stmt", "$@34", "stmt_list", "event",
  "case_list", "case", "case_type_list", "case_type", "for_head",
  "local_id_list", "local_id", "global_id", "$@35", "def_global_id",
  "$@36", "$@37", "event_id", "$@38", "global_or_event_id", "resolve_id",
  "lookup_identifier", "opt_assert_msg", "opt_no_test",
  "opt_no_test_block", "opt_deprecated", "expr_list_opt_comma", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-576)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-210)

#define yytable_value_is_error(Yyn) \
  ((Yyn) == YYTABLE_NINF)

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     -53,  -576,    35,  3689,  3138,  -576,  -576,  -576,   -10,    51,
      52,  -576,  -576,  -576,   -40,  -576,  -576,  -576,   171,    44,
    -576,  -576,  -576,  -576,  -576,  3138,  -576,  -576,  -576,  -576,
      79,  -576,  3138,  -576,    78,   167,  -576,  -576,  -576,  -576,
    -576,   177,   170,  -576,  -576,   -21,  3138,   -79,  -576,  -576,
      33,  -576,   -12,  -576,  3138,  3138,  3138,  -576,  3138,  3138,
    3138,  3138,  2892,  3138,  2637,  -576,  -576,  -576,  -576,  3138,
     179,   185,   122,  -576,   122,    95,    -3,  -576,    95,   122,
      95,    91,  -576,  -576,  -576,  -576,    -3,   125,  1095,  -576,
    2637,  3138,  2637,  -576,  3589,   101,  3138,  -576,   134,   199,
     111,  -576,  1421,  3589,  3138,  3589,  -576,  3589,  3138,  2706,
     130,   130,   191,   130,   130,   130,   130,   204,  2637,   115,
     146,  -576,   148,  1740,  1448,  1448,  3589,  3589,  -576,  3261,
    3138,  3138,  3138,  3138,  3138,  3138,  3138,  3138,  3138,  3138,
    3138,  3138,  3138,  3138,  3138,  3138,  3138,  3138,  3138,  3138,
     211,  3261,  -576,   214,  1809,   132,   133,  3589,    11,  -576,
      11,   229,  3683,  -576,  -576,  -576,  3683,    11,  3683,  -576,
     264,    95,   147,   122,  -576,  -576,  3138,   140,   177,    -3,
     143,   149,   153,   177,   152,  3138,  1218,  3138,  -576,   160,
    -576,  -576,  -576,   234,  1095,    64,  1191,  -576,   198,  -576,
    1095,    74,  1878,   262,   174,    95,   182,   168,   190,   192,
     268,  -576,  -576,  -576,  -576,   299,  -576,    95,  3111,  1448,
    -576,   146,  -576,    -3,  -576,   -73,   148,   193,   -52,  3138,
    -576,   195,  3384,   275,   -48,  -576,   111,  -576,  3138,  -576,
    -576,  -576,  2637,  -576,  -576,  -576,  -576,  1448,  1947,  2865,
    3111,  3234,  3234,  3234,  3234,  3234,  3234,   625,   625,  1287,
     710,   403,   187,   187,   164,   164,   130,   130,   130,  -576,
     227,  2016,   -35,  2892,  -576,  -576,  -576,  -576,  -576,  -576,
    -576,  -576,   837,  -576,   837,   231,   205,   -59,  -576,   235,
     237,   239,  -576,  -576,   241,   243,   246,   247,   248,  -576,
     250,   252,  -576,   253,   254,  -576,  -576,   256,   257,   258,
    -576,  -576,  -576,  -576,  -576,  -576,  3683,  -576,   463,  -576,
     837,  -576,   226,  3683,   294,   353,    11,  3589,  2085,   267,
     122,   232,   236,   267,    -7,  3138,   122,   267,   -56,  -576,
     267,  1260,  1602,  3138,   270,  3138,  -576,    62,  -576,   267,
    3138,  -576,  -576,  -576,  -576,  -576,    15,   251,   274,  -576,
     229,  -576,   229,  -576,   -28,  -576,   338,   144,  -576,  -576,
     245,   255,   259,  3589,  -576,  -576,  3683,   332,   263,  -576,
    -576,  3138,   281,  -576,  2637,  3138,  -576,  3138,  3138,  3138,
    -576,  -576,  3683,  1448,  3683,  3589,   288,   229,   229,  3138,
    3138,  3138,  3138,  3138,  3138,  3138,  3138,  3138,  3138,  3138,
    3138,  3138,  3138,   374,  -576,  -576,  3683,  -576,  -576,   342,
     286,   837,  3683,  3138,   279,  -576,  -576,    11,   267,  3138,
    -576,     5,   177,  2154,    11,  -576,   267,  -576,   267,  -576,
    2223,  -576,  -576,  1671,   295,   298,   292,  3138,  -576,  1331,
    -576,   325,    -9,  -576,  -576,   262,   296,   300,   299,  -576,
    -576,  -576,  -576,  -576,   301,   176,  -576,  -576,  -576,  3589,
    -576,  2637,  -576,   302,   148,   945,   303,  2637,   306,   304,
    -576,   307,  3683,  3589,  -576,  -576,  2637,  2637,  2637,  2637,
    2637,  2637,  2637,  2637,  2637,  2637,  2637,  2637,  2637,  2637,
    -576,   309,   262,   422,   376,  -576,  3683,   310,  2637,  -576,
     837,  -576,   316,   397,  3138,    -2,  -576,  1095,   837,  -576,
    -576,    18,  1095,   835,   270,   308,  -576,  2637,   267,  1095,
     420,   357,   428,  -576,  -576,  -576,  -576,  -576,  -576,   350,
    -576,  -576,  3683,   320,  -576,  -576,  -576,  -576,  -576,  -576,
    -576,  -576,  -576,  -576,   321,   323,   324,  -576,   319,  -576,
    3683,  -576,   347,  2292,   177,    66,   432,  3683,  3015,   358,
    -576,  -576,  -576,  -576,  -576,  -576,  -576,  -576,   327,  -576,
    -576,  -576,  1095,  3589,  -576,  -576,   328,  3683,  3683,   330,
    -576,   331,  3138,  -576,  -576,   425,  3138,  1095,   333,  3629,
      68,    77,  -576,  -576,   965,   334,  -576,   336,  3683,  -576,
    3474,  3500,   339,   267,  2361,   356,  2430,  -576,   267,   412,
    -576,   421,  -576,  1095,  -576,  -576,  -576,   349,   355,   359,
    3683,  -576,  -576,  3138,  -576,  -576,   451,  1095,  -576,  1095,
    -576,  -576,  -576,   367,  2499,  -576,  -576,  -576,  3261,  3261,
     446,  -576,   177,    67,    72,    30,  3261,  3261,  3261,  3261,
    3261,  3261,  1571,  1571,  3629,  3629,  -576,  3261,  3261,  3261,
    3261,  3261,  3261,  3261,  3261,  3261,  3261,  3261,  3261,  3261,
    3261,  3261,  3261,  3261,  3261,  3261,  3261,  3261,  2775,   375,
     378,   464,  3261,  2775,  2775,  3629,  3261,   408,  3138,  3589,
    -576,  3629,   200,   200,   200,   200,   200,   200,  2775,  1571,
    2568,  2988,  3357,  3412,  3412,  3412,  3412,  3412,  3412,   680,
     680,  1532,  2730,  1701,   418,   418,   242,   242,   200,   200,
     200,   229,  2775,  3357,  1571,   379,    54,  3138,  3261,   381,
    3709,   469,   384,  1075,  -576,   417,   429,   441,   443,   444,
     447,   449,   452,   453,   454,   455,   456,   457,   458,  3709,
    3629,  -576,  3261,  3261,  3261,  3261,  3261,  3261,  3261,  3261,
    3261,  3261,  3261,  3261,  3261,  3261,  3709,  2775,  2775,  2775,
    2775,  2775,  2775,  2775,  2775,  2775,  2775,  2775,  2775,  2775,
    2775
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       7,     4,     0,     2,     0,     1,   176,   177,     0,     0,
       0,   285,   285,   288,     0,   285,   285,   285,     0,   283,
     285,   265,     6,   170,   168,     0,   117,   119,   108,    77,
       0,   110,     0,   111,     0,   129,   188,    71,   292,   109,
     113,     0,     0,   115,   116,     0,     0,     0,   114,   118,
       0,   112,     0,   293,     0,     0,     0,    79,     0,     0,
       0,     0,    84,     0,     5,    78,    74,    57,    76,     0,
       0,     0,   201,   283,   201,     0,     0,   149,     0,   201,
       0,     0,   283,   288,   283,   154,     0,     0,     3,   171,
      24,     0,    25,   125,     0,   192,     0,   282,     0,     0,
       0,   122,     0,     0,   100,     0,    63,     0,   100,     0,
      31,    30,     0,    26,    27,    28,    29,     0,    98,     0,
     304,    88,   304,     0,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     9,    68,     0,     0,     0,     0,     0,   202,   286,
     202,   143,   212,   289,   290,     7,   212,   202,   212,   148,
       0,     0,   162,   201,   284,   166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    16,     0,
     242,   262,   259,    11,     0,     0,     0,   263,    57,   264,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   131,   128,   135,   291,   197,   171,     0,    72,     0,
     130,   304,   139,     0,   137,     0,   304,     0,     0,   100,
     127,     0,    81,     0,   192,    61,   303,    86,   303,    85,
      22,    92,    94,    33,    35,    82,    83,     0,     0,    45,
      44,    48,    50,    49,    51,    46,    47,    59,    60,    40,
      41,    39,    42,    43,    32,    34,    36,    37,    38,    58,
       0,    98,     0,    84,    73,   173,   174,   175,   200,   204,
     205,   203,   206,   287,   206,     0,     0,   141,   146,     0,
       0,     0,   217,   218,     0,     0,     0,     0,     0,   231,
       0,     0,   225,     0,     0,   235,   236,     0,     0,   237,
     219,   220,   239,   240,   241,   179,   211,   214,     0,   178,
     206,   180,     0,   212,     0,     0,   202,     0,   295,   297,
     201,     0,     0,   297,     0,     0,   201,   297,     0,    15,
     297,     0,     0,     0,   299,     0,    12,    18,    19,   297,
       0,   250,   182,   172,   169,    23,   302,     0,   101,   103,
     143,   132,   143,   196,     0,   194,     0,     0,   190,    55,
       0,   171,     0,     0,   121,    99,   212,     0,     0,    67,
      80,     0,     0,    87,    97,    96,    54,     0,     9,     0,
      56,    69,   212,     0,   212,     0,   199,     0,   142,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   213,   150,   212,   156,   181,   158,
       0,   206,   212,     0,     0,   296,   253,   202,   297,   100,
     254,     0,     0,     0,   202,   252,   297,   255,   297,   268,
       0,   298,   265,     0,     0,    17,     0,     0,   261,     0,
     265,   300,     0,   107,   126,   102,     0,     0,   197,   191,
     195,   185,   189,    62,     0,     0,    75,   136,    66,     0,
      64,    89,    90,     0,   304,    52,     0,     8,     0,     0,
     207,     0,   212,     0,   145,   144,   221,   215,   216,   222,
     227,   228,   229,   230,   223,   224,   226,   232,   233,   234,
     238,     0,     0,     0,     0,   163,   212,     0,   294,   244,
     206,   246,     0,     0,     0,     0,   281,     0,   206,   245,
     256,     0,     0,     0,   299,     0,    14,    20,   297,   183,
       0,   302,     0,   104,   134,   133,   193,   265,   124,     0,
     138,   120,   212,     0,    93,    95,   210,    70,   152,   208,
     153,   147,   198,   151,     0,     0,     0,   139,     0,   167,
     212,   266,     0,     0,     0,     0,   247,   212,     0,     0,
     249,   267,   251,   243,   265,    19,    21,   260,     0,   301,
     105,   106,   186,     0,    65,    91,     0,     0,     0,   171,
     155,     0,     0,   276,   280,     0,     0,     0,     0,     0,
       0,     0,   273,   265,     0,     0,   184,     0,   212,   157,
       0,     0,     0,   297,     0,     0,     0,   248,   297,   274,
     265,     0,   265,   271,    10,    13,   187,     0,     0,     0,
     212,   258,   278,     0,   277,   257,     0,   269,   272,   270,
     140,   159,   161,     0,     0,   275,   165,   279,     0,     0,
     129,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    53,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    98,     0,
       0,     0,     0,    24,    25,     0,     0,     0,   100,     0,
      63,     0,    31,    30,    26,    27,    28,    29,    94,     0,
       0,    45,    44,    48,    50,    49,    51,    46,    47,    59,
      60,    40,    41,    39,    42,    43,    32,    34,    36,    37,
      38,   143,    97,    72,     0,     0,     0,   100,     0,     0,
     212,     0,     0,    52,   199,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   211,
       0,    64,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   212,   221,   215,   216,
     222,   227,   228,   229,   230,   223,   224,   226,   232,   233,
     234
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -576,  -576,  -576,  -576,   360,   141,  -576,  -576,  -576,  -576,
    -576,   -27,  -576,  -576,    -4,  -110,  -142,  -202,  -576,  -576,
     -91,  -576,   289,   461,   329,  -576,   -96,  -576,  -576,   -37,
    -107,    61,  -576,   114,   113,  -576,  -576,  -576,   120,  -102,
       9,  -576,  -352,  -576,  -309,  -576,  -576,  -576,  -576,  -576,
    -576,  -576,  -576,  -576,  -576,  -576,   -70,     1,  -576,  -576,
    -576,  -576,    25,  -576,  -576,  -576,  -576,   337,  -576,   223,
     116,  -576,     0,   -57,  -149,  -260,  -576,  -576,   -25,  -130,
    -575,  -311,  -180,  -576,  -371,   352,  -576,  -576,  -576,   -45,
    -576,  -576,  -176,    86,  -576,   398,  -576,  -576,   490,  -576,
     491,  -576,   -60,  -576,  -238,    56,    47,  -116
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     2,    21,     4,     3,   270,   192,   193,   194,   195,
     444,   446,   447,   576,   196,   247,   229,   542,   273,   478,
      96,   112,   119,   120,   121,   543,   243,   385,   473,   226,
     227,   357,   358,   359,    65,   222,   464,   203,   224,   225,
     371,   540,   286,   287,   288,    22,   165,   173,   502,   503,
     504,   325,   557,   612,   327,    89,   465,   197,    24,   354,
     450,   578,   462,   537,   607,    66,    95,   216,   217,   364,
     365,   366,   361,   158,   282,   392,   393,   549,    67,   468,
     316,   317,   199,   344,    88,   331,   521,   571,   601,   602,
     200,   515,    98,    85,    86,    72,    73,   283,    75,    76,
     163,   213,    68,   424,   426,   442,   453,   237
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      64,   231,   330,   228,    23,   414,   239,   336,   456,   531,
     457,   284,   610,   611,   346,   279,   164,   160,   320,   201,
     351,    90,   167,   373,   394,   122,   164,   431,    92,   244,
     107,    38,   315,   568,   214,     5,   319,   397,   321,   569,
     389,     1,   102,   214,   373,   214,   103,   214,   104,   381,
     109,   110,   111,   374,   113,   114,   115,   116,   118,   123,
     416,   389,   280,   198,    53,   154,   214,   214,   458,    82,
      83,   523,   701,   398,   377,   162,   436,   215,   166,   529,
     168,   363,     6,     7,     8,     9,    10,   202,   484,   485,
      77,   390,   218,    84,   564,   430,  -197,   214,   459,   435,
     118,   513,   437,   451,   118,   370,   100,   532,   281,   101,
     375,   448,   452,   514,   272,   108,   326,    69,   432,   332,
     242,   242,   378,   369,   565,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   367,   271,   338,   570,
     373,   386,     6,     7,     8,     9,    10,   108,   105,   159,
     106,   506,   595,   332,   692,   759,   582,   620,   170,   198,
     172,   323,   328,   621,   596,   198,   622,   421,    70,    71,
     741,   118,   341,   342,     6,     7,     8,     9,    10,   347,
     511,   348,   103,   418,   698,   126,   127,   699,   519,   700,
     520,   759,   353,   604,   352,    81,    91,   211,    93,    94,
     539,    97,    99,   155,   212,   242,   211,   368,   211,   156,
     211,   157,   161,   169,   175,   118,   215,   230,   259,   126,
     127,   219,   623,   220,   384,   117,   122,   233,   234,   211,
     211,   235,   236,   242,   238,   269,   245,   246,   274,   637,
     560,   639,   126,   127,   150,   151,   516,   152,   567,   153,
     276,   277,   479,   285,   481,   664,   665,   214,   322,   118,
     211,   324,   329,   427,   461,   333,   334,   278,   510,   434,
     335,   147,   148,   149,   337,   518,   501,   343,   150,   151,
     577,   152,   507,   153,   345,   350,   356,   480,   101,   414,
     414,   360,   145,   146,   147,   148,   149,   664,   665,   362,
     107,   150,   151,   214,   152,   103,   153,   105,   363,    23,
     380,   376,   512,   379,   150,   151,   388,   152,   419,   153,
     395,   433,   399,   396,   400,   214,   401,   566,   402,   440,
     403,   443,   572,   404,   405,   406,   449,   407,   474,   408,
     409,   410,   551,   411,   412,   413,   417,   420,   545,   685,
     686,   687,   425,   429,   428,   441,   150,   151,   353,   152,
     455,   153,   460,   463,   469,   631,   558,   471,   472,   739,
     635,   118,   454,   475,   477,   384,  -123,   483,   594,   242,
     466,   470,   500,  -160,   458,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,   498,   499,   214,
      74,   509,   584,    78,    79,    80,   505,   617,    87,   508,
     526,   525,   530,   214,   534,   118,   555,   556,   535,   546,
     591,   562,   538,   544,   547,   575,   548,   598,   579,   550,
     211,   553,   559,   527,   561,   451,   581,   422,   414,   583,
     461,   590,   586,   587,   588,   592,   597,   603,   606,   615,
     609,  -164,   625,   613,   633,   618,   353,   626,   126,   127,
     630,     6,     7,     8,     9,    10,   697,   636,   627,    11,
      12,   640,   599,   664,   665,   645,   211,   641,   695,    13,
      14,   642,   198,   467,    15,    16,    17,   198,   198,   646,
     643,    18,   731,   699,   198,   734,   701,   740,   211,   744,
     563,   760,   761,    19,   762,   482,   143,   144,   145,   146,
     147,   148,   149,   214,    20,   318,   763,   150,   151,   476,
     152,   600,   153,   683,   684,   685,   686,   687,   764,   214,
     765,   766,   150,   151,   767,   152,   768,   153,   605,   769,
     770,   771,   772,   773,   774,   775,   709,   198,   737,   776,
     696,   221,   391,   554,   688,   383,   589,   244,   585,   533,
     445,   382,   198,   171,   536,   372,   638,   174,   580,   198,
     574,     0,   211,     0,     0,     0,     0,     0,   614,   541,
       0,   735,   616,     0,   415,     0,   211,   736,   198,     0,
       0,     0,     0,   552,   214,   214,     0,     0,     0,     0,
       0,     0,   198,   386,   198,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   644,
     742,     0,     0,     0,     0,   214,     0,     0,   369,   214,
       0,   214,     0,     0,   693,   694,   584,     0,     0,     0,
       0,     0,   702,   703,   704,   705,   706,   707,   708,   708,
       0,     0,     0,   710,   711,   712,   713,   714,   715,   716,
     717,   718,   719,   720,   721,   722,   723,   724,   725,   726,
     727,   728,   729,   730,     0,     0,     0,     0,   732,     0,
     126,   127,   733,     0,   118,     0,   211,     0,     0,     0,
     214,     0,     0,   608,     0,   708,     0,     0,     0,     0,
       0,     0,   211,     0,     0,     0,     0,     0,     0,   619,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     708,     0,     0,   118,   743,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   664,   665,     0,     0,   150,
     151,     0,   152,     0,   153,     0,     0,     0,   777,   778,
     779,   780,   781,   782,   783,   784,   785,   786,   787,   788,
     789,   790,     0,     0,     0,   126,   127,   211,   211,     0,
       0,     0,     0,     0,   245,   246,     0,     0,     0,     0,
     678,   679,   680,   681,   682,   683,   684,   685,   686,   687,
       0,     0,     0,     0,   150,   151,     0,   152,   211,   153,
       0,     0,   211,     0,   211,   212,     0,     0,     0,     0,
       0,   230,   142,   143,   144,   145,   146,   147,   148,   149,
       0,     0,     0,     0,   150,   151,     0,   152,    25,   153,
      26,    27,   176,     6,     7,     8,     9,    10,    28,   177,
       0,     0,   178,    29,    30,    31,     0,    32,    33,     0,
      34,   179,     0,   180,    35,   181,    36,     0,    37,    38,
     182,    39,    40,   211,   183,    41,   184,     0,    42,    43,
     541,     0,    44,   185,    45,     0,     0,   186,    46,    47,
      48,    49,   187,    50,    51,     0,     0,    52,   188,   189,
       0,     0,    53,     0,     0,  -209,  -209,  -209,  -209,  -209,
    -209,  -209,  -209,  -209,  -209,  -209,  -209,  -209,  -209,  -209,
    -209,  -209,  -209,  -209,  -209,  -209,  -209,  -209,  -209,  -209,
    -209,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,     0,     0,
      55,    56,     0,    57,     0,    58,    59,    60,    61,     0,
      62,     0,    63,     0,     0,   190,   573,   191,    25,  -209,
      26,    27,   176,     6,     7,     8,     9,    10,    28,   177,
       0,     0,   178,    29,    30,    31,     0,    32,    33,     0,
      34,   179,     0,   180,    35,   181,    36,     0,    37,    38,
     182,    39,    40,     0,   183,    41,   184,     0,    42,    43,
     126,   127,    44,   185,    45,     0,     0,   186,    46,    47,
      48,    49,   187,    50,    51,     0,     0,    52,   188,   189,
       0,     0,    53,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   129,     0,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,     0,     0,     0,     0,   150,
     151,     0,   152,     0,   153,    54,     0,     0,     0,     0,
      55,    56,     0,    57,     0,    58,    59,    60,    61,     0,
      62,     0,    63,     0,     0,   190,   624,   191,    25,     0,
      26,    27,   176,     6,     7,     8,     9,    10,    28,   177,
       0,     0,   178,    29,    30,    31,     0,    32,    33,     0,
      34,   179,     0,   180,    35,   181,    36,     0,    37,    38,
     182,    39,    40,     0,   183,    41,   184,     0,    42,    43,
     664,   665,    44,   185,    45,     0,     0,   186,    46,    47,
      48,    49,   187,    50,    51,     0,     0,    52,   188,   189,
       0,     0,    53,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   667,     0,   668,   669,   670,   671,   672,
     673,   674,   675,   676,   677,   678,   679,   680,   681,   682,
     683,   684,   685,   686,   687,   124,     0,     0,     0,   150,
     151,     0,   152,     0,   153,    54,     0,     0,     0,     0,
      55,    56,     0,    57,     0,    58,    59,    60,    61,     0,
      62,    25,    63,    26,    27,   190,     0,   191,     0,     0,
       0,    28,     0,     0,     0,     0,    29,    30,    31,     0,
      32,    33,   125,    34,     0,     0,     0,    35,     0,    36,
       0,    37,    38,     0,    39,    40,   126,   127,    41,     0,
       0,    42,    43,     0,   124,    44,     0,    45,     0,     0,
       0,    46,    47,    48,    49,     0,    50,    51,     0,     0,
      52,   339,     0,     0,     0,    53,     0,     0,   128,   129,
       0,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   125,     0,     0,     0,   150,   151,     0,   152,     0,
     153,     0,     0,   349,     0,   126,   127,     0,    54,     0,
       0,     0,     0,    55,    56,   124,    57,     0,    58,    59,
      60,    61,     0,    62,     0,    63,     0,     0,     0,     0,
     340,     0,   126,   127,     0,     0,     0,   128,   129,     0,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
       0,     0,   125,     0,   150,   151,     0,   152,     0,   153,
       0,     0,   438,     0,     0,     0,   126,   127,   141,   142,
     143,   144,   145,   146,   147,   148,   149,     0,     0,     0,
       0,   150,   151,     0,   152,     0,   153,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,     0,   128,   129,
       0,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,    25,     0,    26,    27,   150,   151,     0,   152,     0,
     153,    28,     0,   528,     0,     0,    29,    30,    31,     0,
      32,    33,   125,    34,     0,     0,     0,    35,     0,    36,
       0,    37,    38,     0,    39,    40,   126,   127,    41,     0,
       0,    42,    43,     0,     0,    44,     0,    45,     0,     0,
       0,    46,    47,    48,    49,     0,    50,    51,     0,     0,
      52,     0,     0,     0,     0,    53,     0,     0,   128,   129,
       0,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,     0,     0,     0,     0,   150,   151,     0,   152,     0,
     153,   223,     0,     0,     0,     0,     0,     0,    54,     0,
       0,     0,     0,    55,    56,     0,    57,     0,    58,    59,
      60,    61,     0,    62,   648,    63,    26,    27,   241,     0,
       0,     0,     0,     0,    28,     0,     0,     0,     0,    29,
      30,    31,     0,   649,    33,     0,    34,   664,   665,     0,
     650,     0,    36,     0,   651,    38,   124,    39,    40,     0,
       0,   652,     0,     0,    42,    43,     0,     0,    44,     0,
      45,     0,     0,     0,    46,   653,    48,    49,     0,   654,
      51,     0,     0,   655,     0,     0,     0,     0,    53,     0,
       0,     0,     0,   679,   680,   681,   682,   683,   684,   685,
     686,   687,     0,   125,     0,     0,   150,   151,     0,   152,
       0,   153,     0,     0,     0,     0,     0,   126,   127,     0,
       0,     0,     0,     0,     0,   124,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,   656,   657,     0,    57,
       0,   658,   659,   660,   661,     0,    62,     0,    63,   128,
     129,   241,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   125,     0,     0,     0,   150,   151,     0,   152,
       0,   153,   439,     0,     0,     0,   126,   127,     0,     0,
       0,     0,     0,     0,   124,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   664,   665,   128,   129,
       0,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   125,     0,     0,     0,   150,   151,     0,   152,     0,
     153,   524,     0,     0,     0,   126,   127,     0,     0,     0,
       0,     0,     0,   124,   681,   682,   683,   684,   685,   686,
     687,     0,     0,     0,     0,   150,   151,     0,   152,     0,
     153,     0,     0,     0,     0,     0,     0,   128,   129,     0,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     125,     0,     0,     0,   150,   151,     0,   152,   240,   153,
       0,     0,     0,     0,   126,   127,     0,     0,     0,     0,
       0,     0,   124,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   128,   129,     0,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   125,
       0,     0,     0,   150,   151,     0,   152,   275,   153,     0,
       0,     0,     0,   126,   127,     0,     0,     0,     0,     0,
       0,   662,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   128,   129,     0,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   663,     0,
       0,     0,   150,   151,     0,   152,   355,   153,     0,     0,
       0,     0,   664,   665,     0,     0,     0,     0,     0,     0,
     662,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   666,   667,   387,   668,   669,   670,
     671,   672,   673,   674,   675,   676,   677,   678,   679,   680,
     681,   682,   683,   684,   685,   686,   687,   663,     0,     0,
       0,   150,   151,     0,   152,     0,   153,     0,     0,     0,
       0,   664,   665,     0,     0,     0,     0,     0,     0,   124,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   666,   667,    -8,   668,   669,   670,   671,
     672,   673,   674,   675,   676,   677,   678,   679,   680,   681,
     682,   683,   684,   685,   686,   687,   125,     0,     0,     0,
     150,   151,     0,   152,     0,   153,     0,     0,     0,     0,
     126,   127,     0,     0,     0,     0,     0,     0,   124,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   423,   128,   129,     0,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   125,     0,     0,     0,   150,
     151,     0,   152,     0,   153,     0,     0,     0,     0,   126,
     127,     0,     0,     0,     0,     0,     0,   124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   128,   129,     0,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   125,     0,     0,     0,   150,   151,
       0,   152,   517,   153,     0,     0,     0,     0,   126,   127,
       0,     0,     0,     0,     0,     0,   124,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     128,   129,     0,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   125,     0,     0,     0,   150,   151,     0,
     152,   522,   153,     0,     0,     0,     0,   126,   127,     0,
       0,     0,     0,     0,     0,   124,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   128,
     129,     0,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   125,     0,     0,     0,   150,   151,     0,   152,
     593,   153,     0,     0,     0,     0,   126,   127,     0,     0,
       0,     0,     0,     0,   124,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   128,   129,
       0,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   125,     0,     0,     0,   150,   151,     0,   152,   632,
     153,     0,     0,     0,     0,   126,   127,     0,     0,     0,
       0,     0,     0,   124,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   128,   129,     0,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     125,     0,     0,     0,   150,   151,     0,   152,   634,   153,
       0,     0,     0,     0,   126,   127,     0,     0,     0,     0,
       0,     0,   662,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   128,   129,     0,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   663,
       0,     0,     0,   150,   151,     0,   152,   647,   153,     0,
       0,     0,     0,   664,   665,     0,     0,     0,     0,     0,
       0,   124,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   666,   667,   738,   668,   669,
     670,   671,   672,   673,   674,   675,   676,   677,   678,   679,
     680,   681,   682,   683,   684,   685,   686,   687,   125,     0,
       0,     0,   150,   151,     0,   152,     0,   153,     0,     0,
       0,     0,   126,   127,     0,     0,     0,     0,     0,     0,
     124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   128,   129,     0,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   125,     0,     0,
       0,   150,   151,     0,   152,     0,   153,     0,     0,     0,
       0,   126,   127,     0,     0,     0,     0,     0,     0,   662,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   664,   665,     0,     0,     0,
       0,     0,     0,   128,   129,     0,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   232,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   663,     0,     0,     0,
     150,   151,     0,   152,     0,   153,     0,     0,     0,     0,
     664,   665,   680,   681,   682,   683,   684,   685,   686,   687,
       0,     0,     0,     0,   150,   151,     0,   152,     0,   153,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   666,   667,     0,   668,   669,   670,   671,   672,
     673,   674,   675,   676,   677,   678,   679,   680,   681,   682,
     683,   684,   685,   686,   687,    25,     0,    26,    27,   150,
     151,     0,   152,     0,   153,    28,     0,     0,     0,     0,
      29,    30,    31,     0,    32,    33,     0,    34,     0,     0,
       0,    35,     0,    36,     0,    37,    38,     0,    39,    40,
     126,   127,    41,     0,     0,    42,    43,     0,     0,    44,
       0,    45,     0,     0,     0,    46,    47,    48,    49,     0,
      50,    51,     0,     0,    52,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,     0,     0,     0,     0,   150,
     151,     0,   152,     0,   153,     0,     0,     0,     0,     0,
       0,     0,    54,     0,     0,     0,     0,    55,    56,     0,
      57,     0,    58,    59,    60,    61,   117,    62,   648,    63,
      26,    27,     0,     0,     0,     0,     0,     0,    28,     0,
       0,     0,     0,    29,    30,    31,     0,   649,    33,     0,
      34,     0,     0,     0,   650,     0,    36,     0,   651,    38,
       0,    39,    40,   664,   665,   652,     0,     0,    42,    43,
       0,     0,    44,     0,    45,     0,     0,     0,    46,   653,
      48,    49,     0,   654,    51,     0,   599,   655,     0,     0,
       0,     0,    53,     0,     0,     0,     0,     0,     0,   669,
     670,   671,   672,   673,   674,   675,   676,   677,   678,   679,
     680,   681,   682,   683,   684,   685,   686,   687,     0,     0,
       0,     0,   150,   151,     0,   152,     0,   153,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,     0,     0,
     656,   657,     0,    57,     0,   658,   659,   660,   661,     0,
      62,    25,    63,    26,    27,     0,     0,     0,     0,     0,
       0,    28,     0,     0,     0,     0,    29,    30,    31,     0,
      32,    33,     0,    34,     0,     0,     0,    35,     0,    36,
       0,    37,    38,     0,    39,    40,   126,   127,    41,     0,
       0,    42,    43,     0,     0,    44,     0,    45,     0,     0,
       0,    46,    47,    48,    49,     0,    50,    51,     0,     0,
      52,     0,     0,     0,     0,    53,     0,     0,     0,     0,
       0,     0,     0,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,     0,     0,     0,     0,   150,   151,     0,   152,     0,
     153,     0,     0,     0,     0,     0,     0,     0,    54,     0,
       0,     0,     0,    55,    56,     0,    57,     0,    58,    59,
      60,    61,     0,    62,   648,    63,    26,    27,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,     0,    29,
      30,    31,     0,   649,    33,     0,    34,     0,     0,     0,
     650,     0,    36,     0,   651,    38,     0,    39,    40,   126,
     127,   652,     0,     0,    42,    43,     0,     0,    44,     0,
      45,     0,     0,     0,    46,   653,    48,    49,     0,   654,
      51,     0,     0,   655,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,     0,  -210,  -210,  -210,  -210,
    -210,  -210,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,     0,     0,     0,     0,   150,   151,
       0,   152,     0,   153,     0,     0,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,   656,   657,     0,    57,
       0,   658,   659,   660,   661,     0,    62,    25,    63,    26,
      27,     0,     0,     0,     0,     0,     0,    28,     0,     0,
       0,     0,    29,    30,    31,     0,    32,    33,     0,    34,
       0,     0,     0,    35,     0,    36,     0,    37,    38,     0,
      39,    40,   664,   665,    41,     0,     0,    42,    43,     0,
       0,    44,     0,    45,     0,     0,     0,    46,    47,    48,
      49,     0,    50,    51,     0,     0,    52,     0,     0,     0,
       0,    53,     0,     0,     0,     0,     0,     0,     0,   670,
     671,   672,   673,   674,   675,   676,   677,   678,   679,   680,
     681,   682,   683,   684,   685,   686,   687,   664,   665,     0,
       0,   150,   151,     0,   152,     0,   153,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    58,    59,    60,    61,     0,     0,
       0,     0,     0,     0,  -210,  -210,  -210,  -210,  -210,  -210,
     676,   677,   678,   679,   680,   681,   682,   683,   684,   685,
     686,   687,     0,     0,     0,     0,   150,   151,     0,   152,
       0,   153,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,    26,    27,     0,     0,     0,     0,
       0,     0,    28,     0,     0,   628,     0,     0,     0,    31,
       0,     0,    33,     0,    34,   204,     0,     0,    35,     0,
     205,     0,   206,    38,     0,    39,    40,     0,     0,     0,
       0,   629,    42,    43,    26,    27,    44,     0,   207,     0,
       0,     0,    28,   208,    48,    49,     0,   209,    51,    31,
       0,   210,    33,     0,    34,   204,    53,     0,   650,     0,
     689,     0,   206,    38,     0,    39,    40,     0,     0,     0,
       0,     0,    42,    43,     0,     0,    44,     0,   207,     0,
       0,     0,     0,   208,    48,    49,     0,   690,    51,     0,
       0,   691,     0,     0,     0,     0,    53,     6,     7,     8,
       9,    10,     0,     0,     0,    11,    12,     0,     0,     0,
       0,     0,     0,     0,     0,    13,    14,     0,     0,     0,
      15,    16,    17,     0,     0,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    19,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      20,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   745,   746,   747,
     292,   293,   748,   749,   750,   751,   752,   299,   753,   754,
     302,   755,   756,   305,   306,   757,   758,   309,   310,   311,
     312,   313,   314
};

static const yytype_int16 yycheck[] =
{
       4,   108,   178,   105,     3,   316,   122,   183,   360,    18,
     362,   160,   587,   588,   194,     4,    76,    74,   167,    89,
     200,    25,    79,    96,   284,    62,    86,    34,    32,   125,
      42,    34,   162,    15,    94,     0,   166,    96,   168,    21,
      96,    94,    46,   103,    96,   105,   125,   107,   127,    97,
      54,    55,    56,   126,    58,    59,    60,    61,    62,    63,
     320,    96,    51,    88,    67,    69,   126,   127,    96,    25,
      26,   442,    42,   132,   126,    75,   132,   125,    78,   450,
      80,    19,     8,     9,    10,    11,    12,    91,   397,   398,
     130,   126,    96,    49,    96,   333,    34,   157,   126,   337,
     104,    96,   340,    88,   108,   221,   127,   116,    97,   130,
     226,   349,    97,   108,   151,   127,   173,   127,   125,   179,
     124,   125,   229,   219,   126,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   216,   151,   185,   131,
      96,   247,     8,     9,    10,    11,    12,   127,   125,    73,
     127,   421,    96,   223,    96,   740,   537,    99,    82,   194,
      84,   171,   176,    96,   108,   200,    99,   326,   127,   127,
     126,   185,   186,   187,     8,     9,    10,    11,    12,   125,
     428,   127,   125,   323,   127,    65,    66,   125,   436,   127,
     438,   776,   201,   574,   130,    34,   127,    94,   130,    42,
      34,    34,    42,    34,    94,   219,   103,   217,   105,    34,
     107,    99,   127,   132,    99,   229,   125,   107,   232,    65,
      66,    97,   603,    34,   238,   124,   273,    46,    34,   126,
     127,   126,    96,   247,    96,    34,   126,   127,    34,   620,
     510,   622,    65,    66,   124,   125,   432,   127,   518,   129,
     128,   128,   392,    34,   394,    65,    66,   327,     4,   273,
     157,   124,   132,   330,   130,   132,   127,   157,   427,   336,
     127,   117,   118,   119,   132,   434,   416,   127,   124,   125,
     528,   127,   422,   129,    60,    97,    34,   393,   130,   610,
     611,   127,   115,   116,   117,   118,   119,    65,    66,   127,
      42,   124,   125,   373,   127,   125,   129,   125,    19,   318,
      45,   128,   429,   128,   124,   125,    99,   127,    34,   129,
      99,   335,    97,   128,    97,   395,    97,   517,    97,   343,
      97,   345,   522,    97,    97,    97,   350,    97,   385,    97,
      97,    97,   482,    97,    97,    97,   130,     4,   474,   117,
     118,   119,    95,   127,   132,    95,   124,   125,   367,   127,
      96,   129,    34,   128,    42,   613,   506,   381,    97,   731,
     618,   385,   131,   387,   388,   389,   131,    99,   564,   393,
     131,   128,    18,    51,    96,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,   411,   412,   469,
      12,   132,   542,    15,    16,    17,   130,   597,    20,   423,
     128,   126,    97,   483,   128,   429,     4,    51,   128,   126,
     560,    34,   131,   131,   128,   127,   132,   567,    18,   132,
     327,   132,   132,   447,   128,    88,    18,   327,   759,    99,
     130,   132,   131,   130,   130,   108,    24,    99,   131,    34,
     132,   131,   128,   132,   108,   132,   465,   131,    65,    66,
     131,     8,     9,    10,    11,    12,   652,    65,   608,    16,
      17,   132,    61,    65,    66,    34,   373,   132,    42,    26,
      27,   132,   517,   373,    31,    32,    33,   522,   523,   132,
     630,    38,   127,   125,   529,    97,    42,   128,   395,   128,
     514,    42,   128,    50,    97,   395,   113,   114,   115,   116,
     117,   118,   119,   583,    61,   165,    97,   124,   125,   388,
     127,   568,   129,   115,   116,   117,   118,   119,    97,   599,
      97,    97,   124,   125,    97,   127,    97,   129,   575,    97,
      97,    97,    97,    97,    97,    97,   666,   582,   700,   761,
     651,   100,   273,   502,   568,   236,   557,   663,   543,   455,
     347,   234,   597,    83,   458,   223,   621,    86,   531,   604,
     524,    -1,   469,    -1,    -1,    -1,    -1,    -1,   592,   469,
      -1,   698,   596,    -1,   131,    -1,   483,   699,   623,    -1,
      -1,    -1,    -1,   483,   664,   665,    -1,    -1,    -1,    -1,
      -1,    -1,   637,   709,   639,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     737,    -1,    -1,    -1,    -1,   695,    -1,    -1,   734,   699,
      -1,   701,    -1,    -1,   648,   649,   776,    -1,    -1,    -1,
      -1,    -1,   656,   657,   658,   659,   660,   661,   662,   663,
      -1,    -1,    -1,   667,   668,   669,   670,   671,   672,   673,
     674,   675,   676,   677,   678,   679,   680,   681,   682,   683,
     684,   685,   686,   687,    -1,    -1,    -1,    -1,   692,    -1,
      65,    66,   696,    -1,   698,    -1,   583,    -1,    -1,    -1,
     760,    -1,    -1,   583,    -1,   709,    -1,    -1,    -1,    -1,
      -1,    -1,   599,    -1,    -1,    -1,    -1,    -1,    -1,   599,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     734,    -1,    -1,   737,   738,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    65,    66,    -1,    -1,   124,
     125,    -1,   127,    -1,   129,    -1,    -1,    -1,   762,   763,
     764,   765,   766,   767,   768,   769,   770,   771,   772,   773,
     774,   775,    -1,    -1,    -1,    65,    66,   664,   665,    -1,
      -1,    -1,    -1,    -1,   664,   665,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,    -1,    -1,    -1,   124,   125,    -1,   127,   695,   129,
      -1,    -1,   699,    -1,   701,   695,    -1,    -1,    -1,    -1,
      -1,   701,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,    -1,    -1,    -1,   124,   125,    -1,   127,     3,   129,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      -1,    -1,    17,    18,    19,    20,    -1,    22,    23,    -1,
      25,    26,    -1,    28,    29,    30,    31,    -1,    33,    34,
      35,    36,    37,   760,    39,    40,    41,    -1,    43,    44,
     760,    -1,    47,    48,    49,    -1,    -1,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    62,    63,    64,
      -1,    -1,    67,    -1,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,   118,    -1,   120,   121,   122,   123,    -1,
     125,    -1,   127,    -1,    -1,   130,   131,   132,     3,   132,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      -1,    -1,    17,    18,    19,    20,    -1,    22,    23,    -1,
      25,    26,    -1,    28,    29,    30,    31,    -1,    33,    34,
      35,    36,    37,    -1,    39,    40,    41,    -1,    43,    44,
      65,    66,    47,    48,    49,    -1,    -1,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    62,    63,    64,
      -1,    -1,    67,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,    -1,    -1,    -1,   124,
     125,    -1,   127,    -1,   129,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,   118,    -1,   120,   121,   122,   123,    -1,
     125,    -1,   127,    -1,    -1,   130,   131,   132,     3,    -1,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      -1,    -1,    17,    18,    19,    20,    -1,    22,    23,    -1,
      25,    26,    -1,    28,    29,    30,    31,    -1,    33,    34,
      35,    36,    37,    -1,    39,    40,    41,    -1,    43,    44,
      65,    66,    47,    48,    49,    -1,    -1,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    62,    63,    64,
      -1,    -1,    67,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,     4,    -1,    -1,    -1,   124,
     125,    -1,   127,    -1,   129,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,   118,    -1,   120,   121,   122,   123,    -1,
     125,     3,   127,     5,     6,   130,    -1,   132,    -1,    -1,
      -1,    13,    -1,    -1,    -1,    -1,    18,    19,    20,    -1,
      22,    23,    51,    25,    -1,    -1,    -1,    29,    -1,    31,
      -1,    33,    34,    -1,    36,    37,    65,    66,    40,    -1,
      -1,    43,    44,    -1,     4,    47,    -1,    49,    -1,    -1,
      -1,    53,    54,    55,    56,    -1,    58,    59,    -1,    -1,
      62,    63,    -1,    -1,    -1,    67,    -1,    -1,    97,    98,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    51,    -1,    -1,    -1,   124,   125,    -1,   127,    -1,
     129,    -1,    -1,   132,    -1,    65,    66,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,     4,   118,    -1,   120,   121,
     122,   123,    -1,   125,    -1,   127,    -1,    -1,    -1,    -1,
     132,    -1,    65,    66,    -1,    -1,    -1,    97,    98,    -1,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,    -1,    51,    -1,   124,   125,    -1,   127,    -1,   129,
      -1,    -1,   132,    -1,    -1,    -1,    65,    66,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,    -1,    -1,
      -1,   124,   125,    -1,   127,    -1,   129,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     4,    -1,    -1,    97,    98,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,     3,    -1,     5,     6,   124,   125,    -1,   127,    -1,
     129,    13,    -1,   132,    -1,    -1,    18,    19,    20,    -1,
      22,    23,    51,    25,    -1,    -1,    -1,    29,    -1,    31,
      -1,    33,    34,    -1,    36,    37,    65,    66,    40,    -1,
      -1,    43,    44,    -1,    -1,    47,    -1,    49,    -1,    -1,
      -1,    53,    54,    55,    56,    -1,    58,    59,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    67,    -1,    -1,    97,    98,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,    -1,    -1,    -1,   124,   125,    -1,   127,    -1,
     129,   130,    -1,    -1,    -1,    -1,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,    -1,   118,    -1,   120,   121,
     122,   123,    -1,   125,     3,   127,     5,     6,   130,    -1,
      -1,    -1,    -1,    -1,    13,    -1,    -1,    -1,    -1,    18,
      19,    20,    -1,    22,    23,    -1,    25,    65,    66,    -1,
      29,    -1,    31,    -1,    33,    34,     4,    36,    37,    -1,
      -1,    40,    -1,    -1,    43,    44,    -1,    -1,    47,    -1,
      49,    -1,    -1,    -1,    53,    54,    55,    56,    -1,    58,
      59,    -1,    -1,    62,    -1,    -1,    -1,    -1,    67,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,    51,    -1,    -1,   124,   125,    -1,   127,
      -1,   129,    -1,    -1,    -1,    -1,    -1,    65,    66,    -1,
      -1,    -1,    -1,    -1,    -1,     4,    -1,    -1,    -1,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,   118,
      -1,   120,   121,   122,   123,    -1,   125,    -1,   127,    97,
      98,   130,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    51,    -1,    -1,    -1,   124,   125,    -1,   127,
      -1,   129,   130,    -1,    -1,    -1,    65,    66,    -1,    -1,
      -1,    -1,    -1,    -1,     4,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    65,    66,    97,    98,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    51,    -1,    -1,    -1,   124,   125,    -1,   127,    -1,
     129,   130,    -1,    -1,    -1,    65,    66,    -1,    -1,    -1,
      -1,    -1,    -1,     4,   113,   114,   115,   116,   117,   118,
     119,    -1,    -1,    -1,    -1,   124,   125,    -1,   127,    -1,
     129,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    -1,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      51,    -1,    -1,    -1,   124,   125,    -1,   127,   128,   129,
      -1,    -1,    -1,    -1,    65,    66,    -1,    -1,    -1,    -1,
      -1,    -1,     4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    -1,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    51,
      -1,    -1,    -1,   124,   125,    -1,   127,   128,   129,    -1,
      -1,    -1,    -1,    65,    66,    -1,    -1,    -1,    -1,    -1,
      -1,     4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    -1,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    51,    -1,
      -1,    -1,   124,   125,    -1,   127,   128,   129,    -1,    -1,
      -1,    -1,    65,    66,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    51,    -1,    -1,
      -1,   124,   125,    -1,   127,    -1,   129,    -1,    -1,    -1,
      -1,    65,    66,    -1,    -1,    -1,    -1,    -1,    -1,     4,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    51,    -1,    -1,    -1,
     124,   125,    -1,   127,    -1,   129,    -1,    -1,    -1,    -1,
      65,    66,    -1,    -1,    -1,    -1,    -1,    -1,     4,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    98,    -1,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    51,    -1,    -1,    -1,   124,
     125,    -1,   127,    -1,   129,    -1,    -1,    -1,    -1,    65,
      66,    -1,    -1,    -1,    -1,    -1,    -1,     4,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    98,    -1,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    51,    -1,    -1,    -1,   124,   125,
      -1,   127,   128,   129,    -1,    -1,    -1,    -1,    65,    66,
      -1,    -1,    -1,    -1,    -1,    -1,     4,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    -1,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,    51,    -1,    -1,    -1,   124,   125,    -1,
     127,   128,   129,    -1,    -1,    -1,    -1,    65,    66,    -1,
      -1,    -1,    -1,    -1,    -1,     4,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      98,    -1,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    51,    -1,    -1,    -1,   124,   125,    -1,   127,
     128,   129,    -1,    -1,    -1,    -1,    65,    66,    -1,    -1,
      -1,    -1,    -1,    -1,     4,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,
      -1,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    51,    -1,    -1,    -1,   124,   125,    -1,   127,   128,
     129,    -1,    -1,    -1,    -1,    65,    66,    -1,    -1,    -1,
      -1,    -1,    -1,     4,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    -1,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      51,    -1,    -1,    -1,   124,   125,    -1,   127,   128,   129,
      -1,    -1,    -1,    -1,    65,    66,    -1,    -1,    -1,    -1,
      -1,    -1,     4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    -1,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,    51,
      -1,    -1,    -1,   124,   125,    -1,   127,   128,   129,    -1,
      -1,    -1,    -1,    65,    66,    -1,    -1,    -1,    -1,    -1,
      -1,     4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    51,    -1,
      -1,    -1,   124,   125,    -1,   127,    -1,   129,    -1,    -1,
      -1,    -1,    65,    66,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    97,    98,    -1,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    51,    -1,    -1,
      -1,   124,   125,    -1,   127,    -1,   129,    -1,    -1,    -1,
      -1,    65,    66,    -1,    -1,    -1,    -1,    -1,    -1,     4,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    65,    66,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    -1,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,    51,    -1,    -1,    -1,
     124,   125,    -1,   127,    -1,   129,    -1,    -1,    -1,    -1,
      65,    66,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,    -1,    -1,    -1,   124,   125,    -1,   127,    -1,   129,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    97,    98,    -1,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,     3,    -1,     5,     6,   124,
     125,    -1,   127,    -1,   129,    13,    -1,    -1,    -1,    -1,
      18,    19,    20,    -1,    22,    23,    -1,    25,    -1,    -1,
      -1,    29,    -1,    31,    -1,    33,    34,    -1,    36,    37,
      65,    66,    40,    -1,    -1,    43,    44,    -1,    -1,    47,
      -1,    49,    -1,    -1,    -1,    53,    54,    55,    56,    -1,
      58,    59,    -1,    -1,    62,    -1,    -1,    -1,    -1,    67,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,    -1,    -1,    -1,   124,
     125,    -1,   127,    -1,   129,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,
     118,    -1,   120,   121,   122,   123,   124,   125,     3,   127,
       5,     6,    -1,    -1,    -1,    -1,    -1,    -1,    13,    -1,
      -1,    -1,    -1,    18,    19,    20,    -1,    22,    23,    -1,
      25,    -1,    -1,    -1,    29,    -1,    31,    -1,    33,    34,
      -1,    36,    37,    65,    66,    40,    -1,    -1,    43,    44,
      -1,    -1,    47,    -1,    49,    -1,    -1,    -1,    53,    54,
      55,    56,    -1,    58,    59,    -1,    61,    62,    -1,    -1,
      -1,    -1,    67,    -1,    -1,    -1,    -1,    -1,    -1,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,    -1,
      -1,    -1,   124,   125,    -1,   127,    -1,   129,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,   118,    -1,   120,   121,   122,   123,    -1,
     125,     3,   127,     5,     6,    -1,    -1,    -1,    -1,    -1,
      -1,    13,    -1,    -1,    -1,    -1,    18,    19,    20,    -1,
      22,    23,    -1,    25,    -1,    -1,    -1,    29,    -1,    31,
      -1,    33,    34,    -1,    36,    37,    65,    66,    40,    -1,
      -1,    43,    44,    -1,    -1,    47,    -1,    49,    -1,    -1,
      -1,    53,    54,    55,    56,    -1,    58,    59,    -1,    -1,
      62,    -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,    -1,    -1,    -1,    -1,   124,   125,    -1,   127,    -1,
     129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,    -1,   118,    -1,   120,   121,
     122,   123,    -1,   125,     3,   127,     5,     6,    -1,    -1,
      -1,    -1,    -1,    -1,    13,    -1,    -1,    -1,    -1,    18,
      19,    20,    -1,    22,    23,    -1,    25,    -1,    -1,    -1,
      29,    -1,    31,    -1,    33,    34,    -1,    36,    37,    65,
      66,    40,    -1,    -1,    43,    44,    -1,    -1,    47,    -1,
      49,    -1,    -1,    -1,    53,    54,    55,    56,    -1,    58,
      59,    -1,    -1,    62,    -1,    -1,    -1,    -1,    67,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,    -1,    -1,    -1,   124,   125,
      -1,   127,    -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,   118,
      -1,   120,   121,   122,   123,    -1,   125,     3,   127,     5,
       6,    -1,    -1,    -1,    -1,    -1,    -1,    13,    -1,    -1,
      -1,    -1,    18,    19,    20,    -1,    22,    23,    -1,    25,
      -1,    -1,    -1,    29,    -1,    31,    -1,    33,    34,    -1,
      36,    37,    65,    66,    40,    -1,    -1,    43,    44,    -1,
      -1,    47,    -1,    49,    -1,    -1,    -1,    53,    54,    55,
      56,    -1,    58,    59,    -1,    -1,    62,    -1,    -1,    -1,
      -1,    67,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,    65,    66,    -1,
      -1,   124,   125,    -1,   127,    -1,   129,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   120,   121,   122,   123,    -1,    -1,
      -1,    -1,    -1,    -1,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,    -1,    -1,    -1,   124,   125,    -1,   127,
      -1,   129,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,     5,     6,    -1,    -1,    -1,    -1,
      -1,    -1,    13,    -1,    -1,   131,    -1,    -1,    -1,    20,
      -1,    -1,    23,    -1,    25,    26,    -1,    -1,    29,    -1,
      31,    -1,    33,    34,    -1,    36,    37,    -1,    -1,    -1,
      -1,   131,    43,    44,     5,     6,    47,    -1,    49,    -1,
      -1,    -1,    13,    54,    55,    56,    -1,    58,    59,    20,
      -1,    62,    23,    -1,    25,    26,    67,    -1,    29,    -1,
      31,    -1,    33,    34,    -1,    36,    37,    -1,    -1,    -1,
      -1,    -1,    43,    44,    -1,    -1,    47,    -1,    49,    -1,
      -1,    -1,    -1,    54,    55,    56,    -1,    58,    59,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    67,     8,     9,    10,
      11,    12,    -1,    -1,    -1,    16,    17,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    26,    27,    -1,    -1,    -1,
      31,    32,    33,    -1,    -1,    -1,    -1,    38,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      61,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    94,   134,   137,   136,     0,     8,     9,    10,    11,
      12,    16,    17,    26,    27,    31,    32,    33,    38,    50,
      61,   135,   178,   190,   191,     3,     5,     6,    13,    18,
      19,    20,    22,    23,    25,    29,    31,    33,    34,    36,
      37,    40,    43,    44,    47,    49,    53,    54,    55,    56,
      58,    59,    62,    67,   110,   115,   116,   118,   120,   121,
     122,   123,   125,   127,   147,   167,   198,   211,   235,   127,
     127,   127,   228,   229,   228,   231,   232,   130,   228,   228,
     228,    34,    25,    26,    49,   226,   227,   228,   217,   188,
     147,   127,   147,   130,    42,   199,   153,    34,   225,    42,
     127,   130,   147,   125,   127,   125,   127,    42,   127,   147,
     147,   147,   154,   147,   147,   147,   147,   124,   147,   155,
     156,   157,   162,   147,     4,    51,    65,    66,    97,    98,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     124,   125,   127,   129,   147,    34,    34,    99,   206,   226,
     206,   127,   205,   233,   235,   179,   205,   206,   205,   132,
     226,   231,   226,   180,   233,    99,     7,    14,    17,    26,
      28,    30,    35,    39,    41,    48,    52,    57,    63,    64,
     130,   132,   139,   140,   141,   142,   147,   190,   211,   215,
     223,   189,   147,   170,    26,    31,    33,    49,    54,    58,
      62,   167,   171,   234,   235,   125,   200,   201,   147,    97,
      34,   156,   168,   130,   171,   172,   162,   163,   172,   149,
     171,   163,   110,    46,    34,   126,    96,   240,    96,   240,
     128,   130,   147,   159,   159,   171,   171,   148,   147,   147,
     147,   147,   147,   147,   147,   147,   147,   147,   147,   147,
     147,   147,   147,   147,   147,   147,   147,   147,   147,    34,
     138,   147,   162,   151,    34,   128,   128,   128,   171,     4,
      51,    97,   207,   230,   207,    34,   175,   176,   177,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,   212,   213,   214,   137,   212,
     207,   212,     4,   205,   124,   184,   206,   187,   147,   132,
     225,   218,   235,   132,   127,   127,   225,   132,   162,    63,
     132,   147,   147,   127,   216,    60,   215,   125,   127,   132,
      97,   215,   130,   190,   192,   128,    34,   164,   165,   166,
     127,   205,   127,    19,   202,   203,   204,   189,   205,   159,
     240,   173,   218,    96,   126,   240,   128,   126,   163,   128,
      45,    97,   200,   157,   147,   160,   159,    99,    99,    96,
     126,   155,   208,   209,   208,    99,   128,    96,   132,    97,
      97,    97,    97,    97,    97,    97,    97,    97,    97,    97,
      97,    97,    97,    97,   214,   131,   208,   130,   212,    34,
       4,   207,   171,    96,   236,    95,   237,   206,   132,   127,
     237,    34,   125,   147,   206,   237,   132,   237,   132,   130,
     147,    95,   238,   147,   143,   202,   144,   145,   237,   147,
     193,    88,    97,   239,   131,    96,   175,   175,    96,   126,
      34,   130,   195,   128,   169,   189,   131,   171,   212,    42,
     128,   147,    97,   161,   162,   147,   138,   147,   152,   212,
     159,   212,   171,    99,   177,   177,   147,   147,   147,   147,
     147,   147,   147,   147,   147,   147,   147,   147,   147,   147,
      18,   212,   181,   182,   183,   130,   208,   212,   147,   132,
     207,   237,   163,    96,   108,   224,   225,   128,   207,   237,
     237,   219,   128,   217,   130,   126,   128,   147,   132,   217,
      97,    18,   116,   166,   128,   128,   203,   196,   131,    34,
     174,   171,   150,   158,   131,   240,   126,   128,   132,   210,
     132,   212,   171,   132,   164,     4,    51,   185,   212,   132,
     208,   128,    34,   147,    96,   126,   215,   208,    15,    21,
     131,   220,   215,   131,   238,   127,   146,   237,   194,    18,
     239,    18,   217,    99,   212,   195,   131,   130,   130,   173,
     132,   212,   108,   128,   225,    96,   108,    24,   212,    61,
     162,   221,   222,    99,   217,   144,   131,   197,   171,   132,
     213,   213,   186,   132,   147,    34,   147,   215,   132,   171,
      99,    96,    99,   217,   131,   128,   131,   212,   131,   131,
     131,   237,   128,   108,   128,   237,    65,   217,   222,   217,
     132,   132,   132,   212,   147,    34,   132,   128,     3,    22,
      29,    33,    40,    54,    58,    62,   115,   116,   120,   121,
     122,   123,     4,    51,    65,    66,    97,    98,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   147,    31,
      58,    62,    96,   147,   147,    42,   153,   225,   127,   125,
     127,    42,   147,   147,   147,   147,   147,   147,   147,   148,
     147,   147,   147,   147,   147,   147,   147,   147,   147,   147,
     147,   147,   147,   147,   147,   147,   147,   147,   147,   147,
     147,   127,   147,   147,    97,   163,   172,   149,    99,   175,
     128,   126,   163,   147,   128,    68,    69,    70,    73,    74,
      75,    76,    77,    79,    80,    82,    83,    86,    87,   213,
      42,   128,    97,    97,    97,    97,    97,    97,    97,    97,
      97,    97,    97,    97,    97,    97,   150,   147,   147,   147,
     147,   147,   147,   147,   147,   147,   147,   147,   147,   147,
     147
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,   133,   135,   134,   136,   134,   137,   137,   138,   138,
     139,   139,   140,   141,   141,   142,   142,   143,   143,   145,
     146,   144,   147,   147,   147,   147,   147,   147,   147,   147,
     147,   147,   147,   147,   147,   147,   147,   147,   147,   147,
     147,   147,   147,   147,   147,   147,   147,   147,   147,   147,
     147,   147,   147,   148,   147,   147,   147,   147,   147,   147,
     147,   147,   147,   149,   150,   147,   147,   147,   151,   152,
     147,   153,   147,   147,   147,   147,   147,   147,   147,   154,
     147,   147,   147,   147,   155,   155,   155,   156,   156,   157,
     158,   157,   160,   159,   159,   161,   161,   162,   162,   163,
     163,   164,   164,   165,   165,   166,   166,   166,   167,   167,
     167,   167,   167,   167,   167,   167,   167,   167,   167,   167,
     167,   167,   168,   169,   167,   170,   167,   167,   167,   167,
     167,   171,   171,   171,   171,   171,   172,   172,   173,   173,
     174,   175,   175,   175,   176,   176,   176,   177,   178,   179,
     178,   178,   178,   178,   180,   178,   181,   178,   182,   178,
     183,   178,   184,   185,   186,   178,   187,   178,   188,   178,
     178,   189,   189,   190,   190,   190,   190,   190,   191,   191,
     191,   191,   193,   194,   192,   196,   197,   195,   199,   198,
     200,   201,   201,   202,   202,   203,   204,   204,   205,   205,
     206,   206,   207,   207,   207,   207,   209,   210,   208,   208,
     211,   212,   212,   213,   213,   214,   214,   214,   214,   214,
     214,   214,   214,   214,   214,   214,   214,   214,   214,   214,
     214,   214,   214,   214,   214,   214,   214,   214,   214,   214,
     214,   214,   216,   215,   215,   215,   215,   215,   215,   215,
     215,   215,   215,   215,   215,   215,   215,   215,   215,   215,
     215,   215,   215,   215,   217,   217,   218,   219,   219,   220,
     220,   220,   221,   221,   222,   222,   223,   223,   223,   223,
     224,   224,   225,   227,   226,   229,   230,   228,   232,   231,
     233,   234,   235,   235,   236,   236,   237,   237,   238,   238,
     239,   239,   239,   240,   240
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     3,     0,     3,     2,     0,     1,     0,
       7,     1,     2,     7,     4,     2,     1,     1,     0,     0,
       0,     3,     3,     4,     2,     2,     2,     2,     2,     2,
       2,     2,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     5,     0,     4,     4,     4,     1,     3,     3,
       3,     3,     5,     0,     0,     7,     5,     4,     0,     0,
       6,     0,     3,     3,     1,     5,     1,     1,     1,     0,
       4,     3,     3,     3,     0,     2,     2,     3,     1,     4,
       0,     6,     0,     4,     1,     2,     0,     3,     1,     2,
       0,     1,     2,     1,     3,     4,     4,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       6,     4,     0,     0,     6,     0,     5,     3,     3,     1,
       3,     1,     2,     4,     4,     1,     3,     1,     3,     0,
       5,     1,     2,     0,     3,     3,     1,     4,     3,     0,
       5,     7,     7,     7,     0,     8,     0,     9,     0,    11,
       0,    11,     0,     0,     0,    12,     0,     7,     0,     4,
       1,     0,     2,     4,     4,     4,     1,     1,     4,     4,
       4,     5,     0,     0,     5,     0,     0,     5,     0,     5,
       2,     3,     0,     3,     1,     2,     1,     0,     5,     3,
       2,     0,     0,     1,     1,     1,     0,     0,     3,     0,
       6,     1,     0,     2,     1,     3,     3,     1,     1,     1,
       1,     3,     3,     3,     3,     1,     3,     3,     3,     3,
       3,     1,     3,     3,     3,     1,     1,     1,     3,     1,
       1,     1,     0,     5,     4,     4,     4,     5,     7,     5,
       2,     5,     3,     3,     3,     3,     4,     8,     8,     1,
       5,     3,     1,     1,     2,     0,     4,     2,     0,     4,
       4,     3,     3,     1,     2,     4,     6,     8,     8,    10,
       3,     1,     1,     0,     2,     0,     0,     3,     0,     2,
       1,     1,     1,     1,     2,     0,     1,     0,     1,     0,
       1,     3,     0,     1,     0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]));
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Location data for the lookahead symbol.  */
YYLTYPE yylloc
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = zeeklex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 371 "/build/zeek/src/zeek/src/parse.y"
                        {
			// Without the following, in some scenarios the
			// location associated with global statements gets
			// associated with the last @load'd file rather than
			// the script that includes the global statements.
			auto loc = zeek::detail::GetCurrentLocation();
			if ( loc.FileName() )
				set_location(loc);
			}
#line 2825 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 3: /* zeek: decl_list $@1 stmt_list  */
#line 381 "/build/zeek/src/zeek/src/parse.y"
                        {
			if ( stmts )
				stmts->AsStmtList()->Stmts().push_back({AdoptRef{}, (yyvsp[0].stmt)});
			else
				stmts = (yyvsp[0].stmt);

			// Do some further validation on the parsed AST unless
			// we already know there were errors.
			if ( zeek::reporter->Errors() == 0 )
				zeek::detail::script_validation();

			// Any objects creates from here on out should not
			// have file positions associated with them.
			set_location(no_location);
			}
#line 2845 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 4: /* $@2: %empty  */
#line 400 "/build/zeek/src/zeek/src/parse.y"
                          { in_debug = true; }
#line 2851 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 5: /* zeek: TOK_DEBUG $@2 expr  */
#line 401 "/build/zeek/src/zeek/src/parse.y"
                        {
			g_curr_debug_expr = (yyvsp[0].expr);
			}
#line 2859 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 8: /* opt_expr: expr  */
#line 413 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.expr) = (yyvsp[0].expr); }
#line 2865 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 9: /* opt_expr: %empty  */
#line 415 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.expr) = 0; }
#line 2871 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 10: /* when_clause: when_head TOK_TIMEOUT expr '{' opt_no_test_block stmt_list '}'  */
#line 420 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-6]), (yylsp[0]));
			(yyvsp[-6].when_clause)->AddTimeout({AdoptRef{}, (yyvsp[-4].expr)}, {AdoptRef{}, (yyvsp[-1].stmt)});
			if ( (yyvsp[-2].b) )
			    script_coverage_mgr.DecIgnoreDepth();
			}
#line 2882 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 12: /* when_head: when_start stmt  */
#line 432 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]), (yylsp[0]));
			(yyvsp[-1].when_clause)->AddBody({AdoptRef{}, (yyvsp[0].stmt)});
			}
#line 2891 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 13: /* when_start: when_flavor '[' when_captures ']' '(' when_condition ')'  */
#line 440 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-6]), (yylsp[0]));
			(yyval.when_clause) = new WhenInfo({AdoptRef{}, (yyvsp[-1].expr)}, (yyvsp[-4].captures), (yyvsp[-6].b));
			}
#line 2900 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 14: /* when_start: when_flavor '(' when_condition ')'  */
#line 446 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[0]));
			(yyval.when_clause) = new WhenInfo({AdoptRef{}, (yyvsp[-1].expr)}, nullptr, (yyvsp[-3].b));
			}
#line 2909 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 15: /* when_flavor: TOK_RETURN TOK_WHEN  */
#line 454 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.b) = true; }
#line 2915 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 16: /* when_flavor: TOK_WHEN  */
#line 457 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.b) = false; }
#line 2921 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 18: /* when_captures: %empty  */
#line 463 "/build/zeek/src/zeek/src/parse.y"
                { (yyval.captures) = new zeek::FuncType::CaptureList; }
#line 2927 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 19: /* $@3: %empty  */
#line 467 "/build/zeek/src/zeek/src/parse.y"
                { ++in_when_cond; }
#line 2933 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 20: /* $@4: %empty  */
#line 467 "/build/zeek/src/zeek/src/parse.y"
                                         { --in_when_cond; }
#line 2939 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 21: /* when_condition: $@3 expr $@4  */
#line 468 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.expr) = (yyvsp[-1].expr); }
#line 2945 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 22: /* expr: '(' expr ')'  */
#line 473 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = (yyvsp[-1].expr); (yyval.expr)->MarkParen();
			}
#line 2954 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 23: /* expr: TOK_COPY '(' expr ')'  */
#line 479 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[0]));
			(yyval.expr) = new CloneExpr({AdoptRef{}, (yyvsp[-1].expr)});
			}
#line 2963 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 24: /* expr: TOK_ADD expr  */
#line 485 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]), (yylsp[0]));
			(yyval.expr) = new AggrAddExpr({AdoptRef{}, (yyvsp[0].expr)});
			}
#line 2972 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 25: /* expr: TOK_DELETE expr  */
#line 491 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]), (yylsp[0]));
			(yyval.expr) = new AggrDelExpr({AdoptRef{}, (yyvsp[0].expr)});
			}
#line 2981 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 26: /* expr: TOK_INCR expr  */
#line 497 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]), (yylsp[0]));
			(yyval.expr) = new IncrExpr(EXPR_INCR, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 2990 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 27: /* expr: TOK_DECR expr  */
#line 503 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]), (yylsp[0]));
			(yyval.expr) = new IncrExpr(EXPR_DECR, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 2999 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 28: /* expr: '!' expr  */
#line 509 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]), (yylsp[0]));
			(yyval.expr) = new NotExpr({AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3008 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 29: /* expr: '~' expr  */
#line 515 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]), (yylsp[0]));
			(yyval.expr) = new ComplementExpr({AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3017 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 30: /* expr: '-' expr  */
#line 521 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]), (yylsp[0]));
			(yyval.expr) = new NegExpr({AdoptRef{}, (yyvsp[0].expr)});

			if ( ! (yyval.expr)->IsError() && (yyvsp[0].expr)->IsConst() ) {
				auto v = (yyvsp[0].expr)->ExprVal();
				auto tag = v->GetType()->Tag();

				if ( tag == TYPE_COUNT ) {
					auto c = v->AsCount();
					uint64_t int_max = static_cast<uint64_t>(INT64_MAX) + 1;

					if ( c <= int_max ) {
						auto ce = new ConstExpr(val_mgr->Int(-c));
						Unref((yyval.expr));
						(yyval.expr) = ce;
					}
					else {
						(yyval.expr)->Error("literal is outside range of 'int' values");
						(yyval.expr)->SetError();
					}
				}
				else {
					auto ce = new ConstExpr((yyval.expr)->Eval(nullptr));
					Unref((yyval.expr));
					(yyval.expr) = ce;
				}
			}
			}
#line 3051 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 31: /* expr: '+' expr  */
#line 552 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]), (yylsp[0]));
			(yyval.expr) = new PosExpr({AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3060 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 32: /* expr: expr '+' expr  */
#line 558 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new AddExpr({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3069 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 33: /* expr: expr TOK_ADD_TO rhs  */
#line 564 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));

			ExprPtr lhs = {AdoptRef{}, (yyvsp[-2].expr)};
			ExprPtr rhs = {AdoptRef{}, (yyvsp[0].expr)};
			auto tag1 = (yyvsp[-2].expr)->GetType()->Tag();

			if ( IsArithmetic((yyvsp[-2].expr)->GetType()->Tag()) ) {
				// Script optimization assumes that each AST
				// node is distinct, hence the call to
				// Duplicate() here.
				ExprPtr sum = make_intrusive<AddExpr>(lhs->Duplicate(), rhs);

				if ( sum->GetType()->Tag() != tag1 )
					sum = make_intrusive<ArithCoerceExpr>(sum, tag1);

				(yyval.expr) = new AssignExpr(lhs, sum, false);
			}
			else
				(yyval.expr) = new AddToExpr(lhs, rhs);
			}
#line 3095 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 34: /* expr: expr '-' expr  */
#line 587 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new SubExpr({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3104 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 35: /* expr: expr TOK_REMOVE_FROM rhs  */
#line 593 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));

			ExprPtr lhs = {AdoptRef{}, (yyvsp[-2].expr)};
			ExprPtr rhs = {AdoptRef{}, (yyvsp[0].expr)};
			auto tag1 = (yyvsp[-2].expr)->GetType()->Tag();

			if ( IsArithmetic(tag1) ) {
				ExprPtr sum = make_intrusive<SubExpr>(lhs, rhs);

				if ( sum->GetType()->Tag() != tag1 )
					sum = make_intrusive<ArithCoerceExpr>(sum, tag1);

				(yyval.expr) = new AssignExpr(lhs, sum, false);
			}
			else
				(yyval.expr) = new RemoveFromExpr(lhs, rhs);
			}
#line 3127 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 36: /* expr: expr '*' expr  */
#line 613 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new TimesExpr({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3136 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 37: /* expr: expr '/' expr  */
#line 619 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			if ( (yyvsp[-2].expr)->GetType()->Tag() == TYPE_ADDR )
				(yyval.expr) = new MaskExpr({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			else
				(yyval.expr) = new DivideExpr({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3148 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 38: /* expr: expr '%' expr  */
#line 628 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new ModExpr({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3157 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 39: /* expr: expr '&' expr  */
#line 634 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new BitExpr(EXPR_AND, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3166 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 40: /* expr: expr '|' expr  */
#line 640 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new BitExpr(EXPR_OR, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3175 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 41: /* expr: expr '^' expr  */
#line 646 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new BitExpr(EXPR_XOR, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3184 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 42: /* expr: expr TOK_LSHIFT expr  */
#line 652 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new BitExpr(EXPR_LSHIFT, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3193 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 43: /* expr: expr TOK_RSHIFT expr  */
#line 658 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new BitExpr(EXPR_RSHIFT, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3202 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 44: /* expr: expr TOK_AND_AND expr  */
#line 664 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new BoolExpr(EXPR_AND_AND, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3211 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 45: /* expr: expr TOK_OR_OR expr  */
#line 670 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new BoolExpr(EXPR_OR_OR, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3220 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 46: /* expr: expr TOK_EQ expr  */
#line 676 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new EqExpr(EXPR_EQ, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3229 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 47: /* expr: expr TOK_NE expr  */
#line 682 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new EqExpr(EXPR_NE, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3238 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 48: /* expr: expr '<' expr  */
#line 688 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new RelExpr(EXPR_LT, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3247 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 49: /* expr: expr TOK_LE expr  */
#line 694 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new RelExpr(EXPR_LE, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3256 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 50: /* expr: expr '>' expr  */
#line 700 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new RelExpr(EXPR_GT, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3265 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 51: /* expr: expr TOK_GE expr  */
#line 706 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new RelExpr(EXPR_GE, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3274 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 52: /* expr: expr '?' expr ':' expr  */
#line 712 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-4]), (yylsp[0]));
			(yyval.expr) = new CondExpr({AdoptRef{}, (yyvsp[-4].expr)}, {AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3283 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 53: /* $@5: %empty  */
#line 718 "/build/zeek/src/zeek/src/parse.y"
                        {
			// Prevent usage of trailing commas on the left-hand
			// side of list expressions (e.g. in table inits).
			if ( (yyvsp[-1].expr)->Tag() == EXPR_LIST && expr_list_has_opt_comma )
				(yyvsp[-1].expr)->Error("incorrect syntax for list expression "
				          "on left-hand side of assignment: "
				          "trailing comma not allowed");
			}
#line 3296 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 54: /* expr: expr '=' $@5 rhs  */
#line 727 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[-1]));

			if ( (yyvsp[-3].expr)->Tag() == EXPR_INDEX && (yyvsp[-3].expr)->AsIndexExpr()->IsSlice() )
				reporter->Error("index slice assignment may not be used"
				                      " in arbitrary expression contexts, only"
				                      " as a statement");

			(yyval.expr) = get_assign_expr({AdoptRef{}, (yyvsp[-3].expr)}, {AdoptRef{}, (yyvsp[0].expr)}, in_init).release();
			}
#line 3311 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 55: /* expr: TOK_WHEN_LOCAL local_id '=' rhs  */
#line 739 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			if ( ! locals_at_this_scope.empty() )
				locals_at_this_scope.back().insert((yyvsp[-2].id));
			(yyval.expr) = add_and_assign_local({AdoptRef{}, (yyvsp[-2].id)}, {AdoptRef{}, (yyvsp[0].expr)},
			                                        val_mgr->True()).release();
			}
#line 3323 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 56: /* expr: expr '[' expr_list ']'  */
#line 748 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[0]));
			if ( in_when_cond > 0 )
				(yyval.expr) = new IndexExprWhen({AdoptRef{}, (yyvsp[-3].expr)}, {AdoptRef{}, (yyvsp[-1].list)});
			else
				(yyval.expr) = new IndexExpr({AdoptRef{}, (yyvsp[-3].expr)}, {AdoptRef{}, (yyvsp[-1].list)});
			}
#line 3335 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 58: /* expr: expr '$' TOK_ID  */
#line 759 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new FieldExpr({AdoptRef{}, (yyvsp[-2].expr)}, (yyvsp[0].str));
			}
#line 3344 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 59: /* expr: expr TOK_IN expr  */
#line 765 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new InExpr({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3353 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 60: /* expr: expr TOK_NOT_IN expr  */
#line 771 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new NotExpr(make_intrusive<InExpr>(
			        ExprPtr{AdoptRef{}, (yyvsp[-2].expr)},
			        ExprPtr{AdoptRef{}, (yyvsp[0].expr)}));
			}
#line 3364 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 61: /* expr: '[' opt_exprs_or_field_assigns ']'  */
#line 779 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));

			bool is_record_ctor = true;

			// If every expression in the list is a field assignment,
			// then treat it as a record constructor, else as a list
			// used for an initializer. Interpret no expressions
			// as an empty record constructor.

			for ( int i = 0; i < (yyvsp[-1].list)->Exprs().length(); ++i ) {
				if ( (yyvsp[-1].list)->Exprs()[i]->Tag() != EXPR_FIELD_ASSIGN ) {
					is_record_ctor = false;
					break;
				}
			}

			if ( is_record_ctor )
				(yyval.expr) = new RecordConstructorExpr({AdoptRef{}, (yyvsp[-1].list)});
			else
				(yyval.expr) = (yyvsp[-1].list);
			}
#line 3391 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 62: /* expr: TOK_RECORD '(' field_assigns expr_list_opt_comma ')'  */
#line 803 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-4]), (yylsp[-1]));
			(yyval.expr) = new RecordConstructorExpr({AdoptRef{}, (yyvsp[-2].list)});
			}
#line 3400 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 63: /* $@6: %empty  */
#line 808 "/build/zeek/src/zeek/src/parse.y"
                              { ++in_init; }
#line 3406 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 64: /* $@7: %empty  */
#line 808 "/build/zeek/src/zeek/src/parse.y"
                                                               { --in_init; }
#line 3412 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 65: /* expr: TOK_TABLE '(' $@6 opt_expr_list ')' $@7 opt_attr  */
#line 810 "/build/zeek/src/zeek/src/parse.y"
                        { // the ++in_init fixes up the parsing of "[x] = y"
			set_location((yylsp[-6]), (yylsp[-2]));
			std::unique_ptr<std::vector<AttrPtr>> attrs{(yyvsp[0].attr_l)};
			(yyval.expr) = new TableConstructorExpr({AdoptRef{}, (yyvsp[-3].list)}, std::move(attrs));
			}
#line 3422 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 66: /* expr: TOK_SET '(' opt_expr_list ')' opt_attr  */
#line 817 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-4]), (yylsp[-1]));
			std::unique_ptr<std::vector<AttrPtr>> attrs{(yyvsp[0].attr_l)};
			(yyval.expr) = new SetConstructorExpr({AdoptRef{}, (yyvsp[-2].list)}, std::move(attrs));
			}
#line 3432 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 67: /* expr: TOK_VECTOR '(' opt_expr_list ')'  */
#line 824 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[0]));
			(yyval.expr) = new VectorConstructorExpr({AdoptRef{}, (yyvsp[-1].list)});
			}
#line 3441 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 68: /* $@8: %empty  */
#line 830 "/build/zeek/src/zeek/src/parse.y"
                        {
			if ( expr_is_table_type_name((yyvsp[-1].expr)) )
				++in_init;
			}
#line 3450 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 69: /* $@9: %empty  */
#line 836 "/build/zeek/src/zeek/src/parse.y"
                        {
			if ( expr_is_table_type_name((yyvsp[-3].expr)) )
				--in_init;
			}
#line 3459 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 70: /* expr: expr '(' $@8 opt_exprs_or_field_assigns $@9 ')'  */
#line 842 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-5]), (yylsp[0]));

			if ( (yyvsp[-5].expr)->Tag() == EXPR_NAME && (yyvsp[-5].expr)->AsNameExpr()->Id()->IsType() )
				{
				const auto& ctor_type = (yyvsp[-5].expr)->AsNameExpr()->Id()->GetType();

				switch ( ctor_type->Tag() ) {
				case TYPE_RECORD: {
					auto rt = cast_intrusive<RecordType>(ctor_type);
					(yyval.expr) = new RecordConstructorExpr(rt, ListExprPtr{AdoptRef{}, (yyvsp[-2].list)});
					break;
				}

				case TYPE_TABLE:
					if ( ctor_type->IsTable() )
						(yyval.expr) = new TableConstructorExpr({AdoptRef{}, (yyvsp[-2].list)}, 0, ctor_type);
					else
						(yyval.expr) = new SetConstructorExpr({AdoptRef{}, (yyvsp[-2].list)}, 0, ctor_type);

					break;

				case TYPE_VECTOR:
					(yyval.expr) = new VectorConstructorExpr({AdoptRef{}, (yyvsp[-2].list)}, ctor_type);
					break;

				default:
					(yyvsp[-5].expr)->Error("constructor type not implemented");
					YYERROR;
				}
			}

			else
				(yyval.expr) = new CallExpr({AdoptRef{}, (yyvsp[-5].expr)}, {AdoptRef{}, (yyvsp[-2].list)}, in_hook > 0, in_when_cond);
			}
#line 3499 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 71: /* $@10: %empty  */
#line 878 "/build/zeek/src/zeek/src/parse.y"
                         { ++in_hook; }
#line 3505 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 72: /* expr: TOK_HOOK $@10 expr  */
#line 879 "/build/zeek/src/zeek/src/parse.y"
                        {
			--in_hook;
			set_location((yylsp[-2]), (yylsp[0]));

			if ( (yyvsp[0].expr)->Tag() != EXPR_CALL )
				(yyvsp[0].expr)->Error("not a valid hook call expression");
			else if ( (yyvsp[0].expr)->AsCallExpr()->Func()->GetType()->AsFuncType()->Flavor() != FUNC_FLAVOR_HOOK )
				(yyvsp[0].expr)->Error("hook keyword should only be used to call hooks");

			(yyval.expr) = (yyvsp[0].expr);
			}
#line 3521 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 73: /* expr: expr TOK_HAS_FIELD TOK_ID  */
#line 892 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new HasFieldExpr({AdoptRef{}, (yyvsp[-2].expr)}, (yyvsp[0].str));
			}
#line 3530 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 75: /* expr: TOK_SCHEDULE expr '{' event '}'  */
#line 900 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-4]), (yylsp[0]));
			(yyval.expr) = new ScheduleExpr({AdoptRef{}, (yyvsp[-3].expr)}, {AdoptRef{}, (yyvsp[-1].event_expr)});
			}
#line 3539 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 76: /* expr: lookup_identifier  */
#line 906 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			auto id = lookup_ID((yyvsp[0].str), current_module.c_str());

			if ( ! id ) {
				if ( ! in_debug ) {
/*	// CHECK THAT THIS IS NOT GLOBAL.
					id = install_ID($1, current_module.c_str(),
							        false, is_export);
*/

					yyerror(util::fmt("unknown identifier %s", (yyvsp[0].str)));
					YYERROR;
				}
				else {
					yyerror(util::fmt("unknown identifier %s", (yyvsp[0].str)));
					YYERROR;
				}
			}
			else {
				if ( id->IsDeprecated() )
					reporter->Deprecation(id->GetDeprecationWarning());

				if ( id->IsBlank() ) {
					(yyval.expr) = new NameExpr(std::move(id));
					(yyval.expr)->SetError("blank identifier used in expression");
				}
				else if ( ! id->GetType() ) {
					id->Error("undeclared variable");
					id->SetType(error_type());
					(yyval.expr) = new NameExpr(std::move(id));
				}
				else if ( id->IsEnumConst() ) {
					if ( IsErrorType(id->GetType()->Tag()) ) {
						// The most-relevant error message should already be reported, so
						// just bail out.
						YYERROR;
					}

					EnumType* t = id->GetType()->AsEnumType();
					auto intval = t->Lookup(id->ModuleName(), id->Name());
					if ( intval < 0 )
						reporter->InternalError("enum value not found for %s", id->Name());
					(yyval.expr) = new ConstExpr(t->GetEnumVal(intval));
				}
				else {
					if ( out_of_scope_locals.count(id.get()) > 0 )
						id->Error("use of out-of-scope local; move declaration to outer scope");

					(yyval.expr) = new NameExpr(std::move(id));
				}
			}
			}
#line 3597 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 77: /* expr: TOK_CONSTANT  */
#line 961 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.expr) = new ConstExpr({AdoptRef{}, (yyvsp[0].val)});
			}
#line 3606 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 78: /* expr: simple_type  */
#line 967 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			TypePtr ty{AdoptRef(), (yyvsp[0].type)};
			(yyval.expr) = new ConstExpr(make_intrusive<TypeVal>(ty, true));
			}
#line 3616 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 79: /* $@11: %empty  */
#line 973 "/build/zeek/src/zeek/src/parse.y"
                    { begin_RE(); }
#line 3622 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 80: /* expr: '/' $@11 TOK_PATTERN_TEXT TOK_PATTERN_END  */
#line 974 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]));

			auto* re = new RE_Matcher((yyvsp[-1].str));
			delete [] (yyvsp[-1].str);

			if ( (yyvsp[0].re_modes).ignore_case )
				re->MakeCaseInsensitive();

			if ( (yyvsp[0].re_modes).single_line )
				re->MakeSingleLine();

			re->Compile();
			(yyval.expr) = new ConstExpr(make_intrusive<PatternVal>(re));
			}
#line 3642 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 81: /* expr: '|' expr '|'  */
#line 991 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			ExprPtr e{AdoptRef{}, (yyvsp[-1].expr)};
			(yyval.expr) = new SizeExpr(std::move(e));
			}
#line 3652 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 82: /* expr: expr TOK_AS type  */
#line 998 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new CastExpr({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].type)});
			}
#line 3661 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 83: /* expr: expr TOK_IS type  */
#line 1004 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.expr) = new IsExpr({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].type)});
			}
#line 3670 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 84: /* opt_exprs_or_field_assigns: %empty  */
#line 1011 "/build/zeek/src/zeek/src/parse.y"
                { (yyval.list) = new ListExpr(); }
#line 3676 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 87: /* field_assigns: field_assigns ',' field_assign  */
#line 1018 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyvsp[-2].list)->Append({AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3685 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 88: /* field_assigns: field_assign  */
#line 1023 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			expr_list_has_opt_comma = 0;
			(yyval.list) = new ListExpr({AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3695 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 89: /* field_assign: '$' TOK_ID '=' expr  */
#line 1031 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[0]));
			(yyval.expr) = new FieldAssignExpr((yyvsp[-2].str), {AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3704 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 90: /* $@12: %empty  */
#line 1037 "/build/zeek/src/zeek/src/parse.y"
                        {
			func_hdr_location = (yylsp[-3]);
			(yyvsp[-1].id)->SetInferReturnType(true);
			}
#line 3713 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 91: /* field_assign: '$' TOK_ID begin_lambda '=' $@12 lambda_body  */
#line 1042 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.expr) = new FieldAssignExpr((yyvsp[-4].str), IntrusivePtr{AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3721 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 92: /* $@13: %empty  */
#line 1047 "/build/zeek/src/zeek/src/parse.y"
                    { ++in_init; }
#line 3727 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 93: /* rhs: '{' $@13 rhs_expr_list '}'  */
#line 1048 "/build/zeek/src/zeek/src/parse.y"
                        {
			--in_init;
			(yyval.expr) = (yyvsp[-1].list);
			}
#line 3736 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 96: /* rhs_expr_list: %empty  */
#line 1057 "/build/zeek/src/zeek/src/parse.y"
                { (yyval.list) = new ListExpr(); }
#line 3742 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 97: /* expr_list: expr_list ',' expr  */
#line 1062 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyvsp[-2].list)->Append({AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3751 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 98: /* expr_list: expr  */
#line 1068 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			expr_list_has_opt_comma = 0;
			(yyval.list) = new ListExpr({AdoptRef{}, (yyvsp[0].expr)});
			}
#line 3761 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 100: /* opt_expr_list: %empty  */
#line 1078 "/build/zeek/src/zeek/src/parse.y"
                { (yyval.list) = new ListExpr(); }
#line 3767 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 101: /* enum_body: enum_body_list  */
#line 1083 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.type) = cur_enum_type;
			cur_enum_type = nullptr;
			}
#line 3776 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 102: /* enum_body: enum_body_list ','  */
#line 1089 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.type) = cur_enum_type;
			cur_enum_type = nullptr;
			}
#line 3785 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 105: /* enum_body_elem: TOK_ID '=' TOK_CONSTANT opt_deprecated  */
#line 1108 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[-1]));
			assert(cur_enum_type);

			if ( (yyvsp[-1].val)->GetType()->Tag() != TYPE_COUNT )
				reporter->Error("enumerator is not a count constant");
			else
				cur_enum_type->AddName(current_module, (yyvsp[-3].str),
				                       (yyvsp[-1].val)->InternalUnsigned(), is_export, (yyvsp[0].expr),
				                       in_enum_redef != 0);
			}
#line 3801 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 106: /* enum_body_elem: TOK_ID '=' '-' TOK_CONSTANT  */
#line 1121 "/build/zeek/src/zeek/src/parse.y"
                        {
			// We only accept counts as enumerator, but we want to return a nice
			// error message if users try to use a negative integer (will also
			// catch other cases, but that's fine.)
			reporter->Error("enumerator is not a count constant");
			}
#line 3812 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 107: /* enum_body_elem: TOK_ID opt_deprecated  */
#line 1129 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]));
			assert(cur_enum_type);
			cur_enum_type->AddName(current_module, (yyvsp[-1].str), is_export, (yyvsp[0].expr),
			                       in_enum_redef != 0);
			}
#line 3823 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 108: /* simple_type: TOK_BOOL  */
#line 1139 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_BOOL)->Ref();
			}
#line 3832 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 109: /* simple_type: TOK_INT  */
#line 1145 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_INT)->Ref();
			}
#line 3841 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 110: /* simple_type: TOK_COUNT  */
#line 1151 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_COUNT)->Ref();
			}
#line 3850 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 111: /* simple_type: TOK_DOUBLE  */
#line 1157 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_DOUBLE)->Ref();
			}
#line 3859 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 112: /* simple_type: TOK_TIME  */
#line 1163 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_TIME)->Ref();
			}
#line 3868 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 113: /* simple_type: TOK_INTERVAL  */
#line 1169 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_INTERVAL)->Ref();
			}
#line 3877 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 114: /* simple_type: TOK_STRING  */
#line 1175 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_STRING)->Ref();
			}
#line 3886 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 115: /* simple_type: TOK_PATTERN  */
#line 1181 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_PATTERN)->Ref();
			}
#line 3895 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 116: /* simple_type: TOK_PORT  */
#line 1187 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_PORT)->Ref();
			}
#line 3904 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 117: /* simple_type: TOK_ADDR  */
#line 1193 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_ADDR)->Ref();
			}
#line 3913 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 118: /* simple_type: TOK_SUBNET  */
#line 1199 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_SUBNET)->Ref();
			}
#line 3922 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 119: /* simple_type: TOK_ANY  */
#line 1205 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = base_type(TYPE_ANY)->Ref();
			}
#line 3931 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 120: /* simple_type: TOK_TABLE '[' type_list ']' TOK_OF type  */
#line 1211 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-5]), (yylsp[0]));
			(yyval.type) = new TableType({AdoptRef{}, (yyvsp[-3].type_l)}, {AdoptRef{}, (yyvsp[0].type)});
			}
#line 3940 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 121: /* simple_type: TOK_SET '[' type_list ']'  */
#line 1217 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[0]));
			(yyval.type) = new TableType({AdoptRef{}, (yyvsp[-1].type_l)}, nullptr);
			}
#line 3949 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 122: /* $@14: %empty  */
#line 1223 "/build/zeek/src/zeek/src/parse.y"
                        { ++in_record; }
#line 3955 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 123: /* $@15: %empty  */
#line 1225 "/build/zeek/src/zeek/src/parse.y"
                        { --in_record; }
#line 3961 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 124: /* simple_type: TOK_RECORD '{' $@14 type_decl_list $@15 '}'  */
#line 1227 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-5]), (yylsp[-1]));
			(yyval.type) = new RecordType((yyvsp[-2].type_decl_l));
			}
#line 3970 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 125: /* $@16: %empty  */
#line 1232 "/build/zeek/src/zeek/src/parse.y"
                             { set_location((yylsp[-1])); parse_new_enum(); }
#line 3976 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 126: /* simple_type: TOK_ENUM '{' $@16 enum_body '}'  */
#line 1233 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-4]), (yylsp[0]));
			(yyvsp[-1].type)->UpdateLocationEndInfo((yylsp[0]));
			(yyval.type) = (yyvsp[-1].type);
			}
#line 3986 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 127: /* simple_type: TOK_VECTOR TOK_OF type  */
#line 1240 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.type) = new VectorType({AdoptRef{}, (yyvsp[0].type)});
			}
#line 3995 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 128: /* simple_type: TOK_FILE TOK_OF type  */
#line 1246 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.type) = new FileType({AdoptRef{}, (yyvsp[0].type)});
			}
#line 4004 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 129: /* simple_type: TOK_FILE  */
#line 1252 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			(yyval.type) = new FileType(base_type(TYPE_STRING));
			}
#line 4013 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 130: /* simple_type: TOK_OPAQUE TOK_OF TOK_ID  */
#line 1258 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[0]));
			(yyval.type) = new OpaqueType((yyvsp[0].str));
			}
#line 4022 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 132: /* type: TOK_FUNCTION func_params  */
#line 1266 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]), (yylsp[0]));
			(yyval.type) = (yyvsp[0].func_type);
			}
#line 4031 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 133: /* type: TOK_HOOK '(' formal_args ')'  */
#line 1272 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[-1]));
			(yyval.type) = new FuncType({AdoptRef{}, (yyvsp[-1].record)}, base_type(TYPE_BOOL), FUNC_FLAVOR_HOOK);
			}
#line 4040 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 134: /* type: TOK_EVENT '(' formal_args ')'  */
#line 1278 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[-1]));
			(yyval.type) = new FuncType({AdoptRef{}, (yyvsp[-1].record)}, nullptr, FUNC_FLAVOR_EVENT);
			}
#line 4049 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 135: /* type: resolve_id  */
#line 1284 "/build/zeek/src/zeek/src/parse.y"
                        {
			if ( ! (yyvsp[0].id) || ! ((yyval.type) = (yyvsp[0].id)->IsType() ? (yyvsp[0].id)->GetType().get() : nullptr) ) {
				NullStmt here;
				if ( (yyvsp[0].id) )
					(yyvsp[0].id)->Error("not a Zeek type", &here);
				(yyval.type) = error_type()->Ref();
			}
			else {
				Ref((yyval.type));

				if ( (yyvsp[0].id)->IsDeprecated() )
					reporter->Deprecation((yyvsp[0].id)->GetDeprecationWarning());
			}
			}
#line 4068 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 136: /* type_list: type_list ',' type  */
#line 1302 "/build/zeek/src/zeek/src/parse.y"
                        { (yyvsp[-2].type_l)->AppendEvenIfNotPure({AdoptRef{}, (yyvsp[0].type)}); }
#line 4074 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 137: /* type_list: type  */
#line 1304 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.type_l) = new TypeList({NewRef{}, (yyvsp[0].type)});
			(yyval.type_l)->Append({AdoptRef{}, (yyvsp[0].type)});
			}
#line 4083 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 138: /* type_decl_list: type_decl_list conditional_list type_decl  */
#line 1312 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyvsp[-2].type_decl_l)->push_back((yyvsp[0].type_decl));
			}
#line 4091 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 139: /* type_decl_list: %empty  */
#line 1316 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.type_decl_l) = new type_decl_list();
			}
#line 4099 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 140: /* type_decl: TOK_ID ':' type opt_attr ';'  */
#line 1323 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-4]), (yylsp[-1]));
			auto attrs = make_attributes((yyvsp[-1].attr_l), {NewRef{}, (yyvsp[-2].type)}, in_record > 0, /*is_param=*/false);
			(yyval.type_decl) = new TypeDecl((yyvsp[-4].str), {AdoptRef{}, (yyvsp[-2].type)}, std::move(attrs));

			if ( in_record > 0 && cur_decl_type_id )
				zeekygen_mgr->RecordField(cur_decl_type_id, (yyval.type_decl), ::filename,
				                          in_record_redef != 0);
			}
#line 4113 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 141: /* formal_args: formal_args_decl_list  */
#line 1336 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.record) = new RecordType((yyvsp[0].type_decl_l)); }
#line 4119 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 142: /* formal_args: formal_args_decl_list ';'  */
#line 1338 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.record) = new RecordType((yyvsp[-1].type_decl_l)); }
#line 4125 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 143: /* formal_args: %empty  */
#line 1340 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.record) = new RecordType(new type_decl_list()); }
#line 4131 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 144: /* formal_args_decl_list: formal_args_decl_list ';' formal_args_decl  */
#line 1345 "/build/zeek/src/zeek/src/parse.y"
                        { (yyvsp[-2].type_decl_l)->push_back((yyvsp[0].type_decl)); }
#line 4137 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 145: /* formal_args_decl_list: formal_args_decl_list ',' formal_args_decl  */
#line 1347 "/build/zeek/src/zeek/src/parse.y"
                        { (yyvsp[-2].type_decl_l)->push_back((yyvsp[0].type_decl)); }
#line 4143 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 146: /* formal_args_decl_list: formal_args_decl  */
#line 1349 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.type_decl_l) = new type_decl_list(); (yyval.type_decl_l)->push_back((yyvsp[0].type_decl)); }
#line 4149 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 147: /* formal_args_decl: TOK_ID ':' type opt_attr  */
#line 1354 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[0]));
			auto attrs = make_attributes((yyvsp[0].attr_l), {NewRef{}, (yyvsp[-1].type)}, /*in_record=*/false, /*is_param=*/true);
			(yyval.type_decl) = new TypeDecl((yyvsp[-3].str), {AdoptRef{}, (yyvsp[-1].type)}, std::move(attrs));
			}
#line 4159 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 148: /* decl: TOK_MODULE TOK_ID ';'  */
#line 1363 "/build/zeek/src/zeek/src/parse.y"
                        {
			current_module = (yyvsp[-1].str);
			zeek::detail::add_module((yyvsp[-1].str));
			zeekygen_mgr->ModuleUsage(::filename, current_module);
			}
#line 4169 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 149: /* $@17: %empty  */
#line 1369 "/build/zeek/src/zeek/src/parse.y"
                               { is_export = true; }
#line 4175 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 150: /* decl: TOK_EXPORT '{' $@17 decl_list '}'  */
#line 1370 "/build/zeek/src/zeek/src/parse.y"
                        { is_export = false; }
#line 4181 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 151: /* decl: TOK_GLOBAL def_global_id opt_type init_class opt_init opt_attr ';'  */
#line 1373 "/build/zeek/src/zeek/src/parse.y"
                        {
			build_global((yyvsp[-5].id), (yyvsp[-4].type), (yyvsp[-3].ic), (yyvsp[-2].expr), (yyvsp[-1].attr_l), VAR_REGULAR);
			}
#line 4189 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 152: /* decl: TOK_OPTION def_global_id opt_type init_class opt_init opt_attr ';'  */
#line 1378 "/build/zeek/src/zeek/src/parse.y"
                        {
			if ( (yyvsp[-5].id)->IsBlank() )
				(yyvsp[-5].id)->Error("blank identifier used as option");
			else
				build_global((yyvsp[-5].id), (yyvsp[-4].type), (yyvsp[-3].ic), (yyvsp[-2].expr), (yyvsp[-1].attr_l), VAR_OPTION);
			}
#line 4200 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 153: /* decl: TOK_CONST def_global_id opt_type init_class opt_init opt_attr ';'  */
#line 1386 "/build/zeek/src/zeek/src/parse.y"
                        {
			build_global((yyvsp[-5].id), (yyvsp[-4].type), (yyvsp[-3].ic), (yyvsp[-2].expr), (yyvsp[-1].attr_l), VAR_CONST);
			}
#line 4208 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 154: /* $@18: %empty  */
#line 1390 "/build/zeek/src/zeek/src/parse.y"
                                    {
			if ( (yyvsp[0].id)->IsType() ) {
				auto tag = (yyvsp[0].id)->GetType()->Tag();
				auto tstr = type_name(tag);
				if ( tag == TYPE_RECORD || tag == TYPE_ENUM )
					yyerror(zeek::util::fmt("redef of %s type %s is missing %s keyword",
								tstr, (yyvsp[0].id)->Name(), tstr));
				else
					yyerror(zeek::util::fmt("can not redef %s type %s", tstr, (yyvsp[0].id)->Name()));

				YYERROR;  // bail
				}
		}
#line 4226 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 155: /* decl: TOK_REDEF global_id $@18 opt_type init_class opt_init opt_attr ';'  */
#line 1403 "/build/zeek/src/zeek/src/parse.y"
                        {
			build_global((yyvsp[-6].id), (yyvsp[-4].type), (yyvsp[-3].ic), (yyvsp[-2].expr), (yyvsp[-1].attr_l), VAR_REDEF);
			}
#line 4234 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 156: /* $@19: %empty  */
#line 1408 "/build/zeek/src/zeek/src/parse.y"
                        { ++in_enum_redef; parse_redef_enum((yyvsp[-2].id)); zeekygen_mgr->Redef((yyvsp[-2].id), ::filename); }
#line 4240 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 157: /* decl: TOK_REDEF TOK_ENUM global_id TOK_ADD_TO '{' $@19 enum_body '}' ';'  */
#line 1410 "/build/zeek/src/zeek/src/parse.y"
                        {
			--in_enum_redef;
			// Zeekygen already grabbed new enum IDs as the type created them.
			}
#line 4249 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 158: /* $@20: %empty  */
#line 1416 "/build/zeek/src/zeek/src/parse.y"
                        { cur_decl_type_id = (yyvsp[-2].id); zeekygen_mgr->Redef((yyvsp[-2].id), ::filename, INIT_EXTRA); }
#line 4255 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 159: /* decl: TOK_REDEF TOK_RECORD global_id '$' TOK_ID $@20 TOK_ADD_TO '{' attr_list '}' ';'  */
#line 1418 "/build/zeek/src/zeek/src/parse.y"
                        {
			cur_decl_type_id = 0;
			parse_redef_record_field((yyvsp[-8].id), (yyvsp[-6].str), INIT_EXTRA, std::unique_ptr<std::vector<AttrPtr>>((yyvsp[-2].attr_l)));
			}
#line 4264 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 160: /* $@21: %empty  */
#line 1423 "/build/zeek/src/zeek/src/parse.y"
                        { cur_decl_type_id = (yyvsp[-2].id); zeekygen_mgr->Redef((yyvsp[-2].id), ::filename, INIT_REMOVE); }
#line 4270 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 161: /* decl: TOK_REDEF TOK_RECORD global_id '$' TOK_ID $@21 TOK_REMOVE_FROM '{' attr_list '}' ';'  */
#line 1425 "/build/zeek/src/zeek/src/parse.y"
                        {
			cur_decl_type_id = 0;
			parse_redef_record_field((yyvsp[-8].id), (yyvsp[-6].str), INIT_REMOVE, std::unique_ptr<std::vector<AttrPtr>>((yyvsp[-2].attr_l)));
			}
#line 4279 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 162: /* $@22: %empty  */
#line 1430 "/build/zeek/src/zeek/src/parse.y"
                        { cur_decl_type_id = (yyvsp[0].id); zeekygen_mgr->Redef((yyvsp[0].id), ::filename); }
#line 4285 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 163: /* $@23: %empty  */
#line 1432 "/build/zeek/src/zeek/src/parse.y"
                        { ++in_record; ++in_record_redef; }
#line 4291 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 164: /* $@24: %empty  */
#line 1434 "/build/zeek/src/zeek/src/parse.y"
                        { --in_record; --in_record_redef; }
#line 4297 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 165: /* decl: TOK_REDEF TOK_RECORD global_id $@22 TOK_ADD_TO '{' $@23 type_decl_list $@24 '}' opt_attr ';'  */
#line 1436 "/build/zeek/src/zeek/src/parse.y"
                        {
			cur_decl_type_id = 0;

			if ( ! (yyvsp[-9].id)->GetType() )
				(yyvsp[-9].id)->Error("unknown identifier");
			else
				extend_record((yyvsp[-9].id), std::unique_ptr<type_decl_list>((yyvsp[-4].type_decl_l)),
				              std::unique_ptr<std::vector<AttrPtr>>((yyvsp[-1].attr_l)));
			}
#line 4311 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 166: /* $@25: %empty  */
#line 1447 "/build/zeek/src/zeek/src/parse.y"
                        { cur_decl_type_id = (yyvsp[-1].id); zeekygen_mgr->StartType({NewRef{}, (yyvsp[-1].id)});  }
#line 4317 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 167: /* decl: TOK_TYPE def_global_id ':' $@25 type opt_attr ';'  */
#line 1449 "/build/zeek/src/zeek/src/parse.y"
                        {
			cur_decl_type_id = 0;
			IntrusivePtr id{AdoptRef{}, (yyvsp[-5].id)};
			add_type(id.get(), {AdoptRef{}, (yyvsp[-2].type)},
			         std::unique_ptr<std::vector<AttrPtr>>{(yyvsp[-1].attr_l)});
			zeekygen_mgr->Identifier(std::move(id));
			}
#line 4329 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 168: /* $@26: %empty  */
#line 1458 "/build/zeek/src/zeek/src/parse.y"
                        {
			func_hdr_location = (yylsp[0]);
			func_hdr_cond_epoch = conditional_epoch;
			}
#line 4338 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 173: /* conditional: TOK_ATIF '(' expr ')'  */
#line 1473 "/build/zeek/src/zeek/src/parse.y"
                        { do_atif((yyvsp[-1].expr)); }
#line 4344 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 174: /* conditional: TOK_ATIFDEF '(' TOK_ID ')'  */
#line 1475 "/build/zeek/src/zeek/src/parse.y"
                        { do_atifdef((yyvsp[-1].str)); }
#line 4350 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 175: /* conditional: TOK_ATIFNDEF '(' TOK_ID ')'  */
#line 1477 "/build/zeek/src/zeek/src/parse.y"
                        { do_atifndef((yyvsp[-1].str)); }
#line 4356 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 176: /* conditional: TOK_ATENDIF  */
#line 1479 "/build/zeek/src/zeek/src/parse.y"
                        { do_atendif(); }
#line 4362 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 177: /* conditional: TOK_ATELSE  */
#line 1481 "/build/zeek/src/zeek/src/parse.y"
                        { do_atelse(); }
#line 4368 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 178: /* func_hdr: TOK_FUNCTION def_global_id func_params opt_attr  */
#line 1486 "/build/zeek/src/zeek/src/parse.y"
                        {
			IntrusivePtr id{AdoptRef{}, (yyvsp[-2].id)};
			begin_func(id, current_module.c_str(),
				       FUNC_FLAVOR_FUNCTION, false, {NewRef{}, (yyvsp[-1].func_type)},
			           std::unique_ptr<std::vector<AttrPtr>>{(yyvsp[0].attr_l)});
			(yyval.func_type) = (yyvsp[-1].func_type);
			zeekygen_mgr->Identifier(std::move(id));
			}
#line 4381 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 179: /* func_hdr: TOK_EVENT event_id func_params opt_attr  */
#line 1495 "/build/zeek/src/zeek/src/parse.y"
                        {
			begin_func({NewRef{}, (yyvsp[-2].id)}, current_module.c_str(),
				       FUNC_FLAVOR_EVENT, false, {NewRef{}, (yyvsp[-1].func_type)},
			           std::unique_ptr<std::vector<AttrPtr>>{(yyvsp[0].attr_l)});
			(yyval.func_type) = (yyvsp[-1].func_type);
			}
#line 4392 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 180: /* func_hdr: TOK_HOOK def_global_id func_params opt_attr  */
#line 1502 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyvsp[-1].func_type)->ClearYieldType(FUNC_FLAVOR_HOOK);
			(yyvsp[-1].func_type)->SetYieldType(base_type(TYPE_BOOL));
			begin_func({NewRef{}, (yyvsp[-2].id)}, current_module.c_str(),
				       FUNC_FLAVOR_HOOK, false, {NewRef{}, (yyvsp[-1].func_type)},
			           std::unique_ptr<std::vector<AttrPtr>>{(yyvsp[0].attr_l)});
			(yyval.func_type) = (yyvsp[-1].func_type);
			}
#line 4405 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 181: /* func_hdr: TOK_REDEF TOK_EVENT event_id func_params opt_attr  */
#line 1511 "/build/zeek/src/zeek/src/parse.y"
                        {
			begin_func({NewRef{}, (yyvsp[-2].id)}, current_module.c_str(),
				       FUNC_FLAVOR_EVENT, true, {NewRef{}, (yyvsp[-1].func_type)},
			           std::unique_ptr<std::vector<AttrPtr>>{(yyvsp[0].attr_l)});
			(yyval.func_type) = (yyvsp[-1].func_type);
			}
#line 4416 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 182: /* $@27: %empty  */
#line 1521 "/build/zeek/src/zeek/src/parse.y"
                        {
			saved_in_init.push_back(in_init);
			in_init = 0;

			locals_at_this_scope.clear();
			out_of_scope_locals.clear();
			}
#line 4428 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 183: /* $@28: %empty  */
#line 1530 "/build/zeek/src/zeek/src/parse.y"
                        {
			in_init = saved_in_init.back();
			saved_in_init.pop_back();
			}
#line 4437 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 184: /* func_body: '{' $@27 stmt_list $@28 '}'  */
#line 1536 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location(func_hdr_location, (yylsp[0]));

			bool free_of_conditionals = true;
			if ( current_file_has_conditionals || conditional_epoch > func_hdr_cond_epoch )
				free_of_conditionals = false;

			end_func({AdoptRef{}, (yyvsp[-2].stmt)}, current_module.c_str(), free_of_conditionals);
			}
#line 4451 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 185: /* $@29: %empty  */
#line 1549 "/build/zeek/src/zeek/src/parse.y"
                        {
			saved_in_init.push_back(in_init);
			in_init = 0;
			}
#line 4460 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 186: /* $@30: %empty  */
#line 1555 "/build/zeek/src/zeek/src/parse.y"
                        {
			in_init = saved_in_init.back();
			saved_in_init.pop_back();
			}
#line 4469 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 187: /* lambda_body: '{' $@29 stmt_list $@30 '}'  */
#line 1561 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-4]), (yylsp[0]));

			// Code duplication here is sad but needed.
			// end_func actually instantiates the function
			// and associates it with an ID. We perform that
			// association later and need to return a lambda
			// expression.

			// Gather the ingredients for a Func from the
			// current scope.
			auto ingredients = std::make_shared<FunctionIngredients>(
				current_scope(), IntrusivePtr{AdoptRef{}, (yyvsp[-2].stmt)}, current_module.c_str());
			auto outer_ids = gather_outer_ids(pop_scope(), ingredients->Body());

			(yyval.expr) = new LambdaExpr(std::move(ingredients), std::move(outer_ids));
			}
#line 4491 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 188: /* $@31: %empty  */
#line 1582 "/build/zeek/src/zeek/src/parse.y"
                        {
			// "is_export" is used in some contexts to determine
			// whether a given newly seen identifier is a global.
			// We're about parse a lambda body, for which all of
			// the new identifiers should be locals, not globals,
			// so we need to turn off "is_export" here.  We use
			// a stack because lambdas can have additional lambdas
			// inside their bodies.
			hold_is_export.push_back(is_export);
			is_export = false;
			}
#line 4507 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 189: /* anonymous_function: TOK_FUNCTION $@31 begin_lambda conditional_list lambda_body  */
#line 1594 "/build/zeek/src/zeek/src/parse.y"
                        {
			is_export = hold_is_export.back();
			hold_is_export.pop_back();
			(yyval.expr) = (yyvsp[0].expr);
			}
#line 4517 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 190: /* begin_lambda: opt_captures func_params  */
#line 1603 "/build/zeek/src/zeek/src/parse.y"
                        {
			auto id = current_scope()->GenerateTemporary("anonymous-function");
			begin_func(id, current_module.c_str(), FUNC_FLAVOR_FUNCTION, false, {AdoptRef{}, (yyvsp[0].func_type)});

			std::optional<FuncType::CaptureList> captures;

			if ( (yyvsp[-1].captures) ) {
				captures = *(yyvsp[-1].captures);
				delete (yyvsp[-1].captures);
			}

			(yyvsp[0].func_type)->SetCaptures(std::move(captures));
			(yyval.id) = id.release();
			}
#line 4536 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 191: /* opt_captures: '[' capture_list ']'  */
#line 1621 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.captures) = (yyvsp[-1].captures); }
#line 4542 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 192: /* opt_captures: %empty  */
#line 1623 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.captures) = nullptr; }
#line 4548 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 193: /* capture_list: capture_list ',' capture  */
#line 1628 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyvsp[-2].captures)->push_back(*(yyvsp[0].capture));
			delete (yyvsp[0].capture);
			}
#line 4557 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 194: /* capture_list: capture  */
#line 1633 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.captures) = new zeek::FuncType::CaptureList;
			(yyval.captures)->push_back(*(yyvsp[0].capture));
			delete (yyvsp[0].capture);
			}
#line 4567 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 195: /* capture: opt_deep TOK_ID  */
#line 1642 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			auto id = lookup_ID((yyvsp[0].str), current_module.c_str());

			if ( ! id )
				reporter->Error("no such local identifier: %s", (yyvsp[0].str));
			else if ( id->IsType() ) {
				reporter->Error("cannot specify type in capture: %s", (yyvsp[0].str));
				id = nullptr;
			}
			else if ( id->IsGlobal() ) {
				reporter->Error("cannot specify global in capture: %s", (yyvsp[0].str));
				id = nullptr;
			}

			delete [] (yyvsp[0].str);

			(yyval.capture) = new FuncType::Capture(id, (yyvsp[-1].b));
			}
#line 4591 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 196: /* opt_deep: TOK_COPY  */
#line 1664 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.b) = true; }
#line 4597 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 197: /* opt_deep: %empty  */
#line 1666 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.b) = false; }
#line 4603 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 198: /* func_params: '(' formal_args ')' ':' type  */
#line 1671 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.func_type) = new FuncType({AdoptRef{}, (yyvsp[-3].record)}, {AdoptRef{}, (yyvsp[0].type)}, FUNC_FLAVOR_FUNCTION); }
#line 4609 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 199: /* func_params: '(' formal_args ')'  */
#line 1673 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.func_type) = new FuncType({AdoptRef{}, (yyvsp[-1].record)}, base_type(TYPE_VOID), FUNC_FLAVOR_FUNCTION); }
#line 4615 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 200: /* opt_type: ':' type  */
#line 1678 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.type) = (yyvsp[0].type); }
#line 4621 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 201: /* opt_type: %empty  */
#line 1680 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.type) = 0; }
#line 4627 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 202: /* init_class: %empty  */
#line 1684 "/build/zeek/src/zeek/src/parse.y"
                                { (yyval.ic) = INIT_NONE; }
#line 4633 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 203: /* init_class: '='  */
#line 1685 "/build/zeek/src/zeek/src/parse.y"
                                { (yyval.ic) = INIT_FULL; }
#line 4639 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 204: /* init_class: TOK_ADD_TO  */
#line 1686 "/build/zeek/src/zeek/src/parse.y"
                                { (yyval.ic) = INIT_EXTRA; }
#line 4645 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 205: /* init_class: TOK_REMOVE_FROM  */
#line 1687 "/build/zeek/src/zeek/src/parse.y"
                                { (yyval.ic) = INIT_REMOVE; }
#line 4651 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 206: /* $@32: %empty  */
#line 1691 "/build/zeek/src/zeek/src/parse.y"
                { ++in_init; }
#line 4657 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 207: /* $@33: %empty  */
#line 1691 "/build/zeek/src/zeek/src/parse.y"
                                   { --in_init; }
#line 4663 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 208: /* opt_init: $@32 rhs $@33  */
#line 1692 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.expr) = (yyvsp[-1].expr); }
#line 4669 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 209: /* opt_init: %empty  */
#line 1694 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.expr) = 0; }
#line 4675 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 210: /* index_slice: expr '[' opt_expr ':' opt_expr ']'  */
#line 1699 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-5]), (yylsp[0]));

			auto low = (yyvsp[-3].expr) ? ExprPtr{AdoptRef{}, (yyvsp[-3].expr)} :
			                make_intrusive<ConstExpr>(val_mgr->Count(0));

			auto high = (yyvsp[-1].expr) ? ExprPtr{AdoptRef{}, (yyvsp[-1].expr)} :
			                 make_intrusive<SizeExpr>(
			                     ExprPtr{NewRef{}, (yyvsp[-5].expr)});

			if ( ! IsIntegral(low->GetType()->Tag()) || ! IsIntegral(high->GetType()->Tag()) )
				reporter->Error("slice notation must have integral values as indexes");

			auto le = make_intrusive<ListExpr>(std::move(low));
			le->Append(std::move(high));

			if ( in_when_cond > 0  )
				(yyval.expr) = new IndexExprWhen({AdoptRef{}, (yyvsp[-5].expr)}, std::move(le), true);
			else
				(yyval.expr) = new IndexExpr({AdoptRef{}, (yyvsp[-5].expr)}, std::move(le), true);
			}
#line 4701 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 212: /* opt_attr: %empty  */
#line 1724 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr_l) = nullptr; }
#line 4707 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 213: /* attr_list: attr_list attr  */
#line 1729 "/build/zeek/src/zeek/src/parse.y"
                        { (yyvsp[-1].attr_l)->emplace_back(AdoptRef{}, (yyvsp[0].attr)); }
#line 4713 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 214: /* attr_list: attr  */
#line 1731 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.attr_l) = new std::vector<AttrPtr>;
			(yyval.attr_l)->emplace_back(AdoptRef{}, (yyvsp[0].attr));
			}
#line 4722 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 215: /* attr: TOK_ATTR_DEFAULT '=' expr  */
#line 1739 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_DEFAULT, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4728 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 216: /* attr: TOK_ATTR_DEFAULT_INSERT '=' expr  */
#line 1741 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_DEFAULT_INSERT, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4734 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 217: /* attr: TOK_ATTR_OPTIONAL  */
#line 1743 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_OPTIONAL); }
#line 4740 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 218: /* attr: TOK_ATTR_REDEF  */
#line 1745 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_REDEF); }
#line 4746 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 219: /* attr: TOK_ATTR_IS_ASSIGNED  */
#line 1747 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_IS_ASSIGNED); }
#line 4752 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 220: /* attr: TOK_ATTR_IS_USED  */
#line 1749 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_IS_USED); }
#line 4758 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 221: /* attr: TOK_ATTR_ADD_FUNC '=' expr  */
#line 1751 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_ADD_FUNC, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4764 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 222: /* attr: TOK_ATTR_DEL_FUNC '=' expr  */
#line 1753 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_DEL_FUNC, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4770 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 223: /* attr: TOK_ATTR_ON_CHANGE '=' expr  */
#line 1755 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_ON_CHANGE, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4776 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 224: /* attr: TOK_ATTR_BROKER_STORE '=' expr  */
#line 1757 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_BROKER_STORE, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4782 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 225: /* attr: TOK_ATTR_BROKER_STORE_ALLOW_COMPLEX  */
#line 1759 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_BROKER_STORE_ALLOW_COMPLEX); }
#line 4788 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 226: /* attr: TOK_ATTR_BACKEND '=' expr  */
#line 1761 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_BACKEND, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4794 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 227: /* attr: TOK_ATTR_EXPIRE_FUNC '=' expr  */
#line 1763 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_EXPIRE_FUNC, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4800 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 228: /* attr: TOK_ATTR_EXPIRE_CREATE '=' expr  */
#line 1765 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_EXPIRE_CREATE, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4806 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 229: /* attr: TOK_ATTR_EXPIRE_READ '=' expr  */
#line 1767 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_EXPIRE_READ, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4812 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 230: /* attr: TOK_ATTR_EXPIRE_WRITE '=' expr  */
#line 1769 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_EXPIRE_WRITE, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4818 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 231: /* attr: TOK_ATTR_RAW_OUTPUT  */
#line 1771 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_RAW_OUTPUT); }
#line 4824 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 232: /* attr: TOK_ATTR_PRIORITY '=' expr  */
#line 1773 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_PRIORITY, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4830 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 233: /* attr: TOK_ATTR_GROUP '=' expr  */
#line 1775 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_GROUP, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4836 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 234: /* attr: TOK_ATTR_TYPE_COLUMN '=' expr  */
#line 1777 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_TYPE_COLUMN, {AdoptRef{}, (yyvsp[0].expr)}); }
#line 4842 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 235: /* attr: TOK_ATTR_LOG  */
#line 1779 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_LOG); }
#line 4848 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 236: /* attr: TOK_ATTR_ERROR_HANDLER  */
#line 1781 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_ERROR_HANDLER); }
#line 4854 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 237: /* attr: TOK_ATTR_DEPRECATED  */
#line 1783 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_DEPRECATED); }
#line 4860 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 238: /* attr: TOK_ATTR_DEPRECATED '=' TOK_CONSTANT  */
#line 1785 "/build/zeek/src/zeek/src/parse.y"
                        {
			if ( IsString((yyvsp[0].val)->GetType()->Tag()) )
				(yyval.attr) = new Attr(
					ATTR_DEPRECATED,
					make_intrusive<ConstExpr>(IntrusivePtr{AdoptRef{}, (yyvsp[0].val)}));
			else {
				ODesc d;
				(yyvsp[0].val)->Describe(&d);
				Unref((yyvsp[0].val));
				reporter->Error("'&deprecated=%s' must use a string literal",
				                d.Description());
				(yyval.attr) = new Attr(ATTR_DEPRECATED);
				}
			}
#line 4879 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 239: /* attr: TOK_ATTR_ORDERED  */
#line 1800 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_ORDERED); }
#line 4885 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 240: /* attr: TOK_ATTR_NO_ZAM_OPT  */
#line 1802 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_NO_ZAM_OPT); }
#line 4891 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 241: /* attr: TOK_ATTR_NO_CPP_OPT  */
#line 1804 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.attr) = new Attr(ATTR_NO_CPP_OPT); }
#line 4897 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 242: /* $@34: %empty  */
#line 1809 "/build/zeek/src/zeek/src/parse.y"
                        {
			std::set<const ID*> id_set;
			locals_at_this_scope.emplace_back(id_set);
			}
#line 4906 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 243: /* stmt: '{' $@34 opt_no_test_block stmt_list '}'  */
#line 1814 "/build/zeek/src/zeek/src/parse.y"
                        {
			auto& scope_locals = locals_at_this_scope.back();
			out_of_scope_locals.insert(scope_locals.begin(), scope_locals.end());
			locals_at_this_scope.pop_back();

			set_location((yylsp[-4]), (yylsp[0]));
			(yyval.stmt) = (yyvsp[-1].stmt);
			if ( (yyvsp[-2].b) )
				script_coverage_mgr.DecIgnoreDepth();
			}
#line 4921 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 244: /* stmt: TOK_ASSERT expr opt_assert_msg ';'  */
#line 1826 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.stmt) = new AssertStmt(IntrusivePtr{AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[-1].expr)});
			}
#line 4929 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 245: /* stmt: TOK_PRINT expr_list ';' opt_no_test  */
#line 1831 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[-1]));
			(yyval.stmt) = new PrintStmt(IntrusivePtr{AdoptRef{}, (yyvsp[-2].list)});
			if ( ! (yyvsp[0].b) )
				script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 4940 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 246: /* stmt: TOK_EVENT event ';' opt_no_test  */
#line 1839 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[-1]));
			(yyval.stmt) = new EventStmt({AdoptRef{}, (yyvsp[-2].event_expr)});
			if ( ! (yyvsp[0].b) )
				script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 4951 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 247: /* stmt: TOK_IF '(' expr ')' stmt  */
#line 1847 "/build/zeek/src/zeek/src/parse.y"
                        {
			reject_directive((yyvsp[0].stmt));
			set_location((yylsp[-4]), (yylsp[-1]));
			if ( g_policy_debug )
				(yyval.stmt) = new DebugIfStmt({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].stmt)}, make_intrusive<NullStmt>());
			else
				(yyval.stmt) = new IfStmt({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].stmt)}, make_intrusive<NullStmt>());
			script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 4965 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 248: /* stmt: TOK_IF '(' expr ')' stmt TOK_ELSE stmt  */
#line 1858 "/build/zeek/src/zeek/src/parse.y"
                        {
			reject_directive((yyvsp[-2].stmt));
			reject_directive((yyvsp[0].stmt));
			set_location((yylsp[-6]), (yylsp[-3]));
			if ( g_policy_debug )
				(yyval.stmt) = new DebugIfStmt({AdoptRef{}, (yyvsp[-4].expr)}, {AdoptRef{}, (yyvsp[-2].stmt)}, {AdoptRef{}, (yyvsp[0].stmt)});
			else
				(yyval.stmt) = new IfStmt({AdoptRef{}, (yyvsp[-4].expr)}, {AdoptRef{}, (yyvsp[-2].stmt)}, {AdoptRef{}, (yyvsp[0].stmt)});
			script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 4980 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 249: /* stmt: TOK_SWITCH expr '{' case_list '}'  */
#line 1870 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-4]), (yylsp[-3]));
			(yyval.stmt) = new SwitchStmt({AdoptRef{}, (yyvsp[-3].expr)}, (yyvsp[-1].case_l));
			script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 4990 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 250: /* stmt: for_head stmt  */
#line 1877 "/build/zeek/src/zeek/src/parse.y"
                        {
			reject_directive((yyvsp[0].stmt));
			(yyvsp[-1].stmt)->AsForStmt()->AddBody({AdoptRef{}, (yyvsp[0].stmt)});
			script_coverage_mgr.AddStmt((yyvsp[-1].stmt));
			}
#line 5000 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 251: /* stmt: TOK_WHILE '(' expr ')' stmt  */
#line 1884 "/build/zeek/src/zeek/src/parse.y"
                        {
			reject_directive((yyvsp[0].stmt));
			(yyval.stmt) = new WhileStmt({AdoptRef{}, (yyvsp[-2].expr)}, {AdoptRef{}, (yyvsp[0].stmt)});
			script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 5010 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 252: /* stmt: TOK_NEXT ';' opt_no_test  */
#line 1891 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[-1]));
			(yyval.stmt) = new NextStmt;
			if ( ! (yyvsp[0].b) )
				script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 5021 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 253: /* stmt: TOK_BREAK ';' opt_no_test  */
#line 1899 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[-1]));
			(yyval.stmt) = new BreakStmt;
			if ( ! (yyvsp[0].b) )
				script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 5032 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 254: /* stmt: TOK_FALLTHROUGH ';' opt_no_test  */
#line 1907 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[-1]));
			(yyval.stmt) = new FallthroughStmt;
			if ( ! (yyvsp[0].b) )
				script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 5043 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 255: /* stmt: TOK_RETURN ';' opt_no_test  */
#line 1915 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[-1]));
			(yyval.stmt) = new ReturnStmt(0);
			if ( ! (yyvsp[0].b) )
				script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 5054 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 256: /* stmt: TOK_RETURN expr ';' opt_no_test  */
#line 1923 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[-2]));
			(yyval.stmt) = new ReturnStmt({AdoptRef{}, (yyvsp[-2].expr)});
			if ( ! (yyvsp[0].b) )
				script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 5065 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 257: /* stmt: TOK_LOCAL local_id opt_type init_class opt_init opt_attr ';' opt_no_test  */
#line 1931 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-7]), (yylsp[-1]));
			if ( ! locals_at_this_scope.empty() )
				   locals_at_this_scope.back().insert((yyvsp[-6].id));
			(yyval.stmt) = build_local((yyvsp[-6].id), (yyvsp[-5].type), (yyvsp[-4].ic), (yyvsp[-3].expr), (yyvsp[-2].attr_l), VAR_REGULAR, ! (yyvsp[0].b)).release();
			}
#line 5076 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 258: /* stmt: TOK_CONST local_id opt_type init_class opt_init opt_attr ';' opt_no_test  */
#line 1939 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-7]), (yylsp[-2]));

			(yyval.stmt) = build_local((yyvsp[-6].id), (yyvsp[-5].type), (yyvsp[-4].ic), (yyvsp[-3].expr), (yyvsp[-2].attr_l), VAR_CONST, ! (yyvsp[0].b)).release();
			}
#line 5086 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 259: /* stmt: when_clause  */
#line 1946 "/build/zeek/src/zeek/src/parse.y"
                        {
			std::shared_ptr<WhenInfo> wi((yyvsp[0].when_clause));
			(yyval.stmt) = new WhenStmt(std::move(wi));
			script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 5096 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 260: /* stmt: index_slice '=' expr ';' opt_no_test  */
#line 1953 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-4]), (yylsp[-1]));
			(yyval.stmt) = new ExprStmt(get_assign_expr({AdoptRef{}, (yyvsp[-4].expr)},
			                                  {AdoptRef{}, (yyvsp[-2].expr)}, in_init));

			if ( ! (yyvsp[0].b) )
				script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 5109 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 261: /* stmt: expr ';' opt_no_test  */
#line 1963 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-2]), (yylsp[-1]));
			(yyval.stmt) = new ExprStmt({AdoptRef{}, (yyvsp[-2].expr)});
			if ( ! (yyvsp[0].b) )
				script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 5120 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 262: /* stmt: ';'  */
#line 1971 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]), (yylsp[0]));
			(yyval.stmt) = new NullStmt;
			script_coverage_mgr.AddStmt((yyval.stmt));
			}
#line 5130 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 263: /* stmt: conditional  */
#line 1978 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.stmt) = new NullStmt(true /* is_directive */); }
#line 5136 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 264: /* stmt_list: stmt_list stmt  */
#line 1983 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-1]), (yylsp[0]));
			(yyvsp[-1].stmt)->AsStmtList()->Stmts().push_back({AdoptRef{}, (yyvsp[0].stmt)});
			(yyvsp[-1].stmt)->UpdateLocationEndInfo((yylsp[0]));
			}
#line 5146 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 265: /* stmt_list: %empty  */
#line 1989 "/build/zeek/src/zeek/src/parse.y"
                        {
			if ( g_policy_debug )
				(yyval.stmt) = new DebugStmtList();
			else
				(yyval.stmt) = new StmtList();
			}
#line 5157 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 266: /* event: lookup_identifier '(' opt_expr_list ')'  */
#line 1999 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-3]), (yylsp[0]));
			const auto& id = lookup_ID((yyvsp[-3].str), current_module.c_str());

			if ( id ) {
				if ( ! id->IsGlobal() ) {
					yyerror(util::fmt("local identifier \"%s\" cannot be used to reference an event", (yyvsp[-3].str)));
					YYERROR;
				}

				if ( id->IsDeprecated() )
					reporter->Deprecation(id->GetDeprecationWarning());

				(yyval.event_expr) = new EventExpr(id->Name(), {AdoptRef{}, (yyvsp[-1].list)});
			}
			else {
				(yyval.event_expr) = new EventExpr((yyvsp[-3].str), {AdoptRef{}, (yyvsp[-1].list)});
				}
			}
#line 5181 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 267: /* case_list: case_list case  */
#line 2022 "/build/zeek/src/zeek/src/parse.y"
                        { (yyvsp[-1].case_l)->push_back((yyvsp[0].c_case)); }
#line 5187 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 268: /* case_list: %empty  */
#line 2024 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.case_l) = new case_list; }
#line 5193 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 269: /* case: TOK_CASE expr_list ':' stmt_list  */
#line 2029 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.c_case) = new Case({AdoptRef{}, (yyvsp[-2].list)}, nullptr, {AdoptRef{}, (yyvsp[0].stmt)}); }
#line 5199 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 270: /* case: TOK_CASE case_type_list ':' stmt_list  */
#line 2032 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.c_case) = new Case(nullptr, (yyvsp[-2].id_l), {AdoptRef{}, (yyvsp[0].stmt)}); }
#line 5205 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 271: /* case: TOK_DEFAULT ':' stmt_list  */
#line 2035 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.c_case) = new Case(nullptr, nullptr, {AdoptRef{}, (yyvsp[0].stmt)}); }
#line 5211 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 272: /* case_type_list: case_type_list ',' case_type  */
#line 2040 "/build/zeek/src/zeek/src/parse.y"
                        { (yyvsp[-2].id_l)->push_back({AdoptRef{}, (yyvsp[0].id)}); }
#line 5217 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 273: /* case_type_list: case_type  */
#line 2043 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.id_l) = new IDPList;
			(yyval.id_l)->push_back({AdoptRef{}, (yyvsp[0].id)});
			}
#line 5226 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 274: /* case_type: TOK_TYPE type  */
#line 2051 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.id) = new ID(0, SCOPE_FUNCTION, false);
			(yyval.id)->SetType({AdoptRef{}, (yyvsp[0].type)});
			}
#line 5235 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 275: /* case_type: TOK_TYPE type TOK_AS TOK_ID  */
#line 2057 "/build/zeek/src/zeek/src/parse.y"
                        {
			const char* name = (yyvsp[0].str);
			TypePtr type{AdoptRef{}, (yyvsp[-2].type)};
			auto case_var = lookup_ID(name, current_module.c_str());

			if ( case_var && case_var->IsGlobal() )
				case_var->Error("already a global identifier");
			else
				case_var = install_ID(name, current_module.c_str(), false, false);

			add_local(case_var, std::move(type), INIT_NONE, nullptr, nullptr, VAR_REGULAR);
			(yyval.id) = case_var.release();
			}
#line 5253 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 276: /* for_head: TOK_FOR '(' TOK_ID TOK_IN expr ')'  */
#line 2073 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-5]), (yylsp[0]));

			// This rule needs to be separate from the loop
			// body so that we execute these actions - defining
			// the local variable - prior to parsing the body,
			// which might refer to the variable.
			auto loop_var = lookup_ID((yyvsp[-3].str), current_module.c_str());

			if ( loop_var )
				check_loop_var(loop_var);
			else {
				loop_var = install_ID((yyvsp[-3].str), current_module.c_str(), false, false);
			}

			auto* loop_vars = new IDPList;
			loop_vars->push_back(loop_var);

			(yyval.stmt) = new ForStmt(loop_vars, {AdoptRef{}, (yyvsp[-1].expr)});
			}
#line 5278 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 277: /* for_head: TOK_FOR '(' '[' local_id_list ']' TOK_IN expr ')'  */
#line 2095 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.stmt) = new ForStmt((yyvsp[-4].id_l), {AdoptRef{}, (yyvsp[-1].expr)});
			}
#line 5286 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 278: /* for_head: TOK_FOR '(' TOK_ID ',' TOK_ID TOK_IN expr ')'  */
#line 2100 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-7]), (yylsp[0]));
			const char* module = current_module.c_str();

			// Check for previous definitions of key and
			// value variables.
			auto key_var = lookup_ID((yyvsp[-5].str), module);
			auto val_var = lookup_ID((yyvsp[-3].str), module);

			// Validate previous definitions as needed.
			if ( key_var )
				check_loop_var(key_var);
			else
				key_var = install_ID((yyvsp[-5].str), module, false, false);

			if ( val_var )
				check_loop_var(val_var);
			else
				val_var = install_ID((yyvsp[-3].str), module, false, false);

			auto* loop_vars = new IDPList;
			loop_vars->push_back(key_var);

			(yyval.stmt) = new ForStmt(loop_vars, {AdoptRef{}, (yyvsp[-1].expr)}, std::move(val_var));
			}
#line 5316 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 279: /* for_head: TOK_FOR '(' '[' local_id_list ']' ',' TOK_ID TOK_IN expr ')'  */
#line 2127 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[-9]), (yylsp[0]));
			const char* module = current_module.c_str();

			// Validate value variable
			auto val_var = lookup_ID((yyvsp[-3].str), module);

			if ( val_var )
				check_loop_var(val_var);
			else
				val_var = install_ID((yyvsp[-3].str), module, false, false);

			(yyval.stmt) = new ForStmt((yyvsp[-6].id_l), {AdoptRef{}, (yyvsp[-1].expr)}, std::move(val_var));
			}
#line 5335 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 280: /* local_id_list: local_id_list ',' local_id  */
#line 2145 "/build/zeek/src/zeek/src/parse.y"
                        { (yyvsp[-2].id_l)->push_back({AdoptRef{}, (yyvsp[0].id)}); }
#line 5341 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 281: /* local_id_list: local_id  */
#line 2147 "/build/zeek/src/zeek/src/parse.y"
                        {
			(yyval.id_l) = new IDPList;
			(yyval.id_l)->push_back({AdoptRef{}, (yyvsp[0].id)});
			}
#line 5350 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 282: /* local_id: TOK_ID  */
#line 2155 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			auto id = lookup_ID((yyvsp[0].str), current_module.c_str());
			(yyval.id) = id.release();

			if ( (yyval.id) ) {
				if ( (yyval.id)->IsGlobal() && ! (yyval.id)->IsBlank() )
					(yyval.id)->Error("already a global identifier");

				if ( (yyval.id)->IsConst() && ! (yyval.id)->IsBlank() )
 					(yyval.id)->Error("already a const identifier");

				delete [] (yyvsp[0].str);
			}
			else {
				(yyval.id) = install_ID((yyvsp[0].str), current_module.c_str(), false, false).release();
				}
			}
#line 5373 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 283: /* $@35: %empty  */
#line 2176 "/build/zeek/src/zeek/src/parse.y"
        { resolving_global_ID = true; }
#line 5379 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 284: /* global_id: $@35 global_or_event_id  */
#line 2177 "/build/zeek/src/zeek/src/parse.y"
                { (yyval.id) = (yyvsp[0].id); }
#line 5385 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 285: /* $@36: %empty  */
#line 2181 "/build/zeek/src/zeek/src/parse.y"
        { defining_global_ID = true; }
#line 5391 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 286: /* $@37: %empty  */
#line 2181 "/build/zeek/src/zeek/src/parse.y"
                                                 { defining_global_ID = false; }
#line 5397 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 287: /* def_global_id: $@36 global_id $@37  */
#line 2182 "/build/zeek/src/zeek/src/parse.y"
                { (yyval.id) = (yyvsp[-1].id); }
#line 5403 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 288: /* $@38: %empty  */
#line 2186 "/build/zeek/src/zeek/src/parse.y"
        { resolving_global_ID = false; }
#line 5409 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 289: /* event_id: $@38 global_or_event_id  */
#line 2187 "/build/zeek/src/zeek/src/parse.y"
                { (yyval.id) = (yyvsp[0].id); }
#line 5415 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 290: /* global_or_event_id: lookup_identifier  */
#line 2192 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			auto id = lookup_ID((yyvsp[0].str), current_module.c_str(), false,
			                    defining_global_ID);
			(yyval.id) = id.release();

			if ( (yyval.id) ) {
				if ( ! (yyval.id)->IsGlobal() )
					(yyval.id)->Error("already a local identifier");

				if ( (yyval.id)->IsDeprecated() ) {
					const auto& t = (yyval.id)->GetType();

					if ( t->Tag() != TYPE_FUNC ||
					     t->AsFuncType()->Flavor() != FUNC_FLAVOR_FUNCTION )
						reporter->Deprecation((yyval.id)->GetDeprecationWarning());
				}

				refine_location((yyval.id));
				delete [] (yyvsp[0].str);
			}
			else {
				const char* module_name =
					resolving_global_ID ?
						current_module.c_str() : nullptr;

				(yyval.id) = install_ID((yyvsp[0].str), module_name, true, is_export).release();
				}
			}
#line 5449 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 291: /* resolve_id: lookup_identifier  */
#line 2226 "/build/zeek/src/zeek/src/parse.y"
                        {
			set_location((yylsp[0]));
			auto id = lookup_ID((yyvsp[0].str), current_module.c_str());
			(yyval.id) = id.release();

			if ( ! (yyval.id) )
				reporter->Error("identifier not defined: %s", (yyvsp[0].str));

			delete [] (yyvsp[0].str);
			}
#line 5464 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 293: /* lookup_identifier: TOK_GLOBAL_ID  */
#line 2242 "/build/zeek/src/zeek/src/parse.y"
                        {
			if ( is_export ) {
				reporter->Error("cannot use :: prefix in export section: %s", (yyvsp[0].str));
				YYERROR;
			}
			}
#line 5475 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 294: /* opt_assert_msg: ',' expr  */
#line 2253 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.expr) = (yyvsp[0].expr); }
#line 5481 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 295: /* opt_assert_msg: %empty  */
#line 2255 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.expr) = nullptr; }
#line 5487 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 296: /* opt_no_test: TOK_NO_TEST  */
#line 2260 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.b) = true; }
#line 5493 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 297: /* opt_no_test: %empty  */
#line 2262 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.b) = false; }
#line 5499 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 298: /* opt_no_test_block: TOK_NO_TEST  */
#line 2267 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.b) = true; script_coverage_mgr.IncIgnoreDepth(); }
#line 5505 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 299: /* opt_no_test_block: %empty  */
#line 2269 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.b) = false; }
#line 5511 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 300: /* opt_deprecated: TOK_ATTR_DEPRECATED  */
#line 2274 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.expr) = new ConstExpr(make_intrusive<StringVal>("")); }
#line 5517 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 301: /* opt_deprecated: TOK_ATTR_DEPRECATED '=' TOK_CONSTANT  */
#line 2277 "/build/zeek/src/zeek/src/parse.y"
                        {
			if ( IsString((yyvsp[0].val)->GetType()->Tag()) )
				(yyval.expr) = new ConstExpr({AdoptRef{}, (yyvsp[0].val)});
			else {
				ODesc d;
				(yyvsp[0].val)->Describe(&d);
				reporter->Error("'&deprecated=%s' must use a string literal",
				                d.Description());
				(yyval.expr) = new ConstExpr(make_intrusive<StringVal>(""));
				}
			}
#line 5533 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 302: /* opt_deprecated: %empty  */
#line 2289 "/build/zeek/src/zeek/src/parse.y"
                        { (yyval.expr) = nullptr; }
#line 5539 "/build/zeek/src/zeek/build/src/p.cc"
    break;

  case 303: /* expr_list_opt_comma: ','  */
#line 2292 "/build/zeek/src/zeek/src/parse.y"
                         { expr_list_has_opt_comma = 1; }
#line 5545 "/build/zeek/src/zeek/build/src/p.cc"
    break;


#line 5549 "/build/zeek/src/zeek/build/src/p.cc"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 2296 "/build/zeek/src/zeek/src/parse.y"


int yyerror(const char msg[]) {
    if ( in_debug )
        g_curr_debug_error = util::copy_string(msg);

    if ( last_tok[0] == '\n' )
        reporter->Error("%s, on previous line", msg);
    else if ( last_tok[0] == '\0' ) {
        if ( last_filename )
            reporter->Error("%s, at end of file %s", msg, last_filename);
        else
            reporter->Error("%s, at end of file", msg);
    }
    else {
        if ( last_last_tok_filename && last_tok_filename && ! util::streq(last_last_tok_filename, last_tok_filename) )
            reporter->Error("%s, at or near \"%s\" or end of file %s", msg, last_tok, last_last_tok_filename);
        else
            reporter->Error("%s, at or near \"%s\"", msg, last_tok);
    }

    return 0;
}
